/*
  Copyright 2021 Grégory Soutadé

  This file is part of libgourou.

  libgourou is free software: you can redistribute it and/or modify
  it under the terms of the GNU Lesser General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  libgourou is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public License
  along with libgourou. If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _FULFILLMENT_ITEM_H_
#define _FULFILLMENT_ITEM_H_

#include "loan_token.h"

#include <pugixml.hpp>

namespace gourou
{
    class User;

    /**
     * @brief This class is a container for a fulfillment object
     */
    class FulfillmentItem
    {
    public:
	/**
	 * @brief Main constructor. Not to be called by user
	 *
	 * @param doc   Fulfill reply
	 * @param user  User pointer
	 */
	FulfillmentItem(pugi::xml_document& doc, User* user);

	~FulfillmentItem();

	/**
	 * @brief Return metadata value from ACSM metadata section
	 *
	 * @param name  Name of key to return
	 */
	std::string getMetadata(std::string name);

	/**
	 * @brief Return rights generated by ACS server (XML format)
	 */
	std::string getRights();

	/**
	 * @brief Return epub download URL
	 */
	std::string getDownloadURL();

	/**
	 * @brief Return resource value
	 */
	std::string getResource();

	/**
	 * @brief Return loan token if there is one
	 */
	LoanToken* getLoanToken();

    private:
	pugi::xml_document fulfillDoc;
	pugi::xml_node metadatas;
	pugi::xml_document rights;
	std::string downloadURL;
	std::string resource;
	LoanToken* loanToken;
	
	void buildRights(const pugi::xml_node& licenseToken, User* user);
    };
}

#endif
