// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2023 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package api

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
)

var (
	// SwaggerJSON embedded version of the swagger document used at generation time
	SwaggerJSON json.RawMessage
	// FlatSwaggerJSON embedded flattened version of the swagger document used at generation time
	FlatSwaggerJSON json.RawMessage
)

func init() {
	SwaggerJSON = json.RawMessage([]byte(`{
  "consumes": [
    "application/json"
  ],
  "produces": [
    "application/json"
  ],
  "schemes": [
    "http",
    "ws"
  ],
  "swagger": "2.0",
  "info": {
    "title": "MinIO Console Server",
    "version": "0.1.0"
  },
  "basePath": "/api/v1",
  "paths": {
    "/account/change-password": {
      "post": {
        "tags": [
          "Account"
        ],
        "summary": "Change password of currently logged in user.",
        "operationId": "AccountChangePassword",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/accountChangePasswordRequest"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful login."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/account/change-user-password": {
      "post": {
        "tags": [
          "Account"
        ],
        "summary": "Change password of currently logged in user.",
        "operationId": "ChangeUserPassword",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/changeUserPasswordRequest"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Password successfully changed."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/admin/arns": {
      "get": {
        "tags": [
          "System"
        ],
        "summary": "Returns a list of active ARNs in the instance",
        "operationId": "ArnList",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/arnsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/admin/info": {
      "get": {
        "tags": [
          "System"
        ],
        "summary": "Returns information about the deployment",
        "operationId": "AdminInfo",
        "parameters": [
          {
            "type": "boolean",
            "default": false,
            "name": "defaultOnly",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/adminInfoResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/admin/info/widgets/{widgetId}": {
      "get": {
        "tags": [
          "System"
        ],
        "summary": "Returns information about the deployment",
        "operationId": "DashboardWidgetDetails",
        "parameters": [
          {
            "type": "integer",
            "format": "int32",
            "name": "widgetId",
            "in": "path",
            "required": true
          },
          {
            "type": "integer",
            "name": "start",
            "in": "query"
          },
          {
            "type": "integer",
            "name": "end",
            "in": "query"
          },
          {
            "type": "integer",
            "format": "int32",
            "name": "step",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/widgetDetails"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/admin/inspect": {
      "get": {
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "Inspect"
        ],
        "summary": "Inspect Files on Drive",
        "operationId": "Inspect",
        "parameters": [
          {
            "type": "string",
            "name": "file",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "name": "volume",
            "in": "query",
            "required": true
          },
          {
            "type": "boolean",
            "name": "encrypt",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "file"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/admin/notification_endpoints": {
      "get": {
        "tags": [
          "Configuration"
        ],
        "summary": "Returns a list of active notification endpoints",
        "operationId": "NotificationEndpointList",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/notifEndpointResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Configuration"
        ],
        "summary": "Allows to configure a new notification endpoint",
        "operationId": "AddNotificationEndpoint",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/notificationEndpoint"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/setNotificationEndpointResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/admin/site-replication": {
      "get": {
        "tags": [
          "SiteReplication"
        ],
        "summary": "Get list of Replication Sites",
        "operationId": "GetSiteReplicationInfo",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/siteReplicationInfoResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "put": {
        "tags": [
          "SiteReplication"
        ],
        "summary": "Edit a Replication Site",
        "operationId": "SiteReplicationEdit",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/peerInfo"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/peerSiteEditResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "tags": [
          "SiteReplication"
        ],
        "summary": "Add a Replication Site",
        "operationId": "SiteReplicationInfoAdd",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/siteReplicationAddRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/siteReplicationAddResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "SiteReplication"
        ],
        "summary": "Remove a Replication Site",
        "operationId": "SiteReplicationRemove",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/peerInfoRemove"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/peerSiteRemoveResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/admin/site-replication/status": {
      "get": {
        "tags": [
          "SiteReplication"
        ],
        "summary": "Display overall site replication status",
        "operationId": "GetSiteReplicationStatus",
        "parameters": [
          {
            "type": "boolean",
            "default": true,
            "description": "Include Bucket stats",
            "name": "buckets",
            "in": "query"
          },
          {
            "type": "boolean",
            "default": true,
            "description": "Include Group stats",
            "name": "groups",
            "in": "query"
          },
          {
            "type": "boolean",
            "default": true,
            "description": "Include Policies stats",
            "name": "policies",
            "in": "query"
          },
          {
            "type": "boolean",
            "default": true,
            "description": "Include Policies stats",
            "name": "users",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Entity Type to lookup",
            "name": "entityType",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Entity Value to lookup",
            "name": "entityValue",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/siteReplicationStatusResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/admin/tiers": {
      "get": {
        "tags": [
          "Tiering"
        ],
        "summary": "Returns a list of tiers for ilm",
        "operationId": "TiersList",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/tierListResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Tiering"
        ],
        "summary": "Allows to configure a new tier",
        "operationId": "AddTier",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/tier"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/admin/tiers/{type}/{name}": {
      "get": {
        "tags": [
          "Tiering"
        ],
        "summary": "Get Tier",
        "operationId": "GetTier",
        "parameters": [
          {
            "enum": [
              "s3",
              "gcs",
              "azure",
              "minio"
            ],
            "type": "string",
            "name": "type",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/tier"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/admin/tiers/{type}/{name}/credentials": {
      "put": {
        "tags": [
          "Tiering"
        ],
        "summary": "Edit Tier Credentials",
        "operationId": "EditTierCredentials",
        "parameters": [
          {
            "enum": [
              "s3",
              "gcs",
              "azure",
              "minio"
            ],
            "type": "string",
            "name": "type",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/tierCredentialsRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/bucket-policy/{bucket}": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "List Policies With Given Bucket",
        "operationId": "ListPoliciesWithBucket",
        "parameters": [
          {
            "type": "string",
            "name": "bucket",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/offset"
          },
          {
            "$ref": "#/parameters/limit"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listPoliciesResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/bucket-users/{bucket}": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "List Users With Access to a Given Bucket",
        "operationId": "ListUsersWithAccessToBucket",
        "parameters": [
          {
            "type": "string",
            "name": "bucket",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/offset"
          },
          {
            "$ref": "#/parameters/limit"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/bucket/{bucket}/access-rules": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "List Access Rules With Given Bucket",
        "operationId": "ListAccessRulesWithBucket",
        "parameters": [
          {
            "type": "string",
            "name": "bucket",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/offset"
          },
          {
            "$ref": "#/parameters/limit"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listAccessRulesResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Bucket"
        ],
        "summary": "Add Access Rule To Given Bucket",
        "operationId": "SetAccessRuleWithBucket",
        "parameters": [
          {
            "type": "string",
            "name": "bucket",
            "in": "path",
            "required": true
          },
          {
            "name": "prefixaccess",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/prefixAccessPair"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "boolean"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Bucket"
        ],
        "summary": "Delete Access Rule From Given Bucket",
        "operationId": "DeleteAccessRuleWithBucket",
        "parameters": [
          {
            "type": "string",
            "name": "bucket",
            "in": "path",
            "required": true
          },
          {
            "name": "prefix",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/prefixWrapper"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "boolean"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "List Buckets",
        "operationId": "ListBuckets",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listBucketsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Bucket"
        ],
        "summary": "Make bucket",
        "operationId": "MakeBucket",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/makeBucketRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/makeBucketsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets-replication": {
      "post": {
        "tags": [
          "Bucket"
        ],
        "summary": "Sets Multi Bucket Replication in multiple Buckets",
        "operationId": "SetMultiBucketReplication",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/multiBucketReplication"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/multiBucketResponseState"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/max-share-exp": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "Get max expiration time for share link in seconds",
        "operationId": "GetMaxShareLinkExp",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/maxShareLinkExpResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/multi-lifecycle": {
      "post": {
        "tags": [
          "Bucket"
        ],
        "summary": "Add Multi Bucket Lifecycle",
        "operationId": "AddMultiBucketLifecycle",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/addMultiBucketLifecycle"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/multiLifecycleResult"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/delete-all-replication-rules": {
      "delete": {
        "tags": [
          "Bucket"
        ],
        "summary": "Deletes all replication rules from a bucket",
        "operationId": "DeleteAllReplicationRules",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/delete-objects": {
      "post": {
        "tags": [
          "Object"
        ],
        "summary": "Delete Multiple Objects",
        "operationId": "DeleteMultipleObjects",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "name": "all_versions",
            "in": "query"
          },
          {
            "type": "boolean",
            "name": "bypass",
            "in": "query"
          },
          {
            "name": "files",
            "in": "body",
            "required": true,
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/deleteFile"
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/delete-selected-replication-rules": {
      "delete": {
        "tags": [
          "Bucket"
        ],
        "summary": "Deletes selected replication rules from a bucket",
        "operationId": "DeleteSelectedReplicationRules",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "name": "rules",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/bucketReplicationRuleList"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/encryption/disable": {
      "post": {
        "tags": [
          "Bucket"
        ],
        "summary": "Disable bucket encryption.",
        "operationId": "DisableBucketEncryption",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/encryption/enable": {
      "post": {
        "tags": [
          "Bucket"
        ],
        "summary": "Enable bucket encryption.",
        "operationId": "EnableBucketEncryption",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/bucketEncryptionRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/encryption/info": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "Get bucket encryption information.",
        "operationId": "GetBucketEncryptionInfo",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/bucketEncryptionInfo"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/events": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "List Bucket Events",
        "operationId": "ListBucketEvents",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/offset"
          },
          {
            "$ref": "#/parameters/limit"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listBucketEventsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Bucket"
        ],
        "summary": "Create Bucket Event",
        "operationId": "CreateBucketEvent",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/bucketEventRequest"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/events/{arn}": {
      "delete": {
        "tags": [
          "Bucket"
        ],
        "summary": "Delete Bucket Event",
        "operationId": "DeleteBucketEvent",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "arn",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/notificationDeleteRequest"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/lifecycle": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "Bucket Lifecycle",
        "operationId": "GetBucketLifecycle",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/bucketLifecycleResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Bucket"
        ],
        "summary": "Add Bucket Lifecycle",
        "operationId": "AddBucketLifecycle",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/addBucketLifecycle"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/lifecycle/{lifecycle_id}": {
      "put": {
        "tags": [
          "Bucket"
        ],
        "summary": "Update Lifecycle rule",
        "operationId": "UpdateBucketLifecycle",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "lifecycle_id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/updateBucketLifecycle"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Bucket"
        ],
        "summary": "Delete Lifecycle rule",
        "operationId": "DeleteBucketLifecycleRule",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "lifecycle_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/object-locking": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "Returns the status of object locking support on the bucket",
        "operationId": "GetBucketObjectLockingStatus",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/bucketObLockingResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/objects": {
      "get": {
        "security": [
          {
            "key": []
          },
          {
            "anonymous": []
          }
        ],
        "tags": [
          "Object"
        ],
        "summary": "List Objects",
        "operationId": "ListObjects",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "prefix",
            "in": "query"
          },
          {
            "type": "boolean",
            "name": "recursive",
            "in": "query"
          },
          {
            "type": "boolean",
            "name": "with_versions",
            "in": "query"
          },
          {
            "type": "boolean",
            "name": "with_metadata",
            "in": "query"
          },
          {
            "$ref": "#/parameters/limit"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listObjectsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Object"
        ],
        "summary": "Delete Object",
        "operationId": "DeleteObject",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "prefix",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "name": "version_id",
            "in": "query"
          },
          {
            "type": "boolean",
            "name": "recursive",
            "in": "query"
          },
          {
            "type": "boolean",
            "name": "all_versions",
            "in": "query"
          },
          {
            "type": "boolean",
            "name": "non_current_versions",
            "in": "query"
          },
          {
            "type": "boolean",
            "name": "bypass",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/objects/download": {
      "get": {
        "security": [
          {
            "key": []
          },
          {
            "anonymous": []
          }
        ],
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "Object"
        ],
        "summary": "Download Object",
        "operationId": "Download Object",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "prefix",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "name": "version_id",
            "in": "query"
          },
          {
            "type": "boolean",
            "default": false,
            "name": "preview",
            "in": "query"
          },
          {
            "type": "string",
            "default": "",
            "name": "override_file_name",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "file"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/objects/download-multiple": {
      "post": {
        "security": [
          {
            "key": []
          },
          {
            "anonymous": []
          }
        ],
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "Object"
        ],
        "summary": "Download Multiple Objects",
        "operationId": "DownloadMultipleObjects",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "name": "objectList",
            "in": "body",
            "required": true,
            "schema": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "file"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/objects/legalhold": {
      "put": {
        "tags": [
          "Object"
        ],
        "summary": "Put Object's legalhold status",
        "operationId": "PutObjectLegalHold",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "prefix",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "name": "version_id",
            "in": "query",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/putObjectLegalHoldRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/objects/metadata": {
      "get": {
        "tags": [
          "Object"
        ],
        "summary": "Gets the metadata of an object",
        "operationId": "GetObjectMetadata",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "prefix",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "name": "versionID",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/metadata"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/objects/restore": {
      "put": {
        "tags": [
          "Object"
        ],
        "summary": "Restore Object to a selected version",
        "operationId": "PutObjectRestore",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "prefix",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "name": "version_id",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/objects/retention": {
      "put": {
        "tags": [
          "Object"
        ],
        "summary": "Put Object's retention status",
        "operationId": "PutObjectRetention",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "prefix",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "name": "version_id",
            "in": "query",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/putObjectRetentionRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Object"
        ],
        "summary": "Delete Object retention from an object",
        "operationId": "DeleteObjectRetention",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "prefix",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "name": "version_id",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/objects/share": {
      "get": {
        "tags": [
          "Object"
        ],
        "summary": "Shares an Object on a url",
        "operationId": "ShareObject",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "prefix",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "name": "version_id",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "name": "expires",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "string"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/objects/tags": {
      "put": {
        "tags": [
          "Object"
        ],
        "summary": "Put Object's tags",
        "operationId": "PutObjectTags",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "prefix",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "name": "version_id",
            "in": "query",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/putObjectTagsRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/objects/upload": {
      "post": {
        "security": [
          {
            "key": []
          },
          {
            "anonymous": []
          }
        ],
        "consumes": [
          "multipart/form-data"
        ],
        "tags": [
          "Object"
        ],
        "summary": "Uploads an Object.",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "prefix",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/replication": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "Bucket Replication",
        "operationId": "GetBucketReplication",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/bucketReplicationResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/replication/{rule_id}": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "Bucket Replication",
        "operationId": "GetBucketReplicationRule",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "rule_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/bucketReplicationRule"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Bucket"
        ],
        "summary": "Update Replication rule",
        "operationId": "UpdateMultiBucketReplication",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "rule_id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/multiBucketReplicationEdit"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Bucket"
        ],
        "summary": "Bucket Replication Rule Delete",
        "operationId": "DeleteBucketReplicationRule",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "rule_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/retention": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "Get Bucket's retention config",
        "operationId": "GetBucketRetentionConfig",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/getBucketRetentionConfig"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Bucket"
        ],
        "summary": "Set Bucket's retention config",
        "operationId": "SetBucketRetentionConfig",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/putBucketRetentionRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/rewind/{date}": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "Get objects in a bucket for a rewind date",
        "operationId": "GetBucketRewind",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "date",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "prefix",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/rewindResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/tags": {
      "put": {
        "tags": [
          "Bucket"
        ],
        "summary": "Put Bucket's tags",
        "operationId": "PutBucketTags",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/putBucketTagsRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/versioning": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "Bucket Versioning",
        "operationId": "GetBucketVersioning",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/bucketVersioningResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Bucket"
        ],
        "summary": "Set Bucket Versioning",
        "operationId": "SetBucketVersioning",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/setBucketVersioning"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{name}": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "Bucket Info",
        "operationId": "BucketInfo",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/bucket"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Bucket"
        ],
        "summary": "Delete Bucket",
        "operationId": "DeleteBucket",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{name}/quota": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "Get Bucket Quota",
        "operationId": "GetBucketQuota",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/bucketQuota"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Bucket"
        ],
        "summary": "Bucket Quota",
        "operationId": "SetBucketQuota",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/setBucketQuota"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/bucket"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{name}/set-policy": {
      "put": {
        "tags": [
          "Bucket"
        ],
        "summary": "Bucket Set Policy",
        "operationId": "BucketSetPolicy",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/setBucketPolicyRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/bucket"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/configs": {
      "get": {
        "tags": [
          "Configuration"
        ],
        "summary": "List Configurations",
        "operationId": "ListConfig",
        "parameters": [
          {
            "$ref": "#/parameters/offset"
          },
          {
            "$ref": "#/parameters/limit"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listConfigResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/configs/export": {
      "get": {
        "tags": [
          "Configuration"
        ],
        "summary": "Export the current config from MinIO server",
        "operationId": "ExportConfig",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/configExportResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/configs/import": {
      "post": {
        "consumes": [
          "multipart/form-data"
        ],
        "tags": [
          "Configuration"
        ],
        "summary": "Uploads a file to import MinIO server config.",
        "parameters": [
          {
            "type": "file",
            "name": "file",
            "in": "formData",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/configs/{name}": {
      "get": {
        "tags": [
          "Configuration"
        ],
        "summary": "Configuration info",
        "operationId": "ConfigInfo",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/configuration"
              }
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Configuration"
        ],
        "summary": "Set Configuration",
        "operationId": "SetConfig",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/setConfigRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/setConfigResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/configs/{name}/reset": {
      "post": {
        "tags": [
          "Configuration"
        ],
        "summary": "Configuration reset",
        "operationId": "ResetConfig",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/setConfigResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/download-shared-object/{url}": {
      "get": {
        "security": [],
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "Public"
        ],
        "summary": "Downloads an object from a presigned url",
        "operationId": "DownloadSharedObject",
        "parameters": [
          {
            "type": "string",
            "name": "url",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "file"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/group/{name}": {
      "get": {
        "tags": [
          "Group"
        ],
        "summary": "Group info",
        "operationId": "GroupInfo",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/group"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Group"
        ],
        "summary": "Update Group Members or Status",
        "operationId": "UpdateGroup",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/updateGroupRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/group"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Group"
        ],
        "summary": "Remove group",
        "operationId": "RemoveGroup",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/groups": {
      "get": {
        "tags": [
          "Group"
        ],
        "summary": "List Groups",
        "operationId": "ListGroups",
        "parameters": [
          {
            "$ref": "#/parameters/offset"
          },
          {
            "$ref": "#/parameters/limit"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listGroupsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Group"
        ],
        "summary": "Add Group",
        "operationId": "AddGroup",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/addGroupRequest"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/idp/{type}": {
      "get": {
        "tags": [
          "idp"
        ],
        "summary": "List IDP Configurations",
        "operationId": "ListConfigurations",
        "parameters": [
          {
            "type": "string",
            "description": "IDP Configuration Type",
            "name": "type",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/idpListConfigurationsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "consumes": [
          "application/json"
        ],
        "tags": [
          "idp"
        ],
        "summary": "Create IDP Configuration",
        "operationId": "CreateConfiguration",
        "parameters": [
          {
            "type": "string",
            "description": "IDP Configuration Type",
            "name": "type",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/idpServerConfiguration"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/setIDPResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/idp/{type}/{name}": {
      "get": {
        "tags": [
          "idp"
        ],
        "summary": "Get IDP Configuration",
        "operationId": "GetConfiguration",
        "parameters": [
          {
            "type": "string",
            "description": "IDP Configuration Name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "IDP Configuration Type",
            "name": "type",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/idpServerConfiguration"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "put": {
        "consumes": [
          "application/json"
        ],
        "tags": [
          "idp"
        ],
        "summary": "Update IDP Configuration",
        "operationId": "UpdateConfiguration",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/idpServerConfiguration"
            }
          },
          {
            "type": "string",
            "description": "IDP Configuration Name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "IDP Configuration Type",
            "name": "type",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/setIDPResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "idp"
        ],
        "summary": "Delete IDP Configuration",
        "operationId": "DeleteConfiguration",
        "parameters": [
          {
            "type": "string",
            "description": "IDP Configuration Name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "IDP Configuration Type",
            "name": "type",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/setIDPResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/apis": {
      "get": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS apis",
        "operationId": "KMSAPIs",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/kmsAPIsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/describe-self/identity": {
      "get": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS describe self identity",
        "operationId": "KMSDescribeSelfIdentity",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/kmsDescribeSelfIdentityResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/identities": {
      "get": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS list identities",
        "operationId": "KMSListIdentities",
        "parameters": [
          {
            "type": "string",
            "description": "pattern to retrieve identities",
            "name": "pattern",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/kmsListIdentitiesResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/identities/{name}": {
      "delete": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS delete identity",
        "operationId": "KMSDeleteIdentity",
        "parameters": [
          {
            "type": "string",
            "description": "KMS identity name",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/identities/{name}/describe": {
      "get": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS describe identity",
        "operationId": "KMSDescribeIdentity",
        "parameters": [
          {
            "type": "string",
            "description": "KMS identity name",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/kmsDescribeIdentityResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/keys": {
      "get": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS list keys",
        "operationId": "KMSListKeys",
        "parameters": [
          {
            "type": "string",
            "description": "pattern to retrieve keys",
            "name": "pattern",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/kmsListKeysResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS create key",
        "operationId": "KMSCreateKey",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/kmsCreateKeyRequest"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/keys/{name}": {
      "get": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS key status",
        "operationId": "KMSKeyStatus",
        "parameters": [
          {
            "type": "string",
            "description": "KMS key name",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/kmsKeyStatusResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS delete key",
        "operationId": "KMSDeleteKey",
        "parameters": [
          {
            "type": "string",
            "description": "KMS key name",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/keys/{name}/import": {
      "post": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS import key",
        "operationId": "KMSImportKey",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/kmsImportKeyRequest"
            }
          },
          {
            "type": "string",
            "description": "KMS key name",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/metrics": {
      "get": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS metrics",
        "operationId": "KMSMetrics",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/kmsMetricsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/policies": {
      "get": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS list policies",
        "operationId": "KMSListPolicies",
        "parameters": [
          {
            "type": "string",
            "description": "pattern to retrieve policies",
            "name": "pattern",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/kmsListPoliciesResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS set policy",
        "operationId": "KMSSetPolicy",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/kmsSetPolicyRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/policies/{name}": {
      "get": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS get policy",
        "operationId": "KMSGetPolicy",
        "parameters": [
          {
            "type": "string",
            "description": "KMS policy name",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/kmsGetPolicyResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS delete policy",
        "operationId": "KMSDeletePolicy",
        "parameters": [
          {
            "type": "string",
            "description": "KMS policy name",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/policies/{name}/assign": {
      "post": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS assign policy",
        "operationId": "KMSAssignPolicy",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/kmsAssignPolicyRequest"
            }
          },
          {
            "type": "string",
            "description": "KMS policy name",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/policies/{name}/describe": {
      "get": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS describe policy",
        "operationId": "KMSDescribePolicy",
        "parameters": [
          {
            "type": "string",
            "description": "KMS policy name",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/kmsDescribePolicyResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/status": {
      "get": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS status",
        "operationId": "KMSStatus",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/kmsStatusResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/version": {
      "get": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS version",
        "operationId": "KMSVersion",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/kmsVersionResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/ldap-entities": {
      "post": {
        "tags": [
          "idp"
        ],
        "summary": "Get LDAP Entities",
        "operationId": "GetLDAPEntities",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/ldapEntitiesRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/ldapEntities"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/list-external-buckets": {
      "post": {
        "tags": [
          "Bucket"
        ],
        "summary": "Lists an External list of buckets using custom credentials",
        "operationId": "ListExternalBuckets",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/listExternalBucketsParams"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listBucketsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/login": {
      "get": {
        "security": [],
        "tags": [
          "Auth"
        ],
        "summary": "Returns login strategy, form or sso.",
        "operationId": "LoginDetail",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/loginDetails"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "security": [],
        "tags": [
          "Auth"
        ],
        "summary": "Login to Console",
        "operationId": "Login",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/loginRequest"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful login."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/login/oauth2/auth": {
      "post": {
        "security": [],
        "tags": [
          "Auth"
        ],
        "summary": "Identity Provider oauth2 callback endpoint.",
        "operationId": "LoginOauth2Auth",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/loginOauth2AuthRequest"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful login."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/logout": {
      "post": {
        "tags": [
          "Auth"
        ],
        "summary": "Logout from Console.",
        "operationId": "Logout",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/logoutRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/logs/search": {
      "get": {
        "tags": [
          "Logging"
        ],
        "summary": "Search the logs",
        "operationId": "LogSearch",
        "parameters": [
          {
            "type": "array",
            "items": {
              "type": "string"
            },
            "collectionFormat": "multi",
            "description": "Filter Parameters",
            "name": "fp",
            "in": "query"
          },
          {
            "type": "number",
            "format": "int32",
            "default": 10,
            "name": "pageSize",
            "in": "query"
          },
          {
            "type": "number",
            "format": "int32",
            "default": 0,
            "name": "pageNo",
            "in": "query"
          },
          {
            "enum": [
              "timeDesc",
              "timeAsc"
            ],
            "type": "string",
            "default": "timeDesc",
            "name": "order",
            "in": "query"
          },
          {
            "type": "string",
            "name": "timeStart",
            "in": "query"
          },
          {
            "type": "string",
            "name": "timeEnd",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/logSearchResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/nodes": {
      "get": {
        "tags": [
          "System"
        ],
        "summary": "Lists Nodes",
        "operationId": "ListNodes",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/policies": {
      "get": {
        "tags": [
          "Policy"
        ],
        "summary": "List Policies",
        "operationId": "ListPolicies",
        "parameters": [
          {
            "$ref": "#/parameters/offset"
          },
          {
            "$ref": "#/parameters/limit"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listPoliciesResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Policy"
        ],
        "summary": "Add Policy",
        "operationId": "AddPolicy",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/addPolicyRequest"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/policy"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/policies/{policy}/groups": {
      "get": {
        "tags": [
          "Policy"
        ],
        "summary": "List Groups for a Policy",
        "operationId": "ListGroupsForPolicy",
        "parameters": [
          {
            "type": "string",
            "name": "policy",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/policies/{policy}/users": {
      "get": {
        "tags": [
          "Policy"
        ],
        "summary": "List Users for a Policy",
        "operationId": "ListUsersForPolicy",
        "parameters": [
          {
            "type": "string",
            "name": "policy",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/policy/{name}": {
      "get": {
        "tags": [
          "Policy"
        ],
        "summary": "Policy info",
        "operationId": "PolicyInfo",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/policy"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Policy"
        ],
        "summary": "Remove policy",
        "operationId": "RemovePolicy",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/profiling/start": {
      "post": {
        "tags": [
          "Profile"
        ],
        "summary": "Start recording profile data",
        "operationId": "ProfilingStart",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/profilingStartRequest"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/startProfilingList"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/profiling/stop": {
      "post": {
        "produces": [
          "application/zip"
        ],
        "tags": [
          "Profile"
        ],
        "summary": "Stop and download profile data",
        "operationId": "ProfilingStop",
        "responses": {
          "201": {
            "description": "A successful response.",
            "schema": {
              "type": "file"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/releases": {
      "get": {
        "tags": [
          "release"
        ],
        "summary": "Get repo releases for a given version",
        "operationId": "ListReleases",
        "parameters": [
          {
            "type": "string",
            "description": "repo name",
            "name": "repo",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "description": "Current Release",
            "name": "current",
            "in": "query"
          },
          {
            "type": "string",
            "description": "search content",
            "name": "search",
            "in": "query"
          },
          {
            "type": "string",
            "description": "filter releases",
            "name": "filter",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/releaseListResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/remote-buckets": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "List Remote Buckets",
        "operationId": "ListRemoteBuckets",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listRemoteBucketsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Bucket"
        ],
        "summary": "Add Remote Bucket",
        "operationId": "AddRemoteBucket",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/createRemoteBucket"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/remote-buckets/{name}": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "Remote Bucket Details",
        "operationId": "RemoteBucketDetails",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/remoteBucket"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/remote-buckets/{source-bucket-name}/{arn}": {
      "delete": {
        "tags": [
          "Bucket"
        ],
        "summary": "Delete Remote Bucket",
        "operationId": "DeleteRemoteBucket",
        "parameters": [
          {
            "type": "string",
            "name": "source-bucket-name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "arn",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/service-account-credentials": {
      "post": {
        "tags": [
          "ServiceAccount"
        ],
        "summary": "Create Service Account With Credentials",
        "operationId": "CreateServiceAccountCreds",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/serviceAccountRequestCreds"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/serviceAccountCreds"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/service-accounts": {
      "get": {
        "tags": [
          "ServiceAccount"
        ],
        "summary": "List User's Service Accounts",
        "operationId": "ListUserServiceAccounts",
        "parameters": [
          {
            "$ref": "#/parameters/offset"
          },
          {
            "$ref": "#/parameters/limit"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/serviceAccounts"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "tags": [
          "ServiceAccount"
        ],
        "summary": "Create Service Account",
        "operationId": "CreateServiceAccount",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/serviceAccountRequest"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/serviceAccountCreds"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/service-accounts/delete-multi": {
      "delete": {
        "tags": [
          "ServiceAccount"
        ],
        "summary": "Delete Multiple Service Accounts",
        "operationId": "DeleteMultipleServiceAccounts",
        "parameters": [
          {
            "name": "selectedSA",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/selectedSAs"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/service-accounts/{access_key}": {
      "get": {
        "tags": [
          "ServiceAccount"
        ],
        "summary": "Get Service Account",
        "operationId": "GetServiceAccount",
        "parameters": [
          {
            "type": "string",
            "name": "access_key",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/serviceAccount"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "put": {
        "tags": [
          "ServiceAccount"
        ],
        "summary": "Set Service Account Policy",
        "operationId": "UpdateServiceAccount",
        "parameters": [
          {
            "type": "string",
            "name": "access_key",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/updateServiceAccountRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "ServiceAccount"
        ],
        "summary": "Delete Service Account",
        "operationId": "DeleteServiceAccount",
        "parameters": [
          {
            "type": "string",
            "name": "access_key",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/service/restart": {
      "post": {
        "tags": [
          "Service"
        ],
        "summary": "Restart Service",
        "operationId": "RestartService",
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/session": {
      "get": {
        "tags": [
          "Auth"
        ],
        "summary": "Endpoint to check if your session is still valid",
        "operationId": "SessionCheck",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/sessionResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/set-policy": {
      "put": {
        "tags": [
          "Policy"
        ],
        "summary": "Set policy",
        "operationId": "SetPolicy",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/setPolicyNameRequest"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/set-policy-multi": {
      "put": {
        "tags": [
          "Policy"
        ],
        "summary": "Set policy to multiple users/groups",
        "operationId": "SetPolicyMultiple",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/setPolicyMultipleNameRequest"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/subnet/apikey": {
      "get": {
        "tags": [
          "Subnet"
        ],
        "summary": "Subnet api key",
        "operationId": "SubnetApiKey",
        "parameters": [
          {
            "type": "string",
            "name": "token",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/apiKey"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/subnet/info": {
      "get": {
        "tags": [
          "Subnet"
        ],
        "summary": "Subnet info",
        "operationId": "SubnetInfo",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/license"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/subnet/login": {
      "post": {
        "tags": [
          "Subnet"
        ],
        "summary": "Login to SUBNET",
        "operationId": "SubnetLogin",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/subnetLoginRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/subnetLoginResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/subnet/login/mfa": {
      "post": {
        "tags": [
          "Subnet"
        ],
        "summary": "Login to SUBNET using mfa",
        "operationId": "SubnetLoginMFA",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/subnetLoginMFARequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/subnetLoginResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/subnet/register": {
      "post": {
        "tags": [
          "Subnet"
        ],
        "summary": "Register cluster with Subnet",
        "operationId": "SubnetRegister",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/subnetRegisterRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/subnet/registration-token": {
      "get": {
        "tags": [
          "Subnet"
        ],
        "summary": "SUBNET registraton token",
        "operationId": "SubnetRegToken",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/SubnetRegTokenResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/support/callhome": {
      "get": {
        "tags": [
          "Support"
        ],
        "summary": "Get Callhome current status",
        "operationId": "GetCallHomeOptionValue",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/callHomeGetResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Support"
        ],
        "summary": "Sets callhome status",
        "operationId": "SetCallHomeStatus",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/callHomeSetStatus"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/user/policy": {
      "get": {
        "tags": [
          "Policy"
        ],
        "summary": "returns policies for logged in user",
        "operationId": "GetUserPolicy",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "string"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/user/{name}": {
      "get": {
        "tags": [
          "User"
        ],
        "summary": "Get User Info",
        "operationId": "GetUserInfo",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/user"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "put": {
        "tags": [
          "User"
        ],
        "summary": "Update User Info",
        "operationId": "UpdateUserInfo",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/updateUser"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/user"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "User"
        ],
        "summary": "Remove user",
        "operationId": "RemoveUser",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/user/{name}/groups": {
      "put": {
        "tags": [
          "User"
        ],
        "summary": "Update Groups for a user",
        "operationId": "UpdateUserGroups",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/updateUserGroups"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/user"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/user/{name}/policies": {
      "get": {
        "tags": [
          "Policy"
        ],
        "summary": "returns policies assigned for a specified user",
        "operationId": "GetSAUserPolicy",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/aUserPolicyResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/user/{name}/service-account-credentials": {
      "post": {
        "tags": [
          "User"
        ],
        "summary": "Create Service Account for User With Credentials",
        "operationId": "CreateServiceAccountCredentials",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/serviceAccountRequestCreds"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/serviceAccountCreds"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/user/{name}/service-accounts": {
      "get": {
        "tags": [
          "User"
        ],
        "summary": "returns a list of service accounts for a user",
        "operationId": "ListAUserServiceAccounts",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/serviceAccounts"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "tags": [
          "User"
        ],
        "summary": "Create Service Account for User",
        "operationId": "CreateAUserServiceAccount",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/serviceAccountRequest"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/serviceAccountCreds"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/users": {
      "get": {
        "tags": [
          "User"
        ],
        "summary": "List Users",
        "operationId": "ListUsers",
        "parameters": [
          {
            "$ref": "#/parameters/offset"
          },
          {
            "$ref": "#/parameters/limit"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listUsersResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "tags": [
          "User"
        ],
        "summary": "Add User",
        "operationId": "AddUser",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/addUserRequest"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/user"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/users-groups-bulk": {
      "put": {
        "tags": [
          "User"
        ],
        "summary": "Bulk functionality to Add Users to Groups",
        "operationId": "BulkUpdateUsersGroups",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/bulkUserGroups"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/users/service-accounts": {
      "post": {
        "tags": [
          "User"
        ],
        "summary": "Check number of service accounts for each user specified",
        "operationId": "CheckUserServiceAccounts",
        "parameters": [
          {
            "name": "selectedUsers",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/selectedUsers"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/userServiceAccountSummary"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    }
  },
  "definitions": {
    "ApiError": {
      "type": "object",
      "properties": {
        "detailedMessage": {
          "type": "string"
        },
        "message": {
          "type": "string"
        }
      }
    },
    "BackendProperties": {
      "type": "object",
      "properties": {
        "backendType": {
          "type": "string"
        },
        "offlineDrives": {
          "type": "integer"
        },
        "onlineDrives": {
          "type": "integer"
        },
        "rrSCParity": {
          "type": "integer"
        },
        "standardSCParity": {
          "type": "integer"
        }
      }
    },
    "SubnetRegTokenResponse": {
      "type": "object",
      "properties": {
        "regToken": {
          "type": "string"
        }
      }
    },
    "aUserPolicyResponse": {
      "type": "object",
      "properties": {
        "policy": {
          "type": "string"
        }
      }
    },
    "accessRule": {
      "type": "object",
      "properties": {
        "access": {
          "type": "string"
        },
        "prefix": {
          "type": "string"
        }
      }
    },
    "accountChangePasswordRequest": {
      "type": "object",
      "required": [
        "current_secret_key",
        "new_secret_key"
      ],
      "properties": {
        "current_secret_key": {
          "type": "string"
        },
        "new_secret_key": {
          "type": "string"
        }
      }
    },
    "addBucketLifecycle": {
      "type": "object",
      "properties": {
        "disable": {
          "description": "Non required, toggle to disable or enable rule",
          "type": "boolean"
        },
        "expired_object_delete_all": {
          "description": "Non required, toggle to disable or enable rule",
          "type": "boolean"
        },
        "expired_object_delete_marker": {
          "description": "Non required, toggle to disable or enable rule",
          "type": "boolean"
        },
        "expiry_days": {
          "description": "Required in case of expiry_date or transition fields are not set. it defines an expiry days for ILM",
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "newer_noncurrentversion_expiration_versions": {
          "description": "Non required, can be set in case of expiration is enabled",
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "noncurrentversion_expiration_days": {
          "description": "Non required, can be set in case of expiration is enabled",
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "noncurrentversion_transition_days": {
          "description": "Non required, can be set in case of transition is enabled",
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "noncurrentversion_transition_storage_class": {
          "description": "Non required, can be set in case of transition is enabled",
          "type": "string"
        },
        "prefix": {
          "description": "Non required field, it matches a prefix to perform ILM operations on it",
          "type": "string"
        },
        "storage_class": {
          "description": "Required only in case of transition is set. it refers to a tier",
          "type": "string"
        },
        "tags": {
          "description": "Non required field, tags to match ILM files",
          "type": "string"
        },
        "transition_days": {
          "description": "Required in case of transition_date or expiry fields are not set. it defines a transition days for ILM",
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "type": {
          "description": "ILM Rule type (Expiry or transition)",
          "type": "string",
          "enum": [
            "expiry",
            "transition"
          ]
        }
      }
    },
    "addBucketReplication": {
      "type": "object",
      "properties": {
        "arn": {
          "type": "string"
        },
        "destination_bucket": {
          "type": "string"
        }
      }
    },
    "addGroupRequest": {
      "type": "object",
      "required": [
        "group",
        "members"
      ],
      "properties": {
        "group": {
          "type": "string"
        },
        "members": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "addMultiBucketLifecycle": {
      "type": "object",
      "required": [
        "buckets",
        "type"
      ],
      "properties": {
        "buckets": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "expired_object_delete_all": {
          "description": "Non required, toggle to disable or enable rule",
          "type": "boolean"
        },
        "expired_object_delete_marker": {
          "description": "Non required, toggle to disable or enable rule",
          "type": "boolean"
        },
        "expiry_days": {
          "description": "Required in case of expiry_date or transition fields are not set. it defines an expiry days for ILM",
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "noncurrentversion_expiration_days": {
          "description": "Non required, can be set in case of expiration is enabled",
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "noncurrentversion_transition_days": {
          "description": "Non required, can be set in case of transition is enabled",
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "noncurrentversion_transition_storage_class": {
          "description": "Non required, can be set in case of transition is enabled",
          "type": "string"
        },
        "prefix": {
          "description": "Non required field, it matches a prefix to perform ILM operations on it",
          "type": "string"
        },
        "storage_class": {
          "description": "Required only in case of transition is set. it refers to a tier",
          "type": "string"
        },
        "tags": {
          "description": "Non required field, tags to match ILM files",
          "type": "string"
        },
        "transition_days": {
          "description": "Required in case of transition_date or expiry fields are not set. it defines a transition days for ILM",
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "type": {
          "description": "ILM Rule type (Expiry or transition)",
          "type": "string",
          "enum": [
            "expiry",
            "transition"
          ]
        }
      }
    },
    "addPolicyRequest": {
      "type": "object",
      "required": [
        "name",
        "policy"
      ],
      "properties": {
        "name": {
          "type": "string"
        },
        "policy": {
          "type": "string"
        }
      }
    },
    "addUserRequest": {
      "type": "object",
      "required": [
        "accessKey",
        "secretKey",
        "groups",
        "policies"
      ],
      "properties": {
        "accessKey": {
          "type": "string"
        },
        "groups": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "policies": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "secretKey": {
          "type": "string"
        }
      }
    },
    "adminInfoResponse": {
      "type": "object",
      "properties": {
        "advancedMetricsStatus": {
          "type": "string",
          "enum": [
            "not configured",
            "available",
            "unavailable"
          ]
        },
        "backend": {
          "$ref": "#/definitions/BackendProperties"
        },
        "buckets": {
          "type": "integer"
        },
        "objects": {
          "type": "integer"
        },
        "servers": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/serverProperties"
          }
        },
        "usage": {
          "type": "integer"
        },
        "widgets": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/widget"
          }
        }
      }
    },
    "apiKey": {
      "type": "object",
      "properties": {
        "apiKey": {
          "type": "string"
        }
      }
    },
    "arnsResponse": {
      "type": "object",
      "properties": {
        "arns": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "bucket": {
      "type": "object",
      "required": [
        "name"
      ],
      "properties": {
        "access": {
          "$ref": "#/definitions/bucketAccess"
        },
        "creation_date": {
          "type": "string"
        },
        "definition": {
          "type": "string"
        },
        "details": {
          "type": "object",
          "properties": {
            "locking": {
              "type": "boolean"
            },
            "quota": {
              "type": "object",
              "properties": {
                "quota": {
                  "type": "integer",
                  "format": "int64"
                },
                "type": {
                  "type": "string",
                  "enum": [
                    "hard"
                  ]
                }
              }
            },
            "replication": {
              "type": "boolean"
            },
            "tags": {
              "type": "object",
              "additionalProperties": {
                "type": "string"
              }
            },
            "versioning": {
              "type": "boolean"
            },
            "versioningSuspended": {
              "type": "boolean"
            }
          }
        },
        "name": {
          "type": "string",
          "minLength": 3
        },
        "objects": {
          "type": "integer",
          "format": "int64"
        },
        "rw_access": {
          "type": "object",
          "properties": {
            "read": {
              "type": "boolean"
            },
            "write": {
              "type": "boolean"
            }
          }
        },
        "size": {
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "bucketAccess": {
      "type": "string",
      "default": "PRIVATE",
      "enum": [
        "PRIVATE",
        "PUBLIC",
        "CUSTOM"
      ]
    },
    "bucketEncryptionInfo": {
      "type": "object",
      "properties": {
        "algorithm": {
          "type": "string"
        },
        "kmsMasterKeyID": {
          "type": "string"
        }
      }
    },
    "bucketEncryptionRequest": {
      "type": "object",
      "properties": {
        "encType": {
          "$ref": "#/definitions/bucketEncryptionType"
        },
        "kmsKeyID": {
          "type": "string"
        }
      }
    },
    "bucketEncryptionType": {
      "type": "string",
      "default": "sse-s3",
      "enum": [
        "sse-s3",
        "sse-kms"
      ]
    },
    "bucketEventRequest": {
      "type": "object",
      "required": [
        "configuration"
      ],
      "properties": {
        "configuration": {
          "$ref": "#/definitions/notificationConfig"
        },
        "ignoreExisting": {
          "type": "boolean"
        }
      }
    },
    "bucketLifecycleResponse": {
      "type": "object",
      "properties": {
        "lifecycle": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/objectBucketLifecycle"
          }
        }
      }
    },
    "bucketObLockingResponse": {
      "type": "object",
      "properties": {
        "object_locking_enabled": {
          "type": "boolean"
        }
      }
    },
    "bucketObject": {
      "type": "object",
      "properties": {
        "content_type": {
          "type": "string"
        },
        "etag": {
          "type": "string"
        },
        "expiration": {
          "type": "string"
        },
        "expiration_rule_id": {
          "type": "string"
        },
        "is_delete_marker": {
          "type": "boolean"
        },
        "is_latest": {
          "type": "boolean"
        },
        "last_modified": {
          "type": "string"
        },
        "legal_hold_status": {
          "type": "string"
        },
        "metadata": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "name": {
          "type": "string"
        },
        "retention_mode": {
          "type": "string"
        },
        "retention_until_date": {
          "type": "string"
        },
        "size": {
          "type": "integer",
          "format": "int64"
        },
        "tags": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "user_metadata": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "user_tags": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "version_id": {
          "type": "string"
        }
      }
    },
    "bucketQuota": {
      "type": "object",
      "properties": {
        "quota": {
          "type": "integer"
        },
        "type": {
          "type": "string",
          "enum": [
            "hard"
          ]
        }
      }
    },
    "bucketReplicationDestination": {
      "type": "object",
      "properties": {
        "bucket": {
          "type": "string"
        }
      }
    },
    "bucketReplicationResponse": {
      "type": "object",
      "properties": {
        "rules": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/bucketReplicationRule"
          }
        }
      }
    },
    "bucketReplicationRule": {
      "type": "object",
      "properties": {
        "bandwidth": {
          "type": "string"
        },
        "delete_marker_replication": {
          "type": "boolean"
        },
        "deletes_replication": {
          "type": "boolean"
        },
        "destination": {
          "$ref": "#/definitions/bucketReplicationDestination"
        },
        "existingObjects": {
          "type": "boolean"
        },
        "healthCheckPeriod": {
          "type": "integer"
        },
        "id": {
          "type": "string"
        },
        "metadata_replication": {
          "type": "boolean"
        },
        "prefix": {
          "type": "string"
        },
        "priority": {
          "type": "integer",
          "format": "int32"
        },
        "status": {
          "type": "string",
          "enum": [
            "Enabled",
            "Disabled"
          ]
        },
        "storageClass": {
          "type": "string"
        },
        "syncMode": {
          "type": "string",
          "default": "async",
          "enum": [
            "async",
            "sync"
          ]
        },
        "tags": {
          "type": "string"
        }
      }
    },
    "bucketReplicationRuleList": {
      "type": "object",
      "properties": {
        "rules": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "bucketVersioningResponse": {
      "type": "object",
      "properties": {
        "MFADelete": {
          "type": "string"
        },
        "excludeFolders": {
          "type": "boolean"
        },
        "excludedPrefixes": {
          "type": "array",
          "items": {
            "type": "object",
            "properties": {
              "prefix": {
                "type": "string"
              }
            }
          }
        },
        "status": {
          "type": "string"
        }
      }
    },
    "bulkUserGroups": {
      "type": "object",
      "required": [
        "users",
        "groups"
      ],
      "properties": {
        "groups": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "users": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "callHomeGetResponse": {
      "type": "object",
      "properties": {
        "diagnosticsStatus": {
          "type": "boolean"
        },
        "logsStatus": {
          "type": "boolean"
        }
      }
    },
    "callHomeSetStatus": {
      "type": "object",
      "required": [
        "diagState",
        "logsState"
      ],
      "properties": {
        "diagState": {
          "type": "boolean"
        },
        "logsState": {
          "type": "boolean"
        }
      }
    },
    "changeUserPasswordRequest": {
      "type": "object",
      "required": [
        "selectedUser",
        "newSecretKey"
      ],
      "properties": {
        "newSecretKey": {
          "type": "string"
        },
        "selectedUser": {
          "type": "string"
        }
      }
    },
    "configDescription": {
      "type": "object",
      "properties": {
        "description": {
          "type": "string"
        },
        "key": {
          "type": "string"
        }
      }
    },
    "configExportResponse": {
      "type": "object",
      "properties": {
        "status": {
          "type": "string"
        },
        "value": {
          "description": "Returns base64 encoded value",
          "type": "string"
        }
      }
    },
    "configuration": {
      "type": "object",
      "properties": {
        "key_values": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/configurationKV"
          }
        },
        "name": {
          "type": "string"
        }
      }
    },
    "configurationKV": {
      "type": "object",
      "properties": {
        "env_override": {
          "$ref": "#/definitions/envOverride"
        },
        "key": {
          "type": "string"
        },
        "value": {
          "type": "string"
        }
      }
    },
    "createRemoteBucket": {
      "required": [
        "accessKey",
        "secretKey",
        "targetURL",
        "sourceBucket",
        "targetBucket"
      ],
      "properties": {
        "accessKey": {
          "type": "string",
          "minLength": 3
        },
        "bandwidth": {
          "type": "integer",
          "format": "int64"
        },
        "healthCheckPeriod": {
          "type": "integer",
          "format": "int32"
        },
        "region": {
          "type": "string"
        },
        "secretKey": {
          "type": "string",
          "minLength": 8
        },
        "sourceBucket": {
          "type": "string"
        },
        "syncMode": {
          "type": "string",
          "default": "async",
          "enum": [
            "async",
            "sync"
          ]
        },
        "targetBucket": {
          "type": "string"
        },
        "targetURL": {
          "type": "string"
        }
      }
    },
    "deleteFile": {
      "type": "object",
      "properties": {
        "path": {
          "type": "string"
        },
        "recursive": {
          "type": "boolean"
        },
        "versionID": {
          "type": "string"
        }
      }
    },
    "envOverride": {
      "type": "object",
      "properties": {
        "name": {
          "type": "string"
        },
        "value": {
          "type": "string"
        }
      }
    },
    "environmentConstants": {
      "type": "object",
      "properties": {
        "maxConcurrentDownloads": {
          "type": "integer"
        },
        "maxConcurrentUploads": {
          "type": "integer"
        }
      }
    },
    "expirationResponse": {
      "type": "object",
      "properties": {
        "date": {
          "type": "string"
        },
        "days": {
          "type": "integer",
          "format": "int64"
        },
        "delete_all": {
          "type": "boolean"
        },
        "delete_marker": {
          "type": "boolean"
        },
        "newer_noncurrent_expiration_versions": {
          "type": "integer",
          "format": "int64"
        },
        "noncurrent_expiration_days": {
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "getBucketRetentionConfig": {
      "type": "object",
      "properties": {
        "mode": {
          "$ref": "#/definitions/objectRetentionMode"
        },
        "unit": {
          "$ref": "#/definitions/objectRetentionUnit"
        },
        "validity": {
          "type": "integer",
          "format": "int32"
        }
      }
    },
    "group": {
      "type": "object",
      "properties": {
        "members": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "name": {
          "type": "string"
        },
        "policy": {
          "type": "string"
        },
        "status": {
          "type": "string"
        }
      }
    },
    "iamEntity": {
      "type": "string",
      "pattern": "^[\\w+=,.@-]{1,64}$"
    },
    "iamPolicy": {
      "type": "object",
      "properties": {
        "statement": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/iamPolicyStatement"
          }
        },
        "version": {
          "type": "string"
        }
      }
    },
    "iamPolicyStatement": {
      "type": "object",
      "properties": {
        "action": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "condition": {
          "type": "object",
          "additionalProperties": {
            "type": "object"
          }
        },
        "effect": {
          "type": "string"
        },
        "resource": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "idpListConfigurationsResponse": {
      "type": "object",
      "properties": {
        "results": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/idpServerConfiguration"
          }
        }
      }
    },
    "idpServerConfiguration": {
      "type": "object",
      "properties": {
        "enabled": {
          "type": "boolean"
        },
        "info": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/idpServerConfigurationInfo"
          }
        },
        "input": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "type": {
          "type": "string"
        }
      }
    },
    "idpServerConfigurationInfo": {
      "type": "object",
      "properties": {
        "isCfg": {
          "type": "boolean"
        },
        "isEnv": {
          "type": "boolean"
        },
        "key": {
          "type": "string"
        },
        "value": {
          "type": "string"
        }
      }
    },
    "kmDeleteKeyRequest": {
      "type": "object"
    },
    "kmsAPI": {
      "type": "object",
      "properties": {
        "maxBody": {
          "type": "integer"
        },
        "method": {
          "type": "string"
        },
        "path": {
          "type": "string"
        },
        "timeout": {
          "type": "integer"
        }
      }
    },
    "kmsAPIsResponse": {
      "type": "object",
      "properties": {
        "results": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/kmsAPI"
          }
        }
      }
    },
    "kmsAssignPolicyRequest": {
      "type": "object",
      "properties": {
        "identity": {
          "type": "string"
        }
      }
    },
    "kmsCreateKeyRequest": {
      "type": "object",
      "required": [
        "key"
      ],
      "properties": {
        "key": {
          "type": "string"
        }
      }
    },
    "kmsDescribeIdentityResponse": {
      "type": "object",
      "properties": {
        "admin": {
          "type": "boolean"
        },
        "createdAt": {
          "type": "string"
        },
        "createdBy": {
          "type": "string"
        },
        "identity": {
          "type": "string"
        },
        "policy": {
          "type": "string"
        }
      }
    },
    "kmsDescribePolicyResponse": {
      "type": "object",
      "properties": {
        "createdAt": {
          "type": "string"
        },
        "createdBy": {
          "type": "string"
        },
        "name": {
          "type": "string"
        }
      }
    },
    "kmsDescribeSelfIdentityResponse": {
      "type": "object",
      "properties": {
        "admin": {
          "type": "boolean"
        },
        "createdAt": {
          "type": "string"
        },
        "createdBy": {
          "type": "string"
        },
        "identity": {
          "type": "string"
        },
        "policy": {
          "$ref": "#/definitions/kmsGetPolicyResponse"
        },
        "policyName": {
          "type": "string"
        }
      }
    },
    "kmsEndpoint": {
      "type": "object",
      "properties": {
        "status": {
          "type": "string"
        },
        "url": {
          "type": "string"
        }
      }
    },
    "kmsGetPolicyResponse": {
      "type": "object",
      "properties": {
        "allow": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "deny": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "kmsIdentityInfo": {
      "type": "object",
      "properties": {
        "createdAt": {
          "type": "string"
        },
        "createdBy": {
          "type": "string"
        },
        "error": {
          "type": "string"
        },
        "identity": {
          "type": "string"
        },
        "policy": {
          "type": "string"
        }
      }
    },
    "kmsImportKeyRequest": {
      "type": "object",
      "required": [
        "bytes"
      ],
      "properties": {
        "bytes": {
          "type": "string"
        }
      }
    },
    "kmsKeyInfo": {
      "type": "object",
      "properties": {
        "createdAt": {
          "type": "string"
        },
        "createdBy": {
          "type": "string"
        },
        "name": {
          "type": "string"
        }
      }
    },
    "kmsKeyStatusResponse": {
      "type": "object",
      "properties": {
        "decryptionErr": {
          "type": "string"
        },
        "encryptionErr": {
          "type": "string"
        },
        "keyID": {
          "type": "string"
        }
      }
    },
    "kmsLatencyHistogram": {
      "type": "object",
      "properties": {
        "duration": {
          "type": "integer"
        },
        "total": {
          "type": "integer"
        }
      }
    },
    "kmsListIdentitiesResponse": {
      "type": "object",
      "properties": {
        "results": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/kmsIdentityInfo"
          }
        }
      }
    },
    "kmsListKeysResponse": {
      "type": "object",
      "properties": {
        "results": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/kmsKeyInfo"
          }
        }
      }
    },
    "kmsListPoliciesResponse": {
      "type": "object",
      "properties": {
        "results": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/kmsPolicyInfo"
          }
        }
      }
    },
    "kmsMetricsResponse": {
      "type": "object",
      "required": [
        "requestOK",
        "requestErr",
        "requestFail",
        "requestActive",
        "auditEvents",
        "errorEvents",
        "latencyHistogram",
        "uptime",
        "cpus",
        "usableCPUs",
        "threads",
        "heapAlloc",
        "stackAlloc"
      ],
      "properties": {
        "auditEvents": {
          "type": "integer"
        },
        "cpus": {
          "type": "integer"
        },
        "errorEvents": {
          "type": "integer"
        },
        "heapAlloc": {
          "type": "integer"
        },
        "heapObjects": {
          "type": "integer"
        },
        "latencyHistogram": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/kmsLatencyHistogram"
          }
        },
        "requestActive": {
          "type": "integer"
        },
        "requestErr": {
          "type": "integer"
        },
        "requestFail": {
          "type": "integer"
        },
        "requestOK": {
          "type": "integer"
        },
        "stackAlloc": {
          "type": "integer"
        },
        "threads": {
          "type": "integer"
        },
        "uptime": {
          "type": "integer"
        },
        "usableCPUs": {
          "type": "integer"
        }
      }
    },
    "kmsPolicyInfo": {
      "type": "object",
      "properties": {
        "createdAt": {
          "type": "string"
        },
        "createdBy": {
          "type": "string"
        },
        "name": {
          "type": "string"
        }
      }
    },
    "kmsSetPolicyRequest": {
      "type": "object",
      "required": [
        "policy"
      ],
      "properties": {
        "allow": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "deny": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "policy": {
          "type": "string"
        }
      }
    },
    "kmsStatusResponse": {
      "type": "object",
      "properties": {
        "defaultKeyID": {
          "type": "string"
        },
        "endpoints": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/kmsEndpoint"
          }
        },
        "name": {
          "type": "string"
        }
      }
    },
    "kmsVersionResponse": {
      "type": "object",
      "properties": {
        "version": {
          "type": "string"
        }
      }
    },
    "ldapEntities": {
      "type": "object",
      "properties": {
        "groups": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/ldapGroupPolicyEntity"
          }
        },
        "policies": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/ldapPolicyEntity"
          }
        },
        "timestamp": {
          "type": "string"
        },
        "users": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/ldapUserPolicyEntity"
          }
        }
      }
    },
    "ldapEntitiesRequest": {
      "type": "object",
      "properties": {
        "groups": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "policies": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "users": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "ldapGroupPolicyEntity": {
      "type": "object",
      "properties": {
        "group": {
          "type": "string"
        },
        "policies": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "ldapPolicyEntity": {
      "type": "object",
      "properties": {
        "groups": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "policy": {
          "type": "string"
        },
        "users": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "ldapUserPolicyEntity": {
      "type": "object",
      "properties": {
        "policies": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "user": {
          "type": "string"
        }
      }
    },
    "license": {
      "type": "object",
      "properties": {
        "account_id": {
          "type": "integer"
        },
        "email": {
          "type": "string"
        },
        "expires_at": {
          "type": "string"
        },
        "organization": {
          "type": "string"
        },
        "plan": {
          "type": "string"
        },
        "storage_capacity": {
          "type": "integer"
        }
      }
    },
    "lifecycleTag": {
      "type": "object",
      "properties": {
        "key": {
          "type": "string"
        },
        "value": {
          "type": "string"
        }
      }
    },
    "listAccessRulesResponse": {
      "type": "object",
      "properties": {
        "accessRules": {
          "type": "array",
          "title": "list of policies",
          "items": {
            "$ref": "#/definitions/accessRule"
          }
        },
        "total": {
          "type": "integer",
          "format": "int64",
          "title": "total number of policies"
        }
      }
    },
    "listBucketEventsResponse": {
      "type": "object",
      "properties": {
        "events": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/notificationConfig"
          }
        },
        "total": {
          "type": "integer",
          "format": "int64",
          "title": "total number of bucket events"
        }
      }
    },
    "listBucketsResponse": {
      "type": "object",
      "properties": {
        "buckets": {
          "type": "array",
          "title": "list of resulting buckets",
          "items": {
            "$ref": "#/definitions/bucket"
          }
        },
        "total": {
          "type": "integer",
          "format": "int64",
          "title": "number of buckets accessible to the user"
        }
      }
    },
    "listConfigResponse": {
      "type": "object",
      "properties": {
        "configurations": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/configDescription"
          }
        },
        "total": {
          "type": "integer",
          "format": "int64",
          "title": "total number of configurations"
        }
      }
    },
    "listExternalBucketsParams": {
      "required": [
        "accessKey",
        "secretKey",
        "targetURL",
        "useTLS"
      ],
      "properties": {
        "accessKey": {
          "type": "string",
          "minLength": 3
        },
        "region": {
          "type": "string"
        },
        "secretKey": {
          "type": "string",
          "minLength": 8
        },
        "targetURL": {
          "type": "string"
        },
        "useTLS": {
          "type": "boolean"
        }
      }
    },
    "listGroupsResponse": {
      "type": "object",
      "properties": {
        "groups": {
          "type": "array",
          "title": "list of groups",
          "items": {
            "type": "string"
          }
        },
        "total": {
          "type": "integer",
          "format": "int64",
          "title": "total number of groups"
        }
      }
    },
    "listObjectsResponse": {
      "type": "object",
      "properties": {
        "objects": {
          "type": "array",
          "title": "list of resulting objects",
          "items": {
            "$ref": "#/definitions/bucketObject"
          }
        },
        "total": {
          "type": "integer",
          "format": "int64",
          "title": "number of objects"
        }
      }
    },
    "listPoliciesResponse": {
      "type": "object",
      "properties": {
        "policies": {
          "type": "array",
          "title": "list of policies",
          "items": {
            "$ref": "#/definitions/policy"
          }
        },
        "total": {
          "type": "integer",
          "format": "int64",
          "title": "total number of policies"
        }
      }
    },
    "listRemoteBucketsResponse": {
      "type": "object",
      "properties": {
        "buckets": {
          "type": "array",
          "title": "list of remote buckets",
          "items": {
            "$ref": "#/definitions/remoteBucket"
          }
        },
        "total": {
          "type": "integer",
          "format": "int64",
          "title": "number of remote buckets accessible to user"
        }
      }
    },
    "listUsersResponse": {
      "type": "object",
      "properties": {
        "users": {
          "type": "array",
          "title": "list of resulting users",
          "items": {
            "$ref": "#/definitions/user"
          }
        }
      }
    },
    "logSearchResponse": {
      "type": "object",
      "properties": {
        "results": {
          "type": "object",
          "title": "list of log search responses"
        }
      }
    },
    "loginDetails": {
      "type": "object",
      "properties": {
        "animatedLogin": {
          "type": "boolean"
        },
        "isK8S": {
          "type": "boolean"
        },
        "loginStrategy": {
          "type": "string",
          "enum": [
            "form",
            "redirect",
            "service-account",
            "redirect-service-account"
          ]
        },
        "redirectRules": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/redirectRule"
          }
        }
      }
    },
    "loginOauth2AuthRequest": {
      "type": "object",
      "required": [
        "state",
        "code"
      ],
      "properties": {
        "code": {
          "type": "string"
        },
        "state": {
          "type": "string"
        }
      }
    },
    "loginRequest": {
      "type": "object",
      "properties": {
        "accessKey": {
          "type": "string"
        },
        "features": {
          "type": "object",
          "properties": {
            "hide_menu": {
              "type": "boolean"
            }
          }
        },
        "secretKey": {
          "type": "string"
        },
        "sts": {
          "type": "string"
        }
      }
    },
    "loginResponse": {
      "type": "object",
      "properties": {
        "IDPRefreshToken": {
          "type": "string"
        },
        "sessionId": {
          "type": "string"
        }
      }
    },
    "logoutRequest": {
      "type": "object",
      "properties": {
        "state": {
          "type": "string"
        }
      }
    },
    "makeBucketRequest": {
      "type": "object",
      "required": [
        "name"
      ],
      "properties": {
        "locking": {
          "type": "boolean"
        },
        "name": {
          "type": "string"
        },
        "quota": {
          "$ref": "#/definitions/setBucketQuota"
        },
        "retention": {
          "$ref": "#/definitions/putBucketRetentionRequest"
        },
        "versioning": {
          "$ref": "#/definitions/setBucketVersioning"
        }
      }
    },
    "makeBucketsResponse": {
      "type": "object",
      "properties": {
        "bucketName": {
          "type": "string"
        }
      }
    },
    "maxShareLinkExpResponse": {
      "type": "object",
      "required": [
        "exp"
      ],
      "properties": {
        "exp": {
          "type": "number",
          "format": "int64"
        }
      }
    },
    "metadata": {
      "type": "object",
      "properties": {
        "objectMetadata": {
          "type": "object",
          "additionalProperties": true
        }
      }
    },
    "multiBucketReplication": {
      "required": [
        "accessKey",
        "secretKey",
        "targetURL",
        "bucketsRelation"
      ],
      "properties": {
        "accessKey": {
          "type": "string",
          "minLength": 3
        },
        "bandwidth": {
          "type": "integer",
          "format": "int64"
        },
        "bucketsRelation": {
          "type": "array",
          "minLength": 1,
          "items": {
            "$ref": "#/definitions/multiBucketsRelation"
          }
        },
        "healthCheckPeriod": {
          "type": "integer",
          "format": "int32"
        },
        "prefix": {
          "type": "string"
        },
        "priority": {
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "region": {
          "type": "string"
        },
        "replicateDeleteMarkers": {
          "type": "boolean"
        },
        "replicateDeletes": {
          "type": "boolean"
        },
        "replicateExistingObjects": {
          "type": "boolean"
        },
        "replicateMetadata": {
          "type": "boolean"
        },
        "secretKey": {
          "type": "string",
          "minLength": 8
        },
        "storageClass": {
          "type": "string",
          "default": ""
        },
        "syncMode": {
          "type": "string",
          "default": "async",
          "enum": [
            "async",
            "sync"
          ]
        },
        "tags": {
          "type": "string"
        },
        "targetURL": {
          "type": "string"
        }
      }
    },
    "multiBucketReplicationEdit": {
      "properties": {
        "arn": {
          "type": "string"
        },
        "prefix": {
          "type": "string"
        },
        "priority": {
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "replicateDeleteMarkers": {
          "type": "boolean"
        },
        "replicateDeletes": {
          "type": "boolean"
        },
        "replicateExistingObjects": {
          "type": "boolean"
        },
        "replicateMetadata": {
          "type": "boolean"
        },
        "ruleState": {
          "type": "boolean"
        },
        "storageClass": {
          "type": "string",
          "default": ""
        },
        "tags": {
          "type": "string",
          "default": ""
        }
      }
    },
    "multiBucketResponseItem": {
      "type": "object",
      "properties": {
        "errorString": {
          "type": "string"
        },
        "originBucket": {
          "type": "string"
        },
        "targetBucket": {
          "type": "string"
        }
      }
    },
    "multiBucketResponseState": {
      "type": "object",
      "properties": {
        "replicationState": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/multiBucketResponseItem"
          }
        }
      }
    },
    "multiBucketsRelation": {
      "type": "object",
      "properties": {
        "destinationBucket": {
          "type": "string"
        },
        "originBucket": {
          "type": "string"
        }
      }
    },
    "multiLifecycleResult": {
      "properties": {
        "results": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/multicycleResultItem"
          }
        }
      }
    },
    "multicycleResultItem": {
      "type": "object",
      "properties": {
        "bucketName": {
          "type": "string"
        },
        "error": {
          "type": "string"
        }
      }
    },
    "nofiticationService": {
      "type": "string",
      "enum": [
        "webhook",
        "amqp",
        "kafka",
        "mqtt",
        "nats",
        "nsq",
        "mysql",
        "postgres",
        "elasticsearch",
        "redis"
      ]
    },
    "notifEndpointResponse": {
      "type": "object",
      "properties": {
        "notification_endpoints": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/notificationEndpointItem"
          }
        }
      }
    },
    "notificationConfig": {
      "type": "object",
      "required": [
        "arn"
      ],
      "properties": {
        "arn": {
          "type": "string"
        },
        "events": {
          "type": "array",
          "title": "filter specific type of event. Defaults to all event (default: '[put,delete,get]')",
          "items": {
            "$ref": "#/definitions/notificationEventType"
          }
        },
        "id": {
          "type": "string"
        },
        "prefix": {
          "type": "string",
          "title": "filter event associated to the specified prefix"
        },
        "suffix": {
          "type": "string",
          "title": "filter event associated to the specified suffix"
        }
      }
    },
    "notificationDeleteRequest": {
      "type": "object",
      "required": [
        "events",
        "prefix",
        "suffix"
      ],
      "properties": {
        "events": {
          "type": "array",
          "title": "filter specific type of event. Defaults to all event (default: '[put,delete,get]')",
          "minLength": 1,
          "items": {
            "$ref": "#/definitions/notificationEventType"
          }
        },
        "prefix": {
          "type": "string",
          "title": "filter event associated to the specified prefix"
        },
        "suffix": {
          "type": "string",
          "title": "filter event associated to the specified suffix"
        }
      }
    },
    "notificationEndpoint": {
      "type": "object",
      "required": [
        "service",
        "account_id",
        "properties"
      ],
      "properties": {
        "account_id": {
          "type": "string"
        },
        "properties": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "service": {
          "$ref": "#/definitions/nofiticationService"
        }
      }
    },
    "notificationEndpointItem": {
      "type": "object",
      "properties": {
        "account_id": {
          "type": "string"
        },
        "service": {
          "$ref": "#/definitions/nofiticationService"
        },
        "status": {
          "type": "string"
        }
      }
    },
    "notificationEventType": {
      "type": "string",
      "enum": [
        "put",
        "delete",
        "get",
        "replica",
        "ilm",
        "scanner"
      ]
    },
    "objectBucketLifecycle": {
      "type": "object",
      "properties": {
        "expiration": {
          "$ref": "#/definitions/expirationResponse"
        },
        "id": {
          "type": "string"
        },
        "prefix": {
          "type": "string"
        },
        "status": {
          "type": "string"
        },
        "tags": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/lifecycleTag"
          }
        },
        "transition": {
          "$ref": "#/definitions/transitionResponse"
        }
      }
    },
    "objectLegalHoldStatus": {
      "type": "string",
      "enum": [
        "enabled",
        "disabled"
      ]
    },
    "objectRetentionMode": {
      "type": "string",
      "enum": [
        "governance",
        "compliance"
      ]
    },
    "objectRetentionUnit": {
      "type": "string",
      "enum": [
        "days",
        "years"
      ]
    },
    "peerInfo": {
      "type": "object",
      "properties": {
        "deploymentID": {
          "type": "string"
        },
        "endpoint": {
          "type": "string"
        },
        "name": {
          "type": "string"
        }
      }
    },
    "peerInfoRemove": {
      "type": "object",
      "required": [
        "sites"
      ],
      "properties": {
        "all": {
          "type": "boolean"
        },
        "sites": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "peerSite": {
      "type": "object",
      "properties": {
        "accessKey": {
          "type": "string"
        },
        "endpoint": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "secretKey": {
          "type": "string"
        }
      }
    },
    "peerSiteEditResponse": {
      "type": "object",
      "properties": {
        "errorDetail": {
          "type": "string"
        },
        "status": {
          "type": "string"
        },
        "success": {
          "type": "boolean"
        }
      }
    },
    "peerSiteRemoveResponse": {
      "type": "object",
      "properties": {
        "errorDetail": {
          "type": "string"
        },
        "status": {
          "type": "string"
        }
      }
    },
    "permissionResource": {
      "type": "object",
      "properties": {
        "conditionOperator": {
          "type": "string"
        },
        "prefixes": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "resource": {
          "type": "string"
        }
      }
    },
    "policy": {
      "type": "object",
      "properties": {
        "name": {
          "type": "string"
        },
        "policy": {
          "type": "string"
        }
      }
    },
    "policyArgs": {
      "type": "object",
      "properties": {
        "action": {
          "type": "string"
        },
        "bucket_name": {
          "type": "string"
        },
        "id": {
          "type": "string"
        }
      }
    },
    "policyEntity": {
      "type": "string",
      "default": "user",
      "enum": [
        "user",
        "group"
      ]
    },
    "prefixAccessPair": {
      "type": "object",
      "properties": {
        "access": {
          "type": "string"
        },
        "prefix": {
          "type": "string"
        }
      }
    },
    "prefixWrapper": {
      "type": "object",
      "properties": {
        "prefix": {
          "type": "string"
        }
      }
    },
    "principal": {
      "type": "object",
      "properties": {
        "STSAccessKeyID": {
          "type": "string"
        },
        "STSSecretAccessKey": {
          "type": "string"
        },
        "STSSessionToken": {
          "type": "string"
        },
        "accountAccessKey": {
          "type": "string"
        },
        "customStyleOb": {
          "type": "string"
        },
        "hm": {
          "type": "boolean"
        },
        "ob": {
          "type": "boolean"
        }
      }
    },
    "profilingStartRequest": {
      "type": "object",
      "required": [
        "type"
      ],
      "properties": {
        "type": {
          "type": "string"
        }
      }
    },
    "putBucketRetentionRequest": {
      "type": "object",
      "required": [
        "mode",
        "unit",
        "validity"
      ],
      "properties": {
        "mode": {
          "$ref": "#/definitions/objectRetentionMode"
        },
        "unit": {
          "$ref": "#/definitions/objectRetentionUnit"
        },
        "validity": {
          "type": "integer",
          "format": "int32"
        }
      }
    },
    "putBucketTagsRequest": {
      "type": "object",
      "properties": {
        "tags": {
          "additionalProperties": {
            "type": "string"
          }
        }
      }
    },
    "putObjectLegalHoldRequest": {
      "type": "object",
      "required": [
        "status"
      ],
      "properties": {
        "status": {
          "$ref": "#/definitions/objectLegalHoldStatus"
        }
      }
    },
    "putObjectRetentionRequest": {
      "type": "object",
      "required": [
        "mode",
        "expires"
      ],
      "properties": {
        "expires": {
          "type": "string"
        },
        "governance_bypass": {
          "type": "boolean"
        },
        "mode": {
          "$ref": "#/definitions/objectRetentionMode"
        }
      }
    },
    "putObjectTagsRequest": {
      "type": "object",
      "properties": {
        "tags": {
          "additionalProperties": {
            "type": "string"
          }
        }
      }
    },
    "redirectRule": {
      "type": "object",
      "properties": {
        "displayName": {
          "type": "string"
        },
        "redirect": {
          "type": "string"
        },
        "serviceType": {
          "type": "string"
        }
      }
    },
    "releaseAuthor": {
      "type": "object",
      "properties": {
        "avatar_url": {
          "type": "string"
        },
        "events_url": {
          "type": "string"
        },
        "followers_url": {
          "type": "string"
        },
        "following_url": {
          "type": "string"
        },
        "gists_url": {
          "type": "string"
        },
        "gravatar_id": {
          "type": "string"
        },
        "html_url": {
          "type": "string"
        },
        "id": {
          "type": "integer"
        },
        "login": {
          "type": "string"
        },
        "node_id": {
          "type": "string"
        },
        "organizations_url": {
          "type": "string"
        },
        "receivedEvents_url": {
          "type": "string"
        },
        "repos_url": {
          "type": "string"
        },
        "site_admin": {
          "type": "boolean"
        },
        "starred_url": {
          "type": "string"
        },
        "subscriptions_url": {
          "type": "string"
        },
        "type": {
          "type": "string"
        },
        "url": {
          "type": "string"
        }
      }
    },
    "releaseInfo": {
      "type": "object",
      "properties": {
        "breakingChangesContent": {
          "type": "string"
        },
        "contextContent": {
          "type": "string"
        },
        "metadata": {
          "$ref": "#/definitions/releaseMetadata"
        },
        "newFeaturesContent": {
          "type": "string"
        },
        "notesContent": {
          "type": "string"
        },
        "securityContent": {
          "type": "string"
        }
      }
    },
    "releaseListResponse": {
      "type": "object",
      "properties": {
        "results": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/releaseInfo"
          }
        }
      }
    },
    "releaseMetadata": {
      "type": "object",
      "properties": {
        "assets_url": {
          "type": "string"
        },
        "author": {
          "$ref": "#/definitions/releaseAuthor"
        },
        "created_at": {
          "type": "string"
        },
        "draft": {
          "type": "boolean"
        },
        "html_url": {
          "type": "string"
        },
        "id": {
          "type": "integer"
        },
        "name": {
          "type": "string"
        },
        "node_id": {
          "type": "string"
        },
        "prerelease": {
          "type": "boolean"
        },
        "published_at": {
          "type": "string"
        },
        "tag_name": {
          "type": "string"
        },
        "tarball_url": {
          "type": "string"
        },
        "target_commitish": {
          "type": "string"
        },
        "upload_url": {
          "type": "string"
        },
        "url": {
          "type": "string"
        },
        "zipball_url": {
          "type": "string"
        }
      }
    },
    "remoteBucket": {
      "type": "object",
      "required": [
        "accessKey",
        "sourceBucket",
        "remoteARN"
      ],
      "properties": {
        "accessKey": {
          "type": "string",
          "minLength": 3
        },
        "bandwidth": {
          "type": "integer",
          "format": "int64"
        },
        "healthCheckPeriod": {
          "type": "integer"
        },
        "remoteARN": {
          "type": "string"
        },
        "secretKey": {
          "type": "string",
          "minLength": 8
        },
        "service": {
          "type": "string",
          "enum": [
            "replication"
          ]
        },
        "sourceBucket": {
          "type": "string"
        },
        "status": {
          "type": "string"
        },
        "syncMode": {
          "type": "string"
        },
        "targetBucket": {
          "type": "string"
        },
        "targetURL": {
          "type": "string"
        }
      }
    },
    "resultTarget": {
      "type": "object",
      "properties": {
        "legendFormat": {
          "type": "string"
        },
        "result": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/widgetResult"
          }
        },
        "resultType": {
          "type": "string"
        }
      }
    },
    "rewindItem": {
      "type": "object",
      "properties": {
        "action": {
          "type": "string"
        },
        "delete_flag": {
          "type": "boolean"
        },
        "is_latest": {
          "type": "boolean"
        },
        "last_modified": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "size": {
          "type": "integer",
          "format": "int64"
        },
        "version_id": {
          "type": "string"
        }
      }
    },
    "rewindResponse": {
      "type": "object",
      "properties": {
        "objects": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/rewindItem"
          }
        }
      }
    },
    "selectedSAs": {
      "type": "array",
      "items": {
        "type": "string"
      }
    },
    "selectedUsers": {
      "type": "array",
      "items": {
        "type": "string"
      }
    },
    "serverDrives": {
      "type": "object",
      "properties": {
        "availableSpace": {
          "type": "integer"
        },
        "drivePath": {
          "type": "string"
        },
        "endpoint": {
          "type": "string"
        },
        "healing": {
          "type": "boolean"
        },
        "model": {
          "type": "string"
        },
        "rootDisk": {
          "type": "boolean"
        },
        "state": {
          "type": "string"
        },
        "totalSpace": {
          "type": "integer"
        },
        "usedSpace": {
          "type": "integer"
        },
        "uuid": {
          "type": "string"
        }
      }
    },
    "serverProperties": {
      "type": "object",
      "properties": {
        "commitID": {
          "type": "string"
        },
        "drives": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/serverDrives"
          }
        },
        "endpoint": {
          "type": "string"
        },
        "network": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "poolNumber": {
          "type": "integer"
        },
        "state": {
          "type": "string"
        },
        "uptime": {
          "type": "integer"
        },
        "version": {
          "type": "string"
        }
      }
    },
    "serviceAccount": {
      "type": "object",
      "properties": {
        "accountStatus": {
          "type": "string"
        },
        "description": {
          "type": "string"
        },
        "expiration": {
          "type": "string"
        },
        "impliedPolicy": {
          "type": "boolean"
        },
        "name": {
          "type": "string"
        },
        "parentUser": {
          "type": "string"
        },
        "policy": {
          "type": "string"
        }
      }
    },
    "serviceAccountCreds": {
      "type": "object",
      "properties": {
        "accessKey": {
          "type": "string"
        },
        "secretKey": {
          "type": "string"
        },
        "url": {
          "type": "string"
        }
      }
    },
    "serviceAccountRequest": {
      "type": "object",
      "properties": {
        "comment": {
          "type": "string"
        },
        "description": {
          "type": "string"
        },
        "expiry": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "policy": {
          "type": "string",
          "title": "policy to be applied to the Service Account if any"
        }
      }
    },
    "serviceAccountRequestCreds": {
      "type": "object",
      "properties": {
        "accessKey": {
          "type": "string"
        },
        "comment": {
          "type": "string"
        },
        "description": {
          "type": "string"
        },
        "expiry": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "policy": {
          "type": "string",
          "title": "policy to be applied to the Service Account if any"
        },
        "secretKey": {
          "type": "string"
        }
      }
    },
    "serviceAccounts": {
      "type": "array",
      "items": {
        "type": "object",
        "properties": {
          "accessKey": {
            "type": "string"
          },
          "accountStatus": {
            "type": "string"
          },
          "description": {
            "type": "string"
          },
          "expiration": {
            "type": "string"
          },
          "name": {
            "type": "string"
          }
        }
      }
    },
    "sessionResponse": {
      "type": "object",
      "properties": {
        "allowResources": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/permissionResource"
          }
        },
        "customStyles": {
          "type": "string"
        },
        "distributedMode": {
          "type": "boolean"
        },
        "envConstants": {
          "$ref": "#/definitions/environmentConstants"
        },
        "features": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "operator": {
          "type": "boolean"
        },
        "permissions": {
          "type": "object",
          "additionalProperties": {
            "type": "array",
            "items": {
              "type": "string"
            }
          }
        },
        "serverEndPoint": {
          "type": "string"
        },
        "status": {
          "type": "string",
          "enum": [
            "ok"
          ]
        }
      }
    },
    "setBucketPolicyRequest": {
      "type": "object",
      "required": [
        "access"
      ],
      "properties": {
        "access": {
          "$ref": "#/definitions/bucketAccess"
        },
        "definition": {
          "type": "string"
        }
      }
    },
    "setBucketQuota": {
      "type": "object",
      "required": [
        "enabled"
      ],
      "properties": {
        "amount": {
          "type": "integer"
        },
        "enabled": {
          "type": "boolean"
        },
        "quota_type": {
          "type": "string",
          "enum": [
            "hard"
          ]
        }
      }
    },
    "setBucketVersioning": {
      "type": "object",
      "properties": {
        "enabled": {
          "type": "boolean"
        },
        "excludeFolders": {
          "type": "boolean"
        },
        "excludePrefixes": {
          "type": "array",
          "maxLength": 10,
          "items": {
            "type": "string"
          }
        }
      }
    },
    "setConfigRequest": {
      "type": "object",
      "required": [
        "key_values"
      ],
      "properties": {
        "arn_resource_id": {
          "type": "string",
          "title": "Used if configuration is an event notification's target"
        },
        "key_values": {
          "type": "array",
          "minItems": 1,
          "items": {
            "$ref": "#/definitions/configurationKV"
          }
        }
      }
    },
    "setConfigResponse": {
      "type": "object",
      "properties": {
        "restart": {
          "description": "Returns wheter server needs to restart to apply changes or not",
          "type": "boolean"
        }
      }
    },
    "setIDPResponse": {
      "type": "object",
      "properties": {
        "restart": {
          "type": "boolean"
        }
      }
    },
    "setNotificationEndpointResponse": {
      "type": "object",
      "required": [
        "service",
        "account_id",
        "properties"
      ],
      "properties": {
        "account_id": {
          "type": "string"
        },
        "properties": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "restart": {
          "type": "boolean"
        },
        "service": {
          "$ref": "#/definitions/nofiticationService"
        }
      }
    },
    "setPolicyMultipleNameRequest": {
      "type": "object",
      "properties": {
        "groups": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/iamEntity"
          }
        },
        "name": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "users": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/iamEntity"
          }
        }
      }
    },
    "setPolicyNameRequest": {
      "type": "object",
      "required": [
        "name",
        "entityType",
        "entityName"
      ],
      "properties": {
        "entityName": {
          "type": "string"
        },
        "entityType": {
          "$ref": "#/definitions/policyEntity"
        },
        "name": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "setPolicyRequest": {
      "type": "object",
      "required": [
        "entityType",
        "entityName"
      ],
      "properties": {
        "entityName": {
          "type": "string"
        },
        "entityType": {
          "$ref": "#/definitions/policyEntity"
        }
      }
    },
    "siteReplicationAddRequest": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/peerSite"
      }
    },
    "siteReplicationAddResponse": {
      "type": "object",
      "properties": {
        "errorDetail": {
          "type": "string"
        },
        "initialSyncErrorMessage": {
          "type": "string"
        },
        "status": {
          "type": "string"
        },
        "success": {
          "type": "boolean"
        }
      }
    },
    "siteReplicationInfoResponse": {
      "type": "object",
      "properties": {
        "enabled": {
          "type": "boolean"
        },
        "name": {
          "type": "string"
        },
        "serviceAccountAccessKey": {
          "type": "string"
        },
        "sites": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/peerInfo"
          }
        }
      }
    },
    "siteReplicationStatusResponse": {
      "type": "object",
      "properties": {
        "bucketStats": {
          "type": "object"
        },
        "enabled": {
          "type": "boolean"
        },
        "groupStats": {
          "type": "object"
        },
        "maxBuckets": {
          "type": "integer"
        },
        "maxGroups": {
          "type": "integer"
        },
        "maxPolicies": {
          "type": "integer"
        },
        "maxUsers": {
          "type": "integer"
        },
        "policyStats": {
          "type": "object"
        },
        "sites": {
          "type": "object"
        },
        "statsSummary": {
          "type": "object"
        },
        "userStats": {
          "type": "object"
        }
      }
    },
    "startProfilingItem": {
      "type": "object",
      "properties": {
        "error": {
          "type": "string"
        },
        "nodeName": {
          "type": "string"
        },
        "success": {
          "type": "boolean"
        }
      }
    },
    "startProfilingList": {
      "type": "object",
      "properties": {
        "startResults": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/startProfilingItem"
          }
        },
        "total": {
          "type": "integer",
          "format": "int64",
          "title": "number of start results"
        }
      }
    },
    "subnetLoginMFARequest": {
      "type": "object",
      "required": [
        "username",
        "otp",
        "mfa_token"
      ],
      "properties": {
        "mfa_token": {
          "type": "string"
        },
        "otp": {
          "type": "string"
        },
        "username": {
          "type": "string"
        }
      }
    },
    "subnetLoginRequest": {
      "type": "object",
      "properties": {
        "apiKey": {
          "type": "string"
        },
        "password": {
          "type": "string"
        },
        "username": {
          "type": "string"
        }
      }
    },
    "subnetLoginResponse": {
      "type": "object",
      "properties": {
        "access_token": {
          "type": "string"
        },
        "mfa_token": {
          "type": "string"
        },
        "organizations": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/subnetOrganization"
          }
        },
        "registered": {
          "type": "boolean"
        }
      }
    },
    "subnetOrganization": {
      "type": "object",
      "properties": {
        "accountId": {
          "type": "integer"
        },
        "company": {
          "type": "string"
        },
        "isAccountOwner": {
          "type": "boolean"
        },
        "shortName": {
          "type": "string"
        },
        "subscriptionStatus": {
          "type": "string"
        },
        "userId": {
          "type": "integer"
        }
      }
    },
    "subnetRegisterRequest": {
      "type": "object",
      "required": [
        "token",
        "account_id"
      ],
      "properties": {
        "account_id": {
          "type": "string"
        },
        "token": {
          "type": "string"
        }
      }
    },
    "tier": {
      "type": "object",
      "properties": {
        "azure": {
          "type": "object",
          "$ref": "#/definitions/tier_azure"
        },
        "gcs": {
          "type": "object",
          "$ref": "#/definitions/tier_gcs"
        },
        "minio": {
          "type": "object",
          "$ref": "#/definitions/tier_minio"
        },
        "s3": {
          "type": "object",
          "$ref": "#/definitions/tier_s3"
        },
        "status": {
          "type": "boolean"
        },
        "type": {
          "type": "string",
          "enum": [
            "s3",
            "gcs",
            "azure",
            "minio",
            "unsupported"
          ]
        }
      }
    },
    "tierCredentialsRequest": {
      "type": "object",
      "properties": {
        "access_key": {
          "type": "string"
        },
        "creds": {
          "description": "a base64 encoded value",
          "type": "string"
        },
        "secret_key": {
          "type": "string"
        }
      }
    },
    "tierListResponse": {
      "type": "object",
      "properties": {
        "items": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/tier"
          }
        }
      }
    },
    "tier_azure": {
      "type": "object",
      "properties": {
        "accountkey": {
          "type": "string"
        },
        "accountname": {
          "type": "string"
        },
        "bucket": {
          "type": "string"
        },
        "endpoint": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "objects": {
          "type": "string"
        },
        "prefix": {
          "type": "string"
        },
        "region": {
          "type": "string"
        },
        "usage": {
          "type": "string"
        },
        "versions": {
          "type": "string"
        }
      }
    },
    "tier_gcs": {
      "type": "object",
      "properties": {
        "bucket": {
          "type": "string"
        },
        "creds": {
          "type": "string"
        },
        "endpoint": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "objects": {
          "type": "string"
        },
        "prefix": {
          "type": "string"
        },
        "region": {
          "type": "string"
        },
        "usage": {
          "type": "string"
        },
        "versions": {
          "type": "string"
        }
      }
    },
    "tier_minio": {
      "type": "object",
      "properties": {
        "accesskey": {
          "type": "string"
        },
        "bucket": {
          "type": "string"
        },
        "endpoint": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "objects": {
          "type": "string"
        },
        "prefix": {
          "type": "string"
        },
        "region": {
          "type": "string"
        },
        "secretkey": {
          "type": "string"
        },
        "storageclass": {
          "type": "string"
        },
        "usage": {
          "type": "string"
        },
        "versions": {
          "type": "string"
        }
      }
    },
    "tier_s3": {
      "type": "object",
      "properties": {
        "accesskey": {
          "type": "string"
        },
        "bucket": {
          "type": "string"
        },
        "endpoint": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "objects": {
          "type": "string"
        },
        "prefix": {
          "type": "string"
        },
        "region": {
          "type": "string"
        },
        "secretkey": {
          "type": "string"
        },
        "storageclass": {
          "type": "string"
        },
        "usage": {
          "type": "string"
        },
        "versions": {
          "type": "string"
        }
      }
    },
    "transitionResponse": {
      "type": "object",
      "properties": {
        "date": {
          "type": "string"
        },
        "days": {
          "type": "integer",
          "format": "int64"
        },
        "noncurrent_storage_class": {
          "type": "string"
        },
        "noncurrent_transition_days": {
          "type": "integer",
          "format": "int64"
        },
        "storage_class": {
          "type": "string"
        }
      }
    },
    "updateBucketLifecycle": {
      "type": "object",
      "required": [
        "type"
      ],
      "properties": {
        "disable": {
          "description": "Non required, toggle to disable or enable rule",
          "type": "boolean"
        },
        "expired_object_delete_all": {
          "description": "Non required, toggle to disable or enable rule",
          "type": "boolean"
        },
        "expired_object_delete_marker": {
          "description": "Non required, toggle to disable or enable rule",
          "type": "boolean"
        },
        "expiry_days": {
          "description": "Required in case of expiry_date or transition fields are not set. it defines an expiry days for ILM",
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "noncurrentversion_expiration_days": {
          "description": "Non required, can be set in case of expiration is enabled",
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "noncurrentversion_transition_days": {
          "description": "Non required, can be set in case of transition is enabled",
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "noncurrentversion_transition_storage_class": {
          "description": "Non required, can be set in case of transition is enabled",
          "type": "string"
        },
        "prefix": {
          "description": "Non required field, it matches a prefix to perform ILM operations on it",
          "type": "string"
        },
        "storage_class": {
          "description": "Required only in case of transition is set. it refers to a tier",
          "type": "string"
        },
        "tags": {
          "description": "Non required field, tags to match ILM files",
          "type": "string"
        },
        "transition_days": {
          "description": "Required in case of transition_date or expiry fields are not set. it defines a transition days for ILM",
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "type": {
          "description": "ILM Rule type (Expiry or transition)",
          "type": "string",
          "enum": [
            "expiry",
            "transition"
          ]
        }
      }
    },
    "updateGroupRequest": {
      "type": "object",
      "required": [
        "members",
        "status"
      ],
      "properties": {
        "members": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "status": {
          "type": "string"
        }
      }
    },
    "updateServiceAccountRequest": {
      "type": "object",
      "required": [
        "policy"
      ],
      "properties": {
        "description": {
          "type": "string"
        },
        "expiry": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "policy": {
          "type": "string"
        },
        "secretKey": {
          "type": "string"
        },
        "status": {
          "type": "string"
        }
      }
    },
    "updateUser": {
      "type": "object",
      "required": [
        "status",
        "groups"
      ],
      "properties": {
        "groups": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "status": {
          "type": "string"
        }
      }
    },
    "updateUserGroups": {
      "type": "object",
      "required": [
        "groups"
      ],
      "properties": {
        "groups": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "user": {
      "type": "object",
      "properties": {
        "accessKey": {
          "type": "string"
        },
        "hasPolicy": {
          "type": "boolean"
        },
        "memberOf": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "policy": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "status": {
          "type": "string"
        }
      }
    },
    "userSAs": {
      "type": "object",
      "properties": {
        "path": {
          "type": "string"
        },
        "recursive": {
          "type": "boolean"
        },
        "versionID": {
          "type": "string"
        }
      }
    },
    "userServiceAccountItem": {
      "type": "object",
      "properties": {
        "numSAs": {
          "type": "integer",
          "format": "int64"
        },
        "userName": {
          "type": "string"
        }
      }
    },
    "userServiceAccountSummary": {
      "type": "object",
      "properties": {
        "hasSA": {
          "type": "boolean"
        },
        "userServiceAccountList": {
          "type": "array",
          "title": "list of users with number of service accounts",
          "items": {
            "$ref": "#/definitions/userServiceAccountItem"
          }
        }
      }
    },
    "widget": {
      "type": "object",
      "properties": {
        "id": {
          "type": "integer",
          "format": "int32"
        },
        "options": {
          "type": "object",
          "properties": {
            "reduceOptions": {
              "type": "object",
              "properties": {
                "calcs": {
                  "type": "array",
                  "items": {
                    "type": "string"
                  }
                }
              }
            }
          }
        },
        "targets": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/resultTarget"
          }
        },
        "title": {
          "type": "string"
        },
        "type": {
          "type": "string"
        }
      }
    },
    "widgetDetails": {
      "type": "object",
      "properties": {
        "id": {
          "type": "integer",
          "format": "int32"
        },
        "options": {
          "type": "object",
          "properties": {
            "reduceOptions": {
              "type": "object",
              "properties": {
                "calcs": {
                  "type": "array",
                  "items": {
                    "type": "string"
                  }
                }
              }
            }
          }
        },
        "targets": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/resultTarget"
          }
        },
        "title": {
          "type": "string"
        },
        "type": {
          "type": "string"
        }
      }
    },
    "widgetResult": {
      "type": "object",
      "properties": {
        "metric": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "values": {
          "type": "array",
          "items": {}
        }
      }
    }
  },
  "parameters": {
    "limit": {
      "type": "number",
      "format": "int32",
      "default": 20,
      "name": "limit",
      "in": "query"
    },
    "offset": {
      "type": "number",
      "format": "int32",
      "default": 0,
      "name": "offset",
      "in": "query"
    }
  },
  "securityDefinitions": {
    "anonymous": {
      "type": "apiKey",
      "name": "X-Anonymous",
      "in": "header"
    },
    "key": {
      "type": "oauth2",
      "flow": "accessCode",
      "authorizationUrl": "http://min.io",
      "tokenUrl": "http://min.io"
    }
  },
  "security": [
    {
      "key": []
    }
  ]
}`))
	FlatSwaggerJSON = json.RawMessage([]byte(`{
  "consumes": [
    "application/json"
  ],
  "produces": [
    "application/json"
  ],
  "schemes": [
    "http",
    "ws"
  ],
  "swagger": "2.0",
  "info": {
    "title": "MinIO Console Server",
    "version": "0.1.0"
  },
  "basePath": "/api/v1",
  "paths": {
    "/account/change-password": {
      "post": {
        "tags": [
          "Account"
        ],
        "summary": "Change password of currently logged in user.",
        "operationId": "AccountChangePassword",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/accountChangePasswordRequest"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful login."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/account/change-user-password": {
      "post": {
        "tags": [
          "Account"
        ],
        "summary": "Change password of currently logged in user.",
        "operationId": "ChangeUserPassword",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/changeUserPasswordRequest"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Password successfully changed."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/admin/arns": {
      "get": {
        "tags": [
          "System"
        ],
        "summary": "Returns a list of active ARNs in the instance",
        "operationId": "ArnList",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/arnsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/admin/info": {
      "get": {
        "tags": [
          "System"
        ],
        "summary": "Returns information about the deployment",
        "operationId": "AdminInfo",
        "parameters": [
          {
            "type": "boolean",
            "default": false,
            "name": "defaultOnly",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/adminInfoResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/admin/info/widgets/{widgetId}": {
      "get": {
        "tags": [
          "System"
        ],
        "summary": "Returns information about the deployment",
        "operationId": "DashboardWidgetDetails",
        "parameters": [
          {
            "type": "integer",
            "format": "int32",
            "name": "widgetId",
            "in": "path",
            "required": true
          },
          {
            "type": "integer",
            "name": "start",
            "in": "query"
          },
          {
            "type": "integer",
            "name": "end",
            "in": "query"
          },
          {
            "type": "integer",
            "format": "int32",
            "name": "step",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/widgetDetails"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/admin/inspect": {
      "get": {
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "Inspect"
        ],
        "summary": "Inspect Files on Drive",
        "operationId": "Inspect",
        "parameters": [
          {
            "type": "string",
            "name": "file",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "name": "volume",
            "in": "query",
            "required": true
          },
          {
            "type": "boolean",
            "name": "encrypt",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "file"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/admin/notification_endpoints": {
      "get": {
        "tags": [
          "Configuration"
        ],
        "summary": "Returns a list of active notification endpoints",
        "operationId": "NotificationEndpointList",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/notifEndpointResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Configuration"
        ],
        "summary": "Allows to configure a new notification endpoint",
        "operationId": "AddNotificationEndpoint",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/notificationEndpoint"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/setNotificationEndpointResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/admin/site-replication": {
      "get": {
        "tags": [
          "SiteReplication"
        ],
        "summary": "Get list of Replication Sites",
        "operationId": "GetSiteReplicationInfo",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/siteReplicationInfoResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "put": {
        "tags": [
          "SiteReplication"
        ],
        "summary": "Edit a Replication Site",
        "operationId": "SiteReplicationEdit",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/peerInfo"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/peerSiteEditResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "tags": [
          "SiteReplication"
        ],
        "summary": "Add a Replication Site",
        "operationId": "SiteReplicationInfoAdd",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/siteReplicationAddRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/siteReplicationAddResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "SiteReplication"
        ],
        "summary": "Remove a Replication Site",
        "operationId": "SiteReplicationRemove",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/peerInfoRemove"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/peerSiteRemoveResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/admin/site-replication/status": {
      "get": {
        "tags": [
          "SiteReplication"
        ],
        "summary": "Display overall site replication status",
        "operationId": "GetSiteReplicationStatus",
        "parameters": [
          {
            "type": "boolean",
            "default": true,
            "description": "Include Bucket stats",
            "name": "buckets",
            "in": "query"
          },
          {
            "type": "boolean",
            "default": true,
            "description": "Include Group stats",
            "name": "groups",
            "in": "query"
          },
          {
            "type": "boolean",
            "default": true,
            "description": "Include Policies stats",
            "name": "policies",
            "in": "query"
          },
          {
            "type": "boolean",
            "default": true,
            "description": "Include Policies stats",
            "name": "users",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Entity Type to lookup",
            "name": "entityType",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Entity Value to lookup",
            "name": "entityValue",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/siteReplicationStatusResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/admin/tiers": {
      "get": {
        "tags": [
          "Tiering"
        ],
        "summary": "Returns a list of tiers for ilm",
        "operationId": "TiersList",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/tierListResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Tiering"
        ],
        "summary": "Allows to configure a new tier",
        "operationId": "AddTier",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/tier"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/admin/tiers/{type}/{name}": {
      "get": {
        "tags": [
          "Tiering"
        ],
        "summary": "Get Tier",
        "operationId": "GetTier",
        "parameters": [
          {
            "enum": [
              "s3",
              "gcs",
              "azure",
              "minio"
            ],
            "type": "string",
            "name": "type",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/tier"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/admin/tiers/{type}/{name}/credentials": {
      "put": {
        "tags": [
          "Tiering"
        ],
        "summary": "Edit Tier Credentials",
        "operationId": "EditTierCredentials",
        "parameters": [
          {
            "enum": [
              "s3",
              "gcs",
              "azure",
              "minio"
            ],
            "type": "string",
            "name": "type",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/tierCredentialsRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/bucket-policy/{bucket}": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "List Policies With Given Bucket",
        "operationId": "ListPoliciesWithBucket",
        "parameters": [
          {
            "type": "string",
            "name": "bucket",
            "in": "path",
            "required": true
          },
          {
            "type": "number",
            "format": "int32",
            "default": 0,
            "name": "offset",
            "in": "query"
          },
          {
            "type": "number",
            "format": "int32",
            "default": 20,
            "name": "limit",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listPoliciesResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/bucket-users/{bucket}": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "List Users With Access to a Given Bucket",
        "operationId": "ListUsersWithAccessToBucket",
        "parameters": [
          {
            "type": "string",
            "name": "bucket",
            "in": "path",
            "required": true
          },
          {
            "type": "number",
            "format": "int32",
            "default": 0,
            "name": "offset",
            "in": "query"
          },
          {
            "type": "number",
            "format": "int32",
            "default": 20,
            "name": "limit",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/bucket/{bucket}/access-rules": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "List Access Rules With Given Bucket",
        "operationId": "ListAccessRulesWithBucket",
        "parameters": [
          {
            "type": "string",
            "name": "bucket",
            "in": "path",
            "required": true
          },
          {
            "type": "number",
            "format": "int32",
            "default": 0,
            "name": "offset",
            "in": "query"
          },
          {
            "type": "number",
            "format": "int32",
            "default": 20,
            "name": "limit",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listAccessRulesResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Bucket"
        ],
        "summary": "Add Access Rule To Given Bucket",
        "operationId": "SetAccessRuleWithBucket",
        "parameters": [
          {
            "type": "string",
            "name": "bucket",
            "in": "path",
            "required": true
          },
          {
            "name": "prefixaccess",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/prefixAccessPair"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "boolean"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Bucket"
        ],
        "summary": "Delete Access Rule From Given Bucket",
        "operationId": "DeleteAccessRuleWithBucket",
        "parameters": [
          {
            "type": "string",
            "name": "bucket",
            "in": "path",
            "required": true
          },
          {
            "name": "prefix",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/prefixWrapper"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "boolean"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "List Buckets",
        "operationId": "ListBuckets",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listBucketsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Bucket"
        ],
        "summary": "Make bucket",
        "operationId": "MakeBucket",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/makeBucketRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/makeBucketsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets-replication": {
      "post": {
        "tags": [
          "Bucket"
        ],
        "summary": "Sets Multi Bucket Replication in multiple Buckets",
        "operationId": "SetMultiBucketReplication",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/multiBucketReplication"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/multiBucketResponseState"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/max-share-exp": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "Get max expiration time for share link in seconds",
        "operationId": "GetMaxShareLinkExp",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/maxShareLinkExpResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/multi-lifecycle": {
      "post": {
        "tags": [
          "Bucket"
        ],
        "summary": "Add Multi Bucket Lifecycle",
        "operationId": "AddMultiBucketLifecycle",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/addMultiBucketLifecycle"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/multiLifecycleResult"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/delete-all-replication-rules": {
      "delete": {
        "tags": [
          "Bucket"
        ],
        "summary": "Deletes all replication rules from a bucket",
        "operationId": "DeleteAllReplicationRules",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/delete-objects": {
      "post": {
        "tags": [
          "Object"
        ],
        "summary": "Delete Multiple Objects",
        "operationId": "DeleteMultipleObjects",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "name": "all_versions",
            "in": "query"
          },
          {
            "type": "boolean",
            "name": "bypass",
            "in": "query"
          },
          {
            "name": "files",
            "in": "body",
            "required": true,
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/deleteFile"
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/delete-selected-replication-rules": {
      "delete": {
        "tags": [
          "Bucket"
        ],
        "summary": "Deletes selected replication rules from a bucket",
        "operationId": "DeleteSelectedReplicationRules",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "name": "rules",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/bucketReplicationRuleList"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/encryption/disable": {
      "post": {
        "tags": [
          "Bucket"
        ],
        "summary": "Disable bucket encryption.",
        "operationId": "DisableBucketEncryption",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/encryption/enable": {
      "post": {
        "tags": [
          "Bucket"
        ],
        "summary": "Enable bucket encryption.",
        "operationId": "EnableBucketEncryption",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/bucketEncryptionRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/encryption/info": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "Get bucket encryption information.",
        "operationId": "GetBucketEncryptionInfo",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/bucketEncryptionInfo"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/events": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "List Bucket Events",
        "operationId": "ListBucketEvents",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "number",
            "format": "int32",
            "default": 0,
            "name": "offset",
            "in": "query"
          },
          {
            "type": "number",
            "format": "int32",
            "default": 20,
            "name": "limit",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listBucketEventsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Bucket"
        ],
        "summary": "Create Bucket Event",
        "operationId": "CreateBucketEvent",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/bucketEventRequest"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/events/{arn}": {
      "delete": {
        "tags": [
          "Bucket"
        ],
        "summary": "Delete Bucket Event",
        "operationId": "DeleteBucketEvent",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "arn",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/notificationDeleteRequest"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/lifecycle": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "Bucket Lifecycle",
        "operationId": "GetBucketLifecycle",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/bucketLifecycleResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Bucket"
        ],
        "summary": "Add Bucket Lifecycle",
        "operationId": "AddBucketLifecycle",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/addBucketLifecycle"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/lifecycle/{lifecycle_id}": {
      "put": {
        "tags": [
          "Bucket"
        ],
        "summary": "Update Lifecycle rule",
        "operationId": "UpdateBucketLifecycle",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "lifecycle_id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/updateBucketLifecycle"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Bucket"
        ],
        "summary": "Delete Lifecycle rule",
        "operationId": "DeleteBucketLifecycleRule",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "lifecycle_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/object-locking": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "Returns the status of object locking support on the bucket",
        "operationId": "GetBucketObjectLockingStatus",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/bucketObLockingResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/objects": {
      "get": {
        "security": [
          {
            "key": []
          },
          {
            "anonymous": []
          }
        ],
        "tags": [
          "Object"
        ],
        "summary": "List Objects",
        "operationId": "ListObjects",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "prefix",
            "in": "query"
          },
          {
            "type": "boolean",
            "name": "recursive",
            "in": "query"
          },
          {
            "type": "boolean",
            "name": "with_versions",
            "in": "query"
          },
          {
            "type": "boolean",
            "name": "with_metadata",
            "in": "query"
          },
          {
            "type": "number",
            "format": "int32",
            "default": 20,
            "name": "limit",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listObjectsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Object"
        ],
        "summary": "Delete Object",
        "operationId": "DeleteObject",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "prefix",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "name": "version_id",
            "in": "query"
          },
          {
            "type": "boolean",
            "name": "recursive",
            "in": "query"
          },
          {
            "type": "boolean",
            "name": "all_versions",
            "in": "query"
          },
          {
            "type": "boolean",
            "name": "non_current_versions",
            "in": "query"
          },
          {
            "type": "boolean",
            "name": "bypass",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/objects/download": {
      "get": {
        "security": [
          {
            "key": []
          },
          {
            "anonymous": []
          }
        ],
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "Object"
        ],
        "summary": "Download Object",
        "operationId": "Download Object",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "prefix",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "name": "version_id",
            "in": "query"
          },
          {
            "type": "boolean",
            "default": false,
            "name": "preview",
            "in": "query"
          },
          {
            "type": "string",
            "default": "",
            "name": "override_file_name",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "file"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/objects/download-multiple": {
      "post": {
        "security": [
          {
            "key": []
          },
          {
            "anonymous": []
          }
        ],
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "Object"
        ],
        "summary": "Download Multiple Objects",
        "operationId": "DownloadMultipleObjects",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "name": "objectList",
            "in": "body",
            "required": true,
            "schema": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "file"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/objects/legalhold": {
      "put": {
        "tags": [
          "Object"
        ],
        "summary": "Put Object's legalhold status",
        "operationId": "PutObjectLegalHold",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "prefix",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "name": "version_id",
            "in": "query",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/putObjectLegalHoldRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/objects/metadata": {
      "get": {
        "tags": [
          "Object"
        ],
        "summary": "Gets the metadata of an object",
        "operationId": "GetObjectMetadata",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "prefix",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "name": "versionID",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/metadata"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/objects/restore": {
      "put": {
        "tags": [
          "Object"
        ],
        "summary": "Restore Object to a selected version",
        "operationId": "PutObjectRestore",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "prefix",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "name": "version_id",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/objects/retention": {
      "put": {
        "tags": [
          "Object"
        ],
        "summary": "Put Object's retention status",
        "operationId": "PutObjectRetention",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "prefix",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "name": "version_id",
            "in": "query",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/putObjectRetentionRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Object"
        ],
        "summary": "Delete Object retention from an object",
        "operationId": "DeleteObjectRetention",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "prefix",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "name": "version_id",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/objects/share": {
      "get": {
        "tags": [
          "Object"
        ],
        "summary": "Shares an Object on a url",
        "operationId": "ShareObject",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "prefix",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "name": "version_id",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "name": "expires",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "string"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/objects/tags": {
      "put": {
        "tags": [
          "Object"
        ],
        "summary": "Put Object's tags",
        "operationId": "PutObjectTags",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "prefix",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "name": "version_id",
            "in": "query",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/putObjectTagsRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/objects/upload": {
      "post": {
        "security": [
          {
            "key": []
          },
          {
            "anonymous": []
          }
        ],
        "consumes": [
          "multipart/form-data"
        ],
        "tags": [
          "Object"
        ],
        "summary": "Uploads an Object.",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "prefix",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/replication": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "Bucket Replication",
        "operationId": "GetBucketReplication",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/bucketReplicationResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/replication/{rule_id}": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "Bucket Replication",
        "operationId": "GetBucketReplicationRule",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "rule_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/bucketReplicationRule"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Bucket"
        ],
        "summary": "Update Replication rule",
        "operationId": "UpdateMultiBucketReplication",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "rule_id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/multiBucketReplicationEdit"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Bucket"
        ],
        "summary": "Bucket Replication Rule Delete",
        "operationId": "DeleteBucketReplicationRule",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "rule_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/retention": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "Get Bucket's retention config",
        "operationId": "GetBucketRetentionConfig",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/getBucketRetentionConfig"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Bucket"
        ],
        "summary": "Set Bucket's retention config",
        "operationId": "SetBucketRetentionConfig",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/putBucketRetentionRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/rewind/{date}": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "Get objects in a bucket for a rewind date",
        "operationId": "GetBucketRewind",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "date",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "prefix",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/rewindResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/tags": {
      "put": {
        "tags": [
          "Bucket"
        ],
        "summary": "Put Bucket's tags",
        "operationId": "PutBucketTags",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/putBucketTagsRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{bucket_name}/versioning": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "Bucket Versioning",
        "operationId": "GetBucketVersioning",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/bucketVersioningResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Bucket"
        ],
        "summary": "Set Bucket Versioning",
        "operationId": "SetBucketVersioning",
        "parameters": [
          {
            "type": "string",
            "name": "bucket_name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/setBucketVersioning"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{name}": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "Bucket Info",
        "operationId": "BucketInfo",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/bucket"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Bucket"
        ],
        "summary": "Delete Bucket",
        "operationId": "DeleteBucket",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{name}/quota": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "Get Bucket Quota",
        "operationId": "GetBucketQuota",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/bucketQuota"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Bucket"
        ],
        "summary": "Bucket Quota",
        "operationId": "SetBucketQuota",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/setBucketQuota"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/bucket"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/buckets/{name}/set-policy": {
      "put": {
        "tags": [
          "Bucket"
        ],
        "summary": "Bucket Set Policy",
        "operationId": "BucketSetPolicy",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/setBucketPolicyRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/bucket"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/configs": {
      "get": {
        "tags": [
          "Configuration"
        ],
        "summary": "List Configurations",
        "operationId": "ListConfig",
        "parameters": [
          {
            "type": "number",
            "format": "int32",
            "default": 0,
            "name": "offset",
            "in": "query"
          },
          {
            "type": "number",
            "format": "int32",
            "default": 20,
            "name": "limit",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listConfigResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/configs/export": {
      "get": {
        "tags": [
          "Configuration"
        ],
        "summary": "Export the current config from MinIO server",
        "operationId": "ExportConfig",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/configExportResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/configs/import": {
      "post": {
        "consumes": [
          "multipart/form-data"
        ],
        "tags": [
          "Configuration"
        ],
        "summary": "Uploads a file to import MinIO server config.",
        "parameters": [
          {
            "type": "file",
            "name": "file",
            "in": "formData",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/configs/{name}": {
      "get": {
        "tags": [
          "Configuration"
        ],
        "summary": "Configuration info",
        "operationId": "ConfigInfo",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/configuration"
              }
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Configuration"
        ],
        "summary": "Set Configuration",
        "operationId": "SetConfig",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/setConfigRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/setConfigResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/configs/{name}/reset": {
      "post": {
        "tags": [
          "Configuration"
        ],
        "summary": "Configuration reset",
        "operationId": "ResetConfig",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/setConfigResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/download-shared-object/{url}": {
      "get": {
        "security": [],
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "Public"
        ],
        "summary": "Downloads an object from a presigned url",
        "operationId": "DownloadSharedObject",
        "parameters": [
          {
            "type": "string",
            "name": "url",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "file"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/group/{name}": {
      "get": {
        "tags": [
          "Group"
        ],
        "summary": "Group info",
        "operationId": "GroupInfo",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/group"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Group"
        ],
        "summary": "Update Group Members or Status",
        "operationId": "UpdateGroup",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/updateGroupRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/group"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Group"
        ],
        "summary": "Remove group",
        "operationId": "RemoveGroup",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/groups": {
      "get": {
        "tags": [
          "Group"
        ],
        "summary": "List Groups",
        "operationId": "ListGroups",
        "parameters": [
          {
            "type": "number",
            "format": "int32",
            "default": 0,
            "name": "offset",
            "in": "query"
          },
          {
            "type": "number",
            "format": "int32",
            "default": 20,
            "name": "limit",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listGroupsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Group"
        ],
        "summary": "Add Group",
        "operationId": "AddGroup",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/addGroupRequest"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/idp/{type}": {
      "get": {
        "tags": [
          "idp"
        ],
        "summary": "List IDP Configurations",
        "operationId": "ListConfigurations",
        "parameters": [
          {
            "type": "string",
            "description": "IDP Configuration Type",
            "name": "type",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/idpListConfigurationsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "consumes": [
          "application/json"
        ],
        "tags": [
          "idp"
        ],
        "summary": "Create IDP Configuration",
        "operationId": "CreateConfiguration",
        "parameters": [
          {
            "type": "string",
            "description": "IDP Configuration Type",
            "name": "type",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/idpServerConfiguration"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/setIDPResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/idp/{type}/{name}": {
      "get": {
        "tags": [
          "idp"
        ],
        "summary": "Get IDP Configuration",
        "operationId": "GetConfiguration",
        "parameters": [
          {
            "type": "string",
            "description": "IDP Configuration Name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "IDP Configuration Type",
            "name": "type",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/idpServerConfiguration"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "put": {
        "consumes": [
          "application/json"
        ],
        "tags": [
          "idp"
        ],
        "summary": "Update IDP Configuration",
        "operationId": "UpdateConfiguration",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/idpServerConfiguration"
            }
          },
          {
            "type": "string",
            "description": "IDP Configuration Name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "IDP Configuration Type",
            "name": "type",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/setIDPResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "idp"
        ],
        "summary": "Delete IDP Configuration",
        "operationId": "DeleteConfiguration",
        "parameters": [
          {
            "type": "string",
            "description": "IDP Configuration Name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "IDP Configuration Type",
            "name": "type",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/setIDPResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/apis": {
      "get": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS apis",
        "operationId": "KMSAPIs",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/kmsAPIsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/describe-self/identity": {
      "get": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS describe self identity",
        "operationId": "KMSDescribeSelfIdentity",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/kmsDescribeSelfIdentityResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/identities": {
      "get": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS list identities",
        "operationId": "KMSListIdentities",
        "parameters": [
          {
            "type": "string",
            "description": "pattern to retrieve identities",
            "name": "pattern",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/kmsListIdentitiesResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/identities/{name}": {
      "delete": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS delete identity",
        "operationId": "KMSDeleteIdentity",
        "parameters": [
          {
            "type": "string",
            "description": "KMS identity name",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/identities/{name}/describe": {
      "get": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS describe identity",
        "operationId": "KMSDescribeIdentity",
        "parameters": [
          {
            "type": "string",
            "description": "KMS identity name",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/kmsDescribeIdentityResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/keys": {
      "get": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS list keys",
        "operationId": "KMSListKeys",
        "parameters": [
          {
            "type": "string",
            "description": "pattern to retrieve keys",
            "name": "pattern",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/kmsListKeysResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS create key",
        "operationId": "KMSCreateKey",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/kmsCreateKeyRequest"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/keys/{name}": {
      "get": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS key status",
        "operationId": "KMSKeyStatus",
        "parameters": [
          {
            "type": "string",
            "description": "KMS key name",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/kmsKeyStatusResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS delete key",
        "operationId": "KMSDeleteKey",
        "parameters": [
          {
            "type": "string",
            "description": "KMS key name",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/keys/{name}/import": {
      "post": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS import key",
        "operationId": "KMSImportKey",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/kmsImportKeyRequest"
            }
          },
          {
            "type": "string",
            "description": "KMS key name",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/metrics": {
      "get": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS metrics",
        "operationId": "KMSMetrics",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/kmsMetricsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/policies": {
      "get": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS list policies",
        "operationId": "KMSListPolicies",
        "parameters": [
          {
            "type": "string",
            "description": "pattern to retrieve policies",
            "name": "pattern",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/kmsListPoliciesResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS set policy",
        "operationId": "KMSSetPolicy",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/kmsSetPolicyRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/policies/{name}": {
      "get": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS get policy",
        "operationId": "KMSGetPolicy",
        "parameters": [
          {
            "type": "string",
            "description": "KMS policy name",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/kmsGetPolicyResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS delete policy",
        "operationId": "KMSDeletePolicy",
        "parameters": [
          {
            "type": "string",
            "description": "KMS policy name",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/policies/{name}/assign": {
      "post": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS assign policy",
        "operationId": "KMSAssignPolicy",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/kmsAssignPolicyRequest"
            }
          },
          {
            "type": "string",
            "description": "KMS policy name",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/policies/{name}/describe": {
      "get": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS describe policy",
        "operationId": "KMSDescribePolicy",
        "parameters": [
          {
            "type": "string",
            "description": "KMS policy name",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/kmsDescribePolicyResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/status": {
      "get": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS status",
        "operationId": "KMSStatus",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/kmsStatusResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/kms/version": {
      "get": {
        "tags": [
          "KMS"
        ],
        "summary": "KMS version",
        "operationId": "KMSVersion",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/kmsVersionResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/ldap-entities": {
      "post": {
        "tags": [
          "idp"
        ],
        "summary": "Get LDAP Entities",
        "operationId": "GetLDAPEntities",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/ldapEntitiesRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/ldapEntities"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/list-external-buckets": {
      "post": {
        "tags": [
          "Bucket"
        ],
        "summary": "Lists an External list of buckets using custom credentials",
        "operationId": "ListExternalBuckets",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/listExternalBucketsParams"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listBucketsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/login": {
      "get": {
        "security": [],
        "tags": [
          "Auth"
        ],
        "summary": "Returns login strategy, form or sso.",
        "operationId": "LoginDetail",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/loginDetails"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "security": [],
        "tags": [
          "Auth"
        ],
        "summary": "Login to Console",
        "operationId": "Login",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/loginRequest"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful login."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/login/oauth2/auth": {
      "post": {
        "security": [],
        "tags": [
          "Auth"
        ],
        "summary": "Identity Provider oauth2 callback endpoint.",
        "operationId": "LoginOauth2Auth",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/loginOauth2AuthRequest"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful login."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/logout": {
      "post": {
        "tags": [
          "Auth"
        ],
        "summary": "Logout from Console.",
        "operationId": "Logout",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/logoutRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/logs/search": {
      "get": {
        "tags": [
          "Logging"
        ],
        "summary": "Search the logs",
        "operationId": "LogSearch",
        "parameters": [
          {
            "type": "array",
            "items": {
              "type": "string"
            },
            "collectionFormat": "multi",
            "description": "Filter Parameters",
            "name": "fp",
            "in": "query"
          },
          {
            "type": "number",
            "format": "int32",
            "default": 10,
            "name": "pageSize",
            "in": "query"
          },
          {
            "type": "number",
            "format": "int32",
            "default": 0,
            "name": "pageNo",
            "in": "query"
          },
          {
            "enum": [
              "timeDesc",
              "timeAsc"
            ],
            "type": "string",
            "default": "timeDesc",
            "name": "order",
            "in": "query"
          },
          {
            "type": "string",
            "name": "timeStart",
            "in": "query"
          },
          {
            "type": "string",
            "name": "timeEnd",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/logSearchResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/nodes": {
      "get": {
        "tags": [
          "System"
        ],
        "summary": "Lists Nodes",
        "operationId": "ListNodes",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/policies": {
      "get": {
        "tags": [
          "Policy"
        ],
        "summary": "List Policies",
        "operationId": "ListPolicies",
        "parameters": [
          {
            "type": "number",
            "format": "int32",
            "default": 0,
            "name": "offset",
            "in": "query"
          },
          {
            "type": "number",
            "format": "int32",
            "default": 20,
            "name": "limit",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listPoliciesResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Policy"
        ],
        "summary": "Add Policy",
        "operationId": "AddPolicy",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/addPolicyRequest"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/policy"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/policies/{policy}/groups": {
      "get": {
        "tags": [
          "Policy"
        ],
        "summary": "List Groups for a Policy",
        "operationId": "ListGroupsForPolicy",
        "parameters": [
          {
            "type": "string",
            "name": "policy",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/policies/{policy}/users": {
      "get": {
        "tags": [
          "Policy"
        ],
        "summary": "List Users for a Policy",
        "operationId": "ListUsersForPolicy",
        "parameters": [
          {
            "type": "string",
            "name": "policy",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/policy/{name}": {
      "get": {
        "tags": [
          "Policy"
        ],
        "summary": "Policy info",
        "operationId": "PolicyInfo",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/policy"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "Policy"
        ],
        "summary": "Remove policy",
        "operationId": "RemovePolicy",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/profiling/start": {
      "post": {
        "tags": [
          "Profile"
        ],
        "summary": "Start recording profile data",
        "operationId": "ProfilingStart",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/profilingStartRequest"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/startProfilingList"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/profiling/stop": {
      "post": {
        "produces": [
          "application/zip"
        ],
        "tags": [
          "Profile"
        ],
        "summary": "Stop and download profile data",
        "operationId": "ProfilingStop",
        "responses": {
          "201": {
            "description": "A successful response.",
            "schema": {
              "type": "file"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/releases": {
      "get": {
        "tags": [
          "release"
        ],
        "summary": "Get repo releases for a given version",
        "operationId": "ListReleases",
        "parameters": [
          {
            "type": "string",
            "description": "repo name",
            "name": "repo",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "description": "Current Release",
            "name": "current",
            "in": "query"
          },
          {
            "type": "string",
            "description": "search content",
            "name": "search",
            "in": "query"
          },
          {
            "type": "string",
            "description": "filter releases",
            "name": "filter",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/releaseListResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/remote-buckets": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "List Remote Buckets",
        "operationId": "ListRemoteBuckets",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listRemoteBucketsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "tags": [
          "Bucket"
        ],
        "summary": "Add Remote Bucket",
        "operationId": "AddRemoteBucket",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/createRemoteBucket"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/remote-buckets/{name}": {
      "get": {
        "tags": [
          "Bucket"
        ],
        "summary": "Remote Bucket Details",
        "operationId": "RemoteBucketDetails",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/remoteBucket"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/remote-buckets/{source-bucket-name}/{arn}": {
      "delete": {
        "tags": [
          "Bucket"
        ],
        "summary": "Delete Remote Bucket",
        "operationId": "DeleteRemoteBucket",
        "parameters": [
          {
            "type": "string",
            "name": "source-bucket-name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "arn",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/service-account-credentials": {
      "post": {
        "tags": [
          "ServiceAccount"
        ],
        "summary": "Create Service Account With Credentials",
        "operationId": "CreateServiceAccountCreds",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/serviceAccountRequestCreds"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/serviceAccountCreds"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/service-accounts": {
      "get": {
        "tags": [
          "ServiceAccount"
        ],
        "summary": "List User's Service Accounts",
        "operationId": "ListUserServiceAccounts",
        "parameters": [
          {
            "type": "number",
            "format": "int32",
            "default": 0,
            "name": "offset",
            "in": "query"
          },
          {
            "type": "number",
            "format": "int32",
            "default": 20,
            "name": "limit",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/serviceAccounts"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "tags": [
          "ServiceAccount"
        ],
        "summary": "Create Service Account",
        "operationId": "CreateServiceAccount",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/serviceAccountRequest"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/serviceAccountCreds"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/service-accounts/delete-multi": {
      "delete": {
        "tags": [
          "ServiceAccount"
        ],
        "summary": "Delete Multiple Service Accounts",
        "operationId": "DeleteMultipleServiceAccounts",
        "parameters": [
          {
            "name": "selectedSA",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/selectedSAs"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/service-accounts/{access_key}": {
      "get": {
        "tags": [
          "ServiceAccount"
        ],
        "summary": "Get Service Account",
        "operationId": "GetServiceAccount",
        "parameters": [
          {
            "type": "string",
            "name": "access_key",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/serviceAccount"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "put": {
        "tags": [
          "ServiceAccount"
        ],
        "summary": "Set Service Account Policy",
        "operationId": "UpdateServiceAccount",
        "parameters": [
          {
            "type": "string",
            "name": "access_key",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/updateServiceAccountRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "ServiceAccount"
        ],
        "summary": "Delete Service Account",
        "operationId": "DeleteServiceAccount",
        "parameters": [
          {
            "type": "string",
            "name": "access_key",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/service/restart": {
      "post": {
        "tags": [
          "Service"
        ],
        "summary": "Restart Service",
        "operationId": "RestartService",
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/session": {
      "get": {
        "tags": [
          "Auth"
        ],
        "summary": "Endpoint to check if your session is still valid",
        "operationId": "SessionCheck",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/sessionResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/set-policy": {
      "put": {
        "tags": [
          "Policy"
        ],
        "summary": "Set policy",
        "operationId": "SetPolicy",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/setPolicyNameRequest"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/set-policy-multi": {
      "put": {
        "tags": [
          "Policy"
        ],
        "summary": "Set policy to multiple users/groups",
        "operationId": "SetPolicyMultiple",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/setPolicyMultipleNameRequest"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/subnet/apikey": {
      "get": {
        "tags": [
          "Subnet"
        ],
        "summary": "Subnet api key",
        "operationId": "SubnetApiKey",
        "parameters": [
          {
            "type": "string",
            "name": "token",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/apiKey"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/subnet/info": {
      "get": {
        "tags": [
          "Subnet"
        ],
        "summary": "Subnet info",
        "operationId": "SubnetInfo",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/license"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/subnet/login": {
      "post": {
        "tags": [
          "Subnet"
        ],
        "summary": "Login to SUBNET",
        "operationId": "SubnetLogin",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/subnetLoginRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/subnetLoginResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/subnet/login/mfa": {
      "post": {
        "tags": [
          "Subnet"
        ],
        "summary": "Login to SUBNET using mfa",
        "operationId": "SubnetLoginMFA",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/subnetLoginMFARequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/subnetLoginResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/subnet/register": {
      "post": {
        "tags": [
          "Subnet"
        ],
        "summary": "Register cluster with Subnet",
        "operationId": "SubnetRegister",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/subnetRegisterRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/subnet/registration-token": {
      "get": {
        "tags": [
          "Subnet"
        ],
        "summary": "SUBNET registraton token",
        "operationId": "SubnetRegToken",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/SubnetRegTokenResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/support/callhome": {
      "get": {
        "tags": [
          "Support"
        ],
        "summary": "Get Callhome current status",
        "operationId": "GetCallHomeOptionValue",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/callHomeGetResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "put": {
        "tags": [
          "Support"
        ],
        "summary": "Sets callhome status",
        "operationId": "SetCallHomeStatus",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/callHomeSetStatus"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/user/policy": {
      "get": {
        "tags": [
          "Policy"
        ],
        "summary": "returns policies for logged in user",
        "operationId": "GetUserPolicy",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "string"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/user/{name}": {
      "get": {
        "tags": [
          "User"
        ],
        "summary": "Get User Info",
        "operationId": "GetUserInfo",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/user"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "put": {
        "tags": [
          "User"
        ],
        "summary": "Update User Info",
        "operationId": "UpdateUserInfo",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/updateUser"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/user"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "User"
        ],
        "summary": "Remove user",
        "operationId": "RemoveUser",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/user/{name}/groups": {
      "put": {
        "tags": [
          "User"
        ],
        "summary": "Update Groups for a user",
        "operationId": "UpdateUserGroups",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/updateUserGroups"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/user"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/user/{name}/policies": {
      "get": {
        "tags": [
          "Policy"
        ],
        "summary": "returns policies assigned for a specified user",
        "operationId": "GetSAUserPolicy",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/aUserPolicyResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/user/{name}/service-account-credentials": {
      "post": {
        "tags": [
          "User"
        ],
        "summary": "Create Service Account for User With Credentials",
        "operationId": "CreateServiceAccountCredentials",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/serviceAccountRequestCreds"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/serviceAccountCreds"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/user/{name}/service-accounts": {
      "get": {
        "tags": [
          "User"
        ],
        "summary": "returns a list of service accounts for a user",
        "operationId": "ListAUserServiceAccounts",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/serviceAccounts"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "tags": [
          "User"
        ],
        "summary": "Create Service Account for User",
        "operationId": "CreateAUserServiceAccount",
        "parameters": [
          {
            "type": "string",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/serviceAccountRequest"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/serviceAccountCreds"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/users": {
      "get": {
        "tags": [
          "User"
        ],
        "summary": "List Users",
        "operationId": "ListUsers",
        "parameters": [
          {
            "type": "number",
            "format": "int32",
            "default": 0,
            "name": "offset",
            "in": "query"
          },
          {
            "type": "number",
            "format": "int32",
            "default": 20,
            "name": "limit",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listUsersResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      },
      "post": {
        "tags": [
          "User"
        ],
        "summary": "Add User",
        "operationId": "AddUser",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/addUserRequest"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/user"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/users-groups-bulk": {
      "put": {
        "tags": [
          "User"
        ],
        "summary": "Bulk functionality to Add Users to Groups",
        "operationId": "BulkUpdateUsersGroups",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/bulkUserGroups"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    },
    "/users/service-accounts": {
      "post": {
        "tags": [
          "User"
        ],
        "summary": "Check number of service accounts for each user specified",
        "operationId": "CheckUserServiceAccounts",
        "parameters": [
          {
            "name": "selectedUsers",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/selectedUsers"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/userServiceAccountSummary"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/ApiError"
            }
          }
        }
      }
    }
  },
  "definitions": {
    "ApiError": {
      "type": "object",
      "properties": {
        "detailedMessage": {
          "type": "string"
        },
        "message": {
          "type": "string"
        }
      }
    },
    "BackendProperties": {
      "type": "object",
      "properties": {
        "backendType": {
          "type": "string"
        },
        "offlineDrives": {
          "type": "integer"
        },
        "onlineDrives": {
          "type": "integer"
        },
        "rrSCParity": {
          "type": "integer"
        },
        "standardSCParity": {
          "type": "integer"
        }
      }
    },
    "BucketDetails": {
      "type": "object",
      "properties": {
        "locking": {
          "type": "boolean"
        },
        "quota": {
          "type": "object",
          "properties": {
            "quota": {
              "type": "integer",
              "format": "int64"
            },
            "type": {
              "type": "string",
              "enum": [
                "hard"
              ]
            }
          }
        },
        "replication": {
          "type": "boolean"
        },
        "tags": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "versioning": {
          "type": "boolean"
        },
        "versioningSuspended": {
          "type": "boolean"
        }
      }
    },
    "BucketDetailsQuota": {
      "type": "object",
      "properties": {
        "quota": {
          "type": "integer",
          "format": "int64"
        },
        "type": {
          "type": "string",
          "enum": [
            "hard"
          ]
        }
      }
    },
    "BucketRwAccess": {
      "type": "object",
      "properties": {
        "read": {
          "type": "boolean"
        },
        "write": {
          "type": "boolean"
        }
      }
    },
    "BucketVersioningResponseExcludedPrefixesItems0": {
      "type": "object",
      "properties": {
        "prefix": {
          "type": "string"
        }
      }
    },
    "LoginRequestFeatures": {
      "type": "object",
      "properties": {
        "hide_menu": {
          "type": "boolean"
        }
      }
    },
    "ServiceAccountsItems0": {
      "type": "object",
      "properties": {
        "accessKey": {
          "type": "string"
        },
        "accountStatus": {
          "type": "string"
        },
        "description": {
          "type": "string"
        },
        "expiration": {
          "type": "string"
        },
        "name": {
          "type": "string"
        }
      }
    },
    "SubnetRegTokenResponse": {
      "type": "object",
      "properties": {
        "regToken": {
          "type": "string"
        }
      }
    },
    "WidgetDetailsOptions": {
      "type": "object",
      "properties": {
        "reduceOptions": {
          "type": "object",
          "properties": {
            "calcs": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          }
        }
      }
    },
    "WidgetDetailsOptionsReduceOptions": {
      "type": "object",
      "properties": {
        "calcs": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "WidgetOptions": {
      "type": "object",
      "properties": {
        "reduceOptions": {
          "type": "object",
          "properties": {
            "calcs": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          }
        }
      }
    },
    "WidgetOptionsReduceOptions": {
      "type": "object",
      "properties": {
        "calcs": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "aUserPolicyResponse": {
      "type": "object",
      "properties": {
        "policy": {
          "type": "string"
        }
      }
    },
    "accessRule": {
      "type": "object",
      "properties": {
        "access": {
          "type": "string"
        },
        "prefix": {
          "type": "string"
        }
      }
    },
    "accountChangePasswordRequest": {
      "type": "object",
      "required": [
        "current_secret_key",
        "new_secret_key"
      ],
      "properties": {
        "current_secret_key": {
          "type": "string"
        },
        "new_secret_key": {
          "type": "string"
        }
      }
    },
    "addBucketLifecycle": {
      "type": "object",
      "properties": {
        "disable": {
          "description": "Non required, toggle to disable or enable rule",
          "type": "boolean"
        },
        "expired_object_delete_all": {
          "description": "Non required, toggle to disable or enable rule",
          "type": "boolean"
        },
        "expired_object_delete_marker": {
          "description": "Non required, toggle to disable or enable rule",
          "type": "boolean"
        },
        "expiry_days": {
          "description": "Required in case of expiry_date or transition fields are not set. it defines an expiry days for ILM",
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "newer_noncurrentversion_expiration_versions": {
          "description": "Non required, can be set in case of expiration is enabled",
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "noncurrentversion_expiration_days": {
          "description": "Non required, can be set in case of expiration is enabled",
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "noncurrentversion_transition_days": {
          "description": "Non required, can be set in case of transition is enabled",
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "noncurrentversion_transition_storage_class": {
          "description": "Non required, can be set in case of transition is enabled",
          "type": "string"
        },
        "prefix": {
          "description": "Non required field, it matches a prefix to perform ILM operations on it",
          "type": "string"
        },
        "storage_class": {
          "description": "Required only in case of transition is set. it refers to a tier",
          "type": "string"
        },
        "tags": {
          "description": "Non required field, tags to match ILM files",
          "type": "string"
        },
        "transition_days": {
          "description": "Required in case of transition_date or expiry fields are not set. it defines a transition days for ILM",
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "type": {
          "description": "ILM Rule type (Expiry or transition)",
          "type": "string",
          "enum": [
            "expiry",
            "transition"
          ]
        }
      }
    },
    "addBucketReplication": {
      "type": "object",
      "properties": {
        "arn": {
          "type": "string"
        },
        "destination_bucket": {
          "type": "string"
        }
      }
    },
    "addGroupRequest": {
      "type": "object",
      "required": [
        "group",
        "members"
      ],
      "properties": {
        "group": {
          "type": "string"
        },
        "members": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "addMultiBucketLifecycle": {
      "type": "object",
      "required": [
        "buckets",
        "type"
      ],
      "properties": {
        "buckets": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "expired_object_delete_all": {
          "description": "Non required, toggle to disable or enable rule",
          "type": "boolean"
        },
        "expired_object_delete_marker": {
          "description": "Non required, toggle to disable or enable rule",
          "type": "boolean"
        },
        "expiry_days": {
          "description": "Required in case of expiry_date or transition fields are not set. it defines an expiry days for ILM",
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "noncurrentversion_expiration_days": {
          "description": "Non required, can be set in case of expiration is enabled",
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "noncurrentversion_transition_days": {
          "description": "Non required, can be set in case of transition is enabled",
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "noncurrentversion_transition_storage_class": {
          "description": "Non required, can be set in case of transition is enabled",
          "type": "string"
        },
        "prefix": {
          "description": "Non required field, it matches a prefix to perform ILM operations on it",
          "type": "string"
        },
        "storage_class": {
          "description": "Required only in case of transition is set. it refers to a tier",
          "type": "string"
        },
        "tags": {
          "description": "Non required field, tags to match ILM files",
          "type": "string"
        },
        "transition_days": {
          "description": "Required in case of transition_date or expiry fields are not set. it defines a transition days for ILM",
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "type": {
          "description": "ILM Rule type (Expiry or transition)",
          "type": "string",
          "enum": [
            "expiry",
            "transition"
          ]
        }
      }
    },
    "addPolicyRequest": {
      "type": "object",
      "required": [
        "name",
        "policy"
      ],
      "properties": {
        "name": {
          "type": "string"
        },
        "policy": {
          "type": "string"
        }
      }
    },
    "addUserRequest": {
      "type": "object",
      "required": [
        "accessKey",
        "secretKey",
        "groups",
        "policies"
      ],
      "properties": {
        "accessKey": {
          "type": "string"
        },
        "groups": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "policies": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "secretKey": {
          "type": "string"
        }
      }
    },
    "adminInfoResponse": {
      "type": "object",
      "properties": {
        "advancedMetricsStatus": {
          "type": "string",
          "enum": [
            "not configured",
            "available",
            "unavailable"
          ]
        },
        "backend": {
          "$ref": "#/definitions/BackendProperties"
        },
        "buckets": {
          "type": "integer"
        },
        "objects": {
          "type": "integer"
        },
        "servers": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/serverProperties"
          }
        },
        "usage": {
          "type": "integer"
        },
        "widgets": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/widget"
          }
        }
      }
    },
    "apiKey": {
      "type": "object",
      "properties": {
        "apiKey": {
          "type": "string"
        }
      }
    },
    "arnsResponse": {
      "type": "object",
      "properties": {
        "arns": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "bucket": {
      "type": "object",
      "required": [
        "name"
      ],
      "properties": {
        "access": {
          "$ref": "#/definitions/bucketAccess"
        },
        "creation_date": {
          "type": "string"
        },
        "definition": {
          "type": "string"
        },
        "details": {
          "type": "object",
          "properties": {
            "locking": {
              "type": "boolean"
            },
            "quota": {
              "type": "object",
              "properties": {
                "quota": {
                  "type": "integer",
                  "format": "int64"
                },
                "type": {
                  "type": "string",
                  "enum": [
                    "hard"
                  ]
                }
              }
            },
            "replication": {
              "type": "boolean"
            },
            "tags": {
              "type": "object",
              "additionalProperties": {
                "type": "string"
              }
            },
            "versioning": {
              "type": "boolean"
            },
            "versioningSuspended": {
              "type": "boolean"
            }
          }
        },
        "name": {
          "type": "string",
          "minLength": 3
        },
        "objects": {
          "type": "integer",
          "format": "int64"
        },
        "rw_access": {
          "type": "object",
          "properties": {
            "read": {
              "type": "boolean"
            },
            "write": {
              "type": "boolean"
            }
          }
        },
        "size": {
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "bucketAccess": {
      "type": "string",
      "default": "PRIVATE",
      "enum": [
        "PRIVATE",
        "PUBLIC",
        "CUSTOM"
      ]
    },
    "bucketEncryptionInfo": {
      "type": "object",
      "properties": {
        "algorithm": {
          "type": "string"
        },
        "kmsMasterKeyID": {
          "type": "string"
        }
      }
    },
    "bucketEncryptionRequest": {
      "type": "object",
      "properties": {
        "encType": {
          "$ref": "#/definitions/bucketEncryptionType"
        },
        "kmsKeyID": {
          "type": "string"
        }
      }
    },
    "bucketEncryptionType": {
      "type": "string",
      "default": "sse-s3",
      "enum": [
        "sse-s3",
        "sse-kms"
      ]
    },
    "bucketEventRequest": {
      "type": "object",
      "required": [
        "configuration"
      ],
      "properties": {
        "configuration": {
          "$ref": "#/definitions/notificationConfig"
        },
        "ignoreExisting": {
          "type": "boolean"
        }
      }
    },
    "bucketLifecycleResponse": {
      "type": "object",
      "properties": {
        "lifecycle": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/objectBucketLifecycle"
          }
        }
      }
    },
    "bucketObLockingResponse": {
      "type": "object",
      "properties": {
        "object_locking_enabled": {
          "type": "boolean"
        }
      }
    },
    "bucketObject": {
      "type": "object",
      "properties": {
        "content_type": {
          "type": "string"
        },
        "etag": {
          "type": "string"
        },
        "expiration": {
          "type": "string"
        },
        "expiration_rule_id": {
          "type": "string"
        },
        "is_delete_marker": {
          "type": "boolean"
        },
        "is_latest": {
          "type": "boolean"
        },
        "last_modified": {
          "type": "string"
        },
        "legal_hold_status": {
          "type": "string"
        },
        "metadata": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "name": {
          "type": "string"
        },
        "retention_mode": {
          "type": "string"
        },
        "retention_until_date": {
          "type": "string"
        },
        "size": {
          "type": "integer",
          "format": "int64"
        },
        "tags": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "user_metadata": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "user_tags": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "version_id": {
          "type": "string"
        }
      }
    },
    "bucketQuota": {
      "type": "object",
      "properties": {
        "quota": {
          "type": "integer"
        },
        "type": {
          "type": "string",
          "enum": [
            "hard"
          ]
        }
      }
    },
    "bucketReplicationDestination": {
      "type": "object",
      "properties": {
        "bucket": {
          "type": "string"
        }
      }
    },
    "bucketReplicationResponse": {
      "type": "object",
      "properties": {
        "rules": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/bucketReplicationRule"
          }
        }
      }
    },
    "bucketReplicationRule": {
      "type": "object",
      "properties": {
        "bandwidth": {
          "type": "string"
        },
        "delete_marker_replication": {
          "type": "boolean"
        },
        "deletes_replication": {
          "type": "boolean"
        },
        "destination": {
          "$ref": "#/definitions/bucketReplicationDestination"
        },
        "existingObjects": {
          "type": "boolean"
        },
        "healthCheckPeriod": {
          "type": "integer"
        },
        "id": {
          "type": "string"
        },
        "metadata_replication": {
          "type": "boolean"
        },
        "prefix": {
          "type": "string"
        },
        "priority": {
          "type": "integer",
          "format": "int32"
        },
        "status": {
          "type": "string",
          "enum": [
            "Enabled",
            "Disabled"
          ]
        },
        "storageClass": {
          "type": "string"
        },
        "syncMode": {
          "type": "string",
          "default": "async",
          "enum": [
            "async",
            "sync"
          ]
        },
        "tags": {
          "type": "string"
        }
      }
    },
    "bucketReplicationRuleList": {
      "type": "object",
      "properties": {
        "rules": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "bucketVersioningResponse": {
      "type": "object",
      "properties": {
        "MFADelete": {
          "type": "string"
        },
        "excludeFolders": {
          "type": "boolean"
        },
        "excludedPrefixes": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/BucketVersioningResponseExcludedPrefixesItems0"
          }
        },
        "status": {
          "type": "string"
        }
      }
    },
    "bulkUserGroups": {
      "type": "object",
      "required": [
        "users",
        "groups"
      ],
      "properties": {
        "groups": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "users": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "callHomeGetResponse": {
      "type": "object",
      "properties": {
        "diagnosticsStatus": {
          "type": "boolean"
        },
        "logsStatus": {
          "type": "boolean"
        }
      }
    },
    "callHomeSetStatus": {
      "type": "object",
      "required": [
        "diagState",
        "logsState"
      ],
      "properties": {
        "diagState": {
          "type": "boolean"
        },
        "logsState": {
          "type": "boolean"
        }
      }
    },
    "changeUserPasswordRequest": {
      "type": "object",
      "required": [
        "selectedUser",
        "newSecretKey"
      ],
      "properties": {
        "newSecretKey": {
          "type": "string"
        },
        "selectedUser": {
          "type": "string"
        }
      }
    },
    "configDescription": {
      "type": "object",
      "properties": {
        "description": {
          "type": "string"
        },
        "key": {
          "type": "string"
        }
      }
    },
    "configExportResponse": {
      "type": "object",
      "properties": {
        "status": {
          "type": "string"
        },
        "value": {
          "description": "Returns base64 encoded value",
          "type": "string"
        }
      }
    },
    "configuration": {
      "type": "object",
      "properties": {
        "key_values": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/configurationKV"
          }
        },
        "name": {
          "type": "string"
        }
      }
    },
    "configurationKV": {
      "type": "object",
      "properties": {
        "env_override": {
          "$ref": "#/definitions/envOverride"
        },
        "key": {
          "type": "string"
        },
        "value": {
          "type": "string"
        }
      }
    },
    "createRemoteBucket": {
      "required": [
        "accessKey",
        "secretKey",
        "targetURL",
        "sourceBucket",
        "targetBucket"
      ],
      "properties": {
        "accessKey": {
          "type": "string",
          "minLength": 3
        },
        "bandwidth": {
          "type": "integer",
          "format": "int64"
        },
        "healthCheckPeriod": {
          "type": "integer",
          "format": "int32"
        },
        "region": {
          "type": "string"
        },
        "secretKey": {
          "type": "string",
          "minLength": 8
        },
        "sourceBucket": {
          "type": "string"
        },
        "syncMode": {
          "type": "string",
          "default": "async",
          "enum": [
            "async",
            "sync"
          ]
        },
        "targetBucket": {
          "type": "string"
        },
        "targetURL": {
          "type": "string"
        }
      }
    },
    "deleteFile": {
      "type": "object",
      "properties": {
        "path": {
          "type": "string"
        },
        "recursive": {
          "type": "boolean"
        },
        "versionID": {
          "type": "string"
        }
      }
    },
    "envOverride": {
      "type": "object",
      "properties": {
        "name": {
          "type": "string"
        },
        "value": {
          "type": "string"
        }
      }
    },
    "environmentConstants": {
      "type": "object",
      "properties": {
        "maxConcurrentDownloads": {
          "type": "integer"
        },
        "maxConcurrentUploads": {
          "type": "integer"
        }
      }
    },
    "expirationResponse": {
      "type": "object",
      "properties": {
        "date": {
          "type": "string"
        },
        "days": {
          "type": "integer",
          "format": "int64"
        },
        "delete_all": {
          "type": "boolean"
        },
        "delete_marker": {
          "type": "boolean"
        },
        "newer_noncurrent_expiration_versions": {
          "type": "integer",
          "format": "int64"
        },
        "noncurrent_expiration_days": {
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "getBucketRetentionConfig": {
      "type": "object",
      "properties": {
        "mode": {
          "$ref": "#/definitions/objectRetentionMode"
        },
        "unit": {
          "$ref": "#/definitions/objectRetentionUnit"
        },
        "validity": {
          "type": "integer",
          "format": "int32"
        }
      }
    },
    "group": {
      "type": "object",
      "properties": {
        "members": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "name": {
          "type": "string"
        },
        "policy": {
          "type": "string"
        },
        "status": {
          "type": "string"
        }
      }
    },
    "iamEntity": {
      "type": "string",
      "pattern": "^[\\w+=,.@-]{1,64}$"
    },
    "iamPolicy": {
      "type": "object",
      "properties": {
        "statement": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/iamPolicyStatement"
          }
        },
        "version": {
          "type": "string"
        }
      }
    },
    "iamPolicyStatement": {
      "type": "object",
      "properties": {
        "action": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "condition": {
          "type": "object",
          "additionalProperties": {
            "type": "object"
          }
        },
        "effect": {
          "type": "string"
        },
        "resource": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "idpListConfigurationsResponse": {
      "type": "object",
      "properties": {
        "results": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/idpServerConfiguration"
          }
        }
      }
    },
    "idpServerConfiguration": {
      "type": "object",
      "properties": {
        "enabled": {
          "type": "boolean"
        },
        "info": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/idpServerConfigurationInfo"
          }
        },
        "input": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "type": {
          "type": "string"
        }
      }
    },
    "idpServerConfigurationInfo": {
      "type": "object",
      "properties": {
        "isCfg": {
          "type": "boolean"
        },
        "isEnv": {
          "type": "boolean"
        },
        "key": {
          "type": "string"
        },
        "value": {
          "type": "string"
        }
      }
    },
    "kmDeleteKeyRequest": {
      "type": "object"
    },
    "kmsAPI": {
      "type": "object",
      "properties": {
        "maxBody": {
          "type": "integer"
        },
        "method": {
          "type": "string"
        },
        "path": {
          "type": "string"
        },
        "timeout": {
          "type": "integer"
        }
      }
    },
    "kmsAPIsResponse": {
      "type": "object",
      "properties": {
        "results": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/kmsAPI"
          }
        }
      }
    },
    "kmsAssignPolicyRequest": {
      "type": "object",
      "properties": {
        "identity": {
          "type": "string"
        }
      }
    },
    "kmsCreateKeyRequest": {
      "type": "object",
      "required": [
        "key"
      ],
      "properties": {
        "key": {
          "type": "string"
        }
      }
    },
    "kmsDescribeIdentityResponse": {
      "type": "object",
      "properties": {
        "admin": {
          "type": "boolean"
        },
        "createdAt": {
          "type": "string"
        },
        "createdBy": {
          "type": "string"
        },
        "identity": {
          "type": "string"
        },
        "policy": {
          "type": "string"
        }
      }
    },
    "kmsDescribePolicyResponse": {
      "type": "object",
      "properties": {
        "createdAt": {
          "type": "string"
        },
        "createdBy": {
          "type": "string"
        },
        "name": {
          "type": "string"
        }
      }
    },
    "kmsDescribeSelfIdentityResponse": {
      "type": "object",
      "properties": {
        "admin": {
          "type": "boolean"
        },
        "createdAt": {
          "type": "string"
        },
        "createdBy": {
          "type": "string"
        },
        "identity": {
          "type": "string"
        },
        "policy": {
          "$ref": "#/definitions/kmsGetPolicyResponse"
        },
        "policyName": {
          "type": "string"
        }
      }
    },
    "kmsEndpoint": {
      "type": "object",
      "properties": {
        "status": {
          "type": "string"
        },
        "url": {
          "type": "string"
        }
      }
    },
    "kmsGetPolicyResponse": {
      "type": "object",
      "properties": {
        "allow": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "deny": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "kmsIdentityInfo": {
      "type": "object",
      "properties": {
        "createdAt": {
          "type": "string"
        },
        "createdBy": {
          "type": "string"
        },
        "error": {
          "type": "string"
        },
        "identity": {
          "type": "string"
        },
        "policy": {
          "type": "string"
        }
      }
    },
    "kmsImportKeyRequest": {
      "type": "object",
      "required": [
        "bytes"
      ],
      "properties": {
        "bytes": {
          "type": "string"
        }
      }
    },
    "kmsKeyInfo": {
      "type": "object",
      "properties": {
        "createdAt": {
          "type": "string"
        },
        "createdBy": {
          "type": "string"
        },
        "name": {
          "type": "string"
        }
      }
    },
    "kmsKeyStatusResponse": {
      "type": "object",
      "properties": {
        "decryptionErr": {
          "type": "string"
        },
        "encryptionErr": {
          "type": "string"
        },
        "keyID": {
          "type": "string"
        }
      }
    },
    "kmsLatencyHistogram": {
      "type": "object",
      "properties": {
        "duration": {
          "type": "integer"
        },
        "total": {
          "type": "integer"
        }
      }
    },
    "kmsListIdentitiesResponse": {
      "type": "object",
      "properties": {
        "results": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/kmsIdentityInfo"
          }
        }
      }
    },
    "kmsListKeysResponse": {
      "type": "object",
      "properties": {
        "results": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/kmsKeyInfo"
          }
        }
      }
    },
    "kmsListPoliciesResponse": {
      "type": "object",
      "properties": {
        "results": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/kmsPolicyInfo"
          }
        }
      }
    },
    "kmsMetricsResponse": {
      "type": "object",
      "required": [
        "requestOK",
        "requestErr",
        "requestFail",
        "requestActive",
        "auditEvents",
        "errorEvents",
        "latencyHistogram",
        "uptime",
        "cpus",
        "usableCPUs",
        "threads",
        "heapAlloc",
        "stackAlloc"
      ],
      "properties": {
        "auditEvents": {
          "type": "integer"
        },
        "cpus": {
          "type": "integer"
        },
        "errorEvents": {
          "type": "integer"
        },
        "heapAlloc": {
          "type": "integer"
        },
        "heapObjects": {
          "type": "integer"
        },
        "latencyHistogram": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/kmsLatencyHistogram"
          }
        },
        "requestActive": {
          "type": "integer"
        },
        "requestErr": {
          "type": "integer"
        },
        "requestFail": {
          "type": "integer"
        },
        "requestOK": {
          "type": "integer"
        },
        "stackAlloc": {
          "type": "integer"
        },
        "threads": {
          "type": "integer"
        },
        "uptime": {
          "type": "integer"
        },
        "usableCPUs": {
          "type": "integer"
        }
      }
    },
    "kmsPolicyInfo": {
      "type": "object",
      "properties": {
        "createdAt": {
          "type": "string"
        },
        "createdBy": {
          "type": "string"
        },
        "name": {
          "type": "string"
        }
      }
    },
    "kmsSetPolicyRequest": {
      "type": "object",
      "required": [
        "policy"
      ],
      "properties": {
        "allow": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "deny": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "policy": {
          "type": "string"
        }
      }
    },
    "kmsStatusResponse": {
      "type": "object",
      "properties": {
        "defaultKeyID": {
          "type": "string"
        },
        "endpoints": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/kmsEndpoint"
          }
        },
        "name": {
          "type": "string"
        }
      }
    },
    "kmsVersionResponse": {
      "type": "object",
      "properties": {
        "version": {
          "type": "string"
        }
      }
    },
    "ldapEntities": {
      "type": "object",
      "properties": {
        "groups": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/ldapGroupPolicyEntity"
          }
        },
        "policies": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/ldapPolicyEntity"
          }
        },
        "timestamp": {
          "type": "string"
        },
        "users": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/ldapUserPolicyEntity"
          }
        }
      }
    },
    "ldapEntitiesRequest": {
      "type": "object",
      "properties": {
        "groups": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "policies": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "users": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "ldapGroupPolicyEntity": {
      "type": "object",
      "properties": {
        "group": {
          "type": "string"
        },
        "policies": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "ldapPolicyEntity": {
      "type": "object",
      "properties": {
        "groups": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "policy": {
          "type": "string"
        },
        "users": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "ldapUserPolicyEntity": {
      "type": "object",
      "properties": {
        "policies": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "user": {
          "type": "string"
        }
      }
    },
    "license": {
      "type": "object",
      "properties": {
        "account_id": {
          "type": "integer"
        },
        "email": {
          "type": "string"
        },
        "expires_at": {
          "type": "string"
        },
        "organization": {
          "type": "string"
        },
        "plan": {
          "type": "string"
        },
        "storage_capacity": {
          "type": "integer"
        }
      }
    },
    "lifecycleTag": {
      "type": "object",
      "properties": {
        "key": {
          "type": "string"
        },
        "value": {
          "type": "string"
        }
      }
    },
    "listAccessRulesResponse": {
      "type": "object",
      "properties": {
        "accessRules": {
          "type": "array",
          "title": "list of policies",
          "items": {
            "$ref": "#/definitions/accessRule"
          }
        },
        "total": {
          "type": "integer",
          "format": "int64",
          "title": "total number of policies"
        }
      }
    },
    "listBucketEventsResponse": {
      "type": "object",
      "properties": {
        "events": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/notificationConfig"
          }
        },
        "total": {
          "type": "integer",
          "format": "int64",
          "title": "total number of bucket events"
        }
      }
    },
    "listBucketsResponse": {
      "type": "object",
      "properties": {
        "buckets": {
          "type": "array",
          "title": "list of resulting buckets",
          "items": {
            "$ref": "#/definitions/bucket"
          }
        },
        "total": {
          "type": "integer",
          "format": "int64",
          "title": "number of buckets accessible to the user"
        }
      }
    },
    "listConfigResponse": {
      "type": "object",
      "properties": {
        "configurations": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/configDescription"
          }
        },
        "total": {
          "type": "integer",
          "format": "int64",
          "title": "total number of configurations"
        }
      }
    },
    "listExternalBucketsParams": {
      "required": [
        "accessKey",
        "secretKey",
        "targetURL",
        "useTLS"
      ],
      "properties": {
        "accessKey": {
          "type": "string",
          "minLength": 3
        },
        "region": {
          "type": "string"
        },
        "secretKey": {
          "type": "string",
          "minLength": 8
        },
        "targetURL": {
          "type": "string"
        },
        "useTLS": {
          "type": "boolean"
        }
      }
    },
    "listGroupsResponse": {
      "type": "object",
      "properties": {
        "groups": {
          "type": "array",
          "title": "list of groups",
          "items": {
            "type": "string"
          }
        },
        "total": {
          "type": "integer",
          "format": "int64",
          "title": "total number of groups"
        }
      }
    },
    "listObjectsResponse": {
      "type": "object",
      "properties": {
        "objects": {
          "type": "array",
          "title": "list of resulting objects",
          "items": {
            "$ref": "#/definitions/bucketObject"
          }
        },
        "total": {
          "type": "integer",
          "format": "int64",
          "title": "number of objects"
        }
      }
    },
    "listPoliciesResponse": {
      "type": "object",
      "properties": {
        "policies": {
          "type": "array",
          "title": "list of policies",
          "items": {
            "$ref": "#/definitions/policy"
          }
        },
        "total": {
          "type": "integer",
          "format": "int64",
          "title": "total number of policies"
        }
      }
    },
    "listRemoteBucketsResponse": {
      "type": "object",
      "properties": {
        "buckets": {
          "type": "array",
          "title": "list of remote buckets",
          "items": {
            "$ref": "#/definitions/remoteBucket"
          }
        },
        "total": {
          "type": "integer",
          "format": "int64",
          "title": "number of remote buckets accessible to user"
        }
      }
    },
    "listUsersResponse": {
      "type": "object",
      "properties": {
        "users": {
          "type": "array",
          "title": "list of resulting users",
          "items": {
            "$ref": "#/definitions/user"
          }
        }
      }
    },
    "logSearchResponse": {
      "type": "object",
      "properties": {
        "results": {
          "type": "object",
          "title": "list of log search responses"
        }
      }
    },
    "loginDetails": {
      "type": "object",
      "properties": {
        "animatedLogin": {
          "type": "boolean"
        },
        "isK8S": {
          "type": "boolean"
        },
        "loginStrategy": {
          "type": "string",
          "enum": [
            "form",
            "redirect",
            "service-account",
            "redirect-service-account"
          ]
        },
        "redirectRules": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/redirectRule"
          }
        }
      }
    },
    "loginOauth2AuthRequest": {
      "type": "object",
      "required": [
        "state",
        "code"
      ],
      "properties": {
        "code": {
          "type": "string"
        },
        "state": {
          "type": "string"
        }
      }
    },
    "loginRequest": {
      "type": "object",
      "properties": {
        "accessKey": {
          "type": "string"
        },
        "features": {
          "type": "object",
          "properties": {
            "hide_menu": {
              "type": "boolean"
            }
          }
        },
        "secretKey": {
          "type": "string"
        },
        "sts": {
          "type": "string"
        }
      }
    },
    "loginResponse": {
      "type": "object",
      "properties": {
        "IDPRefreshToken": {
          "type": "string"
        },
        "sessionId": {
          "type": "string"
        }
      }
    },
    "logoutRequest": {
      "type": "object",
      "properties": {
        "state": {
          "type": "string"
        }
      }
    },
    "makeBucketRequest": {
      "type": "object",
      "required": [
        "name"
      ],
      "properties": {
        "locking": {
          "type": "boolean"
        },
        "name": {
          "type": "string"
        },
        "quota": {
          "$ref": "#/definitions/setBucketQuota"
        },
        "retention": {
          "$ref": "#/definitions/putBucketRetentionRequest"
        },
        "versioning": {
          "$ref": "#/definitions/setBucketVersioning"
        }
      }
    },
    "makeBucketsResponse": {
      "type": "object",
      "properties": {
        "bucketName": {
          "type": "string"
        }
      }
    },
    "maxShareLinkExpResponse": {
      "type": "object",
      "required": [
        "exp"
      ],
      "properties": {
        "exp": {
          "type": "number",
          "format": "int64"
        }
      }
    },
    "metadata": {
      "type": "object",
      "properties": {
        "objectMetadata": {
          "type": "object",
          "additionalProperties": true
        }
      }
    },
    "multiBucketReplication": {
      "required": [
        "accessKey",
        "secretKey",
        "targetURL",
        "bucketsRelation"
      ],
      "properties": {
        "accessKey": {
          "type": "string",
          "minLength": 3
        },
        "bandwidth": {
          "type": "integer",
          "format": "int64"
        },
        "bucketsRelation": {
          "type": "array",
          "minLength": 1,
          "items": {
            "$ref": "#/definitions/multiBucketsRelation"
          }
        },
        "healthCheckPeriod": {
          "type": "integer",
          "format": "int32"
        },
        "prefix": {
          "type": "string"
        },
        "priority": {
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "region": {
          "type": "string"
        },
        "replicateDeleteMarkers": {
          "type": "boolean"
        },
        "replicateDeletes": {
          "type": "boolean"
        },
        "replicateExistingObjects": {
          "type": "boolean"
        },
        "replicateMetadata": {
          "type": "boolean"
        },
        "secretKey": {
          "type": "string",
          "minLength": 8
        },
        "storageClass": {
          "type": "string",
          "default": ""
        },
        "syncMode": {
          "type": "string",
          "default": "async",
          "enum": [
            "async",
            "sync"
          ]
        },
        "tags": {
          "type": "string"
        },
        "targetURL": {
          "type": "string"
        }
      }
    },
    "multiBucketReplicationEdit": {
      "properties": {
        "arn": {
          "type": "string"
        },
        "prefix": {
          "type": "string"
        },
        "priority": {
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "replicateDeleteMarkers": {
          "type": "boolean"
        },
        "replicateDeletes": {
          "type": "boolean"
        },
        "replicateExistingObjects": {
          "type": "boolean"
        },
        "replicateMetadata": {
          "type": "boolean"
        },
        "ruleState": {
          "type": "boolean"
        },
        "storageClass": {
          "type": "string",
          "default": ""
        },
        "tags": {
          "type": "string",
          "default": ""
        }
      }
    },
    "multiBucketResponseItem": {
      "type": "object",
      "properties": {
        "errorString": {
          "type": "string"
        },
        "originBucket": {
          "type": "string"
        },
        "targetBucket": {
          "type": "string"
        }
      }
    },
    "multiBucketResponseState": {
      "type": "object",
      "properties": {
        "replicationState": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/multiBucketResponseItem"
          }
        }
      }
    },
    "multiBucketsRelation": {
      "type": "object",
      "properties": {
        "destinationBucket": {
          "type": "string"
        },
        "originBucket": {
          "type": "string"
        }
      }
    },
    "multiLifecycleResult": {
      "properties": {
        "results": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/multicycleResultItem"
          }
        }
      }
    },
    "multicycleResultItem": {
      "type": "object",
      "properties": {
        "bucketName": {
          "type": "string"
        },
        "error": {
          "type": "string"
        }
      }
    },
    "nofiticationService": {
      "type": "string",
      "enum": [
        "webhook",
        "amqp",
        "kafka",
        "mqtt",
        "nats",
        "nsq",
        "mysql",
        "postgres",
        "elasticsearch",
        "redis"
      ]
    },
    "notifEndpointResponse": {
      "type": "object",
      "properties": {
        "notification_endpoints": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/notificationEndpointItem"
          }
        }
      }
    },
    "notificationConfig": {
      "type": "object",
      "required": [
        "arn"
      ],
      "properties": {
        "arn": {
          "type": "string"
        },
        "events": {
          "type": "array",
          "title": "filter specific type of event. Defaults to all event (default: '[put,delete,get]')",
          "items": {
            "$ref": "#/definitions/notificationEventType"
          }
        },
        "id": {
          "type": "string"
        },
        "prefix": {
          "type": "string",
          "title": "filter event associated to the specified prefix"
        },
        "suffix": {
          "type": "string",
          "title": "filter event associated to the specified suffix"
        }
      }
    },
    "notificationDeleteRequest": {
      "type": "object",
      "required": [
        "events",
        "prefix",
        "suffix"
      ],
      "properties": {
        "events": {
          "type": "array",
          "title": "filter specific type of event. Defaults to all event (default: '[put,delete,get]')",
          "minLength": 1,
          "items": {
            "$ref": "#/definitions/notificationEventType"
          }
        },
        "prefix": {
          "type": "string",
          "title": "filter event associated to the specified prefix"
        },
        "suffix": {
          "type": "string",
          "title": "filter event associated to the specified suffix"
        }
      }
    },
    "notificationEndpoint": {
      "type": "object",
      "required": [
        "service",
        "account_id",
        "properties"
      ],
      "properties": {
        "account_id": {
          "type": "string"
        },
        "properties": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "service": {
          "$ref": "#/definitions/nofiticationService"
        }
      }
    },
    "notificationEndpointItem": {
      "type": "object",
      "properties": {
        "account_id": {
          "type": "string"
        },
        "service": {
          "$ref": "#/definitions/nofiticationService"
        },
        "status": {
          "type": "string"
        }
      }
    },
    "notificationEventType": {
      "type": "string",
      "enum": [
        "put",
        "delete",
        "get",
        "replica",
        "ilm",
        "scanner"
      ]
    },
    "objectBucketLifecycle": {
      "type": "object",
      "properties": {
        "expiration": {
          "$ref": "#/definitions/expirationResponse"
        },
        "id": {
          "type": "string"
        },
        "prefix": {
          "type": "string"
        },
        "status": {
          "type": "string"
        },
        "tags": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/lifecycleTag"
          }
        },
        "transition": {
          "$ref": "#/definitions/transitionResponse"
        }
      }
    },
    "objectLegalHoldStatus": {
      "type": "string",
      "enum": [
        "enabled",
        "disabled"
      ]
    },
    "objectRetentionMode": {
      "type": "string",
      "enum": [
        "governance",
        "compliance"
      ]
    },
    "objectRetentionUnit": {
      "type": "string",
      "enum": [
        "days",
        "years"
      ]
    },
    "peerInfo": {
      "type": "object",
      "properties": {
        "deploymentID": {
          "type": "string"
        },
        "endpoint": {
          "type": "string"
        },
        "name": {
          "type": "string"
        }
      }
    },
    "peerInfoRemove": {
      "type": "object",
      "required": [
        "sites"
      ],
      "properties": {
        "all": {
          "type": "boolean"
        },
        "sites": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "peerSite": {
      "type": "object",
      "properties": {
        "accessKey": {
          "type": "string"
        },
        "endpoint": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "secretKey": {
          "type": "string"
        }
      }
    },
    "peerSiteEditResponse": {
      "type": "object",
      "properties": {
        "errorDetail": {
          "type": "string"
        },
        "status": {
          "type": "string"
        },
        "success": {
          "type": "boolean"
        }
      }
    },
    "peerSiteRemoveResponse": {
      "type": "object",
      "properties": {
        "errorDetail": {
          "type": "string"
        },
        "status": {
          "type": "string"
        }
      }
    },
    "permissionResource": {
      "type": "object",
      "properties": {
        "conditionOperator": {
          "type": "string"
        },
        "prefixes": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "resource": {
          "type": "string"
        }
      }
    },
    "policy": {
      "type": "object",
      "properties": {
        "name": {
          "type": "string"
        },
        "policy": {
          "type": "string"
        }
      }
    },
    "policyArgs": {
      "type": "object",
      "properties": {
        "action": {
          "type": "string"
        },
        "bucket_name": {
          "type": "string"
        },
        "id": {
          "type": "string"
        }
      }
    },
    "policyEntity": {
      "type": "string",
      "default": "user",
      "enum": [
        "user",
        "group"
      ]
    },
    "prefixAccessPair": {
      "type": "object",
      "properties": {
        "access": {
          "type": "string"
        },
        "prefix": {
          "type": "string"
        }
      }
    },
    "prefixWrapper": {
      "type": "object",
      "properties": {
        "prefix": {
          "type": "string"
        }
      }
    },
    "principal": {
      "type": "object",
      "properties": {
        "STSAccessKeyID": {
          "type": "string"
        },
        "STSSecretAccessKey": {
          "type": "string"
        },
        "STSSessionToken": {
          "type": "string"
        },
        "accountAccessKey": {
          "type": "string"
        },
        "customStyleOb": {
          "type": "string"
        },
        "hm": {
          "type": "boolean"
        },
        "ob": {
          "type": "boolean"
        }
      }
    },
    "profilingStartRequest": {
      "type": "object",
      "required": [
        "type"
      ],
      "properties": {
        "type": {
          "type": "string"
        }
      }
    },
    "putBucketRetentionRequest": {
      "type": "object",
      "required": [
        "mode",
        "unit",
        "validity"
      ],
      "properties": {
        "mode": {
          "$ref": "#/definitions/objectRetentionMode"
        },
        "unit": {
          "$ref": "#/definitions/objectRetentionUnit"
        },
        "validity": {
          "type": "integer",
          "format": "int32"
        }
      }
    },
    "putBucketTagsRequest": {
      "type": "object",
      "properties": {
        "tags": {
          "additionalProperties": {
            "type": "string"
          }
        }
      }
    },
    "putObjectLegalHoldRequest": {
      "type": "object",
      "required": [
        "status"
      ],
      "properties": {
        "status": {
          "$ref": "#/definitions/objectLegalHoldStatus"
        }
      }
    },
    "putObjectRetentionRequest": {
      "type": "object",
      "required": [
        "mode",
        "expires"
      ],
      "properties": {
        "expires": {
          "type": "string"
        },
        "governance_bypass": {
          "type": "boolean"
        },
        "mode": {
          "$ref": "#/definitions/objectRetentionMode"
        }
      }
    },
    "putObjectTagsRequest": {
      "type": "object",
      "properties": {
        "tags": {
          "additionalProperties": {
            "type": "string"
          }
        }
      }
    },
    "redirectRule": {
      "type": "object",
      "properties": {
        "displayName": {
          "type": "string"
        },
        "redirect": {
          "type": "string"
        },
        "serviceType": {
          "type": "string"
        }
      }
    },
    "releaseAuthor": {
      "type": "object",
      "properties": {
        "avatar_url": {
          "type": "string"
        },
        "events_url": {
          "type": "string"
        },
        "followers_url": {
          "type": "string"
        },
        "following_url": {
          "type": "string"
        },
        "gists_url": {
          "type": "string"
        },
        "gravatar_id": {
          "type": "string"
        },
        "html_url": {
          "type": "string"
        },
        "id": {
          "type": "integer"
        },
        "login": {
          "type": "string"
        },
        "node_id": {
          "type": "string"
        },
        "organizations_url": {
          "type": "string"
        },
        "receivedEvents_url": {
          "type": "string"
        },
        "repos_url": {
          "type": "string"
        },
        "site_admin": {
          "type": "boolean"
        },
        "starred_url": {
          "type": "string"
        },
        "subscriptions_url": {
          "type": "string"
        },
        "type": {
          "type": "string"
        },
        "url": {
          "type": "string"
        }
      }
    },
    "releaseInfo": {
      "type": "object",
      "properties": {
        "breakingChangesContent": {
          "type": "string"
        },
        "contextContent": {
          "type": "string"
        },
        "metadata": {
          "$ref": "#/definitions/releaseMetadata"
        },
        "newFeaturesContent": {
          "type": "string"
        },
        "notesContent": {
          "type": "string"
        },
        "securityContent": {
          "type": "string"
        }
      }
    },
    "releaseListResponse": {
      "type": "object",
      "properties": {
        "results": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/releaseInfo"
          }
        }
      }
    },
    "releaseMetadata": {
      "type": "object",
      "properties": {
        "assets_url": {
          "type": "string"
        },
        "author": {
          "$ref": "#/definitions/releaseAuthor"
        },
        "created_at": {
          "type": "string"
        },
        "draft": {
          "type": "boolean"
        },
        "html_url": {
          "type": "string"
        },
        "id": {
          "type": "integer"
        },
        "name": {
          "type": "string"
        },
        "node_id": {
          "type": "string"
        },
        "prerelease": {
          "type": "boolean"
        },
        "published_at": {
          "type": "string"
        },
        "tag_name": {
          "type": "string"
        },
        "tarball_url": {
          "type": "string"
        },
        "target_commitish": {
          "type": "string"
        },
        "upload_url": {
          "type": "string"
        },
        "url": {
          "type": "string"
        },
        "zipball_url": {
          "type": "string"
        }
      }
    },
    "remoteBucket": {
      "type": "object",
      "required": [
        "accessKey",
        "sourceBucket",
        "remoteARN"
      ],
      "properties": {
        "accessKey": {
          "type": "string",
          "minLength": 3
        },
        "bandwidth": {
          "type": "integer",
          "format": "int64"
        },
        "healthCheckPeriod": {
          "type": "integer"
        },
        "remoteARN": {
          "type": "string"
        },
        "secretKey": {
          "type": "string",
          "minLength": 8
        },
        "service": {
          "type": "string",
          "enum": [
            "replication"
          ]
        },
        "sourceBucket": {
          "type": "string"
        },
        "status": {
          "type": "string"
        },
        "syncMode": {
          "type": "string"
        },
        "targetBucket": {
          "type": "string"
        },
        "targetURL": {
          "type": "string"
        }
      }
    },
    "resultTarget": {
      "type": "object",
      "properties": {
        "legendFormat": {
          "type": "string"
        },
        "result": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/widgetResult"
          }
        },
        "resultType": {
          "type": "string"
        }
      }
    },
    "rewindItem": {
      "type": "object",
      "properties": {
        "action": {
          "type": "string"
        },
        "delete_flag": {
          "type": "boolean"
        },
        "is_latest": {
          "type": "boolean"
        },
        "last_modified": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "size": {
          "type": "integer",
          "format": "int64"
        },
        "version_id": {
          "type": "string"
        }
      }
    },
    "rewindResponse": {
      "type": "object",
      "properties": {
        "objects": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/rewindItem"
          }
        }
      }
    },
    "selectedSAs": {
      "type": "array",
      "items": {
        "type": "string"
      }
    },
    "selectedUsers": {
      "type": "array",
      "items": {
        "type": "string"
      }
    },
    "serverDrives": {
      "type": "object",
      "properties": {
        "availableSpace": {
          "type": "integer"
        },
        "drivePath": {
          "type": "string"
        },
        "endpoint": {
          "type": "string"
        },
        "healing": {
          "type": "boolean"
        },
        "model": {
          "type": "string"
        },
        "rootDisk": {
          "type": "boolean"
        },
        "state": {
          "type": "string"
        },
        "totalSpace": {
          "type": "integer"
        },
        "usedSpace": {
          "type": "integer"
        },
        "uuid": {
          "type": "string"
        }
      }
    },
    "serverProperties": {
      "type": "object",
      "properties": {
        "commitID": {
          "type": "string"
        },
        "drives": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/serverDrives"
          }
        },
        "endpoint": {
          "type": "string"
        },
        "network": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "poolNumber": {
          "type": "integer"
        },
        "state": {
          "type": "string"
        },
        "uptime": {
          "type": "integer"
        },
        "version": {
          "type": "string"
        }
      }
    },
    "serviceAccount": {
      "type": "object",
      "properties": {
        "accountStatus": {
          "type": "string"
        },
        "description": {
          "type": "string"
        },
        "expiration": {
          "type": "string"
        },
        "impliedPolicy": {
          "type": "boolean"
        },
        "name": {
          "type": "string"
        },
        "parentUser": {
          "type": "string"
        },
        "policy": {
          "type": "string"
        }
      }
    },
    "serviceAccountCreds": {
      "type": "object",
      "properties": {
        "accessKey": {
          "type": "string"
        },
        "secretKey": {
          "type": "string"
        },
        "url": {
          "type": "string"
        }
      }
    },
    "serviceAccountRequest": {
      "type": "object",
      "properties": {
        "comment": {
          "type": "string"
        },
        "description": {
          "type": "string"
        },
        "expiry": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "policy": {
          "type": "string",
          "title": "policy to be applied to the Service Account if any"
        }
      }
    },
    "serviceAccountRequestCreds": {
      "type": "object",
      "properties": {
        "accessKey": {
          "type": "string"
        },
        "comment": {
          "type": "string"
        },
        "description": {
          "type": "string"
        },
        "expiry": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "policy": {
          "type": "string",
          "title": "policy to be applied to the Service Account if any"
        },
        "secretKey": {
          "type": "string"
        }
      }
    },
    "serviceAccounts": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/ServiceAccountsItems0"
      }
    },
    "sessionResponse": {
      "type": "object",
      "properties": {
        "allowResources": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/permissionResource"
          }
        },
        "customStyles": {
          "type": "string"
        },
        "distributedMode": {
          "type": "boolean"
        },
        "envConstants": {
          "$ref": "#/definitions/environmentConstants"
        },
        "features": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "operator": {
          "type": "boolean"
        },
        "permissions": {
          "type": "object",
          "additionalProperties": {
            "type": "array",
            "items": {
              "type": "string"
            }
          }
        },
        "serverEndPoint": {
          "type": "string"
        },
        "status": {
          "type": "string",
          "enum": [
            "ok"
          ]
        }
      }
    },
    "setBucketPolicyRequest": {
      "type": "object",
      "required": [
        "access"
      ],
      "properties": {
        "access": {
          "$ref": "#/definitions/bucketAccess"
        },
        "definition": {
          "type": "string"
        }
      }
    },
    "setBucketQuota": {
      "type": "object",
      "required": [
        "enabled"
      ],
      "properties": {
        "amount": {
          "type": "integer"
        },
        "enabled": {
          "type": "boolean"
        },
        "quota_type": {
          "type": "string",
          "enum": [
            "hard"
          ]
        }
      }
    },
    "setBucketVersioning": {
      "type": "object",
      "properties": {
        "enabled": {
          "type": "boolean"
        },
        "excludeFolders": {
          "type": "boolean"
        },
        "excludePrefixes": {
          "type": "array",
          "maxLength": 10,
          "items": {
            "type": "string"
          }
        }
      }
    },
    "setConfigRequest": {
      "type": "object",
      "required": [
        "key_values"
      ],
      "properties": {
        "arn_resource_id": {
          "type": "string",
          "title": "Used if configuration is an event notification's target"
        },
        "key_values": {
          "type": "array",
          "minItems": 1,
          "items": {
            "$ref": "#/definitions/configurationKV"
          }
        }
      }
    },
    "setConfigResponse": {
      "type": "object",
      "properties": {
        "restart": {
          "description": "Returns wheter server needs to restart to apply changes or not",
          "type": "boolean"
        }
      }
    },
    "setIDPResponse": {
      "type": "object",
      "properties": {
        "restart": {
          "type": "boolean"
        }
      }
    },
    "setNotificationEndpointResponse": {
      "type": "object",
      "required": [
        "service",
        "account_id",
        "properties"
      ],
      "properties": {
        "account_id": {
          "type": "string"
        },
        "properties": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "restart": {
          "type": "boolean"
        },
        "service": {
          "$ref": "#/definitions/nofiticationService"
        }
      }
    },
    "setPolicyMultipleNameRequest": {
      "type": "object",
      "properties": {
        "groups": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/iamEntity"
          }
        },
        "name": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "users": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/iamEntity"
          }
        }
      }
    },
    "setPolicyNameRequest": {
      "type": "object",
      "required": [
        "name",
        "entityType",
        "entityName"
      ],
      "properties": {
        "entityName": {
          "type": "string"
        },
        "entityType": {
          "$ref": "#/definitions/policyEntity"
        },
        "name": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "setPolicyRequest": {
      "type": "object",
      "required": [
        "entityType",
        "entityName"
      ],
      "properties": {
        "entityName": {
          "type": "string"
        },
        "entityType": {
          "$ref": "#/definitions/policyEntity"
        }
      }
    },
    "siteReplicationAddRequest": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/peerSite"
      }
    },
    "siteReplicationAddResponse": {
      "type": "object",
      "properties": {
        "errorDetail": {
          "type": "string"
        },
        "initialSyncErrorMessage": {
          "type": "string"
        },
        "status": {
          "type": "string"
        },
        "success": {
          "type": "boolean"
        }
      }
    },
    "siteReplicationInfoResponse": {
      "type": "object",
      "properties": {
        "enabled": {
          "type": "boolean"
        },
        "name": {
          "type": "string"
        },
        "serviceAccountAccessKey": {
          "type": "string"
        },
        "sites": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/peerInfo"
          }
        }
      }
    },
    "siteReplicationStatusResponse": {
      "type": "object",
      "properties": {
        "bucketStats": {
          "type": "object"
        },
        "enabled": {
          "type": "boolean"
        },
        "groupStats": {
          "type": "object"
        },
        "maxBuckets": {
          "type": "integer"
        },
        "maxGroups": {
          "type": "integer"
        },
        "maxPolicies": {
          "type": "integer"
        },
        "maxUsers": {
          "type": "integer"
        },
        "policyStats": {
          "type": "object"
        },
        "sites": {
          "type": "object"
        },
        "statsSummary": {
          "type": "object"
        },
        "userStats": {
          "type": "object"
        }
      }
    },
    "startProfilingItem": {
      "type": "object",
      "properties": {
        "error": {
          "type": "string"
        },
        "nodeName": {
          "type": "string"
        },
        "success": {
          "type": "boolean"
        }
      }
    },
    "startProfilingList": {
      "type": "object",
      "properties": {
        "startResults": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/startProfilingItem"
          }
        },
        "total": {
          "type": "integer",
          "format": "int64",
          "title": "number of start results"
        }
      }
    },
    "subnetLoginMFARequest": {
      "type": "object",
      "required": [
        "username",
        "otp",
        "mfa_token"
      ],
      "properties": {
        "mfa_token": {
          "type": "string"
        },
        "otp": {
          "type": "string"
        },
        "username": {
          "type": "string"
        }
      }
    },
    "subnetLoginRequest": {
      "type": "object",
      "properties": {
        "apiKey": {
          "type": "string"
        },
        "password": {
          "type": "string"
        },
        "username": {
          "type": "string"
        }
      }
    },
    "subnetLoginResponse": {
      "type": "object",
      "properties": {
        "access_token": {
          "type": "string"
        },
        "mfa_token": {
          "type": "string"
        },
        "organizations": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/subnetOrganization"
          }
        },
        "registered": {
          "type": "boolean"
        }
      }
    },
    "subnetOrganization": {
      "type": "object",
      "properties": {
        "accountId": {
          "type": "integer"
        },
        "company": {
          "type": "string"
        },
        "isAccountOwner": {
          "type": "boolean"
        },
        "shortName": {
          "type": "string"
        },
        "subscriptionStatus": {
          "type": "string"
        },
        "userId": {
          "type": "integer"
        }
      }
    },
    "subnetRegisterRequest": {
      "type": "object",
      "required": [
        "token",
        "account_id"
      ],
      "properties": {
        "account_id": {
          "type": "string"
        },
        "token": {
          "type": "string"
        }
      }
    },
    "tier": {
      "type": "object",
      "properties": {
        "azure": {
          "type": "object",
          "$ref": "#/definitions/tier_azure"
        },
        "gcs": {
          "type": "object",
          "$ref": "#/definitions/tier_gcs"
        },
        "minio": {
          "type": "object",
          "$ref": "#/definitions/tier_minio"
        },
        "s3": {
          "type": "object",
          "$ref": "#/definitions/tier_s3"
        },
        "status": {
          "type": "boolean"
        },
        "type": {
          "type": "string",
          "enum": [
            "s3",
            "gcs",
            "azure",
            "minio",
            "unsupported"
          ]
        }
      }
    },
    "tierCredentialsRequest": {
      "type": "object",
      "properties": {
        "access_key": {
          "type": "string"
        },
        "creds": {
          "description": "a base64 encoded value",
          "type": "string"
        },
        "secret_key": {
          "type": "string"
        }
      }
    },
    "tierListResponse": {
      "type": "object",
      "properties": {
        "items": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/tier"
          }
        }
      }
    },
    "tier_azure": {
      "type": "object",
      "properties": {
        "accountkey": {
          "type": "string"
        },
        "accountname": {
          "type": "string"
        },
        "bucket": {
          "type": "string"
        },
        "endpoint": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "objects": {
          "type": "string"
        },
        "prefix": {
          "type": "string"
        },
        "region": {
          "type": "string"
        },
        "usage": {
          "type": "string"
        },
        "versions": {
          "type": "string"
        }
      }
    },
    "tier_gcs": {
      "type": "object",
      "properties": {
        "bucket": {
          "type": "string"
        },
        "creds": {
          "type": "string"
        },
        "endpoint": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "objects": {
          "type": "string"
        },
        "prefix": {
          "type": "string"
        },
        "region": {
          "type": "string"
        },
        "usage": {
          "type": "string"
        },
        "versions": {
          "type": "string"
        }
      }
    },
    "tier_minio": {
      "type": "object",
      "properties": {
        "accesskey": {
          "type": "string"
        },
        "bucket": {
          "type": "string"
        },
        "endpoint": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "objects": {
          "type": "string"
        },
        "prefix": {
          "type": "string"
        },
        "region": {
          "type": "string"
        },
        "secretkey": {
          "type": "string"
        },
        "storageclass": {
          "type": "string"
        },
        "usage": {
          "type": "string"
        },
        "versions": {
          "type": "string"
        }
      }
    },
    "tier_s3": {
      "type": "object",
      "properties": {
        "accesskey": {
          "type": "string"
        },
        "bucket": {
          "type": "string"
        },
        "endpoint": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "objects": {
          "type": "string"
        },
        "prefix": {
          "type": "string"
        },
        "region": {
          "type": "string"
        },
        "secretkey": {
          "type": "string"
        },
        "storageclass": {
          "type": "string"
        },
        "usage": {
          "type": "string"
        },
        "versions": {
          "type": "string"
        }
      }
    },
    "transitionResponse": {
      "type": "object",
      "properties": {
        "date": {
          "type": "string"
        },
        "days": {
          "type": "integer",
          "format": "int64"
        },
        "noncurrent_storage_class": {
          "type": "string"
        },
        "noncurrent_transition_days": {
          "type": "integer",
          "format": "int64"
        },
        "storage_class": {
          "type": "string"
        }
      }
    },
    "updateBucketLifecycle": {
      "type": "object",
      "required": [
        "type"
      ],
      "properties": {
        "disable": {
          "description": "Non required, toggle to disable or enable rule",
          "type": "boolean"
        },
        "expired_object_delete_all": {
          "description": "Non required, toggle to disable or enable rule",
          "type": "boolean"
        },
        "expired_object_delete_marker": {
          "description": "Non required, toggle to disable or enable rule",
          "type": "boolean"
        },
        "expiry_days": {
          "description": "Required in case of expiry_date or transition fields are not set. it defines an expiry days for ILM",
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "noncurrentversion_expiration_days": {
          "description": "Non required, can be set in case of expiration is enabled",
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "noncurrentversion_transition_days": {
          "description": "Non required, can be set in case of transition is enabled",
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "noncurrentversion_transition_storage_class": {
          "description": "Non required, can be set in case of transition is enabled",
          "type": "string"
        },
        "prefix": {
          "description": "Non required field, it matches a prefix to perform ILM operations on it",
          "type": "string"
        },
        "storage_class": {
          "description": "Required only in case of transition is set. it refers to a tier",
          "type": "string"
        },
        "tags": {
          "description": "Non required field, tags to match ILM files",
          "type": "string"
        },
        "transition_days": {
          "description": "Required in case of transition_date or expiry fields are not set. it defines a transition days for ILM",
          "type": "integer",
          "format": "int32",
          "default": 0
        },
        "type": {
          "description": "ILM Rule type (Expiry or transition)",
          "type": "string",
          "enum": [
            "expiry",
            "transition"
          ]
        }
      }
    },
    "updateGroupRequest": {
      "type": "object",
      "required": [
        "members",
        "status"
      ],
      "properties": {
        "members": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "status": {
          "type": "string"
        }
      }
    },
    "updateServiceAccountRequest": {
      "type": "object",
      "required": [
        "policy"
      ],
      "properties": {
        "description": {
          "type": "string"
        },
        "expiry": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "policy": {
          "type": "string"
        },
        "secretKey": {
          "type": "string"
        },
        "status": {
          "type": "string"
        }
      }
    },
    "updateUser": {
      "type": "object",
      "required": [
        "status",
        "groups"
      ],
      "properties": {
        "groups": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "status": {
          "type": "string"
        }
      }
    },
    "updateUserGroups": {
      "type": "object",
      "required": [
        "groups"
      ],
      "properties": {
        "groups": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "user": {
      "type": "object",
      "properties": {
        "accessKey": {
          "type": "string"
        },
        "hasPolicy": {
          "type": "boolean"
        },
        "memberOf": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "policy": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "status": {
          "type": "string"
        }
      }
    },
    "userSAs": {
      "type": "object",
      "properties": {
        "path": {
          "type": "string"
        },
        "recursive": {
          "type": "boolean"
        },
        "versionID": {
          "type": "string"
        }
      }
    },
    "userServiceAccountItem": {
      "type": "object",
      "properties": {
        "numSAs": {
          "type": "integer",
          "format": "int64"
        },
        "userName": {
          "type": "string"
        }
      }
    },
    "userServiceAccountSummary": {
      "type": "object",
      "properties": {
        "hasSA": {
          "type": "boolean"
        },
        "userServiceAccountList": {
          "type": "array",
          "title": "list of users with number of service accounts",
          "items": {
            "$ref": "#/definitions/userServiceAccountItem"
          }
        }
      }
    },
    "widget": {
      "type": "object",
      "properties": {
        "id": {
          "type": "integer",
          "format": "int32"
        },
        "options": {
          "type": "object",
          "properties": {
            "reduceOptions": {
              "type": "object",
              "properties": {
                "calcs": {
                  "type": "array",
                  "items": {
                    "type": "string"
                  }
                }
              }
            }
          }
        },
        "targets": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/resultTarget"
          }
        },
        "title": {
          "type": "string"
        },
        "type": {
          "type": "string"
        }
      }
    },
    "widgetDetails": {
      "type": "object",
      "properties": {
        "id": {
          "type": "integer",
          "format": "int32"
        },
        "options": {
          "type": "object",
          "properties": {
            "reduceOptions": {
              "type": "object",
              "properties": {
                "calcs": {
                  "type": "array",
                  "items": {
                    "type": "string"
                  }
                }
              }
            }
          }
        },
        "targets": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/resultTarget"
          }
        },
        "title": {
          "type": "string"
        },
        "type": {
          "type": "string"
        }
      }
    },
    "widgetResult": {
      "type": "object",
      "properties": {
        "metric": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "values": {
          "type": "array",
          "items": {}
        }
      }
    }
  },
  "parameters": {
    "limit": {
      "type": "number",
      "format": "int32",
      "default": 20,
      "name": "limit",
      "in": "query"
    },
    "offset": {
      "type": "number",
      "format": "int32",
      "default": 0,
      "name": "offset",
      "in": "query"
    }
  },
  "securityDefinitions": {
    "anonymous": {
      "type": "apiKey",
      "name": "X-Anonymous",
      "in": "header"
    },
    "key": {
      "type": "oauth2",
      "flow": "accessCode",
      "authorizationUrl": "http://min.io",
      "tokenUrl": "http://min.io"
    }
  },
  "security": [
    {
      "key": []
    }
  ]
}`))
}
