// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2023 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package bucket

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/minio/console/models"
)

// AddMultiBucketLifecycleOKCode is the HTTP code returned for type AddMultiBucketLifecycleOK
const AddMultiBucketLifecycleOKCode int = 200

/*
AddMultiBucketLifecycleOK A successful response.

swagger:response addMultiBucketLifecycleOK
*/
type AddMultiBucketLifecycleOK struct {

	/*
	  In: Body
	*/
	Payload *models.MultiLifecycleResult `json:"body,omitempty"`
}

// NewAddMultiBucketLifecycleOK creates AddMultiBucketLifecycleOK with default headers values
func NewAddMultiBucketLifecycleOK() *AddMultiBucketLifecycleOK {

	return &AddMultiBucketLifecycleOK{}
}

// WithPayload adds the payload to the add multi bucket lifecycle o k response
func (o *AddMultiBucketLifecycleOK) WithPayload(payload *models.MultiLifecycleResult) *AddMultiBucketLifecycleOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the add multi bucket lifecycle o k response
func (o *AddMultiBucketLifecycleOK) SetPayload(payload *models.MultiLifecycleResult) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AddMultiBucketLifecycleOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
AddMultiBucketLifecycleDefault Generic error response.

swagger:response addMultiBucketLifecycleDefault
*/
type AddMultiBucketLifecycleDefault struct {
	_statusCode int

	/*
	  In: Body
	*/
	Payload *models.APIError `json:"body,omitempty"`
}

// NewAddMultiBucketLifecycleDefault creates AddMultiBucketLifecycleDefault with default headers values
func NewAddMultiBucketLifecycleDefault(code int) *AddMultiBucketLifecycleDefault {
	if code <= 0 {
		code = 500
	}

	return &AddMultiBucketLifecycleDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the add multi bucket lifecycle default response
func (o *AddMultiBucketLifecycleDefault) WithStatusCode(code int) *AddMultiBucketLifecycleDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the add multi bucket lifecycle default response
func (o *AddMultiBucketLifecycleDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithPayload adds the payload to the add multi bucket lifecycle default response
func (o *AddMultiBucketLifecycleDefault) WithPayload(payload *models.APIError) *AddMultiBucketLifecycleDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the add multi bucket lifecycle default response
func (o *AddMultiBucketLifecycleDefault) SetPayload(payload *models.APIError) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AddMultiBucketLifecycleDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
