// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2023 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package site_replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/minio/console/models"
)

// SiteReplicationRemoveNoContentCode is the HTTP code returned for type SiteReplicationRemoveNoContent
const SiteReplicationRemoveNoContentCode int = 204

/*
SiteReplicationRemoveNoContent A successful response.

swagger:response siteReplicationRemoveNoContent
*/
type SiteReplicationRemoveNoContent struct {

	/*
	  In: Body
	*/
	Payload *models.PeerSiteRemoveResponse `json:"body,omitempty"`
}

// NewSiteReplicationRemoveNoContent creates SiteReplicationRemoveNoContent with default headers values
func NewSiteReplicationRemoveNoContent() *SiteReplicationRemoveNoContent {

	return &SiteReplicationRemoveNoContent{}
}

// WithPayload adds the payload to the site replication remove no content response
func (o *SiteReplicationRemoveNoContent) WithPayload(payload *models.PeerSiteRemoveResponse) *SiteReplicationRemoveNoContent {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the site replication remove no content response
func (o *SiteReplicationRemoveNoContent) SetPayload(payload *models.PeerSiteRemoveResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *SiteReplicationRemoveNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(204)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
SiteReplicationRemoveDefault Generic error response.

swagger:response siteReplicationRemoveDefault
*/
type SiteReplicationRemoveDefault struct {
	_statusCode int

	/*
	  In: Body
	*/
	Payload *models.APIError `json:"body,omitempty"`
}

// NewSiteReplicationRemoveDefault creates SiteReplicationRemoveDefault with default headers values
func NewSiteReplicationRemoveDefault(code int) *SiteReplicationRemoveDefault {
	if code <= 0 {
		code = 500
	}

	return &SiteReplicationRemoveDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the site replication remove default response
func (o *SiteReplicationRemoveDefault) WithStatusCode(code int) *SiteReplicationRemoveDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the site replication remove default response
func (o *SiteReplicationRemoveDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithPayload adds the payload to the site replication remove default response
func (o *SiteReplicationRemoveDefault) WithPayload(payload *models.APIError) *SiteReplicationRemoveDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the site replication remove default response
func (o *SiteReplicationRemoveDefault) SetPayload(payload *models.APIError) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *SiteReplicationRemoveDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
