// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2023 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package subnet

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/minio/console/models"
)

// SubnetLoginMFAOKCode is the HTTP code returned for type SubnetLoginMFAOK
const SubnetLoginMFAOKCode int = 200

/*
SubnetLoginMFAOK A successful response.

swagger:response subnetLoginMFAOK
*/
type SubnetLoginMFAOK struct {

	/*
	  In: Body
	*/
	Payload *models.SubnetLoginResponse `json:"body,omitempty"`
}

// NewSubnetLoginMFAOK creates SubnetLoginMFAOK with default headers values
func NewSubnetLoginMFAOK() *SubnetLoginMFAOK {

	return &SubnetLoginMFAOK{}
}

// WithPayload adds the payload to the subnet login m f a o k response
func (o *SubnetLoginMFAOK) WithPayload(payload *models.SubnetLoginResponse) *SubnetLoginMFAOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the subnet login m f a o k response
func (o *SubnetLoginMFAOK) SetPayload(payload *models.SubnetLoginResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *SubnetLoginMFAOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
SubnetLoginMFADefault Generic error response.

swagger:response subnetLoginMFADefault
*/
type SubnetLoginMFADefault struct {
	_statusCode int

	/*
	  In: Body
	*/
	Payload *models.APIError `json:"body,omitempty"`
}

// NewSubnetLoginMFADefault creates SubnetLoginMFADefault with default headers values
func NewSubnetLoginMFADefault(code int) *SubnetLoginMFADefault {
	if code <= 0 {
		code = 500
	}

	return &SubnetLoginMFADefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the subnet login m f a default response
func (o *SubnetLoginMFADefault) WithStatusCode(code int) *SubnetLoginMFADefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the subnet login m f a default response
func (o *SubnetLoginMFADefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithPayload adds the payload to the subnet login m f a default response
func (o *SubnetLoginMFADefault) WithPayload(payload *models.APIError) *SubnetLoginMFADefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the subnet login m f a default response
func (o *SubnetLoginMFADefault) SetPayload(payload *models.APIError) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *SubnetLoginMFADefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
