// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2023 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/minio/console/models"
)

// GetCallHomeOptionValueOKCode is the HTTP code returned for type GetCallHomeOptionValueOK
const GetCallHomeOptionValueOKCode int = 200

/*
GetCallHomeOptionValueOK A successful response.

swagger:response getCallHomeOptionValueOK
*/
type GetCallHomeOptionValueOK struct {

	/*
	  In: Body
	*/
	Payload *models.CallHomeGetResponse `json:"body,omitempty"`
}

// NewGetCallHomeOptionValueOK creates GetCallHomeOptionValueOK with default headers values
func NewGetCallHomeOptionValueOK() *GetCallHomeOptionValueOK {

	return &GetCallHomeOptionValueOK{}
}

// WithPayload adds the payload to the get call home option value o k response
func (o *GetCallHomeOptionValueOK) WithPayload(payload *models.CallHomeGetResponse) *GetCallHomeOptionValueOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get call home option value o k response
func (o *GetCallHomeOptionValueOK) SetPayload(payload *models.CallHomeGetResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetCallHomeOptionValueOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetCallHomeOptionValueDefault Generic error response.

swagger:response getCallHomeOptionValueDefault
*/
type GetCallHomeOptionValueDefault struct {
	_statusCode int

	/*
	  In: Body
	*/
	Payload *models.APIError `json:"body,omitempty"`
}

// NewGetCallHomeOptionValueDefault creates GetCallHomeOptionValueDefault with default headers values
func NewGetCallHomeOptionValueDefault(code int) *GetCallHomeOptionValueDefault {
	if code <= 0 {
		code = 500
	}

	return &GetCallHomeOptionValueDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get call home option value default response
func (o *GetCallHomeOptionValueDefault) WithStatusCode(code int) *GetCallHomeOptionValueDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get call home option value default response
func (o *GetCallHomeOptionValueDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithPayload adds the payload to the get call home option value default response
func (o *GetCallHomeOptionValueDefault) WithPayload(payload *models.APIError) *GetCallHomeOptionValueDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get call home option value default response
func (o *GetCallHomeOptionValueDefault) SetPayload(payload *models.APIError) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetCallHomeOptionValueDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
