// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2023 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/minio/console/models"
)

// SetCallHomeStatusNoContentCode is the HTTP code returned for type SetCallHomeStatusNoContent
const SetCallHomeStatusNoContentCode int = 204

/*
SetCallHomeStatusNoContent A successful response.

swagger:response setCallHomeStatusNoContent
*/
type SetCallHomeStatusNoContent struct {
}

// NewSetCallHomeStatusNoContent creates SetCallHomeStatusNoContent with default headers values
func NewSetCallHomeStatusNoContent() *SetCallHomeStatusNoContent {

	return &SetCallHomeStatusNoContent{}
}

// WriteResponse to the client
func (o *SetCallHomeStatusNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

/*
SetCallHomeStatusDefault Generic error response.

swagger:response setCallHomeStatusDefault
*/
type SetCallHomeStatusDefault struct {
	_statusCode int

	/*
	  In: Body
	*/
	Payload *models.APIError `json:"body,omitempty"`
}

// NewSetCallHomeStatusDefault creates SetCallHomeStatusDefault with default headers values
func NewSetCallHomeStatusDefault(code int) *SetCallHomeStatusDefault {
	if code <= 0 {
		code = 500
	}

	return &SetCallHomeStatusDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the set call home status default response
func (o *SetCallHomeStatusDefault) WithStatusCode(code int) *SetCallHomeStatusDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the set call home status default response
func (o *SetCallHomeStatusDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithPayload adds the payload to the set call home status default response
func (o *SetCallHomeStatusDefault) WithPayload(payload *models.APIError) *SetCallHomeStatusDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the set call home status default response
func (o *SetCallHomeStatusDefault) SetPayload(payload *models.APIError) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *SetCallHomeStatusDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
