// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2023 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// LoginDetails login details
//
// swagger:model loginDetails
type LoginDetails struct {

	// animated login
	AnimatedLogin bool `json:"animatedLogin,omitempty"`

	// is k8 s
	IsK8S bool `json:"isK8S,omitempty"`

	// login strategy
	// Enum: [form redirect service-account redirect-service-account]
	LoginStrategy string `json:"loginStrategy,omitempty"`

	// redirect rules
	RedirectRules []*RedirectRule `json:"redirectRules"`
}

// Validate validates this login details
func (m *LoginDetails) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLoginStrategy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRedirectRules(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var loginDetailsTypeLoginStrategyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["form","redirect","service-account","redirect-service-account"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		loginDetailsTypeLoginStrategyPropEnum = append(loginDetailsTypeLoginStrategyPropEnum, v)
	}
}

const (

	// LoginDetailsLoginStrategyForm captures enum value "form"
	LoginDetailsLoginStrategyForm string = "form"

	// LoginDetailsLoginStrategyRedirect captures enum value "redirect"
	LoginDetailsLoginStrategyRedirect string = "redirect"

	// LoginDetailsLoginStrategyServiceDashAccount captures enum value "service-account"
	LoginDetailsLoginStrategyServiceDashAccount string = "service-account"

	// LoginDetailsLoginStrategyRedirectDashServiceDashAccount captures enum value "redirect-service-account"
	LoginDetailsLoginStrategyRedirectDashServiceDashAccount string = "redirect-service-account"
)

// prop value enum
func (m *LoginDetails) validateLoginStrategyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, loginDetailsTypeLoginStrategyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LoginDetails) validateLoginStrategy(formats strfmt.Registry) error {
	if swag.IsZero(m.LoginStrategy) { // not required
		return nil
	}

	// value enum
	if err := m.validateLoginStrategyEnum("loginStrategy", "body", m.LoginStrategy); err != nil {
		return err
	}

	return nil
}

func (m *LoginDetails) validateRedirectRules(formats strfmt.Registry) error {
	if swag.IsZero(m.RedirectRules) { // not required
		return nil
	}

	for i := 0; i < len(m.RedirectRules); i++ {
		if swag.IsZero(m.RedirectRules[i]) { // not required
			continue
		}

		if m.RedirectRules[i] != nil {
			if err := m.RedirectRules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("redirectRules" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("redirectRules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this login details based on the context it is used
func (m *LoginDetails) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateRedirectRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LoginDetails) contextValidateRedirectRules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.RedirectRules); i++ {

		if m.RedirectRules[i] != nil {

			if swag.IsZero(m.RedirectRules[i]) { // not required
				return nil
			}

			if err := m.RedirectRules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("redirectRules" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("redirectRules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *LoginDetails) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LoginDetails) UnmarshalBinary(b []byte) error {
	var res LoginDetails
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
