// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2023 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Tier tier
//
// swagger:model tier
type Tier struct {

	// azure
	Azure *TierAzure `json:"azure,omitempty"`

	// gcs
	Gcs *TierGcs `json:"gcs,omitempty"`

	// minio
	Minio *TierMinio `json:"minio,omitempty"`

	// s3
	S3 *TierS3 `json:"s3,omitempty"`

	// status
	Status bool `json:"status,omitempty"`

	// type
	// Enum: [s3 gcs azure minio unsupported]
	Type string `json:"type,omitempty"`
}

// Validate validates this tier
func (m *Tier) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAzure(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGcs(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMinio(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateS3(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Tier) validateAzure(formats strfmt.Registry) error {
	if swag.IsZero(m.Azure) { // not required
		return nil
	}

	if m.Azure != nil {
		if err := m.Azure.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("azure")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("azure")
			}
			return err
		}
	}

	return nil
}

func (m *Tier) validateGcs(formats strfmt.Registry) error {
	if swag.IsZero(m.Gcs) { // not required
		return nil
	}

	if m.Gcs != nil {
		if err := m.Gcs.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("gcs")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("gcs")
			}
			return err
		}
	}

	return nil
}

func (m *Tier) validateMinio(formats strfmt.Registry) error {
	if swag.IsZero(m.Minio) { // not required
		return nil
	}

	if m.Minio != nil {
		if err := m.Minio.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("minio")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("minio")
			}
			return err
		}
	}

	return nil
}

func (m *Tier) validateS3(formats strfmt.Registry) error {
	if swag.IsZero(m.S3) { // not required
		return nil
	}

	if m.S3 != nil {
		if err := m.S3.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("s3")
			}
			return err
		}
	}

	return nil
}

var tierTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["s3","gcs","azure","minio","unsupported"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		tierTypeTypePropEnum = append(tierTypeTypePropEnum, v)
	}
}

const (

	// TierTypeS3 captures enum value "s3"
	TierTypeS3 string = "s3"

	// TierTypeGcs captures enum value "gcs"
	TierTypeGcs string = "gcs"

	// TierTypeAzure captures enum value "azure"
	TierTypeAzure string = "azure"

	// TierTypeMinio captures enum value "minio"
	TierTypeMinio string = "minio"

	// TierTypeUnsupported captures enum value "unsupported"
	TierTypeUnsupported string = "unsupported"
)

// prop value enum
func (m *Tier) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, tierTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Tier) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this tier based on the context it is used
func (m *Tier) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAzure(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGcs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMinio(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateS3(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Tier) contextValidateAzure(ctx context.Context, formats strfmt.Registry) error {

	if m.Azure != nil {

		if swag.IsZero(m.Azure) { // not required
			return nil
		}

		if err := m.Azure.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("azure")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("azure")
			}
			return err
		}
	}

	return nil
}

func (m *Tier) contextValidateGcs(ctx context.Context, formats strfmt.Registry) error {

	if m.Gcs != nil {

		if swag.IsZero(m.Gcs) { // not required
			return nil
		}

		if err := m.Gcs.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("gcs")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("gcs")
			}
			return err
		}
	}

	return nil
}

func (m *Tier) contextValidateMinio(ctx context.Context, formats strfmt.Registry) error {

	if m.Minio != nil {

		if swag.IsZero(m.Minio) { // not required
			return nil
		}

		if err := m.Minio.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("minio")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("minio")
			}
			return err
		}
	}

	return nil
}

func (m *Tier) contextValidateS3(ctx context.Context, formats strfmt.Registry) error {

	if m.S3 != nil {

		if swag.IsZero(m.S3) { // not required
			return nil
		}

		if err := m.S3.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("s3")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Tier) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Tier) UnmarshalBinary(b []byte) error {
	var res Tier
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
