/**
 * @licstart The following is the entire license notice for the
 * JavaScript code in this page
 *
 * Copyright 2023 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @licend The above is the entire license notice for the
 * JavaScript code in this page
 */
!(function webpackUniversalModuleDefinition(e, t) {
  "object" == typeof exports && "object" == typeof module
    ? (module.exports = e.pdfjsWorker = t())
    : "function" == typeof define && define.amd
      ? define("pdfjs-dist/build/pdf.worker", [], () => (e.pdfjsWorker = t()))
      : "object" == typeof exports
        ? (exports["pdfjs-dist/build/pdf.worker"] = e.pdfjsWorker = t())
        : (e["pdfjs-dist/build/pdf.worker"] = e.pdfjsWorker = t());
})(globalThis, () =>
  (() => {
    "use strict";
    var e = [
        ,
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.WorkerTask = t.WorkerMessageHandler = void 0;
          var r = a(2),
            n = a(3),
            i = a(4),
            s = a(6),
            o = a(10),
            c = a(68),
            l = a(73),
            h = a(104),
            u = a(105),
            d = a(72);
          class WorkerTask {
            constructor(e) {
              this.name = e;
              this.terminated = !1;
              this._capability = new r.PromiseCapability();
            }
            get finished() {
              return this._capability.promise;
            }
            finish() {
              this._capability.resolve();
            }
            terminate() {
              this.terminated = !0;
            }
            ensureNotTerminated() {
              if (this.terminated)
                throw new Error("Worker task was terminated");
            }
          }
          t.WorkerTask = WorkerTask;
          class WorkerMessageHandler {
            static setup(e, t) {
              let a = !1;
              e.on("test", function (t) {
                if (!a) {
                  a = !0;
                  e.send("test", t instanceof Uint8Array);
                }
              });
              e.on("configure", function (e) {
                (0, r.setVerbosityLevel)(e.verbosity);
              });
              e.on("GetDocRequest", function (e) {
                return WorkerMessageHandler.createDocumentHandler(e, t);
              });
            }
            static createDocumentHandler(e, t) {
              let a,
                f = !1,
                g = null;
              const p = new Set(),
                m = (0, r.getVerbosityLevel)(),
                { docId: b, apiVersion: y } = e,
                w = "3.11.174";
              if (y !== w)
                throw new Error(
                  `The API version "${y}" does not match the Worker version "${w}".`,
                );
              const S = [];
              for (const e in []) S.push(e);
              if (S.length)
                throw new Error(
                  "The `Array.prototype` contains unexpected enumerable properties: " +
                    S.join(", ") +
                    "; thus breaking e.g. `for...in` iteration of `Array`s.",
                );
              const x = b + "_worker";
              let C = new h.MessageHandler(x, b, t);
              function ensureNotTerminated() {
                if (f) throw new Error("Worker was terminated");
              }
              function startWorkerTask(e) {
                p.add(e);
              }
              function finishWorkerTask(e) {
                e.finish();
                p.delete(e);
              }
              async function loadDocument(e) {
                await a.ensureDoc("checkHeader");
                await a.ensureDoc("parseStartXRef");
                await a.ensureDoc("parse", [e]);
                await a.ensureDoc("checkFirstPage", [e]);
                await a.ensureDoc("checkLastPage", [e]);
                const t = await a.ensureDoc("isPureXfa");
                if (t) {
                  const e = new WorkerTask("loadXfaFonts");
                  startWorkerTask(e);
                  await Promise.all([
                    a
                      .loadXfaFonts(C, e)
                      .catch((e) => {})
                      .then(() => finishWorkerTask(e)),
                    a.loadXfaImages(),
                  ]);
                }
                const [r, n] = await Promise.all([
                  a.ensureDoc("numPages"),
                  a.ensureDoc("fingerprints"),
                ]);
                return {
                  numPages: r,
                  fingerprints: n,
                  htmlForXfa: t ? await a.ensureDoc("htmlForXfa") : null,
                };
              }
              function getPdfManager({
                data: e,
                password: t,
                disableAutoFetch: a,
                rangeChunkSize: i,
                length: o,
                docBaseUrl: c,
                enableXfa: l,
                evaluatorOptions: h,
              }) {
                const d = {
                    source: null,
                    disableAutoFetch: a,
                    docBaseUrl: c,
                    docId: b,
                    enableXfa: l,
                    evaluatorOptions: h,
                    handler: C,
                    length: o,
                    password: t,
                    rangeChunkSize: i,
                  },
                  f = new r.PromiseCapability();
                let p;
                if (e) {
                  try {
                    d.source = e;
                    p = new s.LocalPdfManager(d);
                    f.resolve(p);
                  } catch (e) {
                    f.reject(e);
                  }
                  return f.promise;
                }
                let m,
                  y = [];
                try {
                  m = new u.PDFWorkerStream(C);
                } catch (e) {
                  f.reject(e);
                  return f.promise;
                }
                const w = m.getFullReader();
                w.headersReady
                  .then(function () {
                    if (w.isRangeSupported) {
                      d.source = m;
                      d.length = w.contentLength;
                      d.disableAutoFetch ||= w.isStreamingSupported;
                      p = new s.NetworkPdfManager(d);
                      for (const e of y) p.sendProgressiveData(e);
                      y = [];
                      f.resolve(p);
                      g = null;
                    }
                  })
                  .catch(function (e) {
                    f.reject(e);
                    g = null;
                  });
                let S = 0;
                new Promise(function (e, t) {
                  const readChunk = function ({ value: e, done: a }) {
                    try {
                      ensureNotTerminated();
                      if (a) {
                        p ||
                          (function () {
                            const e = (0, n.arrayBuffersToBytes)(y);
                            o &&
                              e.length !== o &&
                              (0, r.warn)(
                                "reported HTTP length is different from actual",
                              );
                            try {
                              d.source = e;
                              p = new s.LocalPdfManager(d);
                              f.resolve(p);
                            } catch (e) {
                              f.reject(e);
                            }
                            y = [];
                          })();
                        g = null;
                        return;
                      }
                      S += e.byteLength;
                      w.isStreamingSupported ||
                        C.send("DocProgress", {
                          loaded: S,
                          total: Math.max(S, w.contentLength || 0),
                        });
                      p ? p.sendProgressiveData(e) : y.push(e);
                      w.read().then(readChunk, t);
                    } catch (e) {
                      t(e);
                    }
                  };
                  w.read().then(readChunk, t);
                }).catch(function (e) {
                  f.reject(e);
                  g = null;
                });
                g = function (e) {
                  m.cancelAllRequests(e);
                };
                return f.promise;
              }
              C.on("GetPage", function (e) {
                return a.getPage(e.pageIndex).then(function (e) {
                  return Promise.all([
                    a.ensure(e, "rotate"),
                    a.ensure(e, "ref"),
                    a.ensure(e, "userUnit"),
                    a.ensure(e, "view"),
                  ]).then(function ([e, t, a, r]) {
                    return { rotate: e, ref: t, userUnit: a, view: r };
                  });
                });
              });
              C.on("GetPageIndex", function (e) {
                const t = i.Ref.get(e.num, e.gen);
                return a.ensureCatalog("getPageIndex", [t]);
              });
              C.on("GetDestinations", function (e) {
                return a.ensureCatalog("destinations");
              });
              C.on("GetDestination", function (e) {
                return a.ensureCatalog("getDestination", [e.id]);
              });
              C.on("GetPageLabels", function (e) {
                return a.ensureCatalog("pageLabels");
              });
              C.on("GetPageLayout", function (e) {
                return a.ensureCatalog("pageLayout");
              });
              C.on("GetPageMode", function (e) {
                return a.ensureCatalog("pageMode");
              });
              C.on("GetViewerPreferences", function (e) {
                return a.ensureCatalog("viewerPreferences");
              });
              C.on("GetOpenAction", function (e) {
                return a.ensureCatalog("openAction");
              });
              C.on("GetAttachments", function (e) {
                return a.ensureCatalog("attachments");
              });
              C.on("GetDocJSActions", function (e) {
                return a.ensureCatalog("jsActions");
              });
              C.on("GetPageJSActions", function ({ pageIndex: e }) {
                return a.getPage(e).then(function (e) {
                  return a.ensure(e, "jsActions");
                });
              });
              C.on("GetOutline", function (e) {
                return a.ensureCatalog("documentOutline");
              });
              C.on("GetOptionalContentConfig", function (e) {
                return a.ensureCatalog("optionalContentConfig");
              });
              C.on("GetPermissions", function (e) {
                return a.ensureCatalog("permissions");
              });
              C.on("GetMetadata", function (e) {
                return Promise.all([
                  a.ensureDoc("documentInfo"),
                  a.ensureCatalog("metadata"),
                ]);
              });
              C.on("GetMarkInfo", function (e) {
                return a.ensureCatalog("markInfo");
              });
              C.on("GetData", function (e) {
                return a.requestLoadedStream().then(function (e) {
                  return e.bytes;
                });
              });
              C.on("GetAnnotations", function ({ pageIndex: e, intent: t }) {
                return a.getPage(e).then(function (a) {
                  const r = new WorkerTask(`GetAnnotations: page ${e}`);
                  startWorkerTask(r);
                  return a.getAnnotationsData(C, r, t).then(
                    (e) => {
                      finishWorkerTask(r);
                      return e;
                    },
                    (e) => {
                      finishWorkerTask(r);
                      throw e;
                    },
                  );
                });
              });
              C.on("GetFieldObjects", function (e) {
                return a.ensureDoc("fieldObjects");
              });
              C.on("HasJSActions", function (e) {
                return a.ensureDoc("hasJSActions");
              });
              C.on("GetCalculationOrderIds", function (e) {
                return a.ensureDoc("calculationOrderIds");
              });
              C.on(
                "SaveDocument",
                async function ({
                  isPureXfa: e,
                  numPages: t,
                  annotationStorage: s,
                  filename: c,
                }) {
                  const h = [
                      a.requestLoadedStream(),
                      a.ensureCatalog("acroForm"),
                      a.ensureCatalog("acroFormRef"),
                      a.ensureDoc("startXRef"),
                      a.ensureDoc("xref"),
                      a.ensureDoc("linearization"),
                      a.ensureCatalog("structTreeRoot"),
                    ],
                    u = [],
                    f = e ? null : (0, n.getNewAnnotationsMap)(s),
                    [g, p, m, b, y, w, S] = await Promise.all(h),
                    x = y.trailer.getRaw("Root") || null;
                  let k;
                  if (f) {
                    S
                      ? (await S.canUpdateStructTree({
                          pdfManager: a,
                          newAnnotationsByPage: f,
                        })) && (k = S)
                      : (await d.StructTreeRoot.canCreateStructureTree({
                          catalogRef: x,
                          pdfManager: a,
                          newAnnotationsByPage: f,
                        })) && (k = null);
                    const e = o.AnnotationFactory.generateImages(
                        s.values(),
                        y,
                        a.evaluatorOptions.isOffscreenCanvasSupported,
                      ),
                      t = void 0 === k ? u : [];
                    for (const [r, n] of f)
                      t.push(
                        a.getPage(r).then((t) => {
                          const a = new WorkerTask(`Save (editor): page ${r}`);
                          return t
                            .saveNewAnnotations(C, a, n, e)
                            .finally(function () {
                              finishWorkerTask(a);
                            });
                        }),
                      );
                    null === k
                      ? u.push(
                          Promise.all(t).then(async (e) => {
                            await d.StructTreeRoot.createStructureTree({
                              newAnnotationsByPage: f,
                              xref: y,
                              catalogRef: x,
                              pdfManager: a,
                              newRefs: e,
                            });
                            return e;
                          }),
                        )
                      : k &&
                        u.push(
                          Promise.all(t).then(async (e) => {
                            await k.updateStructureTree({
                              newAnnotationsByPage: f,
                              pdfManager: a,
                              newRefs: e,
                            });
                            return e;
                          }),
                        );
                  }
                  if (e) u.push(a.serializeXfaData(s));
                  else
                    for (let e = 0; e < t; e++)
                      u.push(
                        a.getPage(e).then(function (t) {
                          const a = new WorkerTask(`Save: page ${e}`);
                          return t.save(C, a, s).finally(function () {
                            finishWorkerTask(a);
                          });
                        }),
                      );
                  const v = await Promise.all(u);
                  let F = [],
                    O = null;
                  if (e) {
                    O = v[0];
                    if (!O) return g.bytes;
                  } else {
                    F = v.flat(2);
                    if (0 === F.length) return g.bytes;
                  }
                  const T =
                      m &&
                      p instanceof i.Dict &&
                      F.some((e) => e.needAppearances),
                    M = (p instanceof i.Dict && p.get("XFA")) || null;
                  let D = null,
                    E = !1;
                  if (Array.isArray(M)) {
                    for (let e = 0, t = M.length; e < t; e += 2)
                      if ("datasets" === M[e]) {
                        D = M[e + 1];
                        E = !0;
                      }
                    null === D && (D = y.getNewTemporaryRef());
                  } else M && (0, r.warn)("Unsupported XFA type.");
                  let N = Object.create(null);
                  if (y.trailer) {
                    const e = Object.create(null),
                      t = y.trailer.get("Info") || null;
                    t instanceof i.Dict &&
                      t.forEach((t, a) => {
                        "string" == typeof a &&
                          (e[t] = (0, r.stringToPDFString)(a));
                      });
                    N = {
                      rootRef: x,
                      encryptRef: y.trailer.getRaw("Encrypt") || null,
                      newRef: y.getNewTemporaryRef(),
                      infoRef: y.trailer.getRaw("Info") || null,
                      info: e,
                      fileIds: y.trailer.get("ID") || null,
                      startXRef: w ? b : y.lastXRefStreamPos ?? b,
                      filename: c,
                    };
                  }
                  return (0, l.incrementalUpdate)({
                    originalData: g.bytes,
                    xrefInfo: N,
                    newRefs: F,
                    xref: y,
                    hasXfa: !!M,
                    xfaDatasetsRef: D,
                    hasXfaDatasetsEntry: E,
                    needAppearances: T,
                    acroFormRef: m,
                    acroForm: p,
                    xfaData: O,
                  }).finally(() => {
                    y.resetNewTemporaryRef();
                  });
                },
              );
              C.on("GetOperatorList", function (e, t) {
                const n = e.pageIndex;
                a.getPage(n).then(function (a) {
                  const i = new WorkerTask(`GetOperatorList: page ${n}`);
                  startWorkerTask(i);
                  const s = m >= r.VerbosityLevel.INFOS ? Date.now() : 0;
                  a.getOperatorList({
                    handler: C,
                    sink: t,
                    task: i,
                    intent: e.intent,
                    cacheKey: e.cacheKey,
                    annotationStorage: e.annotationStorage,
                  }).then(
                    function (e) {
                      finishWorkerTask(i);
                      s &&
                        (0, r.info)(
                          `page=${n + 1} - getOperatorList: time=${
                            Date.now() - s
                          }ms, len=${e.length}`,
                        );
                      t.close();
                    },
                    function (e) {
                      finishWorkerTask(i);
                      i.terminated || t.error(e);
                    },
                  );
                });
              });
              C.on("GetTextContent", function (e, t) {
                const {
                  pageIndex: n,
                  includeMarkedContent: i,
                  disableNormalization: s,
                } = e;
                a.getPage(n).then(function (e) {
                  const a = new WorkerTask("GetTextContent: page " + n);
                  startWorkerTask(a);
                  const o = m >= r.VerbosityLevel.INFOS ? Date.now() : 0;
                  e.extractTextContent({
                    handler: C,
                    task: a,
                    sink: t,
                    includeMarkedContent: i,
                    disableNormalization: s,
                  }).then(
                    function () {
                      finishWorkerTask(a);
                      o &&
                        (0, r.info)(
                          `page=${n + 1} - getTextContent: time=` +
                            (Date.now() - o) +
                            "ms",
                        );
                      t.close();
                    },
                    function (e) {
                      finishWorkerTask(a);
                      a.terminated || t.error(e);
                    },
                  );
                });
              });
              C.on("GetStructTree", function (e) {
                return a.getPage(e.pageIndex).then(function (e) {
                  return a.ensure(e, "getStructTree");
                });
              });
              C.on("FontFallback", function (e) {
                return a.fontFallback(e.id, C);
              });
              C.on("Cleanup", function (e) {
                return a.cleanup(!0);
              });
              C.on("Terminate", function (e) {
                f = !0;
                const t = [];
                if (a) {
                  a.terminate(new r.AbortException("Worker was terminated."));
                  const e = a.cleanup();
                  t.push(e);
                  a = null;
                } else (0, c.clearGlobalCaches)();
                g && g(new r.AbortException("Worker was terminated."));
                for (const e of p) {
                  t.push(e.finished);
                  e.terminate();
                }
                return Promise.all(t).then(function () {
                  C.destroy();
                  C = null;
                });
              });
              C.on("Ready", function (t) {
                !(function setupDoc(e) {
                  function onSuccess(e) {
                    ensureNotTerminated();
                    C.send("GetDoc", { pdfInfo: e });
                  }
                  function onFailure(e) {
                    ensureNotTerminated();
                    if (e instanceof r.PasswordException) {
                      const t = new WorkerTask(
                        `PasswordException: response ${e.code}`,
                      );
                      startWorkerTask(t);
                      C.sendWithPromise("PasswordRequest", e)
                        .then(function ({ password: e }) {
                          finishWorkerTask(t);
                          a.updatePassword(e);
                          pdfManagerReady();
                        })
                        .catch(function () {
                          finishWorkerTask(t);
                          C.send("DocException", e);
                        });
                    } else
                      e instanceof r.InvalidPDFException ||
                      e instanceof r.MissingPDFException ||
                      e instanceof r.UnexpectedResponseException ||
                      e instanceof r.UnknownErrorException
                        ? C.send("DocException", e)
                        : C.send(
                            "DocException",
                            new r.UnknownErrorException(
                              e.message,
                              e.toString(),
                            ),
                          );
                  }
                  function pdfManagerReady() {
                    ensureNotTerminated();
                    loadDocument(!1).then(onSuccess, function (e) {
                      ensureNotTerminated();
                      e instanceof n.XRefParseException
                        ? a.requestLoadedStream().then(function () {
                            ensureNotTerminated();
                            loadDocument(!0).then(onSuccess, onFailure);
                          })
                        : onFailure(e);
                    });
                  }
                  ensureNotTerminated();
                  getPdfManager(e)
                    .then(function (e) {
                      if (f) {
                        e.terminate(
                          new r.AbortException("Worker was terminated."),
                        );
                        throw new Error("Worker was terminated");
                      }
                      a = e;
                      a.requestLoadedStream(!0).then((e) => {
                        C.send("DataLoaded", { length: e.bytes.byteLength });
                      });
                    })
                    .then(pdfManagerReady, onFailure);
                })(e);
                e = null;
              });
              return x;
            }
            static initializeFromPort(e) {
              const t = new h.MessageHandler("worker", "main", e);
              WorkerMessageHandler.setup(t, e);
              t.send("ready", null);
            }
          }
          t.WorkerMessageHandler = WorkerMessageHandler;
          "undefined" == typeof window &&
            !r.isNodeJS &&
            "undefined" != typeof self &&
            (function isMessagePort(e) {
              return "function" == typeof e.postMessage && "onmessage" in e;
            })(self) &&
            WorkerMessageHandler.initializeFromPort(self);
        },
        (e, t) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.VerbosityLevel =
            t.Util =
            t.UnknownErrorException =
            t.UnexpectedResponseException =
            t.TextRenderingMode =
            t.RenderingIntentFlag =
            t.PromiseCapability =
            t.PermissionFlag =
            t.PasswordResponses =
            t.PasswordException =
            t.PageActionEventType =
            t.OPS =
            t.MissingPDFException =
            t.MAX_IMAGE_SIZE_TO_CACHE =
            t.LINE_FACTOR =
            t.LINE_DESCENT_FACTOR =
            t.InvalidPDFException =
            t.ImageKind =
            t.IDENTITY_MATRIX =
            t.FormatError =
            t.FeatureTest =
            t.FONT_IDENTITY_MATRIX =
            t.DocumentActionEventType =
            t.CMapCompressionType =
            t.BaseException =
            t.BASELINE_FACTOR =
            t.AnnotationType =
            t.AnnotationReplyType =
            t.AnnotationPrefix =
            t.AnnotationMode =
            t.AnnotationFlag =
            t.AnnotationFieldFlag =
            t.AnnotationEditorType =
            t.AnnotationEditorPrefix =
            t.AnnotationEditorParamsType =
            t.AnnotationBorderStyleType =
            t.AnnotationActionEventType =
            t.AbortException =
              void 0;
          t.assert = function assert(e, t) {
            e || unreachable(t);
          };
          t.bytesToString = bytesToString;
          t.createValidAbsoluteUrl = function createValidAbsoluteUrl(
            e,
            t = null,
            a = null,
          ) {
            if (!e) return null;
            try {
              if (a && "string" == typeof e) {
                if (a.addDefaultProtocol && e.startsWith("www.")) {
                  const t = e.match(/\./g);
                  t?.length >= 2 && (e = `http://${e}`);
                }
                if (a.tryConvertEncoding)
                  try {
                    e = stringToUTF8String(e);
                  } catch {}
              }
              const r = t ? new URL(e, t) : new URL(e);
              if (
                (function _isValidProtocol(e) {
                  switch (e?.protocol) {
                    case "http:":
                    case "https:":
                    case "ftp:":
                    case "mailto:":
                    case "tel:":
                      return !0;
                    default:
                      return !1;
                  }
                })(r)
              )
                return r;
            } catch {}
            return null;
          };
          t.getModificationDate = function getModificationDate(e = new Date()) {
            return [
              e.getUTCFullYear().toString(),
              (e.getUTCMonth() + 1).toString().padStart(2, "0"),
              e.getUTCDate().toString().padStart(2, "0"),
              e.getUTCHours().toString().padStart(2, "0"),
              e.getUTCMinutes().toString().padStart(2, "0"),
              e.getUTCSeconds().toString().padStart(2, "0"),
            ].join("");
          };
          t.getUuid = function getUuid() {
            if (
              "undefined" != typeof crypto &&
              "function" == typeof crypto?.randomUUID
            )
              return crypto.randomUUID();
            const e = new Uint8Array(32);
            if (
              "undefined" != typeof crypto &&
              "function" == typeof crypto?.getRandomValues
            )
              crypto.getRandomValues(e);
            else
              for (let t = 0; t < 32; t++)
                e[t] = Math.floor(255 * Math.random());
            return bytesToString(e);
          };
          t.getVerbosityLevel = function getVerbosityLevel() {
            return n;
          };
          t.info = function info(e) {
            n >= r.INFOS && console.log(`Info: ${e}`);
          };
          t.isArrayBuffer = function isArrayBuffer(e) {
            return "object" == typeof e && void 0 !== e?.byteLength;
          };
          t.isArrayEqual = function isArrayEqual(e, t) {
            if (e.length !== t.length) return !1;
            for (let a = 0, r = e.length; a < r; a++)
              if (e[a] !== t[a]) return !1;
            return !0;
          };
          t.isNodeJS = void 0;
          t.normalizeUnicode = function normalizeUnicode(e) {
            if (!c) {
              c =
                /([\u00a0\u00b5\u037e\u0eb3\u2000-\u200a\u202f\u2126\ufb00-\ufb04\ufb06\ufb20-\ufb36\ufb38-\ufb3c\ufb3e\ufb40-\ufb41\ufb43-\ufb44\ufb46-\ufba1\ufba4-\ufba9\ufbae-\ufbb1\ufbd3-\ufbdc\ufbde-\ufbe7\ufbea-\ufbf8\ufbfc-\ufbfd\ufc00-\ufc5d\ufc64-\ufcf1\ufcf5-\ufd3d\ufd88\ufdf4\ufdfa-\ufdfb\ufe71\ufe77\ufe79\ufe7b\ufe7d]+)|(\ufb05+)/gu;
              l = new Map([["ﬅ", "ſt"]]);
            }
            return e.replaceAll(c, (e, t, a) =>
              t ? t.normalize("NFKC") : l.get(a),
            );
          };
          t.objectFromMap = function objectFromMap(e) {
            const t = Object.create(null);
            for (const [a, r] of e) t[a] = r;
            return t;
          };
          t.objectSize = function objectSize(e) {
            return Object.keys(e).length;
          };
          t.setVerbosityLevel = function setVerbosityLevel(e) {
            Number.isInteger(e) && (n = e);
          };
          t.shadow = shadow;
          t.string32 = function string32(e) {
            return String.fromCharCode(
              (e >> 24) & 255,
              (e >> 16) & 255,
              (e >> 8) & 255,
              255 & e,
            );
          };
          t.stringToBytes = stringToBytes;
          t.stringToPDFString = function stringToPDFString(e) {
            if (e[0] >= "ï") {
              let t;
              "þ" === e[0] && "ÿ" === e[1]
                ? (t = "utf-16be")
                : "ÿ" === e[0] && "þ" === e[1]
                  ? (t = "utf-16le")
                  : "ï" === e[0] &&
                    "»" === e[1] &&
                    "¿" === e[2] &&
                    (t = "utf-8");
              if (t)
                try {
                  const a = new TextDecoder(t, { fatal: !0 }),
                    r = stringToBytes(e);
                  return a.decode(r);
                } catch (e) {
                  warn(`stringToPDFString: "${e}".`);
                }
            }
            const t = [];
            for (let a = 0, r = e.length; a < r; a++) {
              const r = o[e.charCodeAt(a)];
              t.push(r ? String.fromCharCode(r) : e.charAt(a));
            }
            return t.join("");
          };
          t.stringToUTF8String = stringToUTF8String;
          t.unreachable = unreachable;
          t.utf8StringToString = function utf8StringToString(e) {
            return unescape(encodeURIComponent(e));
          };
          t.warn = warn;
          const a = !(
            "object" != typeof process ||
            process + "" != "[object process]" ||
            process.versions.nw ||
            (process.versions.electron &&
              process.type &&
              "browser" !== process.type)
          );
          t.isNodeJS = a;
          t.IDENTITY_MATRIX = [1, 0, 0, 1, 0, 0];
          t.FONT_IDENTITY_MATRIX = [0.001, 0, 0, 0.001, 0, 0];
          t.MAX_IMAGE_SIZE_TO_CACHE = 1e7;
          t.LINE_FACTOR = 1.35;
          t.LINE_DESCENT_FACTOR = 0.35;
          t.BASELINE_FACTOR = 0.25925925925925924;
          t.RenderingIntentFlag = {
            ANY: 1,
            DISPLAY: 2,
            PRINT: 4,
            SAVE: 8,
            ANNOTATIONS_FORMS: 16,
            ANNOTATIONS_STORAGE: 32,
            ANNOTATIONS_DISABLE: 64,
            OPLIST: 256,
          };
          t.AnnotationMode = {
            DISABLE: 0,
            ENABLE: 1,
            ENABLE_FORMS: 2,
            ENABLE_STORAGE: 3,
          };
          t.AnnotationEditorPrefix = "pdfjs_internal_editor_";
          t.AnnotationEditorType = {
            DISABLE: -1,
            NONE: 0,
            FREETEXT: 3,
            STAMP: 13,
            INK: 15,
          };
          t.AnnotationEditorParamsType = {
            RESIZE: 1,
            CREATE: 2,
            FREETEXT_SIZE: 11,
            FREETEXT_COLOR: 12,
            FREETEXT_OPACITY: 13,
            INK_COLOR: 21,
            INK_THICKNESS: 22,
            INK_OPACITY: 23,
          };
          t.PermissionFlag = {
            PRINT: 4,
            MODIFY_CONTENTS: 8,
            COPY: 16,
            MODIFY_ANNOTATIONS: 32,
            FILL_INTERACTIVE_FORMS: 256,
            COPY_FOR_ACCESSIBILITY: 512,
            ASSEMBLE: 1024,
            PRINT_HIGH_QUALITY: 2048,
          };
          t.TextRenderingMode = {
            FILL: 0,
            STROKE: 1,
            FILL_STROKE: 2,
            INVISIBLE: 3,
            FILL_ADD_TO_PATH: 4,
            STROKE_ADD_TO_PATH: 5,
            FILL_STROKE_ADD_TO_PATH: 6,
            ADD_TO_PATH: 7,
            FILL_STROKE_MASK: 3,
            ADD_TO_PATH_FLAG: 4,
          };
          t.ImageKind = { GRAYSCALE_1BPP: 1, RGB_24BPP: 2, RGBA_32BPP: 3 };
          t.AnnotationType = {
            TEXT: 1,
            LINK: 2,
            FREETEXT: 3,
            LINE: 4,
            SQUARE: 5,
            CIRCLE: 6,
            POLYGON: 7,
            POLYLINE: 8,
            HIGHLIGHT: 9,
            UNDERLINE: 10,
            SQUIGGLY: 11,
            STRIKEOUT: 12,
            STAMP: 13,
            CARET: 14,
            INK: 15,
            POPUP: 16,
            FILEATTACHMENT: 17,
            SOUND: 18,
            MOVIE: 19,
            WIDGET: 20,
            SCREEN: 21,
            PRINTERMARK: 22,
            TRAPNET: 23,
            WATERMARK: 24,
            THREED: 25,
            REDACT: 26,
          };
          t.AnnotationReplyType = { GROUP: "Group", REPLY: "R" };
          t.AnnotationFlag = {
            INVISIBLE: 1,
            HIDDEN: 2,
            PRINT: 4,
            NOZOOM: 8,
            NOROTATE: 16,
            NOVIEW: 32,
            READONLY: 64,
            LOCKED: 128,
            TOGGLENOVIEW: 256,
            LOCKEDCONTENTS: 512,
          };
          t.AnnotationFieldFlag = {
            READONLY: 1,
            REQUIRED: 2,
            NOEXPORT: 4,
            MULTILINE: 4096,
            PASSWORD: 8192,
            NOTOGGLETOOFF: 16384,
            RADIO: 32768,
            PUSHBUTTON: 65536,
            COMBO: 131072,
            EDIT: 262144,
            SORT: 524288,
            FILESELECT: 1048576,
            MULTISELECT: 2097152,
            DONOTSPELLCHECK: 4194304,
            DONOTSCROLL: 8388608,
            COMB: 16777216,
            RICHTEXT: 33554432,
            RADIOSINUNISON: 33554432,
            COMMITONSELCHANGE: 67108864,
          };
          t.AnnotationBorderStyleType = {
            SOLID: 1,
            DASHED: 2,
            BEVELED: 3,
            INSET: 4,
            UNDERLINE: 5,
          };
          t.AnnotationActionEventType = {
            E: "Mouse Enter",
            X: "Mouse Exit",
            D: "Mouse Down",
            U: "Mouse Up",
            Fo: "Focus",
            Bl: "Blur",
            PO: "PageOpen",
            PC: "PageClose",
            PV: "PageVisible",
            PI: "PageInvisible",
            K: "Keystroke",
            F: "Format",
            V: "Validate",
            C: "Calculate",
          };
          t.DocumentActionEventType = {
            WC: "WillClose",
            WS: "WillSave",
            DS: "DidSave",
            WP: "WillPrint",
            DP: "DidPrint",
          };
          t.PageActionEventType = { O: "PageOpen", C: "PageClose" };
          const r = { ERRORS: 0, WARNINGS: 1, INFOS: 5 };
          t.VerbosityLevel = r;
          t.CMapCompressionType = { NONE: 0, BINARY: 1 };
          t.OPS = {
            dependency: 1,
            setLineWidth: 2,
            setLineCap: 3,
            setLineJoin: 4,
            setMiterLimit: 5,
            setDash: 6,
            setRenderingIntent: 7,
            setFlatness: 8,
            setGState: 9,
            save: 10,
            restore: 11,
            transform: 12,
            moveTo: 13,
            lineTo: 14,
            curveTo: 15,
            curveTo2: 16,
            curveTo3: 17,
            closePath: 18,
            rectangle: 19,
            stroke: 20,
            closeStroke: 21,
            fill: 22,
            eoFill: 23,
            fillStroke: 24,
            eoFillStroke: 25,
            closeFillStroke: 26,
            closeEOFillStroke: 27,
            endPath: 28,
            clip: 29,
            eoClip: 30,
            beginText: 31,
            endText: 32,
            setCharSpacing: 33,
            setWordSpacing: 34,
            setHScale: 35,
            setLeading: 36,
            setFont: 37,
            setTextRenderingMode: 38,
            setTextRise: 39,
            moveText: 40,
            setLeadingMoveText: 41,
            setTextMatrix: 42,
            nextLine: 43,
            showText: 44,
            showSpacedText: 45,
            nextLineShowText: 46,
            nextLineSetSpacingShowText: 47,
            setCharWidth: 48,
            setCharWidthAndBounds: 49,
            setStrokeColorSpace: 50,
            setFillColorSpace: 51,
            setStrokeColor: 52,
            setStrokeColorN: 53,
            setFillColor: 54,
            setFillColorN: 55,
            setStrokeGray: 56,
            setFillGray: 57,
            setStrokeRGBColor: 58,
            setFillRGBColor: 59,
            setStrokeCMYKColor: 60,
            setFillCMYKColor: 61,
            shadingFill: 62,
            beginInlineImage: 63,
            beginImageData: 64,
            endInlineImage: 65,
            paintXObject: 66,
            markPoint: 67,
            markPointProps: 68,
            beginMarkedContent: 69,
            beginMarkedContentProps: 70,
            endMarkedContent: 71,
            beginCompat: 72,
            endCompat: 73,
            paintFormXObjectBegin: 74,
            paintFormXObjectEnd: 75,
            beginGroup: 76,
            endGroup: 77,
            beginAnnotation: 80,
            endAnnotation: 81,
            paintImageMaskXObject: 83,
            paintImageMaskXObjectGroup: 84,
            paintImageXObject: 85,
            paintInlineImageXObject: 86,
            paintInlineImageXObjectGroup: 87,
            paintImageXObjectRepeat: 88,
            paintImageMaskXObjectRepeat: 89,
            paintSolidColorImageMask: 90,
            constructPath: 91,
          };
          t.PasswordResponses = { NEED_PASSWORD: 1, INCORRECT_PASSWORD: 2 };
          let n = r.WARNINGS;
          function warn(e) {
            n >= r.WARNINGS && console.log(`Warning: ${e}`);
          }
          function unreachable(e) {
            throw new Error(e);
          }
          function shadow(e, t, a, r = !1) {
            Object.defineProperty(e, t, {
              value: a,
              enumerable: !r,
              configurable: !0,
              writable: !1,
            });
            return a;
          }
          const i = (function BaseExceptionClosure() {
            function BaseException(e, t) {
              this.constructor === BaseException &&
                unreachable("Cannot initialize BaseException.");
              this.message = e;
              this.name = t;
            }
            BaseException.prototype = new Error();
            BaseException.constructor = BaseException;
            return BaseException;
          })();
          t.BaseException = i;
          t.PasswordException = class PasswordException extends i {
            constructor(e, t) {
              super(e, "PasswordException");
              this.code = t;
            }
          };
          t.UnknownErrorException = class UnknownErrorException extends i {
            constructor(e, t) {
              super(e, "UnknownErrorException");
              this.details = t;
            }
          };
          t.InvalidPDFException = class InvalidPDFException extends i {
            constructor(e) {
              super(e, "InvalidPDFException");
            }
          };
          t.MissingPDFException = class MissingPDFException extends i {
            constructor(e) {
              super(e, "MissingPDFException");
            }
          };
          t.UnexpectedResponseException = class UnexpectedResponseException extends (
            i
          ) {
            constructor(e, t) {
              super(e, "UnexpectedResponseException");
              this.status = t;
            }
          };
          t.FormatError = class FormatError extends i {
            constructor(e) {
              super(e, "FormatError");
            }
          };
          t.AbortException = class AbortException extends i {
            constructor(e) {
              super(e, "AbortException");
            }
          };
          function bytesToString(e) {
            ("object" == typeof e && void 0 !== e?.length) ||
              unreachable("Invalid argument for bytesToString");
            const t = e.length,
              a = 8192;
            if (t < a) return String.fromCharCode.apply(null, e);
            const r = [];
            for (let n = 0; n < t; n += a) {
              const i = Math.min(n + a, t),
                s = e.subarray(n, i);
              r.push(String.fromCharCode.apply(null, s));
            }
            return r.join("");
          }
          function stringToBytes(e) {
            "string" != typeof e &&
              unreachable("Invalid argument for stringToBytes");
            const t = e.length,
              a = new Uint8Array(t);
            for (let r = 0; r < t; ++r) a[r] = 255 & e.charCodeAt(r);
            return a;
          }
          t.FeatureTest = class FeatureTest {
            static get isLittleEndian() {
              return shadow(
                this,
                "isLittleEndian",
                (function isLittleEndian() {
                  const e = new Uint8Array(4);
                  e[0] = 1;
                  return 1 === new Uint32Array(e.buffer, 0, 1)[0];
                })(),
              );
            }
            static get isEvalSupported() {
              return shadow(
                this,
                "isEvalSupported",
                (function isEvalSupported() {
                  try {
                    new Function("");
                    return !0;
                  } catch {
                    return !1;
                  }
                })(),
              );
            }
            static get isOffscreenCanvasSupported() {
              return shadow(
                this,
                "isOffscreenCanvasSupported",
                "undefined" != typeof OffscreenCanvas,
              );
            }
            static get platform() {
              return "undefined" == typeof navigator
                ? shadow(this, "platform", { isWin: !1, isMac: !1 })
                : shadow(this, "platform", {
                    isWin: navigator.platform.includes("Win"),
                    isMac: navigator.platform.includes("Mac"),
                  });
            }
            static get isCSSRoundSupported() {
              return shadow(
                this,
                "isCSSRoundSupported",
                globalThis.CSS?.supports?.("width: round(1.5px, 1px)"),
              );
            }
          };
          const s = [...Array(256).keys()].map((e) =>
            e.toString(16).padStart(2, "0"),
          );
          t.Util = class Util {
            static makeHexColor(e, t, a) {
              return `#${s[e]}${s[t]}${s[a]}`;
            }
            static scaleMinMax(e, t) {
              let a;
              if (e[0]) {
                if (e[0] < 0) {
                  a = t[0];
                  t[0] = t[1];
                  t[1] = a;
                }
                t[0] *= e[0];
                t[1] *= e[0];
                if (e[3] < 0) {
                  a = t[2];
                  t[2] = t[3];
                  t[3] = a;
                }
                t[2] *= e[3];
                t[3] *= e[3];
              } else {
                a = t[0];
                t[0] = t[2];
                t[2] = a;
                a = t[1];
                t[1] = t[3];
                t[3] = a;
                if (e[1] < 0) {
                  a = t[2];
                  t[2] = t[3];
                  t[3] = a;
                }
                t[2] *= e[1];
                t[3] *= e[1];
                if (e[2] < 0) {
                  a = t[0];
                  t[0] = t[1];
                  t[1] = a;
                }
                t[0] *= e[2];
                t[1] *= e[2];
              }
              t[0] += e[4];
              t[1] += e[4];
              t[2] += e[5];
              t[3] += e[5];
            }
            static transform(e, t) {
              return [
                e[0] * t[0] + e[2] * t[1],
                e[1] * t[0] + e[3] * t[1],
                e[0] * t[2] + e[2] * t[3],
                e[1] * t[2] + e[3] * t[3],
                e[0] * t[4] + e[2] * t[5] + e[4],
                e[1] * t[4] + e[3] * t[5] + e[5],
              ];
            }
            static applyTransform(e, t) {
              return [
                e[0] * t[0] + e[1] * t[2] + t[4],
                e[0] * t[1] + e[1] * t[3] + t[5],
              ];
            }
            static applyInverseTransform(e, t) {
              const a = t[0] * t[3] - t[1] * t[2];
              return [
                (e[0] * t[3] - e[1] * t[2] + t[2] * t[5] - t[4] * t[3]) / a,
                (-e[0] * t[1] + e[1] * t[0] + t[4] * t[1] - t[5] * t[0]) / a,
              ];
            }
            static getAxialAlignedBoundingBox(e, t) {
              const a = this.applyTransform(e, t),
                r = this.applyTransform(e.slice(2, 4), t),
                n = this.applyTransform([e[0], e[3]], t),
                i = this.applyTransform([e[2], e[1]], t);
              return [
                Math.min(a[0], r[0], n[0], i[0]),
                Math.min(a[1], r[1], n[1], i[1]),
                Math.max(a[0], r[0], n[0], i[0]),
                Math.max(a[1], r[1], n[1], i[1]),
              ];
            }
            static inverseTransform(e) {
              const t = e[0] * e[3] - e[1] * e[2];
              return [
                e[3] / t,
                -e[1] / t,
                -e[2] / t,
                e[0] / t,
                (e[2] * e[5] - e[4] * e[3]) / t,
                (e[4] * e[1] - e[5] * e[0]) / t,
              ];
            }
            static singularValueDecompose2dScale(e) {
              const t = [e[0], e[2], e[1], e[3]],
                a = e[0] * t[0] + e[1] * t[2],
                r = e[0] * t[1] + e[1] * t[3],
                n = e[2] * t[0] + e[3] * t[2],
                i = e[2] * t[1] + e[3] * t[3],
                s = (a + i) / 2,
                o = Math.sqrt((a + i) ** 2 - 4 * (a * i - n * r)) / 2,
                c = s + o || 1,
                l = s - o || 1;
              return [Math.sqrt(c), Math.sqrt(l)];
            }
            static normalizeRect(e) {
              const t = e.slice(0);
              if (e[0] > e[2]) {
                t[0] = e[2];
                t[2] = e[0];
              }
              if (e[1] > e[3]) {
                t[1] = e[3];
                t[3] = e[1];
              }
              return t;
            }
            static intersect(e, t) {
              const a = Math.max(Math.min(e[0], e[2]), Math.min(t[0], t[2])),
                r = Math.min(Math.max(e[0], e[2]), Math.max(t[0], t[2]));
              if (a > r) return null;
              const n = Math.max(Math.min(e[1], e[3]), Math.min(t[1], t[3])),
                i = Math.min(Math.max(e[1], e[3]), Math.max(t[1], t[3]));
              return n > i ? null : [a, n, r, i];
            }
            static bezierBoundingBox(e, t, a, r, n, i, s, o) {
              const c = [],
                l = [[], []];
              let h, u, d, f, g, p, m, b;
              for (let l = 0; l < 2; ++l) {
                if (0 === l) {
                  u = 6 * e - 12 * a + 6 * n;
                  h = -3 * e + 9 * a - 9 * n + 3 * s;
                  d = 3 * a - 3 * e;
                } else {
                  u = 6 * t - 12 * r + 6 * i;
                  h = -3 * t + 9 * r - 9 * i + 3 * o;
                  d = 3 * r - 3 * t;
                }
                if (Math.abs(h) < 1e-12) {
                  if (Math.abs(u) < 1e-12) continue;
                  f = -d / u;
                  0 < f && f < 1 && c.push(f);
                } else {
                  m = u * u - 4 * d * h;
                  b = Math.sqrt(m);
                  if (!(m < 0)) {
                    g = (-u + b) / (2 * h);
                    0 < g && g < 1 && c.push(g);
                    p = (-u - b) / (2 * h);
                    0 < p && p < 1 && c.push(p);
                  }
                }
              }
              let y,
                w = c.length;
              const S = w;
              for (; w--; ) {
                f = c[w];
                y = 1 - f;
                l[0][w] =
                  y * y * y * e +
                  3 * y * y * f * a +
                  3 * y * f * f * n +
                  f * f * f * s;
                l[1][w] =
                  y * y * y * t +
                  3 * y * y * f * r +
                  3 * y * f * f * i +
                  f * f * f * o;
              }
              l[0][S] = e;
              l[1][S] = t;
              l[0][S + 1] = s;
              l[1][S + 1] = o;
              l[0].length = l[1].length = S + 2;
              return [
                Math.min(...l[0]),
                Math.min(...l[1]),
                Math.max(...l[0]),
                Math.max(...l[1]),
              ];
            }
          };
          const o = [
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 728, 711, 710, 729, 733, 731, 730, 732, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8226, 8224,
            8225, 8230, 8212, 8211, 402, 8260, 8249, 8250, 8722, 8240, 8222,
            8220, 8221, 8216, 8217, 8218, 8482, 64257, 64258, 321, 338, 352,
            376, 381, 305, 322, 339, 353, 382, 0, 8364,
          ];
          function stringToUTF8String(e) {
            return decodeURIComponent(escape(e));
          }
          t.PromiseCapability = class PromiseCapability {
            #e = !1;
            constructor() {
              this.promise = new Promise((e, t) => {
                this.resolve = (t) => {
                  this.#e = !0;
                  e(t);
                };
                this.reject = (e) => {
                  this.#e = !0;
                  t(e);
                };
              });
            }
            get settled() {
              return this.#e;
            }
          };
          let c = null,
            l = null;
          t.AnnotationPrefix = "pdfjs_internal_id_";
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.XRefParseException =
            t.XRefEntryException =
            t.ParserEOFException =
            t.PDF_VERSION_REGEXP =
            t.MissingDataException =
              void 0;
          t.arrayBuffersToBytes = function arrayBuffersToBytes(e) {
            const t = e.length;
            if (0 === t) return new Uint8Array(0);
            if (1 === t) return new Uint8Array(e[0]);
            let a = 0;
            for (let r = 0; r < t; r++) a += e[r].byteLength;
            const r = new Uint8Array(a);
            let n = 0;
            for (let a = 0; a < t; a++) {
              const t = new Uint8Array(e[a]);
              r.set(t, n);
              n += t.byteLength;
            }
            return r;
          };
          t.collectActions = function collectActions(e, t, a) {
            const i = Object.create(null),
              s = getInheritableProperty({
                dict: t,
                key: "AA",
                stopWhenFound: !1,
              });
            if (s)
              for (let t = s.length - 1; t >= 0; t--) {
                const r = s[t];
                if (r instanceof n.Dict)
                  for (const t of r.getKeys()) {
                    const s = a[t];
                    if (!s) continue;
                    const o = [];
                    _collectJS(r.getRaw(t), e, o, new n.RefSet());
                    o.length > 0 && (i[s] = o);
                  }
              }
            if (t.has("A")) {
              const a = [];
              _collectJS(t.get("A"), e, a, new n.RefSet());
              a.length > 0 && (i.Action = a);
            }
            return (0, r.objectSize)(i) > 0 ? i : null;
          };
          t.encodeToXmlString = function encodeToXmlString(e) {
            const t = [];
            let a = 0;
            for (let r = 0, n = e.length; r < n; r++) {
              const n = e.codePointAt(r);
              if (32 <= n && n <= 126) {
                const i = o[n];
                if (i) {
                  a < r && t.push(e.substring(a, r));
                  t.push(i);
                  a = r + 1;
                }
              } else {
                a < r && t.push(e.substring(a, r));
                t.push(`&#x${n.toString(16).toUpperCase()};`);
                n > 55295 && (n < 57344 || n > 65533) && r++;
                a = r + 1;
              }
            }
            if (0 === t.length) return e;
            a < e.length && t.push(e.substring(a, e.length));
            return t.join("");
          };
          t.escapePDFName = function escapePDFName(e) {
            const t = [];
            let a = 0;
            for (let r = 0, n = e.length; r < n; r++) {
              const n = e.charCodeAt(r);
              if (
                n < 33 ||
                n > 126 ||
                35 === n ||
                40 === n ||
                41 === n ||
                60 === n ||
                62 === n ||
                91 === n ||
                93 === n ||
                123 === n ||
                125 === n ||
                47 === n ||
                37 === n
              ) {
                a < r && t.push(e.substring(a, r));
                t.push(`#${n.toString(16)}`);
                a = r + 1;
              }
            }
            if (0 === t.length) return e;
            a < e.length && t.push(e.substring(a, e.length));
            return t.join("");
          };
          t.escapeString = function escapeString(e) {
            return e.replaceAll(/([()\\\n\r])/g, (e) =>
              "\n" === e ? "\\n" : "\r" === e ? "\\r" : `\\${e}`,
            );
          };
          t.getInheritableProperty = getInheritableProperty;
          t.getLookupTableFactory = function getLookupTableFactory(e) {
            let t;
            return function () {
              if (e) {
                t = Object.create(null);
                e(t);
                e = null;
              }
              return t;
            };
          };
          t.getNewAnnotationsMap = function getNewAnnotationsMap(e) {
            if (!e) return null;
            const t = new Map();
            for (const [a, n] of e) {
              if (!a.startsWith(r.AnnotationEditorPrefix)) continue;
              let e = t.get(n.pageIndex);
              if (!e) {
                e = [];
                t.set(n.pageIndex, e);
              }
              e.push(n);
            }
            return t.size > 0 ? t : null;
          };
          t.getRotationMatrix = function getRotationMatrix(e, t, a) {
            switch (e) {
              case 90:
                return [0, 1, -1, 0, t, 0];
              case 180:
                return [-1, 0, 0, -1, t, a];
              case 270:
                return [0, -1, 1, 0, 0, a];
              default:
                throw new Error("Invalid rotation");
            }
          };
          t.isAscii = function isAscii(e) {
            return /^[\x00-\x7F]*$/.test(e);
          };
          t.isWhiteSpace = function isWhiteSpace(e) {
            return 32 === e || 9 === e || 13 === e || 10 === e;
          };
          t.log2 = function log2(e) {
            if (e <= 0) return 0;
            return Math.ceil(Math.log2(e));
          };
          t.numberToString = function numberToString(e) {
            if (Number.isInteger(e)) return e.toString();
            const t = Math.round(100 * e);
            if (t % 100 == 0) return (t / 100).toString();
            if (t % 10 == 0) return e.toFixed(1);
            return e.toFixed(2);
          };
          t.parseXFAPath = function parseXFAPath(e) {
            const t = /(.+)\[(\d+)\]$/;
            return e.split(".").map((e) => {
              const a = e.match(t);
              return a
                ? { name: a[1], pos: parseInt(a[2], 10) }
                : { name: e, pos: 0 };
            });
          };
          t.readInt8 = function readInt8(e, t) {
            return (e[t] << 24) >> 24;
          };
          t.readUint16 = function readUint16(e, t) {
            return (e[t] << 8) | e[t + 1];
          };
          t.readUint32 = function readUint32(e, t) {
            return (
              ((e[t] << 24) | (e[t + 1] << 16) | (e[t + 2] << 8) | e[t + 3]) >>>
              0
            );
          };
          t.recoverJsURL = function recoverJsURL(e) {
            const t = new RegExp(
              "^\\s*(" +
                ["app.launchURL", "window.open", "xfa.host.gotoURL"]
                  .join("|")
                  .replaceAll(".", "\\.") +
                ")\\((?:'|\")([^'\"]*)(?:'|\")(?:,\\s*(\\w+)\\)|\\))",
              "i",
            ).exec(e);
            if (t?.[2]) {
              const e = t[2];
              let a = !1;
              "true" === t[3] && "app.launchURL" === t[1] && (a = !0);
              return { url: e, newWindow: a };
            }
            return null;
          };
          t.stringToUTF16HexString = function stringToUTF16HexString(e) {
            const t = [];
            for (let a = 0, r = e.length; a < r; a++) {
              const r = e.charCodeAt(a);
              t.push(
                ((r >> 8) & 255).toString(16).padStart(2, "0"),
                (255 & r).toString(16).padStart(2, "0"),
              );
            }
            return t.join("");
          };
          t.stringToUTF16String = function stringToUTF16String(e, t = !1) {
            const a = [];
            t && a.push("þÿ");
            for (let t = 0, r = e.length; t < r; t++) {
              const r = e.charCodeAt(t);
              a.push(
                String.fromCharCode((r >> 8) & 255),
                String.fromCharCode(255 & r),
              );
            }
            return a.join("");
          };
          t.toRomanNumerals = function toRomanNumerals(e, t = !1) {
            (0, r.assert)(
              Number.isInteger(e) && e > 0,
              "The number should be a positive integer.",
            );
            const a = [];
            let n;
            for (; e >= 1e3; ) {
              e -= 1e3;
              a.push("M");
            }
            n = (e / 100) | 0;
            e %= 100;
            a.push(s[n]);
            n = (e / 10) | 0;
            e %= 10;
            a.push(s[10 + n]);
            a.push(s[20 + e]);
            const i = a.join("");
            return t ? i.toLowerCase() : i;
          };
          t.validateCSSFont = function validateCSSFont(e) {
            const t = new Set([
                "100",
                "200",
                "300",
                "400",
                "500",
                "600",
                "700",
                "800",
                "900",
                "1000",
                "normal",
                "bold",
                "bolder",
                "lighter",
              ]),
              { fontFamily: a, fontWeight: r, italicAngle: n } = e;
            if (!validateFontName(a, !0)) return !1;
            const i = r ? r.toString() : "";
            e.fontWeight = t.has(i) ? i : "400";
            const s = parseFloat(n);
            e.italicAngle = isNaN(s) || s < -90 || s > 90 ? "14" : n.toString();
            return !0;
          };
          t.validateFontName = validateFontName;
          var r = a(2),
            n = a(4),
            i = a(5);
          t.PDF_VERSION_REGEXP = /^[1-9]\.\d$/;
          class MissingDataException extends r.BaseException {
            constructor(e, t) {
              super(`Missing data [${e}, ${t})`, "MissingDataException");
              this.begin = e;
              this.end = t;
            }
          }
          t.MissingDataException = MissingDataException;
          class ParserEOFException extends r.BaseException {
            constructor(e) {
              super(e, "ParserEOFException");
            }
          }
          t.ParserEOFException = ParserEOFException;
          class XRefEntryException extends r.BaseException {
            constructor(e) {
              super(e, "XRefEntryException");
            }
          }
          t.XRefEntryException = XRefEntryException;
          class XRefParseException extends r.BaseException {
            constructor(e) {
              super(e, "XRefParseException");
            }
          }
          t.XRefParseException = XRefParseException;
          function getInheritableProperty({
            dict: e,
            key: t,
            getArray: a = !1,
            stopWhenFound: r = !0,
          }) {
            let i;
            const s = new n.RefSet();
            for (; e instanceof n.Dict && (!e.objId || !s.has(e.objId)); ) {
              e.objId && s.put(e.objId);
              const n = a ? e.getArray(t) : e.get(t);
              if (void 0 !== n) {
                if (r) return n;
                (i ||= []).push(n);
              }
              e = e.get("Parent");
            }
            return i;
          }
          const s = [
            "",
            "C",
            "CC",
            "CCC",
            "CD",
            "D",
            "DC",
            "DCC",
            "DCCC",
            "CM",
            "",
            "X",
            "XX",
            "XXX",
            "XL",
            "L",
            "LX",
            "LXX",
            "LXXX",
            "XC",
            "",
            "I",
            "II",
            "III",
            "IV",
            "V",
            "VI",
            "VII",
            "VIII",
            "IX",
          ];
          function _collectJS(e, t, a, s) {
            if (!e) return;
            let o = null;
            if (e instanceof n.Ref) {
              if (s.has(e)) return;
              o = e;
              s.put(o);
              e = t.fetch(e);
            }
            if (Array.isArray(e)) for (const r of e) _collectJS(r, t, a, s);
            else if (e instanceof n.Dict) {
              if ((0, n.isName)(e.get("S"), "JavaScript")) {
                const t = e.get("JS");
                let n;
                t instanceof i.BaseStream
                  ? (n = t.getString())
                  : "string" == typeof t && (n = t);
                n &&= (0, r.stringToPDFString)(n).replaceAll("\0", "");
                n && a.push(n);
              }
              _collectJS(e.getRaw("Next"), t, a, s);
            }
            o && s.remove(o);
          }
          const o = {
            60: "&lt;",
            62: "&gt;",
            38: "&amp;",
            34: "&quot;",
            39: "&apos;",
          };
          function validateFontName(e, t = !1) {
            const a = /^("|').*("|')$/.exec(e);
            if (a && a[1] === a[2]) {
              if (new RegExp(`[^\\\\]${a[1]}`).test(e.slice(1, -1))) {
                t &&
                  (0, r.warn)(`FontFamily contains unescaped ${a[1]}: ${e}.`);
                return !1;
              }
            } else
              for (const a of e.split(/[ \t]+/))
                if (/^(\d|(-(\d|-)))/.test(a) || !/^[\w-\\]+$/.test(a)) {
                  t &&
                    (0, r.warn)(
                      `FontFamily contains invalid <custom-ident>: ${e}.`,
                    );
                  return !1;
                }
            return !0;
          }
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.RefSetCache =
            t.RefSet =
            t.Ref =
            t.Name =
            t.EOF =
            t.Dict =
            t.Cmd =
            t.CIRCULAR_REF =
              void 0;
          t.clearPrimitiveCaches = function clearPrimitiveCaches() {
            s = Object.create(null);
            o = Object.create(null);
            c = Object.create(null);
          };
          t.isCmd = function isCmd(e, t) {
            return e instanceof Cmd && (void 0 === t || e.cmd === t);
          };
          t.isDict = function isDict(e, t) {
            return (
              e instanceof Dict && (void 0 === t || isName(e.get("Type"), t))
            );
          };
          t.isName = isName;
          t.isRefsEqual = function isRefsEqual(e, t) {
            return e.num === t.num && e.gen === t.gen;
          };
          var r = a(2);
          const n = Symbol("CIRCULAR_REF");
          t.CIRCULAR_REF = n;
          const i = Symbol("EOF");
          t.EOF = i;
          let s = Object.create(null),
            o = Object.create(null),
            c = Object.create(null);
          class Name {
            constructor(e) {
              this.name = e;
            }
            static get(e) {
              return (o[e] ||= new Name(e));
            }
          }
          t.Name = Name;
          class Cmd {
            constructor(e) {
              this.cmd = e;
            }
            static get(e) {
              return (s[e] ||= new Cmd(e));
            }
          }
          t.Cmd = Cmd;
          const l = function nonSerializableClosure() {
            return l;
          };
          class Dict {
            constructor(e = null) {
              this._map = Object.create(null);
              this.xref = e;
              this.objId = null;
              this.suppressEncryption = !1;
              this.__nonSerializable__ = l;
            }
            assignXref(e) {
              this.xref = e;
            }
            get size() {
              return Object.keys(this._map).length;
            }
            get(e, t, a) {
              let r = this._map[e];
              if (void 0 === r && void 0 !== t) {
                r = this._map[t];
                void 0 === r && void 0 !== a && (r = this._map[a]);
              }
              return r instanceof Ref && this.xref
                ? this.xref.fetch(r, this.suppressEncryption)
                : r;
            }
            async getAsync(e, t, a) {
              let r = this._map[e];
              if (void 0 === r && void 0 !== t) {
                r = this._map[t];
                void 0 === r && void 0 !== a && (r = this._map[a]);
              }
              return r instanceof Ref && this.xref
                ? this.xref.fetchAsync(r, this.suppressEncryption)
                : r;
            }
            getArray(e, t, a) {
              let r = this._map[e];
              if (void 0 === r && void 0 !== t) {
                r = this._map[t];
                void 0 === r && void 0 !== a && (r = this._map[a]);
              }
              r instanceof Ref &&
                this.xref &&
                (r = this.xref.fetch(r, this.suppressEncryption));
              if (Array.isArray(r)) {
                r = r.slice();
                for (let e = 0, t = r.length; e < t; e++)
                  r[e] instanceof Ref &&
                    this.xref &&
                    (r[e] = this.xref.fetch(r[e], this.suppressEncryption));
              }
              return r;
            }
            getRaw(e) {
              return this._map[e];
            }
            getKeys() {
              return Object.keys(this._map);
            }
            getRawValues() {
              return Object.values(this._map);
            }
            set(e, t) {
              this._map[e] = t;
            }
            has(e) {
              return void 0 !== this._map[e];
            }
            forEach(e) {
              for (const t in this._map) e(t, this.get(t));
            }
            static get empty() {
              const e = new Dict(null);
              e.set = (e, t) => {
                (0, r.unreachable)(
                  "Should not call `set` on the empty dictionary.",
                );
              };
              return (0, r.shadow)(this, "empty", e);
            }
            static merge({ xref: e, dictArray: t, mergeSubDicts: a = !1 }) {
              const r = new Dict(e),
                n = new Map();
              for (const e of t)
                if (e instanceof Dict)
                  for (const [t, r] of Object.entries(e._map)) {
                    let e = n.get(t);
                    if (void 0 === e) {
                      e = [];
                      n.set(t, e);
                    } else if (!(a && r instanceof Dict)) continue;
                    e.push(r);
                  }
              for (const [t, a] of n) {
                if (1 === a.length || !(a[0] instanceof Dict)) {
                  r._map[t] = a[0];
                  continue;
                }
                const n = new Dict(e);
                for (const e of a)
                  for (const [t, a] of Object.entries(e._map))
                    void 0 === n._map[t] && (n._map[t] = a);
                n.size > 0 && (r._map[t] = n);
              }
              n.clear();
              return r.size > 0 ? r : Dict.empty;
            }
            clone() {
              const e = new Dict(this.xref);
              for (const t of this.getKeys()) e.set(t, this.getRaw(t));
              return e;
            }
          }
          t.Dict = Dict;
          class Ref {
            constructor(e, t) {
              this.num = e;
              this.gen = t;
            }
            toString() {
              return 0 === this.gen
                ? `${this.num}R`
                : `${this.num}R${this.gen}`;
            }
            static fromString(e) {
              const t = c[e];
              if (t) return t;
              const a = /^(\d+)R(\d*)$/.exec(e);
              return a && "0" !== a[1]
                ? (c[e] = new Ref(parseInt(a[1]), a[2] ? parseInt(a[2]) : 0))
                : null;
            }
            static get(e, t) {
              const a = 0 === t ? `${e}R` : `${e}R${t}`;
              return (c[a] ||= new Ref(e, t));
            }
          }
          t.Ref = Ref;
          class RefSet {
            constructor(e = null) {
              this._set = new Set(e?._set);
            }
            has(e) {
              return this._set.has(e.toString());
            }
            put(e) {
              this._set.add(e.toString());
            }
            remove(e) {
              this._set.delete(e.toString());
            }
            [Symbol.iterator]() {
              return this._set.values();
            }
            clear() {
              this._set.clear();
            }
          }
          t.RefSet = RefSet;
          class RefSetCache {
            constructor() {
              this._map = new Map();
            }
            get size() {
              return this._map.size;
            }
            get(e) {
              return this._map.get(e.toString());
            }
            has(e) {
              return this._map.has(e.toString());
            }
            put(e, t) {
              this._map.set(e.toString(), t);
            }
            putAlias(e, t) {
              this._map.set(e.toString(), this.get(t));
            }
            [Symbol.iterator]() {
              return this._map.values();
            }
            clear() {
              this._map.clear();
            }
          }
          t.RefSetCache = RefSetCache;
          function isName(e, t) {
            return e instanceof Name && (void 0 === t || e.name === t);
          }
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.BaseStream = void 0;
          var r = a(2);
          class BaseStream {
            constructor() {
              this.constructor === BaseStream &&
                (0, r.unreachable)("Cannot initialize BaseStream.");
            }
            get length() {
              (0, r.unreachable)("Abstract getter `length` accessed");
            }
            get isEmpty() {
              (0, r.unreachable)("Abstract getter `isEmpty` accessed");
            }
            get isDataLoaded() {
              return (0, r.shadow)(this, "isDataLoaded", !0);
            }
            getByte() {
              (0, r.unreachable)("Abstract method `getByte` called");
            }
            getBytes(e) {
              (0, r.unreachable)("Abstract method `getBytes` called");
            }
            peekByte() {
              const e = this.getByte();
              -1 !== e && this.pos--;
              return e;
            }
            peekBytes(e) {
              const t = this.getBytes(e);
              this.pos -= t.length;
              return t;
            }
            getUint16() {
              const e = this.getByte(),
                t = this.getByte();
              return -1 === e || -1 === t ? -1 : (e << 8) + t;
            }
            getInt32() {
              return (
                (this.getByte() << 24) +
                (this.getByte() << 16) +
                (this.getByte() << 8) +
                this.getByte()
              );
            }
            getByteRange(e, t) {
              (0, r.unreachable)("Abstract method `getByteRange` called");
            }
            getString(e) {
              return (0, r.bytesToString)(this.getBytes(e));
            }
            skip(e) {
              this.pos += e || 1;
            }
            reset() {
              (0, r.unreachable)("Abstract method `reset` called");
            }
            moveStart() {
              (0, r.unreachable)("Abstract method `moveStart` called");
            }
            makeSubStream(e, t, a = null) {
              (0, r.unreachable)("Abstract method `makeSubStream` called");
            }
            getBaseStreams() {
              return null;
            }
          }
          t.BaseStream = BaseStream;
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.NetworkPdfManager = t.LocalPdfManager = void 0;
          var r = a(2),
            n = a(7),
            i = a(3),
            s = a(9),
            o = a(8);
          class BasePdfManager {
            constructor(e) {
              this.constructor === BasePdfManager &&
                (0, r.unreachable)("Cannot initialize BasePdfManager.");
              this._docBaseUrl = (function parseDocBaseUrl(e) {
                if (e) {
                  const t = (0, r.createValidAbsoluteUrl)(e);
                  if (t) return t.href;
                  (0, r.warn)(`Invalid absolute docBaseUrl: "${e}".`);
                }
                return null;
              })(e.docBaseUrl);
              this._docId = e.docId;
              this._password = e.password;
              this.enableXfa = e.enableXfa;
              e.evaluatorOptions.isOffscreenCanvasSupported &&=
                r.FeatureTest.isOffscreenCanvasSupported;
              this.evaluatorOptions = e.evaluatorOptions;
            }
            get docId() {
              return this._docId;
            }
            get password() {
              return this._password;
            }
            get docBaseUrl() {
              return this._docBaseUrl;
            }
            get catalog() {
              return this.pdfDocument.catalog;
            }
            ensureDoc(e, t) {
              return this.ensure(this.pdfDocument, e, t);
            }
            ensureXRef(e, t) {
              return this.ensure(this.pdfDocument.xref, e, t);
            }
            ensureCatalog(e, t) {
              return this.ensure(this.pdfDocument.catalog, e, t);
            }
            getPage(e) {
              return this.pdfDocument.getPage(e);
            }
            fontFallback(e, t) {
              return this.pdfDocument.fontFallback(e, t);
            }
            loadXfaFonts(e, t) {
              return this.pdfDocument.loadXfaFonts(e, t);
            }
            loadXfaImages() {
              return this.pdfDocument.loadXfaImages();
            }
            serializeXfaData(e) {
              return this.pdfDocument.serializeXfaData(e);
            }
            cleanup(e = !1) {
              return this.pdfDocument.cleanup(e);
            }
            async ensure(e, t, a) {
              (0, r.unreachable)("Abstract method `ensure` called");
            }
            requestRange(e, t) {
              (0, r.unreachable)("Abstract method `requestRange` called");
            }
            requestLoadedStream(e = !1) {
              (0, r.unreachable)(
                "Abstract method `requestLoadedStream` called",
              );
            }
            sendProgressiveData(e) {
              (0, r.unreachable)(
                "Abstract method `sendProgressiveData` called",
              );
            }
            updatePassword(e) {
              this._password = e;
            }
            terminate(e) {
              (0, r.unreachable)("Abstract method `terminate` called");
            }
          }
          t.LocalPdfManager = class LocalPdfManager extends BasePdfManager {
            constructor(e) {
              super(e);
              const t = new o.Stream(e.source);
              this.pdfDocument = new s.PDFDocument(this, t);
              this._loadedStreamPromise = Promise.resolve(t);
            }
            async ensure(e, t, a) {
              const r = e[t];
              return "function" == typeof r ? r.apply(e, a) : r;
            }
            requestRange(e, t) {
              return Promise.resolve();
            }
            requestLoadedStream(e = !1) {
              return this._loadedStreamPromise;
            }
            terminate(e) {}
          };
          t.NetworkPdfManager = class NetworkPdfManager extends BasePdfManager {
            constructor(e) {
              super(e);
              this.streamManager = new n.ChunkedStreamManager(e.source, {
                msgHandler: e.handler,
                length: e.length,
                disableAutoFetch: e.disableAutoFetch,
                rangeChunkSize: e.rangeChunkSize,
              });
              this.pdfDocument = new s.PDFDocument(
                this,
                this.streamManager.getStream(),
              );
            }
            async ensure(e, t, a) {
              try {
                const r = e[t];
                return "function" == typeof r ? r.apply(e, a) : r;
              } catch (r) {
                if (!(r instanceof i.MissingDataException)) throw r;
                await this.requestRange(r.begin, r.end);
                return this.ensure(e, t, a);
              }
            }
            requestRange(e, t) {
              return this.streamManager.requestRange(e, t);
            }
            requestLoadedStream(e = !1) {
              return this.streamManager.requestAllChunks(e);
            }
            sendProgressiveData(e) {
              this.streamManager.onReceiveData({ chunk: e });
            }
            terminate(e) {
              this.streamManager.abort(e);
            }
          };
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.ChunkedStreamManager = t.ChunkedStream = void 0;
          var r = a(3),
            n = a(2),
            i = a(8);
          class ChunkedStream extends i.Stream {
            constructor(e, t, a) {
              super(new Uint8Array(e), 0, e, null);
              this.chunkSize = t;
              this._loadedChunks = new Set();
              this.numChunks = Math.ceil(e / t);
              this.manager = a;
              this.progressiveDataLength = 0;
              this.lastSuccessfulEnsureByteChunk = -1;
            }
            getMissingChunks() {
              const e = [];
              for (let t = 0, a = this.numChunks; t < a; ++t)
                this._loadedChunks.has(t) || e.push(t);
              return e;
            }
            get numChunksLoaded() {
              return this._loadedChunks.size;
            }
            get isDataLoaded() {
              return this.numChunksLoaded === this.numChunks;
            }
            onReceiveData(e, t) {
              const a = this.chunkSize;
              if (e % a != 0) throw new Error(`Bad begin offset: ${e}`);
              const r = e + t.byteLength;
              if (r % a != 0 && r !== this.bytes.length)
                throw new Error(`Bad end offset: ${r}`);
              this.bytes.set(new Uint8Array(t), e);
              const n = Math.floor(e / a),
                i = Math.floor((r - 1) / a) + 1;
              for (let e = n; e < i; ++e) this._loadedChunks.add(e);
            }
            onReceiveProgressiveData(e) {
              let t = this.progressiveDataLength;
              const a = Math.floor(t / this.chunkSize);
              this.bytes.set(new Uint8Array(e), t);
              t += e.byteLength;
              this.progressiveDataLength = t;
              const r =
                t >= this.end ? this.numChunks : Math.floor(t / this.chunkSize);
              for (let e = a; e < r; ++e) this._loadedChunks.add(e);
            }
            ensureByte(e) {
              if (e < this.progressiveDataLength) return;
              const t = Math.floor(e / this.chunkSize);
              if (
                !(t > this.numChunks) &&
                t !== this.lastSuccessfulEnsureByteChunk
              ) {
                if (!this._loadedChunks.has(t))
                  throw new r.MissingDataException(e, e + 1);
                this.lastSuccessfulEnsureByteChunk = t;
              }
            }
            ensureRange(e, t) {
              if (e >= t) return;
              if (t <= this.progressiveDataLength) return;
              const a = Math.floor(e / this.chunkSize);
              if (a > this.numChunks) return;
              const n = Math.min(
                Math.floor((t - 1) / this.chunkSize) + 1,
                this.numChunks,
              );
              for (let i = a; i < n; ++i)
                if (!this._loadedChunks.has(i))
                  throw new r.MissingDataException(e, t);
            }
            nextEmptyChunk(e) {
              const t = this.numChunks;
              for (let a = 0; a < t; ++a) {
                const r = (e + a) % t;
                if (!this._loadedChunks.has(r)) return r;
              }
              return null;
            }
            hasChunk(e) {
              return this._loadedChunks.has(e);
            }
            getByte() {
              const e = this.pos;
              if (e >= this.end) return -1;
              e >= this.progressiveDataLength && this.ensureByte(e);
              return this.bytes[this.pos++];
            }
            getBytes(e) {
              const t = this.bytes,
                a = this.pos,
                r = this.end;
              if (!e) {
                r > this.progressiveDataLength && this.ensureRange(a, r);
                return t.subarray(a, r);
              }
              let n = a + e;
              n > r && (n = r);
              n > this.progressiveDataLength && this.ensureRange(a, n);
              this.pos = n;
              return t.subarray(a, n);
            }
            getByteRange(e, t) {
              e < 0 && (e = 0);
              t > this.end && (t = this.end);
              t > this.progressiveDataLength && this.ensureRange(e, t);
              return this.bytes.subarray(e, t);
            }
            makeSubStream(e, t, a = null) {
              t
                ? e + t > this.progressiveDataLength &&
                  this.ensureRange(e, e + t)
                : e >= this.progressiveDataLength && this.ensureByte(e);
              function ChunkedStreamSubstream() {}
              ChunkedStreamSubstream.prototype = Object.create(this);
              ChunkedStreamSubstream.prototype.getMissingChunks = function () {
                const e = this.chunkSize,
                  t = Math.floor(this.start / e),
                  a = Math.floor((this.end - 1) / e) + 1,
                  r = [];
                for (let e = t; e < a; ++e)
                  this._loadedChunks.has(e) || r.push(e);
                return r;
              };
              Object.defineProperty(
                ChunkedStreamSubstream.prototype,
                "isDataLoaded",
                {
                  get() {
                    return (
                      this.numChunksLoaded === this.numChunks ||
                      0 === this.getMissingChunks().length
                    );
                  },
                  configurable: !0,
                },
              );
              const r = new ChunkedStreamSubstream();
              r.pos = r.start = e;
              r.end = e + t || this.end;
              r.dict = a;
              return r;
            }
            getBaseStreams() {
              return [this];
            }
          }
          t.ChunkedStream = ChunkedStream;
          t.ChunkedStreamManager = class ChunkedStreamManager {
            constructor(e, t) {
              this.length = t.length;
              this.chunkSize = t.rangeChunkSize;
              this.stream = new ChunkedStream(
                this.length,
                this.chunkSize,
                this,
              );
              this.pdfNetworkStream = e;
              this.disableAutoFetch = t.disableAutoFetch;
              this.msgHandler = t.msgHandler;
              this.currRequestId = 0;
              this._chunksNeededByRequest = new Map();
              this._requestsByChunk = new Map();
              this._promisesByRequest = new Map();
              this.progressiveDataLength = 0;
              this.aborted = !1;
              this._loadedStreamCapability = new n.PromiseCapability();
            }
            sendRequest(e, t) {
              const a = this.pdfNetworkStream.getRangeReader(e, t);
              a.isStreamingSupported ||
                (a.onProgress = this.onProgress.bind(this));
              let n = [],
                i = 0;
              return new Promise((e, t) => {
                const readChunk = ({ value: s, done: o }) => {
                  try {
                    if (o) {
                      const t = (0, r.arrayBuffersToBytes)(n);
                      n = null;
                      e(t);
                      return;
                    }
                    i += s.byteLength;
                    a.isStreamingSupported && this.onProgress({ loaded: i });
                    n.push(s);
                    a.read().then(readChunk, t);
                  } catch (e) {
                    t(e);
                  }
                };
                a.read().then(readChunk, t);
              }).then((t) => {
                this.aborted || this.onReceiveData({ chunk: t, begin: e });
              });
            }
            requestAllChunks(e = !1) {
              if (!e) {
                const e = this.stream.getMissingChunks();
                this._requestChunks(e);
              }
              return this._loadedStreamCapability.promise;
            }
            _requestChunks(e) {
              const t = this.currRequestId++,
                a = new Set();
              this._chunksNeededByRequest.set(t, a);
              for (const t of e) this.stream.hasChunk(t) || a.add(t);
              if (0 === a.size) return Promise.resolve();
              const r = new n.PromiseCapability();
              this._promisesByRequest.set(t, r);
              const i = [];
              for (const e of a) {
                let a = this._requestsByChunk.get(e);
                if (!a) {
                  a = [];
                  this._requestsByChunk.set(e, a);
                  i.push(e);
                }
                a.push(t);
              }
              if (i.length > 0) {
                const e = this.groupChunks(i);
                for (const t of e) {
                  const e = t.beginChunk * this.chunkSize,
                    a = Math.min(t.endChunk * this.chunkSize, this.length);
                  this.sendRequest(e, a).catch(r.reject);
                }
              }
              return r.promise.catch((e) => {
                if (!this.aborted) throw e;
              });
            }
            getStream() {
              return this.stream;
            }
            requestRange(e, t) {
              t = Math.min(t, this.length);
              const a = this.getBeginChunk(e),
                r = this.getEndChunk(t),
                n = [];
              for (let e = a; e < r; ++e) n.push(e);
              return this._requestChunks(n);
            }
            requestRanges(e = []) {
              const t = [];
              for (const a of e) {
                const e = this.getBeginChunk(a.begin),
                  r = this.getEndChunk(a.end);
                for (let a = e; a < r; ++a) t.includes(a) || t.push(a);
              }
              t.sort(function (e, t) {
                return e - t;
              });
              return this._requestChunks(t);
            }
            groupChunks(e) {
              const t = [];
              let a = -1,
                r = -1;
              for (let n = 0, i = e.length; n < i; ++n) {
                const i = e[n];
                a < 0 && (a = i);
                if (r >= 0 && r + 1 !== i) {
                  t.push({ beginChunk: a, endChunk: r + 1 });
                  a = i;
                }
                n + 1 === e.length &&
                  t.push({ beginChunk: a, endChunk: i + 1 });
                r = i;
              }
              return t;
            }
            onProgress(e) {
              this.msgHandler.send("DocProgress", {
                loaded: this.stream.numChunksLoaded * this.chunkSize + e.loaded,
                total: this.length,
              });
            }
            onReceiveData(e) {
              const t = e.chunk,
                a = void 0 === e.begin,
                r = a ? this.progressiveDataLength : e.begin,
                n = r + t.byteLength,
                i = Math.floor(r / this.chunkSize),
                s =
                  n < this.length
                    ? Math.floor(n / this.chunkSize)
                    : Math.ceil(n / this.chunkSize);
              if (a) {
                this.stream.onReceiveProgressiveData(t);
                this.progressiveDataLength = n;
              } else this.stream.onReceiveData(r, t);
              this.stream.isDataLoaded &&
                this._loadedStreamCapability.resolve(this.stream);
              const o = [];
              for (let e = i; e < s; ++e) {
                const t = this._requestsByChunk.get(e);
                if (t) {
                  this._requestsByChunk.delete(e);
                  for (const a of t) {
                    const t = this._chunksNeededByRequest.get(a);
                    t.has(e) && t.delete(e);
                    t.size > 0 || o.push(a);
                  }
                }
              }
              if (!this.disableAutoFetch && 0 === this._requestsByChunk.size) {
                let e;
                if (1 === this.stream.numChunksLoaded) {
                  const t = this.stream.numChunks - 1;
                  this.stream.hasChunk(t) || (e = t);
                } else e = this.stream.nextEmptyChunk(s);
                Number.isInteger(e) && this._requestChunks([e]);
              }
              for (const e of o) {
                const t = this._promisesByRequest.get(e);
                this._promisesByRequest.delete(e);
                t.resolve();
              }
              this.msgHandler.send("DocProgress", {
                loaded: this.stream.numChunksLoaded * this.chunkSize,
                total: this.length,
              });
            }
            onError(e) {
              this._loadedStreamCapability.reject(e);
            }
            getBeginChunk(e) {
              return Math.floor(e / this.chunkSize);
            }
            getEndChunk(e) {
              return Math.floor((e - 1) / this.chunkSize) + 1;
            }
            abort(e) {
              this.aborted = !0;
              this.pdfNetworkStream?.cancelAllRequests(e);
              for (const t of this._promisesByRequest.values()) t.reject(e);
            }
          };
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.StringStream = t.Stream = t.NullStream = void 0;
          var r = a(5),
            n = a(2);
          class Stream extends r.BaseStream {
            constructor(e, t, a, r) {
              super();
              this.bytes = e instanceof Uint8Array ? e : new Uint8Array(e);
              this.start = t || 0;
              this.pos = this.start;
              this.end = t + a || this.bytes.length;
              this.dict = r;
            }
            get length() {
              return this.end - this.start;
            }
            get isEmpty() {
              return 0 === this.length;
            }
            getByte() {
              return this.pos >= this.end ? -1 : this.bytes[this.pos++];
            }
            getBytes(e) {
              const t = this.bytes,
                a = this.pos,
                r = this.end;
              if (!e) return t.subarray(a, r);
              let n = a + e;
              n > r && (n = r);
              this.pos = n;
              return t.subarray(a, n);
            }
            getByteRange(e, t) {
              e < 0 && (e = 0);
              t > this.end && (t = this.end);
              return this.bytes.subarray(e, t);
            }
            reset() {
              this.pos = this.start;
            }
            moveStart() {
              this.start = this.pos;
            }
            makeSubStream(e, t, a = null) {
              return new Stream(this.bytes.buffer, e, t, a);
            }
          }
          t.Stream = Stream;
          t.StringStream = class StringStream extends Stream {
            constructor(e) {
              super((0, n.stringToBytes)(e));
            }
          };
          t.NullStream = class NullStream extends Stream {
            constructor() {
              super(new Uint8Array(0));
            }
          };
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.Page = t.PDFDocument = void 0;
          var r = a(2),
            n = a(10),
            i = a(3),
            s = a(4),
            o = a(51),
            c = a(5),
            l = a(74),
            h = a(66),
            u = a(68),
            d = a(102),
            f = a(16),
            g = a(8),
            p = a(76),
            m = a(64),
            b = a(13),
            y = a(18),
            w = a(72),
            S = a(73),
            x = a(77),
            C = a(103);
          const k = [0, 0, 612, 792];
          class Page {
            constructor({
              pdfManager: e,
              xref: t,
              pageIndex: a,
              pageDict: r,
              ref: n,
              globalIdFactory: i,
              fontCache: s,
              builtInCMapCache: o,
              standardFontDataCache: c,
              globalImageCache: l,
              systemFontCache: h,
              nonBlendModesSet: u,
              xfaFactory: d,
            }) {
              this.pdfManager = e;
              this.pageIndex = a;
              this.pageDict = r;
              this.xref = t;
              this.ref = n;
              this.fontCache = s;
              this.builtInCMapCache = o;
              this.standardFontDataCache = c;
              this.globalImageCache = l;
              this.systemFontCache = h;
              this.nonBlendModesSet = u;
              this.evaluatorOptions = e.evaluatorOptions;
              this.resourcesPromise = null;
              this.xfaFactory = d;
              const f = { obj: 0 };
              this._localIdFactory = class extends i {
                static createObjId() {
                  return `p${a}_${++f.obj}`;
                }
                static getPageObjId() {
                  return `p${n.toString()}`;
                }
              };
            }
            _getInheritableProperty(e, t = !1) {
              const a = (0, i.getInheritableProperty)({
                dict: this.pageDict,
                key: e,
                getArray: t,
                stopWhenFound: !1,
              });
              return Array.isArray(a)
                ? 1 !== a.length && a[0] instanceof s.Dict
                  ? s.Dict.merge({ xref: this.xref, dictArray: a })
                  : a[0]
                : a;
            }
            get content() {
              return this.pageDict.getArray("Contents");
            }
            get resources() {
              const e = this._getInheritableProperty("Resources");
              return (0, r.shadow)(
                this,
                "resources",
                e instanceof s.Dict ? e : s.Dict.empty,
              );
            }
            _getBoundingBox(e) {
              if (this.xfaData) return this.xfaData.bbox;
              let t = this._getInheritableProperty(e, !0);
              if (Array.isArray(t) && 4 === t.length) {
                t = r.Util.normalizeRect(t);
                if (t[2] - t[0] > 0 && t[3] - t[1] > 0) return t;
                (0, r.warn)(`Empty, or invalid, /${e} entry.`);
              }
              return null;
            }
            get mediaBox() {
              return (0, r.shadow)(
                this,
                "mediaBox",
                this._getBoundingBox("MediaBox") || k,
              );
            }
            get cropBox() {
              return (0, r.shadow)(
                this,
                "cropBox",
                this._getBoundingBox("CropBox") || this.mediaBox,
              );
            }
            get userUnit() {
              let e = this.pageDict.get("UserUnit");
              ("number" != typeof e || e <= 0) && (e = 1);
              return (0, r.shadow)(this, "userUnit", e);
            }
            get view() {
              const { cropBox: e, mediaBox: t } = this;
              if (e !== t && !(0, r.isArrayEqual)(e, t)) {
                const a = r.Util.intersect(e, t);
                if (a && a[2] - a[0] > 0 && a[3] - a[1] > 0)
                  return (0, r.shadow)(this, "view", a);
                (0, r.warn)("Empty /CropBox and /MediaBox intersection.");
              }
              return (0, r.shadow)(this, "view", t);
            }
            get rotate() {
              let e = this._getInheritableProperty("Rotate") || 0;
              e % 90 != 0
                ? (e = 0)
                : e >= 360
                  ? (e %= 360)
                  : e < 0 && (e = ((e % 360) + 360) % 360);
              return (0, r.shadow)(this, "rotate", e);
            }
            _onSubStreamError(e, t) {
              if (!this.evaluatorOptions.ignoreErrors) throw e;
              (0, r.warn)(
                `getContentStream - ignoring sub-stream (${t}): "${e}".`,
              );
            }
            getContentStream() {
              return this.pdfManager
                .ensure(this, "content")
                .then((e) =>
                  e instanceof c.BaseStream
                    ? e
                    : Array.isArray(e)
                      ? new y.StreamsSequenceStream(
                          e,
                          this._onSubStreamError.bind(this),
                        )
                      : new g.NullStream(),
                );
            }
            get xfaData() {
              return (0, r.shadow)(
                this,
                "xfaData",
                this.xfaFactory
                  ? { bbox: this.xfaFactory.getBoundingBox(this.pageIndex) }
                  : null,
              );
            }
            #t(e, t, a) {
              for (const n of e)
                if (n.id) {
                  const e = s.Ref.fromString(n.id);
                  if (!e) {
                    (0, r.warn)(
                      `A non-linked annotation cannot be modified: ${n.id}`,
                    );
                    continue;
                  }
                  if (n.deleted) {
                    t.put(e);
                    continue;
                  }
                  a?.put(e);
                  n.ref = e;
                  delete n.id;
                }
            }
            async saveNewAnnotations(e, t, a, r) {
              if (this.xfaFactory)
                throw new Error("XFA: Cannot save new annotations.");
              const i = new b.PartialEvaluator({
                  xref: this.xref,
                  handler: e,
                  pageIndex: this.pageIndex,
                  idFactory: this._localIdFactory,
                  fontCache: this.fontCache,
                  builtInCMapCache: this.builtInCMapCache,
                  standardFontDataCache: this.standardFontDataCache,
                  globalImageCache: this.globalImageCache,
                  systemFontCache: this.systemFontCache,
                  options: this.evaluatorOptions,
                }),
                o = new s.RefSet(),
                c = new s.RefSet();
              this.#t(a, o, c);
              const l = this.pageDict,
                h = this.annotations.filter(
                  (e) => !(e instanceof s.Ref && o.has(e)),
                ),
                u = await n.AnnotationFactory.saveNewAnnotations(i, t, a, r);
              for (const { ref: e } of u.annotations)
                e instanceof s.Ref && !c.has(e) && h.push(e);
              const d = l.get("Annots");
              l.set("Annots", h);
              const f = [];
              await (0, S.writeObject)(this.ref, l, f, this.xref);
              d && l.set("Annots", d);
              const g = u.dependencies;
              g.push({ ref: this.ref, data: f.join("") }, ...u.annotations);
              return g;
            }
            save(e, t, a) {
              const n = new b.PartialEvaluator({
                xref: this.xref,
                handler: e,
                pageIndex: this.pageIndex,
                idFactory: this._localIdFactory,
                fontCache: this.fontCache,
                builtInCMapCache: this.builtInCMapCache,
                standardFontDataCache: this.standardFontDataCache,
                globalImageCache: this.globalImageCache,
                systemFontCache: this.systemFontCache,
                options: this.evaluatorOptions,
              });
              return this._parsedAnnotations.then(function (e) {
                const i = [];
                for (const s of e)
                  s.mustBePrinted(a) &&
                    i.push(
                      s.save(n, t, a).catch(function (e) {
                        (0, r.warn)(
                          `save - ignoring annotation data during "${t.name}" task: "${e}".`,
                        );
                        return null;
                      }),
                    );
                return Promise.all(i).then(function (e) {
                  return e.filter((e) => !!e);
                });
              });
            }
            loadResources(e) {
              this.resourcesPromise ||
                (this.resourcesPromise = this.pdfManager.ensure(
                  this,
                  "resources",
                ));
              return this.resourcesPromise.then(() =>
                new p.ObjectLoader(this.resources, e, this.xref).load(),
              );
            }
            getOperatorList({
              handler: e,
              sink: t,
              task: a,
              intent: o,
              cacheKey: c,
              annotationStorage: l = null,
            }) {
              const h = this.getContentStream(),
                u = this.loadResources([
                  "ColorSpace",
                  "ExtGState",
                  "Font",
                  "Pattern",
                  "Properties",
                  "Shading",
                  "XObject",
                ]),
                d = new b.PartialEvaluator({
                  xref: this.xref,
                  handler: e,
                  pageIndex: this.pageIndex,
                  idFactory: this._localIdFactory,
                  fontCache: this.fontCache,
                  builtInCMapCache: this.builtInCMapCache,
                  standardFontDataCache: this.standardFontDataCache,
                  globalImageCache: this.globalImageCache,
                  systemFontCache: this.systemFontCache,
                  options: this.evaluatorOptions,
                }),
                f = this.xfaFactory ? null : (0, i.getNewAnnotationsMap)(l);
              let g = null,
                p = Promise.resolve(null);
              if (f) {
                const e = f.get(this.pageIndex);
                if (e) {
                  const t = this.pdfManager.ensureDoc("annotationGlobals");
                  let i;
                  const o = new Set();
                  for (const { bitmapId: t, bitmap: a } of e)
                    !t || a || o.has(t) || o.add(t);
                  const { isOffscreenCanvasSupported: c } =
                    this.evaluatorOptions;
                  if (o.size > 0) {
                    const t = e.slice();
                    for (const [e, a] of l)
                      e.startsWith(r.AnnotationEditorPrefix) &&
                        a.bitmap &&
                        o.has(a.bitmapId) &&
                        t.push(a);
                    i = n.AnnotationFactory.generateImages(t, this.xref, c);
                  } else
                    i = n.AnnotationFactory.generateImages(e, this.xref, c);
                  g = new s.RefSet();
                  this.#t(e, g, null);
                  p = t.then((t) =>
                    t
                      ? n.AnnotationFactory.printNewAnnotations(t, d, a, e, i)
                      : null,
                  );
                }
              }
              const y = Promise.all([h, u]).then(([r]) => {
                const n = new m.OperatorList(o, t);
                e.send("StartRenderPage", {
                  transparency: d.hasBlendModes(
                    this.resources,
                    this.nonBlendModesSet,
                  ),
                  pageIndex: this.pageIndex,
                  cacheKey: c,
                });
                return d
                  .getOperatorList({
                    stream: r,
                    task: a,
                    resources: this.resources,
                    operatorList: n,
                  })
                  .then(function () {
                    return n;
                  });
              });
              return Promise.all([y, this._parsedAnnotations, p]).then(
                function ([e, t, n]) {
                  if (n) {
                    t = t.filter((e) => !(e.ref && g.has(e.ref)));
                    for (let e = 0, a = n.length; e < a; e++) {
                      const r = n[e];
                      if (r.refToReplace) {
                        const i = t.findIndex(
                          (e) =>
                            e.ref && (0, s.isRefsEqual)(e.ref, r.refToReplace),
                        );
                        if (i >= 0) {
                          t.splice(i, 1, r);
                          n.splice(e--, 1);
                          a--;
                        }
                      }
                    }
                    t = t.concat(n);
                  }
                  if (
                    0 === t.length ||
                    o & r.RenderingIntentFlag.ANNOTATIONS_DISABLE
                  ) {
                    e.flush(!0);
                    return { length: e.totalLength };
                  }
                  const i = !!(o & r.RenderingIntentFlag.ANNOTATIONS_FORMS),
                    c = !!(o & r.RenderingIntentFlag.ANY),
                    h = !!(o & r.RenderingIntentFlag.DISPLAY),
                    u = !!(o & r.RenderingIntentFlag.PRINT),
                    f = [];
                  for (const e of t)
                    (c ||
                      (h && e.mustBeViewed(l, i)) ||
                      (u && e.mustBePrinted(l))) &&
                      f.push(
                        e.getOperatorList(d, a, o, i, l).catch(function (e) {
                          (0, r.warn)(
                            `getOperatorList - ignoring annotation data during "${a.name}" task: "${e}".`,
                          );
                          return {
                            opList: null,
                            separateForm: !1,
                            separateCanvas: !1,
                          };
                        }),
                      );
                  return Promise.all(f).then(function (t) {
                    let a = !1,
                      r = !1;
                    for (const {
                      opList: n,
                      separateForm: i,
                      separateCanvas: s,
                    } of t) {
                      e.addOpList(n);
                      a ||= i;
                      r ||= s;
                    }
                    e.flush(!0, { form: a, canvas: r });
                    return { length: e.totalLength };
                  });
                },
              );
            }
            extractTextContent({
              handler: e,
              task: t,
              includeMarkedContent: a,
              disableNormalization: r,
              sink: n,
            }) {
              const i = this.getContentStream(),
                s = this.loadResources([
                  "ExtGState",
                  "Font",
                  "Properties",
                  "XObject",
                ]);
              return Promise.all([i, s]).then(([i]) =>
                new b.PartialEvaluator({
                  xref: this.xref,
                  handler: e,
                  pageIndex: this.pageIndex,
                  idFactory: this._localIdFactory,
                  fontCache: this.fontCache,
                  builtInCMapCache: this.builtInCMapCache,
                  standardFontDataCache: this.standardFontDataCache,
                  globalImageCache: this.globalImageCache,
                  systemFontCache: this.systemFontCache,
                  options: this.evaluatorOptions,
                }).getTextContent({
                  stream: i,
                  task: t,
                  resources: this.resources,
                  includeMarkedContent: a,
                  disableNormalization: r,
                  sink: n,
                  viewBox: this.view,
                }),
              );
            }
            async getStructTree() {
              const e = await this.pdfManager.ensureCatalog("structTreeRoot");
              if (!e) return null;
              await this._parsedAnnotations;
              return (
                await this.pdfManager.ensure(this, "_parseStructTree", [e])
              ).serializable;
            }
            _parseStructTree(e) {
              const t = new w.StructTreePage(e, this.pageDict);
              t.parse(this.ref);
              return t;
            }
            async getAnnotationsData(e, t, a) {
              const n = await this._parsedAnnotations;
              if (0 === n.length) return n;
              const i = [],
                s = [];
              let o;
              const c = !!(a & r.RenderingIntentFlag.ANY),
                l = !!(a & r.RenderingIntentFlag.DISPLAY),
                h = !!(a & r.RenderingIntentFlag.PRINT);
              for (const a of n) {
                const n = c || (l && a.viewable);
                (n || (h && a.printable)) && i.push(a.data);
                if (a.hasTextContent && n) {
                  o ||= new b.PartialEvaluator({
                    xref: this.xref,
                    handler: e,
                    pageIndex: this.pageIndex,
                    idFactory: this._localIdFactory,
                    fontCache: this.fontCache,
                    builtInCMapCache: this.builtInCMapCache,
                    standardFontDataCache: this.standardFontDataCache,
                    globalImageCache: this.globalImageCache,
                    systemFontCache: this.systemFontCache,
                    options: this.evaluatorOptions,
                  });
                  s.push(
                    a
                      .extractTextContent(o, t, [-1 / 0, -1 / 0, 1 / 0, 1 / 0])
                      .catch(function (e) {
                        (0, r.warn)(
                          `getAnnotationsData - ignoring textContent during "${t.name}" task: "${e}".`,
                        );
                      }),
                  );
                }
              }
              await Promise.all(s);
              return i;
            }
            get annotations() {
              const e = this._getInheritableProperty("Annots");
              return (0, r.shadow)(
                this,
                "annotations",
                Array.isArray(e) ? e : [],
              );
            }
            get _parsedAnnotations() {
              const e = this.pdfManager
                .ensure(this, "annotations")
                .then(async (e) => {
                  if (0 === e.length) return e;
                  const t =
                    await this.pdfManager.ensureDoc("annotationGlobals");
                  if (!t) return [];
                  const a = [];
                  for (const i of e)
                    a.push(
                      n.AnnotationFactory.create(
                        this.xref,
                        i,
                        t,
                        this._localIdFactory,
                        !1,
                        this.ref,
                      ).catch(function (e) {
                        (0, r.warn)(`_parsedAnnotations: "${e}".`);
                        return null;
                      }),
                    );
                  const i = [];
                  let s;
                  for (const e of await Promise.all(a))
                    e &&
                      (e instanceof n.PopupAnnotation
                        ? (s ||= []).push(e)
                        : i.push(e));
                  s && i.push(...s);
                  return i;
                });
              return (0, r.shadow)(this, "_parsedAnnotations", e);
            }
            get jsActions() {
              const e = (0, i.collectActions)(
                this.xref,
                this.pageDict,
                r.PageActionEventType,
              );
              return (0, r.shadow)(this, "jsActions", e);
            }
          }
          t.Page = Page;
          const v = new Uint8Array([37, 80, 68, 70, 45]),
            F = new Uint8Array([115, 116, 97, 114, 116, 120, 114, 101, 102]),
            O = new Uint8Array([101, 110, 100, 111, 98, 106]);
          function find(e, t, a = 1024, r = !1) {
            const n = t.length,
              i = e.peekBytes(a),
              s = i.length - n;
            if (s <= 0) return !1;
            if (r) {
              const a = n - 1;
              let r = i.length - 1;
              for (; r >= a; ) {
                let s = 0;
                for (; s < n && i[r - s] === t[a - s]; ) s++;
                if (s >= n) {
                  e.pos += r - a;
                  return !0;
                }
                r--;
              }
            } else {
              let a = 0;
              for (; a <= s; ) {
                let r = 0;
                for (; r < n && i[a + r] === t[r]; ) r++;
                if (r >= n) {
                  e.pos += a;
                  return !0;
                }
                a++;
              }
            }
            return !1;
          }
          t.PDFDocument = class PDFDocument {
            constructor(e, t) {
              if (t.length <= 0)
                throw new r.InvalidPDFException(
                  "The PDF file is empty, i.e. its size is zero bytes.",
                );
              this.pdfManager = e;
              this.stream = t;
              this.xref = new C.XRef(t, e);
              this._pagePromises = new Map();
              this._version = null;
              const a = { font: 0 };
              this._globalIdFactory = class {
                static getDocId() {
                  return `g_${e.docId}`;
                }
                static createFontId() {
                  return "f" + ++a.font;
                }
                static createObjId() {
                  (0, r.unreachable)("Abstract method `createObjId` called.");
                }
                static getPageObjId() {
                  (0, r.unreachable)("Abstract method `getPageObjId` called.");
                }
              };
            }
            parse(e) {
              this.xref.parse(e);
              this.catalog = new h.Catalog(this.pdfManager, this.xref);
            }
            get linearization() {
              let e = null;
              try {
                e = f.Linearization.create(this.stream);
              } catch (e) {
                if (e instanceof i.MissingDataException) throw e;
                (0, r.info)(e);
              }
              return (0, r.shadow)(this, "linearization", e);
            }
            get startXRef() {
              const e = this.stream;
              let t = 0;
              if (this.linearization) {
                e.reset();
                find(e, O) && (t = e.pos + 6 - e.start);
              } else {
                const a = 1024,
                  r = F.length;
                let n = !1,
                  s = e.end;
                for (; !n && s > 0; ) {
                  s -= a - r;
                  s < 0 && (s = 0);
                  e.pos = s;
                  n = find(e, F, a, !0);
                }
                if (n) {
                  e.skip(9);
                  let a;
                  do {
                    a = e.getByte();
                  } while ((0, i.isWhiteSpace)(a));
                  let r = "";
                  for (; a >= 32 && a <= 57; ) {
                    r += String.fromCharCode(a);
                    a = e.getByte();
                  }
                  t = parseInt(r, 10);
                  isNaN(t) && (t = 0);
                }
              }
              return (0, r.shadow)(this, "startXRef", t);
            }
            checkHeader() {
              const e = this.stream;
              e.reset();
              if (!find(e, v)) return;
              e.moveStart();
              e.skip(v.length);
              let t,
                a = "";
              for (; (t = e.getByte()) > 32 && a.length < 7; )
                a += String.fromCharCode(t);
              i.PDF_VERSION_REGEXP.test(a)
                ? (this._version = a)
                : (0, r.warn)(`Invalid PDF header version: ${a}`);
            }
            parseStartXRef() {
              this.xref.setStartXRef(this.startXRef);
            }
            get numPages() {
              let e = 0;
              e = this.catalog.hasActualNumPages
                ? this.catalog.numPages
                : this.xfaFactory
                  ? this.xfaFactory.getNumPages()
                  : this.linearization
                    ? this.linearization.numPages
                    : this.catalog.numPages;
              return (0, r.shadow)(this, "numPages", e);
            }
            _hasOnlyDocumentSignatures(e, t = 0) {
              return (
                !!Array.isArray(e) &&
                e.every((e) => {
                  if (!((e = this.xref.fetchIfRef(e)) instanceof s.Dict))
                    return !1;
                  if (e.has("Kids")) {
                    if (++t > 10) {
                      (0, r.warn)(
                        "_hasOnlyDocumentSignatures: maximum recursion depth reached",
                      );
                      return !1;
                    }
                    return this._hasOnlyDocumentSignatures(e.get("Kids"), t);
                  }
                  const a = (0, s.isName)(e.get("FT"), "Sig"),
                    n = e.get("Rect"),
                    i = Array.isArray(n) && n.every((e) => 0 === e);
                  return a && i;
                })
              );
            }
            get _xfaStreams() {
              const e = this.catalog.acroForm;
              if (!e) return null;
              const t = e.get("XFA"),
                a = {
                  "xdp:xdp": "",
                  template: "",
                  datasets: "",
                  config: "",
                  connectionSet: "",
                  localeSet: "",
                  stylesheet: "",
                  "/xdp:xdp": "",
                };
              if (t instanceof c.BaseStream && !t.isEmpty) {
                a["xdp:xdp"] = t;
                return a;
              }
              if (!Array.isArray(t) || 0 === t.length) return null;
              for (let e = 0, r = t.length; e < r; e += 2) {
                let n;
                n = 0 === e ? "xdp:xdp" : e === r - 2 ? "/xdp:xdp" : t[e];
                if (!a.hasOwnProperty(n)) continue;
                const i = this.xref.fetchIfRef(t[e + 1]);
                i instanceof c.BaseStream && !i.isEmpty && (a[n] = i);
              }
              return a;
            }
            get xfaDatasets() {
              const e = this._xfaStreams;
              if (!e) return (0, r.shadow)(this, "xfaDatasets", null);
              for (const t of ["datasets", "xdp:xdp"]) {
                const a = e[t];
                if (a)
                  try {
                    const e = { [t]: (0, r.stringToUTF8String)(a.getString()) };
                    return (0, r.shadow)(
                      this,
                      "xfaDatasets",
                      new d.DatasetReader(e),
                    );
                  } catch {
                    (0, r.warn)("XFA - Invalid utf-8 string.");
                    break;
                  }
              }
              return (0, r.shadow)(this, "xfaDatasets", null);
            }
            get xfaData() {
              const e = this._xfaStreams;
              if (!e) return null;
              const t = Object.create(null);
              for (const [a, n] of Object.entries(e))
                if (n)
                  try {
                    t[a] = (0, r.stringToUTF8String)(n.getString());
                  } catch {
                    (0, r.warn)("XFA - Invalid utf-8 string.");
                    return null;
                  }
              return t;
            }
            get xfaFactory() {
              let e;
              this.pdfManager.enableXfa &&
                this.catalog.needsRendering &&
                this.formInfo.hasXfa &&
                !this.formInfo.hasAcroForm &&
                (e = this.xfaData);
              return (0, r.shadow)(
                this,
                "xfaFactory",
                e ? new x.XFAFactory(e) : null,
              );
            }
            get isPureXfa() {
              return !!this.xfaFactory && this.xfaFactory.isValid();
            }
            get htmlForXfa() {
              return this.xfaFactory ? this.xfaFactory.getPages() : null;
            }
            async loadXfaImages() {
              const e = await this.pdfManager.ensureCatalog("xfaImages");
              if (!e) return;
              const t = e.getKeys(),
                a = new p.ObjectLoader(e, t, this.xref);
              await a.load();
              const r = new Map();
              for (const a of t) {
                const t = e.get(a);
                t instanceof c.BaseStream && r.set(a, t.getBytes());
              }
              this.xfaFactory.setImages(r);
            }
            async loadXfaFonts(e, t) {
              const a = await this.pdfManager.ensureCatalog("acroForm");
              if (!a) return;
              const n = await a.getAsync("DR");
              if (!(n instanceof s.Dict)) return;
              const c = new p.ObjectLoader(n, ["Font"], this.xref);
              await c.load();
              const l = n.get("Font");
              if (!(l instanceof s.Dict)) return;
              const h = Object.assign(
                Object.create(null),
                this.pdfManager.evaluatorOptions,
              );
              h.useSystemFonts = !1;
              const u = new b.PartialEvaluator({
                  xref: this.xref,
                  handler: e,
                  pageIndex: -1,
                  idFactory: this._globalIdFactory,
                  fontCache: this.catalog.fontCache,
                  builtInCMapCache: this.catalog.builtInCMapCache,
                  standardFontDataCache: this.catalog.standardFontDataCache,
                  options: h,
                }),
                d = new m.OperatorList(),
                f = [],
                g = {
                  get font() {
                    return f.at(-1);
                  },
                  set font(e) {
                    f.push(e);
                  },
                  clone() {
                    return this;
                  },
                },
                y = new Map();
              l.forEach((e, t) => {
                y.set(e, t);
              });
              const w = [];
              for (const [e, a] of y) {
                const o = a.get("FontDescriptor");
                if (!(o instanceof s.Dict)) continue;
                let c = o.get("FontFamily");
                c = c.replaceAll(/[ ]+(\d)/g, "$1");
                const l = {
                  fontFamily: c,
                  fontWeight: o.get("FontWeight"),
                  italicAngle: -o.get("ItalicAngle"),
                };
                (0, i.validateCSSFont)(l) &&
                  w.push(
                    u
                      .handleSetFont(
                        n,
                        [s.Name.get(e), 1],
                        null,
                        d,
                        t,
                        g,
                        null,
                        l,
                      )
                      .catch(function (e) {
                        (0, r.warn)(`loadXfaFonts: "${e}".`);
                        return null;
                      }),
                  );
              }
              await Promise.all(w);
              const S = this.xfaFactory.setFonts(f);
              if (!S) return;
              h.ignoreErrors = !0;
              w.length = 0;
              f.length = 0;
              const x = new Set();
              for (const e of S)
                (0, o.getXfaFontName)(`${e}-Regular`) || x.add(e);
              x.size && S.push("PdfJS-Fallback");
              for (const e of S)
                if (!x.has(e))
                  for (const a of [
                    { name: "Regular", fontWeight: 400, italicAngle: 0 },
                    { name: "Bold", fontWeight: 700, italicAngle: 0 },
                    { name: "Italic", fontWeight: 400, italicAngle: 12 },
                    { name: "BoldItalic", fontWeight: 700, italicAngle: 12 },
                  ]) {
                    const i = `${e}-${a.name}`,
                      c = (0, o.getXfaFontDict)(i);
                    w.push(
                      u
                        .handleSetFont(
                          n,
                          [s.Name.get(i), 1],
                          null,
                          d,
                          t,
                          g,
                          c,
                          {
                            fontFamily: e,
                            fontWeight: a.fontWeight,
                            italicAngle: a.italicAngle,
                          },
                        )
                        .catch(function (e) {
                          (0, r.warn)(`loadXfaFonts: "${e}".`);
                          return null;
                        }),
                    );
                  }
              await Promise.all(w);
              this.xfaFactory.appendFonts(f, x);
            }
            async serializeXfaData(e) {
              return this.xfaFactory ? this.xfaFactory.serializeData(e) : null;
            }
            get version() {
              return this.catalog.version || this._version;
            }
            get formInfo() {
              const e = {
                  hasFields: !1,
                  hasAcroForm: !1,
                  hasXfa: !1,
                  hasSignatures: !1,
                },
                t = this.catalog.acroForm;
              if (!t) return (0, r.shadow)(this, "formInfo", e);
              try {
                const a = t.get("Fields"),
                  r = Array.isArray(a) && a.length > 0;
                e.hasFields = r;
                const n = t.get("XFA");
                e.hasXfa =
                  (Array.isArray(n) && n.length > 0) ||
                  (n instanceof c.BaseStream && !n.isEmpty);
                const i = !!(1 & t.get("SigFlags")),
                  s = i && this._hasOnlyDocumentSignatures(a);
                e.hasAcroForm = r && !s;
                e.hasSignatures = i;
              } catch (e) {
                if (e instanceof i.MissingDataException) throw e;
                (0, r.warn)(`Cannot fetch form information: "${e}".`);
              }
              return (0, r.shadow)(this, "formInfo", e);
            }
            get documentInfo() {
              const e = {
                PDFFormatVersion: this.version,
                Language: this.catalog.lang,
                EncryptFilterName: this.xref.encrypt
                  ? this.xref.encrypt.filterName
                  : null,
                IsLinearized: !!this.linearization,
                IsAcroFormPresent: this.formInfo.hasAcroForm,
                IsXFAPresent: this.formInfo.hasXfa,
                IsCollectionPresent: !!this.catalog.collection,
                IsSignaturesPresent: this.formInfo.hasSignatures,
              };
              let t;
              try {
                t = this.xref.trailer.get("Info");
              } catch (e) {
                if (e instanceof i.MissingDataException) throw e;
                (0, r.info)("The document information dictionary is invalid.");
              }
              if (!(t instanceof s.Dict))
                return (0, r.shadow)(this, "documentInfo", e);
              for (const a of t.getKeys()) {
                const n = t.get(a);
                switch (a) {
                  case "Title":
                  case "Author":
                  case "Subject":
                  case "Keywords":
                  case "Creator":
                  case "Producer":
                  case "CreationDate":
                  case "ModDate":
                    if ("string" == typeof n) {
                      e[a] = (0, r.stringToPDFString)(n);
                      continue;
                    }
                    break;
                  case "Trapped":
                    if (n instanceof s.Name) {
                      e[a] = n;
                      continue;
                    }
                    break;
                  default:
                    let t;
                    switch (typeof n) {
                      case "string":
                        t = (0, r.stringToPDFString)(n);
                        break;
                      case "number":
                      case "boolean":
                        t = n;
                        break;
                      default:
                        n instanceof s.Name && (t = n);
                    }
                    if (void 0 === t) {
                      (0, r.warn)(
                        `Bad value, for custom key "${a}", in Info: ${n}.`,
                      );
                      continue;
                    }
                    e.Custom || (e.Custom = Object.create(null));
                    e.Custom[a] = t;
                    continue;
                }
                (0, r.warn)(`Bad value, for key "${a}", in Info: ${n}.`);
              }
              return (0, r.shadow)(this, "documentInfo", e);
            }
            get fingerprints() {
              function validate(e) {
                return (
                  "string" == typeof e &&
                  e.length > 0 &&
                  "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0" !== e
                );
              }
              function hexString(e) {
                const t = [];
                for (const a of e) {
                  const e = a.toString(16);
                  t.push(e.padStart(2, "0"));
                }
                return t.join("");
              }
              const e = this.xref.trailer.get("ID");
              let t, a;
              if (Array.isArray(e) && validate(e[0])) {
                t = (0, r.stringToBytes)(e[0]);
                e[1] !== e[0] &&
                  validate(e[1]) &&
                  (a = (0, r.stringToBytes)(e[1]));
              } else
                t = (0, l.calculateMD5)(
                  this.stream.getByteRange(0, 1024),
                  0,
                  1024,
                );
              return (0, r.shadow)(this, "fingerprints", [
                hexString(t),
                a ? hexString(a) : null,
              ]);
            }
            async _getLinearizationPage(e) {
              const { catalog: t, linearization: a, xref: n } = this,
                i = s.Ref.get(a.objectNumberFirst, 0);
              try {
                const e = await n.fetchAsync(i);
                if (e instanceof s.Dict) {
                  let a = e.getRaw("Type");
                  a instanceof s.Ref && (a = await n.fetchAsync(a));
                  if (
                    (0, s.isName)(a, "Page") ||
                    (!e.has("Type") && !e.has("Kids"))
                  ) {
                    t.pageKidsCountCache.has(i) ||
                      t.pageKidsCountCache.put(i, 1);
                    t.pageIndexCache.has(i) || t.pageIndexCache.put(i, 0);
                    return [e, i];
                  }
                }
                throw new r.FormatError(
                  "The Linearization dictionary doesn't point to a valid Page dictionary.",
                );
              } catch (a) {
                (0, r.warn)(`_getLinearizationPage: "${a.message}".`);
                return t.getPageDict(e);
              }
            }
            getPage(e) {
              const t = this._pagePromises.get(e);
              if (t) return t;
              const { catalog: a, linearization: r, xfaFactory: n } = this;
              let i;
              i = n
                ? Promise.resolve([s.Dict.empty, null])
                : r?.pageFirst === e
                  ? this._getLinearizationPage(e)
                  : a.getPageDict(e);
              i = i.then(
                ([t, r]) =>
                  new Page({
                    pdfManager: this.pdfManager,
                    xref: this.xref,
                    pageIndex: e,
                    pageDict: t,
                    ref: r,
                    globalIdFactory: this._globalIdFactory,
                    fontCache: a.fontCache,
                    builtInCMapCache: a.builtInCMapCache,
                    standardFontDataCache: a.standardFontDataCache,
                    globalImageCache: a.globalImageCache,
                    systemFontCache: a.systemFontCache,
                    nonBlendModesSet: a.nonBlendModesSet,
                    xfaFactory: n,
                  }),
              );
              this._pagePromises.set(e, i);
              return i;
            }
            async checkFirstPage(e = !1) {
              if (!e)
                try {
                  await this.getPage(0);
                } catch (e) {
                  if (e instanceof i.XRefEntryException) {
                    this._pagePromises.delete(0);
                    await this.cleanup();
                    throw new i.XRefParseException();
                  }
                }
            }
            async checkLastPage(e = !1) {
              const { catalog: t, pdfManager: a } = this;
              t.setActualNumPages();
              let n;
              try {
                await Promise.all([
                  a.ensureDoc("xfaFactory"),
                  a.ensureDoc("linearization"),
                  a.ensureCatalog("numPages"),
                ]);
                if (this.xfaFactory) return;
                n = this.linearization
                  ? this.linearization.numPages
                  : t.numPages;
                if (!Number.isInteger(n))
                  throw new r.FormatError("Page count is not an integer.");
                if (n <= 1) return;
                await this.getPage(n - 1);
              } catch (s) {
                this._pagePromises.delete(n - 1);
                await this.cleanup();
                if (s instanceof i.XRefEntryException && !e)
                  throw new i.XRefParseException();
                (0, r.warn)(
                  `checkLastPage - invalid /Pages tree /Count: ${n}.`,
                );
                let o;
                try {
                  o = await t.getAllPageDicts(e);
                } catch (a) {
                  if (a instanceof i.XRefEntryException && !e)
                    throw new i.XRefParseException();
                  t.setActualNumPages(1);
                  return;
                }
                for (const [e, [r, n]] of o) {
                  let i;
                  if (r instanceof Error) {
                    i = Promise.reject(r);
                    i.catch(() => {});
                  } else
                    i = Promise.resolve(
                      new Page({
                        pdfManager: a,
                        xref: this.xref,
                        pageIndex: e,
                        pageDict: r,
                        ref: n,
                        globalIdFactory: this._globalIdFactory,
                        fontCache: t.fontCache,
                        builtInCMapCache: t.builtInCMapCache,
                        standardFontDataCache: t.standardFontDataCache,
                        globalImageCache: t.globalImageCache,
                        systemFontCache: t.systemFontCache,
                        nonBlendModesSet: t.nonBlendModesSet,
                        xfaFactory: null,
                      }),
                    );
                  this._pagePromises.set(e, i);
                }
                t.setActualNumPages(o.size);
              }
            }
            fontFallback(e, t) {
              return this.catalog.fontFallback(e, t);
            }
            async cleanup(e = !1) {
              return this.catalog
                ? this.catalog.cleanup(e)
                : (0, u.clearGlobalCaches)();
            }
            #a(e, t, a, i) {
              const s = this.xref.fetchIfRef(t);
              if (s.has("T")) {
                const t = (0, r.stringToPDFString)(s.get("T"));
                e = "" === e ? t : `${e}.${t}`;
              }
              a.has(e) || a.set(e, []);
              a.get(e).push(
                n.AnnotationFactory.create(
                  this.xref,
                  t,
                  i,
                  this._localIdFactory,
                  !0,
                  null,
                )
                  .then((e) => e?.getFieldObject())
                  .catch(function (e) {
                    (0, r.warn)(`#collectFieldObjects: "${e}".`);
                    return null;
                  }),
              );
              if (s.has("Kids"))
                for (const t of s.get("Kids")) this.#a(e, t, a, i);
            }
            get fieldObjects() {
              if (!this.formInfo.hasFields)
                return (0, r.shadow)(
                  this,
                  "fieldObjects",
                  Promise.resolve(null),
                );
              const e = this.pdfManager
                .ensureDoc("annotationGlobals")
                .then(async (e) => {
                  if (!e) return null;
                  const t = Object.create(null),
                    a = new Map();
                  for (const t of this.catalog.acroForm.get("Fields"))
                    this.#a("", t, a, e);
                  const r = [];
                  for (const [e, n] of a)
                    r.push(
                      Promise.all(n).then((a) => {
                        (a = a.filter((e) => !!e)).length > 0 && (t[e] = a);
                      }),
                    );
                  await Promise.all(r);
                  return t;
                });
              return (0, r.shadow)(this, "fieldObjects", e);
            }
            get hasJSActions() {
              const e = this.pdfManager.ensureDoc("_parseHasJSActions");
              return (0, r.shadow)(this, "hasJSActions", e);
            }
            async _parseHasJSActions() {
              const [e, t] = await Promise.all([
                this.pdfManager.ensureCatalog("jsActions"),
                this.pdfManager.ensureDoc("fieldObjects"),
              ]);
              return (
                !!e ||
                (!!t &&
                  Object.values(t).some((e) =>
                    e.some((e) => null !== e.actions),
                  ))
              );
            }
            get calculationOrderIds() {
              const e = this.catalog.acroForm;
              if (!e?.has("CO"))
                return (0, r.shadow)(this, "calculationOrderIds", null);
              const t = e.get("CO");
              if (!Array.isArray(t) || 0 === t.length)
                return (0, r.shadow)(this, "calculationOrderIds", null);
              const a = [];
              for (const e of t) e instanceof s.Ref && a.push(e.toString());
              return 0 === a.length
                ? (0, r.shadow)(this, "calculationOrderIds", null)
                : (0, r.shadow)(this, "calculationOrderIds", a);
            }
            get annotationGlobals() {
              return (0, r.shadow)(
                this,
                "annotationGlobals",
                n.AnnotationFactory.createGlobals(this.pdfManager),
              );
            }
          };
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.PopupAnnotation =
            t.MarkupAnnotation =
            t.AnnotationFactory =
            t.AnnotationBorderStyle =
            t.Annotation =
              void 0;
          t.getQuadPoints = getQuadPoints;
          var r = a(2),
            n = a(3),
            i = a(11),
            s = a(4),
            o = a(8),
            c = a(5),
            l = a(60),
            h = a(66),
            u = a(12),
            d = a(69),
            f = a(26),
            g = a(76),
            p = a(64),
            m = a(73),
            b = a(77);
          t.AnnotationFactory = class AnnotationFactory {
            static createGlobals(e) {
              return Promise.all([
                e.ensureCatalog("acroForm"),
                e.ensureDoc("xfaDatasets"),
                e.ensureCatalog("structTreeRoot"),
                e.ensureCatalog("baseUrl"),
                e.ensureCatalog("attachments"),
              ]).then(
                ([t, a, r, n, i]) => ({
                  pdfManager: e,
                  acroForm: t instanceof s.Dict ? t : s.Dict.empty,
                  xfaDatasets: a,
                  structTreeRoot: r,
                  baseUrl: n,
                  attachments: i,
                }),
                (e) => {
                  (0, r.warn)(`createGlobals: "${e}".`);
                  return null;
                },
              );
            }
            static async create(e, t, a, r, n, i) {
              const s = n ? await this._getPageIndex(e, t, a.pdfManager) : null;
              return a.pdfManager.ensure(this, "_create", [
                e,
                t,
                a,
                r,
                n,
                s,
                i,
              ]);
            }
            static _create(e, t, a, i, o = !1, c = null, l = null) {
              const h = e.fetchIfRef(t);
              if (!(h instanceof s.Dict)) return;
              const { acroForm: u, pdfManager: d } = a,
                f =
                  t instanceof s.Ref
                    ? t.toString()
                    : `annot_${i.createObjId()}`;
              let g = h.get("Subtype");
              g = g instanceof s.Name ? g.name : null;
              const p = {
                xref: e,
                ref: t,
                dict: h,
                subtype: g,
                id: f,
                annotationGlobals: a,
                collectFields: o,
                needAppearances: !o && !0 === u.get("NeedAppearances"),
                pageIndex: c,
                evaluatorOptions: d.evaluatorOptions,
                pageRef: l,
              };
              switch (g) {
                case "Link":
                  return new LinkAnnotation(p);
                case "Text":
                  return new TextAnnotation(p);
                case "Widget":
                  let e = (0, n.getInheritableProperty)({ dict: h, key: "FT" });
                  e = e instanceof s.Name ? e.name : null;
                  switch (e) {
                    case "Tx":
                      return new TextWidgetAnnotation(p);
                    case "Btn":
                      return new ButtonWidgetAnnotation(p);
                    case "Ch":
                      return new ChoiceWidgetAnnotation(p);
                    case "Sig":
                      return new SignatureWidgetAnnotation(p);
                  }
                  (0, r.warn)(
                    `Unimplemented widget field type "${e}", falling back to base field type.`,
                  );
                  return new WidgetAnnotation(p);
                case "Popup":
                  return new PopupAnnotation(p);
                case "FreeText":
                  return new FreeTextAnnotation(p);
                case "Line":
                  return new LineAnnotation(p);
                case "Square":
                  return new SquareAnnotation(p);
                case "Circle":
                  return new CircleAnnotation(p);
                case "PolyLine":
                  return new PolylineAnnotation(p);
                case "Polygon":
                  return new PolygonAnnotation(p);
                case "Caret":
                  return new CaretAnnotation(p);
                case "Ink":
                  return new InkAnnotation(p);
                case "Highlight":
                  return new HighlightAnnotation(p);
                case "Underline":
                  return new UnderlineAnnotation(p);
                case "Squiggly":
                  return new SquigglyAnnotation(p);
                case "StrikeOut":
                  return new StrikeOutAnnotation(p);
                case "Stamp":
                  return new StampAnnotation(p);
                case "FileAttachment":
                  return new FileAttachmentAnnotation(p);
                default:
                  o ||
                    (g
                      ? (0, r.warn)(
                          `Unimplemented annotation type "${g}", falling back to base annotation.`,
                        )
                      : (0, r.warn)(
                          "Annotation is missing the required /Subtype.",
                        ));
                  return new Annotation(p);
              }
            }
            static async _getPageIndex(e, t, a) {
              try {
                const n = await e.fetchIfRefAsync(t);
                if (!(n instanceof s.Dict)) return -1;
                const i = n.getRaw("P");
                if (i instanceof s.Ref)
                  try {
                    return await a.ensureCatalog("getPageIndex", [i]);
                  } catch (e) {
                    (0, r.info)(
                      `_getPageIndex -- not a valid page reference: "${e}".`,
                    );
                  }
                if (n.has("Kids")) return -1;
                const o = await a.ensureDoc("numPages");
                for (let e = 0; e < o; e++) {
                  const r = await a.getPage(e),
                    n = await a.ensure(r, "annotations");
                  for (const a of n)
                    if (a instanceof s.Ref && (0, s.isRefsEqual)(a, t))
                      return e;
                }
              } catch (e) {
                (0, r.warn)(`_getPageIndex: "${e}".`);
              }
              return -1;
            }
            static generateImages(e, t, a) {
              if (!a) {
                (0, r.warn)(
                  "generateImages: OffscreenCanvas is not supported, cannot save or print some annotations with images.",
                );
                return null;
              }
              let n;
              for (const { bitmapId: a, bitmap: r } of e)
                if (r) {
                  n ||= new Map();
                  n.set(a, StampAnnotation.createImage(r, t));
                }
              return n;
            }
            static async saveNewAnnotations(e, t, a, n) {
              const i = e.xref;
              let o;
              const c = [],
                l = [],
                { isOffscreenCanvasSupported: h } = e.options;
              for (const u of a)
                if (!u.deleted)
                  switch (u.annotationType) {
                    case r.AnnotationEditorType.FREETEXT:
                      if (!o) {
                        const e = new s.Dict(i);
                        e.set("BaseFont", s.Name.get("Helvetica"));
                        e.set("Type", s.Name.get("Font"));
                        e.set("Subtype", s.Name.get("Type1"));
                        e.set("Encoding", s.Name.get("WinAnsiEncoding"));
                        const t = [];
                        o = i.getNewTemporaryRef();
                        await (0, m.writeObject)(o, e, t, i);
                        c.push({ ref: o, data: t.join("") });
                      }
                      l.push(
                        FreeTextAnnotation.createNewAnnotation(i, u, c, {
                          evaluator: e,
                          task: t,
                          baseFontRef: o,
                        }),
                      );
                      break;
                    case r.AnnotationEditorType.INK:
                      l.push(InkAnnotation.createNewAnnotation(i, u, c));
                      break;
                    case r.AnnotationEditorType.STAMP:
                      if (!h) break;
                      const a = await n.get(u.bitmapId);
                      if (a.imageStream) {
                        const { imageStream: e, smaskStream: t } = a,
                          r = [];
                        if (t) {
                          const a = i.getNewTemporaryRef();
                          await (0, m.writeObject)(a, t, r, i);
                          c.push({ ref: a, data: r.join("") });
                          e.dict.set("SMask", a);
                          r.length = 0;
                        }
                        const n = (a.imageRef = i.getNewTemporaryRef());
                        await (0, m.writeObject)(n, e, r, i);
                        c.push({ ref: n, data: r.join("") });
                        a.imageStream = a.smaskStream = null;
                      }
                      l.push(
                        StampAnnotation.createNewAnnotation(i, u, c, {
                          image: a,
                        }),
                      );
                  }
              return { annotations: await Promise.all(l), dependencies: c };
            }
            static async printNewAnnotations(e, t, a, n, i) {
              if (!n) return null;
              const { options: s, xref: o } = t,
                c = [];
              for (const l of n)
                if (!l.deleted)
                  switch (l.annotationType) {
                    case r.AnnotationEditorType.FREETEXT:
                      c.push(
                        FreeTextAnnotation.createNewPrintAnnotation(e, o, l, {
                          evaluator: t,
                          task: a,
                          evaluatorOptions: s,
                        }),
                      );
                      break;
                    case r.AnnotationEditorType.INK:
                      c.push(
                        InkAnnotation.createNewPrintAnnotation(e, o, l, {
                          evaluatorOptions: s,
                        }),
                      );
                      break;
                    case r.AnnotationEditorType.STAMP:
                      if (!s.isOffscreenCanvasSupported) break;
                      const n = await i.get(l.bitmapId);
                      if (n.imageStream) {
                        const { imageStream: e, smaskStream: t } = n;
                        t && e.dict.set("SMask", t);
                        n.imageRef = new f.JpegStream(e, e.length);
                        n.imageStream = n.smaskStream = null;
                      }
                      c.push(
                        StampAnnotation.createNewPrintAnnotation(e, o, l, {
                          image: n,
                          evaluatorOptions: s,
                        }),
                      );
                  }
              return Promise.all(c);
            }
          };
          function getRgbColor(e, t = new Uint8ClampedArray(3)) {
            if (!Array.isArray(e)) return t;
            const a = t || new Uint8ClampedArray(3);
            switch (e.length) {
              case 0:
                return null;
              case 1:
                u.ColorSpace.singletons.gray.getRgbItem(e, 0, a, 0);
                return a;
              case 3:
                u.ColorSpace.singletons.rgb.getRgbItem(e, 0, a, 0);
                return a;
              case 4:
                u.ColorSpace.singletons.cmyk.getRgbItem(e, 0, a, 0);
                return a;
              default:
                return t;
            }
          }
          function getPdfColorArray(e) {
            return Array.from(e, (e) => e / 255);
          }
          function getQuadPoints(e, t) {
            const a = e.getArray("QuadPoints");
            if (!Array.isArray(a) || 0 === a.length || a.length % 8 > 0)
              return null;
            const r = [];
            for (let e = 0, n = a.length / 8; e < n; e++) {
              let n = 1 / 0,
                i = -1 / 0,
                s = 1 / 0,
                o = -1 / 0;
              for (let t = 8 * e, r = 8 * e + 8; t < r; t += 2) {
                const e = a[t],
                  r = a[t + 1];
                n = Math.min(e, n);
                i = Math.max(e, i);
                s = Math.min(r, s);
                o = Math.max(r, o);
              }
              if (null !== t && (n < t[0] || i > t[2] || s < t[1] || o > t[3]))
                return null;
              r.push([
                { x: n, y: o },
                { x: i, y: o },
                { x: n, y: s },
                { x: i, y: s },
              ]);
            }
            return r;
          }
          function getTransformMatrix(e, t, a) {
            const [n, i, s, o] = r.Util.getAxialAlignedBoundingBox(t, a);
            if (n === s || i === o) return [1, 0, 0, 1, e[0], e[1]];
            const c = (e[2] - e[0]) / (s - n),
              l = (e[3] - e[1]) / (o - i);
            return [c, 0, 0, l, e[0] - n * c, e[1] - i * l];
          }
          class Annotation {
            constructor(e) {
              const { dict: t, xref: a, annotationGlobals: i } = e;
              this.setTitle(t.get("T"));
              this.setContents(t.get("Contents"));
              this.setModificationDate(t.get("M"));
              this.setFlags(t.get("F"));
              this.setRectangle(t.getArray("Rect"));
              this.setColor(t.getArray("C"));
              this.setBorderStyle(t);
              this.setAppearance(t);
              this.setOptionalContent(t);
              const o = t.get("MK");
              this.setBorderAndBackgroundColors(o);
              this.setRotation(o, t);
              this.ref = e.ref instanceof s.Ref ? e.ref : null;
              this._streams = [];
              this.appearance && this._streams.push(this.appearance);
              const c = !!(this.flags & r.AnnotationFlag.LOCKED),
                l = !!(this.flags & r.AnnotationFlag.LOCKEDCONTENTS);
              if (i.structTreeRoot) {
                let a = t.get("StructParent");
                a = Number.isInteger(a) && a >= 0 ? a : -1;
                i.structTreeRoot.addAnnotationIdToPage(e.pageRef, a);
              }
              this.data = {
                annotationFlags: this.flags,
                borderStyle: this.borderStyle,
                color: this.color,
                backgroundColor: this.backgroundColor,
                borderColor: this.borderColor,
                rotation: this.rotation,
                contentsObj: this._contents,
                hasAppearance: !!this.appearance,
                id: e.id,
                modificationDate: this.modificationDate,
                rect: this.rectangle,
                subtype: e.subtype,
                hasOwnCanvas: !1,
                noRotate: !!(this.flags & r.AnnotationFlag.NOROTATE),
                noHTML: c && l,
              };
              if (e.collectFields) {
                const i = t.get("Kids");
                if (Array.isArray(i)) {
                  const e = [];
                  for (const t of i) t instanceof s.Ref && e.push(t.toString());
                  0 !== e.length && (this.data.kidIds = e);
                }
                this.data.actions = (0, n.collectActions)(
                  a,
                  t,
                  r.AnnotationActionEventType,
                );
                this.data.fieldName = this._constructFieldName(t);
                this.data.pageIndex = e.pageIndex;
              }
              this._isOffscreenCanvasSupported =
                e.evaluatorOptions.isOffscreenCanvasSupported;
              this._fallbackFontDict = null;
              this._needAppearances = !1;
            }
            _hasFlag(e, t) {
              return !!(e & t);
            }
            _isViewable(e) {
              return (
                !this._hasFlag(e, r.AnnotationFlag.INVISIBLE) &&
                !this._hasFlag(e, r.AnnotationFlag.NOVIEW)
              );
            }
            _isPrintable(e) {
              return (
                this._hasFlag(e, r.AnnotationFlag.PRINT) &&
                !this._hasFlag(e, r.AnnotationFlag.HIDDEN) &&
                !this._hasFlag(e, r.AnnotationFlag.INVISIBLE)
              );
            }
            mustBeViewed(e, t) {
              const a = e?.get(this.data.id)?.noView;
              return void 0 !== a
                ? !a
                : this.viewable &&
                    !this._hasFlag(this.flags, r.AnnotationFlag.HIDDEN);
            }
            mustBePrinted(e) {
              const t = e?.get(this.data.id)?.noPrint;
              return void 0 !== t ? !t : this.printable;
            }
            get viewable() {
              return (
                null !== this.data.quadPoints &&
                (0 === this.flags || this._isViewable(this.flags))
              );
            }
            get printable() {
              return (
                null !== this.data.quadPoints &&
                0 !== this.flags &&
                this._isPrintable(this.flags)
              );
            }
            _parseStringHelper(e) {
              const t = "string" == typeof e ? (0, r.stringToPDFString)(e) : "";
              return {
                str: t,
                dir: t && "rtl" === (0, l.bidi)(t).dir ? "rtl" : "ltr",
              };
            }
            setDefaultAppearance(e) {
              const { dict: t, annotationGlobals: a } = e,
                r =
                  (0, n.getInheritableProperty)({ dict: t, key: "DA" }) ||
                  a.acroForm.get("DA");
              this._defaultAppearance = "string" == typeof r ? r : "";
              this.data.defaultAppearanceData = (0, i.parseDefaultAppearance)(
                this._defaultAppearance,
              );
            }
            setTitle(e) {
              this._title = this._parseStringHelper(e);
            }
            setContents(e) {
              this._contents = this._parseStringHelper(e);
            }
            setModificationDate(e) {
              this.modificationDate = "string" == typeof e ? e : null;
            }
            setFlags(e) {
              this.flags = Number.isInteger(e) && e > 0 ? e : 0;
            }
            hasFlag(e) {
              return this._hasFlag(this.flags, e);
            }
            setRectangle(e) {
              this.rectangle =
                Array.isArray(e) && 4 === e.length
                  ? r.Util.normalizeRect(e)
                  : [0, 0, 0, 0];
            }
            setColor(e) {
              this.color = getRgbColor(e);
            }
            setLineEndings(e) {
              this.lineEndings = ["None", "None"];
              if (Array.isArray(e) && 2 === e.length)
                for (let t = 0; t < 2; t++) {
                  const a = e[t];
                  if (a instanceof s.Name)
                    switch (a.name) {
                      case "None":
                        continue;
                      case "Square":
                      case "Circle":
                      case "Diamond":
                      case "OpenArrow":
                      case "ClosedArrow":
                      case "Butt":
                      case "ROpenArrow":
                      case "RClosedArrow":
                      case "Slash":
                        this.lineEndings[t] = a.name;
                        continue;
                    }
                  (0, r.warn)(`Ignoring invalid lineEnding: ${a}`);
                }
            }
            setRotation(e, t) {
              this.rotation = 0;
              let a =
                e instanceof s.Dict ? e.get("R") || 0 : t.get("Rotate") || 0;
              if (Number.isInteger(a) && 0 !== a) {
                a %= 360;
                a < 0 && (a += 360);
                a % 90 == 0 && (this.rotation = a);
              }
            }
            setBorderAndBackgroundColors(e) {
              if (e instanceof s.Dict) {
                this.borderColor = getRgbColor(e.getArray("BC"), null);
                this.backgroundColor = getRgbColor(e.getArray("BG"), null);
              } else this.borderColor = this.backgroundColor = null;
            }
            setBorderStyle(e) {
              this.borderStyle = new AnnotationBorderStyle();
              if (e instanceof s.Dict)
                if (e.has("BS")) {
                  const t = e.get("BS"),
                    a = t.get("Type");
                  if (!a || (0, s.isName)(a, "Border")) {
                    this.borderStyle.setWidth(t.get("W"), this.rectangle);
                    this.borderStyle.setStyle(t.get("S"));
                    this.borderStyle.setDashArray(t.getArray("D"));
                  }
                } else if (e.has("Border")) {
                  const t = e.getArray("Border");
                  if (Array.isArray(t) && t.length >= 3) {
                    this.borderStyle.setHorizontalCornerRadius(t[0]);
                    this.borderStyle.setVerticalCornerRadius(t[1]);
                    this.borderStyle.setWidth(t[2], this.rectangle);
                    4 === t.length && this.borderStyle.setDashArray(t[3], !0);
                  }
                } else this.borderStyle.setWidth(0);
            }
            setAppearance(e) {
              this.appearance = null;
              const t = e.get("AP");
              if (!(t instanceof s.Dict)) return;
              const a = t.get("N");
              if (a instanceof c.BaseStream) {
                this.appearance = a;
                return;
              }
              if (!(a instanceof s.Dict)) return;
              const r = e.get("AS");
              if (!(r instanceof s.Name && a.has(r.name))) return;
              const n = a.get(r.name);
              n instanceof c.BaseStream && (this.appearance = n);
            }
            setOptionalContent(e) {
              this.oc = null;
              const t = e.get("OC");
              t instanceof s.Name
                ? (0, r.warn)(
                    "setOptionalContent: Support for /Name-entry is not implemented.",
                  )
                : t instanceof s.Dict && (this.oc = t);
            }
            loadResources(e, t) {
              return t.dict.getAsync("Resources").then((t) => {
                if (!t) return;
                return new g.ObjectLoader(t, e, t.xref)
                  .load()
                  .then(function () {
                    return t;
                  });
              });
            }
            async getOperatorList(e, t, a, n, i) {
              const c = this.data;
              let l = this.appearance;
              const h = !!(
                this.data.hasOwnCanvas && a & r.RenderingIntentFlag.DISPLAY
              );
              if (!l) {
                if (!h)
                  return {
                    opList: new p.OperatorList(),
                    separateForm: !1,
                    separateCanvas: !1,
                  };
                l = new o.StringStream("");
                l.dict = new s.Dict();
              }
              const u = l.dict,
                d = await this.loadResources(
                  [
                    "ExtGState",
                    "ColorSpace",
                    "Pattern",
                    "Shading",
                    "XObject",
                    "Font",
                  ],
                  l,
                ),
                f = u.getArray("BBox") || [0, 0, 1, 1],
                g = u.getArray("Matrix") || [1, 0, 0, 1, 0, 0],
                m = getTransformMatrix(c.rect, f, g),
                b = new p.OperatorList();
              let y;
              this.oc && (y = await e.parseMarkedContentProps(this.oc, null));
              void 0 !== y && b.addOp(r.OPS.beginMarkedContentProps, ["OC", y]);
              b.addOp(r.OPS.beginAnnotation, [c.id, c.rect, m, g, h]);
              await e.getOperatorList({
                stream: l,
                task: t,
                resources: d,
                operatorList: b,
                fallbackFontDict: this._fallbackFontDict,
              });
              b.addOp(r.OPS.endAnnotation, []);
              void 0 !== y && b.addOp(r.OPS.endMarkedContent, []);
              this.reset();
              return { opList: b, separateForm: !1, separateCanvas: h };
            }
            async save(e, t, a) {
              return null;
            }
            get hasTextContent() {
              return !1;
            }
            async extractTextContent(e, t, a) {
              if (!this.appearance) return;
              const n = await this.loadResources(
                  ["ExtGState", "Font", "Properties", "XObject"],
                  this.appearance,
                ),
                i = [],
                s = [];
              let o = null;
              const c = {
                desiredSize: Math.Infinity,
                ready: !0,
                enqueue(e, t) {
                  for (const t of e.items)
                    if (void 0 !== t.str) {
                      o ||= t.transform.slice(-2);
                      s.push(t.str);
                      if (t.hasEOL) {
                        i.push(s.join(""));
                        s.length = 0;
                      }
                    }
                },
              };
              await e.getTextContent({
                stream: this.appearance,
                task: t,
                resources: n,
                includeMarkedContent: !0,
                sink: c,
                viewBox: a,
              });
              this.reset();
              s.length && i.push(s.join(""));
              if (i.length > 1 || i[0]) {
                const e = this.appearance.dict,
                  t = e.getArray("BBox") || [0, 0, 1, 1],
                  a = e.getArray("Matrix") || [1, 0, 0, 1, 0, 0],
                  n = this.data.rect,
                  s = getTransformMatrix(n, t, a);
                s[4] -= n[0];
                s[5] -= n[1];
                o = r.Util.applyTransform(o, s);
                o = r.Util.applyTransform(o, a);
                this.data.textPosition = o;
                this.data.textContent = i;
              }
            }
            getFieldObject() {
              return this.data.kidIds
                ? {
                    id: this.data.id,
                    actions: this.data.actions,
                    name: this.data.fieldName,
                    strokeColor: this.data.borderColor,
                    fillColor: this.data.backgroundColor,
                    type: "",
                    kidIds: this.data.kidIds,
                    page: this.data.pageIndex,
                    rotation: this.rotation,
                  }
                : null;
            }
            reset() {
              for (const e of this._streams) e.reset();
            }
            _constructFieldName(e) {
              if (!e.has("T") && !e.has("Parent")) {
                (0, r.warn)(
                  "Unknown field name, falling back to empty field name.",
                );
                return "";
              }
              if (!e.has("Parent")) return (0, r.stringToPDFString)(e.get("T"));
              const t = [];
              e.has("T") && t.unshift((0, r.stringToPDFString)(e.get("T")));
              let a = e;
              const n = new s.RefSet();
              e.objId && n.put(e.objId);
              for (; a.has("Parent"); ) {
                a = a.get("Parent");
                if (!(a instanceof s.Dict) || (a.objId && n.has(a.objId)))
                  break;
                a.objId && n.put(a.objId);
                a.has("T") && t.unshift((0, r.stringToPDFString)(a.get("T")));
              }
              return t.join(".");
            }
          }
          t.Annotation = Annotation;
          class AnnotationBorderStyle {
            constructor() {
              this.width = 1;
              this.style = r.AnnotationBorderStyleType.SOLID;
              this.dashArray = [3];
              this.horizontalCornerRadius = 0;
              this.verticalCornerRadius = 0;
            }
            setWidth(e, t = [0, 0, 0, 0]) {
              if (e instanceof s.Name) this.width = 0;
              else if ("number" == typeof e) {
                if (e > 0) {
                  const a = (t[2] - t[0]) / 2,
                    n = (t[3] - t[1]) / 2;
                  if (a > 0 && n > 0 && (e > a || e > n)) {
                    (0, r.warn)(
                      `AnnotationBorderStyle.setWidth - ignoring width: ${e}`,
                    );
                    e = 1;
                  }
                }
                this.width = e;
              }
            }
            setStyle(e) {
              if (e instanceof s.Name)
                switch (e.name) {
                  case "S":
                    this.style = r.AnnotationBorderStyleType.SOLID;
                    break;
                  case "D":
                    this.style = r.AnnotationBorderStyleType.DASHED;
                    break;
                  case "B":
                    this.style = r.AnnotationBorderStyleType.BEVELED;
                    break;
                  case "I":
                    this.style = r.AnnotationBorderStyleType.INSET;
                    break;
                  case "U":
                    this.style = r.AnnotationBorderStyleType.UNDERLINE;
                }
            }
            setDashArray(e, t = !1) {
              if (Array.isArray(e) && e.length > 0) {
                let a = !0,
                  r = !0;
                for (const t of e) {
                  if (!(+t >= 0)) {
                    a = !1;
                    break;
                  }
                  t > 0 && (r = !1);
                }
                if (a && !r) {
                  this.dashArray = e;
                  t && this.setStyle(s.Name.get("D"));
                } else this.width = 0;
              } else e && (this.width = 0);
            }
            setHorizontalCornerRadius(e) {
              Number.isInteger(e) && (this.horizontalCornerRadius = e);
            }
            setVerticalCornerRadius(e) {
              Number.isInteger(e) && (this.verticalCornerRadius = e);
            }
          }
          t.AnnotationBorderStyle = AnnotationBorderStyle;
          class MarkupAnnotation extends Annotation {
            constructor(e) {
              super(e);
              const { dict: t } = e;
              if (t.has("IRT")) {
                const e = t.getRaw("IRT");
                this.data.inReplyTo = e instanceof s.Ref ? e.toString() : null;
                const a = t.get("RT");
                this.data.replyType =
                  a instanceof s.Name ? a.name : r.AnnotationReplyType.REPLY;
              }
              let a = null;
              if (this.data.replyType === r.AnnotationReplyType.GROUP) {
                const e = t.get("IRT");
                this.setTitle(e.get("T"));
                this.data.titleObj = this._title;
                this.setContents(e.get("Contents"));
                this.data.contentsObj = this._contents;
                if (e.has("CreationDate")) {
                  this.setCreationDate(e.get("CreationDate"));
                  this.data.creationDate = this.creationDate;
                } else this.data.creationDate = null;
                if (e.has("M")) {
                  this.setModificationDate(e.get("M"));
                  this.data.modificationDate = this.modificationDate;
                } else this.data.modificationDate = null;
                a = e.getRaw("Popup");
                if (e.has("C")) {
                  this.setColor(e.getArray("C"));
                  this.data.color = this.color;
                } else this.data.color = null;
              } else {
                this.data.titleObj = this._title;
                this.setCreationDate(t.get("CreationDate"));
                this.data.creationDate = this.creationDate;
                a = t.getRaw("Popup");
                t.has("C") || (this.data.color = null);
              }
              this.data.popupRef = a instanceof s.Ref ? a.toString() : null;
              t.has("RC") &&
                (this.data.richText = b.XFAFactory.getRichTextAsHtml(
                  t.get("RC"),
                ));
            }
            setCreationDate(e) {
              this.creationDate = "string" == typeof e ? e : null;
            }
            _setDefaultAppearance({
              xref: e,
              extra: t,
              strokeColor: a,
              fillColor: r,
              blendMode: n,
              strokeAlpha: i,
              fillAlpha: c,
              pointsCallback: l,
            }) {
              let h = Number.MAX_VALUE,
                u = Number.MAX_VALUE,
                d = Number.MIN_VALUE,
                f = Number.MIN_VALUE;
              const g = ["q"];
              t && g.push(t);
              a && g.push(`${a[0]} ${a[1]} ${a[2]} RG`);
              r && g.push(`${r[0]} ${r[1]} ${r[2]} rg`);
              let p = this.data.quadPoints;
              p ||
                (p = [
                  [
                    { x: this.rectangle[0], y: this.rectangle[3] },
                    { x: this.rectangle[2], y: this.rectangle[3] },
                    { x: this.rectangle[0], y: this.rectangle[1] },
                    { x: this.rectangle[2], y: this.rectangle[1] },
                  ],
                ]);
              for (const e of p) {
                const [t, a, r, n] = l(g, e);
                h = Math.min(h, t);
                d = Math.max(d, a);
                u = Math.min(u, r);
                f = Math.max(f, n);
              }
              g.push("Q");
              const m = new s.Dict(e),
                b = new s.Dict(e);
              b.set("Subtype", s.Name.get("Form"));
              const y = new o.StringStream(g.join(" "));
              y.dict = b;
              m.set("Fm0", y);
              const w = new s.Dict(e);
              n && w.set("BM", s.Name.get(n));
              "number" == typeof i && w.set("CA", i);
              "number" == typeof c && w.set("ca", c);
              const S = new s.Dict(e);
              S.set("GS0", w);
              const x = new s.Dict(e);
              x.set("ExtGState", S);
              x.set("XObject", m);
              const C = new s.Dict(e);
              C.set("Resources", x);
              const k = (this.data.rect = [h, u, d, f]);
              C.set("BBox", k);
              this.appearance = new o.StringStream("/GS0 gs /Fm0 Do");
              this.appearance.dict = C;
              this._streams.push(this.appearance, y);
            }
            static async createNewAnnotation(e, t, a, r) {
              const n = (t.ref ||= e.getNewTemporaryRef()),
                i = await this.createNewAppearanceStream(t, e, r),
                s = [];
              let o;
              if (i) {
                const r = e.getNewTemporaryRef();
                o = this.createNewDict(t, e, { apRef: r });
                await (0, m.writeObject)(r, i, s, e);
                a.push({ ref: r, data: s.join("") });
              } else o = this.createNewDict(t, e, {});
              Number.isInteger(t.parentTreeId) &&
                o.set("StructParent", t.parentTreeId);
              s.length = 0;
              await (0, m.writeObject)(n, o, s, e);
              return { ref: n, data: s.join("") };
            }
            static async createNewPrintAnnotation(e, t, a, r) {
              const n = await this.createNewAppearanceStream(a, t, r),
                i = this.createNewDict(a, t, { ap: n }),
                s = new this.prototype.constructor({
                  dict: i,
                  xref: t,
                  annotationGlobals: e,
                  evaluatorOptions: r.evaluatorOptions,
                });
              a.ref && (s.ref = s.refToReplace = a.ref);
              return s;
            }
          }
          t.MarkupAnnotation = MarkupAnnotation;
          class WidgetAnnotation extends Annotation {
            constructor(e) {
              super(e);
              const { dict: t, xref: a, annotationGlobals: i } = e,
                o = this.data;
              this._needAppearances = e.needAppearances;
              o.annotationType = r.AnnotationType.WIDGET;
              void 0 === o.fieldName &&
                (o.fieldName = this._constructFieldName(t));
              void 0 === o.actions &&
                (o.actions = (0, n.collectActions)(
                  a,
                  t,
                  r.AnnotationActionEventType,
                ));
              let c = (0, n.getInheritableProperty)({
                dict: t,
                key: "V",
                getArray: !0,
              });
              o.fieldValue = this._decodeFormValue(c);
              const l = (0, n.getInheritableProperty)({
                dict: t,
                key: "DV",
                getArray: !0,
              });
              o.defaultFieldValue = this._decodeFormValue(l);
              if (void 0 === c && i.xfaDatasets) {
                const e = this._title.str;
                if (e) {
                  this._hasValueFromXFA = !0;
                  o.fieldValue = c = i.xfaDatasets.getValue(e);
                }
              }
              void 0 === c &&
                null !== o.defaultFieldValue &&
                (o.fieldValue = o.defaultFieldValue);
              o.alternativeText = (0, r.stringToPDFString)(t.get("TU") || "");
              this.setDefaultAppearance(e);
              o.hasAppearance ||=
                this._needAppearances &&
                void 0 !== o.fieldValue &&
                null !== o.fieldValue;
              const h = (0, n.getInheritableProperty)({ dict: t, key: "FT" });
              o.fieldType = h instanceof s.Name ? h.name : null;
              const u = (0, n.getInheritableProperty)({ dict: t, key: "DR" }),
                d = i.acroForm.get("DR"),
                f = this.appearance?.dict.get("Resources");
              this._fieldResources = {
                localResources: u,
                acroFormResources: d,
                appearanceResources: f,
                mergedResources: s.Dict.merge({
                  xref: a,
                  dictArray: [u, f, d],
                  mergeSubDicts: !0,
                }),
              };
              o.fieldFlags = (0, n.getInheritableProperty)({
                dict: t,
                key: "Ff",
              });
              (!Number.isInteger(o.fieldFlags) || o.fieldFlags < 0) &&
                (o.fieldFlags = 0);
              o.readOnly = this.hasFieldFlag(r.AnnotationFieldFlag.READONLY);
              o.required = this.hasFieldFlag(r.AnnotationFieldFlag.REQUIRED);
              o.hidden =
                this._hasFlag(o.annotationFlags, r.AnnotationFlag.HIDDEN) ||
                this._hasFlag(o.annotationFlags, r.AnnotationFlag.NOVIEW);
            }
            _decodeFormValue(e) {
              return Array.isArray(e)
                ? e
                    .filter((e) => "string" == typeof e)
                    .map((e) => (0, r.stringToPDFString)(e))
                : e instanceof s.Name
                  ? (0, r.stringToPDFString)(e.name)
                  : "string" == typeof e
                    ? (0, r.stringToPDFString)(e)
                    : null;
            }
            hasFieldFlag(e) {
              return !!(this.data.fieldFlags & e);
            }
            _isViewable(e) {
              return !this._hasFlag(e, r.AnnotationFlag.INVISIBLE);
            }
            mustBeViewed(e, t) {
              return t
                ? this.viewable
                : super.mustBeViewed(e, t) &&
                    !this._hasFlag(this.flags, r.AnnotationFlag.NOVIEW);
            }
            getRotationMatrix(e) {
              let t = e?.get(this.data.id)?.rotation;
              void 0 === t && (t = this.rotation);
              if (0 === t) return r.IDENTITY_MATRIX;
              const a = this.data.rect[2] - this.data.rect[0],
                i = this.data.rect[3] - this.data.rect[1];
              return (0, n.getRotationMatrix)(t, a, i);
            }
            getBorderAndBackgroundAppearances(e) {
              let t = e?.get(this.data.id)?.rotation;
              void 0 === t && (t = this.rotation);
              if (!this.backgroundColor && !this.borderColor) return "";
              const a = this.data.rect[2] - this.data.rect[0],
                r = this.data.rect[3] - this.data.rect[1],
                n =
                  0 === t || 180 === t
                    ? `0 0 ${a} ${r} re`
                    : `0 0 ${r} ${a} re`;
              let s = "";
              this.backgroundColor &&
                (s = `${(0, i.getPdfColor)(this.backgroundColor, !0)} ${n} f `);
              if (this.borderColor) {
                s += `${this.borderStyle.width || 1} w ${(0, i.getPdfColor)(
                  this.borderColor,
                  !1,
                )} ${n} S `;
              }
              return s;
            }
            async getOperatorList(e, t, a, n, i) {
              if (
                n &&
                !(this instanceof SignatureWidgetAnnotation) &&
                !this.data.noHTML &&
                !this.data.hasOwnCanvas
              )
                return {
                  opList: new p.OperatorList(),
                  separateForm: !0,
                  separateCanvas: !1,
                };
              if (!this._hasText) return super.getOperatorList(e, t, a, n, i);
              const s = await this._getAppearance(e, t, a, i);
              if (this.appearance && null === s)
                return super.getOperatorList(e, t, a, n, i);
              const c = new p.OperatorList();
              if (!this._defaultAppearance || null === s)
                return { opList: c, separateForm: !1, separateCanvas: !1 };
              const l = !!(
                  this.data.hasOwnCanvas && a & r.RenderingIntentFlag.DISPLAY
                ),
                h = [
                  0,
                  0,
                  this.data.rect[2] - this.data.rect[0],
                  this.data.rect[3] - this.data.rect[1],
                ],
                u = getTransformMatrix(this.data.rect, h, [1, 0, 0, 1, 0, 0]);
              let d;
              this.oc && (d = await e.parseMarkedContentProps(this.oc, null));
              void 0 !== d && c.addOp(r.OPS.beginMarkedContentProps, ["OC", d]);
              c.addOp(r.OPS.beginAnnotation, [
                this.data.id,
                this.data.rect,
                u,
                this.getRotationMatrix(i),
                l,
              ]);
              const f = new o.StringStream(s);
              await e.getOperatorList({
                stream: f,
                task: t,
                resources: this._fieldResources.mergedResources,
                operatorList: c,
              });
              c.addOp(r.OPS.endAnnotation, []);
              void 0 !== d && c.addOp(r.OPS.endMarkedContent, []);
              return { opList: c, separateForm: !1, separateCanvas: l };
            }
            _getMKDict(e) {
              const t = new s.Dict(null);
              e && t.set("R", e);
              this.borderColor &&
                t.set("BC", getPdfColorArray(this.borderColor));
              this.backgroundColor &&
                t.set("BG", getPdfColorArray(this.backgroundColor));
              return t.size > 0 ? t : null;
            }
            amendSavedDict(e, t) {}
            async save(e, t, a) {
              const i = a?.get(this.data.id);
              let c = i?.value,
                l = i?.rotation;
              if (c === this.data.fieldValue || void 0 === c) {
                if (!this._hasValueFromXFA && void 0 === l) return null;
                c ||= this.data.fieldValue;
              }
              if (
                void 0 === l &&
                !this._hasValueFromXFA &&
                Array.isArray(c) &&
                Array.isArray(this.data.fieldValue) &&
                c.length === this.data.fieldValue.length &&
                c.every((e, t) => e === this.data.fieldValue[t])
              )
                return null;
              void 0 === l && (l = this.rotation);
              let h = null;
              if (!this._needAppearances) {
                h = await this._getAppearance(
                  e,
                  t,
                  r.RenderingIntentFlag.SAVE,
                  a,
                );
                if (null === h) return null;
              }
              let u = !1;
              if (h?.needAppearances) {
                u = !0;
                h = null;
              }
              const { xref: d } = e,
                f = d.fetchIfRef(this.ref);
              if (!(f instanceof s.Dict)) return null;
              const g = new s.Dict(d);
              for (const e of f.getKeys()) "AP" !== e && g.set(e, f.getRaw(e));
              const p = { path: this.data.fieldName, value: c },
                encoder = (e) =>
                  (0, n.isAscii)(e) ? e : (0, n.stringToUTF16String)(e, !0);
              g.set("V", Array.isArray(c) ? c.map(encoder) : encoder(c));
              this.amendSavedDict(a, g);
              const b = this._getMKDict(l);
              b && g.set("MK", b);
              const y = [],
                w = [{ ref: this.ref, data: "", xfa: p, needAppearances: u }];
              if (null !== h) {
                const e = d.getNewTemporaryRef(),
                  t = new s.Dict(d);
                g.set("AP", t);
                t.set("N", e);
                const n = this._getSaveFieldResources(d),
                  i = new o.StringStream(h),
                  c = (i.dict = new s.Dict(d));
                c.set("Subtype", s.Name.get("Form"));
                c.set("Resources", n);
                c.set("BBox", [
                  0,
                  0,
                  this.data.rect[2] - this.data.rect[0],
                  this.data.rect[3] - this.data.rect[1],
                ]);
                const l = this.getRotationMatrix(a);
                l !== r.IDENTITY_MATRIX && c.set("Matrix", l);
                await (0, m.writeObject)(e, i, y, d);
                w.push({
                  ref: e,
                  data: y.join(""),
                  xfa: null,
                  needAppearances: !1,
                });
                y.length = 0;
              }
              g.set("M", `D:${(0, r.getModificationDate)()}`);
              await (0, m.writeObject)(this.ref, g, y, d);
              w[0].data = y.join("");
              return w;
            }
            async _getAppearance(e, t, a, s) {
              if (this.hasFieldFlag(r.AnnotationFieldFlag.PASSWORD))
                return null;
              const o = s?.get(this.data.id);
              let c, l;
              if (o) {
                c = o.formattedValue || o.value;
                l = o.rotation;
              }
              if (
                void 0 === l &&
                void 0 === c &&
                !this._needAppearances &&
                (!this._hasValueFromXFA || this.appearance)
              )
                return null;
              const h = this.getBorderAndBackgroundAppearances(s);
              if (void 0 === c) {
                c = this.data.fieldValue;
                if (!c) return `/Tx BMC q ${h}Q EMC`;
              }
              Array.isArray(c) && 1 === c.length && (c = c[0]);
              (0, r.assert)(
                "string" == typeof c,
                "Expected `value` to be a string.",
              );
              c = c.trim();
              if (this.data.combo) {
                const e = this.data.options.find(
                  ({ exportValue: e }) => c === e,
                );
                c = e?.displayValue || c;
              }
              if ("" === c) return `/Tx BMC q ${h}Q EMC`;
              void 0 === l && (l = this.rotation);
              let u,
                d = -1;
              if (this.data.multiLine) {
                u = c.split(/\r\n?|\n/).map((e) => e.normalize("NFC"));
                d = u.length;
              } else u = [c.replace(/\r\n?|\n/, "").normalize("NFC")];
              let f = this.data.rect[3] - this.data.rect[1],
                g = this.data.rect[2] - this.data.rect[0];
              (90 !== l && 270 !== l) || ([g, f] = [f, g]);
              this._defaultAppearance ||
                (this.data.defaultAppearanceData = (0,
                i.parseDefaultAppearance)(
                  (this._defaultAppearance = "/Helvetica 0 Tf 0 g"),
                ));
              let p,
                m,
                b,
                y = await WidgetAnnotation._getFontData(
                  e,
                  t,
                  this.data.defaultAppearanceData,
                  this._fieldResources.mergedResources,
                );
              const w = [];
              let S = !1;
              for (const e of u) {
                const t = y.encodeString(e);
                t.length > 1 && (S = !0);
                w.push(t.join(""));
              }
              if (S && a & r.RenderingIntentFlag.SAVE)
                return { needAppearances: !0 };
              if (S && this._isOffscreenCanvasSupported) {
                const a = this.data.comb ? "monospace" : "sans-serif",
                  r = new i.FakeUnicodeFont(e.xref, a),
                  s = r.createFontResources(u.join("")),
                  o = s.getRaw("Font");
                if (this._fieldResources.mergedResources.has("Font")) {
                  const e = this._fieldResources.mergedResources.get("Font");
                  for (const t of o.getKeys()) e.set(t, o.getRaw(t));
                } else this._fieldResources.mergedResources.set("Font", o);
                const l = r.fontName.name;
                y = await WidgetAnnotation._getFontData(
                  e,
                  t,
                  { fontName: l, fontSize: 0 },
                  s,
                );
                for (let e = 0, t = w.length; e < t; e++)
                  w[e] = (0, n.stringToUTF16String)(u[e]);
                const h = Object.assign(
                  Object.create(null),
                  this.data.defaultAppearanceData,
                );
                this.data.defaultAppearanceData.fontSize = 0;
                this.data.defaultAppearanceData.fontName = l;
                [p, m, b] = this._computeFontSize(f - 2, g - 4, c, y, d);
                this.data.defaultAppearanceData = h;
              } else {
                this._isOffscreenCanvasSupported ||
                  (0, r.warn)(
                    "_getAppearance: OffscreenCanvas is not supported, annotation may not render correctly.",
                  );
                [p, m, b] = this._computeFontSize(f - 2, g - 4, c, y, d);
              }
              let x = y.descent;
              x = isNaN(x)
                ? r.BASELINE_FACTOR * b
                : Math.max(r.BASELINE_FACTOR * b, Math.abs(x) * m);
              const C = Math.min(Math.floor((f - m) / 2), 1),
                k = this.data.textAlignment;
              if (this.data.multiLine)
                return this._getMultilineAppearance(
                  p,
                  w,
                  y,
                  m,
                  g,
                  f,
                  k,
                  2,
                  C,
                  x,
                  b,
                  s,
                );
              if (this.data.comb)
                return this._getCombAppearance(
                  p,
                  y,
                  w[0],
                  m,
                  g,
                  f,
                  2,
                  C,
                  x,
                  b,
                  s,
                );
              const v = C + x;
              if (0 === k || k > 2)
                return (
                  `/Tx BMC q ${h}BT ` +
                  p +
                  ` 1 0 0 1 ${(0, n.numberToString)(2)} ${(0, n.numberToString)(
                    v,
                  )} Tm (${(0, n.escapeString)(w[0])}) Tj ET Q EMC`
                );
              return (
                `/Tx BMC q ${h}BT ` +
                p +
                ` 1 0 0 1 0 0 Tm ${this._renderText(
                  w[0],
                  y,
                  m,
                  g,
                  k,
                  { shift: 0 },
                  2,
                  v,
                )} ET Q EMC`
              );
            }
            static async _getFontData(e, t, a, r) {
              const n = new p.OperatorList(),
                i = {
                  font: null,
                  clone() {
                    return this;
                  },
                },
                { fontName: o, fontSize: c } = a;
              await e.handleSetFont(
                r,
                [o && s.Name.get(o), c],
                null,
                n,
                t,
                i,
                null,
              );
              return i.font;
            }
            _getTextWidth(e, t) {
              return t.charsToGlyphs(e).reduce((e, t) => e + t.width, 0) / 1e3;
            }
            _computeFontSize(e, t, a, n, s) {
              let { fontSize: o } = this.data.defaultAppearanceData,
                c = (o || 12) * r.LINE_FACTOR,
                l = Math.round(e / c);
              if (!o) {
                const roundWithTwoDigits = (e) => Math.floor(100 * e) / 100;
                if (-1 === s) {
                  const i = this._getTextWidth(a, n);
                  o = roundWithTwoDigits(
                    Math.min(e / r.LINE_FACTOR, i > t ? t / i : 1 / 0),
                  );
                  l = 1;
                } else {
                  const i = a.split(/\r\n?|\n/),
                    h = [];
                  for (const e of i) {
                    const t = n.encodeString(e).join(""),
                      a = n.charsToGlyphs(t),
                      r = n.getCharPositions(t);
                    h.push({ line: t, glyphs: a, positions: r });
                  }
                  const isTooBig = (a) => {
                    let r = 0;
                    for (const i of h) {
                      r += this._splitLine(null, n, a, t, i).length * a;
                      if (r > e) return !0;
                    }
                    return !1;
                  };
                  l = Math.max(l, s);
                  for (;;) {
                    c = e / l;
                    o = roundWithTwoDigits(c / r.LINE_FACTOR);
                    if (!isTooBig(o)) break;
                    l++;
                  }
                }
                const { fontName: h, fontColor: u } =
                  this.data.defaultAppearanceData;
                this._defaultAppearance = (0, i.createDefaultAppearance)({
                  fontSize: o,
                  fontName: h,
                  fontColor: u,
                });
              }
              return [this._defaultAppearance, o, e / l];
            }
            _renderText(e, t, a, r, i, s, o, c) {
              let l;
              if (1 === i) {
                l = (r - this._getTextWidth(e, t) * a) / 2;
              } else if (2 === i) {
                l = r - this._getTextWidth(e, t) * a - o;
              } else l = o;
              const h = (0, n.numberToString)(l - s.shift);
              s.shift = l;
              return `${h} ${(c = (0, n.numberToString)(c))} Td (${(0,
              n.escapeString)(e)}) Tj`;
            }
            _getSaveFieldResources(e) {
              const {
                  localResources: t,
                  appearanceResources: a,
                  acroFormResources: r,
                } = this._fieldResources,
                n = this.data.defaultAppearanceData?.fontName;
              if (!n) return t || s.Dict.empty;
              for (const e of [t, a])
                if (e instanceof s.Dict) {
                  const t = e.get("Font");
                  if (t instanceof s.Dict && t.has(n)) return e;
                }
              if (r instanceof s.Dict) {
                const a = r.get("Font");
                if (a instanceof s.Dict && a.has(n)) {
                  const r = new s.Dict(e);
                  r.set(n, a.getRaw(n));
                  const i = new s.Dict(e);
                  i.set("Font", r);
                  return s.Dict.merge({
                    xref: e,
                    dictArray: [i, t],
                    mergeSubDicts: !0,
                  });
                }
              }
              return t || s.Dict.empty;
            }
            getFieldObject() {
              return null;
            }
          }
          class TextWidgetAnnotation extends WidgetAnnotation {
            constructor(e) {
              super(e);
              this.data.hasOwnCanvas = this.data.readOnly && !this.data.noHTML;
              this._hasText = !0;
              const t = e.dict;
              "string" != typeof this.data.fieldValue &&
                (this.data.fieldValue = "");
              let a = (0, n.getInheritableProperty)({ dict: t, key: "Q" });
              (!Number.isInteger(a) || a < 0 || a > 2) && (a = null);
              this.data.textAlignment = a;
              let i = (0, n.getInheritableProperty)({ dict: t, key: "MaxLen" });
              (!Number.isInteger(i) || i < 0) && (i = 0);
              this.data.maxLen = i;
              this.data.multiLine = this.hasFieldFlag(
                r.AnnotationFieldFlag.MULTILINE,
              );
              this.data.comb =
                this.hasFieldFlag(r.AnnotationFieldFlag.COMB) &&
                !this.hasFieldFlag(r.AnnotationFieldFlag.MULTILINE) &&
                !this.hasFieldFlag(r.AnnotationFieldFlag.PASSWORD) &&
                !this.hasFieldFlag(r.AnnotationFieldFlag.FILESELECT) &&
                0 !== this.data.maxLen;
              this.data.doNotScroll = this.hasFieldFlag(
                r.AnnotationFieldFlag.DONOTSCROLL,
              );
            }
            get hasTextContent() {
              return !!this.appearance && !this._needAppearances;
            }
            _getCombAppearance(e, t, a, r, i, s, o, c, l, h, u) {
              const d = i / this.data.maxLen,
                f = this.getBorderAndBackgroundAppearances(u),
                g = [],
                p = t.getCharPositions(a);
              for (const [e, t] of p)
                g.push(`(${(0, n.escapeString)(a.substring(e, t))}) Tj`);
              const m = g.join(` ${(0, n.numberToString)(d)} 0 Td `);
              return (
                `/Tx BMC q ${f}BT ` +
                e +
                ` 1 0 0 1 ${(0, n.numberToString)(o)} ${(0, n.numberToString)(
                  c + l,
                )} Tm ${m} ET Q EMC`
              );
            }
            _getMultilineAppearance(e, t, a, r, i, s, o, c, l, h, u, d) {
              const f = [],
                g = i - 2 * c,
                p = { shift: 0 };
              for (let e = 0, n = t.length; e < n; e++) {
                const n = t[e],
                  s = this._splitLine(n, a, r, g);
                for (let t = 0, n = s.length; t < n; t++) {
                  const n = s[t],
                    d = 0 === e && 0 === t ? -l - (u - h) : -u;
                  f.push(this._renderText(n, a, r, i, o, p, c, d));
                }
              }
              const m = this.getBorderAndBackgroundAppearances(d),
                b = f.join("\n");
              return (
                `/Tx BMC q ${m}BT ` +
                e +
                ` 1 0 0 1 0 ${(0, n.numberToString)(s)} Tm ${b} ET Q EMC`
              );
            }
            _splitLine(e, t, a, r, n = {}) {
              e = n.line || e;
              const i = n.glyphs || t.charsToGlyphs(e);
              if (i.length <= 1) return [e];
              const s = n.positions || t.getCharPositions(e),
                o = a / 1e3,
                c = [];
              let l = -1,
                h = -1,
                u = -1,
                d = 0,
                f = 0;
              for (let t = 0, a = i.length; t < a; t++) {
                const [a, n] = s[t],
                  g = i[t],
                  p = g.width * o;
                if (" " === g.unicode)
                  if (f + p > r) {
                    c.push(e.substring(d, a));
                    d = a;
                    f = p;
                    l = -1;
                    u = -1;
                  } else {
                    f += p;
                    l = a;
                    h = n;
                    u = t;
                  }
                else if (f + p > r)
                  if (-1 !== l) {
                    c.push(e.substring(d, h));
                    d = h;
                    t = u + 1;
                    l = -1;
                    f = 0;
                  } else {
                    c.push(e.substring(d, a));
                    d = a;
                    f = p;
                  }
                else f += p;
              }
              d < e.length && c.push(e.substring(d, e.length));
              return c;
            }
            getFieldObject() {
              return {
                id: this.data.id,
                value: this.data.fieldValue,
                defaultValue: this.data.defaultFieldValue || "",
                multiline: this.data.multiLine,
                password: this.hasFieldFlag(r.AnnotationFieldFlag.PASSWORD),
                charLimit: this.data.maxLen,
                comb: this.data.comb,
                editable: !this.data.readOnly,
                hidden: this.data.hidden,
                name: this.data.fieldName,
                rect: this.data.rect,
                actions: this.data.actions,
                page: this.data.pageIndex,
                strokeColor: this.data.borderColor,
                fillColor: this.data.backgroundColor,
                rotation: this.rotation,
                type: "text",
              };
            }
          }
          class ButtonWidgetAnnotation extends WidgetAnnotation {
            constructor(e) {
              super(e);
              this.checkedAppearance = null;
              this.uncheckedAppearance = null;
              this.data.checkBox =
                !this.hasFieldFlag(r.AnnotationFieldFlag.RADIO) &&
                !this.hasFieldFlag(r.AnnotationFieldFlag.PUSHBUTTON);
              this.data.radioButton =
                this.hasFieldFlag(r.AnnotationFieldFlag.RADIO) &&
                !this.hasFieldFlag(r.AnnotationFieldFlag.PUSHBUTTON);
              this.data.pushButton = this.hasFieldFlag(
                r.AnnotationFieldFlag.PUSHBUTTON,
              );
              this.data.isTooltipOnly = !1;
              if (this.data.checkBox) this._processCheckBox(e);
              else if (this.data.radioButton) this._processRadioButton(e);
              else if (this.data.pushButton) {
                this.data.hasOwnCanvas = !0;
                this._processPushButton(e);
              } else
                (0, r.warn)("Invalid field flags for button widget annotation");
            }
            async getOperatorList(e, t, a, n, i) {
              if (this.data.pushButton)
                return super.getOperatorList(e, t, a, !1, i);
              let s = null,
                o = null;
              if (i) {
                const e = i.get(this.data.id);
                s = e ? e.value : null;
                o = e ? e.rotation : null;
              }
              if (null === s && this.appearance)
                return super.getOperatorList(e, t, a, n, i);
              null == s &&
                (s = this.data.checkBox
                  ? this.data.fieldValue === this.data.exportValue
                  : this.data.fieldValue === this.data.buttonValue);
              const c = s ? this.checkedAppearance : this.uncheckedAppearance;
              if (c) {
                const s = this.appearance,
                  l = c.dict.getArray("Matrix") || r.IDENTITY_MATRIX;
                o && c.dict.set("Matrix", this.getRotationMatrix(i));
                this.appearance = c;
                const h = super.getOperatorList(e, t, a, n, i);
                this.appearance = s;
                c.dict.set("Matrix", l);
                return h;
              }
              return {
                opList: new p.OperatorList(),
                separateForm: !1,
                separateCanvas: !1,
              };
            }
            async save(e, t, a) {
              return this.data.checkBox
                ? this._saveCheckbox(e, t, a)
                : this.data.radioButton
                  ? this._saveRadioButton(e, t, a)
                  : null;
            }
            async _saveCheckbox(e, t, a) {
              if (!a) return null;
              const n = a.get(this.data.id);
              let i = n?.rotation,
                o = n?.value;
              if (void 0 === i) {
                if (void 0 === o) return null;
                if ((this.data.fieldValue === this.data.exportValue) === o)
                  return null;
              }
              const c = e.xref.fetchIfRef(this.ref);
              if (!(c instanceof s.Dict)) return null;
              void 0 === i && (i = this.rotation);
              void 0 === o &&
                (o = this.data.fieldValue === this.data.exportValue);
              const l = {
                  path: this.data.fieldName,
                  value: o ? this.data.exportValue : "",
                },
                h = s.Name.get(o ? this.data.exportValue : "Off");
              c.set("V", h);
              c.set("AS", h);
              c.set("M", `D:${(0, r.getModificationDate)()}`);
              const u = this._getMKDict(i);
              u && c.set("MK", u);
              const d = [];
              await (0, m.writeObject)(this.ref, c, d, e.xref);
              return [{ ref: this.ref, data: d.join(""), xfa: l }];
            }
            async _saveRadioButton(e, t, a) {
              if (!a) return null;
              const n = a.get(this.data.id);
              let i = n?.rotation,
                o = n?.value;
              if (void 0 === i) {
                if (void 0 === o) return null;
                if ((this.data.fieldValue === this.data.buttonValue) === o)
                  return null;
              }
              const c = e.xref.fetchIfRef(this.ref);
              if (!(c instanceof s.Dict)) return null;
              void 0 === o &&
                (o = this.data.fieldValue === this.data.buttonValue);
              void 0 === i && (i = this.rotation);
              const l = {
                  path: this.data.fieldName,
                  value: o ? this.data.buttonValue : "",
                },
                h = s.Name.get(o ? this.data.buttonValue : "Off"),
                u = [];
              let d = null;
              if (o)
                if (this.parent instanceof s.Ref) {
                  const t = e.xref.fetch(this.parent);
                  t.set("V", h);
                  await (0, m.writeObject)(this.parent, t, u, e.xref);
                  d = u.join("");
                  u.length = 0;
                } else this.parent instanceof s.Dict && this.parent.set("V", h);
              c.set("AS", h);
              c.set("M", `D:${(0, r.getModificationDate)()}`);
              const f = this._getMKDict(i);
              f && c.set("MK", f);
              await (0, m.writeObject)(this.ref, c, u, e.xref);
              const g = [{ ref: this.ref, data: u.join(""), xfa: l }];
              d && g.push({ ref: this.parent, data: d, xfa: null });
              return g;
            }
            _getDefaultCheckedAppearance(e, t) {
              const a = this.data.rect[2] - this.data.rect[0],
                i = this.data.rect[3] - this.data.rect[1],
                c = [0, 0, a, i],
                l = 0.8 * Math.min(a, i);
              let h, u;
              if ("check" === t) {
                h = { width: 0.755 * l, height: 0.705 * l };
                u = "3";
              } else if ("disc" === t) {
                h = { width: 0.791 * l, height: 0.705 * l };
                u = "l";
              } else
                (0, r.unreachable)(
                  `_getDefaultCheckedAppearance - unsupported type: ${t}`,
                );
              const d = `q BT /PdfJsZaDb ${l} Tf 0 g ${(0, n.numberToString)(
                  (a - h.width) / 2,
                )} ${(0, n.numberToString)(
                  (i - h.height) / 2,
                )} Td (${u}) Tj ET Q`,
                f = new s.Dict(e.xref);
              f.set("FormType", 1);
              f.set("Subtype", s.Name.get("Form"));
              f.set("Type", s.Name.get("XObject"));
              f.set("BBox", c);
              f.set("Matrix", [1, 0, 0, 1, 0, 0]);
              f.set("Length", d.length);
              const g = new s.Dict(e.xref),
                p = new s.Dict(e.xref);
              p.set("PdfJsZaDb", this.fallbackFontDict);
              g.set("Font", p);
              f.set("Resources", g);
              this.checkedAppearance = new o.StringStream(d);
              this.checkedAppearance.dict = f;
              this._streams.push(this.checkedAppearance);
            }
            _processCheckBox(e) {
              const t = e.dict.get("AP");
              if (!(t instanceof s.Dict)) return;
              const a = t.get("N");
              if (!(a instanceof s.Dict)) return;
              const r = this._decodeFormValue(e.dict.get("AS"));
              "string" == typeof r && (this.data.fieldValue = r);
              const n =
                  null !== this.data.fieldValue &&
                  "Off" !== this.data.fieldValue
                    ? this.data.fieldValue
                    : "Yes",
                i = a.getKeys();
              if (0 === i.length) i.push("Off", n);
              else if (1 === i.length)
                "Off" === i[0] ? i.push(n) : i.unshift("Off");
              else if (i.includes(n)) {
                i.length = 0;
                i.push("Off", n);
              } else {
                const e = i.find((e) => "Off" !== e);
                i.length = 0;
                i.push("Off", e);
              }
              i.includes(this.data.fieldValue) ||
                (this.data.fieldValue = "Off");
              this.data.exportValue = i[1];
              const o = a.get(this.data.exportValue);
              this.checkedAppearance = o instanceof c.BaseStream ? o : null;
              const l = a.get("Off");
              this.uncheckedAppearance = l instanceof c.BaseStream ? l : null;
              this.checkedAppearance
                ? this._streams.push(this.checkedAppearance)
                : this._getDefaultCheckedAppearance(e, "check");
              this.uncheckedAppearance &&
                this._streams.push(this.uncheckedAppearance);
              this._fallbackFontDict = this.fallbackFontDict;
              null === this.data.defaultFieldValue &&
                (this.data.defaultFieldValue = "Off");
            }
            _processRadioButton(e) {
              this.data.fieldValue = this.data.buttonValue = null;
              const t = e.dict.get("Parent");
              if (t instanceof s.Dict) {
                this.parent = e.dict.getRaw("Parent");
                const a = t.get("V");
                a instanceof s.Name &&
                  (this.data.fieldValue = this._decodeFormValue(a));
              }
              const a = e.dict.get("AP");
              if (!(a instanceof s.Dict)) return;
              const r = a.get("N");
              if (!(r instanceof s.Dict)) return;
              for (const e of r.getKeys())
                if ("Off" !== e) {
                  this.data.buttonValue = this._decodeFormValue(e);
                  break;
                }
              const n = r.get(this.data.buttonValue);
              this.checkedAppearance = n instanceof c.BaseStream ? n : null;
              const i = r.get("Off");
              this.uncheckedAppearance = i instanceof c.BaseStream ? i : null;
              this.checkedAppearance
                ? this._streams.push(this.checkedAppearance)
                : this._getDefaultCheckedAppearance(e, "disc");
              this.uncheckedAppearance &&
                this._streams.push(this.uncheckedAppearance);
              this._fallbackFontDict = this.fallbackFontDict;
              null === this.data.defaultFieldValue &&
                (this.data.defaultFieldValue = "Off");
            }
            _processPushButton(e) {
              const { dict: t, annotationGlobals: a } = e;
              if (t.has("A") || t.has("AA") || this.data.alternativeText) {
                this.data.isTooltipOnly = !t.has("A") && !t.has("AA");
                h.Catalog.parseDestDictionary({
                  destDict: t,
                  resultObj: this.data,
                  docBaseUrl: a.baseUrl,
                  docAttachments: a.attachments,
                });
              } else
                (0, r.warn)(
                  "Push buttons without action dictionaries are not supported",
                );
            }
            getFieldObject() {
              let e,
                t = "button";
              if (this.data.checkBox) {
                t = "checkbox";
                e = this.data.exportValue;
              } else if (this.data.radioButton) {
                t = "radiobutton";
                e = this.data.buttonValue;
              }
              return {
                id: this.data.id,
                value: this.data.fieldValue || "Off",
                defaultValue: this.data.defaultFieldValue,
                exportValues: e,
                editable: !this.data.readOnly,
                name: this.data.fieldName,
                rect: this.data.rect,
                hidden: this.data.hidden,
                actions: this.data.actions,
                page: this.data.pageIndex,
                strokeColor: this.data.borderColor,
                fillColor: this.data.backgroundColor,
                rotation: this.rotation,
                type: t,
              };
            }
            get fallbackFontDict() {
              const e = new s.Dict();
              e.set("BaseFont", s.Name.get("ZapfDingbats"));
              e.set("Type", s.Name.get("FallbackType"));
              e.set("Subtype", s.Name.get("FallbackType"));
              e.set("Encoding", s.Name.get("ZapfDingbatsEncoding"));
              return (0, r.shadow)(this, "fallbackFontDict", e);
            }
          }
          class ChoiceWidgetAnnotation extends WidgetAnnotation {
            constructor(e) {
              super(e);
              const { dict: t, xref: a } = e;
              this.indices = t.getArray("I");
              this.hasIndices =
                Array.isArray(this.indices) && this.indices.length > 0;
              this.data.options = [];
              const i = (0, n.getInheritableProperty)({ dict: t, key: "Opt" });
              if (Array.isArray(i))
                for (let e = 0, t = i.length; e < t; e++) {
                  const t = a.fetchIfRef(i[e]),
                    r = Array.isArray(t);
                  this.data.options[e] = {
                    exportValue: this._decodeFormValue(
                      r ? a.fetchIfRef(t[0]) : t,
                    ),
                    displayValue: this._decodeFormValue(
                      r ? a.fetchIfRef(t[1]) : t,
                    ),
                  };
                }
              if (this.hasIndices) {
                this.data.fieldValue = [];
                const e = this.data.options.length;
                for (const t of this.indices)
                  Number.isInteger(t) &&
                    t >= 0 &&
                    t < e &&
                    this.data.fieldValue.push(this.data.options[t].exportValue);
              } else
                "string" == typeof this.data.fieldValue
                  ? (this.data.fieldValue = [this.data.fieldValue])
                  : this.data.fieldValue || (this.data.fieldValue = []);
              this.data.combo = this.hasFieldFlag(r.AnnotationFieldFlag.COMBO);
              this.data.multiSelect = this.hasFieldFlag(
                r.AnnotationFieldFlag.MULTISELECT,
              );
              this._hasText = !0;
            }
            getFieldObject() {
              const e = this.data.combo ? "combobox" : "listbox",
                t =
                  this.data.fieldValue.length > 0
                    ? this.data.fieldValue[0]
                    : null;
              return {
                id: this.data.id,
                value: t,
                defaultValue: this.data.defaultFieldValue,
                editable: !this.data.readOnly,
                name: this.data.fieldName,
                rect: this.data.rect,
                numItems: this.data.fieldValue.length,
                multipleSelection: this.data.multiSelect,
                hidden: this.data.hidden,
                actions: this.data.actions,
                items: this.data.options,
                page: this.data.pageIndex,
                strokeColor: this.data.borderColor,
                fillColor: this.data.backgroundColor,
                rotation: this.rotation,
                type: e,
              };
            }
            amendSavedDict(e, t) {
              if (!this.hasIndices) return;
              let a = e?.get(this.data.id)?.value;
              Array.isArray(a) || (a = [a]);
              const r = [],
                { options: n } = this.data;
              for (let e = 0, t = 0, i = n.length; e < i; e++)
                if (n[e].exportValue === a[t]) {
                  r.push(e);
                  t += 1;
                }
              t.set("I", r);
            }
            async _getAppearance(e, t, a, n) {
              if (this.data.combo) return super._getAppearance(e, t, a, n);
              let s, o;
              const c = n?.get(this.data.id);
              if (c) {
                o = c.rotation;
                s = c.value;
              }
              if (void 0 === o && void 0 === s && !this._needAppearances)
                return null;
              void 0 === s
                ? (s = this.data.fieldValue)
                : Array.isArray(s) || (s = [s]);
              let l = this.data.rect[3] - this.data.rect[1],
                h = this.data.rect[2] - this.data.rect[0];
              (90 !== o && 270 !== o) || ([h, l] = [l, h]);
              const u = this.data.options.length,
                d = [];
              for (let e = 0; e < u; e++) {
                const { exportValue: t } = this.data.options[e];
                s.includes(t) && d.push(e);
              }
              this._defaultAppearance ||
                (this.data.defaultAppearanceData = (0,
                i.parseDefaultAppearance)(
                  (this._defaultAppearance = "/Helvetica 0 Tf 0 g"),
                ));
              const f = await WidgetAnnotation._getFontData(
                e,
                t,
                this.data.defaultAppearanceData,
                this._fieldResources.mergedResources,
              );
              let g,
                { fontSize: p } = this.data.defaultAppearanceData;
              if (p) g = this._defaultAppearance;
              else {
                const e = (l - 1) / u;
                let t,
                  a = -1;
                for (const { displayValue: e } of this.data.options) {
                  const r = this._getTextWidth(e, f);
                  if (r > a) {
                    a = r;
                    t = e;
                  }
                }
                [g, p] = this._computeFontSize(e, h - 4, t, f, -1);
              }
              const m = p * r.LINE_FACTOR,
                b = (m - p) / 2,
                y = Math.floor(l / m);
              let w = 0;
              if (d.length > 0) {
                const e = Math.min(...d),
                  t = Math.max(...d);
                w = Math.max(0, t - y + 1);
                w > e && (w = e);
              }
              const S = Math.min(w + y + 1, u),
                x = ["/Tx BMC q", `1 1 ${h} ${l} re W n`];
              if (d.length) {
                x.push("0.600006 0.756866 0.854904 rg");
                for (const e of d)
                  w <= e &&
                    e < S &&
                    x.push(`1 ${l - (e - w + 1) * m} ${h} ${m} re f`);
              }
              x.push("BT", g, `1 0 0 1 0 ${l} Tm`);
              const C = { shift: 0 };
              for (let e = w; e < S; e++) {
                const { displayValue: t } = this.data.options[e],
                  a = e === w ? b : 0;
                x.push(this._renderText(t, f, p, h, 0, C, 2, -m + a));
              }
              x.push("ET Q EMC");
              return x.join("\n");
            }
          }
          class SignatureWidgetAnnotation extends WidgetAnnotation {
            constructor(e) {
              super(e);
              this.data.fieldValue = null;
              this.data.hasOwnCanvas = this.data.noRotate;
            }
            getFieldObject() {
              return {
                id: this.data.id,
                value: null,
                page: this.data.pageIndex,
                type: "signature",
              };
            }
          }
          class TextAnnotation extends MarkupAnnotation {
            constructor(e) {
              super(e);
              this.data.noRotate = !0;
              this.data.hasOwnCanvas = this.data.noRotate;
              const { dict: t } = e;
              this.data.annotationType = r.AnnotationType.TEXT;
              if (this.data.hasAppearance) this.data.name = "NoIcon";
              else {
                this.data.rect[1] = this.data.rect[3] - 22;
                this.data.rect[2] = this.data.rect[0] + 22;
                this.data.name = t.has("Name") ? t.get("Name").name : "Note";
              }
              if (t.has("State")) {
                this.data.state = t.get("State") || null;
                this.data.stateModel = t.get("StateModel") || null;
              } else {
                this.data.state = null;
                this.data.stateModel = null;
              }
            }
          }
          class LinkAnnotation extends Annotation {
            constructor(e) {
              super(e);
              const { dict: t, annotationGlobals: a } = e;
              this.data.annotationType = r.AnnotationType.LINK;
              const n = getQuadPoints(t, this.rectangle);
              n && (this.data.quadPoints = n);
              this.data.borderColor ||= this.data.color;
              h.Catalog.parseDestDictionary({
                destDict: t,
                resultObj: this.data,
                docBaseUrl: a.baseUrl,
                docAttachments: a.attachments,
              });
            }
          }
          class PopupAnnotation extends Annotation {
            constructor(e) {
              super(e);
              const { dict: t } = e;
              this.data.annotationType = r.AnnotationType.POPUP;
              (this.data.rect[0] !== this.data.rect[2] &&
                this.data.rect[1] !== this.data.rect[3]) ||
                (this.data.rect = null);
              let a = t.get("Parent");
              if (!a) {
                (0, r.warn)(
                  "Popup annotation has a missing or invalid parent annotation.",
                );
                return;
              }
              const n = a.getArray("Rect");
              this.data.parentRect =
                Array.isArray(n) && 4 === n.length
                  ? r.Util.normalizeRect(n)
                  : null;
              const i = a.get("RT");
              (0, s.isName)(i, r.AnnotationReplyType.GROUP) &&
                (a = a.get("IRT"));
              if (a.has("M")) {
                this.setModificationDate(a.get("M"));
                this.data.modificationDate = this.modificationDate;
              } else this.data.modificationDate = null;
              if (a.has("C")) {
                this.setColor(a.getArray("C"));
                this.data.color = this.color;
              } else this.data.color = null;
              if (!this.viewable) {
                const e = a.get("F");
                this._isViewable(e) && this.setFlags(e);
              }
              this.setTitle(a.get("T"));
              this.data.titleObj = this._title;
              this.setContents(a.get("Contents"));
              this.data.contentsObj = this._contents;
              a.has("RC") &&
                (this.data.richText = b.XFAFactory.getRichTextAsHtml(
                  a.get("RC"),
                ));
              this.data.open = !!t.get("Open");
            }
          }
          t.PopupAnnotation = PopupAnnotation;
          class FreeTextAnnotation extends MarkupAnnotation {
            constructor(e) {
              super(e);
              this.data.hasOwnCanvas = !0;
              const { evaluatorOptions: t, xref: a } = e;
              this.data.annotationType = r.AnnotationType.FREETEXT;
              this.setDefaultAppearance(e);
              if (this.appearance) {
                const { fontColor: e, fontSize: r } = (0,
                i.parseAppearanceStream)(this.appearance, t, a);
                this.data.defaultAppearanceData.fontColor = e;
                this.data.defaultAppearanceData.fontSize = r || 10;
              } else if (this._isOffscreenCanvasSupported) {
                const t = e.dict.get("CA"),
                  r = new i.FakeUnicodeFont(a, "sans-serif");
                this.data.defaultAppearanceData.fontSize ||= 10;
                const { fontColor: n, fontSize: s } =
                  this.data.defaultAppearanceData;
                this.appearance = r.createAppearance(
                  this._contents.str,
                  this.rectangle,
                  this.rotation,
                  s,
                  n,
                  t,
                );
                this._streams.push(
                  this.appearance,
                  i.FakeUnicodeFont.toUnicodeStream,
                );
              } else
                (0, r.warn)(
                  "FreeTextAnnotation: OffscreenCanvas is not supported, annotation may not render correctly.",
                );
            }
            get hasTextContent() {
              return !!this.appearance;
            }
            static createNewDict(e, t, { apRef: a, ap: o }) {
              const {
                  color: c,
                  fontSize: l,
                  rect: h,
                  rotation: u,
                  user: d,
                  value: f,
                } = e,
                g = new s.Dict(t);
              g.set("Type", s.Name.get("Annot"));
              g.set("Subtype", s.Name.get("FreeText"));
              g.set("CreationDate", `D:${(0, r.getModificationDate)()}`);
              g.set("Rect", h);
              const p = `/Helv ${l} Tf ${(0, i.getPdfColor)(c, !0)}`;
              g.set("DA", p);
              g.set(
                "Contents",
                (0, n.isAscii)(f) ? f : (0, n.stringToUTF16String)(f, !0),
              );
              g.set("F", 4);
              g.set("Border", [0, 0, 0]);
              g.set("Rotate", u);
              d &&
                g.set(
                  "T",
                  (0, n.isAscii)(d) ? d : (0, n.stringToUTF16String)(d, !0),
                );
              if (a || o) {
                const e = new s.Dict(t);
                g.set("AP", e);
                a ? e.set("N", a) : e.set("N", o);
              }
              return g;
            }
            static async createNewAppearanceStream(e, t, a) {
              const { baseFontRef: c, evaluator: l, task: h } = a,
                { color: u, fontSize: d, rect: f, rotation: g, value: p } = e,
                m = new s.Dict(t),
                b = new s.Dict(t);
              if (c) b.set("Helv", c);
              else {
                const e = new s.Dict(t);
                e.set("BaseFont", s.Name.get("Helvetica"));
                e.set("Type", s.Name.get("Font"));
                e.set("Subtype", s.Name.get("Type1"));
                e.set("Encoding", s.Name.get("WinAnsiEncoding"));
                b.set("Helv", e);
              }
              m.set("Font", b);
              const y = await WidgetAnnotation._getFontData(
                  l,
                  h,
                  { fontName: "Helv", fontSize: d },
                  m,
                ),
                [w, S, x, C] = f;
              let k = x - w,
                v = C - S;
              g % 180 != 0 && ([k, v] = [v, k]);
              const F = p.split("\n"),
                O = d / 1e3;
              let T = -1 / 0;
              const M = [];
              for (let e of F) {
                const t = y.encodeString(e);
                if (t.length > 1) return null;
                e = t.join("");
                M.push(e);
                let a = 0;
                const r = y.charsToGlyphs(e);
                for (const e of r) a += e.width * O;
                T = Math.max(T, a);
              }
              let D = 1;
              T > k && (D = k / T);
              let E = 1;
              const N = r.LINE_FACTOR * d,
                R = (r.LINE_FACTOR - r.LINE_DESCENT_FACTOR) * d,
                L = N * F.length;
              L > v && (E = v / L);
              const $ = d * Math.min(D, E);
              let _, j, U;
              switch (g) {
                case 0:
                  U = [1, 0, 0, 1];
                  j = [f[0], f[1], k, v];
                  _ = [f[0], f[3] - R];
                  break;
                case 90:
                  U = [0, 1, -1, 0];
                  j = [f[1], -f[2], k, v];
                  _ = [f[1], -f[0] - R];
                  break;
                case 180:
                  U = [-1, 0, 0, -1];
                  j = [-f[2], -f[3], k, v];
                  _ = [-f[2], -f[1] - R];
                  break;
                case 270:
                  U = [0, -1, 1, 0];
                  j = [-f[3], f[0], k, v];
                  _ = [-f[3], f[2] - R];
              }
              const X = [
                "q",
                `${U.join(" ")} 0 0 cm`,
                `${j.join(" ")} re W n`,
                "BT",
                `${(0, i.getPdfColor)(u, !0)}`,
                `0 Tc /Helv ${(0, n.numberToString)($)} Tf`,
              ];
              X.push(`${_.join(" ")} Td (${(0, n.escapeString)(M[0])}) Tj`);
              const H = (0, n.numberToString)(N);
              for (let e = 1, t = M.length; e < t; e++) {
                const t = M[e];
                X.push(`0 -${H} Td (${(0, n.escapeString)(t)}) Tj`);
              }
              X.push("ET", "Q");
              const q = X.join("\n"),
                z = new s.Dict(t);
              z.set("FormType", 1);
              z.set("Subtype", s.Name.get("Form"));
              z.set("Type", s.Name.get("XObject"));
              z.set("BBox", f);
              z.set("Resources", m);
              z.set("Matrix", [1, 0, 0, 1, -f[0], -f[1]]);
              const W = new o.StringStream(q);
              W.dict = z;
              return W;
            }
          }
          class LineAnnotation extends MarkupAnnotation {
            constructor(e) {
              super(e);
              const { dict: t, xref: a } = e;
              this.data.annotationType = r.AnnotationType.LINE;
              this.data.hasOwnCanvas = this.data.noRotate;
              const n = t.getArray("L");
              this.data.lineCoordinates = r.Util.normalizeRect(n);
              this.setLineEndings(t.getArray("LE"));
              this.data.lineEndings = this.lineEndings;
              if (!this.appearance) {
                const e = this.color ? getPdfColorArray(this.color) : [0, 0, 0],
                  i = t.get("CA"),
                  s = getRgbColor(t.getArray("IC"), null),
                  o = s ? getPdfColorArray(s) : null,
                  c = o ? i : null,
                  l = this.borderStyle.width || 1,
                  h = 2 * l,
                  u = [
                    this.data.lineCoordinates[0] - h,
                    this.data.lineCoordinates[1] - h,
                    this.data.lineCoordinates[2] + h,
                    this.data.lineCoordinates[3] + h,
                  ];
                r.Util.intersect(this.rectangle, u) || (this.rectangle = u);
                this._setDefaultAppearance({
                  xref: a,
                  extra: `${l} w`,
                  strokeColor: e,
                  fillColor: o,
                  strokeAlpha: i,
                  fillAlpha: c,
                  pointsCallback: (e, t) => {
                    e.push(`${n[0]} ${n[1]} m`, `${n[2]} ${n[3]} l`, "S");
                    return [t[0].x - l, t[1].x + l, t[3].y - l, t[1].y + l];
                  },
                });
              }
            }
          }
          class SquareAnnotation extends MarkupAnnotation {
            constructor(e) {
              super(e);
              const { dict: t, xref: a } = e;
              this.data.annotationType = r.AnnotationType.SQUARE;
              this.data.hasOwnCanvas = this.data.noRotate;
              if (!this.appearance) {
                const e = this.color ? getPdfColorArray(this.color) : [0, 0, 0],
                  r = t.get("CA"),
                  n = getRgbColor(t.getArray("IC"), null),
                  i = n ? getPdfColorArray(n) : null,
                  s = i ? r : null;
                if (0 === this.borderStyle.width && !i) return;
                this._setDefaultAppearance({
                  xref: a,
                  extra: `${this.borderStyle.width} w`,
                  strokeColor: e,
                  fillColor: i,
                  strokeAlpha: r,
                  fillAlpha: s,
                  pointsCallback: (e, t) => {
                    const a = t[2].x + this.borderStyle.width / 2,
                      r = t[2].y + this.borderStyle.width / 2,
                      n = t[3].x - t[2].x - this.borderStyle.width,
                      s = t[1].y - t[3].y - this.borderStyle.width;
                    e.push(`${a} ${r} ${n} ${s} re`);
                    i ? e.push("B") : e.push("S");
                    return [t[0].x, t[1].x, t[3].y, t[1].y];
                  },
                });
              }
            }
          }
          class CircleAnnotation extends MarkupAnnotation {
            constructor(e) {
              super(e);
              const { dict: t, xref: a } = e;
              this.data.annotationType = r.AnnotationType.CIRCLE;
              if (!this.appearance) {
                const e = this.color ? getPdfColorArray(this.color) : [0, 0, 0],
                  r = t.get("CA"),
                  n = getRgbColor(t.getArray("IC"), null),
                  i = n ? getPdfColorArray(n) : null,
                  s = i ? r : null;
                if (0 === this.borderStyle.width && !i) return;
                const o = (4 / 3) * Math.tan(Math.PI / 8);
                this._setDefaultAppearance({
                  xref: a,
                  extra: `${this.borderStyle.width} w`,
                  strokeColor: e,
                  fillColor: i,
                  strokeAlpha: r,
                  fillAlpha: s,
                  pointsCallback: (e, t) => {
                    const a = t[0].x + this.borderStyle.width / 2,
                      r = t[0].y - this.borderStyle.width / 2,
                      n = t[3].x - this.borderStyle.width / 2,
                      s = t[3].y + this.borderStyle.width / 2,
                      c = a + (n - a) / 2,
                      l = r + (s - r) / 2,
                      h = ((n - a) / 2) * o,
                      u = ((s - r) / 2) * o;
                    e.push(
                      `${c} ${s} m`,
                      `${c + h} ${s} ${n} ${l + u} ${n} ${l} c`,
                      `${n} ${l - u} ${c + h} ${r} ${c} ${r} c`,
                      `${c - h} ${r} ${a} ${l - u} ${a} ${l} c`,
                      `${a} ${l + u} ${c - h} ${s} ${c} ${s} c`,
                      "h",
                    );
                    i ? e.push("B") : e.push("S");
                    return [t[0].x, t[1].x, t[3].y, t[1].y];
                  },
                });
              }
            }
          }
          class PolylineAnnotation extends MarkupAnnotation {
            constructor(e) {
              super(e);
              const { dict: t, xref: a } = e;
              this.data.annotationType = r.AnnotationType.POLYLINE;
              this.data.hasOwnCanvas = this.data.noRotate;
              this.data.vertices = [];
              if (!(this instanceof PolygonAnnotation)) {
                this.setLineEndings(t.getArray("LE"));
                this.data.lineEndings = this.lineEndings;
              }
              const n = t.getArray("Vertices");
              if (Array.isArray(n)) {
                for (let e = 0, t = n.length; e < t; e += 2)
                  this.data.vertices.push({ x: n[e], y: n[e + 1] });
                if (!this.appearance) {
                  const e = this.color
                      ? getPdfColorArray(this.color)
                      : [0, 0, 0],
                    n = t.get("CA"),
                    i = this.borderStyle.width || 1,
                    s = 2 * i,
                    o = [1 / 0, 1 / 0, -1 / 0, -1 / 0];
                  for (const e of this.data.vertices) {
                    o[0] = Math.min(o[0], e.x - s);
                    o[1] = Math.min(o[1], e.y - s);
                    o[2] = Math.max(o[2], e.x + s);
                    o[3] = Math.max(o[3], e.y + s);
                  }
                  r.Util.intersect(this.rectangle, o) || (this.rectangle = o);
                  this._setDefaultAppearance({
                    xref: a,
                    extra: `${i} w`,
                    strokeColor: e,
                    strokeAlpha: n,
                    pointsCallback: (e, t) => {
                      const a = this.data.vertices;
                      for (let t = 0, r = a.length; t < r; t++)
                        e.push(`${a[t].x} ${a[t].y} ${0 === t ? "m" : "l"}`);
                      e.push("S");
                      return [t[0].x, t[1].x, t[3].y, t[1].y];
                    },
                  });
                }
              }
            }
          }
          class PolygonAnnotation extends PolylineAnnotation {
            constructor(e) {
              super(e);
              this.data.annotationType = r.AnnotationType.POLYGON;
            }
          }
          class CaretAnnotation extends MarkupAnnotation {
            constructor(e) {
              super(e);
              this.data.annotationType = r.AnnotationType.CARET;
            }
          }
          class InkAnnotation extends MarkupAnnotation {
            constructor(e) {
              super(e);
              this.data.hasOwnCanvas = this.data.noRotate;
              const { dict: t, xref: a } = e;
              this.data.annotationType = r.AnnotationType.INK;
              this.data.inkLists = [];
              const n = t.getArray("InkList");
              if (Array.isArray(n)) {
                for (let e = 0, t = n.length; e < t; ++e) {
                  this.data.inkLists.push([]);
                  for (let t = 0, r = n[e].length; t < r; t += 2)
                    this.data.inkLists[e].push({
                      x: a.fetchIfRef(n[e][t]),
                      y: a.fetchIfRef(n[e][t + 1]),
                    });
                }
                if (!this.appearance) {
                  const e = this.color
                      ? getPdfColorArray(this.color)
                      : [0, 0, 0],
                    n = t.get("CA"),
                    i = this.borderStyle.width || 1,
                    s = 2 * i,
                    o = [1 / 0, 1 / 0, -1 / 0, -1 / 0];
                  for (const e of this.data.inkLists)
                    for (const t of e) {
                      o[0] = Math.min(o[0], t.x - s);
                      o[1] = Math.min(o[1], t.y - s);
                      o[2] = Math.max(o[2], t.x + s);
                      o[3] = Math.max(o[3], t.y + s);
                    }
                  r.Util.intersect(this.rectangle, o) || (this.rectangle = o);
                  this._setDefaultAppearance({
                    xref: a,
                    extra: `${i} w`,
                    strokeColor: e,
                    strokeAlpha: n,
                    pointsCallback: (e, t) => {
                      for (const t of this.data.inkLists) {
                        for (let a = 0, r = t.length; a < r; a++)
                          e.push(`${t[a].x} ${t[a].y} ${0 === a ? "m" : "l"}`);
                        e.push("S");
                      }
                      return [t[0].x, t[1].x, t[3].y, t[1].y];
                    },
                  });
                }
              }
            }
            static createNewDict(e, t, { apRef: a, ap: n }) {
              const {
                  color: i,
                  opacity: o,
                  paths: c,
                  rect: l,
                  rotation: h,
                  thickness: u,
                } = e,
                d = new s.Dict(t);
              d.set("Type", s.Name.get("Annot"));
              d.set("Subtype", s.Name.get("Ink"));
              d.set("CreationDate", `D:${(0, r.getModificationDate)()}`);
              d.set("Rect", l);
              d.set(
                "InkList",
                c.map((e) => e.points),
              );
              d.set("F", 4);
              d.set("Rotate", h);
              const f = new s.Dict(t);
              d.set("BS", f);
              f.set("W", u);
              d.set(
                "C",
                Array.from(i, (e) => e / 255),
              );
              d.set("CA", o);
              const g = new s.Dict(t);
              d.set("AP", g);
              a ? g.set("N", a) : g.set("N", n);
              return d;
            }
            static async createNewAppearanceStream(e, t, a) {
              const {
                  color: r,
                  rect: c,
                  paths: l,
                  thickness: h,
                  opacity: u,
                } = e,
                d = [`${h} w 1 J 1 j`, `${(0, i.getPdfColor)(r, !1)}`];
              1 !== u && d.push("/R0 gs");
              const f = [];
              for (const { bezier: e } of l) {
                f.length = 0;
                f.push(
                  `${(0, n.numberToString)(e[0])} ${(0, n.numberToString)(
                    e[1],
                  )} m`,
                );
                for (let t = 2, a = e.length; t < a; t += 6) {
                  const a = e
                    .slice(t, t + 6)
                    .map(n.numberToString)
                    .join(" ");
                  f.push(`${a} c`);
                }
                f.push("S");
                d.push(f.join("\n"));
              }
              const g = d.join("\n"),
                p = new s.Dict(t);
              p.set("FormType", 1);
              p.set("Subtype", s.Name.get("Form"));
              p.set("Type", s.Name.get("XObject"));
              p.set("BBox", c);
              p.set("Length", g.length);
              if (1 !== u) {
                const e = new s.Dict(t),
                  a = new s.Dict(t),
                  r = new s.Dict(t);
                r.set("CA", u);
                r.set("Type", s.Name.get("ExtGState"));
                a.set("R0", r);
                e.set("ExtGState", a);
                p.set("Resources", e);
              }
              const m = new o.StringStream(g);
              m.dict = p;
              return m;
            }
          }
          class HighlightAnnotation extends MarkupAnnotation {
            constructor(e) {
              super(e);
              const { dict: t, xref: a } = e;
              this.data.annotationType = r.AnnotationType.HIGHLIGHT;
              if ((this.data.quadPoints = getQuadPoints(t, null))) {
                const e = this.appearance?.dict.get("Resources");
                if (!this.appearance || !e?.has("ExtGState")) {
                  this.appearance &&
                    (0, r.warn)(
                      "HighlightAnnotation - ignoring built-in appearance stream.",
                    );
                  const e = this.color
                      ? getPdfColorArray(this.color)
                      : [1, 1, 0],
                    n = t.get("CA");
                  this._setDefaultAppearance({
                    xref: a,
                    fillColor: e,
                    blendMode: "Multiply",
                    fillAlpha: n,
                    pointsCallback: (e, t) => {
                      e.push(
                        `${t[0].x} ${t[0].y} m`,
                        `${t[1].x} ${t[1].y} l`,
                        `${t[3].x} ${t[3].y} l`,
                        `${t[2].x} ${t[2].y} l`,
                        "f",
                      );
                      return [t[0].x, t[1].x, t[3].y, t[1].y];
                    },
                  });
                }
              } else this.data.popupRef = null;
            }
          }
          class UnderlineAnnotation extends MarkupAnnotation {
            constructor(e) {
              super(e);
              const { dict: t, xref: a } = e;
              this.data.annotationType = r.AnnotationType.UNDERLINE;
              if ((this.data.quadPoints = getQuadPoints(t, null))) {
                if (!this.appearance) {
                  const e = this.color
                      ? getPdfColorArray(this.color)
                      : [0, 0, 0],
                    r = t.get("CA");
                  this._setDefaultAppearance({
                    xref: a,
                    extra: "[] 0 d 0.571 w",
                    strokeColor: e,
                    strokeAlpha: r,
                    pointsCallback: (e, t) => {
                      e.push(
                        `${t[2].x} ${t[2].y + 1.3} m`,
                        `${t[3].x} ${t[3].y + 1.3} l`,
                        "S",
                      );
                      return [t[0].x, t[1].x, t[3].y, t[1].y];
                    },
                  });
                }
              } else this.data.popupRef = null;
            }
          }
          class SquigglyAnnotation extends MarkupAnnotation {
            constructor(e) {
              super(e);
              const { dict: t, xref: a } = e;
              this.data.annotationType = r.AnnotationType.SQUIGGLY;
              if ((this.data.quadPoints = getQuadPoints(t, null))) {
                if (!this.appearance) {
                  const e = this.color
                      ? getPdfColorArray(this.color)
                      : [0, 0, 0],
                    r = t.get("CA");
                  this._setDefaultAppearance({
                    xref: a,
                    extra: "[] 0 d 1 w",
                    strokeColor: e,
                    strokeAlpha: r,
                    pointsCallback: (e, t) => {
                      const a = (t[0].y - t[2].y) / 6;
                      let r = a,
                        n = t[2].x;
                      const i = t[2].y,
                        s = t[3].x;
                      e.push(`${n} ${i + r} m`);
                      do {
                        n += 2;
                        r = 0 === r ? a : 0;
                        e.push(`${n} ${i + r} l`);
                      } while (n < s);
                      e.push("S");
                      return [t[2].x, s, i - 2 * a, i + 2 * a];
                    },
                  });
                }
              } else this.data.popupRef = null;
            }
          }
          class StrikeOutAnnotation extends MarkupAnnotation {
            constructor(e) {
              super(e);
              const { dict: t, xref: a } = e;
              this.data.annotationType = r.AnnotationType.STRIKEOUT;
              if ((this.data.quadPoints = getQuadPoints(t, null))) {
                if (!this.appearance) {
                  const e = this.color
                      ? getPdfColorArray(this.color)
                      : [0, 0, 0],
                    r = t.get("CA");
                  this._setDefaultAppearance({
                    xref: a,
                    extra: "[] 0 d 1 w",
                    strokeColor: e,
                    strokeAlpha: r,
                    pointsCallback: (e, t) => {
                      e.push(
                        (t[0].x + t[2].x) / 2 +
                          " " +
                          (t[0].y + t[2].y) / 2 +
                          " m",
                        (t[1].x + t[3].x) / 2 +
                          " " +
                          (t[1].y + t[3].y) / 2 +
                          " l",
                        "S",
                      );
                      return [t[0].x, t[1].x, t[3].y, t[1].y];
                    },
                  });
                }
              } else this.data.popupRef = null;
            }
          }
          class StampAnnotation extends MarkupAnnotation {
            constructor(e) {
              super(e);
              this.data.annotationType = r.AnnotationType.STAMP;
              this.data.hasOwnCanvas = this.data.noRotate;
            }
            static async createImage(e, t) {
              const { width: a, height: n } = e,
                i = new OffscreenCanvas(a, n),
                c = i.getContext("2d", { alpha: !0 });
              c.drawImage(e, 0, 0);
              const l = c.getImageData(0, 0, a, n).data,
                h = new Uint32Array(l.buffer),
                u = h.some(
                  r.FeatureTest.isLittleEndian
                    ? (e) => e >>> 24 != 255
                    : (e) => 255 != (255 & e),
                );
              if (u) {
                c.fillStyle = "white";
                c.fillRect(0, 0, a, n);
                c.drawImage(e, 0, 0);
              }
              const d = i
                  .convertToBlob({ type: "image/jpeg", quality: 1 })
                  .then((e) => e.arrayBuffer()),
                f = s.Name.get("XObject"),
                g = s.Name.get("Image"),
                p = new s.Dict(t);
              p.set("Type", f);
              p.set("Subtype", g);
              p.set("BitsPerComponent", 8);
              p.set("ColorSpace", s.Name.get("DeviceRGB"));
              p.set("Filter", s.Name.get("DCTDecode"));
              p.set("BBox", [0, 0, a, n]);
              p.set("Width", a);
              p.set("Height", n);
              let m = null;
              if (u) {
                const e = new Uint8Array(h.length);
                if (r.FeatureTest.isLittleEndian)
                  for (let t = 0, a = h.length; t < a; t++) e[t] = h[t] >>> 24;
                else
                  for (let t = 0, a = h.length; t < a; t++) e[t] = 255 & h[t];
                const i = new s.Dict(t);
                i.set("Type", f);
                i.set("Subtype", g);
                i.set("BitsPerComponent", 8);
                i.set("ColorSpace", s.Name.get("DeviceGray"));
                i.set("Width", a);
                i.set("Height", n);
                m = new o.Stream(e, 0, 0, i);
              }
              return {
                imageStream: new o.Stream(await d, 0, 0, p),
                smaskStream: m,
                width: a,
                height: n,
              };
            }
            static createNewDict(e, t, { apRef: a, ap: i }) {
              const { rect: o, rotation: c, user: l } = e,
                h = new s.Dict(t);
              h.set("Type", s.Name.get("Annot"));
              h.set("Subtype", s.Name.get("Stamp"));
              h.set("CreationDate", `D:${(0, r.getModificationDate)()}`);
              h.set("Rect", o);
              h.set("F", 4);
              h.set("Border", [0, 0, 0]);
              h.set("Rotate", c);
              l &&
                h.set(
                  "T",
                  (0, n.isAscii)(l) ? l : (0, n.stringToUTF16String)(l, !0),
                );
              if (a || i) {
                const e = new s.Dict(t);
                h.set("AP", e);
                a ? e.set("N", a) : e.set("N", i);
              }
              return h;
            }
            static async createNewAppearanceStream(e, t, a) {
              const { rotation: r } = e,
                { imageRef: i, width: c, height: l } = a.image,
                h = new s.Dict(t),
                u = new s.Dict(t);
              h.set("XObject", u);
              u.set("Im0", i);
              const d = `q ${c} 0 0 ${l} 0 0 cm /Im0 Do Q`,
                f = new s.Dict(t);
              f.set("FormType", 1);
              f.set("Subtype", s.Name.get("Form"));
              f.set("Type", s.Name.get("XObject"));
              f.set("BBox", [0, 0, c, l]);
              f.set("Resources", h);
              if (r) {
                const e = (0, n.getRotationMatrix)(r, c, l);
                f.set("Matrix", e);
              }
              const g = new o.StringStream(d);
              g.dict = f;
              return g;
            }
          }
          class FileAttachmentAnnotation extends MarkupAnnotation {
            constructor(e) {
              super(e);
              const { dict: t, xref: a } = e,
                n = new d.FileSpec(t.get("FS"), a);
              this.data.annotationType = r.AnnotationType.FILEATTACHMENT;
              this.data.hasOwnCanvas = this.data.noRotate;
              this.data.file = n.serializable;
              const i = t.get("Name");
              this.data.name =
                i instanceof s.Name
                  ? (0, r.stringToPDFString)(i.name)
                  : "PushPin";
              const o = t.get("ca");
              this.data.fillAlpha =
                "number" == typeof o && o >= 0 && o <= 1 ? o : null;
            }
          }
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.FakeUnicodeFont = void 0;
          t.createDefaultAppearance = function createDefaultAppearance({
            fontSize: e,
            fontName: t,
            fontColor: a,
          }) {
            return `/${(0, n.escapePDFName)(t)} ${e} Tf ${getPdfColor(a, !0)}`;
          };
          t.getPdfColor = getPdfColor;
          t.parseAppearanceStream = function parseAppearanceStream(e, t, a) {
            return new AppearanceStreamEvaluator(e, t, a).parse();
          };
          t.parseDefaultAppearance = function parseDefaultAppearance(e) {
            return new DefaultAppearanceEvaluator(e).parse();
          };
          var r = a(4),
            n = a(3),
            i = a(2),
            s = a(12),
            o = a(13),
            c = a(59),
            l = a(57),
            h = a(8);
          class DefaultAppearanceEvaluator extends o.EvaluatorPreprocessor {
            constructor(e) {
              super(new h.StringStream(e));
            }
            parse() {
              const e = { fn: 0, args: [] },
                t = {
                  fontSize: 0,
                  fontName: "",
                  fontColor: new Uint8ClampedArray(3),
                };
              try {
                for (;;) {
                  e.args.length = 0;
                  if (!this.read(e)) break;
                  if (0 !== this.savedStatesDepth) continue;
                  const { fn: a, args: n } = e;
                  switch (0 | a) {
                    case i.OPS.setFont:
                      const [e, a] = n;
                      e instanceof r.Name && (t.fontName = e.name);
                      "number" == typeof a && a > 0 && (t.fontSize = a);
                      break;
                    case i.OPS.setFillRGBColor:
                      s.ColorSpace.singletons.rgb.getRgbItem(
                        n,
                        0,
                        t.fontColor,
                        0,
                      );
                      break;
                    case i.OPS.setFillGray:
                      s.ColorSpace.singletons.gray.getRgbItem(
                        n,
                        0,
                        t.fontColor,
                        0,
                      );
                      break;
                    case i.OPS.setFillCMYKColor:
                      s.ColorSpace.singletons.cmyk.getRgbItem(
                        n,
                        0,
                        t.fontColor,
                        0,
                      );
                  }
                }
              } catch (e) {
                (0, i.warn)(
                  `parseDefaultAppearance - ignoring errors: "${e}".`,
                );
              }
              return t;
            }
          }
          class AppearanceStreamEvaluator extends o.EvaluatorPreprocessor {
            constructor(e, t, a) {
              super(e);
              this.stream = e;
              this.evaluatorOptions = t;
              this.xref = a;
              this.resources = e.dict?.get("Resources");
            }
            parse() {
              const e = { fn: 0, args: [] };
              let t = {
                  scaleFactor: 1,
                  fontSize: 0,
                  fontName: "",
                  fontColor: new Uint8ClampedArray(3),
                  fillColorSpace: s.ColorSpace.singletons.gray,
                },
                a = !1;
              const n = [];
              try {
                for (;;) {
                  e.args.length = 0;
                  if (a || !this.read(e)) break;
                  const { fn: o, args: c } = e;
                  switch (0 | o) {
                    case i.OPS.save:
                      n.push({
                        scaleFactor: t.scaleFactor,
                        fontSize: t.fontSize,
                        fontName: t.fontName,
                        fontColor: t.fontColor.slice(),
                        fillColorSpace: t.fillColorSpace,
                      });
                      break;
                    case i.OPS.restore:
                      t = n.pop() || t;
                      break;
                    case i.OPS.setTextMatrix:
                      t.scaleFactor *= Math.hypot(c[0], c[1]);
                      break;
                    case i.OPS.setFont:
                      const [e, o] = c;
                      e instanceof r.Name && (t.fontName = e.name);
                      "number" == typeof o &&
                        o > 0 &&
                        (t.fontSize = o * t.scaleFactor);
                      break;
                    case i.OPS.setFillColorSpace:
                      t.fillColorSpace = s.ColorSpace.parse({
                        cs: c[0],
                        xref: this.xref,
                        resources: this.resources,
                        pdfFunctionFactory: this._pdfFunctionFactory,
                        localColorSpaceCache: this._localColorSpaceCache,
                      });
                      break;
                    case i.OPS.setFillColor:
                      t.fillColorSpace.getRgbItem(c, 0, t.fontColor, 0);
                      break;
                    case i.OPS.setFillRGBColor:
                      s.ColorSpace.singletons.rgb.getRgbItem(
                        c,
                        0,
                        t.fontColor,
                        0,
                      );
                      break;
                    case i.OPS.setFillGray:
                      s.ColorSpace.singletons.gray.getRgbItem(
                        c,
                        0,
                        t.fontColor,
                        0,
                      );
                      break;
                    case i.OPS.setFillCMYKColor:
                      s.ColorSpace.singletons.cmyk.getRgbItem(
                        c,
                        0,
                        t.fontColor,
                        0,
                      );
                      break;
                    case i.OPS.showText:
                    case i.OPS.showSpacedText:
                    case i.OPS.nextLineShowText:
                    case i.OPS.nextLineSetSpacingShowText:
                      a = !0;
                  }
                }
              } catch (e) {
                (0, i.warn)(`parseAppearanceStream - ignoring errors: "${e}".`);
              }
              this.stream.reset();
              delete t.scaleFactor;
              delete t.fillColorSpace;
              return t;
            }
            get _localColorSpaceCache() {
              return (0, i.shadow)(
                this,
                "_localColorSpaceCache",
                new c.LocalColorSpaceCache(),
              );
            }
            get _pdfFunctionFactory() {
              const e = new l.PDFFunctionFactory({
                xref: this.xref,
                isEvalSupported: this.evaluatorOptions.isEvalSupported,
              });
              return (0, i.shadow)(this, "_pdfFunctionFactory", e);
            }
          }
          function getPdfColor(e, t) {
            if (e[0] === e[1] && e[1] === e[2]) {
              const a = e[0] / 255;
              return `${(0, n.numberToString)(a)} ${t ? "g" : "G"}`;
            }
            return (
              Array.from(e, (e) => (0, n.numberToString)(e / 255)).join(" ") +
              " " +
              (t ? "rg" : "RG")
            );
          }
          class FakeUnicodeFont {
            constructor(e, t) {
              this.xref = e;
              this.widths = null;
              this.firstChar = 1 / 0;
              this.lastChar = -1 / 0;
              this.fontFamily = t;
              const a = new OffscreenCanvas(1, 1);
              this.ctxMeasure = a.getContext("2d");
              FakeUnicodeFont._fontNameId || (FakeUnicodeFont._fontNameId = 1);
              this.fontName = r.Name.get(
                `InvalidPDFjsFont_${t}_${FakeUnicodeFont._fontNameId++}`,
              );
            }
            get toUnicodeRef() {
              if (!FakeUnicodeFont._toUnicodeRef) {
                const e =
                    "/CIDInit /ProcSet findresource begin\n12 dict begin\nbegincmap\n/CIDSystemInfo\n<< /Registry (Adobe)\n/Ordering (UCS) /Supplement 0 >> def\n/CMapName /Adobe-Identity-UCS def\n/CMapType 2 def\n1 begincodespacerange\n<0000> <FFFF>\nendcodespacerange\n1 beginbfrange\n<0000> <FFFF> <0000>\nendbfrange\nendcmap CMapName currentdict /CMap defineresource pop end end",
                  t = (FakeUnicodeFont.toUnicodeStream = new h.StringStream(e)),
                  a = new r.Dict(this.xref);
                t.dict = a;
                a.set("Length", e.length);
                FakeUnicodeFont._toUnicodeRef =
                  this.xref.getNewPersistentRef(t);
              }
              return FakeUnicodeFont._toUnicodeRef;
            }
            get fontDescriptorRef() {
              if (!FakeUnicodeFont._fontDescriptorRef) {
                const e = new r.Dict(this.xref);
                e.set("Type", r.Name.get("FontDescriptor"));
                e.set("FontName", this.fontName);
                e.set("FontFamily", "MyriadPro Regular");
                e.set("FontBBox", [0, 0, 0, 0]);
                e.set("FontStretch", r.Name.get("Normal"));
                e.set("FontWeight", 400);
                e.set("ItalicAngle", 0);
                FakeUnicodeFont._fontDescriptorRef =
                  this.xref.getNewPersistentRef(e);
              }
              return FakeUnicodeFont._fontDescriptorRef;
            }
            get descendantFontRef() {
              const e = new r.Dict(this.xref);
              e.set("BaseFont", this.fontName);
              e.set("Type", r.Name.get("Font"));
              e.set("Subtype", r.Name.get("CIDFontType0"));
              e.set("CIDToGIDMap", r.Name.get("Identity"));
              e.set("FirstChar", this.firstChar);
              e.set("LastChar", this.lastChar);
              e.set("FontDescriptor", this.fontDescriptorRef);
              e.set("DW", 1e3);
              const t = [],
                a = [...this.widths.entries()].sort();
              let n = null,
                i = null;
              for (const [e, r] of a)
                if (n)
                  if (e === n + i.length) i.push(r);
                  else {
                    t.push(n, i);
                    n = e;
                    i = [r];
                  }
                else {
                  n = e;
                  i = [r];
                }
              n && t.push(n, i);
              e.set("W", t);
              const s = new r.Dict(this.xref);
              s.set("Ordering", "Identity");
              s.set("Registry", "Adobe");
              s.set("Supplement", 0);
              e.set("CIDSystemInfo", s);
              return this.xref.getNewPersistentRef(e);
            }
            get baseFontRef() {
              const e = new r.Dict(this.xref);
              e.set("BaseFont", this.fontName);
              e.set("Type", r.Name.get("Font"));
              e.set("Subtype", r.Name.get("Type0"));
              e.set("Encoding", r.Name.get("Identity-H"));
              e.set("DescendantFonts", [this.descendantFontRef]);
              e.set("ToUnicode", this.toUnicodeRef);
              return this.xref.getNewPersistentRef(e);
            }
            get resources() {
              const e = new r.Dict(this.xref),
                t = new r.Dict(this.xref);
              t.set(this.fontName.name, this.baseFontRef);
              e.set("Font", t);
              return e;
            }
            _createContext() {
              this.widths = new Map();
              this.ctxMeasure.font = `1000px ${this.fontFamily}`;
              return this.ctxMeasure;
            }
            createFontResources(e) {
              const t = this._createContext();
              for (const a of e.split(/\r\n?|\n/))
                for (const e of a.split("")) {
                  const a = e.charCodeAt(0);
                  if (this.widths.has(a)) continue;
                  const r = t.measureText(e),
                    n = Math.ceil(r.width);
                  this.widths.set(a, n);
                  this.firstChar = Math.min(a, this.firstChar);
                  this.lastChar = Math.max(a, this.lastChar);
                }
              return this.resources;
            }
            createAppearance(e, t, a, s, o, c) {
              const l = this._createContext(),
                u = [];
              let d = -1 / 0;
              for (const t of e.split(/\r\n?|\n/)) {
                u.push(t);
                const e = l.measureText(t).width;
                d = Math.max(d, e);
                for (const e of t.split("")) {
                  const t = e.charCodeAt(0);
                  let a = this.widths.get(t);
                  if (void 0 === a) {
                    const r = l.measureText(e);
                    a = Math.ceil(r.width);
                    this.widths.set(t, a);
                    this.firstChar = Math.min(t, this.firstChar);
                    this.lastChar = Math.max(t, this.lastChar);
                  }
                }
              }
              d *= s / 1e3;
              const [f, g, p, m] = t;
              let b = p - f,
                y = m - g;
              a % 180 != 0 && ([b, y] = [y, b]);
              let w = 1;
              d > b && (w = b / d);
              let S = 1;
              const x = i.LINE_FACTOR * s,
                C = i.LINE_DESCENT_FACTOR * s,
                k = x * u.length;
              k > y && (S = y / k);
              const v = s * Math.min(w, S),
                F = [
                  "q",
                  `0 0 ${(0, n.numberToString)(b)} ${(0, n.numberToString)(
                    y,
                  )} re W n`,
                  "BT",
                  `1 0 0 1 0 ${(0, n.numberToString)(
                    y + C,
                  )} Tm 0 Tc ${getPdfColor(o, !0)}`,
                  `/${this.fontName.name} ${(0, n.numberToString)(v)} Tf`,
                ],
                { resources: O } = this;
              if (
                1 !== (c = "number" == typeof c && c >= 0 && c <= 1 ? c : 1)
              ) {
                F.push("/R0 gs");
                const e = new r.Dict(this.xref),
                  t = new r.Dict(this.xref);
                t.set("ca", c);
                t.set("CA", c);
                t.set("Type", r.Name.get("ExtGState"));
                e.set("R0", t);
                O.set("ExtGState", e);
              }
              const T = (0, n.numberToString)(x);
              for (const e of u)
                F.push(`0 -${T} Td <${(0, n.stringToUTF16HexString)(e)}> Tj`);
              F.push("ET", "Q");
              const M = F.join("\n"),
                D = new r.Dict(this.xref);
              D.set("Subtype", r.Name.get("Form"));
              D.set("Type", r.Name.get("XObject"));
              D.set("BBox", [0, 0, b, y]);
              D.set("Length", M.length);
              D.set("Resources", O);
              if (a) {
                const e = (0, n.getRotationMatrix)(a, b, y);
                D.set("Matrix", e);
              }
              const E = new h.StringStream(M);
              E.dict = D;
              return E;
            }
          }
          t.FakeUnicodeFont = FakeUnicodeFont;
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.ColorSpace = void 0;
          var r = a(2),
            n = a(4),
            i = a(5),
            s = a(3);
          class ColorSpace {
            constructor(e, t) {
              this.constructor === ColorSpace &&
                (0, r.unreachable)("Cannot initialize ColorSpace.");
              this.name = e;
              this.numComps = t;
            }
            getRgb(e, t) {
              const a = new Uint8ClampedArray(3);
              this.getRgbItem(e, t, a, 0);
              return a;
            }
            getRgbItem(e, t, a, n) {
              (0, r.unreachable)("Should not call ColorSpace.getRgbItem");
            }
            getRgbBuffer(e, t, a, n, i, s, o) {
              (0, r.unreachable)("Should not call ColorSpace.getRgbBuffer");
            }
            getOutputLength(e, t) {
              (0, r.unreachable)("Should not call ColorSpace.getOutputLength");
            }
            isPassthrough(e) {
              return !1;
            }
            isDefaultDecode(e, t) {
              return ColorSpace.isDefaultDecode(e, this.numComps);
            }
            fillRgb(e, t, a, r, n, i, s, o, c) {
              const l = t * a;
              let h = null;
              const u = 1 << s,
                d = a !== n || t !== r;
              if (this.isPassthrough(s)) h = o;
              else if (
                1 === this.numComps &&
                l > u &&
                "DeviceGray" !== this.name &&
                "DeviceRGB" !== this.name
              ) {
                const t = s <= 8 ? new Uint8Array(u) : new Uint16Array(u);
                for (let e = 0; e < u; e++) t[e] = e;
                const a = new Uint8ClampedArray(3 * u);
                this.getRgbBuffer(t, 0, u, a, 0, s, 0);
                if (d) {
                  h = new Uint8Array(3 * l);
                  let e = 0;
                  for (let t = 0; t < l; ++t) {
                    const r = 3 * o[t];
                    h[e++] = a[r];
                    h[e++] = a[r + 1];
                    h[e++] = a[r + 2];
                  }
                } else {
                  let t = 0;
                  for (let r = 0; r < l; ++r) {
                    const n = 3 * o[r];
                    e[t++] = a[n];
                    e[t++] = a[n + 1];
                    e[t++] = a[n + 2];
                    t += c;
                  }
                }
              } else if (d) {
                h = new Uint8ClampedArray(3 * l);
                this.getRgbBuffer(o, 0, l, h, 0, s, 0);
              } else this.getRgbBuffer(o, 0, r * i, e, 0, s, c);
              if (h)
                if (d)
                  !(function resizeRgbImage(e, t, a, r, n, i, s) {
                    s = 1 !== s ? 0 : s;
                    const o = a / n,
                      c = r / i;
                    let l,
                      h = 0;
                    const u = new Uint16Array(n),
                      d = 3 * a;
                    for (let e = 0; e < n; e++) u[e] = 3 * Math.floor(e * o);
                    for (let a = 0; a < i; a++) {
                      const r = Math.floor(a * c) * d;
                      for (let a = 0; a < n; a++) {
                        l = r + u[a];
                        t[h++] = e[l++];
                        t[h++] = e[l++];
                        t[h++] = e[l++];
                        h += s;
                      }
                    }
                  })(h, e, t, a, r, n, c);
                else {
                  let t = 0,
                    a = 0;
                  for (let n = 0, s = r * i; n < s; n++) {
                    e[t++] = h[a++];
                    e[t++] = h[a++];
                    e[t++] = h[a++];
                    t += c;
                  }
                }
            }
            get usesZeroToOneRange() {
              return (0, r.shadow)(this, "usesZeroToOneRange", !0);
            }
            static _cache(e, t, a, r) {
              if (!a)
                throw new Error(
                  'ColorSpace._cache - expected "localColorSpaceCache" argument.',
                );
              if (!r)
                throw new Error(
                  'ColorSpace._cache - expected "parsedColorSpace" argument.',
                );
              let i, s;
              if (e instanceof n.Ref) {
                s = e;
                e = t.fetch(e);
              }
              e instanceof n.Name && (i = e.name);
              (i || s) && a.set(i, s, r);
            }
            static getCached(e, t, a) {
              if (!a)
                throw new Error(
                  'ColorSpace.getCached - expected "localColorSpaceCache" argument.',
                );
              if (e instanceof n.Ref) {
                const r = a.getByRef(e);
                if (r) return r;
                try {
                  e = t.fetch(e);
                } catch (e) {
                  if (e instanceof s.MissingDataException) throw e;
                }
              }
              if (e instanceof n.Name) {
                const t = a.getByName(e.name);
                if (t) return t;
              }
              return null;
            }
            static async parseAsync({
              cs: e,
              xref: t,
              resources: a = null,
              pdfFunctionFactory: r,
              localColorSpaceCache: n,
            }) {
              const i = this._parse(e, t, a, r);
              this._cache(e, t, n, i);
              return i;
            }
            static parse({
              cs: e,
              xref: t,
              resources: a = null,
              pdfFunctionFactory: r,
              localColorSpaceCache: n,
            }) {
              const i = this.getCached(e, t, n);
              if (i) return i;
              const s = this._parse(e, t, a, r);
              this._cache(e, t, n, s);
              return s;
            }
            static _parse(e, t, a = null, i) {
              if ((e = t.fetchIfRef(e)) instanceof n.Name)
                switch (e.name) {
                  case "G":
                  case "DeviceGray":
                    return this.singletons.gray;
                  case "RGB":
                  case "DeviceRGB":
                    return this.singletons.rgb;
                  case "CMYK":
                  case "DeviceCMYK":
                    return this.singletons.cmyk;
                  case "Pattern":
                    return new PatternCS(null);
                  default:
                    if (a instanceof n.Dict) {
                      const r = a.get("ColorSpace");
                      if (r instanceof n.Dict) {
                        const s = r.get(e.name);
                        if (s) {
                          if (s instanceof n.Name)
                            return this._parse(s, t, a, i);
                          e = s;
                          break;
                        }
                      }
                    }
                    throw new r.FormatError(
                      `Unrecognized ColorSpace: ${e.name}`,
                    );
                }
              if (Array.isArray(e)) {
                const n = t.fetchIfRef(e[0]).name;
                let s, o, c, l, h, u;
                switch (n) {
                  case "G":
                  case "DeviceGray":
                    return this.singletons.gray;
                  case "RGB":
                  case "DeviceRGB":
                    return this.singletons.rgb;
                  case "CMYK":
                  case "DeviceCMYK":
                    return this.singletons.cmyk;
                  case "CalGray":
                    s = t.fetchIfRef(e[1]);
                    l = s.getArray("WhitePoint");
                    h = s.getArray("BlackPoint");
                    u = s.get("Gamma");
                    return new CalGrayCS(l, h, u);
                  case "CalRGB":
                    s = t.fetchIfRef(e[1]);
                    l = s.getArray("WhitePoint");
                    h = s.getArray("BlackPoint");
                    u = s.getArray("Gamma");
                    const d = s.getArray("Matrix");
                    return new CalRGBCS(l, h, u, d);
                  case "ICCBased":
                    const f = t.fetchIfRef(e[1]).dict;
                    o = f.get("N");
                    const g = f.get("Alternate");
                    if (g) {
                      const e = this._parse(g, t, a, i);
                      if (e.numComps === o) return e;
                      (0, r.warn)(
                        "ICCBased color space: Ignoring incorrect /Alternate entry.",
                      );
                    }
                    if (1 === o) return this.singletons.gray;
                    if (3 === o) return this.singletons.rgb;
                    if (4 === o) return this.singletons.cmyk;
                    break;
                  case "Pattern":
                    c = e[1] || null;
                    c && (c = this._parse(c, t, a, i));
                    return new PatternCS(c);
                  case "I":
                  case "Indexed":
                    c = this._parse(e[1], t, a, i);
                    const p = t.fetchIfRef(e[2]) + 1,
                      m = t.fetchIfRef(e[3]);
                    return new IndexedCS(c, p, m);
                  case "Separation":
                  case "DeviceN":
                    const b = t.fetchIfRef(e[1]);
                    o = Array.isArray(b) ? b.length : 1;
                    c = this._parse(e[2], t, a, i);
                    const y = i.create(e[3]);
                    return new AlternateCS(o, c, y);
                  case "Lab":
                    s = t.fetchIfRef(e[1]);
                    l = s.getArray("WhitePoint");
                    h = s.getArray("BlackPoint");
                    const w = s.getArray("Range");
                    return new LabCS(l, h, w);
                  default:
                    throw new r.FormatError(
                      `Unimplemented ColorSpace object: ${n}`,
                    );
                }
              }
              throw new r.FormatError(`Unrecognized ColorSpace object: ${e}`);
            }
            static isDefaultDecode(e, t) {
              if (!Array.isArray(e)) return !0;
              if (2 * t !== e.length) {
                (0, r.warn)("The decode map is not the correct length");
                return !0;
              }
              for (let t = 0, a = e.length; t < a; t += 2)
                if (0 !== e[t] || 1 !== e[t + 1]) return !1;
              return !0;
            }
            static get singletons() {
              return (0, r.shadow)(this, "singletons", {
                get gray() {
                  return (0, r.shadow)(this, "gray", new DeviceGrayCS());
                },
                get rgb() {
                  return (0, r.shadow)(this, "rgb", new DeviceRgbCS());
                },
                get cmyk() {
                  return (0, r.shadow)(this, "cmyk", new DeviceCmykCS());
                },
              });
            }
          }
          t.ColorSpace = ColorSpace;
          class AlternateCS extends ColorSpace {
            constructor(e, t, a) {
              super("Alternate", e);
              this.base = t;
              this.tintFn = a;
              this.tmpBuf = new Float32Array(t.numComps);
            }
            getRgbItem(e, t, a, r) {
              const n = this.tmpBuf;
              this.tintFn(e, t, n, 0);
              this.base.getRgbItem(n, 0, a, r);
            }
            getRgbBuffer(e, t, a, r, n, i, s) {
              const o = this.tintFn,
                c = this.base,
                l = 1 / ((1 << i) - 1),
                h = c.numComps,
                u = c.usesZeroToOneRange,
                d = (c.isPassthrough(8) || !u) && 0 === s;
              let f = d ? n : 0;
              const g = d ? r : new Uint8ClampedArray(h * a),
                p = this.numComps,
                m = new Float32Array(p),
                b = new Float32Array(h);
              let y, w;
              for (y = 0; y < a; y++) {
                for (w = 0; w < p; w++) m[w] = e[t++] * l;
                o(m, 0, b, 0);
                if (u) for (w = 0; w < h; w++) g[f++] = 255 * b[w];
                else {
                  c.getRgbItem(b, 0, g, f);
                  f += h;
                }
              }
              d || c.getRgbBuffer(g, 0, a, r, n, 8, s);
            }
            getOutputLength(e, t) {
              return this.base.getOutputLength(
                (e * this.base.numComps) / this.numComps,
                t,
              );
            }
          }
          class PatternCS extends ColorSpace {
            constructor(e) {
              super("Pattern", null);
              this.base = e;
            }
            isDefaultDecode(e, t) {
              (0, r.unreachable)("Should not call PatternCS.isDefaultDecode");
            }
          }
          class IndexedCS extends ColorSpace {
            constructor(e, t, a) {
              super("Indexed", 1);
              this.base = e;
              this.highVal = t;
              const n = e.numComps * t;
              this.lookup = new Uint8Array(n);
              if (a instanceof i.BaseStream) {
                const e = a.getBytes(n);
                this.lookup.set(e);
              } else {
                if ("string" != typeof a)
                  throw new r.FormatError(
                    `IndexedCS - unrecognized lookup table: ${a}`,
                  );
                for (let e = 0; e < n; ++e)
                  this.lookup[e] = 255 & a.charCodeAt(e);
              }
            }
            getRgbItem(e, t, a, r) {
              const n = this.base.numComps,
                i = e[t] * n;
              this.base.getRgbBuffer(this.lookup, i, 1, a, r, 8, 0);
            }
            getRgbBuffer(e, t, a, r, n, i, s) {
              const o = this.base,
                c = o.numComps,
                l = o.getOutputLength(c, s),
                h = this.lookup;
              for (let i = 0; i < a; ++i) {
                const a = e[t++] * c;
                o.getRgbBuffer(h, a, 1, r, n, 8, s);
                n += l;
              }
            }
            getOutputLength(e, t) {
              return this.base.getOutputLength(e * this.base.numComps, t);
            }
            isDefaultDecode(e, t) {
              if (!Array.isArray(e)) return !0;
              if (2 !== e.length) {
                (0, r.warn)("Decode map length is not correct");
                return !0;
              }
              if (!Number.isInteger(t) || t < 1) {
                (0, r.warn)("Bits per component is not correct");
                return !0;
              }
              return 0 === e[0] && e[1] === (1 << t) - 1;
            }
          }
          class DeviceGrayCS extends ColorSpace {
            constructor() {
              super("DeviceGray", 1);
            }
            getRgbItem(e, t, a, r) {
              const n = 255 * e[t];
              a[r] = a[r + 1] = a[r + 2] = n;
            }
            getRgbBuffer(e, t, a, r, n, i, s) {
              const o = 255 / ((1 << i) - 1);
              let c = t,
                l = n;
              for (let t = 0; t < a; ++t) {
                const t = o * e[c++];
                r[l++] = t;
                r[l++] = t;
                r[l++] = t;
                l += s;
              }
            }
            getOutputLength(e, t) {
              return e * (3 + t);
            }
          }
          class DeviceRgbCS extends ColorSpace {
            constructor() {
              super("DeviceRGB", 3);
            }
            getRgbItem(e, t, a, r) {
              a[r] = 255 * e[t];
              a[r + 1] = 255 * e[t + 1];
              a[r + 2] = 255 * e[t + 2];
            }
            getRgbBuffer(e, t, a, r, n, i, s) {
              if (8 === i && 0 === s) {
                r.set(e.subarray(t, t + 3 * a), n);
                return;
              }
              const o = 255 / ((1 << i) - 1);
              let c = t,
                l = n;
              for (let t = 0; t < a; ++t) {
                r[l++] = o * e[c++];
                r[l++] = o * e[c++];
                r[l++] = o * e[c++];
                l += s;
              }
            }
            getOutputLength(e, t) {
              return ((e * (3 + t)) / 3) | 0;
            }
            isPassthrough(e) {
              return 8 === e;
            }
          }
          class DeviceCmykCS extends ColorSpace {
            constructor() {
              super("DeviceCMYK", 4);
            }
            #r(e, t, a, r, n) {
              const i = e[t] * a,
                s = e[t + 1] * a,
                o = e[t + 2] * a,
                c = e[t + 3] * a;
              r[n] =
                255 +
                i *
                  (-4.387332384609988 * i +
                    54.48615194189176 * s +
                    18.82290502165302 * o +
                    212.25662451639585 * c -
                    285.2331026137004) +
                s *
                  (1.7149763477362134 * s -
                    5.6096736904047315 * o +
                    -17.873870861415444 * c -
                    5.497006427196366) +
                o *
                  (-2.5217340131683033 * o -
                    21.248923337353073 * c +
                    17.5119270841813) +
                c * (-21.86122147463605 * c - 189.48180835922747);
              r[n + 1] =
                255 +
                i *
                  (8.841041422036149 * i +
                    60.118027045597366 * s +
                    6.871425592049007 * o +
                    31.159100130055922 * c -
                    79.2970844816548) +
                s *
                  (-15.310361306967817 * s +
                    17.575251261109482 * o +
                    131.35250912493976 * c -
                    190.9453302588951) +
                o *
                  (4.444339102852739 * o +
                    9.8632861493405 * c -
                    24.86741582555878) +
                c * (-20.737325471181034 * c - 187.80453709719578);
              r[n + 2] =
                255 +
                i *
                  (0.8842522430003296 * i +
                    8.078677503112928 * s +
                    30.89978309703729 * o -
                    0.23883238689178934 * c -
                    14.183576799673286) +
                s *
                  (10.49593273432072 * s +
                    63.02378494754052 * o +
                    50.606957656360734 * c -
                    112.23884253719248) +
                o *
                  (0.03296041114873217 * o +
                    115.60384449646641 * c -
                    193.58209356861505) +
                c * (-22.33816807309886 * c - 180.12613974708367);
            }
            getRgbItem(e, t, a, r) {
              this.#r(e, t, 1, a, r);
            }
            getRgbBuffer(e, t, a, r, n, i, s) {
              const o = 1 / ((1 << i) - 1);
              for (let i = 0; i < a; i++) {
                this.#r(e, t, o, r, n);
                t += 4;
                n += 3 + s;
              }
            }
            getOutputLength(e, t) {
              return ((e / 4) * (3 + t)) | 0;
            }
          }
          class CalGrayCS extends ColorSpace {
            constructor(e, t, a) {
              super("CalGray", 1);
              if (!e)
                throw new r.FormatError(
                  "WhitePoint missing - required for color space CalGray",
                );
              [this.XW, this.YW, this.ZW] = e;
              [this.XB, this.YB, this.ZB] = t || [0, 0, 0];
              this.G = a || 1;
              if (this.XW < 0 || this.ZW < 0 || 1 !== this.YW)
                throw new r.FormatError(
                  `Invalid WhitePoint components for ${this.name}, no fallback available`,
                );
              if (this.XB < 0 || this.YB < 0 || this.ZB < 0) {
                (0, r.info)(
                  `Invalid BlackPoint for ${this.name}, falling back to default.`,
                );
                this.XB = this.YB = this.ZB = 0;
              }
              (0 === this.XB && 0 === this.YB && 0 === this.ZB) ||
                (0, r.warn)(
                  `${this.name}, BlackPoint: XB: ${this.XB}, YB: ${this.YB}, ZB: ${this.ZB}, only default values are supported.`,
                );
              if (this.G < 1) {
                (0, r.info)(
                  `Invalid Gamma: ${this.G} for ${this.name}, falling back to default.`,
                );
                this.G = 1;
              }
            }
            #r(e, t, a, r, n) {
              const i = (e[t] * n) ** this.G,
                s = this.YW * i,
                o = Math.max(295.8 * s ** 0.3333333333333333 - 40.8, 0);
              a[r] = o;
              a[r + 1] = o;
              a[r + 2] = o;
            }
            getRgbItem(e, t, a, r) {
              this.#r(e, t, a, r, 1);
            }
            getRgbBuffer(e, t, a, r, n, i, s) {
              const o = 1 / ((1 << i) - 1);
              for (let i = 0; i < a; ++i) {
                this.#r(e, t, r, n, o);
                t += 1;
                n += 3 + s;
              }
            }
            getOutputLength(e, t) {
              return e * (3 + t);
            }
          }
          class CalRGBCS extends ColorSpace {
            static #n = new Float32Array([
              0.8951, 0.2664, -0.1614, -0.7502, 1.7135, 0.0367, 0.0389, -0.0685,
              1.0296,
            ]);
            static #i = new Float32Array([
              0.9869929, -0.1470543, 0.1599627, 0.4323053, 0.5183603, 0.0492912,
              -0.0085287, 0.0400428, 0.9684867,
            ]);
            static #s = new Float32Array([
              3.2404542, -1.5371385, -0.4985314, -0.969266, 1.8760108, 0.041556,
              0.0556434, -0.2040259, 1.0572252,
            ]);
            static #o = new Float32Array([1, 1, 1]);
            static #c = new Float32Array(3);
            static #l = new Float32Array(3);
            static #h = new Float32Array(3);
            static #u = (24 / 116) ** 3 / 8;
            constructor(e, t, a, n) {
              super("CalRGB", 3);
              if (!e)
                throw new r.FormatError(
                  "WhitePoint missing - required for color space CalRGB",
                );
              const [i, s, o] = (this.whitePoint = e),
                [c, l, h] = (this.blackPoint = t || new Float32Array(3));
              [this.GR, this.GG, this.GB] = a || new Float32Array([1, 1, 1]);
              [
                this.MXA,
                this.MYA,
                this.MZA,
                this.MXB,
                this.MYB,
                this.MZB,
                this.MXC,
                this.MYC,
                this.MZC,
              ] = n || new Float32Array([1, 0, 0, 0, 1, 0, 0, 0, 1]);
              if (i < 0 || o < 0 || 1 !== s)
                throw new r.FormatError(
                  `Invalid WhitePoint components for ${this.name}, no fallback available`,
                );
              if (c < 0 || l < 0 || h < 0) {
                (0, r.info)(
                  `Invalid BlackPoint for ${this.name} [${c}, ${l}, ${h}], falling back to default.`,
                );
                this.blackPoint = new Float32Array(3);
              }
              if (this.GR < 0 || this.GG < 0 || this.GB < 0) {
                (0, r.info)(
                  `Invalid Gamma [${this.GR}, ${this.GG}, ${this.GB}] for ${this.name}, falling back to default.`,
                );
                this.GR = this.GG = this.GB = 1;
              }
            }
            #d(e, t, a) {
              a[0] = e[0] * t[0] + e[1] * t[1] + e[2] * t[2];
              a[1] = e[3] * t[0] + e[4] * t[1] + e[5] * t[2];
              a[2] = e[6] * t[0] + e[7] * t[1] + e[8] * t[2];
            }
            #f(e, t, a) {
              a[0] = (1 * t[0]) / e[0];
              a[1] = (1 * t[1]) / e[1];
              a[2] = (1 * t[2]) / e[2];
            }
            #g(e, t, a) {
              a[0] = (0.95047 * t[0]) / e[0];
              a[1] = (1 * t[1]) / e[1];
              a[2] = (1.08883 * t[2]) / e[2];
            }
            #p(e) {
              return e <= 0.0031308
                ? this.#m(0, 1, 12.92 * e)
                : e >= 0.99554525
                  ? 1
                  : this.#m(0, 1, 1.055 * e ** (1 / 2.4) - 0.055);
            }
            #m(e, t, a) {
              return Math.max(e, Math.min(t, a));
            }
            #b(e) {
              return e < 0
                ? -this.#b(-e)
                : e > 8
                  ? ((e + 16) / 116) ** 3
                  : e * CalRGBCS.#u;
            }
            #y(e, t, a) {
              if (0 === e[0] && 0 === e[1] && 0 === e[2]) {
                a[0] = t[0];
                a[1] = t[1];
                a[2] = t[2];
                return;
              }
              const r = this.#b(0),
                n = (1 - r) / (1 - this.#b(e[0])),
                i = 1 - n,
                s = (1 - r) / (1 - this.#b(e[1])),
                o = 1 - s,
                c = (1 - r) / (1 - this.#b(e[2])),
                l = 1 - c;
              a[0] = t[0] * n + i;
              a[1] = t[1] * s + o;
              a[2] = t[2] * c + l;
            }
            #w(e, t, a) {
              if (1 === e[0] && 1 === e[2]) {
                a[0] = t[0];
                a[1] = t[1];
                a[2] = t[2];
                return;
              }
              const r = a;
              this.#d(CalRGBCS.#n, t, r);
              const n = CalRGBCS.#c;
              this.#f(e, r, n);
              this.#d(CalRGBCS.#i, n, a);
            }
            #S(e, t, a) {
              const r = a;
              this.#d(CalRGBCS.#n, t, r);
              const n = CalRGBCS.#c;
              this.#g(e, r, n);
              this.#d(CalRGBCS.#i, n, a);
            }
            #r(e, t, a, r, n) {
              const i = this.#m(0, 1, e[t] * n),
                s = this.#m(0, 1, e[t + 1] * n),
                o = this.#m(0, 1, e[t + 2] * n),
                c = 1 === i ? 1 : i ** this.GR,
                l = 1 === s ? 1 : s ** this.GG,
                h = 1 === o ? 1 : o ** this.GB,
                u = this.MXA * c + this.MXB * l + this.MXC * h,
                d = this.MYA * c + this.MYB * l + this.MYC * h,
                f = this.MZA * c + this.MZB * l + this.MZC * h,
                g = CalRGBCS.#l;
              g[0] = u;
              g[1] = d;
              g[2] = f;
              const p = CalRGBCS.#h;
              this.#w(this.whitePoint, g, p);
              const m = CalRGBCS.#l;
              this.#y(this.blackPoint, p, m);
              const b = CalRGBCS.#h;
              this.#S(CalRGBCS.#o, m, b);
              const y = CalRGBCS.#l;
              this.#d(CalRGBCS.#s, b, y);
              a[r] = 255 * this.#p(y[0]);
              a[r + 1] = 255 * this.#p(y[1]);
              a[r + 2] = 255 * this.#p(y[2]);
            }
            getRgbItem(e, t, a, r) {
              this.#r(e, t, a, r, 1);
            }
            getRgbBuffer(e, t, a, r, n, i, s) {
              const o = 1 / ((1 << i) - 1);
              for (let i = 0; i < a; ++i) {
                this.#r(e, t, r, n, o);
                t += 3;
                n += 3 + s;
              }
            }
            getOutputLength(e, t) {
              return ((e * (3 + t)) / 3) | 0;
            }
          }
          class LabCS extends ColorSpace {
            constructor(e, t, a) {
              super("Lab", 3);
              if (!e)
                throw new r.FormatError(
                  "WhitePoint missing - required for color space Lab",
                );
              [this.XW, this.YW, this.ZW] = e;
              [this.amin, this.amax, this.bmin, this.bmax] = a || [
                -100, 100, -100, 100,
              ];
              [this.XB, this.YB, this.ZB] = t || [0, 0, 0];
              if (this.XW < 0 || this.ZW < 0 || 1 !== this.YW)
                throw new r.FormatError(
                  "Invalid WhitePoint components, no fallback available",
                );
              if (this.XB < 0 || this.YB < 0 || this.ZB < 0) {
                (0, r.info)("Invalid BlackPoint, falling back to default");
                this.XB = this.YB = this.ZB = 0;
              }
              if (this.amin > this.amax || this.bmin > this.bmax) {
                (0, r.info)("Invalid Range, falling back to defaults");
                this.amin = -100;
                this.amax = 100;
                this.bmin = -100;
                this.bmax = 100;
              }
            }
            #x(e) {
              return e >= 6 / 29 ? e ** 3 : (108 / 841) * (e - 4 / 29);
            }
            #A(e, t, a, r) {
              return a + (e * (r - a)) / t;
            }
            #r(e, t, a, r, n) {
              let i = e[t],
                s = e[t + 1],
                o = e[t + 2];
              if (!1 !== a) {
                i = this.#A(i, a, 0, 100);
                s = this.#A(s, a, this.amin, this.amax);
                o = this.#A(o, a, this.bmin, this.bmax);
              }
              s > this.amax
                ? (s = this.amax)
                : s < this.amin && (s = this.amin);
              o > this.bmax
                ? (o = this.bmax)
                : o < this.bmin && (o = this.bmin);
              const c = (i + 16) / 116,
                l = c + s / 500,
                h = c - o / 200,
                u = this.XW * this.#x(l),
                d = this.YW * this.#x(c),
                f = this.ZW * this.#x(h);
              let g, p, m;
              if (this.ZW < 1) {
                g = 3.1339 * u + -1.617 * d + -0.4906 * f;
                p = -0.9785 * u + 1.916 * d + 0.0333 * f;
                m = 0.072 * u + -0.229 * d + 1.4057 * f;
              } else {
                g = 3.2406 * u + -1.5372 * d + -0.4986 * f;
                p = -0.9689 * u + 1.8758 * d + 0.0415 * f;
                m = 0.0557 * u + -0.204 * d + 1.057 * f;
              }
              r[n] = 255 * Math.sqrt(g);
              r[n + 1] = 255 * Math.sqrt(p);
              r[n + 2] = 255 * Math.sqrt(m);
            }
            getRgbItem(e, t, a, r) {
              this.#r(e, t, !1, a, r);
            }
            getRgbBuffer(e, t, a, r, n, i, s) {
              const o = (1 << i) - 1;
              for (let i = 0; i < a; i++) {
                this.#r(e, t, o, r, n);
                t += 3;
                n += 3 + s;
              }
            }
            getOutputLength(e, t) {
              return ((e * (3 + t)) / 3) | 0;
            }
            isDefaultDecode(e, t) {
              return !0;
            }
            get usesZeroToOneRange() {
              return (0, r.shadow)(this, "usesZeroToOneRange", !1);
            }
          }
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.PartialEvaluator = t.EvaluatorPreprocessor = void 0;
          var r = a(2),
            n = a(14),
            i = a(4),
            s = a(34),
            o = a(37),
            c = a(41),
            l = a(50),
            h = a(51),
            u = a(42),
            d = a(57),
            f = a(16),
            g = a(59),
            p = a(8),
            m = a(5),
            b = a(60),
            y = a(12),
            w = a(18),
            S = a(38),
            x = a(61),
            C = a(39),
            k = a(45),
            v = a(40),
            F = a(62),
            O = a(63),
            T = a(64),
            M = a(65);
          const D = Object.freeze({
              maxImageSize: -1,
              disableFontFace: !1,
              ignoreErrors: !1,
              isEvalSupported: !0,
              isOffscreenCanvasSupported: !1,
              canvasMaxAreaInBytes: -1,
              fontExtraProperties: !1,
              useSystemFonts: !0,
              cMapUrl: null,
              standardFontDataUrl: null,
            }),
            E = 1,
            N = 2,
            R = Promise.resolve();
          function normalizeBlendMode(e, t = !1) {
            if (Array.isArray(e)) {
              for (const t of e) {
                const e = normalizeBlendMode(t, !0);
                if (e) return e;
              }
              (0, r.warn)(`Unsupported blend mode Array: ${e}`);
              return "source-over";
            }
            if (!(e instanceof i.Name)) return t ? null : "source-over";
            switch (e.name) {
              case "Normal":
              case "Compatible":
                return "source-over";
              case "Multiply":
                return "multiply";
              case "Screen":
                return "screen";
              case "Overlay":
                return "overlay";
              case "Darken":
                return "darken";
              case "Lighten":
                return "lighten";
              case "ColorDodge":
                return "color-dodge";
              case "ColorBurn":
                return "color-burn";
              case "HardLight":
                return "hard-light";
              case "SoftLight":
                return "soft-light";
              case "Difference":
                return "difference";
              case "Exclusion":
                return "exclusion";
              case "Hue":
                return "hue";
              case "Saturation":
                return "saturation";
              case "Color":
                return "color";
              case "Luminosity":
                return "luminosity";
            }
            if (t) return null;
            (0, r.warn)(`Unsupported blend mode: ${e.name}`);
            return "source-over";
          }
          function incrementCachedImageMaskCount(e) {
            e.fn === r.OPS.paintImageMaskXObject &&
              e.args[0]?.count > 0 &&
              e.args[0].count++;
          }
          class TimeSlotManager {
            static TIME_SLOT_DURATION_MS = 20;
            static CHECK_TIME_EVERY = 100;
            constructor() {
              this.reset();
            }
            check() {
              if (++this.checked < TimeSlotManager.CHECK_TIME_EVERY) return !1;
              this.checked = 0;
              return this.endTime <= Date.now();
            }
            reset() {
              this.endTime = Date.now() + TimeSlotManager.TIME_SLOT_DURATION_MS;
              this.checked = 0;
            }
          }
          class PartialEvaluator {
            constructor({
              xref: e,
              handler: t,
              pageIndex: a,
              idFactory: r,
              fontCache: n,
              builtInCMapCache: i,
              standardFontDataCache: s,
              globalImageCache: o,
              systemFontCache: c,
              options: l = null,
            }) {
              this.xref = e;
              this.handler = t;
              this.pageIndex = a;
              this.idFactory = r;
              this.fontCache = n;
              this.builtInCMapCache = i;
              this.standardFontDataCache = s;
              this.globalImageCache = o;
              this.systemFontCache = c;
              this.options = l || D;
              this.parsingType3Font = !1;
              this._regionalImageCache = new g.RegionalImageCache();
              this._fetchBuiltInCMapBound = this.fetchBuiltInCMap.bind(this);
              F.ImageResizer.setMaxArea(this.options.canvasMaxAreaInBytes);
            }
            get _pdfFunctionFactory() {
              const e = new d.PDFFunctionFactory({
                xref: this.xref,
                isEvalSupported: this.options.isEvalSupported,
              });
              return (0, r.shadow)(this, "_pdfFunctionFactory", e);
            }
            clone(e = null) {
              const t = Object.create(this);
              t.options = Object.assign(Object.create(null), this.options, e);
              return t;
            }
            hasBlendModes(e, t) {
              if (!(e instanceof i.Dict)) return !1;
              if (e.objId && t.has(e.objId)) return !1;
              const a = new i.RefSet(t);
              e.objId && a.put(e.objId);
              const n = [e],
                s = this.xref;
              for (; n.length; ) {
                const e = n.shift(),
                  t = e.get("ExtGState");
                if (t instanceof i.Dict)
                  for (let e of t.getRawValues()) {
                    if (e instanceof i.Ref) {
                      if (a.has(e)) continue;
                      try {
                        e = s.fetch(e);
                      } catch (t) {
                        a.put(e);
                        (0, r.info)(
                          `hasBlendModes - ignoring ExtGState: "${t}".`,
                        );
                        continue;
                      }
                    }
                    if (!(e instanceof i.Dict)) continue;
                    e.objId && a.put(e.objId);
                    const t = e.get("BM");
                    if (t instanceof i.Name) {
                      if ("Normal" !== t.name) return !0;
                    } else if (void 0 !== t && Array.isArray(t))
                      for (const e of t)
                        if (e instanceof i.Name && "Normal" !== e.name)
                          return !0;
                  }
                const o = e.get("XObject");
                if (o instanceof i.Dict)
                  for (let e of o.getRawValues()) {
                    if (e instanceof i.Ref) {
                      if (a.has(e)) continue;
                      try {
                        e = s.fetch(e);
                      } catch (t) {
                        a.put(e);
                        (0, r.info)(
                          `hasBlendModes - ignoring XObject: "${t}".`,
                        );
                        continue;
                      }
                    }
                    if (!(e instanceof m.BaseStream)) continue;
                    e.dict.objId && a.put(e.dict.objId);
                    const t = e.dict.get("Resources");
                    if (t instanceof i.Dict && (!t.objId || !a.has(t.objId))) {
                      n.push(t);
                      t.objId && a.put(t.objId);
                    }
                  }
              }
              for (const e of a) t.put(e);
              return !1;
            }
            async fetchBuiltInCMap(e) {
              const t = this.builtInCMapCache.get(e);
              if (t) return t;
              let a;
              if (null !== this.options.cMapUrl) {
                const t = `${this.options.cMapUrl}${e}.bcmap`,
                  n = await fetch(t);
                if (!n.ok)
                  throw new Error(
                    `fetchBuiltInCMap: failed to fetch file "${t}" with "${n.statusText}".`,
                  );
                a = {
                  cMapData: new Uint8Array(await n.arrayBuffer()),
                  compressionType: r.CMapCompressionType.BINARY,
                };
              } else
                a = await this.handler.sendWithPromise("FetchBuiltInCMap", {
                  name: e,
                });
              a.compressionType !== r.CMapCompressionType.NONE &&
                this.builtInCMapCache.set(e, a);
              return a;
            }
            async fetchStandardFontData(e) {
              const t = this.standardFontDataCache.get(e);
              if (t) return new p.Stream(t);
              if (
                this.options.useSystemFonts &&
                "Symbol" !== e &&
                "ZapfDingbats" !== e
              )
                return null;
              const a = (0, c.getFontNameToFileMap)()[e];
              let n;
              if (null !== this.options.standardFontDataUrl) {
                const e = `${this.options.standardFontDataUrl}${a}`,
                  t = await fetch(e);
                t.ok
                  ? (n = await t.arrayBuffer())
                  : (0, r.warn)(
                      `fetchStandardFontData: failed to fetch file "${e}" with "${t.statusText}".`,
                    );
              } else
                try {
                  n = await this.handler.sendWithPromise(
                    "FetchStandardFontData",
                    { filename: a },
                  );
                } catch (e) {
                  (0, r.warn)(
                    `fetchStandardFontData: failed to fetch file "${a}" with "${e}".`,
                  );
                }
              if (!n) return null;
              this.standardFontDataCache.set(e, n);
              return new p.Stream(n);
            }
            async buildFormXObject(e, t, a, n, s, o, c) {
              const l = t.dict,
                h = l.getArray("Matrix");
              let u,
                d,
                f = l.getArray("BBox");
              f =
                Array.isArray(f) && 4 === f.length
                  ? r.Util.normalizeRect(f)
                  : null;
              l.has("OC") &&
                (u = await this.parseMarkedContentProps(l.get("OC"), e));
              void 0 !== u && n.addOp(r.OPS.beginMarkedContentProps, ["OC", u]);
              const g = l.get("Group");
              if (g) {
                d = {
                  matrix: h,
                  bbox: f,
                  smask: a,
                  isolated: !1,
                  knockout: !1,
                };
                const t = g.get("S");
                let s = null;
                if ((0, i.isName)(t, "Transparency")) {
                  d.isolated = g.get("I") || !1;
                  d.knockout = g.get("K") || !1;
                  if (g.has("CS")) {
                    const t = g.getRaw("CS"),
                      a = y.ColorSpace.getCached(t, this.xref, c);
                    s =
                      a ||
                      (await this.parseColorSpace({
                        cs: t,
                        resources: e,
                        localColorSpaceCache: c,
                      }));
                  }
                }
                if (a?.backdrop) {
                  s ||= y.ColorSpace.singletons.rgb;
                  a.backdrop = s.getRgb(a.backdrop, 0);
                }
                n.addOp(r.OPS.beginGroup, [d]);
              }
              const p = g ? [h, null] : [h, f];
              n.addOp(r.OPS.paintFormXObjectBegin, p);
              return this.getOperatorList({
                stream: t,
                task: s,
                resources: l.get("Resources") || e,
                operatorList: n,
                initialState: o,
              }).then(function () {
                n.addOp(r.OPS.paintFormXObjectEnd, []);
                g && n.addOp(r.OPS.endGroup, [d]);
                void 0 !== u && n.addOp(r.OPS.endMarkedContent, []);
              });
            }
            _sendImgData(e, t, a = !1) {
              const r = t ? [t.bitmap || t.data.buffer] : null;
              return this.parsingType3Font || a
                ? this.handler.send("commonobj", [e, "Image", t], r)
                : this.handler.send("obj", [e, this.pageIndex, "Image", t], r);
            }
            async buildPaintImageXObject({
              resources: e,
              image: t,
              isInline: a = !1,
              operatorList: n,
              cacheKey: i,
              localImageCache: s,
              localColorSpaceCache: o,
            }) {
              const c = t.dict,
                l = c.objId,
                h = c.get("W", "Width"),
                u = c.get("H", "Height");
              if (!h || "number" != typeof h || !u || "number" != typeof u) {
                (0, r.warn)("Image dimensions are missing, or not numbers.");
                return;
              }
              const d = this.options.maxImageSize;
              if (-1 !== d && h * u > d) {
                const e =
                  "Image exceeded maximum allowed size and was removed.";
                if (this.options.ignoreErrors) {
                  (0, r.warn)(e);
                  return;
                }
                throw new Error(e);
              }
              let f;
              c.has("OC") &&
                (f = await this.parseMarkedContentProps(c.get("OC"), e));
              let g, p;
              if (c.get("IM", "ImageMask") || !1) {
                const e = c.get("I", "Interpolate"),
                  a = (h + 7) >> 3,
                  o = t.getBytes(a * u),
                  d = c.getArray("D", "Decode");
                if (this.parsingType3Font) {
                  g = M.PDFImage.createRawMask({
                    imgArray: o,
                    width: h,
                    height: u,
                    imageIsFromDecodeStream: t instanceof w.DecodeStream,
                    inverseDecode: d?.[0] > 0,
                    interpolate: e,
                  });
                  g.cached = !!i;
                  p = [g];
                  n.addImageOps(r.OPS.paintImageMaskXObject, p, f);
                  if (i) {
                    const e = {
                      fn: r.OPS.paintImageMaskXObject,
                      args: p,
                      optionalContent: f,
                    };
                    s.set(i, l, e);
                    l && this._regionalImageCache.set(null, l, e);
                  }
                  return;
                }
                g = await M.PDFImage.createMask({
                  imgArray: o,
                  width: h,
                  height: u,
                  imageIsFromDecodeStream: t instanceof w.DecodeStream,
                  inverseDecode: d?.[0] > 0,
                  interpolate: e,
                  isOffscreenCanvasSupported:
                    this.options.isOffscreenCanvasSupported,
                });
                if (g.isSingleOpaquePixel) {
                  n.addImageOps(r.OPS.paintSolidColorImageMask, [], f);
                  if (i) {
                    const e = {
                      fn: r.OPS.paintSolidColorImageMask,
                      args: [],
                      optionalContent: f,
                    };
                    s.set(i, l, e);
                    l && this._regionalImageCache.set(null, l, e);
                  }
                  return;
                }
                const m = `mask_${this.idFactory.createObjId()}`;
                n.addDependency(m);
                this._sendImgData(m, g);
                p = [
                  {
                    data: m,
                    width: g.width,
                    height: g.height,
                    interpolate: g.interpolate,
                    count: 1,
                  },
                ];
                n.addImageOps(r.OPS.paintImageMaskXObject, p, f);
                if (i) {
                  const e = {
                    fn: r.OPS.paintImageMaskXObject,
                    args: p,
                    optionalContent: f,
                  };
                  s.set(i, l, e);
                  l && this._regionalImageCache.set(null, l, e);
                }
                return;
              }
              if (a && !c.has("SMask") && !c.has("Mask") && h + u < 200) {
                const i = new M.PDFImage({
                  xref: this.xref,
                  res: e,
                  image: t,
                  isInline: a,
                  pdfFunctionFactory: this._pdfFunctionFactory,
                  localColorSpaceCache: o,
                });
                g = await i.createImageData(!0, !1);
                n.isOffscreenCanvasSupported =
                  this.options.isOffscreenCanvasSupported;
                n.addImageOps(r.OPS.paintInlineImageXObject, [g], f);
                return;
              }
              let m = `img_${this.idFactory.createObjId()}`,
                b = !1;
              if (this.parsingType3Font)
                m = `${this.idFactory.getDocId()}_type3_${m}`;
              else if (l) {
                b = this.globalImageCache.shouldCache(l, this.pageIndex);
                b && (m = `${this.idFactory.getDocId()}_${m}`);
              }
              n.addDependency(m);
              p = [m, h, u];
              M.PDFImage.buildImage({
                xref: this.xref,
                res: e,
                image: t,
                isInline: a,
                pdfFunctionFactory: this._pdfFunctionFactory,
                localColorSpaceCache: o,
              })
                .then(async (e) => {
                  g = await e.createImageData(
                    !1,
                    this.options.isOffscreenCanvasSupported,
                  );
                  if (i && l && b) {
                    const e = g.bitmap ? g.width * g.height * 4 : g.data.length;
                    this.globalImageCache.addByteSize(l, e);
                  }
                  return this._sendImgData(m, g, b);
                })
                .catch((e) => {
                  (0, r.warn)(`Unable to decode image "${m}": "${e}".`);
                  return this._sendImgData(m, null, b);
                });
              n.addImageOps(r.OPS.paintImageXObject, p, f);
              if (i) {
                const e = {
                  fn: r.OPS.paintImageXObject,
                  args: p,
                  optionalContent: f,
                };
                s.set(i, l, e);
                if (l) {
                  this._regionalImageCache.set(null, l, e);
                  if (b) {
                    (0, r.assert)(!a, "Cannot cache an inline image globally.");
                    this.globalImageCache.setData(l, {
                      objId: m,
                      fn: r.OPS.paintImageXObject,
                      args: p,
                      optionalContent: f,
                      byteSize: 0,
                    });
                  }
                }
              }
            }
            handleSMask(e, t, a, r, n, i) {
              const s = e.get("G"),
                o = { subtype: e.get("S").name, backdrop: e.get("BC") },
                c = e.get("TR");
              if ((0, d.isPDFFunction)(c)) {
                const e = this._pdfFunctionFactory.create(c),
                  t = new Uint8Array(256),
                  a = new Float32Array(1);
                for (let r = 0; r < 256; r++) {
                  a[0] = r / 255;
                  e(a, 0, a, 0);
                  t[r] = (255 * a[0]) | 0;
                }
                o.transferMap = t;
              }
              return this.buildFormXObject(t, s, o, a, r, n.state.clone(), i);
            }
            handleTransferFunction(e) {
              let t;
              if (Array.isArray(e)) t = e;
              else {
                if (!(0, d.isPDFFunction)(e)) return null;
                t = [e];
              }
              const a = [];
              let r = 0,
                n = 0;
              for (const e of t) {
                const t = this.xref.fetchIfRef(e);
                r++;
                if ((0, i.isName)(t, "Identity")) {
                  a.push(null);
                  continue;
                }
                if (!(0, d.isPDFFunction)(t)) return null;
                const s = this._pdfFunctionFactory.create(t),
                  o = new Uint8Array(256),
                  c = new Float32Array(1);
                for (let e = 0; e < 256; e++) {
                  c[0] = e / 255;
                  s(c, 0, c, 0);
                  o[e] = (255 * c[0]) | 0;
                }
                a.push(o);
                n++;
              }
              return (1 !== r && 4 !== r) || 0 === n ? null : a;
            }
            handleTilingType(e, t, a, n, s, o, c, h) {
              const u = new T.OperatorList(),
                d = i.Dict.merge({
                  xref: this.xref,
                  dictArray: [s.get("Resources"), a],
                });
              return this.getOperatorList({
                stream: n,
                task: c,
                resources: d,
                operatorList: u,
              })
                .then(function () {
                  const a = u.getIR(),
                    r = (0, l.getTilingPatternIR)(a, s, t);
                  o.addDependencies(u.dependencies);
                  o.addOp(e, r);
                  s.objId &&
                    h.set(null, s.objId, { operatorListIR: a, dict: s });
                })
                .catch((e) => {
                  if (!(e instanceof r.AbortException)) {
                    if (!this.options.ignoreErrors) throw e;
                    (0, r.warn)(`handleTilingType - ignoring pattern: "${e}".`);
                  }
                });
            }
            handleSetFont(e, t, a, r, n, o, c = null, l = null) {
              const h = t?.[0] instanceof i.Name ? t[0].name : null;
              return this.loadFont(h, a, e, c, l)
                .then((t) =>
                  t.font.isType3Font
                    ? t
                        .loadType3Data(this, e, n)
                        .then(function () {
                          r.addDependencies(t.type3Dependencies);
                          return t;
                        })
                        .catch(
                          (e) =>
                            new TranslatedFont({
                              loadedName: "g_font_error",
                              font: new s.ErrorFont(
                                `Type3 font load error: ${e}`,
                              ),
                              dict: t.font,
                              evaluatorOptions: this.options,
                            }),
                        )
                    : t,
                )
                .then((e) => {
                  o.font = e.font;
                  e.send(this.handler);
                  return e.loadedName;
                });
            }
            handleText(e, t) {
              const a = t.font,
                n = a.charsToGlyphs(e);
              if (a.data) {
                (!!(
                  t.textRenderingMode & r.TextRenderingMode.ADD_TO_PATH_FLAG
                ) ||
                  "Pattern" === t.fillColorSpace.name ||
                  a.disableFontFace ||
                  this.options.disableFontFace) &&
                  PartialEvaluator.buildFontPaths(
                    a,
                    n,
                    this.handler,
                    this.options,
                  );
              }
              return n;
            }
            ensureStateFont(e) {
              if (e.font) return;
              const t = new r.FormatError(
                "Missing setFont (Tf) operator before text rendering operator.",
              );
              if (!this.options.ignoreErrors) throw t;
              (0, r.warn)(`ensureStateFont: "${t}".`);
            }
            async setGState({
              resources: e,
              gState: t,
              operatorList: a,
              cacheKey: n,
              task: s,
              stateManager: o,
              localGStateCache: c,
              localColorSpaceCache: l,
            }) {
              const h = t.objId;
              let u = !0;
              const d = [];
              let f = Promise.resolve();
              for (const n of t.getKeys()) {
                const c = t.get(n);
                switch (n) {
                  case "Type":
                    break;
                  case "LW":
                  case "LC":
                  case "LJ":
                  case "ML":
                  case "D":
                  case "RI":
                  case "FL":
                  case "CA":
                  case "ca":
                    d.push([n, c]);
                    break;
                  case "Font":
                    u = !1;
                    f = f.then(() =>
                      this.handleSetFont(e, null, c[0], a, s, o.state).then(
                        function (e) {
                          a.addDependency(e);
                          d.push([n, [e, c[1]]]);
                        },
                      ),
                    );
                    break;
                  case "BM":
                    d.push([n, normalizeBlendMode(c)]);
                    break;
                  case "SMask":
                    if ((0, i.isName)(c, "None")) {
                      d.push([n, !1]);
                      break;
                    }
                    if (c instanceof i.Dict) {
                      u = !1;
                      f = f.then(() => this.handleSMask(c, e, a, s, o, l));
                      d.push([n, !0]);
                    } else (0, r.warn)("Unsupported SMask type");
                    break;
                  case "TR":
                    const t = this.handleTransferFunction(c);
                    d.push([n, t]);
                    break;
                  case "OP":
                  case "op":
                  case "OPM":
                  case "BG":
                  case "BG2":
                  case "UCR":
                  case "UCR2":
                  case "TR2":
                  case "HT":
                  case "SM":
                  case "SA":
                  case "AIS":
                  case "TK":
                    (0, r.info)("graphic state operator " + n);
                    break;
                  default:
                    (0, r.info)("Unknown graphic state operator " + n);
                }
              }
              return f.then(function () {
                d.length > 0 && a.addOp(r.OPS.setGState, [d]);
                u && c.set(n, h, d);
              });
            }
            loadFont(e, t, a, n = null, o = null) {
              const errorFont = async () =>
                new TranslatedFont({
                  loadedName: "g_font_error",
                  font: new s.ErrorFont(`Font "${e}" is not available.`),
                  dict: t,
                  evaluatorOptions: this.options,
                });
              let c;
              if (t) t instanceof i.Ref && (c = t);
              else {
                const t = a.get("Font");
                t && (c = t.getRaw(e));
              }
              if (c) {
                if (this.parsingType3Font && this.type3FontRefs.has(c))
                  return errorFont();
                if (this.fontCache.has(c)) return this.fontCache.get(c);
                t = this.xref.fetchIfRef(c);
              }
              if (!(t instanceof i.Dict)) {
                if (!this.options.ignoreErrors && !this.parsingType3Font) {
                  (0, r.warn)(`Font "${e}" is not available.`);
                  return errorFont();
                }
                (0, r.warn)(
                  `Font "${e}" is not available -- attempting to fallback to a default font.`,
                );
                t = n || PartialEvaluator.fallbackFontDict;
              }
              if (t.cacheKey && this.fontCache.has(t.cacheKey))
                return this.fontCache.get(t.cacheKey);
              const l = new r.PromiseCapability();
              let h;
              try {
                h = this.preEvaluateFont(t);
                h.cssFontInfo = o;
              } catch (e) {
                (0, r.warn)(`loadFont - preEvaluateFont failed: "${e}".`);
                return errorFont();
              }
              const { descriptor: u, hash: d } = h,
                f = c instanceof i.Ref;
              let g;
              if (d && u instanceof i.Dict) {
                const e = (u.fontAliases ||= Object.create(null));
                if (e[d]) {
                  const t = e[d].aliasRef;
                  if (f && t && this.fontCache.has(t)) {
                    this.fontCache.putAlias(c, t);
                    return this.fontCache.get(c);
                  }
                } else e[d] = { fontID: this.idFactory.createFontId() };
                f && (e[d].aliasRef = c);
                g = e[d].fontID;
              } else g = this.idFactory.createFontId();
              (0, r.assert)(
                g?.startsWith("f"),
                'The "fontID" must be (correctly) defined.',
              );
              if (f) this.fontCache.put(c, l.promise);
              else {
                t.cacheKey = `cacheKey_${g}`;
                this.fontCache.put(t.cacheKey, l.promise);
              }
              t.loadedName = `${this.idFactory.getDocId()}_${g}`;
              this.translateFont(h)
                .then((e) => {
                  l.resolve(
                    new TranslatedFont({
                      loadedName: t.loadedName,
                      font: e,
                      dict: t,
                      evaluatorOptions: this.options,
                    }),
                  );
                })
                .catch((e) => {
                  (0, r.warn)(`loadFont - translateFont failed: "${e}".`);
                  l.resolve(
                    new TranslatedFont({
                      loadedName: t.loadedName,
                      font: new s.ErrorFont(e instanceof Error ? e.message : e),
                      dict: t,
                      evaluatorOptions: this.options,
                    }),
                  );
                });
              return l.promise;
            }
            buildPath(e, t, a, n = !1) {
              const i = e.length - 1;
              a || (a = []);
              if (i < 0 || e.fnArray[i] !== r.OPS.constructPath) {
                if (n) {
                  (0, r.warn)(
                    `Encountered path operator "${t}" inside of a text object.`,
                  );
                  e.addOp(r.OPS.save, null);
                }
                let i;
                switch (t) {
                  case r.OPS.rectangle:
                    const e = a[0] + a[2],
                      t = a[1] + a[3];
                    i = [
                      Math.min(a[0], e),
                      Math.max(a[0], e),
                      Math.min(a[1], t),
                      Math.max(a[1], t),
                    ];
                    break;
                  case r.OPS.moveTo:
                  case r.OPS.lineTo:
                    i = [a[0], a[0], a[1], a[1]];
                    break;
                  default:
                    i = [1 / 0, -1 / 0, 1 / 0, -1 / 0];
                }
                e.addOp(r.OPS.constructPath, [[t], a, i]);
                n && e.addOp(r.OPS.restore, null);
              } else {
                const n = e.argsArray[i];
                n[0].push(t);
                n[1].push(...a);
                const s = n[2];
                switch (t) {
                  case r.OPS.rectangle:
                    const e = a[0] + a[2],
                      t = a[1] + a[3];
                    s[0] = Math.min(s[0], a[0], e);
                    s[1] = Math.max(s[1], a[0], e);
                    s[2] = Math.min(s[2], a[1], t);
                    s[3] = Math.max(s[3], a[1], t);
                    break;
                  case r.OPS.moveTo:
                  case r.OPS.lineTo:
                    s[0] = Math.min(s[0], a[0]);
                    s[1] = Math.max(s[1], a[0]);
                    s[2] = Math.min(s[2], a[1]);
                    s[3] = Math.max(s[3], a[1]);
                }
              }
            }
            parseColorSpace({ cs: e, resources: t, localColorSpaceCache: a }) {
              return y.ColorSpace.parseAsync({
                cs: e,
                xref: this.xref,
                resources: t,
                pdfFunctionFactory: this._pdfFunctionFactory,
                localColorSpaceCache: a,
              }).catch((e) => {
                if (e instanceof r.AbortException) return null;
                if (this.options.ignoreErrors) {
                  (0, r.warn)(`parseColorSpace - ignoring ColorSpace: "${e}".`);
                  return null;
                }
                throw e;
              });
            }
            parseShading({
              shading: e,
              resources: t,
              localColorSpaceCache: a,
              localShadingPatternCache: r,
            }) {
              let n = r.get(e);
              if (!n) {
                const i = l.Pattern.parseShading(
                  e,
                  this.xref,
                  t,
                  this._pdfFunctionFactory,
                  a,
                ).getIR();
                n = `pattern_${this.idFactory.createObjId()}`;
                this.parsingType3Font &&
                  (n = `${this.idFactory.getDocId()}_type3_${n}`);
                r.set(e, n);
                this.parsingType3Font
                  ? this.handler.send("commonobj", [n, "Pattern", i])
                  : this.handler.send("obj", [n, this.pageIndex, "Pattern", i]);
              }
              return n;
            }
            handleColorN(e, t, a, n, s, o, c, h, u, d) {
              const f = a.pop();
              if (f instanceof i.Name) {
                const g = s.getRaw(f.name),
                  p = g instanceof i.Ref && u.getByRef(g);
                if (p)
                  try {
                    const r = n.base ? n.base.getRgb(a, 0) : null,
                      i = (0, l.getTilingPatternIR)(
                        p.operatorListIR,
                        p.dict,
                        r,
                      );
                    e.addOp(t, i);
                    return;
                  } catch {}
                const b = this.xref.fetchIfRef(g);
                if (b) {
                  const i = b instanceof m.BaseStream ? b.dict : b,
                    s = i.get("PatternType");
                  if (s === E) {
                    const r = n.base ? n.base.getRgb(a, 0) : null;
                    return this.handleTilingType(t, r, o, b, i, e, c, u);
                  }
                  if (s === N) {
                    const a = i.get("Shading"),
                      r = i.getArray("Matrix"),
                      n = this.parseShading({
                        shading: a,
                        resources: o,
                        localColorSpaceCache: h,
                        localShadingPatternCache: d,
                      });
                    e.addOp(t, ["Shading", n, r]);
                    return;
                  }
                  throw new r.FormatError(`Unknown PatternType: ${s}`);
                }
              }
              throw new r.FormatError(`Unknown PatternName: ${f}`);
            }
            _parseVisibilityExpression(e, t, a) {
              if (++t > 10) {
                (0, r.warn)("Visibility expression is too deeply nested");
                return;
              }
              const n = e.length,
                s = this.xref.fetchIfRef(e[0]);
              if (!(n < 2) && s instanceof i.Name) {
                switch (s.name) {
                  case "And":
                  case "Or":
                  case "Not":
                    a.push(s.name);
                    break;
                  default:
                    (0, r.warn)(
                      `Invalid operator ${s.name} in visibility expression`,
                    );
                    return;
                }
                for (let r = 1; r < n; r++) {
                  const n = e[r],
                    s = this.xref.fetchIfRef(n);
                  if (Array.isArray(s)) {
                    const e = [];
                    a.push(e);
                    this._parseVisibilityExpression(s, t, e);
                  } else n instanceof i.Ref && a.push(n.toString());
                }
              } else (0, r.warn)("Invalid visibility expression");
            }
            async parseMarkedContentProps(e, t) {
              let a;
              if (e instanceof i.Name) {
                a = t.get("Properties").get(e.name);
              } else {
                if (!(e instanceof i.Dict))
                  throw new r.FormatError(
                    "Optional content properties malformed.",
                  );
                a = e;
              }
              const n = a.get("Type")?.name;
              if ("OCG" === n) return { type: n, id: a.objId };
              if ("OCMD" === n) {
                const e = a.get("VE");
                if (Array.isArray(e)) {
                  const t = [];
                  this._parseVisibilityExpression(e, 0, t);
                  if (t.length > 0) return { type: "OCMD", expression: t };
                }
                const t = a.get("OCGs");
                if (Array.isArray(t) || t instanceof i.Dict) {
                  const e = [];
                  if (Array.isArray(t)) for (const a of t) e.push(a.toString());
                  else e.push(t.objId);
                  return {
                    type: n,
                    ids: e,
                    policy:
                      a.get("P") instanceof i.Name ? a.get("P").name : null,
                    expression: null,
                  };
                }
                if (t instanceof i.Ref) return { type: n, id: t.toString() };
              }
              return null;
            }
            getOperatorList({
              stream: e,
              task: t,
              resources: a,
              operatorList: n,
              initialState: s = null,
              fallbackFontDict: o = null,
            }) {
              a ||= i.Dict.empty;
              s ||= new EvalState();
              if (!n)
                throw new Error(
                  'getOperatorList: missing "operatorList" parameter',
                );
              const c = this,
                l = this.xref;
              let h = !1;
              const u = new g.LocalImageCache(),
                d = new g.LocalColorSpaceCache(),
                f = new g.LocalGStateCache(),
                p = new g.LocalTilingPatternCache(),
                b = new Map(),
                w = a.get("XObject") || i.Dict.empty,
                S = a.get("Pattern") || i.Dict.empty,
                x = new StateManager(s),
                C = new EvaluatorPreprocessor(e, l, x),
                k = new TimeSlotManager();
              function closePendingRestoreOPS(e) {
                for (let e = 0, t = C.savedStatesDepth; e < t; e++)
                  n.addOp(r.OPS.restore, []);
              }
              return new Promise(function promiseBody(e, s) {
                const next = function (t) {
                  Promise.all([t, n.ready]).then(function () {
                    try {
                      promiseBody(e, s);
                    } catch (e) {
                      s(e);
                    }
                  }, s);
                };
                t.ensureNotTerminated();
                k.reset();
                const g = {};
                let v, F, O, T, M, D;
                for (; !(v = k.check()); ) {
                  g.args = null;
                  if (!C.read(g)) break;
                  let e = g.args,
                    s = g.fn;
                  switch (0 | s) {
                    case r.OPS.paintXObject:
                      D = e[0] instanceof i.Name;
                      M = e[0].name;
                      if (D) {
                        const t = u.getByName(M);
                        if (t) {
                          n.addImageOps(t.fn, t.args, t.optionalContent);
                          incrementCachedImageMaskCount(t);
                          e = null;
                          continue;
                        }
                      }
                      next(
                        new Promise(function (e, s) {
                          if (!D)
                            throw new r.FormatError(
                              "XObject must be referred to by name.",
                            );
                          let o = w.getRaw(M);
                          if (o instanceof i.Ref) {
                            const t =
                              u.getByRef(o) ||
                              c._regionalImageCache.getByRef(o);
                            if (t) {
                              n.addImageOps(t.fn, t.args, t.optionalContent);
                              incrementCachedImageMaskCount(t);
                              e();
                              return;
                            }
                            const a = c.globalImageCache.getData(
                              o,
                              c.pageIndex,
                            );
                            if (a) {
                              n.addDependency(a.objId);
                              n.addImageOps(a.fn, a.args, a.optionalContent);
                              e();
                              return;
                            }
                            o = l.fetch(o);
                          }
                          if (!(o instanceof m.BaseStream))
                            throw new r.FormatError(
                              "XObject should be a stream",
                            );
                          const h = o.dict.get("Subtype");
                          if (!(h instanceof i.Name))
                            throw new r.FormatError(
                              "XObject should have a Name subtype",
                            );
                          if ("Form" !== h.name)
                            if ("Image" !== h.name) {
                              if ("PS" !== h.name)
                                throw new r.FormatError(
                                  `Unhandled XObject subtype ${h.name}`,
                                );
                              (0, r.info)("Ignored XObject subtype PS");
                              e();
                            } else
                              c.buildPaintImageXObject({
                                resources: a,
                                image: o,
                                operatorList: n,
                                cacheKey: M,
                                localImageCache: u,
                                localColorSpaceCache: d,
                              }).then(e, s);
                          else {
                            x.save();
                            c.buildFormXObject(
                              a,
                              o,
                              null,
                              n,
                              t,
                              x.state.clone(),
                              d,
                            ).then(function () {
                              x.restore();
                              e();
                            }, s);
                          }
                        }).catch(function (e) {
                          if (!(e instanceof r.AbortException)) {
                            if (!c.options.ignoreErrors) throw e;
                            (0, r.warn)(
                              `getOperatorList - ignoring XObject: "${e}".`,
                            );
                          }
                        }),
                      );
                      return;
                    case r.OPS.setFont:
                      var E = e[1];
                      next(
                        c
                          .handleSetFont(a, e, null, n, t, x.state, o)
                          .then(function (e) {
                            n.addDependency(e);
                            n.addOp(r.OPS.setFont, [e, E]);
                          }),
                      );
                      return;
                    case r.OPS.beginText:
                      h = !0;
                      break;
                    case r.OPS.endText:
                      h = !1;
                      break;
                    case r.OPS.endInlineImage:
                      var N = e[0].cacheKey;
                      if (N) {
                        const t = u.getByName(N);
                        if (t) {
                          n.addImageOps(t.fn, t.args, t.optionalContent);
                          incrementCachedImageMaskCount(t);
                          e = null;
                          continue;
                        }
                      }
                      next(
                        c.buildPaintImageXObject({
                          resources: a,
                          image: e[0],
                          isInline: !0,
                          operatorList: n,
                          cacheKey: N,
                          localImageCache: u,
                          localColorSpaceCache: d,
                        }),
                      );
                      return;
                    case r.OPS.showText:
                      if (!x.state.font) {
                        c.ensureStateFont(x.state);
                        continue;
                      }
                      e[0] = c.handleText(e[0], x.state);
                      break;
                    case r.OPS.showSpacedText:
                      if (!x.state.font) {
                        c.ensureStateFont(x.state);
                        continue;
                      }
                      var L = [],
                        $ = x.state;
                      for (const t of e[0])
                        "string" == typeof t
                          ? L.push(...c.handleText(t, $))
                          : "number" == typeof t && L.push(t);
                      e[0] = L;
                      s = r.OPS.showText;
                      break;
                    case r.OPS.nextLineShowText:
                      if (!x.state.font) {
                        c.ensureStateFont(x.state);
                        continue;
                      }
                      n.addOp(r.OPS.nextLine);
                      e[0] = c.handleText(e[0], x.state);
                      s = r.OPS.showText;
                      break;
                    case r.OPS.nextLineSetSpacingShowText:
                      if (!x.state.font) {
                        c.ensureStateFont(x.state);
                        continue;
                      }
                      n.addOp(r.OPS.nextLine);
                      n.addOp(r.OPS.setWordSpacing, [e.shift()]);
                      n.addOp(r.OPS.setCharSpacing, [e.shift()]);
                      e[0] = c.handleText(e[0], x.state);
                      s = r.OPS.showText;
                      break;
                    case r.OPS.setTextRenderingMode:
                      x.state.textRenderingMode = e[0];
                      break;
                    case r.OPS.setFillColorSpace: {
                      const t = y.ColorSpace.getCached(e[0], l, d);
                      if (t) {
                        x.state.fillColorSpace = t;
                        continue;
                      }
                      next(
                        c
                          .parseColorSpace({
                            cs: e[0],
                            resources: a,
                            localColorSpaceCache: d,
                          })
                          .then(function (e) {
                            e && (x.state.fillColorSpace = e);
                          }),
                      );
                      return;
                    }
                    case r.OPS.setStrokeColorSpace: {
                      const t = y.ColorSpace.getCached(e[0], l, d);
                      if (t) {
                        x.state.strokeColorSpace = t;
                        continue;
                      }
                      next(
                        c
                          .parseColorSpace({
                            cs: e[0],
                            resources: a,
                            localColorSpaceCache: d,
                          })
                          .then(function (e) {
                            e && (x.state.strokeColorSpace = e);
                          }),
                      );
                      return;
                    }
                    case r.OPS.setFillColor:
                      T = x.state.fillColorSpace;
                      e = T.getRgb(e, 0);
                      s = r.OPS.setFillRGBColor;
                      break;
                    case r.OPS.setStrokeColor:
                      T = x.state.strokeColorSpace;
                      e = T.getRgb(e, 0);
                      s = r.OPS.setStrokeRGBColor;
                      break;
                    case r.OPS.setFillGray:
                      x.state.fillColorSpace = y.ColorSpace.singletons.gray;
                      e = y.ColorSpace.singletons.gray.getRgb(e, 0);
                      s = r.OPS.setFillRGBColor;
                      break;
                    case r.OPS.setStrokeGray:
                      x.state.strokeColorSpace = y.ColorSpace.singletons.gray;
                      e = y.ColorSpace.singletons.gray.getRgb(e, 0);
                      s = r.OPS.setStrokeRGBColor;
                      break;
                    case r.OPS.setFillCMYKColor:
                      x.state.fillColorSpace = y.ColorSpace.singletons.cmyk;
                      e = y.ColorSpace.singletons.cmyk.getRgb(e, 0);
                      s = r.OPS.setFillRGBColor;
                      break;
                    case r.OPS.setStrokeCMYKColor:
                      x.state.strokeColorSpace = y.ColorSpace.singletons.cmyk;
                      e = y.ColorSpace.singletons.cmyk.getRgb(e, 0);
                      s = r.OPS.setStrokeRGBColor;
                      break;
                    case r.OPS.setFillRGBColor:
                      x.state.fillColorSpace = y.ColorSpace.singletons.rgb;
                      e = y.ColorSpace.singletons.rgb.getRgb(e, 0);
                      break;
                    case r.OPS.setStrokeRGBColor:
                      x.state.strokeColorSpace = y.ColorSpace.singletons.rgb;
                      e = y.ColorSpace.singletons.rgb.getRgb(e, 0);
                      break;
                    case r.OPS.setFillColorN:
                      T = x.state.fillColorSpace;
                      if ("Pattern" === T.name) {
                        next(
                          c.handleColorN(
                            n,
                            r.OPS.setFillColorN,
                            e,
                            T,
                            S,
                            a,
                            t,
                            d,
                            p,
                            b,
                          ),
                        );
                        return;
                      }
                      e = T.getRgb(e, 0);
                      s = r.OPS.setFillRGBColor;
                      break;
                    case r.OPS.setStrokeColorN:
                      T = x.state.strokeColorSpace;
                      if ("Pattern" === T.name) {
                        next(
                          c.handleColorN(
                            n,
                            r.OPS.setStrokeColorN,
                            e,
                            T,
                            S,
                            a,
                            t,
                            d,
                            p,
                            b,
                          ),
                        );
                        return;
                      }
                      e = T.getRgb(e, 0);
                      s = r.OPS.setStrokeRGBColor;
                      break;
                    case r.OPS.shadingFill:
                      var _ = a.get("Shading");
                      if (!_)
                        throw new r.FormatError("No shading resource found");
                      var j = _.get(e[0].name);
                      if (!j)
                        throw new r.FormatError("No shading object found");
                      e = [
                        c.parseShading({
                          shading: j,
                          resources: a,
                          localColorSpaceCache: d,
                          localShadingPatternCache: b,
                        }),
                      ];
                      s = r.OPS.shadingFill;
                      break;
                    case r.OPS.setGState:
                      D = e[0] instanceof i.Name;
                      M = e[0].name;
                      if (D) {
                        const t = f.getByName(M);
                        if (t) {
                          t.length > 0 && n.addOp(r.OPS.setGState, [t]);
                          e = null;
                          continue;
                        }
                      }
                      next(
                        new Promise(function (e, s) {
                          if (!D)
                            throw new r.FormatError(
                              "GState must be referred to by name.",
                            );
                          const o = a.get("ExtGState");
                          if (!(o instanceof i.Dict))
                            throw new r.FormatError(
                              "ExtGState should be a dictionary.",
                            );
                          const l = o.get(M);
                          if (!(l instanceof i.Dict))
                            throw new r.FormatError(
                              "GState should be a dictionary.",
                            );
                          c.setGState({
                            resources: a,
                            gState: l,
                            operatorList: n,
                            cacheKey: M,
                            task: t,
                            stateManager: x,
                            localGStateCache: f,
                            localColorSpaceCache: d,
                          }).then(e, s);
                        }).catch(function (e) {
                          if (!(e instanceof r.AbortException)) {
                            if (!c.options.ignoreErrors) throw e;
                            (0, r.warn)(
                              `getOperatorList - ignoring ExtGState: "${e}".`,
                            );
                          }
                        }),
                      );
                      return;
                    case r.OPS.moveTo:
                    case r.OPS.lineTo:
                    case r.OPS.curveTo:
                    case r.OPS.curveTo2:
                    case r.OPS.curveTo3:
                    case r.OPS.closePath:
                    case r.OPS.rectangle:
                      c.buildPath(n, s, e, h);
                      continue;
                    case r.OPS.markPoint:
                    case r.OPS.markPointProps:
                    case r.OPS.beginCompat:
                    case r.OPS.endCompat:
                      continue;
                    case r.OPS.beginMarkedContentProps:
                      if (!(e[0] instanceof i.Name)) {
                        (0, r.warn)(
                          `Expected name for beginMarkedContentProps arg0=${e[0]}`,
                        );
                        continue;
                      }
                      if ("OC" === e[0].name) {
                        next(
                          c
                            .parseMarkedContentProps(e[1], a)
                            .then((e) => {
                              n.addOp(r.OPS.beginMarkedContentProps, ["OC", e]);
                            })
                            .catch((e) => {
                              if (!(e instanceof r.AbortException)) {
                                if (!c.options.ignoreErrors) throw e;
                                (0, r.warn)(
                                  `getOperatorList - ignoring beginMarkedContentProps: "${e}".`,
                                );
                              }
                            }),
                        );
                        return;
                      }
                      e = [
                        e[0].name,
                        e[1] instanceof i.Dict ? e[1].get("MCID") : null,
                      ];
                      break;
                    case r.OPS.beginMarkedContent:
                    case r.OPS.endMarkedContent:
                    default:
                      if (null !== e) {
                        for (
                          F = 0, O = e.length;
                          F < O && !(e[F] instanceof i.Dict);
                          F++
                        );
                        if (F < O) {
                          (0, r.warn)(
                            "getOperatorList - ignoring operator: " + s,
                          );
                          continue;
                        }
                      }
                  }
                  n.addOp(s, e);
                }
                if (v) next(R);
                else {
                  closePendingRestoreOPS();
                  e();
                }
              }).catch((e) => {
                if (!(e instanceof r.AbortException)) {
                  if (!this.options.ignoreErrors) throw e;
                  (0, r.warn)(
                    `getOperatorList - ignoring errors during "${t.name}" task: "${e}".`,
                  );
                  closePendingRestoreOPS();
                }
              });
            }
            getTextContent({
              stream: e,
              task: t,
              resources: a,
              stateManager: n = null,
              includeMarkedContent: s = !1,
              sink: o,
              seenStyles: c = new Set(),
              viewBox: l,
              markedContentData: h = null,
              disableNormalization: u = !1,
            }) {
              a ||= i.Dict.empty;
              n ||= new StateManager(new TextState());
              s && (h ||= { level: 0 });
              const d = { items: [], styles: Object.create(null) },
                f = {
                  initialized: !1,
                  str: [],
                  totalWidth: 0,
                  totalHeight: 0,
                  width: 0,
                  height: 0,
                  vertical: !1,
                  prevTransform: null,
                  textAdvanceScale: 0,
                  spaceInFlowMin: 0,
                  spaceInFlowMax: 0,
                  trackingSpaceMin: 1 / 0,
                  negativeSpaceMax: -1 / 0,
                  notASpace: -1 / 0,
                  transform: null,
                  fontName: null,
                  hasEOL: !1,
                },
                p = [" ", " "];
              let y = 0;
              function saveLastChar(e) {
                const t = (y + 1) % 2,
                  a = " " !== p[y] && " " === p[t];
                p[y] = e;
                y = t;
                return a;
              }
              function shouldAddWhitepsace() {
                return " " !== p[y] && " " === p[(y + 1) % 2];
              }
              function resetLastChars() {
                p[0] = p[1] = " ";
                y = 0;
              }
              const w = this,
                S = this.xref,
                x = [];
              let C = null;
              const k = new g.LocalImageCache(),
                v = new g.LocalGStateCache(),
                F = new EvaluatorPreprocessor(e, S, n);
              let O;
              function pushWhitespace({
                width: e = 0,
                height: t = 0,
                transform: a = f.prevTransform,
                fontName: r = f.fontName,
              }) {
                d.items.push({
                  str: " ",
                  dir: "ltr",
                  width: e,
                  height: t,
                  transform: a,
                  fontName: r,
                  hasEOL: !1,
                });
              }
              function getCurrentTextTransform() {
                const e = O.font,
                  t = [
                    O.fontSize * O.textHScale,
                    0,
                    0,
                    O.fontSize,
                    0,
                    O.textRise,
                  ];
                if (
                  e.isType3Font &&
                  (O.fontSize <= 1 || e.isCharBBox) &&
                  !(0, r.isArrayEqual)(O.fontMatrix, r.FONT_IDENTITY_MATRIX)
                ) {
                  const a = e.bbox[3] - e.bbox[1];
                  a > 0 && (t[3] *= a * O.fontMatrix[3]);
                }
                return r.Util.transform(
                  O.ctm,
                  r.Util.transform(O.textMatrix, t),
                );
              }
              function ensureTextContentItem() {
                if (f.initialized) return f;
                const { font: e, loadedName: t } = O;
                if (!c.has(t)) {
                  c.add(t);
                  d.styles[t] = {
                    fontFamily: e.fallbackName,
                    ascent: e.ascent,
                    descent: e.descent,
                    vertical: e.vertical,
                  };
                }
                f.fontName = t;
                const a = (f.transform = getCurrentTextTransform());
                if (e.vertical) {
                  f.width = f.totalWidth = Math.hypot(a[0], a[1]);
                  f.height = f.totalHeight = 0;
                  f.vertical = !0;
                } else {
                  f.width = f.totalWidth = 0;
                  f.height = f.totalHeight = Math.hypot(a[2], a[3]);
                  f.vertical = !1;
                }
                const r = Math.hypot(O.textLineMatrix[0], O.textLineMatrix[1]),
                  n = Math.hypot(O.ctm[0], O.ctm[1]);
                f.textAdvanceScale = n * r;
                const { fontSize: i } = O;
                f.trackingSpaceMin = 0.102 * i;
                f.notASpace = 0.03 * i;
                f.negativeSpaceMax = -0.2 * i;
                f.spaceInFlowMin = 0.102 * i;
                f.spaceInFlowMax = 0.6 * i;
                f.hasEOL = !1;
                f.initialized = !0;
                return f;
              }
              function updateAdvanceScale() {
                if (!f.initialized) return;
                const e = Math.hypot(O.textLineMatrix[0], O.textLineMatrix[1]),
                  t = Math.hypot(O.ctm[0], O.ctm[1]) * e;
                if (t !== f.textAdvanceScale) {
                  if (f.vertical) {
                    f.totalHeight += f.height * f.textAdvanceScale;
                    f.height = 0;
                  } else {
                    f.totalWidth += f.width * f.textAdvanceScale;
                    f.width = 0;
                  }
                  f.textAdvanceScale = t;
                }
              }
              function handleSetFont(e, n) {
                return w
                  .loadFont(e, n, a)
                  .then(function (e) {
                    return e.font.isType3Font
                      ? e
                          .loadType3Data(w, a, t)
                          .catch(function () {})
                          .then(function () {
                            return e;
                          })
                      : e;
                  })
                  .then(function (e) {
                    O.loadedName = e.loadedName;
                    O.font = e.font;
                    O.fontMatrix = e.font.fontMatrix || r.FONT_IDENTITY_MATRIX;
                  });
              }
              function applyInverseRotation(e, t, a) {
                const r = Math.hypot(a[0], a[1]);
                return [(a[0] * e + a[1] * t) / r, (a[2] * e + a[3] * t) / r];
              }
              function compareWithLastPosition(e) {
                const t = getCurrentTextTransform();
                let a = t[4],
                  r = t[5];
                if (O.font?.vertical) {
                  if (a < l[0] || a > l[2] || r + e < l[1] || r > l[3])
                    return !1;
                } else if (a + e < l[0] || a > l[2] || r < l[1] || r > l[3])
                  return !1;
                if (!O.font || !f.prevTransform) return !0;
                let n = f.prevTransform[4],
                  i = f.prevTransform[5];
                if (n === a && i === r) return !0;
                let s = -1;
                t[0] && 0 === t[1] && 0 === t[2]
                  ? (s = t[0] > 0 ? 0 : 180)
                  : t[1] &&
                    0 === t[0] &&
                    0 === t[3] &&
                    (s = t[1] > 0 ? 90 : 270);
                switch (s) {
                  case 0:
                    break;
                  case 90:
                    [a, r] = [r, a];
                    [n, i] = [i, n];
                    break;
                  case 180:
                    [a, r, n, i] = [-a, -r, -n, -i];
                    break;
                  case 270:
                    [a, r] = [-r, -a];
                    [n, i] = [-i, -n];
                    break;
                  default:
                    [a, r] = applyInverseRotation(a, r, t);
                    [n, i] = applyInverseRotation(n, i, f.prevTransform);
                }
                if (O.font.vertical) {
                  const e = (i - r) / f.textAdvanceScale,
                    t = a - n,
                    s = Math.sign(f.height);
                  if (e < s * f.negativeSpaceMax) {
                    if (Math.abs(t) > 0.5 * f.width) {
                      appendEOL();
                      return !0;
                    }
                    resetLastChars();
                    flushTextContentItem();
                    return !0;
                  }
                  if (Math.abs(t) > f.width) {
                    appendEOL();
                    return !0;
                  }
                  e <= s * f.notASpace && resetLastChars();
                  if (e <= s * f.trackingSpaceMin)
                    if (shouldAddWhitepsace()) {
                      resetLastChars();
                      flushTextContentItem();
                      pushWhitespace({ height: Math.abs(e) });
                    } else f.height += e;
                  else if (!addFakeSpaces(e, f.prevTransform, s))
                    if (0 === f.str.length) {
                      resetLastChars();
                      pushWhitespace({ height: Math.abs(e) });
                    } else f.height += e;
                  Math.abs(t) > 0.25 * f.width && flushTextContentItem();
                  return !0;
                }
                const o = (a - n) / f.textAdvanceScale,
                  c = r - i,
                  h = Math.sign(f.width);
                if (o < h * f.negativeSpaceMax) {
                  if (Math.abs(c) > 0.5 * f.height) {
                    appendEOL();
                    return !0;
                  }
                  resetLastChars();
                  flushTextContentItem();
                  return !0;
                }
                if (Math.abs(c) > f.height) {
                  appendEOL();
                  return !0;
                }
                o <= h * f.notASpace && resetLastChars();
                if (o <= h * f.trackingSpaceMin)
                  if (shouldAddWhitepsace()) {
                    resetLastChars();
                    flushTextContentItem();
                    pushWhitespace({ width: Math.abs(o) });
                  } else f.width += o;
                else if (!addFakeSpaces(o, f.prevTransform, h))
                  if (0 === f.str.length) {
                    resetLastChars();
                    pushWhitespace({ width: Math.abs(o) });
                  } else f.width += o;
                Math.abs(c) > 0.25 * f.height && flushTextContentItem();
                return !0;
              }
              function buildTextContentItem({ chars: e, extraSpacing: t }) {
                const a = O.font;
                if (!e) {
                  const e = O.charSpacing + t;
                  e &&
                    (a.vertical
                      ? O.translateTextMatrix(0, -e)
                      : O.translateTextMatrix(e * O.textHScale, 0));
                  return;
                }
                const r = a.charsToGlyphs(e),
                  n = O.fontMatrix[0] * O.fontSize;
                for (let e = 0, i = r.length; e < i; e++) {
                  const s = r[e],
                    { category: o } = s;
                  if (o.isInvisibleFormatMark) continue;
                  let c = O.charSpacing + (e + 1 === i ? t : 0),
                    l = s.width;
                  a.vertical && (l = s.vmetric ? s.vmetric[0] : -l);
                  let h = l * n;
                  if (o.isWhitespace) {
                    if (a.vertical) {
                      c += -h + O.wordSpacing;
                      O.translateTextMatrix(0, -c);
                    } else {
                      c += h + O.wordSpacing;
                      O.translateTextMatrix(c * O.textHScale, 0);
                    }
                    saveLastChar(" ");
                    continue;
                  }
                  if (!o.isZeroWidthDiacritic && !compareWithLastPosition(h)) {
                    a.vertical
                      ? O.translateTextMatrix(0, h)
                      : O.translateTextMatrix(h * O.textHScale, 0);
                    continue;
                  }
                  const u = ensureTextContentItem();
                  o.isZeroWidthDiacritic && (h = 0);
                  if (a.vertical) {
                    O.translateTextMatrix(0, h);
                    h = Math.abs(h);
                    u.height += h;
                  } else {
                    h *= O.textHScale;
                    O.translateTextMatrix(h, 0);
                    u.width += h;
                  }
                  h && (u.prevTransform = getCurrentTextTransform());
                  const d = s.unicode;
                  saveLastChar(d) && u.str.push(" ");
                  u.str.push(d);
                  c &&
                    (a.vertical
                      ? O.translateTextMatrix(0, -c)
                      : O.translateTextMatrix(c * O.textHScale, 0));
                }
              }
              function appendEOL() {
                resetLastChars();
                if (f.initialized) {
                  f.hasEOL = !0;
                  flushTextContentItem();
                } else
                  d.items.push({
                    str: "",
                    dir: "ltr",
                    width: 0,
                    height: 0,
                    transform: getCurrentTextTransform(),
                    fontName: O.loadedName,
                    hasEOL: !0,
                  });
              }
              function addFakeSpaces(e, t, a) {
                if (a * f.spaceInFlowMin <= e && e <= a * f.spaceInFlowMax) {
                  if (f.initialized) {
                    resetLastChars();
                    f.str.push(" ");
                  }
                  return !1;
                }
                const r = f.fontName;
                let n = 0;
                if (f.vertical) {
                  n = e;
                  e = 0;
                }
                flushTextContentItem();
                resetLastChars();
                pushWhitespace({
                  width: Math.abs(e),
                  height: Math.abs(n),
                  transform: t || getCurrentTextTransform(),
                  fontName: r,
                });
                return !0;
              }
              function flushTextContentItem() {
                if (f.initialized && f.str) {
                  f.vertical
                    ? (f.totalHeight += f.height * f.textAdvanceScale)
                    : (f.totalWidth += f.width * f.textAdvanceScale);
                  d.items.push(
                    (function runBidiTransform(e) {
                      let t = e.str.join("");
                      u || (t = (0, r.normalizeUnicode)(t));
                      const a = (0, b.bidi)(t, -1, e.vertical);
                      return {
                        str: a.str,
                        dir: a.dir,
                        width: Math.abs(e.totalWidth),
                        height: Math.abs(e.totalHeight),
                        transform: e.transform,
                        fontName: e.fontName,
                        hasEOL: e.hasEOL,
                      };
                    })(f),
                  );
                  f.initialized = !1;
                  f.str.length = 0;
                }
              }
              function enqueueChunk(e = !1) {
                const t = d.items.length;
                if (0 !== t && !(e && t < 10)) {
                  o.enqueue(d, t);
                  d.items = [];
                  d.styles = Object.create(null);
                }
              }
              const T = new TimeSlotManager();
              return new Promise(function promiseBody(e, f) {
                const next = function (t) {
                  enqueueChunk(!0);
                  Promise.all([t, o.ready]).then(function () {
                    try {
                      promiseBody(e, f);
                    } catch (e) {
                      f(e);
                    }
                  }, f);
                };
                t.ensureNotTerminated();
                T.reset();
                const g = {};
                let p,
                  b = [];
                for (; !(p = T.check()); ) {
                  b.length = 0;
                  g.args = b;
                  if (!F.read(g)) break;
                  const e = O;
                  O = n.state;
                  const f = g.fn;
                  b = g.args;
                  switch (0 | f) {
                    case r.OPS.setFont:
                      var y = b[0].name,
                        M = b[1];
                      if (O.font && y === O.fontName && M === O.fontSize) break;
                      flushTextContentItem();
                      O.fontName = y;
                      O.fontSize = M;
                      next(handleSetFont(y, null));
                      return;
                    case r.OPS.setTextRise:
                      O.textRise = b[0];
                      break;
                    case r.OPS.setHScale:
                      O.textHScale = b[0] / 100;
                      break;
                    case r.OPS.setLeading:
                      O.leading = b[0];
                      break;
                    case r.OPS.moveText:
                      O.translateTextLineMatrix(b[0], b[1]);
                      O.textMatrix = O.textLineMatrix.slice();
                      break;
                    case r.OPS.setLeadingMoveText:
                      O.leading = -b[1];
                      O.translateTextLineMatrix(b[0], b[1]);
                      O.textMatrix = O.textLineMatrix.slice();
                      break;
                    case r.OPS.nextLine:
                      O.carriageReturn();
                      break;
                    case r.OPS.setTextMatrix:
                      O.setTextMatrix(b[0], b[1], b[2], b[3], b[4], b[5]);
                      O.setTextLineMatrix(b[0], b[1], b[2], b[3], b[4], b[5]);
                      updateAdvanceScale();
                      break;
                    case r.OPS.setCharSpacing:
                      O.charSpacing = b[0];
                      break;
                    case r.OPS.setWordSpacing:
                      O.wordSpacing = b[0];
                      break;
                    case r.OPS.beginText:
                      O.textMatrix = r.IDENTITY_MATRIX.slice();
                      O.textLineMatrix = r.IDENTITY_MATRIX.slice();
                      break;
                    case r.OPS.showSpacedText:
                      if (!n.state.font) {
                        w.ensureStateFont(n.state);
                        continue;
                      }
                      const f = ((O.font.vertical ? 1 : -1) * O.fontSize) / 1e3,
                        g = b[0];
                      for (let e = 0, t = g.length; e < t; e++) {
                        const t = g[e];
                        if ("string" == typeof t) x.push(t);
                        else if ("number" == typeof t && 0 !== t) {
                          const e = x.join("");
                          x.length = 0;
                          buildTextContentItem({
                            chars: e,
                            extraSpacing: t * f,
                          });
                        }
                      }
                      if (x.length > 0) {
                        const e = x.join("");
                        x.length = 0;
                        buildTextContentItem({ chars: e, extraSpacing: 0 });
                      }
                      break;
                    case r.OPS.showText:
                      if (!n.state.font) {
                        w.ensureStateFont(n.state);
                        continue;
                      }
                      buildTextContentItem({ chars: b[0], extraSpacing: 0 });
                      break;
                    case r.OPS.nextLineShowText:
                      if (!n.state.font) {
                        w.ensureStateFont(n.state);
                        continue;
                      }
                      O.carriageReturn();
                      buildTextContentItem({ chars: b[0], extraSpacing: 0 });
                      break;
                    case r.OPS.nextLineSetSpacingShowText:
                      if (!n.state.font) {
                        w.ensureStateFont(n.state);
                        continue;
                      }
                      O.wordSpacing = b[0];
                      O.charSpacing = b[1];
                      O.carriageReturn();
                      buildTextContentItem({ chars: b[2], extraSpacing: 0 });
                      break;
                    case r.OPS.paintXObject:
                      flushTextContentItem();
                      C || (C = a.get("XObject") || i.Dict.empty);
                      var D = b[0] instanceof i.Name,
                        E = b[0].name;
                      if (D && k.getByName(E)) break;
                      next(
                        new Promise(function (e, d) {
                          if (!D)
                            throw new r.FormatError(
                              "XObject must be referred to by name.",
                            );
                          let f = C.getRaw(E);
                          if (f instanceof i.Ref) {
                            if (k.getByRef(f)) {
                              e();
                              return;
                            }
                            if (w.globalImageCache.getData(f, w.pageIndex)) {
                              e();
                              return;
                            }
                            f = S.fetch(f);
                          }
                          if (!(f instanceof m.BaseStream))
                            throw new r.FormatError(
                              "XObject should be a stream",
                            );
                          const g = f.dict.get("Subtype");
                          if (!(g instanceof i.Name))
                            throw new r.FormatError(
                              "XObject should have a Name subtype",
                            );
                          if ("Form" !== g.name) {
                            k.set(E, f.dict.objId, !0);
                            e();
                            return;
                          }
                          const p = n.state.clone(),
                            b = new StateManager(p),
                            y = f.dict.getArray("Matrix");
                          Array.isArray(y) && 6 === y.length && b.transform(y);
                          enqueueChunk();
                          const x = {
                            enqueueInvoked: !1,
                            enqueue(e, t) {
                              this.enqueueInvoked = !0;
                              o.enqueue(e, t);
                            },
                            get desiredSize() {
                              return o.desiredSize;
                            },
                            get ready() {
                              return o.ready;
                            },
                          };
                          w.getTextContent({
                            stream: f,
                            task: t,
                            resources: f.dict.get("Resources") || a,
                            stateManager: b,
                            includeMarkedContent: s,
                            sink: x,
                            seenStyles: c,
                            viewBox: l,
                            markedContentData: h,
                            disableNormalization: u,
                          }).then(function () {
                            x.enqueueInvoked || k.set(E, f.dict.objId, !0);
                            e();
                          }, d);
                        }).catch(function (e) {
                          if (!(e instanceof r.AbortException)) {
                            if (!w.options.ignoreErrors) throw e;
                            (0, r.warn)(
                              `getTextContent - ignoring XObject: "${e}".`,
                            );
                          }
                        }),
                      );
                      return;
                    case r.OPS.setGState:
                      D = b[0] instanceof i.Name;
                      E = b[0].name;
                      if (D && v.getByName(E)) break;
                      next(
                        new Promise(function (e, t) {
                          if (!D)
                            throw new r.FormatError(
                              "GState must be referred to by name.",
                            );
                          const n = a.get("ExtGState");
                          if (!(n instanceof i.Dict))
                            throw new r.FormatError(
                              "ExtGState should be a dictionary.",
                            );
                          const s = n.get(E);
                          if (!(s instanceof i.Dict))
                            throw new r.FormatError(
                              "GState should be a dictionary.",
                            );
                          const o = s.get("Font");
                          if (o) {
                            flushTextContentItem();
                            O.fontName = null;
                            O.fontSize = o[1];
                            handleSetFont(null, o[0]).then(e, t);
                          } else {
                            v.set(E, s.objId, !0);
                            e();
                          }
                        }).catch(function (e) {
                          if (!(e instanceof r.AbortException)) {
                            if (!w.options.ignoreErrors) throw e;
                            (0, r.warn)(
                              `getTextContent - ignoring ExtGState: "${e}".`,
                            );
                          }
                        }),
                      );
                      return;
                    case r.OPS.beginMarkedContent:
                      flushTextContentItem();
                      if (s) {
                        h.level++;
                        d.items.push({
                          type: "beginMarkedContent",
                          tag: b[0] instanceof i.Name ? b[0].name : null,
                        });
                      }
                      break;
                    case r.OPS.beginMarkedContentProps:
                      flushTextContentItem();
                      if (s) {
                        h.level++;
                        let e = null;
                        b[1] instanceof i.Dict && (e = b[1].get("MCID"));
                        d.items.push({
                          type: "beginMarkedContentProps",
                          id: Number.isInteger(e)
                            ? `${w.idFactory.getPageObjId()}_mc${e}`
                            : null,
                          tag: b[0] instanceof i.Name ? b[0].name : null,
                        });
                      }
                      break;
                    case r.OPS.endMarkedContent:
                      flushTextContentItem();
                      if (s) {
                        if (0 === h.level) break;
                        h.level--;
                        d.items.push({ type: "endMarkedContent" });
                      }
                      break;
                    case r.OPS.restore:
                      !e ||
                        (e.font === O.font &&
                          e.fontSize === O.fontSize &&
                          e.fontName === O.fontName) ||
                        flushTextContentItem();
                  }
                  if (d.items.length >= o.desiredSize) {
                    p = !0;
                    break;
                  }
                }
                if (p) next(R);
                else {
                  flushTextContentItem();
                  enqueueChunk();
                  e();
                }
              }).catch((e) => {
                if (!(e instanceof r.AbortException)) {
                  if (!this.options.ignoreErrors) throw e;
                  (0, r.warn)(
                    `getTextContent - ignoring errors during "${t.name}" task: "${e}".`,
                  );
                  flushTextContentItem();
                  enqueueChunk();
                }
              });
            }
            extractDataStructures(e, t, a) {
              const n = this.xref;
              let s;
              const l = this.readToUnicode(
                a.toUnicode || e.get("ToUnicode") || t.get("ToUnicode"),
              );
              if (a.composite) {
                const t = e.get("CIDSystemInfo");
                t instanceof i.Dict &&
                  (a.cidSystemInfo = {
                    registry: (0, r.stringToPDFString)(t.get("Registry")),
                    ordering: (0, r.stringToPDFString)(t.get("Ordering")),
                    supplement: t.get("Supplement"),
                  });
                try {
                  const t = e.get("CIDToGIDMap");
                  t instanceof m.BaseStream && (s = t.getBytes());
                } catch (e) {
                  if (!this.options.ignoreErrors) throw e;
                  (0, r.warn)(
                    `extractDataStructures - ignoring CIDToGIDMap data: "${e}".`,
                  );
                }
              }
              const h = [];
              let u,
                d = null;
              if (e.has("Encoding")) {
                u = e.get("Encoding");
                if (u instanceof i.Dict) {
                  d = u.get("BaseEncoding");
                  d = d instanceof i.Name ? d.name : null;
                  if (u.has("Differences")) {
                    const e = u.get("Differences");
                    let t = 0;
                    for (const a of e) {
                      const e = n.fetchIfRef(a);
                      if ("number" == typeof e) t = e;
                      else {
                        if (!(e instanceof i.Name))
                          throw new r.FormatError(
                            `Invalid entry in 'Differences' array: ${e}`,
                          );
                        h[t++] = e.name;
                      }
                    }
                  }
                } else if (u instanceof i.Name) d = u.name;
                else {
                  const e = "Encoding is not a Name nor a Dict";
                  if (!this.options.ignoreErrors) throw new r.FormatError(e);
                  (0, r.warn)(e);
                }
                "MacRomanEncoding" !== d &&
                  "MacExpertEncoding" !== d &&
                  "WinAnsiEncoding" !== d &&
                  (d = null);
              }
              const f = !a.file || a.isInternalFont,
                g = (0, c.getSymbolsFonts)()[a.name];
              d && f && g && (d = null);
              if (d) a.defaultEncoding = (0, o.getEncoding)(d);
              else {
                const e = !!(a.flags & S.FontFlags.Symbolic),
                  t = !!(a.flags & S.FontFlags.Nonsymbolic);
                u = o.StandardEncoding;
                "TrueType" !== a.type || t || (u = o.WinAnsiEncoding);
                if (e || g) {
                  u = o.MacRomanEncoding;
                  f &&
                    (/Symbol/i.test(a.name)
                      ? (u = o.SymbolSetEncoding)
                      : /Dingbats/i.test(a.name)
                        ? (u = o.ZapfDingbatsEncoding)
                        : /Wingdings/i.test(a.name) && (u = o.WinAnsiEncoding));
                }
                a.defaultEncoding = u;
              }
              a.differences = h;
              a.baseEncodingName = d;
              a.hasEncoding = !!d || h.length > 0;
              a.dict = e;
              return l
                .then((e) => {
                  a.toUnicode = e;
                  return this.buildToUnicode(a);
                })
                .then((e) => {
                  a.toUnicode = e;
                  s && (a.cidToGidMap = this.readCidToGidMap(s, e));
                  return a;
                });
            }
            _simpleFontToUnicode(e, t = !1) {
              (0, r.assert)(!e.composite, "Must be a simple font.");
              const a = [],
                n = e.defaultEncoding.slice(),
                i = e.baseEncodingName,
                s = e.differences;
              for (const e in s) {
                const t = s[e];
                ".notdef" !== t && (n[e] = t);
              }
              const c = (0, C.getGlyphsUnicode)();
              for (const r in n) {
                let s = n[r];
                if ("" === s) continue;
                let l = c[s];
                if (void 0 !== l) {
                  a[r] = String.fromCharCode(l);
                  continue;
                }
                let h = 0;
                switch (s[0]) {
                  case "G":
                    3 === s.length && (h = parseInt(s.substring(1), 16));
                    break;
                  case "g":
                    5 === s.length && (h = parseInt(s.substring(1), 16));
                    break;
                  case "C":
                  case "c":
                    if (s.length >= 3 && s.length <= 4) {
                      const a = s.substring(1);
                      if (t) {
                        h = parseInt(a, 16);
                        break;
                      }
                      h = +a;
                      if (Number.isNaN(h) && Number.isInteger(parseInt(a, 16)))
                        return this._simpleFontToUnicode(e, !0);
                    }
                    break;
                  case "u":
                    l = (0, v.getUnicodeForGlyph)(s, c);
                    -1 !== l && (h = l);
                    break;
                  default:
                    switch (s) {
                      case "f_h":
                      case "f_t":
                      case "T_h":
                        a[r] = s.replaceAll("_", "");
                        continue;
                    }
                }
                if (h > 0 && h <= 1114111 && Number.isInteger(h)) {
                  if (i && h === +r) {
                    const e = (0, o.getEncoding)(i);
                    if (e && (s = e[r])) {
                      a[r] = String.fromCharCode(c[s]);
                      continue;
                    }
                  }
                  a[r] = String.fromCodePoint(h);
                }
              }
              return a;
            }
            async buildToUnicode(e) {
              e.hasIncludedToUnicodeMap = e.toUnicode?.length > 0;
              if (e.hasIncludedToUnicodeMap) {
                !e.composite &&
                  e.hasEncoding &&
                  (e.fallbackToUnicode = this._simpleFontToUnicode(e));
                return e.toUnicode;
              }
              if (!e.composite)
                return new u.ToUnicodeMap(this._simpleFontToUnicode(e));
              if (
                e.composite &&
                ((e.cMap.builtInCMap && !(e.cMap instanceof n.IdentityCMap)) ||
                  ("Adobe" === e.cidSystemInfo.registry &&
                    ("GB1" === e.cidSystemInfo.ordering ||
                      "CNS1" === e.cidSystemInfo.ordering ||
                      "Japan1" === e.cidSystemInfo.ordering ||
                      "Korea1" === e.cidSystemInfo.ordering)))
              ) {
                const { registry: t, ordering: a } = e.cidSystemInfo,
                  s = i.Name.get(`${t}-${a}-UCS2`),
                  o = await n.CMapFactory.create({
                    encoding: s,
                    fetchBuiltInCMap: this._fetchBuiltInCMapBound,
                    useCMap: null,
                  }),
                  c = [],
                  l = [];
                e.cMap.forEach(function (e, t) {
                  if (t > 65535)
                    throw new r.FormatError("Max size of CID is 65,535");
                  const a = o.lookup(t);
                  if (a) {
                    l.length = 0;
                    for (let e = 0, t = a.length; e < t; e += 2)
                      l.push((a.charCodeAt(e) << 8) + a.charCodeAt(e + 1));
                    c[e] = String.fromCharCode(...l);
                  }
                });
                return new u.ToUnicodeMap(c);
              }
              return new u.IdentityToUnicodeMap(e.firstChar, e.lastChar);
            }
            readToUnicode(e) {
              return e
                ? e instanceof i.Name
                  ? n.CMapFactory.create({
                      encoding: e,
                      fetchBuiltInCMap: this._fetchBuiltInCMapBound,
                      useCMap: null,
                    }).then(function (e) {
                      return e instanceof n.IdentityCMap
                        ? new u.IdentityToUnicodeMap(0, 65535)
                        : new u.ToUnicodeMap(e.getMap());
                    })
                  : e instanceof m.BaseStream
                    ? n.CMapFactory.create({
                        encoding: e,
                        fetchBuiltInCMap: this._fetchBuiltInCMapBound,
                        useCMap: null,
                      }).then(
                        function (e) {
                          if (e instanceof n.IdentityCMap)
                            return new u.IdentityToUnicodeMap(0, 65535);
                          const t = new Array(e.length);
                          e.forEach(function (e, a) {
                            if ("number" == typeof a) {
                              t[e] = String.fromCodePoint(a);
                              return;
                            }
                            const r = [];
                            for (let e = 0; e < a.length; e += 2) {
                              const t =
                                (a.charCodeAt(e) << 8) | a.charCodeAt(e + 1);
                              if (55296 != (63488 & t)) {
                                r.push(t);
                                continue;
                              }
                              e += 2;
                              const n =
                                (a.charCodeAt(e) << 8) | a.charCodeAt(e + 1);
                              r.push(((1023 & t) << 10) + (1023 & n) + 65536);
                            }
                            t[e] = String.fromCodePoint(...r);
                          });
                          return new u.ToUnicodeMap(t);
                        },
                        (e) => {
                          if (e instanceof r.AbortException) return null;
                          if (this.options.ignoreErrors) {
                            (0, r.warn)(
                              `readToUnicode - ignoring ToUnicode data: "${e}".`,
                            );
                            return null;
                          }
                          throw e;
                        },
                      )
                    : Promise.resolve(null)
                : Promise.resolve(null);
            }
            readCidToGidMap(e, t) {
              const a = [];
              for (let r = 0, n = e.length; r < n; r++) {
                const n = (e[r++] << 8) | e[r],
                  i = r >> 1;
                (0 !== n || t.has(i)) && (a[i] = n);
              }
              return a;
            }
            extractWidths(e, t, a) {
              const r = this.xref;
              let n = [],
                s = 0;
              const o = [];
              let c, l, h, u, d, f, g, p;
              if (a.composite) {
                s = e.has("DW") ? e.get("DW") : 1e3;
                p = e.get("W");
                if (p)
                  for (l = 0, h = p.length; l < h; l++) {
                    f = r.fetchIfRef(p[l++]);
                    g = r.fetchIfRef(p[l]);
                    if (Array.isArray(g))
                      for (u = 0, d = g.length; u < d; u++)
                        n[f++] = r.fetchIfRef(g[u]);
                    else {
                      const e = r.fetchIfRef(p[++l]);
                      for (u = f; u <= g; u++) n[u] = e;
                    }
                  }
                if (a.vertical) {
                  let t = e.getArray("DW2") || [880, -1e3];
                  c = [t[1], 0.5 * s, t[0]];
                  t = e.get("W2");
                  if (t)
                    for (l = 0, h = t.length; l < h; l++) {
                      f = r.fetchIfRef(t[l++]);
                      g = r.fetchIfRef(t[l]);
                      if (Array.isArray(g))
                        for (u = 0, d = g.length; u < d; u++)
                          o[f++] = [
                            r.fetchIfRef(g[u++]),
                            r.fetchIfRef(g[u++]),
                            r.fetchIfRef(g[u]),
                          ];
                      else {
                        const e = [
                          r.fetchIfRef(t[++l]),
                          r.fetchIfRef(t[++l]),
                          r.fetchIfRef(t[++l]),
                        ];
                        for (u = f; u <= g; u++) o[u] = e;
                      }
                    }
                }
              } else {
                const o = a.firstChar;
                p = e.get("Widths");
                if (p) {
                  u = o;
                  for (l = 0, h = p.length; l < h; l++)
                    n[u++] = r.fetchIfRef(p[l]);
                  s = parseFloat(t.get("MissingWidth")) || 0;
                } else {
                  const t = e.get("BaseFont");
                  if (t instanceof i.Name) {
                    const e = this.getBaseFontMetrics(t.name);
                    n = this.buildCharCodeToWidth(e.widths, a);
                    s = e.defaultWidth;
                  }
                }
              }
              let m = !0,
                b = s;
              for (const e in n) {
                const t = n[e];
                if (t)
                  if (b) {
                    if (b !== t) {
                      m = !1;
                      break;
                    }
                  } else b = t;
              }
              m
                ? (a.flags |= S.FontFlags.FixedPitch)
                : (a.flags &= ~S.FontFlags.FixedPitch);
              a.defaultWidth = s;
              a.widths = n;
              a.defaultVMetrics = c;
              a.vmetrics = o;
            }
            isSerifFont(e) {
              const t = e.split("-")[0];
              return t in (0, c.getSerifFonts)() || /serif/gi.test(t);
            }
            getBaseFontMetrics(e) {
              let t = 0,
                a = Object.create(null),
                r = !1;
              let n = (0, c.getStdFontMap)()[e] || e;
              const i = (0, k.getMetrics)();
              n in i || (n = this.isSerifFont(e) ? "Times-Roman" : "Helvetica");
              const s = i[n];
              if ("number" == typeof s) {
                t = s;
                r = !0;
              } else a = s();
              return { defaultWidth: t, monospace: r, widths: a };
            }
            buildCharCodeToWidth(e, t) {
              const a = Object.create(null),
                r = t.differences,
                n = t.defaultEncoding;
              for (let t = 0; t < 256; t++)
                t in r && e[r[t]]
                  ? (a[t] = e[r[t]])
                  : t in n && e[n[t]] && (a[t] = e[n[t]]);
              return a;
            }
            preEvaluateFont(e) {
              const t = e;
              let a = e.get("Subtype");
              if (!(a instanceof i.Name))
                throw new r.FormatError("invalid font Subtype");
              let n,
                s,
                o = !1;
              if ("Type0" === a.name) {
                const t = e.get("DescendantFonts");
                if (!t)
                  throw new r.FormatError("Descendant fonts are not specified");
                if (
                  !(
                    (e = Array.isArray(t)
                      ? this.xref.fetchIfRef(t[0])
                      : t) instanceof i.Dict
                  )
                )
                  throw new r.FormatError(
                    "Descendant font is not a dictionary.",
                  );
                a = e.get("Subtype");
                if (!(a instanceof i.Name))
                  throw new r.FormatError("invalid font Subtype");
                o = !0;
              }
              const c = e.get("FirstChar") || 0,
                l = e.get("LastChar") || (o ? 65535 : 255),
                h = e.get("FontDescriptor");
              if (h) {
                n = new O.MurmurHash3_64();
                const a = t.getRaw("Encoding");
                if (a instanceof i.Name) n.update(a.name);
                else if (a instanceof i.Ref) n.update(a.toString());
                else if (a instanceof i.Dict)
                  for (const e of a.getRawValues())
                    if (e instanceof i.Name) n.update(e.name);
                    else if (e instanceof i.Ref) n.update(e.toString());
                    else if (Array.isArray(e)) {
                      const t = e.length,
                        a = new Array(t);
                      for (let r = 0; r < t; r++) {
                        const t = e[r];
                        t instanceof i.Name
                          ? (a[r] = t.name)
                          : ("number" == typeof t || t instanceof i.Ref) &&
                            (a[r] = t.toString());
                      }
                      n.update(a.join());
                    }
                n.update(`${c}-${l}`);
                s = e.get("ToUnicode") || t.get("ToUnicode");
                if (s instanceof m.BaseStream) {
                  const e = s.str || s,
                    t = e.buffer
                      ? new Uint8Array(e.buffer.buffer, 0, e.bufferLength)
                      : new Uint8Array(
                          e.bytes.buffer,
                          e.start,
                          e.end - e.start,
                        );
                  n.update(t);
                } else s instanceof i.Name && n.update(s.name);
                const r = e.get("Widths") || t.get("Widths");
                if (Array.isArray(r)) {
                  const e = [];
                  for (const t of r)
                    ("number" == typeof t || t instanceof i.Ref) &&
                      e.push(t.toString());
                  n.update(e.join());
                }
                if (o) {
                  n.update("compositeFont");
                  const a = e.get("W") || t.get("W");
                  if (Array.isArray(a)) {
                    const e = [];
                    for (const t of a)
                      if ("number" == typeof t || t instanceof i.Ref)
                        e.push(t.toString());
                      else if (Array.isArray(t)) {
                        const a = [];
                        for (const e of t)
                          ("number" == typeof e || e instanceof i.Ref) &&
                            a.push(e.toString());
                        e.push(`[${a.join()}]`);
                      }
                    n.update(e.join());
                  }
                  const r = e.getRaw("CIDToGIDMap") || t.getRaw("CIDToGIDMap");
                  r instanceof i.Name
                    ? n.update(r.name)
                    : r instanceof i.Ref
                      ? n.update(r.toString())
                      : r instanceof m.BaseStream && n.update(r.peekBytes());
                }
              }
              return {
                descriptor: h,
                dict: e,
                baseDict: t,
                composite: o,
                type: a.name,
                firstChar: c,
                lastChar: l,
                toUnicode: s,
                hash: n ? n.hexdigest() : "",
              };
            }
            async translateFont({
              descriptor: e,
              dict: t,
              baseDict: a,
              composite: o,
              type: l,
              firstChar: u,
              lastChar: d,
              toUnicode: f,
              cssFontInfo: g,
            }) {
              const m = "Type3" === l;
              let b;
              if (!e) {
                if (!m) {
                  let e = t.get("BaseFont");
                  if (!(e instanceof i.Name))
                    throw new r.FormatError("Base font is not specified");
                  e = e.name.replaceAll(/[,_]/g, "-");
                  const n = this.getBaseFontMetrics(e),
                    o = e.split("-")[0],
                    h =
                      (this.isSerifFont(o) ? S.FontFlags.Serif : 0) |
                      (n.monospace ? S.FontFlags.FixedPitch : 0) |
                      ((0, c.getSymbolsFonts)()[o]
                        ? S.FontFlags.Symbolic
                        : S.FontFlags.Nonsymbolic);
                  b = {
                    type: l,
                    name: e,
                    loadedName: a.loadedName,
                    systemFontInfo: null,
                    widths: n.widths,
                    defaultWidth: n.defaultWidth,
                    isSimulatedFlags: !0,
                    flags: h,
                    firstChar: u,
                    lastChar: d,
                    toUnicode: f,
                    xHeight: 0,
                    capHeight: 0,
                    italicAngle: 0,
                    isType3Font: m,
                  };
                  const g = t.get("Widths"),
                    p = (0, c.getStandardFontName)(e);
                  let y = null;
                  if (p) {
                    y = await this.fetchStandardFontData(p);
                    b.isInternalFont = !!y;
                  }
                  !b.isInternalFont &&
                    this.options.useSystemFonts &&
                    (b.systemFontInfo = (0, x.getFontSubstitution)(
                      this.systemFontCache,
                      this.idFactory,
                      this.options.standardFontDataUrl,
                      e,
                      p,
                    ));
                  return this.extractDataStructures(t, t, b).then((t) => {
                    if (g) {
                      const e = [];
                      let a = u;
                      for (const t of g) e[a++] = this.xref.fetchIfRef(t);
                      t.widths = e;
                    } else t.widths = this.buildCharCodeToWidth(n.widths, t);
                    return new s.Font(e, y, t);
                  });
                }
                (e = new i.Dict(null)).set("FontName", i.Name.get(l));
                e.set("FontBBox", t.getArray("FontBBox") || [0, 0, 0, 0]);
              }
              let y = e.get("FontName"),
                w = t.get("BaseFont");
              "string" == typeof y && (y = i.Name.get(y));
              "string" == typeof w && (w = i.Name.get(w));
              const C = y?.name,
                k = w?.name;
              if (!m && C !== k) {
                (0, r.info)(
                  `The FontDescriptor's FontName is "${C}" but should be the same as the Font's BaseFont "${k}".`,
                );
                C &&
                  k &&
                  (k.startsWith(C) ||
                    (!(0, c.isKnownFontName)(C) &&
                      (0, c.isKnownFontName)(k))) &&
                  (y = null);
              }
              y ||= w;
              if (!(y instanceof i.Name))
                throw new r.FormatError("invalid font name");
              let v, F, O, T, M;
              try {
                v = e.get("FontFile", "FontFile2", "FontFile3");
              } catch (e) {
                if (!this.options.ignoreErrors) throw e;
                (0, r.warn)(
                  `translateFont - fetching "${y.name}" font file: "${e}".`,
                );
                v = new p.NullStream();
              }
              let D = !1,
                E = null,
                N = null;
              if (v) {
                if (v.dict) {
                  const e = v.dict.get("Subtype");
                  e instanceof i.Name && (F = e.name);
                  O = v.dict.get("Length1");
                  T = v.dict.get("Length2");
                  M = v.dict.get("Length3");
                }
              } else if (g) {
                const e = (0, h.getXfaFontName)(y.name);
                if (e) {
                  g.fontFamily = `${g.fontFamily}-PdfJS-XFA`;
                  g.metrics = e.metrics || null;
                  E = e.factors || null;
                  v = await this.fetchStandardFontData(e.name);
                  D = !!v;
                  a = t = (0, h.getXfaFontDict)(y.name);
                  o = !0;
                }
              } else if (!m) {
                const e = (0, c.getStandardFontName)(y.name);
                if (e) {
                  v = await this.fetchStandardFontData(e);
                  D = !!v;
                }
                !D &&
                  this.options.useSystemFonts &&
                  (N = (0, x.getFontSubstitution)(
                    this.systemFontCache,
                    this.idFactory,
                    this.options.standardFontDataUrl,
                    y.name,
                    e,
                  ));
              }
              b = {
                type: l,
                name: y.name,
                subtype: F,
                file: v,
                length1: O,
                length2: T,
                length3: M,
                isInternalFont: D,
                loadedName: a.loadedName,
                composite: o,
                fixedPitch: !1,
                fontMatrix: t.getArray("FontMatrix") || r.FONT_IDENTITY_MATRIX,
                firstChar: u,
                lastChar: d,
                toUnicode: f,
                bbox: e.getArray("FontBBox") || t.getArray("FontBBox"),
                ascent: e.get("Ascent"),
                descent: e.get("Descent"),
                xHeight: e.get("XHeight") || 0,
                capHeight: e.get("CapHeight") || 0,
                flags: e.get("Flags"),
                italicAngle: e.get("ItalicAngle") || 0,
                isType3Font: m,
                cssFontInfo: g,
                scaleFactors: E,
                systemFontInfo: N,
              };
              if (o) {
                const e = a.get("Encoding");
                e instanceof i.Name && (b.cidEncoding = e.name);
                const t = await n.CMapFactory.create({
                  encoding: e,
                  fetchBuiltInCMap: this._fetchBuiltInCMapBound,
                  useCMap: null,
                });
                b.cMap = t;
                b.vertical = b.cMap.vertical;
              }
              return this.extractDataStructures(t, a, b).then((a) => {
                this.extractWidths(t, e, a);
                return new s.Font(y.name, v, a);
              });
            }
            static buildFontPaths(e, t, a, n) {
              function buildPath(t) {
                const i = `${e.loadedName}_path_${t}`;
                try {
                  if (e.renderer.hasBuiltPath(t)) return;
                  a.send("commonobj", [i, "FontPath", e.renderer.getPathJs(t)]);
                } catch (e) {
                  if (n.ignoreErrors) {
                    (0, r.warn)(
                      `buildFontPaths - ignoring ${i} glyph: "${e}".`,
                    );
                    return;
                  }
                  throw e;
                }
              }
              for (const e of t) {
                buildPath(e.fontChar);
                const t = e.accent;
                t?.fontChar && buildPath(t.fontChar);
              }
            }
            static get fallbackFontDict() {
              const e = new i.Dict();
              e.set("BaseFont", i.Name.get("Helvetica"));
              e.set("Type", i.Name.get("FallbackType"));
              e.set("Subtype", i.Name.get("FallbackType"));
              e.set("Encoding", i.Name.get("WinAnsiEncoding"));
              return (0, r.shadow)(this, "fallbackFontDict", e);
            }
          }
          t.PartialEvaluator = PartialEvaluator;
          class TranslatedFont {
            constructor({
              loadedName: e,
              font: t,
              dict: a,
              evaluatorOptions: r,
            }) {
              this.loadedName = e;
              this.font = t;
              this.dict = a;
              this._evaluatorOptions = r || D;
              this.type3Loaded = null;
              this.type3Dependencies = t.isType3Font ? new Set() : null;
              this.sent = !1;
            }
            send(e) {
              if (!this.sent) {
                this.sent = !0;
                e.send("commonobj", [
                  this.loadedName,
                  "Font",
                  this.font.exportData(
                    this._evaluatorOptions.fontExtraProperties,
                  ),
                ]);
              }
            }
            fallback(e) {
              if (this.font.data) {
                this.font.disableFontFace = !0;
                PartialEvaluator.buildFontPaths(
                  this.font,
                  this.font.glyphCacheValues,
                  e,
                  this._evaluatorOptions,
                );
              }
            }
            loadType3Data(e, t, a) {
              if (this.type3Loaded) return this.type3Loaded;
              if (!this.font.isType3Font)
                throw new Error("Must be a Type3 font.");
              const n = e.clone({ ignoreErrors: !1 });
              n.parsingType3Font = !0;
              const s = new i.RefSet(e.type3FontRefs);
              this.dict.objId &&
                !s.has(this.dict.objId) &&
                s.put(this.dict.objId);
              n.type3FontRefs = s;
              const o = this.font,
                c = this.type3Dependencies;
              let l = Promise.resolve();
              const h = this.dict.get("CharProcs"),
                u = this.dict.get("Resources") || t,
                d = Object.create(null),
                f = r.Util.normalizeRect(o.bbox || [0, 0, 0, 0]),
                g = f[2] - f[0],
                p = f[3] - f[1],
                m = Math.hypot(g, p);
              for (const e of h.getKeys())
                l = l.then(() => {
                  const t = h.get(e),
                    i = new T.OperatorList();
                  return n
                    .getOperatorList({
                      stream: t,
                      task: a,
                      resources: u,
                      operatorList: i,
                    })
                    .then(() => {
                      i.fnArray[0] === r.OPS.setCharWidthAndBounds &&
                        this._removeType3ColorOperators(i, m);
                      d[e] = i.getIR();
                      for (const e of i.dependencies) c.add(e);
                    })
                    .catch(function (t) {
                      (0, r.warn)(
                        `Type3 font resource "${e}" is not available.`,
                      );
                      const a = new T.OperatorList();
                      d[e] = a.getIR();
                    });
                });
              this.type3Loaded = l.then(() => {
                o.charProcOperatorList = d;
                if (this._bbox) {
                  o.isCharBBox = !0;
                  o.bbox = this._bbox;
                }
              });
              return this.type3Loaded;
            }
            _removeType3ColorOperators(e, t = NaN) {
              const a = r.Util.normalizeRect(e.argsArray[0].slice(2)),
                n = a[2] - a[0],
                i = a[3] - a[1],
                s = Math.hypot(n, i);
              if (0 === n || 0 === i) {
                e.fnArray.splice(0, 1);
                e.argsArray.splice(0, 1);
              } else if (0 === t || Math.round(s / t) >= 10) {
                this._bbox || (this._bbox = [1 / 0, 1 / 0, -1 / 0, -1 / 0]);
                this._bbox[0] = Math.min(this._bbox[0], a[0]);
                this._bbox[1] = Math.min(this._bbox[1], a[1]);
                this._bbox[2] = Math.max(this._bbox[2], a[2]);
                this._bbox[3] = Math.max(this._bbox[3], a[3]);
              }
              let o = 0,
                c = e.length;
              for (; o < c; ) {
                switch (e.fnArray[o]) {
                  case r.OPS.setCharWidthAndBounds:
                    break;
                  case r.OPS.setStrokeColorSpace:
                  case r.OPS.setFillColorSpace:
                  case r.OPS.setStrokeColor:
                  case r.OPS.setStrokeColorN:
                  case r.OPS.setFillColor:
                  case r.OPS.setFillColorN:
                  case r.OPS.setStrokeGray:
                  case r.OPS.setFillGray:
                  case r.OPS.setStrokeRGBColor:
                  case r.OPS.setFillRGBColor:
                  case r.OPS.setStrokeCMYKColor:
                  case r.OPS.setFillCMYKColor:
                  case r.OPS.shadingFill:
                  case r.OPS.setRenderingIntent:
                    e.fnArray.splice(o, 1);
                    e.argsArray.splice(o, 1);
                    c--;
                    continue;
                  case r.OPS.setGState:
                    const [t] = e.argsArray[o];
                    let a = 0,
                      n = t.length;
                    for (; a < n; ) {
                      const [e] = t[a];
                      switch (e) {
                        case "TR":
                        case "TR2":
                        case "HT":
                        case "BG":
                        case "BG2":
                        case "UCR":
                        case "UCR2":
                          t.splice(a, 1);
                          n--;
                          continue;
                      }
                      a++;
                    }
                }
                o++;
              }
            }
          }
          class StateManager {
            constructor(e = new EvalState()) {
              this.state = e;
              this.stateStack = [];
            }
            save() {
              const e = this.state;
              this.stateStack.push(this.state);
              this.state = e.clone();
            }
            restore() {
              const e = this.stateStack.pop();
              e && (this.state = e);
            }
            transform(e) {
              this.state.ctm = r.Util.transform(this.state.ctm, e);
            }
          }
          class TextState {
            constructor() {
              this.ctm = new Float32Array(r.IDENTITY_MATRIX);
              this.fontName = null;
              this.fontSize = 0;
              this.loadedName = null;
              this.font = null;
              this.fontMatrix = r.FONT_IDENTITY_MATRIX;
              this.textMatrix = r.IDENTITY_MATRIX.slice();
              this.textLineMatrix = r.IDENTITY_MATRIX.slice();
              this.charSpacing = 0;
              this.wordSpacing = 0;
              this.leading = 0;
              this.textHScale = 1;
              this.textRise = 0;
            }
            setTextMatrix(e, t, a, r, n, i) {
              const s = this.textMatrix;
              s[0] = e;
              s[1] = t;
              s[2] = a;
              s[3] = r;
              s[4] = n;
              s[5] = i;
            }
            setTextLineMatrix(e, t, a, r, n, i) {
              const s = this.textLineMatrix;
              s[0] = e;
              s[1] = t;
              s[2] = a;
              s[3] = r;
              s[4] = n;
              s[5] = i;
            }
            translateTextMatrix(e, t) {
              const a = this.textMatrix;
              a[4] = a[0] * e + a[2] * t + a[4];
              a[5] = a[1] * e + a[3] * t + a[5];
            }
            translateTextLineMatrix(e, t) {
              const a = this.textLineMatrix;
              a[4] = a[0] * e + a[2] * t + a[4];
              a[5] = a[1] * e + a[3] * t + a[5];
            }
            carriageReturn() {
              this.translateTextLineMatrix(0, -this.leading);
              this.textMatrix = this.textLineMatrix.slice();
            }
            clone() {
              const e = Object.create(this);
              e.textMatrix = this.textMatrix.slice();
              e.textLineMatrix = this.textLineMatrix.slice();
              e.fontMatrix = this.fontMatrix.slice();
              return e;
            }
          }
          class EvalState {
            constructor() {
              this.ctm = new Float32Array(r.IDENTITY_MATRIX);
              this.font = null;
              this.textRenderingMode = r.TextRenderingMode.FILL;
              this.fillColorSpace = y.ColorSpace.singletons.gray;
              this.strokeColorSpace = y.ColorSpace.singletons.gray;
            }
            clone() {
              return Object.create(this);
            }
          }
          class EvaluatorPreprocessor {
            static get opMap() {
              return (0, r.shadow)(this, "opMap", {
                w: { id: r.OPS.setLineWidth, numArgs: 1, variableArgs: !1 },
                J: { id: r.OPS.setLineCap, numArgs: 1, variableArgs: !1 },
                j: { id: r.OPS.setLineJoin, numArgs: 1, variableArgs: !1 },
                M: { id: r.OPS.setMiterLimit, numArgs: 1, variableArgs: !1 },
                d: { id: r.OPS.setDash, numArgs: 2, variableArgs: !1 },
                ri: {
                  id: r.OPS.setRenderingIntent,
                  numArgs: 1,
                  variableArgs: !1,
                },
                i: { id: r.OPS.setFlatness, numArgs: 1, variableArgs: !1 },
                gs: { id: r.OPS.setGState, numArgs: 1, variableArgs: !1 },
                q: { id: r.OPS.save, numArgs: 0, variableArgs: !1 },
                Q: { id: r.OPS.restore, numArgs: 0, variableArgs: !1 },
                cm: { id: r.OPS.transform, numArgs: 6, variableArgs: !1 },
                m: { id: r.OPS.moveTo, numArgs: 2, variableArgs: !1 },
                l: { id: r.OPS.lineTo, numArgs: 2, variableArgs: !1 },
                c: { id: r.OPS.curveTo, numArgs: 6, variableArgs: !1 },
                v: { id: r.OPS.curveTo2, numArgs: 4, variableArgs: !1 },
                y: { id: r.OPS.curveTo3, numArgs: 4, variableArgs: !1 },
                h: { id: r.OPS.closePath, numArgs: 0, variableArgs: !1 },
                re: { id: r.OPS.rectangle, numArgs: 4, variableArgs: !1 },
                S: { id: r.OPS.stroke, numArgs: 0, variableArgs: !1 },
                s: { id: r.OPS.closeStroke, numArgs: 0, variableArgs: !1 },
                f: { id: r.OPS.fill, numArgs: 0, variableArgs: !1 },
                F: { id: r.OPS.fill, numArgs: 0, variableArgs: !1 },
                "f*": { id: r.OPS.eoFill, numArgs: 0, variableArgs: !1 },
                B: { id: r.OPS.fillStroke, numArgs: 0, variableArgs: !1 },
                "B*": { id: r.OPS.eoFillStroke, numArgs: 0, variableArgs: !1 },
                b: { id: r.OPS.closeFillStroke, numArgs: 0, variableArgs: !1 },
                "b*": {
                  id: r.OPS.closeEOFillStroke,
                  numArgs: 0,
                  variableArgs: !1,
                },
                n: { id: r.OPS.endPath, numArgs: 0, variableArgs: !1 },
                W: { id: r.OPS.clip, numArgs: 0, variableArgs: !1 },
                "W*": { id: r.OPS.eoClip, numArgs: 0, variableArgs: !1 },
                BT: { id: r.OPS.beginText, numArgs: 0, variableArgs: !1 },
                ET: { id: r.OPS.endText, numArgs: 0, variableArgs: !1 },
                Tc: { id: r.OPS.setCharSpacing, numArgs: 1, variableArgs: !1 },
                Tw: { id: r.OPS.setWordSpacing, numArgs: 1, variableArgs: !1 },
                Tz: { id: r.OPS.setHScale, numArgs: 1, variableArgs: !1 },
                TL: { id: r.OPS.setLeading, numArgs: 1, variableArgs: !1 },
                Tf: { id: r.OPS.setFont, numArgs: 2, variableArgs: !1 },
                Tr: {
                  id: r.OPS.setTextRenderingMode,
                  numArgs: 1,
                  variableArgs: !1,
                },
                Ts: { id: r.OPS.setTextRise, numArgs: 1, variableArgs: !1 },
                Td: { id: r.OPS.moveText, numArgs: 2, variableArgs: !1 },
                TD: {
                  id: r.OPS.setLeadingMoveText,
                  numArgs: 2,
                  variableArgs: !1,
                },
                Tm: { id: r.OPS.setTextMatrix, numArgs: 6, variableArgs: !1 },
                "T*": { id: r.OPS.nextLine, numArgs: 0, variableArgs: !1 },
                Tj: { id: r.OPS.showText, numArgs: 1, variableArgs: !1 },
                TJ: { id: r.OPS.showSpacedText, numArgs: 1, variableArgs: !1 },
                "'": {
                  id: r.OPS.nextLineShowText,
                  numArgs: 1,
                  variableArgs: !1,
                },
                '"': {
                  id: r.OPS.nextLineSetSpacingShowText,
                  numArgs: 3,
                  variableArgs: !1,
                },
                d0: { id: r.OPS.setCharWidth, numArgs: 2, variableArgs: !1 },
                d1: {
                  id: r.OPS.setCharWidthAndBounds,
                  numArgs: 6,
                  variableArgs: !1,
                },
                CS: {
                  id: r.OPS.setStrokeColorSpace,
                  numArgs: 1,
                  variableArgs: !1,
                },
                cs: {
                  id: r.OPS.setFillColorSpace,
                  numArgs: 1,
                  variableArgs: !1,
                },
                SC: { id: r.OPS.setStrokeColor, numArgs: 4, variableArgs: !0 },
                SCN: {
                  id: r.OPS.setStrokeColorN,
                  numArgs: 33,
                  variableArgs: !0,
                },
                sc: { id: r.OPS.setFillColor, numArgs: 4, variableArgs: !0 },
                scn: { id: r.OPS.setFillColorN, numArgs: 33, variableArgs: !0 },
                G: { id: r.OPS.setStrokeGray, numArgs: 1, variableArgs: !1 },
                g: { id: r.OPS.setFillGray, numArgs: 1, variableArgs: !1 },
                RG: {
                  id: r.OPS.setStrokeRGBColor,
                  numArgs: 3,
                  variableArgs: !1,
                },
                rg: { id: r.OPS.setFillRGBColor, numArgs: 3, variableArgs: !1 },
                K: {
                  id: r.OPS.setStrokeCMYKColor,
                  numArgs: 4,
                  variableArgs: !1,
                },
                k: { id: r.OPS.setFillCMYKColor, numArgs: 4, variableArgs: !1 },
                sh: { id: r.OPS.shadingFill, numArgs: 1, variableArgs: !1 },
                BI: {
                  id: r.OPS.beginInlineImage,
                  numArgs: 0,
                  variableArgs: !1,
                },
                ID: { id: r.OPS.beginImageData, numArgs: 0, variableArgs: !1 },
                EI: { id: r.OPS.endInlineImage, numArgs: 1, variableArgs: !1 },
                Do: { id: r.OPS.paintXObject, numArgs: 1, variableArgs: !1 },
                MP: { id: r.OPS.markPoint, numArgs: 1, variableArgs: !1 },
                DP: { id: r.OPS.markPointProps, numArgs: 2, variableArgs: !1 },
                BMC: {
                  id: r.OPS.beginMarkedContent,
                  numArgs: 1,
                  variableArgs: !1,
                },
                BDC: {
                  id: r.OPS.beginMarkedContentProps,
                  numArgs: 2,
                  variableArgs: !1,
                },
                EMC: {
                  id: r.OPS.endMarkedContent,
                  numArgs: 0,
                  variableArgs: !1,
                },
                BX: { id: r.OPS.beginCompat, numArgs: 0, variableArgs: !1 },
                EX: { id: r.OPS.endCompat, numArgs: 0, variableArgs: !1 },
                BM: null,
                BD: null,
                true: null,
                fa: null,
                fal: null,
                fals: null,
                false: null,
                nu: null,
                nul: null,
                null: null,
              });
            }
            static MAX_INVALID_PATH_OPS = 10;
            constructor(e, t, a = new StateManager()) {
              this.parser = new f.Parser({
                lexer: new f.Lexer(e, EvaluatorPreprocessor.opMap),
                xref: t,
              });
              this.stateManager = a;
              this.nonProcessedArgs = [];
              this._isPathOp = !1;
              this._numInvalidPathOPS = 0;
            }
            get savedStatesDepth() {
              return this.stateManager.stateStack.length;
            }
            read(e) {
              let t = e.args;
              for (;;) {
                const a = this.parser.getObj();
                if (a instanceof i.Cmd) {
                  const n = a.cmd,
                    i = EvaluatorPreprocessor.opMap[n];
                  if (!i) {
                    (0, r.warn)(`Unknown command "${n}".`);
                    continue;
                  }
                  const s = i.id,
                    o = i.numArgs;
                  let c = null !== t ? t.length : 0;
                  this._isPathOp || (this._numInvalidPathOPS = 0);
                  this._isPathOp = s >= r.OPS.moveTo && s <= r.OPS.endPath;
                  if (i.variableArgs)
                    c > o &&
                      (0, r.info)(
                        `Command ${n}: expected [0, ${o}] args, but received ${c} args.`,
                      );
                  else {
                    if (c !== o) {
                      const e = this.nonProcessedArgs;
                      for (; c > o; ) {
                        e.push(t.shift());
                        c--;
                      }
                      for (; c < o && 0 !== e.length; ) {
                        null === t && (t = []);
                        t.unshift(e.pop());
                        c++;
                      }
                    }
                    if (c < o) {
                      const e = `command ${n}: expected ${o} args, but received ${c} args.`;
                      if (
                        this._isPathOp &&
                        ++this._numInvalidPathOPS >
                          EvaluatorPreprocessor.MAX_INVALID_PATH_OPS
                      )
                        throw new r.FormatError(`Invalid ${e}`);
                      (0, r.warn)(`Skipping ${e}`);
                      null !== t && (t.length = 0);
                      continue;
                    }
                  }
                  this.preprocessCommand(s, t);
                  e.fn = s;
                  e.args = t;
                  return !0;
                }
                if (a === i.EOF) return !1;
                if (null !== a) {
                  null === t && (t = []);
                  t.push(a);
                  if (t.length > 33)
                    throw new r.FormatError("Too many arguments");
                }
              }
            }
            preprocessCommand(e, t) {
              switch (0 | e) {
                case r.OPS.save:
                  this.stateManager.save();
                  break;
                case r.OPS.restore:
                  this.stateManager.restore();
                  break;
                case r.OPS.transform:
                  this.stateManager.transform(t);
              }
            }
          }
          t.EvaluatorPreprocessor = EvaluatorPreprocessor;
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.IdentityCMap = t.CMapFactory = t.CMap = void 0;
          var r = a(2),
            n = a(4),
            i = a(5),
            s = a(15),
            o = a(16),
            c = a(3),
            l = a(8);
          const h = [
              "Adobe-GB1-UCS2",
              "Adobe-CNS1-UCS2",
              "Adobe-Japan1-UCS2",
              "Adobe-Korea1-UCS2",
              "78-EUC-H",
              "78-EUC-V",
              "78-H",
              "78-RKSJ-H",
              "78-RKSJ-V",
              "78-V",
              "78ms-RKSJ-H",
              "78ms-RKSJ-V",
              "83pv-RKSJ-H",
              "90ms-RKSJ-H",
              "90ms-RKSJ-V",
              "90msp-RKSJ-H",
              "90msp-RKSJ-V",
              "90pv-RKSJ-H",
              "90pv-RKSJ-V",
              "Add-H",
              "Add-RKSJ-H",
              "Add-RKSJ-V",
              "Add-V",
              "Adobe-CNS1-0",
              "Adobe-CNS1-1",
              "Adobe-CNS1-2",
              "Adobe-CNS1-3",
              "Adobe-CNS1-4",
              "Adobe-CNS1-5",
              "Adobe-CNS1-6",
              "Adobe-GB1-0",
              "Adobe-GB1-1",
              "Adobe-GB1-2",
              "Adobe-GB1-3",
              "Adobe-GB1-4",
              "Adobe-GB1-5",
              "Adobe-Japan1-0",
              "Adobe-Japan1-1",
              "Adobe-Japan1-2",
              "Adobe-Japan1-3",
              "Adobe-Japan1-4",
              "Adobe-Japan1-5",
              "Adobe-Japan1-6",
              "Adobe-Korea1-0",
              "Adobe-Korea1-1",
              "Adobe-Korea1-2",
              "B5-H",
              "B5-V",
              "B5pc-H",
              "B5pc-V",
              "CNS-EUC-H",
              "CNS-EUC-V",
              "CNS1-H",
              "CNS1-V",
              "CNS2-H",
              "CNS2-V",
              "ETHK-B5-H",
              "ETHK-B5-V",
              "ETen-B5-H",
              "ETen-B5-V",
              "ETenms-B5-H",
              "ETenms-B5-V",
              "EUC-H",
              "EUC-V",
              "Ext-H",
              "Ext-RKSJ-H",
              "Ext-RKSJ-V",
              "Ext-V",
              "GB-EUC-H",
              "GB-EUC-V",
              "GB-H",
              "GB-V",
              "GBK-EUC-H",
              "GBK-EUC-V",
              "GBK2K-H",
              "GBK2K-V",
              "GBKp-EUC-H",
              "GBKp-EUC-V",
              "GBT-EUC-H",
              "GBT-EUC-V",
              "GBT-H",
              "GBT-V",
              "GBTpc-EUC-H",
              "GBTpc-EUC-V",
              "GBpc-EUC-H",
              "GBpc-EUC-V",
              "H",
              "HKdla-B5-H",
              "HKdla-B5-V",
              "HKdlb-B5-H",
              "HKdlb-B5-V",
              "HKgccs-B5-H",
              "HKgccs-B5-V",
              "HKm314-B5-H",
              "HKm314-B5-V",
              "HKm471-B5-H",
              "HKm471-B5-V",
              "HKscs-B5-H",
              "HKscs-B5-V",
              "Hankaku",
              "Hiragana",
              "KSC-EUC-H",
              "KSC-EUC-V",
              "KSC-H",
              "KSC-Johab-H",
              "KSC-Johab-V",
              "KSC-V",
              "KSCms-UHC-H",
              "KSCms-UHC-HW-H",
              "KSCms-UHC-HW-V",
              "KSCms-UHC-V",
              "KSCpc-EUC-H",
              "KSCpc-EUC-V",
              "Katakana",
              "NWP-H",
              "NWP-V",
              "RKSJ-H",
              "RKSJ-V",
              "Roman",
              "UniCNS-UCS2-H",
              "UniCNS-UCS2-V",
              "UniCNS-UTF16-H",
              "UniCNS-UTF16-V",
              "UniCNS-UTF32-H",
              "UniCNS-UTF32-V",
              "UniCNS-UTF8-H",
              "UniCNS-UTF8-V",
              "UniGB-UCS2-H",
              "UniGB-UCS2-V",
              "UniGB-UTF16-H",
              "UniGB-UTF16-V",
              "UniGB-UTF32-H",
              "UniGB-UTF32-V",
              "UniGB-UTF8-H",
              "UniGB-UTF8-V",
              "UniJIS-UCS2-H",
              "UniJIS-UCS2-HW-H",
              "UniJIS-UCS2-HW-V",
              "UniJIS-UCS2-V",
              "UniJIS-UTF16-H",
              "UniJIS-UTF16-V",
              "UniJIS-UTF32-H",
              "UniJIS-UTF32-V",
              "UniJIS-UTF8-H",
              "UniJIS-UTF8-V",
              "UniJIS2004-UTF16-H",
              "UniJIS2004-UTF16-V",
              "UniJIS2004-UTF32-H",
              "UniJIS2004-UTF32-V",
              "UniJIS2004-UTF8-H",
              "UniJIS2004-UTF8-V",
              "UniJISPro-UCS2-HW-V",
              "UniJISPro-UCS2-V",
              "UniJISPro-UTF8-V",
              "UniJISX0213-UTF32-H",
              "UniJISX0213-UTF32-V",
              "UniJISX02132004-UTF32-H",
              "UniJISX02132004-UTF32-V",
              "UniKS-UCS2-H",
              "UniKS-UCS2-V",
              "UniKS-UTF16-H",
              "UniKS-UTF16-V",
              "UniKS-UTF32-H",
              "UniKS-UTF32-V",
              "UniKS-UTF8-H",
              "UniKS-UTF8-V",
              "V",
              "WP-Symbol",
            ],
            u = 2 ** 24 - 1;
          class CMap {
            constructor(e = !1) {
              this.codespaceRanges = [[], [], [], []];
              this.numCodespaceRanges = 0;
              this._map = [];
              this.name = "";
              this.vertical = !1;
              this.useCMap = null;
              this.builtInCMap = e;
            }
            addCodespaceRange(e, t, a) {
              this.codespaceRanges[e - 1].push(t, a);
              this.numCodespaceRanges++;
            }
            mapCidRange(e, t, a) {
              if (t - e > u)
                throw new Error(
                  "mapCidRange - ignoring data above MAX_MAP_RANGE.",
                );
              for (; e <= t; ) this._map[e++] = a++;
            }
            mapBfRange(e, t, a) {
              if (t - e > u)
                throw new Error(
                  "mapBfRange - ignoring data above MAX_MAP_RANGE.",
                );
              const r = a.length - 1;
              for (; e <= t; ) {
                this._map[e++] = a;
                const t = a.charCodeAt(r) + 1;
                t > 255
                  ? (a =
                      a.substring(0, r - 1) +
                      String.fromCharCode(a.charCodeAt(r - 1) + 1) +
                      "\0")
                  : (a = a.substring(0, r) + String.fromCharCode(t));
              }
            }
            mapBfRangeToArray(e, t, a) {
              if (t - e > u)
                throw new Error(
                  "mapBfRangeToArray - ignoring data above MAX_MAP_RANGE.",
                );
              const r = a.length;
              let n = 0;
              for (; e <= t && n < r; ) {
                this._map[e] = a[n++];
                ++e;
              }
            }
            mapOne(e, t) {
              this._map[e] = t;
            }
            lookup(e) {
              return this._map[e];
            }
            contains(e) {
              return void 0 !== this._map[e];
            }
            forEach(e) {
              const t = this._map,
                a = t.length;
              if (a <= 65536)
                for (let r = 0; r < a; r++) void 0 !== t[r] && e(r, t[r]);
              else for (const a in t) e(a, t[a]);
            }
            charCodeOf(e) {
              const t = this._map;
              if (t.length <= 65536) return t.indexOf(e);
              for (const a in t) if (t[a] === e) return 0 | a;
              return -1;
            }
            getMap() {
              return this._map;
            }
            readCharCode(e, t, a) {
              let r = 0;
              const n = this.codespaceRanges;
              for (let i = 0, s = n.length; i < s; i++) {
                r = ((r << 8) | e.charCodeAt(t + i)) >>> 0;
                const s = n[i];
                for (let e = 0, t = s.length; e < t; ) {
                  const t = s[e++],
                    n = s[e++];
                  if (r >= t && r <= n) {
                    a.charcode = r;
                    a.length = i + 1;
                    return;
                  }
                }
              }
              a.charcode = 0;
              a.length = 1;
            }
            getCharCodeLength(e) {
              const t = this.codespaceRanges;
              for (let a = 0, r = t.length; a < r; a++) {
                const r = t[a];
                for (let t = 0, n = r.length; t < n; ) {
                  const n = r[t++],
                    i = r[t++];
                  if (e >= n && e <= i) return a + 1;
                }
              }
              return 1;
            }
            get length() {
              return this._map.length;
            }
            get isIdentityCMap() {
              if ("Identity-H" !== this.name && "Identity-V" !== this.name)
                return !1;
              if (65536 !== this._map.length) return !1;
              for (let e = 0; e < 65536; e++) if (this._map[e] !== e) return !1;
              return !0;
            }
          }
          t.CMap = CMap;
          class IdentityCMap extends CMap {
            constructor(e, t) {
              super();
              this.vertical = e;
              this.addCodespaceRange(t, 0, 65535);
            }
            mapCidRange(e, t, a) {
              (0, r.unreachable)("should not call mapCidRange");
            }
            mapBfRange(e, t, a) {
              (0, r.unreachable)("should not call mapBfRange");
            }
            mapBfRangeToArray(e, t, a) {
              (0, r.unreachable)("should not call mapBfRangeToArray");
            }
            mapOne(e, t) {
              (0, r.unreachable)("should not call mapCidOne");
            }
            lookup(e) {
              return Number.isInteger(e) && e <= 65535 ? e : void 0;
            }
            contains(e) {
              return Number.isInteger(e) && e <= 65535;
            }
            forEach(e) {
              for (let t = 0; t <= 65535; t++) e(t, t);
            }
            charCodeOf(e) {
              return Number.isInteger(e) && e <= 65535 ? e : -1;
            }
            getMap() {
              const e = new Array(65536);
              for (let t = 0; t <= 65535; t++) e[t] = t;
              return e;
            }
            get length() {
              return 65536;
            }
            get isIdentityCMap() {
              (0, r.unreachable)("should not access .isIdentityCMap");
            }
          }
          t.IdentityCMap = IdentityCMap;
          function strToInt(e) {
            let t = 0;
            for (let a = 0; a < e.length; a++) t = (t << 8) | e.charCodeAt(a);
            return t >>> 0;
          }
          function expectString(e) {
            if ("string" != typeof e)
              throw new r.FormatError("Malformed CMap: expected string.");
          }
          function expectInt(e) {
            if (!Number.isInteger(e))
              throw new r.FormatError("Malformed CMap: expected int.");
          }
          function parseBfChar(e, t) {
            for (;;) {
              let a = t.getObj();
              if (a === n.EOF) break;
              if ((0, n.isCmd)(a, "endbfchar")) return;
              expectString(a);
              const r = strToInt(a);
              a = t.getObj();
              expectString(a);
              const i = a;
              e.mapOne(r, i);
            }
          }
          function parseBfRange(e, t) {
            for (;;) {
              let a = t.getObj();
              if (a === n.EOF) break;
              if ((0, n.isCmd)(a, "endbfrange")) return;
              expectString(a);
              const r = strToInt(a);
              a = t.getObj();
              expectString(a);
              const i = strToInt(a);
              a = t.getObj();
              if (Number.isInteger(a) || "string" == typeof a) {
                const t = Number.isInteger(a) ? String.fromCharCode(a) : a;
                e.mapBfRange(r, i, t);
              } else {
                if (!(0, n.isCmd)(a, "[")) break;
                {
                  a = t.getObj();
                  const s = [];
                  for (; !(0, n.isCmd)(a, "]") && a !== n.EOF; ) {
                    s.push(a);
                    a = t.getObj();
                  }
                  e.mapBfRangeToArray(r, i, s);
                }
              }
            }
            throw new r.FormatError("Invalid bf range.");
          }
          function parseCidChar(e, t) {
            for (;;) {
              let a = t.getObj();
              if (a === n.EOF) break;
              if ((0, n.isCmd)(a, "endcidchar")) return;
              expectString(a);
              const r = strToInt(a);
              a = t.getObj();
              expectInt(a);
              const i = a;
              e.mapOne(r, i);
            }
          }
          function parseCidRange(e, t) {
            for (;;) {
              let a = t.getObj();
              if (a === n.EOF) break;
              if ((0, n.isCmd)(a, "endcidrange")) return;
              expectString(a);
              const r = strToInt(a);
              a = t.getObj();
              expectString(a);
              const i = strToInt(a);
              a = t.getObj();
              expectInt(a);
              const s = a;
              e.mapCidRange(r, i, s);
            }
          }
          function parseCodespaceRange(e, t) {
            for (;;) {
              let a = t.getObj();
              if (a === n.EOF) break;
              if ((0, n.isCmd)(a, "endcodespacerange")) return;
              if ("string" != typeof a) break;
              const r = strToInt(a);
              a = t.getObj();
              if ("string" != typeof a) break;
              const i = strToInt(a);
              e.addCodespaceRange(a.length, r, i);
            }
            throw new r.FormatError("Invalid codespace range.");
          }
          function parseWMode(e, t) {
            const a = t.getObj();
            Number.isInteger(a) && (e.vertical = !!a);
          }
          function parseCMapName(e, t) {
            const a = t.getObj();
            a instanceof n.Name && (e.name = a.name);
          }
          async function parseCMap(e, t, a, i) {
            let s, o;
            e: for (;;)
              try {
                const a = t.getObj();
                if (a === n.EOF) break;
                if (a instanceof n.Name) {
                  "WMode" === a.name
                    ? parseWMode(e, t)
                    : "CMapName" === a.name && parseCMapName(e, t);
                  s = a;
                } else if (a instanceof n.Cmd)
                  switch (a.cmd) {
                    case "endcmap":
                      break e;
                    case "usecmap":
                      s instanceof n.Name && (o = s.name);
                      break;
                    case "begincodespacerange":
                      parseCodespaceRange(e, t);
                      break;
                    case "beginbfchar":
                      parseBfChar(e, t);
                      break;
                    case "begincidchar":
                      parseCidChar(e, t);
                      break;
                    case "beginbfrange":
                      parseBfRange(e, t);
                      break;
                    case "begincidrange":
                      parseCidRange(e, t);
                  }
              } catch (e) {
                if (e instanceof c.MissingDataException) throw e;
                (0, r.warn)("Invalid cMap data: " + e);
                continue;
              }
            !i && o && (i = o);
            return i ? extendCMap(e, a, i) : e;
          }
          async function extendCMap(e, t, a) {
            e.useCMap = await createBuiltInCMap(a, t);
            if (0 === e.numCodespaceRanges) {
              const t = e.useCMap.codespaceRanges;
              for (let a = 0; a < t.length; a++)
                e.codespaceRanges[a] = t[a].slice();
              e.numCodespaceRanges = e.useCMap.numCodespaceRanges;
            }
            e.useCMap.forEach(function (t, a) {
              e.contains(t) || e.mapOne(t, e.useCMap.lookup(t));
            });
            return e;
          }
          async function createBuiltInCMap(e, t) {
            if ("Identity-H" === e) return new IdentityCMap(!1, 2);
            if ("Identity-V" === e) return new IdentityCMap(!0, 2);
            if (!h.includes(e)) throw new Error("Unknown CMap name: " + e);
            if (!t)
              throw new Error("Built-in CMap parameters are not provided.");
            const { cMapData: a, compressionType: n } = await t(e),
              i = new CMap(!0);
            if (n === r.CMapCompressionType.BINARY)
              return new s.BinaryCMapReader().process(a, i, (e) =>
                extendCMap(i, t, e),
              );
            if (n === r.CMapCompressionType.NONE) {
              const e = new o.Lexer(new l.Stream(a));
              return parseCMap(i, e, t, null);
            }
            throw new Error(`Invalid CMap "compressionType" value: ${n}`);
          }
          t.CMapFactory = class CMapFactory {
            static async create({
              encoding: e,
              fetchBuiltInCMap: t,
              useCMap: a,
            }) {
              if (e instanceof n.Name) return createBuiltInCMap(e.name, t);
              if (e instanceof i.BaseStream) {
                const r = await parseCMap(new CMap(), new o.Lexer(e), t, a);
                return r.isIdentityCMap ? createBuiltInCMap(r.name, t) : r;
              }
              throw new Error("Encoding required.");
            }
          };
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.BinaryCMapReader = void 0;
          var r = a(2);
          function hexToInt(e, t) {
            let a = 0;
            for (let r = 0; r <= t; r++) a = (a << 8) | e[r];
            return a >>> 0;
          }
          function hexToStr(e, t) {
            return 1 === t
              ? String.fromCharCode(e[0], e[1])
              : 3 === t
                ? String.fromCharCode(e[0], e[1], e[2], e[3])
                : String.fromCharCode(...e.subarray(0, t + 1));
          }
          function addHex(e, t, a) {
            let r = 0;
            for (let n = a; n >= 0; n--) {
              r += e[n] + t[n];
              e[n] = 255 & r;
              r >>= 8;
            }
          }
          function incHex(e, t) {
            let a = 1;
            for (let r = t; r >= 0 && a > 0; r--) {
              a += e[r];
              e[r] = 255 & a;
              a >>= 8;
            }
          }
          const n = 16;
          class BinaryCMapStream {
            constructor(e) {
              this.buffer = e;
              this.pos = 0;
              this.end = e.length;
              this.tmpBuf = new Uint8Array(19);
            }
            readByte() {
              return this.pos >= this.end ? -1 : this.buffer[this.pos++];
            }
            readNumber() {
              let e,
                t = 0;
              do {
                const a = this.readByte();
                if (a < 0) throw new r.FormatError("unexpected EOF in bcmap");
                e = !(128 & a);
                t = (t << 7) | (127 & a);
              } while (!e);
              return t;
            }
            readSigned() {
              const e = this.readNumber();
              return 1 & e ? ~(e >>> 1) : e >>> 1;
            }
            readHex(e, t) {
              e.set(this.buffer.subarray(this.pos, this.pos + t + 1));
              this.pos += t + 1;
            }
            readHexNumber(e, t) {
              let a;
              const n = this.tmpBuf;
              let i = 0;
              do {
                const e = this.readByte();
                if (e < 0) throw new r.FormatError("unexpected EOF in bcmap");
                a = !(128 & e);
                n[i++] = 127 & e;
              } while (!a);
              let s = t,
                o = 0,
                c = 0;
              for (; s >= 0; ) {
                for (; c < 8 && n.length > 0; ) {
                  o |= n[--i] << c;
                  c += 7;
                }
                e[s] = 255 & o;
                s--;
                o >>= 8;
                c -= 8;
              }
            }
            readHexSigned(e, t) {
              this.readHexNumber(e, t);
              const a = 1 & e[t] ? 255 : 0;
              let r = 0;
              for (let n = 0; n <= t; n++) {
                r = ((1 & r) << 8) | e[n];
                e[n] = (r >> 1) ^ a;
              }
            }
            readString() {
              const e = this.readNumber(),
                t = new Array(e);
              for (let a = 0; a < e; a++) t[a] = this.readNumber();
              return String.fromCharCode(...t);
            }
          }
          t.BinaryCMapReader = class BinaryCMapReader {
            async process(e, t, a) {
              const r = new BinaryCMapStream(e),
                i = r.readByte();
              t.vertical = !!(1 & i);
              let s = null;
              const o = new Uint8Array(n),
                c = new Uint8Array(n),
                l = new Uint8Array(n),
                h = new Uint8Array(n),
                u = new Uint8Array(n);
              let d, f;
              for (; (f = r.readByte()) >= 0; ) {
                const e = f >> 5;
                if (7 === e) {
                  switch (31 & f) {
                    case 0:
                      r.readString();
                      break;
                    case 1:
                      s = r.readString();
                  }
                  continue;
                }
                const a = !!(16 & f),
                  i = 15 & f;
                if (i + 1 > n)
                  throw new Error(
                    "BinaryCMapReader.process: Invalid dataSize.",
                  );
                const g = 1,
                  p = r.readNumber();
                switch (e) {
                  case 0:
                    r.readHex(o, i);
                    r.readHexNumber(c, i);
                    addHex(c, o, i);
                    t.addCodespaceRange(i + 1, hexToInt(o, i), hexToInt(c, i));
                    for (let e = 1; e < p; e++) {
                      incHex(c, i);
                      r.readHexNumber(o, i);
                      addHex(o, c, i);
                      r.readHexNumber(c, i);
                      addHex(c, o, i);
                      t.addCodespaceRange(
                        i + 1,
                        hexToInt(o, i),
                        hexToInt(c, i),
                      );
                    }
                    break;
                  case 1:
                    r.readHex(o, i);
                    r.readHexNumber(c, i);
                    addHex(c, o, i);
                    r.readNumber();
                    for (let e = 1; e < p; e++) {
                      incHex(c, i);
                      r.readHexNumber(o, i);
                      addHex(o, c, i);
                      r.readHexNumber(c, i);
                      addHex(c, o, i);
                      r.readNumber();
                    }
                    break;
                  case 2:
                    r.readHex(l, i);
                    d = r.readNumber();
                    t.mapOne(hexToInt(l, i), d);
                    for (let e = 1; e < p; e++) {
                      incHex(l, i);
                      if (!a) {
                        r.readHexNumber(u, i);
                        addHex(l, u, i);
                      }
                      d = r.readSigned() + (d + 1);
                      t.mapOne(hexToInt(l, i), d);
                    }
                    break;
                  case 3:
                    r.readHex(o, i);
                    r.readHexNumber(c, i);
                    addHex(c, o, i);
                    d = r.readNumber();
                    t.mapCidRange(hexToInt(o, i), hexToInt(c, i), d);
                    for (let e = 1; e < p; e++) {
                      incHex(c, i);
                      if (a) o.set(c);
                      else {
                        r.readHexNumber(o, i);
                        addHex(o, c, i);
                      }
                      r.readHexNumber(c, i);
                      addHex(c, o, i);
                      d = r.readNumber();
                      t.mapCidRange(hexToInt(o, i), hexToInt(c, i), d);
                    }
                    break;
                  case 4:
                    r.readHex(l, g);
                    r.readHex(h, i);
                    t.mapOne(hexToInt(l, g), hexToStr(h, i));
                    for (let e = 1; e < p; e++) {
                      incHex(l, g);
                      if (!a) {
                        r.readHexNumber(u, g);
                        addHex(l, u, g);
                      }
                      incHex(h, i);
                      r.readHexSigned(u, i);
                      addHex(h, u, i);
                      t.mapOne(hexToInt(l, g), hexToStr(h, i));
                    }
                    break;
                  case 5:
                    r.readHex(o, g);
                    r.readHexNumber(c, g);
                    addHex(c, o, g);
                    r.readHex(h, i);
                    t.mapBfRange(
                      hexToInt(o, g),
                      hexToInt(c, g),
                      hexToStr(h, i),
                    );
                    for (let e = 1; e < p; e++) {
                      incHex(c, g);
                      if (a) o.set(c);
                      else {
                        r.readHexNumber(o, g);
                        addHex(o, c, g);
                      }
                      r.readHexNumber(c, g);
                      addHex(c, o, g);
                      r.readHex(h, i);
                      t.mapBfRange(
                        hexToInt(o, g),
                        hexToInt(c, g),
                        hexToStr(h, i),
                      );
                    }
                    break;
                  default:
                    throw new Error(
                      `BinaryCMapReader.process - unknown type: ${e}`,
                    );
                }
              }
              return s ? a(s) : t;
            }
          };
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.Parser = t.Linearization = t.Lexer = void 0;
          var r = a(2),
            n = a(4),
            i = a(3),
            s = a(8),
            o = a(17),
            c = a(19),
            l = a(20),
            h = a(22),
            u = a(23),
            d = a(26),
            f = a(29),
            g = a(31),
            p = a(32),
            m = a(33);
          class Parser {
            constructor({
              lexer: e,
              xref: t,
              allowStreams: a = !1,
              recoveryMode: r = !1,
            }) {
              this.lexer = e;
              this.xref = t;
              this.allowStreams = a;
              this.recoveryMode = r;
              this.imageCache = Object.create(null);
              this._imageId = 0;
              this.refill();
            }
            refill() {
              this.buf1 = this.lexer.getObj();
              this.buf2 = this.lexer.getObj();
            }
            shift() {
              if (this.buf2 instanceof n.Cmd && "ID" === this.buf2.cmd) {
                this.buf1 = this.buf2;
                this.buf2 = null;
              } else {
                this.buf1 = this.buf2;
                this.buf2 = this.lexer.getObj();
              }
            }
            tryShift() {
              try {
                this.shift();
                return !0;
              } catch (e) {
                if (e instanceof i.MissingDataException) throw e;
                return !1;
              }
            }
            getObj(e = null) {
              const t = this.buf1;
              this.shift();
              if (t instanceof n.Cmd)
                switch (t.cmd) {
                  case "BI":
                    return this.makeInlineImage(e);
                  case "[":
                    const a = [];
                    for (
                      ;
                      !(0, n.isCmd)(this.buf1, "]") && this.buf1 !== n.EOF;

                    )
                      a.push(this.getObj(e));
                    if (this.buf1 === n.EOF) {
                      if (this.recoveryMode) return a;
                      throw new i.ParserEOFException(
                        "End of file inside array.",
                      );
                    }
                    this.shift();
                    return a;
                  case "<<":
                    const s = new n.Dict(this.xref);
                    for (
                      ;
                      !(0, n.isCmd)(this.buf1, ">>") && this.buf1 !== n.EOF;

                    ) {
                      if (!(this.buf1 instanceof n.Name)) {
                        (0, r.info)(
                          "Malformed dictionary: key must be a name object",
                        );
                        this.shift();
                        continue;
                      }
                      const t = this.buf1.name;
                      this.shift();
                      if (this.buf1 === n.EOF) break;
                      s.set(t, this.getObj(e));
                    }
                    if (this.buf1 === n.EOF) {
                      if (this.recoveryMode) return s;
                      throw new i.ParserEOFException(
                        "End of file inside dictionary.",
                      );
                    }
                    if ((0, n.isCmd)(this.buf2, "stream"))
                      return this.allowStreams ? this.makeStream(s, e) : s;
                    this.shift();
                    return s;
                  default:
                    return t;
                }
              if (Number.isInteger(t)) {
                if (
                  Number.isInteger(this.buf1) &&
                  (0, n.isCmd)(this.buf2, "R")
                ) {
                  const e = n.Ref.get(t, this.buf1);
                  this.shift();
                  this.shift();
                  return e;
                }
                return t;
              }
              return "string" == typeof t && e ? e.decryptString(t) : t;
            }
            findDefaultInlineStreamEnd(e) {
              const { knownCommands: t } = this.lexer,
                a = e.pos;
              let o,
                c,
                l = 0;
              for (; -1 !== (o = e.getByte()); )
                if (0 === l) l = 69 === o ? 1 : 0;
                else if (1 === l) l = 73 === o ? 2 : 0;
                else if (32 === o || 10 === o || 13 === o) {
                  c = e.pos;
                  const a = e.peekBytes(15),
                    i = a.length;
                  if (0 === i) break;
                  for (let e = 0; e < i; e++) {
                    o = a[e];
                    if (
                      (0 !== o || 0 === a[e + 1]) &&
                      10 !== o &&
                      13 !== o &&
                      (o < 32 || o > 127)
                    ) {
                      l = 0;
                      break;
                    }
                  }
                  if (2 !== l) continue;
                  if (!t) {
                    (0, r.warn)(
                      "findDefaultInlineStreamEnd - `lexer.knownCommands` is undefined.",
                    );
                    continue;
                  }
                  const h = new Lexer(new s.Stream(a.slice()), t);
                  h._hexStringWarn = () => {};
                  let u = 0;
                  for (;;) {
                    const e = h.getObj();
                    if (e === n.EOF) {
                      l = 0;
                      break;
                    }
                    if (e instanceof n.Cmd) {
                      const a = t[e.cmd];
                      if (!a) {
                        l = 0;
                        break;
                      }
                      if (a.variableArgs ? u <= a.numArgs : u === a.numArgs)
                        break;
                      u = 0;
                    } else u++;
                  }
                  if (2 === l) break;
                } else l = 0;
              if (-1 === o) {
                (0, r.warn)(
                  "findDefaultInlineStreamEnd: Reached the end of the stream without finding a valid EI marker",
                );
                if (c) {
                  (0, r.warn)(
                    '... trying to recover by using the last "EI" occurrence.',
                  );
                  e.skip(-(e.pos - c));
                }
              }
              let h = 4;
              e.skip(-h);
              o = e.peekByte();
              e.skip(h);
              (0, i.isWhiteSpace)(o) || h--;
              return e.pos - h - a;
            }
            findDCTDecodeInlineStreamEnd(e) {
              const t = e.pos;
              let a,
                n,
                i = !1;
              for (; -1 !== (a = e.getByte()); )
                if (255 === a) {
                  switch (e.getByte()) {
                    case 0:
                      break;
                    case 255:
                      e.skip(-1);
                      break;
                    case 217:
                      i = !0;
                      break;
                    case 192:
                    case 193:
                    case 194:
                    case 195:
                    case 197:
                    case 198:
                    case 199:
                    case 201:
                    case 202:
                    case 203:
                    case 205:
                    case 206:
                    case 207:
                    case 196:
                    case 204:
                    case 218:
                    case 219:
                    case 220:
                    case 221:
                    case 222:
                    case 223:
                    case 224:
                    case 225:
                    case 226:
                    case 227:
                    case 228:
                    case 229:
                    case 230:
                    case 231:
                    case 232:
                    case 233:
                    case 234:
                    case 235:
                    case 236:
                    case 237:
                    case 238:
                    case 239:
                    case 254:
                      n = e.getUint16();
                      n > 2 ? e.skip(n - 2) : e.skip(-2);
                  }
                  if (i) break;
                }
              const s = e.pos - t;
              if (-1 === a) {
                (0, r.warn)(
                  "Inline DCTDecode image stream: EOI marker not found, searching for /EI/ instead.",
                );
                e.skip(-s);
                return this.findDefaultInlineStreamEnd(e);
              }
              this.inlineStreamSkipEI(e);
              return s;
            }
            findASCII85DecodeInlineStreamEnd(e) {
              const t = e.pos;
              let a;
              for (; -1 !== (a = e.getByte()); )
                if (126 === a) {
                  const t = e.pos;
                  a = e.peekByte();
                  for (; (0, i.isWhiteSpace)(a); ) {
                    e.skip();
                    a = e.peekByte();
                  }
                  if (62 === a) {
                    e.skip();
                    break;
                  }
                  if (e.pos > t) {
                    const t = e.peekBytes(2);
                    if (69 === t[0] && 73 === t[1]) break;
                  }
                }
              const n = e.pos - t;
              if (-1 === a) {
                (0, r.warn)(
                  "Inline ASCII85Decode image stream: EOD marker not found, searching for /EI/ instead.",
                );
                e.skip(-n);
                return this.findDefaultInlineStreamEnd(e);
              }
              this.inlineStreamSkipEI(e);
              return n;
            }
            findASCIIHexDecodeInlineStreamEnd(e) {
              const t = e.pos;
              let a;
              for (; -1 !== (a = e.getByte()) && 62 !== a; );
              const n = e.pos - t;
              if (-1 === a) {
                (0, r.warn)(
                  "Inline ASCIIHexDecode image stream: EOD marker not found, searching for /EI/ instead.",
                );
                e.skip(-n);
                return this.findDefaultInlineStreamEnd(e);
              }
              this.inlineStreamSkipEI(e);
              return n;
            }
            inlineStreamSkipEI(e) {
              let t,
                a = 0;
              for (; -1 !== (t = e.getByte()); )
                if (0 === a) a = 69 === t ? 1 : 0;
                else if (1 === a) a = 73 === t ? 2 : 0;
                else if (2 === a) break;
            }
            makeInlineImage(e) {
              const t = this.lexer,
                a = t.stream,
                i = Object.create(null);
              let s;
              for (; !(0, n.isCmd)(this.buf1, "ID") && this.buf1 !== n.EOF; ) {
                if (!(this.buf1 instanceof n.Name))
                  throw new r.FormatError(
                    "Dictionary key must be a name object",
                  );
                const t = this.buf1.name;
                this.shift();
                if (this.buf1 === n.EOF) break;
                i[t] = this.getObj(e);
              }
              -1 !== t.beginInlineImagePos &&
                (s = a.pos - t.beginInlineImagePos);
              const o = this.xref.fetchIfRef(i.F || i.Filter);
              let c;
              if (o instanceof n.Name) c = o.name;
              else if (Array.isArray(o)) {
                const e = this.xref.fetchIfRef(o[0]);
                e instanceof n.Name && (c = e.name);
              }
              const l = a.pos;
              let h, u;
              switch (c) {
                case "DCT":
                case "DCTDecode":
                  h = this.findDCTDecodeInlineStreamEnd(a);
                  break;
                case "A85":
                case "ASCII85Decode":
                  h = this.findASCII85DecodeInlineStreamEnd(a);
                  break;
                case "AHx":
                case "ASCIIHexDecode":
                  h = this.findASCIIHexDecodeInlineStreamEnd(a);
                  break;
                default:
                  h = this.findDefaultInlineStreamEnd(a);
              }
              if (h < 1e3 && s > 0) {
                const e = a.pos;
                a.pos = t.beginInlineImagePos;
                u = (function getInlineImageCacheKey(e) {
                  const t = [],
                    a = e.length;
                  let r = 0;
                  for (; r < a - 1; ) t.push((e[r++] << 8) | e[r++]);
                  r < a && t.push(e[r]);
                  return a + "_" + String.fromCharCode.apply(null, t);
                })(a.getBytes(s + h));
                a.pos = e;
                const r = this.imageCache[u];
                if (void 0 !== r) {
                  this.buf2 = n.Cmd.get("EI");
                  this.shift();
                  r.reset();
                  return r;
                }
              }
              const d = new n.Dict(this.xref);
              for (const e in i) d.set(e, i[e]);
              let f = a.makeSubStream(l, h, d);
              e && (f = e.createStream(f, h));
              f = this.filter(f, d, h);
              f.dict = d;
              if (void 0 !== u) {
                f.cacheKey = "inline_img_" + ++this._imageId;
                this.imageCache[u] = f;
              }
              this.buf2 = n.Cmd.get("EI");
              this.shift();
              return f;
            }
            _findStreamLength(e, t) {
              const { stream: a } = this.lexer;
              a.pos = e;
              const r = t.length;
              for (; a.pos < a.end; ) {
                const n = a.peekBytes(2048),
                  i = n.length - r;
                if (i <= 0) break;
                let s = 0;
                for (; s < i; ) {
                  let i = 0;
                  for (; i < r && n[s + i] === t[i]; ) i++;
                  if (i >= r) {
                    a.pos += s;
                    return a.pos - e;
                  }
                  s++;
                }
                a.pos += i;
              }
              return -1;
            }
            makeStream(e, t) {
              const a = this.lexer;
              let s = a.stream;
              a.skipToNextLine();
              const o = s.pos - 1;
              let c = e.get("Length");
              if (!Number.isInteger(c)) {
                (0, r.info)(`Bad length "${c && c.toString()}" in stream.`);
                c = 0;
              }
              s.pos = o + c;
              a.nextChar();
              if (this.tryShift() && (0, n.isCmd)(this.buf2, "endstream"))
                this.shift();
              else {
                const e = new Uint8Array([
                  101, 110, 100, 115, 116, 114, 101, 97, 109,
                ]);
                let t = this._findStreamLength(o, e);
                if (t < 0) {
                  const a = 1;
                  for (let n = 1; n <= a; n++) {
                    const a = e.length - n,
                      c = e.slice(0, a),
                      l = this._findStreamLength(o, c);
                    if (l >= 0) {
                      const e = s.peekBytes(a + 1)[a];
                      if (!(0, i.isWhiteSpace)(e)) break;
                      (0, r.info)(
                        `Found "${(0, r.bytesToString)(
                          c,
                        )}" when searching for endstream command.`,
                      );
                      t = l;
                      break;
                    }
                  }
                  if (t < 0)
                    throw new r.FormatError("Missing endstream command.");
                }
                c = t;
                a.nextChar();
                this.shift();
                this.shift();
              }
              this.shift();
              s = s.makeSubStream(o, c, e);
              t && (s = t.createStream(s, c));
              s = this.filter(s, e, c);
              s.dict = e;
              return s;
            }
            filter(e, t, a) {
              let i = t.get("F", "Filter"),
                s = t.get("DP", "DecodeParms");
              if (i instanceof n.Name) {
                Array.isArray(s) &&
                  (0, r.warn)(
                    "/DecodeParms should not be an Array, when /Filter is a Name.",
                  );
                return this.makeFilter(e, i.name, a, s);
              }
              let o = a;
              if (Array.isArray(i)) {
                const t = i,
                  a = s;
                for (let c = 0, l = t.length; c < l; ++c) {
                  i = this.xref.fetchIfRef(t[c]);
                  if (!(i instanceof n.Name))
                    throw new r.FormatError(`Bad filter name "${i}"`);
                  s = null;
                  Array.isArray(a) &&
                    c in a &&
                    (s = this.xref.fetchIfRef(a[c]));
                  e = this.makeFilter(e, i.name, o, s);
                  o = null;
                }
              }
              return e;
            }
            makeFilter(e, t, a, n) {
              if (0 === a) {
                (0, r.warn)(`Empty "${t}" stream.`);
                return new s.NullStream();
              }
              try {
                switch (t) {
                  case "Fl":
                  case "FlateDecode":
                    return n
                      ? new p.PredictorStream(new h.FlateStream(e, a), a, n)
                      : new h.FlateStream(e, a);
                  case "LZW":
                  case "LZWDecode":
                    let t = 1;
                    if (n) {
                      n.has("EarlyChange") && (t = n.get("EarlyChange"));
                      return new p.PredictorStream(
                        new g.LZWStream(e, a, t),
                        a,
                        n,
                      );
                    }
                    return new g.LZWStream(e, a, t);
                  case "DCT":
                  case "DCTDecode":
                    return new d.JpegStream(e, a, n);
                  case "JPX":
                  case "JPXDecode":
                    return new f.JpxStream(e, a, n);
                  case "A85":
                  case "ASCII85Decode":
                    return new o.Ascii85Stream(e, a);
                  case "AHx":
                  case "ASCIIHexDecode":
                    return new c.AsciiHexStream(e, a);
                  case "CCF":
                  case "CCITTFaxDecode":
                    return new l.CCITTFaxStream(e, a, n);
                  case "RL":
                  case "RunLengthDecode":
                    return new m.RunLengthStream(e, a);
                  case "JBIG2Decode":
                    return new u.Jbig2Stream(e, a, n);
                }
                (0, r.warn)(`Filter "${t}" is not supported.`);
                return e;
              } catch (e) {
                if (e instanceof i.MissingDataException) throw e;
                (0, r.warn)(`Invalid stream: "${e}"`);
                return new s.NullStream();
              }
            }
          }
          t.Parser = Parser;
          const b = [
            1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 2, 0, 0, 2, 2, 0, 0, 0, 0,
            0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
            0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0,
          ];
          function toHexDigit(e) {
            return e >= 48 && e <= 57
              ? 15 & e
              : (e >= 65 && e <= 70) || (e >= 97 && e <= 102)
                ? 9 + (15 & e)
                : -1;
          }
          class Lexer {
            constructor(e, t = null) {
              this.stream = e;
              this.nextChar();
              this.strBuf = [];
              this.knownCommands = t;
              this._hexStringNumWarn = 0;
              this.beginInlineImagePos = -1;
            }
            nextChar() {
              return (this.currentChar = this.stream.getByte());
            }
            peekChar() {
              return this.stream.peekByte();
            }
            getNumber() {
              let e = this.currentChar,
                t = !1,
                a = 0,
                n = 1;
              if (45 === e) {
                n = -1;
                e = this.nextChar();
                45 === e && (e = this.nextChar());
              } else 43 === e && (e = this.nextChar());
              if (10 === e || 13 === e)
                do {
                  e = this.nextChar();
                } while (10 === e || 13 === e);
              if (46 === e) {
                a = 10;
                e = this.nextChar();
              }
              if (e < 48 || e > 57) {
                const t = `Invalid number: ${String.fromCharCode(
                  e,
                )} (charCode ${e})`;
                if ((0, i.isWhiteSpace)(e) || -1 === e) {
                  (0, r.info)(`Lexer.getNumber - "${t}".`);
                  return 0;
                }
                throw new r.FormatError(t);
              }
              let s = e - 48,
                o = 0,
                c = 1;
              for (; (e = this.nextChar()) >= 0; )
                if (e >= 48 && e <= 57) {
                  const r = e - 48;
                  if (t) o = 10 * o + r;
                  else {
                    0 !== a && (a *= 10);
                    s = 10 * s + r;
                  }
                } else if (46 === e) {
                  if (0 !== a) break;
                  a = 1;
                } else if (45 === e)
                  (0, r.warn)(
                    "Badly formatted number: minus sign in the middle",
                  );
                else {
                  if (69 !== e && 101 !== e) break;
                  e = this.peekChar();
                  if (43 === e || 45 === e) {
                    c = 45 === e ? -1 : 1;
                    this.nextChar();
                  } else if (e < 48 || e > 57) break;
                  t = !0;
                }
              0 !== a && (s /= a);
              t && (s *= 10 ** (c * o));
              return n * s;
            }
            getString() {
              let e = 1,
                t = !1;
              const a = this.strBuf;
              a.length = 0;
              let n = this.nextChar();
              for (;;) {
                let i = !1;
                switch (0 | n) {
                  case -1:
                    (0, r.warn)("Unterminated string");
                    t = !0;
                    break;
                  case 40:
                    ++e;
                    a.push("(");
                    break;
                  case 41:
                    if (0 == --e) {
                      this.nextChar();
                      t = !0;
                    } else a.push(")");
                    break;
                  case 92:
                    n = this.nextChar();
                    switch (n) {
                      case -1:
                        (0, r.warn)("Unterminated string");
                        t = !0;
                        break;
                      case 110:
                        a.push("\n");
                        break;
                      case 114:
                        a.push("\r");
                        break;
                      case 116:
                        a.push("\t");
                        break;
                      case 98:
                        a.push("\b");
                        break;
                      case 102:
                        a.push("\f");
                        break;
                      case 92:
                      case 40:
                      case 41:
                        a.push(String.fromCharCode(n));
                        break;
                      case 48:
                      case 49:
                      case 50:
                      case 51:
                      case 52:
                      case 53:
                      case 54:
                      case 55:
                        let e = 15 & n;
                        n = this.nextChar();
                        i = !0;
                        if (n >= 48 && n <= 55) {
                          e = (e << 3) + (15 & n);
                          n = this.nextChar();
                          if (n >= 48 && n <= 55) {
                            i = !1;
                            e = (e << 3) + (15 & n);
                          }
                        }
                        a.push(String.fromCharCode(e));
                        break;
                      case 13:
                        10 === this.peekChar() && this.nextChar();
                        break;
                      case 10:
                        break;
                      default:
                        a.push(String.fromCharCode(n));
                    }
                    break;
                  default:
                    a.push(String.fromCharCode(n));
                }
                if (t) break;
                i || (n = this.nextChar());
              }
              return a.join("");
            }
            getName() {
              let e, t;
              const a = this.strBuf;
              a.length = 0;
              for (; (e = this.nextChar()) >= 0 && !b[e]; )
                if (35 === e) {
                  e = this.nextChar();
                  if (b[e]) {
                    (0, r.warn)(
                      "Lexer_getName: NUMBER SIGN (#) should be followed by a hexadecimal number.",
                    );
                    a.push("#");
                    break;
                  }
                  const n = toHexDigit(e);
                  if (-1 !== n) {
                    t = e;
                    e = this.nextChar();
                    const i = toHexDigit(e);
                    if (-1 === i) {
                      (0, r.warn)(
                        `Lexer_getName: Illegal digit (${String.fromCharCode(
                          e,
                        )}) in hexadecimal number.`,
                      );
                      a.push("#", String.fromCharCode(t));
                      if (b[e]) break;
                      a.push(String.fromCharCode(e));
                      continue;
                    }
                    a.push(String.fromCharCode((n << 4) | i));
                  } else a.push("#", String.fromCharCode(e));
                } else a.push(String.fromCharCode(e));
              a.length > 127 &&
                (0, r.warn)(
                  `Name token is longer than allowed by the spec: ${a.length}`,
                );
              return n.Name.get(a.join(""));
            }
            _hexStringWarn(e) {
              5 != this._hexStringNumWarn++
                ? this._hexStringNumWarn > 5 ||
                  (0, r.warn)(`getHexString - ignoring invalid character: ${e}`)
                : (0, r.warn)(
                    "getHexString - ignoring additional invalid characters.",
                  );
            }
            getHexString() {
              const e = this.strBuf;
              e.length = 0;
              let t,
                a,
                n = this.currentChar,
                i = !0;
              this._hexStringNumWarn = 0;
              for (;;) {
                if (n < 0) {
                  (0, r.warn)("Unterminated hex string");
                  break;
                }
                if (62 === n) {
                  this.nextChar();
                  break;
                }
                if (1 !== b[n]) {
                  if (i) {
                    t = toHexDigit(n);
                    if (-1 === t) {
                      this._hexStringWarn(n);
                      n = this.nextChar();
                      continue;
                    }
                  } else {
                    a = toHexDigit(n);
                    if (-1 === a) {
                      this._hexStringWarn(n);
                      n = this.nextChar();
                      continue;
                    }
                    e.push(String.fromCharCode((t << 4) | a));
                  }
                  i = !i;
                  n = this.nextChar();
                } else n = this.nextChar();
              }
              return e.join("");
            }
            getObj() {
              let e = !1,
                t = this.currentChar;
              for (;;) {
                if (t < 0) return n.EOF;
                if (e) (10 !== t && 13 !== t) || (e = !1);
                else if (37 === t) e = !0;
                else if (1 !== b[t]) break;
                t = this.nextChar();
              }
              switch (0 | t) {
                case 48:
                case 49:
                case 50:
                case 51:
                case 52:
                case 53:
                case 54:
                case 55:
                case 56:
                case 57:
                case 43:
                case 45:
                case 46:
                  return this.getNumber();
                case 40:
                  return this.getString();
                case 47:
                  return this.getName();
                case 91:
                  this.nextChar();
                  return n.Cmd.get("[");
                case 93:
                  this.nextChar();
                  return n.Cmd.get("]");
                case 60:
                  t = this.nextChar();
                  if (60 === t) {
                    this.nextChar();
                    return n.Cmd.get("<<");
                  }
                  return this.getHexString();
                case 62:
                  t = this.nextChar();
                  if (62 === t) {
                    this.nextChar();
                    return n.Cmd.get(">>");
                  }
                  return n.Cmd.get(">");
                case 123:
                  this.nextChar();
                  return n.Cmd.get("{");
                case 125:
                  this.nextChar();
                  return n.Cmd.get("}");
                case 41:
                  this.nextChar();
                  throw new r.FormatError(`Illegal character: ${t}`);
              }
              let a = String.fromCharCode(t);
              if (t < 32 || t > 127) {
                const e = this.peekChar();
                if (e >= 32 && e <= 127) {
                  this.nextChar();
                  return n.Cmd.get(a);
                }
              }
              const i = this.knownCommands;
              let s = void 0 !== i?.[a];
              for (; (t = this.nextChar()) >= 0 && !b[t]; ) {
                const e = a + String.fromCharCode(t);
                if (s && void 0 === i[e]) break;
                if (128 === a.length)
                  throw new r.FormatError(
                    `Command token too long: ${a.length}`,
                  );
                a = e;
                s = void 0 !== i?.[a];
              }
              if ("true" === a) return !0;
              if ("false" === a) return !1;
              if ("null" === a) return null;
              "BI" === a && (this.beginInlineImagePos = this.stream.pos);
              return n.Cmd.get(a);
            }
            skipToNextLine() {
              let e = this.currentChar;
              for (; e >= 0; ) {
                if (13 === e) {
                  e = this.nextChar();
                  10 === e && this.nextChar();
                  break;
                }
                if (10 === e) {
                  this.nextChar();
                  break;
                }
                e = this.nextChar();
              }
            }
          }
          t.Lexer = Lexer;
          t.Linearization = class Linearization {
            static create(e) {
              function getInt(e, t, a = !1) {
                const r = e.get(t);
                if (Number.isInteger(r) && (a ? r >= 0 : r > 0)) return r;
                throw new Error(
                  `The "${t}" parameter in the linearization dictionary is invalid.`,
                );
              }
              const t = new Parser({ lexer: new Lexer(e), xref: null }),
                a = t.getObj(),
                r = t.getObj(),
                i = t.getObj(),
                s = t.getObj();
              let o, c;
              if (
                !(
                  Number.isInteger(a) &&
                  Number.isInteger(r) &&
                  (0, n.isCmd)(i, "obj") &&
                  s instanceof n.Dict &&
                  "number" == typeof (o = s.get("Linearized")) &&
                  o > 0
                )
              )
                return null;
              if ((c = getInt(s, "L")) !== e.length)
                throw new Error(
                  'The "L" parameter in the linearization dictionary does not equal the stream length.',
                );
              return {
                length: c,
                hints: (function getHints(e) {
                  const t = e.get("H");
                  let a;
                  if (Array.isArray(t) && (2 === (a = t.length) || 4 === a)) {
                    for (let e = 0; e < a; e++) {
                      const a = t[e];
                      if (!(Number.isInteger(a) && a > 0))
                        throw new Error(
                          `Hint (${e}) in the linearization dictionary is invalid.`,
                        );
                    }
                    return t;
                  }
                  throw new Error(
                    "Hint array in the linearization dictionary is invalid.",
                  );
                })(s),
                objectNumberFirst: getInt(s, "O"),
                endFirst: getInt(s, "E"),
                numPages: getInt(s, "N"),
                mainXRefEntriesOffset: getInt(s, "T"),
                pageFirst: s.has("P") ? getInt(s, "P", !0) : 0,
              };
            }
          };
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.Ascii85Stream = void 0;
          var r = a(18),
            n = a(3);
          class Ascii85Stream extends r.DecodeStream {
            constructor(e, t) {
              t && (t *= 0.8);
              super(t);
              this.str = e;
              this.dict = e.dict;
              this.input = new Uint8Array(5);
            }
            readBlock() {
              const e = this.str;
              let t = e.getByte();
              for (; (0, n.isWhiteSpace)(t); ) t = e.getByte();
              if (-1 === t || 126 === t) {
                this.eof = !0;
                return;
              }
              const a = this.bufferLength;
              let r, i;
              if (122 === t) {
                r = this.ensureBuffer(a + 4);
                for (i = 0; i < 4; ++i) r[a + i] = 0;
                this.bufferLength += 4;
              } else {
                const s = this.input;
                s[0] = t;
                for (i = 1; i < 5; ++i) {
                  t = e.getByte();
                  for (; (0, n.isWhiteSpace)(t); ) t = e.getByte();
                  s[i] = t;
                  if (-1 === t || 126 === t) break;
                }
                r = this.ensureBuffer(a + i - 1);
                this.bufferLength += i - 1;
                if (i < 5) {
                  for (; i < 5; ++i) s[i] = 117;
                  this.eof = !0;
                }
                let o = 0;
                for (i = 0; i < 5; ++i) o = 85 * o + (s[i] - 33);
                for (i = 3; i >= 0; --i) {
                  r[a + i] = 255 & o;
                  o >>= 8;
                }
              }
            }
          }
          t.Ascii85Stream = Ascii85Stream;
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.StreamsSequenceStream = t.DecodeStream = void 0;
          var r = a(5),
            n = a(8);
          const i = new Uint8Array(0);
          class DecodeStream extends r.BaseStream {
            constructor(e) {
              super();
              this._rawMinBufferLength = e || 0;
              this.pos = 0;
              this.bufferLength = 0;
              this.eof = !1;
              this.buffer = i;
              this.minBufferLength = 512;
              if (e)
                for (; this.minBufferLength < e; ) this.minBufferLength *= 2;
            }
            get isEmpty() {
              for (; !this.eof && 0 === this.bufferLength; ) this.readBlock();
              return 0 === this.bufferLength;
            }
            ensureBuffer(e) {
              const t = this.buffer;
              if (e <= t.byteLength) return t;
              let a = this.minBufferLength;
              for (; a < e; ) a *= 2;
              const r = new Uint8Array(a);
              r.set(t);
              return (this.buffer = r);
            }
            getByte() {
              const e = this.pos;
              for (; this.bufferLength <= e; ) {
                if (this.eof) return -1;
                this.readBlock();
              }
              return this.buffer[this.pos++];
            }
            getBytes(e) {
              const t = this.pos;
              let a;
              if (e) {
                this.ensureBuffer(t + e);
                a = t + e;
                for (; !this.eof && this.bufferLength < a; ) this.readBlock();
                const r = this.bufferLength;
                a > r && (a = r);
              } else {
                for (; !this.eof; ) this.readBlock();
                a = this.bufferLength;
              }
              this.pos = a;
              return this.buffer.subarray(t, a);
            }
            reset() {
              this.pos = 0;
            }
            makeSubStream(e, t, a = null) {
              if (void 0 === t) for (; !this.eof; ) this.readBlock();
              else {
                const a = e + t;
                for (; this.bufferLength <= a && !this.eof; ) this.readBlock();
              }
              return new n.Stream(this.buffer, e, t, a);
            }
            getBaseStreams() {
              return this.str ? this.str.getBaseStreams() : null;
            }
          }
          t.DecodeStream = DecodeStream;
          t.StreamsSequenceStream = class StreamsSequenceStream extends (
            DecodeStream
          ) {
            constructor(e, t = null) {
              let a = 0;
              for (const t of e)
                a +=
                  t instanceof DecodeStream ? t._rawMinBufferLength : t.length;
              super(a);
              this.streams = e;
              this._onError = t;
            }
            readBlock() {
              const e = this.streams;
              if (0 === e.length) {
                this.eof = !0;
                return;
              }
              const t = e.shift();
              let a;
              try {
                a = t.getBytes();
              } catch (e) {
                if (this._onError) {
                  this._onError(e, t.dict?.objId);
                  return;
                }
                throw e;
              }
              const r = this.bufferLength,
                n = r + a.length;
              this.ensureBuffer(n).set(a, r);
              this.bufferLength = n;
            }
            getBaseStreams() {
              const e = [];
              for (const t of this.streams) {
                const a = t.getBaseStreams();
                a && e.push(...a);
              }
              return e.length > 0 ? e : null;
            }
          };
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.AsciiHexStream = void 0;
          var r = a(18);
          class AsciiHexStream extends r.DecodeStream {
            constructor(e, t) {
              t && (t *= 0.5);
              super(t);
              this.str = e;
              this.dict = e.dict;
              this.firstDigit = -1;
            }
            readBlock() {
              const e = this.str.getBytes(8e3);
              if (!e.length) {
                this.eof = !0;
                return;
              }
              const t = (e.length + 1) >> 1,
                a = this.ensureBuffer(this.bufferLength + t);
              let r = this.bufferLength,
                n = this.firstDigit;
              for (const t of e) {
                let e;
                if (t >= 48 && t <= 57) e = 15 & t;
                else {
                  if (!((t >= 65 && t <= 70) || (t >= 97 && t <= 102))) {
                    if (62 === t) {
                      this.eof = !0;
                      break;
                    }
                    continue;
                  }
                  e = 9 + (15 & t);
                }
                if (n < 0) n = e;
                else {
                  a[r++] = (n << 4) | e;
                  n = -1;
                }
              }
              if (n >= 0 && this.eof) {
                a[r++] = n << 4;
                n = -1;
              }
              this.firstDigit = n;
              this.bufferLength = r;
            }
          }
          t.AsciiHexStream = AsciiHexStream;
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.CCITTFaxStream = void 0;
          var r = a(21),
            n = a(18),
            i = a(4);
          class CCITTFaxStream extends n.DecodeStream {
            constructor(e, t, a) {
              super(t);
              this.str = e;
              this.dict = e.dict;
              a instanceof i.Dict || (a = i.Dict.empty);
              const n = { next: () => e.getByte() };
              this.ccittFaxDecoder = new r.CCITTFaxDecoder(n, {
                K: a.get("K"),
                EndOfLine: a.get("EndOfLine"),
                EncodedByteAlign: a.get("EncodedByteAlign"),
                Columns: a.get("Columns"),
                Rows: a.get("Rows"),
                EndOfBlock: a.get("EndOfBlock"),
                BlackIs1: a.get("BlackIs1"),
              });
            }
            readBlock() {
              for (; !this.eof; ) {
                const e = this.ccittFaxDecoder.readNextChar();
                if (-1 === e) {
                  this.eof = !0;
                  return;
                }
                this.ensureBuffer(this.bufferLength + 1);
                this.buffer[this.bufferLength++] = e;
              }
            }
          }
          t.CCITTFaxStream = CCITTFaxStream;
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.CCITTFaxDecoder = void 0;
          var r = a(2);
          const n = -1,
            i = [
              [-1, -1],
              [-1, -1],
              [7, 8],
              [7, 7],
              [6, 6],
              [6, 6],
              [6, 5],
              [6, 5],
              [4, 0],
              [4, 0],
              [4, 0],
              [4, 0],
              [4, 0],
              [4, 0],
              [4, 0],
              [4, 0],
              [3, 1],
              [3, 1],
              [3, 1],
              [3, 1],
              [3, 1],
              [3, 1],
              [3, 1],
              [3, 1],
              [3, 1],
              [3, 1],
              [3, 1],
              [3, 1],
              [3, 1],
              [3, 1],
              [3, 1],
              [3, 1],
              [3, 4],
              [3, 4],
              [3, 4],
              [3, 4],
              [3, 4],
              [3, 4],
              [3, 4],
              [3, 4],
              [3, 4],
              [3, 4],
              [3, 4],
              [3, 4],
              [3, 4],
              [3, 4],
              [3, 4],
              [3, 4],
              [3, 3],
              [3, 3],
              [3, 3],
              [3, 3],
              [3, 3],
              [3, 3],
              [3, 3],
              [3, 3],
              [3, 3],
              [3, 3],
              [3, 3],
              [3, 3],
              [3, 3],
              [3, 3],
              [3, 3],
              [3, 3],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
              [1, 2],
            ],
            s = [
              [-1, -1],
              [12, -2],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [11, 1792],
              [11, 1792],
              [12, 1984],
              [12, 2048],
              [12, 2112],
              [12, 2176],
              [12, 2240],
              [12, 2304],
              [11, 1856],
              [11, 1856],
              [11, 1920],
              [11, 1920],
              [12, 2368],
              [12, 2432],
              [12, 2496],
              [12, 2560],
            ],
            o = [
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [8, 29],
              [8, 29],
              [8, 30],
              [8, 30],
              [8, 45],
              [8, 45],
              [8, 46],
              [8, 46],
              [7, 22],
              [7, 22],
              [7, 22],
              [7, 22],
              [7, 23],
              [7, 23],
              [7, 23],
              [7, 23],
              [8, 47],
              [8, 47],
              [8, 48],
              [8, 48],
              [6, 13],
              [6, 13],
              [6, 13],
              [6, 13],
              [6, 13],
              [6, 13],
              [6, 13],
              [6, 13],
              [7, 20],
              [7, 20],
              [7, 20],
              [7, 20],
              [8, 33],
              [8, 33],
              [8, 34],
              [8, 34],
              [8, 35],
              [8, 35],
              [8, 36],
              [8, 36],
              [8, 37],
              [8, 37],
              [8, 38],
              [8, 38],
              [7, 19],
              [7, 19],
              [7, 19],
              [7, 19],
              [8, 31],
              [8, 31],
              [8, 32],
              [8, 32],
              [6, 1],
              [6, 1],
              [6, 1],
              [6, 1],
              [6, 1],
              [6, 1],
              [6, 1],
              [6, 1],
              [6, 12],
              [6, 12],
              [6, 12],
              [6, 12],
              [6, 12],
              [6, 12],
              [6, 12],
              [6, 12],
              [8, 53],
              [8, 53],
              [8, 54],
              [8, 54],
              [7, 26],
              [7, 26],
              [7, 26],
              [7, 26],
              [8, 39],
              [8, 39],
              [8, 40],
              [8, 40],
              [8, 41],
              [8, 41],
              [8, 42],
              [8, 42],
              [8, 43],
              [8, 43],
              [8, 44],
              [8, 44],
              [7, 21],
              [7, 21],
              [7, 21],
              [7, 21],
              [7, 28],
              [7, 28],
              [7, 28],
              [7, 28],
              [8, 61],
              [8, 61],
              [8, 62],
              [8, 62],
              [8, 63],
              [8, 63],
              [8, 0],
              [8, 0],
              [8, 320],
              [8, 320],
              [8, 384],
              [8, 384],
              [5, 10],
              [5, 10],
              [5, 10],
              [5, 10],
              [5, 10],
              [5, 10],
              [5, 10],
              [5, 10],
              [5, 10],
              [5, 10],
              [5, 10],
              [5, 10],
              [5, 10],
              [5, 10],
              [5, 10],
              [5, 10],
              [5, 11],
              [5, 11],
              [5, 11],
              [5, 11],
              [5, 11],
              [5, 11],
              [5, 11],
              [5, 11],
              [5, 11],
              [5, 11],
              [5, 11],
              [5, 11],
              [5, 11],
              [5, 11],
              [5, 11],
              [5, 11],
              [7, 27],
              [7, 27],
              [7, 27],
              [7, 27],
              [8, 59],
              [8, 59],
              [8, 60],
              [8, 60],
              [9, 1472],
              [9, 1536],
              [9, 1600],
              [9, 1728],
              [7, 18],
              [7, 18],
              [7, 18],
              [7, 18],
              [7, 24],
              [7, 24],
              [7, 24],
              [7, 24],
              [8, 49],
              [8, 49],
              [8, 50],
              [8, 50],
              [8, 51],
              [8, 51],
              [8, 52],
              [8, 52],
              [7, 25],
              [7, 25],
              [7, 25],
              [7, 25],
              [8, 55],
              [8, 55],
              [8, 56],
              [8, 56],
              [8, 57],
              [8, 57],
              [8, 58],
              [8, 58],
              [6, 192],
              [6, 192],
              [6, 192],
              [6, 192],
              [6, 192],
              [6, 192],
              [6, 192],
              [6, 192],
              [6, 1664],
              [6, 1664],
              [6, 1664],
              [6, 1664],
              [6, 1664],
              [6, 1664],
              [6, 1664],
              [6, 1664],
              [8, 448],
              [8, 448],
              [8, 512],
              [8, 512],
              [9, 704],
              [9, 768],
              [8, 640],
              [8, 640],
              [8, 576],
              [8, 576],
              [9, 832],
              [9, 896],
              [9, 960],
              [9, 1024],
              [9, 1088],
              [9, 1152],
              [9, 1216],
              [9, 1280],
              [9, 1344],
              [9, 1408],
              [7, 256],
              [7, 256],
              [7, 256],
              [7, 256],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 2],
              [4, 3],
              [4, 3],
              [4, 3],
              [4, 3],
              [4, 3],
              [4, 3],
              [4, 3],
              [4, 3],
              [4, 3],
              [4, 3],
              [4, 3],
              [4, 3],
              [4, 3],
              [4, 3],
              [4, 3],
              [4, 3],
              [4, 3],
              [4, 3],
              [4, 3],
              [4, 3],
              [4, 3],
              [4, 3],
              [4, 3],
              [4, 3],
              [4, 3],
              [4, 3],
              [4, 3],
              [4, 3],
              [4, 3],
              [4, 3],
              [4, 3],
              [4, 3],
              [5, 128],
              [5, 128],
              [5, 128],
              [5, 128],
              [5, 128],
              [5, 128],
              [5, 128],
              [5, 128],
              [5, 128],
              [5, 128],
              [5, 128],
              [5, 128],
              [5, 128],
              [5, 128],
              [5, 128],
              [5, 128],
              [5, 8],
              [5, 8],
              [5, 8],
              [5, 8],
              [5, 8],
              [5, 8],
              [5, 8],
              [5, 8],
              [5, 8],
              [5, 8],
              [5, 8],
              [5, 8],
              [5, 8],
              [5, 8],
              [5, 8],
              [5, 8],
              [5, 9],
              [5, 9],
              [5, 9],
              [5, 9],
              [5, 9],
              [5, 9],
              [5, 9],
              [5, 9],
              [5, 9],
              [5, 9],
              [5, 9],
              [5, 9],
              [5, 9],
              [5, 9],
              [5, 9],
              [5, 9],
              [6, 16],
              [6, 16],
              [6, 16],
              [6, 16],
              [6, 16],
              [6, 16],
              [6, 16],
              [6, 16],
              [6, 17],
              [6, 17],
              [6, 17],
              [6, 17],
              [6, 17],
              [6, 17],
              [6, 17],
              [6, 17],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 4],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [6, 14],
              [6, 14],
              [6, 14],
              [6, 14],
              [6, 14],
              [6, 14],
              [6, 14],
              [6, 14],
              [6, 15],
              [6, 15],
              [6, 15],
              [6, 15],
              [6, 15],
              [6, 15],
              [6, 15],
              [6, 15],
              [5, 64],
              [5, 64],
              [5, 64],
              [5, 64],
              [5, 64],
              [5, 64],
              [5, 64],
              [5, 64],
              [5, 64],
              [5, 64],
              [5, 64],
              [5, 64],
              [5, 64],
              [5, 64],
              [5, 64],
              [5, 64],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 7],
              [4, 7],
              [4, 7],
              [4, 7],
              [4, 7],
              [4, 7],
              [4, 7],
              [4, 7],
              [4, 7],
              [4, 7],
              [4, 7],
              [4, 7],
              [4, 7],
              [4, 7],
              [4, 7],
              [4, 7],
              [4, 7],
              [4, 7],
              [4, 7],
              [4, 7],
              [4, 7],
              [4, 7],
              [4, 7],
              [4, 7],
              [4, 7],
              [4, 7],
              [4, 7],
              [4, 7],
              [4, 7],
              [4, 7],
              [4, 7],
              [4, 7],
            ],
            c = [
              [-1, -1],
              [-1, -1],
              [12, -2],
              [12, -2],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [11, 1792],
              [11, 1792],
              [11, 1792],
              [11, 1792],
              [12, 1984],
              [12, 1984],
              [12, 2048],
              [12, 2048],
              [12, 2112],
              [12, 2112],
              [12, 2176],
              [12, 2176],
              [12, 2240],
              [12, 2240],
              [12, 2304],
              [12, 2304],
              [11, 1856],
              [11, 1856],
              [11, 1856],
              [11, 1856],
              [11, 1920],
              [11, 1920],
              [11, 1920],
              [11, 1920],
              [12, 2368],
              [12, 2368],
              [12, 2432],
              [12, 2432],
              [12, 2496],
              [12, 2496],
              [12, 2560],
              [12, 2560],
              [10, 18],
              [10, 18],
              [10, 18],
              [10, 18],
              [10, 18],
              [10, 18],
              [10, 18],
              [10, 18],
              [12, 52],
              [12, 52],
              [13, 640],
              [13, 704],
              [13, 768],
              [13, 832],
              [12, 55],
              [12, 55],
              [12, 56],
              [12, 56],
              [13, 1280],
              [13, 1344],
              [13, 1408],
              [13, 1472],
              [12, 59],
              [12, 59],
              [12, 60],
              [12, 60],
              [13, 1536],
              [13, 1600],
              [11, 24],
              [11, 24],
              [11, 24],
              [11, 24],
              [11, 25],
              [11, 25],
              [11, 25],
              [11, 25],
              [13, 1664],
              [13, 1728],
              [12, 320],
              [12, 320],
              [12, 384],
              [12, 384],
              [12, 448],
              [12, 448],
              [13, 512],
              [13, 576],
              [12, 53],
              [12, 53],
              [12, 54],
              [12, 54],
              [13, 896],
              [13, 960],
              [13, 1024],
              [13, 1088],
              [13, 1152],
              [13, 1216],
              [10, 64],
              [10, 64],
              [10, 64],
              [10, 64],
              [10, 64],
              [10, 64],
              [10, 64],
              [10, 64],
            ],
            l = [
              [8, 13],
              [8, 13],
              [8, 13],
              [8, 13],
              [8, 13],
              [8, 13],
              [8, 13],
              [8, 13],
              [8, 13],
              [8, 13],
              [8, 13],
              [8, 13],
              [8, 13],
              [8, 13],
              [8, 13],
              [8, 13],
              [11, 23],
              [11, 23],
              [12, 50],
              [12, 51],
              [12, 44],
              [12, 45],
              [12, 46],
              [12, 47],
              [12, 57],
              [12, 58],
              [12, 61],
              [12, 256],
              [10, 16],
              [10, 16],
              [10, 16],
              [10, 16],
              [10, 17],
              [10, 17],
              [10, 17],
              [10, 17],
              [12, 48],
              [12, 49],
              [12, 62],
              [12, 63],
              [12, 30],
              [12, 31],
              [12, 32],
              [12, 33],
              [12, 40],
              [12, 41],
              [11, 22],
              [11, 22],
              [8, 14],
              [8, 14],
              [8, 14],
              [8, 14],
              [8, 14],
              [8, 14],
              [8, 14],
              [8, 14],
              [8, 14],
              [8, 14],
              [8, 14],
              [8, 14],
              [8, 14],
              [8, 14],
              [8, 14],
              [8, 14],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 10],
              [7, 11],
              [7, 11],
              [7, 11],
              [7, 11],
              [7, 11],
              [7, 11],
              [7, 11],
              [7, 11],
              [7, 11],
              [7, 11],
              [7, 11],
              [7, 11],
              [7, 11],
              [7, 11],
              [7, 11],
              [7, 11],
              [7, 11],
              [7, 11],
              [7, 11],
              [7, 11],
              [7, 11],
              [7, 11],
              [7, 11],
              [7, 11],
              [7, 11],
              [7, 11],
              [7, 11],
              [7, 11],
              [7, 11],
              [7, 11],
              [7, 11],
              [7, 11],
              [9, 15],
              [9, 15],
              [9, 15],
              [9, 15],
              [9, 15],
              [9, 15],
              [9, 15],
              [9, 15],
              [12, 128],
              [12, 192],
              [12, 26],
              [12, 27],
              [12, 28],
              [12, 29],
              [11, 19],
              [11, 19],
              [11, 20],
              [11, 20],
              [12, 34],
              [12, 35],
              [12, 36],
              [12, 37],
              [12, 38],
              [12, 39],
              [11, 21],
              [11, 21],
              [12, 42],
              [12, 43],
              [10, 0],
              [10, 0],
              [10, 0],
              [10, 0],
              [7, 12],
              [7, 12],
              [7, 12],
              [7, 12],
              [7, 12],
              [7, 12],
              [7, 12],
              [7, 12],
              [7, 12],
              [7, 12],
              [7, 12],
              [7, 12],
              [7, 12],
              [7, 12],
              [7, 12],
              [7, 12],
              [7, 12],
              [7, 12],
              [7, 12],
              [7, 12],
              [7, 12],
              [7, 12],
              [7, 12],
              [7, 12],
              [7, 12],
              [7, 12],
              [7, 12],
              [7, 12],
              [7, 12],
              [7, 12],
              [7, 12],
              [7, 12],
            ],
            h = [
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [-1, -1],
              [6, 9],
              [6, 8],
              [5, 7],
              [5, 7],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 6],
              [4, 5],
              [4, 5],
              [4, 5],
              [4, 5],
              [3, 1],
              [3, 1],
              [3, 1],
              [3, 1],
              [3, 1],
              [3, 1],
              [3, 1],
              [3, 1],
              [3, 4],
              [3, 4],
              [3, 4],
              [3, 4],
              [3, 4],
              [3, 4],
              [3, 4],
              [3, 4],
              [2, 3],
              [2, 3],
              [2, 3],
              [2, 3],
              [2, 3],
              [2, 3],
              [2, 3],
              [2, 3],
              [2, 3],
              [2, 3],
              [2, 3],
              [2, 3],
              [2, 3],
              [2, 3],
              [2, 3],
              [2, 3],
              [2, 2],
              [2, 2],
              [2, 2],
              [2, 2],
              [2, 2],
              [2, 2],
              [2, 2],
              [2, 2],
              [2, 2],
              [2, 2],
              [2, 2],
              [2, 2],
              [2, 2],
              [2, 2],
              [2, 2],
              [2, 2],
            ];
          t.CCITTFaxDecoder = class CCITTFaxDecoder {
            constructor(e, t = {}) {
              if (!e || "function" != typeof e.next)
                throw new Error(
                  'CCITTFaxDecoder - invalid "source" parameter.',
                );
              this.source = e;
              this.eof = !1;
              this.encoding = t.K || 0;
              this.eoline = t.EndOfLine || !1;
              this.byteAlign = t.EncodedByteAlign || !1;
              this.columns = t.Columns || 1728;
              this.rows = t.Rows || 0;
              this.eoblock = t.EndOfBlock ?? !0;
              this.black = t.BlackIs1 || !1;
              this.codingLine = new Uint32Array(this.columns + 1);
              this.refLine = new Uint32Array(this.columns + 2);
              this.codingLine[0] = this.columns;
              this.codingPos = 0;
              this.row = 0;
              this.nextLine2D = this.encoding < 0;
              this.inputBits = 0;
              this.inputBuf = 0;
              this.outputBits = 0;
              this.rowsDone = !1;
              let a;
              for (; 0 === (a = this._lookBits(12)); ) this._eatBits(1);
              1 === a && this._eatBits(12);
              if (this.encoding > 0) {
                this.nextLine2D = !this._lookBits(1);
                this._eatBits(1);
              }
            }
            readNextChar() {
              if (this.eof) return -1;
              const e = this.refLine,
                t = this.codingLine,
                a = this.columns;
              let i, s, o, c, l;
              if (0 === this.outputBits) {
                this.rowsDone && (this.eof = !0);
                if (this.eof) return -1;
                this.err = !1;
                let o, l, h;
                if (this.nextLine2D) {
                  for (c = 0; t[c] < a; ++c) e[c] = t[c];
                  e[c++] = a;
                  e[c] = a;
                  t[0] = 0;
                  this.codingPos = 0;
                  i = 0;
                  s = 0;
                  for (; t[this.codingPos] < a; ) {
                    o = this._getTwoDimCode();
                    switch (o) {
                      case 0:
                        this._addPixels(e[i + 1], s);
                        e[i + 1] < a && (i += 2);
                        break;
                      case 1:
                        o = l = 0;
                        if (s) {
                          do {
                            o += h = this._getBlackCode();
                          } while (h >= 64);
                          do {
                            l += h = this._getWhiteCode();
                          } while (h >= 64);
                        } else {
                          do {
                            o += h = this._getWhiteCode();
                          } while (h >= 64);
                          do {
                            l += h = this._getBlackCode();
                          } while (h >= 64);
                        }
                        this._addPixels(t[this.codingPos] + o, s);
                        t[this.codingPos] < a &&
                          this._addPixels(t[this.codingPos] + l, 1 ^ s);
                        for (; e[i] <= t[this.codingPos] && e[i] < a; ) i += 2;
                        break;
                      case 7:
                        this._addPixels(e[i] + 3, s);
                        s ^= 1;
                        if (t[this.codingPos] < a) {
                          ++i;
                          for (; e[i] <= t[this.codingPos] && e[i] < a; )
                            i += 2;
                        }
                        break;
                      case 5:
                        this._addPixels(e[i] + 2, s);
                        s ^= 1;
                        if (t[this.codingPos] < a) {
                          ++i;
                          for (; e[i] <= t[this.codingPos] && e[i] < a; )
                            i += 2;
                        }
                        break;
                      case 3:
                        this._addPixels(e[i] + 1, s);
                        s ^= 1;
                        if (t[this.codingPos] < a) {
                          ++i;
                          for (; e[i] <= t[this.codingPos] && e[i] < a; )
                            i += 2;
                        }
                        break;
                      case 2:
                        this._addPixels(e[i], s);
                        s ^= 1;
                        if (t[this.codingPos] < a) {
                          ++i;
                          for (; e[i] <= t[this.codingPos] && e[i] < a; )
                            i += 2;
                        }
                        break;
                      case 8:
                        this._addPixelsNeg(e[i] - 3, s);
                        s ^= 1;
                        if (t[this.codingPos] < a) {
                          i > 0 ? --i : ++i;
                          for (; e[i] <= t[this.codingPos] && e[i] < a; )
                            i += 2;
                        }
                        break;
                      case 6:
                        this._addPixelsNeg(e[i] - 2, s);
                        s ^= 1;
                        if (t[this.codingPos] < a) {
                          i > 0 ? --i : ++i;
                          for (; e[i] <= t[this.codingPos] && e[i] < a; )
                            i += 2;
                        }
                        break;
                      case 4:
                        this._addPixelsNeg(e[i] - 1, s);
                        s ^= 1;
                        if (t[this.codingPos] < a) {
                          i > 0 ? --i : ++i;
                          for (; e[i] <= t[this.codingPos] && e[i] < a; )
                            i += 2;
                        }
                        break;
                      case n:
                        this._addPixels(a, 0);
                        this.eof = !0;
                        break;
                      default:
                        (0, r.info)("bad 2d code");
                        this._addPixels(a, 0);
                        this.err = !0;
                    }
                  }
                } else {
                  t[0] = 0;
                  this.codingPos = 0;
                  s = 0;
                  for (; t[this.codingPos] < a; ) {
                    o = 0;
                    if (s)
                      do {
                        o += h = this._getBlackCode();
                      } while (h >= 64);
                    else
                      do {
                        o += h = this._getWhiteCode();
                      } while (h >= 64);
                    this._addPixels(t[this.codingPos] + o, s);
                    s ^= 1;
                  }
                }
                let u = !1;
                this.byteAlign && (this.inputBits &= -8);
                if (this.eoblock || this.row !== this.rows - 1) {
                  o = this._lookBits(12);
                  if (this.eoline)
                    for (; o !== n && 1 !== o; ) {
                      this._eatBits(1);
                      o = this._lookBits(12);
                    }
                  else
                    for (; 0 === o; ) {
                      this._eatBits(1);
                      o = this._lookBits(12);
                    }
                  if (1 === o) {
                    this._eatBits(12);
                    u = !0;
                  } else o === n && (this.eof = !0);
                } else this.rowsDone = !0;
                if (!this.eof && this.encoding > 0 && !this.rowsDone) {
                  this.nextLine2D = !this._lookBits(1);
                  this._eatBits(1);
                }
                if (this.eoblock && u && this.byteAlign) {
                  o = this._lookBits(12);
                  if (1 === o) {
                    this._eatBits(12);
                    if (this.encoding > 0) {
                      this._lookBits(1);
                      this._eatBits(1);
                    }
                    if (this.encoding >= 0)
                      for (c = 0; c < 4; ++c) {
                        o = this._lookBits(12);
                        1 !== o && (0, r.info)("bad rtc code: " + o);
                        this._eatBits(12);
                        if (this.encoding > 0) {
                          this._lookBits(1);
                          this._eatBits(1);
                        }
                      }
                    this.eof = !0;
                  }
                } else if (this.err && this.eoline) {
                  for (;;) {
                    o = this._lookBits(13);
                    if (o === n) {
                      this.eof = !0;
                      return -1;
                    }
                    if (o >> 1 == 1) break;
                    this._eatBits(1);
                  }
                  this._eatBits(12);
                  if (this.encoding > 0) {
                    this._eatBits(1);
                    this.nextLine2D = !(1 & o);
                  }
                }
                this.outputBits =
                  t[0] > 0 ? t[(this.codingPos = 0)] : t[(this.codingPos = 1)];
                this.row++;
              }
              if (this.outputBits >= 8) {
                l = 1 & this.codingPos ? 0 : 255;
                this.outputBits -= 8;
                if (0 === this.outputBits && t[this.codingPos] < a) {
                  this.codingPos++;
                  this.outputBits = t[this.codingPos] - t[this.codingPos - 1];
                }
              } else {
                o = 8;
                l = 0;
                do {
                  if ("number" != typeof this.outputBits)
                    throw new r.FormatError(
                      'Invalid /CCITTFaxDecode data, "outputBits" must be a number.',
                    );
                  if (this.outputBits > o) {
                    l <<= o;
                    1 & this.codingPos || (l |= 255 >> (8 - o));
                    this.outputBits -= o;
                    o = 0;
                  } else {
                    l <<= this.outputBits;
                    1 & this.codingPos || (l |= 255 >> (8 - this.outputBits));
                    o -= this.outputBits;
                    this.outputBits = 0;
                    if (t[this.codingPos] < a) {
                      this.codingPos++;
                      this.outputBits =
                        t[this.codingPos] - t[this.codingPos - 1];
                    } else if (o > 0) {
                      l <<= o;
                      o = 0;
                    }
                  }
                } while (o);
              }
              this.black && (l ^= 255);
              return l;
            }
            _addPixels(e, t) {
              const a = this.codingLine;
              let n = this.codingPos;
              if (e > a[n]) {
                if (e > this.columns) {
                  (0, r.info)("row is wrong length");
                  this.err = !0;
                  e = this.columns;
                }
                (1 & n) ^ t && ++n;
                a[n] = e;
              }
              this.codingPos = n;
            }
            _addPixelsNeg(e, t) {
              const a = this.codingLine;
              let n = this.codingPos;
              if (e > a[n]) {
                if (e > this.columns) {
                  (0, r.info)("row is wrong length");
                  this.err = !0;
                  e = this.columns;
                }
                (1 & n) ^ t && ++n;
                a[n] = e;
              } else if (e < a[n]) {
                if (e < 0) {
                  (0, r.info)("invalid code");
                  this.err = !0;
                  e = 0;
                }
                for (; n > 0 && e < a[n - 1]; ) --n;
                a[n] = e;
              }
              this.codingPos = n;
            }
            _findTableCode(e, t, a, r) {
              const i = r || 0;
              for (let r = e; r <= t; ++r) {
                let e = this._lookBits(r);
                if (e === n) return [!0, 1, !1];
                r < t && (e <<= t - r);
                if (!i || e >= i) {
                  const t = a[e - i];
                  if (t[0] === r) {
                    this._eatBits(r);
                    return [!0, t[1], !0];
                  }
                }
              }
              return [!1, 0, !1];
            }
            _getTwoDimCode() {
              let e,
                t = 0;
              if (this.eoblock) {
                t = this._lookBits(7);
                e = i[t];
                if (e?.[0] > 0) {
                  this._eatBits(e[0]);
                  return e[1];
                }
              } else {
                const e = this._findTableCode(1, 7, i);
                if (e[0] && e[2]) return e[1];
              }
              (0, r.info)("Bad two dim code");
              return n;
            }
            _getWhiteCode() {
              let e,
                t = 0;
              if (this.eoblock) {
                t = this._lookBits(12);
                if (t === n) return 1;
                e = t >> 5 == 0 ? s[t] : o[t >> 3];
                if (e[0] > 0) {
                  this._eatBits(e[0]);
                  return e[1];
                }
              } else {
                let e = this._findTableCode(1, 9, o);
                if (e[0]) return e[1];
                e = this._findTableCode(11, 12, s);
                if (e[0]) return e[1];
              }
              (0, r.info)("bad white code");
              this._eatBits(1);
              return 1;
            }
            _getBlackCode() {
              let e, t;
              if (this.eoblock) {
                e = this._lookBits(13);
                if (e === n) return 1;
                t =
                  e >> 7 == 0
                    ? c[e]
                    : e >> 9 == 0 && e >> 7 != 0
                      ? l[(e >> 1) - 64]
                      : h[e >> 7];
                if (t[0] > 0) {
                  this._eatBits(t[0]);
                  return t[1];
                }
              } else {
                let e = this._findTableCode(2, 6, h);
                if (e[0]) return e[1];
                e = this._findTableCode(7, 12, l, 64);
                if (e[0]) return e[1];
                e = this._findTableCode(10, 13, c);
                if (e[0]) return e[1];
              }
              (0, r.info)("bad black code");
              this._eatBits(1);
              return 1;
            }
            _lookBits(e) {
              let t;
              for (; this.inputBits < e; ) {
                if (-1 === (t = this.source.next()))
                  return 0 === this.inputBits
                    ? n
                    : (this.inputBuf << (e - this.inputBits)) &
                        (65535 >> (16 - e));
                this.inputBuf = (this.inputBuf << 8) | t;
                this.inputBits += 8;
              }
              return (
                (this.inputBuf >> (this.inputBits - e)) & (65535 >> (16 - e))
              );
            }
            _eatBits(e) {
              (this.inputBits -= e) < 0 && (this.inputBits = 0);
            }
          };
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.FlateStream = void 0;
          var r = a(18),
            n = a(2);
          const i = new Int32Array([
              16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15,
            ]),
            s = new Int32Array([
              3, 4, 5, 6, 7, 8, 9, 10, 65547, 65549, 65551, 65553, 131091,
              131095, 131099, 131103, 196643, 196651, 196659, 196667, 262211,
              262227, 262243, 262259, 327811, 327843, 327875, 327907, 258, 258,
              258,
            ]),
            o = new Int32Array([
              1, 2, 3, 4, 65541, 65543, 131081, 131085, 196625, 196633, 262177,
              262193, 327745, 327777, 393345, 393409, 459009, 459137, 524801,
              525057, 590849, 591361, 657409, 658433, 724993, 727041, 794625,
              798721, 868353, 876545,
            ]),
            c = [
              new Int32Array([
                459008, 524368, 524304, 524568, 459024, 524400, 524336, 590016,
                459016, 524384, 524320, 589984, 524288, 524416, 524352, 590048,
                459012, 524376, 524312, 589968, 459028, 524408, 524344, 590032,
                459020, 524392, 524328, 59e4, 524296, 524424, 524360, 590064,
                459010, 524372, 524308, 524572, 459026, 524404, 524340, 590024,
                459018, 524388, 524324, 589992, 524292, 524420, 524356, 590056,
                459014, 524380, 524316, 589976, 459030, 524412, 524348, 590040,
                459022, 524396, 524332, 590008, 524300, 524428, 524364, 590072,
                459009, 524370, 524306, 524570, 459025, 524402, 524338, 590020,
                459017, 524386, 524322, 589988, 524290, 524418, 524354, 590052,
                459013, 524378, 524314, 589972, 459029, 524410, 524346, 590036,
                459021, 524394, 524330, 590004, 524298, 524426, 524362, 590068,
                459011, 524374, 524310, 524574, 459027, 524406, 524342, 590028,
                459019, 524390, 524326, 589996, 524294, 524422, 524358, 590060,
                459015, 524382, 524318, 589980, 459031, 524414, 524350, 590044,
                459023, 524398, 524334, 590012, 524302, 524430, 524366, 590076,
                459008, 524369, 524305, 524569, 459024, 524401, 524337, 590018,
                459016, 524385, 524321, 589986, 524289, 524417, 524353, 590050,
                459012, 524377, 524313, 589970, 459028, 524409, 524345, 590034,
                459020, 524393, 524329, 590002, 524297, 524425, 524361, 590066,
                459010, 524373, 524309, 524573, 459026, 524405, 524341, 590026,
                459018, 524389, 524325, 589994, 524293, 524421, 524357, 590058,
                459014, 524381, 524317, 589978, 459030, 524413, 524349, 590042,
                459022, 524397, 524333, 590010, 524301, 524429, 524365, 590074,
                459009, 524371, 524307, 524571, 459025, 524403, 524339, 590022,
                459017, 524387, 524323, 589990, 524291, 524419, 524355, 590054,
                459013, 524379, 524315, 589974, 459029, 524411, 524347, 590038,
                459021, 524395, 524331, 590006, 524299, 524427, 524363, 590070,
                459011, 524375, 524311, 524575, 459027, 524407, 524343, 590030,
                459019, 524391, 524327, 589998, 524295, 524423, 524359, 590062,
                459015, 524383, 524319, 589982, 459031, 524415, 524351, 590046,
                459023, 524399, 524335, 590014, 524303, 524431, 524367, 590078,
                459008, 524368, 524304, 524568, 459024, 524400, 524336, 590017,
                459016, 524384, 524320, 589985, 524288, 524416, 524352, 590049,
                459012, 524376, 524312, 589969, 459028, 524408, 524344, 590033,
                459020, 524392, 524328, 590001, 524296, 524424, 524360, 590065,
                459010, 524372, 524308, 524572, 459026, 524404, 524340, 590025,
                459018, 524388, 524324, 589993, 524292, 524420, 524356, 590057,
                459014, 524380, 524316, 589977, 459030, 524412, 524348, 590041,
                459022, 524396, 524332, 590009, 524300, 524428, 524364, 590073,
                459009, 524370, 524306, 524570, 459025, 524402, 524338, 590021,
                459017, 524386, 524322, 589989, 524290, 524418, 524354, 590053,
                459013, 524378, 524314, 589973, 459029, 524410, 524346, 590037,
                459021, 524394, 524330, 590005, 524298, 524426, 524362, 590069,
                459011, 524374, 524310, 524574, 459027, 524406, 524342, 590029,
                459019, 524390, 524326, 589997, 524294, 524422, 524358, 590061,
                459015, 524382, 524318, 589981, 459031, 524414, 524350, 590045,
                459023, 524398, 524334, 590013, 524302, 524430, 524366, 590077,
                459008, 524369, 524305, 524569, 459024, 524401, 524337, 590019,
                459016, 524385, 524321, 589987, 524289, 524417, 524353, 590051,
                459012, 524377, 524313, 589971, 459028, 524409, 524345, 590035,
                459020, 524393, 524329, 590003, 524297, 524425, 524361, 590067,
                459010, 524373, 524309, 524573, 459026, 524405, 524341, 590027,
                459018, 524389, 524325, 589995, 524293, 524421, 524357, 590059,
                459014, 524381, 524317, 589979, 459030, 524413, 524349, 590043,
                459022, 524397, 524333, 590011, 524301, 524429, 524365, 590075,
                459009, 524371, 524307, 524571, 459025, 524403, 524339, 590023,
                459017, 524387, 524323, 589991, 524291, 524419, 524355, 590055,
                459013, 524379, 524315, 589975, 459029, 524411, 524347, 590039,
                459021, 524395, 524331, 590007, 524299, 524427, 524363, 590071,
                459011, 524375, 524311, 524575, 459027, 524407, 524343, 590031,
                459019, 524391, 524327, 589999, 524295, 524423, 524359, 590063,
                459015, 524383, 524319, 589983, 459031, 524415, 524351, 590047,
                459023, 524399, 524335, 590015, 524303, 524431, 524367, 590079,
              ]),
              9,
            ],
            l = [
              new Int32Array([
                327680, 327696, 327688, 327704, 327684, 327700, 327692, 327708,
                327682, 327698, 327690, 327706, 327686, 327702, 327694, 0,
                327681, 327697, 327689, 327705, 327685, 327701, 327693, 327709,
                327683, 327699, 327691, 327707, 327687, 327703, 327695, 0,
              ]),
              5,
            ];
          class FlateStream extends r.DecodeStream {
            constructor(e, t) {
              super(t);
              this.str = e;
              this.dict = e.dict;
              const a = e.getByte(),
                r = e.getByte();
              if (-1 === a || -1 === r)
                throw new n.FormatError(
                  `Invalid header in flate stream: ${a}, ${r}`,
                );
              if (8 != (15 & a))
                throw new n.FormatError(
                  `Unknown compression method in flate stream: ${a}, ${r}`,
                );
              if (((a << 8) + r) % 31 != 0)
                throw new n.FormatError(
                  `Bad FCHECK in flate stream: ${a}, ${r}`,
                );
              if (32 & r)
                throw new n.FormatError(
                  `FDICT bit set in flate stream: ${a}, ${r}`,
                );
              this.codeSize = 0;
              this.codeBuf = 0;
            }
            getBits(e) {
              const t = this.str;
              let a,
                r = this.codeSize,
                i = this.codeBuf;
              for (; r < e; ) {
                if (-1 === (a = t.getByte()))
                  throw new n.FormatError("Bad encoding in flate stream");
                i |= a << r;
                r += 8;
              }
              a = i & ((1 << e) - 1);
              this.codeBuf = i >> e;
              this.codeSize = r -= e;
              return a;
            }
            getCode(e) {
              const t = this.str,
                a = e[0],
                r = e[1];
              let i,
                s = this.codeSize,
                o = this.codeBuf;
              for (; s < r && -1 !== (i = t.getByte()); ) {
                o |= i << s;
                s += 8;
              }
              const c = a[o & ((1 << r) - 1)],
                l = c >> 16,
                h = 65535 & c;
              if (l < 1 || s < l)
                throw new n.FormatError("Bad encoding in flate stream");
              this.codeBuf = o >> l;
              this.codeSize = s - l;
              return h;
            }
            generateHuffmanTable(e) {
              const t = e.length;
              let a,
                r = 0;
              for (a = 0; a < t; ++a) e[a] > r && (r = e[a]);
              const n = 1 << r,
                i = new Int32Array(n);
              for (let s = 1, o = 0, c = 2; s <= r; ++s, o <<= 1, c <<= 1)
                for (let r = 0; r < t; ++r)
                  if (e[r] === s) {
                    let e = 0,
                      t = o;
                    for (a = 0; a < s; ++a) {
                      e = (e << 1) | (1 & t);
                      t >>= 1;
                    }
                    for (a = e; a < n; a += c) i[a] = (s << 16) | r;
                    ++o;
                  }
              return [i, r];
            }
            readBlock() {
              let e, t;
              const a = this.str;
              let r,
                h,
                u = this.getBits(3);
              1 & u && (this.eof = !0);
              u >>= 1;
              if (0 === u) {
                let t;
                if (-1 === (t = a.getByte()))
                  throw new n.FormatError("Bad block header in flate stream");
                let r = t;
                if (-1 === (t = a.getByte()))
                  throw new n.FormatError("Bad block header in flate stream");
                r |= t << 8;
                if (-1 === (t = a.getByte()))
                  throw new n.FormatError("Bad block header in flate stream");
                let i = t;
                if (-1 === (t = a.getByte()))
                  throw new n.FormatError("Bad block header in flate stream");
                i |= t << 8;
                if (i !== (65535 & ~r) && (0 !== r || 0 !== i))
                  throw new n.FormatError(
                    "Bad uncompressed block length in flate stream",
                  );
                this.codeBuf = 0;
                this.codeSize = 0;
                const s = this.bufferLength,
                  o = s + r;
                e = this.ensureBuffer(o);
                this.bufferLength = o;
                if (0 === r) -1 === a.peekByte() && (this.eof = !0);
                else {
                  const t = a.getBytes(r);
                  e.set(t, s);
                  t.length < r && (this.eof = !0);
                }
                return;
              }
              if (1 === u) {
                r = c;
                h = l;
              } else {
                if (2 !== u)
                  throw new n.FormatError("Unknown block type in flate stream");
                {
                  const e = this.getBits(5) + 257,
                    a = this.getBits(5) + 1,
                    n = this.getBits(4) + 4,
                    s = new Uint8Array(i.length);
                  let o;
                  for (o = 0; o < n; ++o) s[i[o]] = this.getBits(3);
                  const c = this.generateHuffmanTable(s);
                  t = 0;
                  o = 0;
                  const l = e + a,
                    u = new Uint8Array(l);
                  let d, f, g;
                  for (; o < l; ) {
                    const e = this.getCode(c);
                    if (16 === e) {
                      d = 2;
                      f = 3;
                      g = t;
                    } else if (17 === e) {
                      d = 3;
                      f = 3;
                      g = t = 0;
                    } else {
                      if (18 !== e) {
                        u[o++] = t = e;
                        continue;
                      }
                      d = 7;
                      f = 11;
                      g = t = 0;
                    }
                    let a = this.getBits(d) + f;
                    for (; a-- > 0; ) u[o++] = g;
                  }
                  r = this.generateHuffmanTable(u.subarray(0, e));
                  h = this.generateHuffmanTable(u.subarray(e, l));
                }
              }
              e = this.buffer;
              let d = e ? e.length : 0,
                f = this.bufferLength;
              for (;;) {
                let a = this.getCode(r);
                if (a < 256) {
                  if (f + 1 >= d) {
                    e = this.ensureBuffer(f + 1);
                    d = e.length;
                  }
                  e[f++] = a;
                  continue;
                }
                if (256 === a) {
                  this.bufferLength = f;
                  return;
                }
                a -= 257;
                a = s[a];
                let n = a >> 16;
                n > 0 && (n = this.getBits(n));
                t = (65535 & a) + n;
                a = this.getCode(h);
                a = o[a];
                n = a >> 16;
                n > 0 && (n = this.getBits(n));
                const i = (65535 & a) + n;
                if (f + t >= d) {
                  e = this.ensureBuffer(f + t);
                  d = e.length;
                }
                for (let a = 0; a < t; ++a, ++f) e[f] = e[f - i];
              }
            }
          }
          t.FlateStream = FlateStream;
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.Jbig2Stream = void 0;
          var r = a(5),
            n = a(18),
            i = a(4),
            s = a(24),
            o = a(2);
          class Jbig2Stream extends n.DecodeStream {
            constructor(e, t, a) {
              super(t);
              this.stream = e;
              this.dict = e.dict;
              this.maybeLength = t;
              this.params = a;
            }
            get bytes() {
              return (0, o.shadow)(
                this,
                "bytes",
                this.stream.getBytes(this.maybeLength),
              );
            }
            ensureBuffer(e) {}
            readBlock() {
              if (this.eof) return;
              const e = new s.Jbig2Image(),
                t = [];
              if (this.params instanceof i.Dict) {
                const e = this.params.get("JBIG2Globals");
                if (e instanceof r.BaseStream) {
                  const a = e.getBytes();
                  t.push({ data: a, start: 0, end: a.length });
                }
              }
              t.push({ data: this.bytes, start: 0, end: this.bytes.length });
              const a = e.parseChunks(t),
                n = a.length;
              for (let e = 0; e < n; e++) a[e] ^= 255;
              this.buffer = a;
              this.bufferLength = n;
              this.eof = !0;
            }
          }
          t.Jbig2Stream = Jbig2Stream;
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.Jbig2Image = void 0;
          var r = a(2),
            n = a(3),
            i = a(25),
            s = a(21);
          class Jbig2Error extends r.BaseException {
            constructor(e) {
              super(`JBIG2 error: ${e}`, "Jbig2Error");
            }
          }
          class ContextCache {
            getContexts(e) {
              return e in this ? this[e] : (this[e] = new Int8Array(65536));
            }
          }
          class DecodingContext {
            constructor(e, t, a) {
              this.data = e;
              this.start = t;
              this.end = a;
            }
            get decoder() {
              const e = new i.ArithmeticDecoder(
                this.data,
                this.start,
                this.end,
              );
              return (0, r.shadow)(this, "decoder", e);
            }
            get contextCache() {
              const e = new ContextCache();
              return (0, r.shadow)(this, "contextCache", e);
            }
          }
          const o = 2 ** 31 - 1,
            c = -(2 ** 31);
          function decodeInteger(e, t, a) {
            const r = e.getContexts(t);
            let n = 1;
            function readBits(e) {
              let t = 0;
              for (let i = 0; i < e; i++) {
                const e = a.readBit(r, n);
                n = n < 256 ? (n << 1) | e : (511 & ((n << 1) | e)) | 256;
                t = (t << 1) | e;
              }
              return t >>> 0;
            }
            const i = readBits(1),
              s = readBits(1)
                ? readBits(1)
                  ? readBits(1)
                    ? readBits(1)
                      ? readBits(1)
                        ? readBits(32) + 4436
                        : readBits(12) + 340
                      : readBits(8) + 84
                    : readBits(6) + 20
                  : readBits(4) + 4
                : readBits(2);
            let l;
            0 === i ? (l = s) : s > 0 && (l = -s);
            return l >= c && l <= o ? l : null;
          }
          function decodeIAID(e, t, a) {
            const r = e.getContexts("IAID");
            let n = 1;
            for (let e = 0; e < a; e++) {
              n = (n << 1) | t.readBit(r, n);
            }
            return a < 31 ? n & ((1 << a) - 1) : 2147483647 & n;
          }
          const l = [
              "SymbolDictionary",
              null,
              null,
              null,
              "IntermediateTextRegion",
              null,
              "ImmediateTextRegion",
              "ImmediateLosslessTextRegion",
              null,
              null,
              null,
              null,
              null,
              null,
              null,
              null,
              "PatternDictionary",
              null,
              null,
              null,
              "IntermediateHalftoneRegion",
              null,
              "ImmediateHalftoneRegion",
              "ImmediateLosslessHalftoneRegion",
              null,
              null,
              null,
              null,
              null,
              null,
              null,
              null,
              null,
              null,
              null,
              null,
              "IntermediateGenericRegion",
              null,
              "ImmediateGenericRegion",
              "ImmediateLosslessGenericRegion",
              "IntermediateGenericRefinementRegion",
              null,
              "ImmediateGenericRefinementRegion",
              "ImmediateLosslessGenericRefinementRegion",
              null,
              null,
              null,
              null,
              "PageInformation",
              "EndOfPage",
              "EndOfStripe",
              "EndOfFile",
              "Profiles",
              "Tables",
              null,
              null,
              null,
              null,
              null,
              null,
              null,
              null,
              "Extension",
            ],
            h = [
              [
                { x: -1, y: -2 },
                { x: 0, y: -2 },
                { x: 1, y: -2 },
                { x: -2, y: -1 },
                { x: -1, y: -1 },
                { x: 0, y: -1 },
                { x: 1, y: -1 },
                { x: 2, y: -1 },
                { x: -4, y: 0 },
                { x: -3, y: 0 },
                { x: -2, y: 0 },
                { x: -1, y: 0 },
              ],
              [
                { x: -1, y: -2 },
                { x: 0, y: -2 },
                { x: 1, y: -2 },
                { x: 2, y: -2 },
                { x: -2, y: -1 },
                { x: -1, y: -1 },
                { x: 0, y: -1 },
                { x: 1, y: -1 },
                { x: 2, y: -1 },
                { x: -3, y: 0 },
                { x: -2, y: 0 },
                { x: -1, y: 0 },
              ],
              [
                { x: -1, y: -2 },
                { x: 0, y: -2 },
                { x: 1, y: -2 },
                { x: -2, y: -1 },
                { x: -1, y: -1 },
                { x: 0, y: -1 },
                { x: 1, y: -1 },
                { x: -2, y: 0 },
                { x: -1, y: 0 },
              ],
              [
                { x: -3, y: -1 },
                { x: -2, y: -1 },
                { x: -1, y: -1 },
                { x: 0, y: -1 },
                { x: 1, y: -1 },
                { x: -4, y: 0 },
                { x: -3, y: 0 },
                { x: -2, y: 0 },
                { x: -1, y: 0 },
              ],
            ],
            u = [
              {
                coding: [
                  { x: 0, y: -1 },
                  { x: 1, y: -1 },
                  { x: -1, y: 0 },
                ],
                reference: [
                  { x: 0, y: -1 },
                  { x: 1, y: -1 },
                  { x: -1, y: 0 },
                  { x: 0, y: 0 },
                  { x: 1, y: 0 },
                  { x: -1, y: 1 },
                  { x: 0, y: 1 },
                  { x: 1, y: 1 },
                ],
              },
              {
                coding: [
                  { x: -1, y: -1 },
                  { x: 0, y: -1 },
                  { x: 1, y: -1 },
                  { x: -1, y: 0 },
                ],
                reference: [
                  { x: 0, y: -1 },
                  { x: -1, y: 0 },
                  { x: 0, y: 0 },
                  { x: 1, y: 0 },
                  { x: 0, y: 1 },
                  { x: 1, y: 1 },
                ],
              },
            ],
            d = [39717, 1941, 229, 405],
            f = [32, 8];
          function decodeBitmap(e, t, a, r, n, i, s, o) {
            if (e) {
              return decodeMMRBitmap(
                new Reader(o.data, o.start, o.end),
                t,
                a,
                !1,
              );
            }
            if (
              0 === r &&
              !i &&
              !n &&
              4 === s.length &&
              3 === s[0].x &&
              -1 === s[0].y &&
              -3 === s[1].x &&
              -1 === s[1].y &&
              2 === s[2].x &&
              -2 === s[2].y &&
              -2 === s[3].x &&
              -2 === s[3].y
            )
              return (function decodeBitmapTemplate0(e, t, a) {
                const r = a.decoder,
                  n = a.contextCache.getContexts("GB"),
                  i = [];
                let s, o, c, l, h, u, d;
                for (o = 0; o < t; o++) {
                  h = i[o] = new Uint8Array(e);
                  u = o < 1 ? h : i[o - 1];
                  d = o < 2 ? h : i[o - 2];
                  s =
                    (d[0] << 13) |
                    (d[1] << 12) |
                    (d[2] << 11) |
                    (u[0] << 7) |
                    (u[1] << 6) |
                    (u[2] << 5) |
                    (u[3] << 4);
                  for (c = 0; c < e; c++) {
                    h[c] = l = r.readBit(n, s);
                    s =
                      ((31735 & s) << 1) |
                      (c + 3 < e ? d[c + 3] << 11 : 0) |
                      (c + 4 < e ? u[c + 4] << 4 : 0) |
                      l;
                  }
                }
                return i;
              })(t, a, o);
            const c = !!i,
              l = h[r].concat(s);
            l.sort(function (e, t) {
              return e.y - t.y || e.x - t.x;
            });
            const u = l.length,
              f = new Int8Array(u),
              g = new Int8Array(u),
              p = [];
            let m,
              b,
              y = 0,
              w = 0,
              S = 0,
              x = 0;
            for (b = 0; b < u; b++) {
              f[b] = l[b].x;
              g[b] = l[b].y;
              w = Math.min(w, l[b].x);
              S = Math.max(S, l[b].x);
              x = Math.min(x, l[b].y);
              b < u - 1 && l[b].y === l[b + 1].y && l[b].x === l[b + 1].x - 1
                ? (y |= 1 << (u - 1 - b))
                : p.push(b);
            }
            const C = p.length,
              k = new Int8Array(C),
              v = new Int8Array(C),
              F = new Uint16Array(C);
            for (m = 0; m < C; m++) {
              b = p[m];
              k[m] = l[b].x;
              v[m] = l[b].y;
              F[m] = 1 << (u - 1 - b);
            }
            const O = -w,
              T = -x,
              M = t - S,
              D = d[r];
            let E = new Uint8Array(t);
            const N = [],
              R = o.decoder,
              L = o.contextCache.getContexts("GB");
            let $,
              _,
              j,
              U,
              X,
              H = 0,
              q = 0;
            for (let e = 0; e < a; e++) {
              if (n) {
                H ^= R.readBit(L, D);
                if (H) {
                  N.push(E);
                  continue;
                }
              }
              E = new Uint8Array(E);
              N.push(E);
              for ($ = 0; $ < t; $++) {
                if (c && i[e][$]) {
                  E[$] = 0;
                  continue;
                }
                if ($ >= O && $ < M && e >= T) {
                  q = (q << 1) & y;
                  for (b = 0; b < C; b++) {
                    _ = e + v[b];
                    j = $ + k[b];
                    U = N[_][j];
                    if (U) {
                      U = F[b];
                      q |= U;
                    }
                  }
                } else {
                  q = 0;
                  X = u - 1;
                  for (b = 0; b < u; b++, X--) {
                    j = $ + f[b];
                    if (j >= 0 && j < t) {
                      _ = e + g[b];
                      if (_ >= 0) {
                        U = N[_][j];
                        U && (q |= U << X);
                      }
                    }
                  }
                }
                const a = R.readBit(L, q);
                E[$] = a;
              }
            }
            return N;
          }
          function decodeRefinement(e, t, a, r, n, i, s, o, c) {
            let l = u[a].coding;
            0 === a && (l = l.concat([o[0]]));
            const h = l.length,
              d = new Int32Array(h),
              g = new Int32Array(h);
            let p;
            for (p = 0; p < h; p++) {
              d[p] = l[p].x;
              g[p] = l[p].y;
            }
            let m = u[a].reference;
            0 === a && (m = m.concat([o[1]]));
            const b = m.length,
              y = new Int32Array(b),
              w = new Int32Array(b);
            for (p = 0; p < b; p++) {
              y[p] = m[p].x;
              w[p] = m[p].y;
            }
            const S = r[0].length,
              x = r.length,
              C = f[a],
              k = [],
              v = c.decoder,
              F = c.contextCache.getContexts("GR");
            let O = 0;
            for (let a = 0; a < t; a++) {
              if (s) {
                O ^= v.readBit(F, C);
                if (O) throw new Jbig2Error("prediction is not supported");
              }
              const t = new Uint8Array(e);
              k.push(t);
              for (let s = 0; s < e; s++) {
                let o,
                  c,
                  l = 0;
                for (p = 0; p < h; p++) {
                  o = a + g[p];
                  c = s + d[p];
                  o < 0 || c < 0 || c >= e
                    ? (l <<= 1)
                    : (l = (l << 1) | k[o][c]);
                }
                for (p = 0; p < b; p++) {
                  o = a + w[p] - i;
                  c = s + y[p] - n;
                  o < 0 || o >= x || c < 0 || c >= S
                    ? (l <<= 1)
                    : (l = (l << 1) | r[o][c]);
                }
                const u = v.readBit(F, l);
                t[s] = u;
              }
            }
            return k;
          }
          function decodeTextRegion(
            e,
            t,
            a,
            r,
            n,
            i,
            s,
            o,
            c,
            l,
            h,
            u,
            d,
            f,
            g,
            p,
            m,
            b,
            y,
          ) {
            if (e && t)
              throw new Jbig2Error("refinement with Huffman is not supported");
            const w = [];
            let S, x;
            for (S = 0; S < r; S++) {
              x = new Uint8Array(a);
              if (n) for (let e = 0; e < a; e++) x[e] = n;
              w.push(x);
            }
            const C = m.decoder,
              k = m.contextCache;
            let v = e ? -f.tableDeltaT.decode(y) : -decodeInteger(k, "IADT", C),
              F = 0;
            S = 0;
            for (; S < i; ) {
              v += e ? f.tableDeltaT.decode(y) : decodeInteger(k, "IADT", C);
              F += e ? f.tableFirstS.decode(y) : decodeInteger(k, "IAFS", C);
              let r = F;
              for (;;) {
                let n = 0;
                s > 1 && (n = e ? y.readBits(b) : decodeInteger(k, "IAIT", C));
                const i = s * v + n,
                  F = e ? f.symbolIDTable.decode(y) : decodeIAID(k, C, c),
                  O = t && (e ? y.readBit() : decodeInteger(k, "IARI", C));
                let T = o[F],
                  M = T[0].length,
                  D = T.length;
                if (O) {
                  const e = decodeInteger(k, "IARDW", C),
                    t = decodeInteger(k, "IARDH", C);
                  M += e;
                  D += t;
                  T = decodeRefinement(
                    M,
                    D,
                    g,
                    T,
                    (e >> 1) + decodeInteger(k, "IARDX", C),
                    (t >> 1) + decodeInteger(k, "IARDY", C),
                    !1,
                    p,
                    m,
                  );
                }
                const E = i - (1 & u ? 0 : D - 1),
                  N = r - (2 & u ? M - 1 : 0);
                let R, L, $;
                if (l) {
                  for (R = 0; R < D; R++) {
                    x = w[N + R];
                    if (!x) continue;
                    $ = T[R];
                    const e = Math.min(a - E, M);
                    switch (d) {
                      case 0:
                        for (L = 0; L < e; L++) x[E + L] |= $[L];
                        break;
                      case 2:
                        for (L = 0; L < e; L++) x[E + L] ^= $[L];
                        break;
                      default:
                        throw new Jbig2Error(`operator ${d} is not supported`);
                    }
                  }
                  r += D - 1;
                } else {
                  for (L = 0; L < D; L++) {
                    x = w[E + L];
                    if (x) {
                      $ = T[L];
                      switch (d) {
                        case 0:
                          for (R = 0; R < M; R++) x[N + R] |= $[R];
                          break;
                        case 2:
                          for (R = 0; R < M; R++) x[N + R] ^= $[R];
                          break;
                        default:
                          throw new Jbig2Error(
                            `operator ${d} is not supported`,
                          );
                      }
                    }
                  }
                  r += M - 1;
                }
                S++;
                const _ = e
                  ? f.tableDeltaS.decode(y)
                  : decodeInteger(k, "IADS", C);
                if (null === _) break;
                r += _ + h;
              }
            }
            return w;
          }
          function readSegmentHeader(e, t) {
            const a = {};
            a.number = (0, n.readUint32)(e, t);
            const r = e[t + 4],
              i = 63 & r;
            if (!l[i]) throw new Jbig2Error("invalid segment type: " + i);
            a.type = i;
            a.typeName = l[i];
            a.deferredNonRetain = !!(128 & r);
            const s = !!(64 & r),
              o = e[t + 5];
            let c = (o >> 5) & 7;
            const h = [31 & o];
            let u = t + 6;
            if (7 === o) {
              c = 536870911 & (0, n.readUint32)(e, u - 1);
              u += 3;
              let t = (c + 7) >> 3;
              h[0] = e[u++];
              for (; --t > 0; ) h.push(e[u++]);
            } else if (5 === o || 6 === o)
              throw new Jbig2Error("invalid referred-to flags");
            a.retainBits = h;
            let d = 4;
            a.number <= 256 ? (d = 1) : a.number <= 65536 && (d = 2);
            const f = [];
            let p, m;
            for (p = 0; p < c; p++) {
              let t;
              t =
                1 === d
                  ? e[u]
                  : 2 === d
                    ? (0, n.readUint16)(e, u)
                    : (0, n.readUint32)(e, u);
              f.push(t);
              u += d;
            }
            a.referredTo = f;
            if (s) {
              a.pageAssociation = (0, n.readUint32)(e, u);
              u += 4;
            } else a.pageAssociation = e[u++];
            a.length = (0, n.readUint32)(e, u);
            u += 4;
            if (4294967295 === a.length) {
              if (38 !== i)
                throw new Jbig2Error("invalid unknown segment length");
              {
                const t = readRegionSegmentInformation(e, u),
                  r = !!(1 & e[u + g]),
                  n = 6,
                  i = new Uint8Array(n);
                if (!r) {
                  i[0] = 255;
                  i[1] = 172;
                }
                i[2] = (t.height >>> 24) & 255;
                i[3] = (t.height >> 16) & 255;
                i[4] = (t.height >> 8) & 255;
                i[5] = 255 & t.height;
                for (p = u, m = e.length; p < m; p++) {
                  let t = 0;
                  for (; t < n && i[t] === e[p + t]; ) t++;
                  if (t === n) {
                    a.length = p + n;
                    break;
                  }
                }
                if (4294967295 === a.length)
                  throw new Jbig2Error("segment end was not found");
              }
            }
            a.headerEnd = u;
            return a;
          }
          function readSegments(e, t, a, r) {
            const n = [];
            let i = a;
            for (; i < r; ) {
              const a = readSegmentHeader(t, i);
              i = a.headerEnd;
              const r = { header: a, data: t };
              if (!e.randomAccess) {
                r.start = i;
                i += a.length;
                r.end = i;
              }
              n.push(r);
              if (51 === a.type) break;
            }
            if (e.randomAccess)
              for (let e = 0, t = n.length; e < t; e++) {
                n[e].start = i;
                i += n[e].header.length;
                n[e].end = i;
              }
            return n;
          }
          function readRegionSegmentInformation(e, t) {
            return {
              width: (0, n.readUint32)(e, t),
              height: (0, n.readUint32)(e, t + 4),
              x: (0, n.readUint32)(e, t + 8),
              y: (0, n.readUint32)(e, t + 12),
              combinationOperator: 7 & e[t + 16],
            };
          }
          const g = 17;
          function processSegment(e, t) {
            const a = e.header,
              r = e.data,
              i = e.end;
            let s,
              o,
              c,
              l,
              h = e.start;
            switch (a.type) {
              case 0:
                const e = {},
                  t = (0, n.readUint16)(r, h);
                e.huffman = !!(1 & t);
                e.refinement = !!(2 & t);
                e.huffmanDHSelector = (t >> 2) & 3;
                e.huffmanDWSelector = (t >> 4) & 3;
                e.bitmapSizeSelector = (t >> 6) & 1;
                e.aggregationInstancesSelector = (t >> 7) & 1;
                e.bitmapCodingContextUsed = !!(256 & t);
                e.bitmapCodingContextRetained = !!(512 & t);
                e.template = (t >> 10) & 3;
                e.refinementTemplate = (t >> 12) & 1;
                h += 2;
                if (!e.huffman) {
                  l = 0 === e.template ? 4 : 1;
                  o = [];
                  for (c = 0; c < l; c++) {
                    o.push({
                      x: (0, n.readInt8)(r, h),
                      y: (0, n.readInt8)(r, h + 1),
                    });
                    h += 2;
                  }
                  e.at = o;
                }
                if (e.refinement && !e.refinementTemplate) {
                  o = [];
                  for (c = 0; c < 2; c++) {
                    o.push({
                      x: (0, n.readInt8)(r, h),
                      y: (0, n.readInt8)(r, h + 1),
                    });
                    h += 2;
                  }
                  e.refinementAt = o;
                }
                e.numberOfExportedSymbols = (0, n.readUint32)(r, h);
                h += 4;
                e.numberOfNewSymbols = (0, n.readUint32)(r, h);
                h += 4;
                s = [e, a.number, a.referredTo, r, h, i];
                break;
              case 6:
              case 7:
                const u = {};
                u.info = readRegionSegmentInformation(r, h);
                h += g;
                const d = (0, n.readUint16)(r, h);
                h += 2;
                u.huffman = !!(1 & d);
                u.refinement = !!(2 & d);
                u.logStripSize = (d >> 2) & 3;
                u.stripSize = 1 << u.logStripSize;
                u.referenceCorner = (d >> 4) & 3;
                u.transposed = !!(64 & d);
                u.combinationOperator = (d >> 7) & 3;
                u.defaultPixelValue = (d >> 9) & 1;
                u.dsOffset = (d << 17) >> 27;
                u.refinementTemplate = (d >> 15) & 1;
                if (u.huffman) {
                  const e = (0, n.readUint16)(r, h);
                  h += 2;
                  u.huffmanFS = 3 & e;
                  u.huffmanDS = (e >> 2) & 3;
                  u.huffmanDT = (e >> 4) & 3;
                  u.huffmanRefinementDW = (e >> 6) & 3;
                  u.huffmanRefinementDH = (e >> 8) & 3;
                  u.huffmanRefinementDX = (e >> 10) & 3;
                  u.huffmanRefinementDY = (e >> 12) & 3;
                  u.huffmanRefinementSizeSelector = !!(16384 & e);
                }
                if (u.refinement && !u.refinementTemplate) {
                  o = [];
                  for (c = 0; c < 2; c++) {
                    o.push({
                      x: (0, n.readInt8)(r, h),
                      y: (0, n.readInt8)(r, h + 1),
                    });
                    h += 2;
                  }
                  u.refinementAt = o;
                }
                u.numberOfSymbolInstances = (0, n.readUint32)(r, h);
                h += 4;
                s = [u, a.referredTo, r, h, i];
                break;
              case 16:
                const f = {},
                  p = r[h++];
                f.mmr = !!(1 & p);
                f.template = (p >> 1) & 3;
                f.patternWidth = r[h++];
                f.patternHeight = r[h++];
                f.maxPatternIndex = (0, n.readUint32)(r, h);
                h += 4;
                s = [f, a.number, r, h, i];
                break;
              case 22:
              case 23:
                const m = {};
                m.info = readRegionSegmentInformation(r, h);
                h += g;
                const b = r[h++];
                m.mmr = !!(1 & b);
                m.template = (b >> 1) & 3;
                m.enableSkip = !!(8 & b);
                m.combinationOperator = (b >> 4) & 7;
                m.defaultPixelValue = (b >> 7) & 1;
                m.gridWidth = (0, n.readUint32)(r, h);
                h += 4;
                m.gridHeight = (0, n.readUint32)(r, h);
                h += 4;
                m.gridOffsetX = 4294967295 & (0, n.readUint32)(r, h);
                h += 4;
                m.gridOffsetY = 4294967295 & (0, n.readUint32)(r, h);
                h += 4;
                m.gridVectorX = (0, n.readUint16)(r, h);
                h += 2;
                m.gridVectorY = (0, n.readUint16)(r, h);
                h += 2;
                s = [m, a.referredTo, r, h, i];
                break;
              case 38:
              case 39:
                const y = {};
                y.info = readRegionSegmentInformation(r, h);
                h += g;
                const w = r[h++];
                y.mmr = !!(1 & w);
                y.template = (w >> 1) & 3;
                y.prediction = !!(8 & w);
                if (!y.mmr) {
                  l = 0 === y.template ? 4 : 1;
                  o = [];
                  for (c = 0; c < l; c++) {
                    o.push({
                      x: (0, n.readInt8)(r, h),
                      y: (0, n.readInt8)(r, h + 1),
                    });
                    h += 2;
                  }
                  y.at = o;
                }
                s = [y, r, h, i];
                break;
              case 48:
                const S = {
                  width: (0, n.readUint32)(r, h),
                  height: (0, n.readUint32)(r, h + 4),
                  resolutionX: (0, n.readUint32)(r, h + 8),
                  resolutionY: (0, n.readUint32)(r, h + 12),
                };
                4294967295 === S.height && delete S.height;
                const x = r[h + 16];
                (0, n.readUint16)(r, h + 17);
                S.lossless = !!(1 & x);
                S.refinement = !!(2 & x);
                S.defaultPixelValue = (x >> 2) & 1;
                S.combinationOperator = (x >> 3) & 3;
                S.requiresBuffer = !!(32 & x);
                S.combinationOperatorOverride = !!(64 & x);
                s = [S];
                break;
              case 49:
              case 50:
              case 51:
              case 62:
                break;
              case 53:
                s = [a.number, r, h, i];
                break;
              default:
                throw new Jbig2Error(
                  `segment type ${a.typeName}(${a.type}) is not implemented`,
                );
            }
            const u = "on" + a.typeName;
            u in t && t[u].apply(t, s);
          }
          function processSegments(e, t) {
            for (let a = 0, r = e.length; a < r; a++) processSegment(e[a], t);
          }
          class SimpleSegmentVisitor {
            onPageInformation(e) {
              this.currentPageInfo = e;
              const t = (e.width + 7) >> 3,
                a = new Uint8ClampedArray(t * e.height);
              e.defaultPixelValue && a.fill(255);
              this.buffer = a;
            }
            drawBitmap(e, t) {
              const a = this.currentPageInfo,
                r = e.width,
                n = e.height,
                i = (a.width + 7) >> 3,
                s = a.combinationOperatorOverride
                  ? e.combinationOperator
                  : a.combinationOperator,
                o = this.buffer,
                c = 128 >> (7 & e.x);
              let l,
                h,
                u,
                d,
                f = e.y * i + (e.x >> 3);
              switch (s) {
                case 0:
                  for (l = 0; l < n; l++) {
                    u = c;
                    d = f;
                    for (h = 0; h < r; h++) {
                      t[l][h] && (o[d] |= u);
                      u >>= 1;
                      if (!u) {
                        u = 128;
                        d++;
                      }
                    }
                    f += i;
                  }
                  break;
                case 2:
                  for (l = 0; l < n; l++) {
                    u = c;
                    d = f;
                    for (h = 0; h < r; h++) {
                      t[l][h] && (o[d] ^= u);
                      u >>= 1;
                      if (!u) {
                        u = 128;
                        d++;
                      }
                    }
                    f += i;
                  }
                  break;
                default:
                  throw new Jbig2Error(`operator ${s} is not supported`);
              }
            }
            onImmediateGenericRegion(e, t, a, r) {
              const n = e.info,
                i = new DecodingContext(t, a, r),
                s = decodeBitmap(
                  e.mmr,
                  n.width,
                  n.height,
                  e.template,
                  e.prediction,
                  null,
                  e.at,
                  i,
                );
              this.drawBitmap(n, s);
            }
            onImmediateLosslessGenericRegion() {
              this.onImmediateGenericRegion(...arguments);
            }
            onSymbolDictionary(e, t, a, r, i, s) {
              let o, c;
              if (e.huffman) {
                o = (function getSymbolDictionaryHuffmanTables(e, t, a) {
                  let r,
                    n,
                    i,
                    s,
                    o = 0;
                  switch (e.huffmanDHSelector) {
                    case 0:
                    case 1:
                      r = getStandardTable(e.huffmanDHSelector + 4);
                      break;
                    case 3:
                      r = getCustomHuffmanTable(o, t, a);
                      o++;
                      break;
                    default:
                      throw new Jbig2Error("invalid Huffman DH selector");
                  }
                  switch (e.huffmanDWSelector) {
                    case 0:
                    case 1:
                      n = getStandardTable(e.huffmanDWSelector + 2);
                      break;
                    case 3:
                      n = getCustomHuffmanTable(o, t, a);
                      o++;
                      break;
                    default:
                      throw new Jbig2Error("invalid Huffman DW selector");
                  }
                  if (e.bitmapSizeSelector) {
                    i = getCustomHuffmanTable(o, t, a);
                    o++;
                  } else i = getStandardTable(1);
                  s = e.aggregationInstancesSelector
                    ? getCustomHuffmanTable(o, t, a)
                    : getStandardTable(1);
                  return {
                    tableDeltaHeight: r,
                    tableDeltaWidth: n,
                    tableBitmapSize: i,
                    tableAggregateInstances: s,
                  };
                })(e, a, this.customTables);
                c = new Reader(r, i, s);
              }
              let l = this.symbols;
              l || (this.symbols = l = {});
              const h = [];
              for (const e of a) {
                const t = l[e];
                t && h.push(...t);
              }
              const u = new DecodingContext(r, i, s);
              l[t] = (function decodeSymbolDictionary(
                e,
                t,
                a,
                r,
                i,
                s,
                o,
                c,
                l,
                h,
                u,
                d,
              ) {
                if (e && t)
                  throw new Jbig2Error(
                    "symbol refinement with Huffman is not supported",
                  );
                const f = [];
                let g = 0,
                  p = (0, n.log2)(a.length + r);
                const m = u.decoder,
                  b = u.contextCache;
                let y, w;
                if (e) {
                  y = getStandardTable(1);
                  w = [];
                  p = Math.max(p, 1);
                }
                for (; f.length < r; ) {
                  g += e
                    ? s.tableDeltaHeight.decode(d)
                    : decodeInteger(b, "IADH", m);
                  let r = 0,
                    n = 0;
                  const i = e ? w.length : 0;
                  for (;;) {
                    const i = e
                      ? s.tableDeltaWidth.decode(d)
                      : decodeInteger(b, "IADW", m);
                    if (null === i) break;
                    r += i;
                    n += r;
                    let y;
                    if (t) {
                      const n = decodeInteger(b, "IAAI", m);
                      if (n > 1)
                        y = decodeTextRegion(
                          e,
                          t,
                          r,
                          g,
                          0,
                          n,
                          1,
                          a.concat(f),
                          p,
                          0,
                          0,
                          1,
                          0,
                          s,
                          l,
                          h,
                          u,
                          0,
                          d,
                        );
                      else {
                        const e = decodeIAID(b, m, p),
                          t = decodeInteger(b, "IARDX", m),
                          n = decodeInteger(b, "IARDY", m);
                        y = decodeRefinement(
                          r,
                          g,
                          l,
                          e < a.length ? a[e] : f[e - a.length],
                          t,
                          n,
                          !1,
                          h,
                          u,
                        );
                      }
                      f.push(y);
                    } else if (e) w.push(r);
                    else {
                      y = decodeBitmap(!1, r, g, o, !1, null, c, u);
                      f.push(y);
                    }
                  }
                  if (e && !t) {
                    const e = s.tableBitmapSize.decode(d);
                    d.byteAlign();
                    let t;
                    if (0 === e) t = readUncompressedBitmap(d, n, g);
                    else {
                      const a = d.end,
                        r = d.position + e;
                      d.end = r;
                      t = decodeMMRBitmap(d, n, g, !1);
                      d.end = a;
                      d.position = r;
                    }
                    const a = w.length;
                    if (i === a - 1) f.push(t);
                    else {
                      let e,
                        r,
                        n,
                        s,
                        o,
                        c = 0;
                      for (e = i; e < a; e++) {
                        s = w[e];
                        n = c + s;
                        o = [];
                        for (r = 0; r < g; r++) o.push(t[r].subarray(c, n));
                        f.push(o);
                        c = n;
                      }
                    }
                  }
                }
                const S = [],
                  x = [];
                let C,
                  k,
                  v = !1;
                const F = a.length + r;
                for (; x.length < F; ) {
                  let t = e ? y.decode(d) : decodeInteger(b, "IAEX", m);
                  for (; t--; ) x.push(v);
                  v = !v;
                }
                for (C = 0, k = a.length; C < k; C++) x[C] && S.push(a[C]);
                for (let e = 0; e < r; C++, e++) x[C] && S.push(f[e]);
                return S;
              })(
                e.huffman,
                e.refinement,
                h,
                e.numberOfNewSymbols,
                e.numberOfExportedSymbols,
                o,
                e.template,
                e.at,
                e.refinementTemplate,
                e.refinementAt,
                u,
                c,
              );
            }
            onImmediateTextRegion(e, t, a, r, i) {
              const s = e.info;
              let o, c;
              const l = this.symbols,
                h = [];
              for (const e of t) {
                const t = l[e];
                t && h.push(...t);
              }
              const u = (0, n.log2)(h.length);
              if (e.huffman) {
                c = new Reader(a, r, i);
                o = (function getTextRegionHuffmanTables(e, t, a, r, n) {
                  const i = [];
                  for (let e = 0; e <= 34; e++) {
                    const t = n.readBits(4);
                    i.push(new HuffmanLine([e, t, 0, 0]));
                  }
                  const s = new HuffmanTable(i, !1);
                  i.length = 0;
                  for (let e = 0; e < r; ) {
                    const t = s.decode(n);
                    if (t >= 32) {
                      let a, r, s;
                      switch (t) {
                        case 32:
                          if (0 === e)
                            throw new Jbig2Error(
                              "no previous value in symbol ID table",
                            );
                          r = n.readBits(2) + 3;
                          a = i[e - 1].prefixLength;
                          break;
                        case 33:
                          r = n.readBits(3) + 3;
                          a = 0;
                          break;
                        case 34:
                          r = n.readBits(7) + 11;
                          a = 0;
                          break;
                        default:
                          throw new Jbig2Error(
                            "invalid code length in symbol ID table",
                          );
                      }
                      for (s = 0; s < r; s++) {
                        i.push(new HuffmanLine([e, a, 0, 0]));
                        e++;
                      }
                    } else {
                      i.push(new HuffmanLine([e, t, 0, 0]));
                      e++;
                    }
                  }
                  n.byteAlign();
                  const o = new HuffmanTable(i, !1);
                  let c,
                    l,
                    h,
                    u = 0;
                  switch (e.huffmanFS) {
                    case 0:
                    case 1:
                      c = getStandardTable(e.huffmanFS + 6);
                      break;
                    case 3:
                      c = getCustomHuffmanTable(u, t, a);
                      u++;
                      break;
                    default:
                      throw new Jbig2Error("invalid Huffman FS selector");
                  }
                  switch (e.huffmanDS) {
                    case 0:
                    case 1:
                    case 2:
                      l = getStandardTable(e.huffmanDS + 8);
                      break;
                    case 3:
                      l = getCustomHuffmanTable(u, t, a);
                      u++;
                      break;
                    default:
                      throw new Jbig2Error("invalid Huffman DS selector");
                  }
                  switch (e.huffmanDT) {
                    case 0:
                    case 1:
                    case 2:
                      h = getStandardTable(e.huffmanDT + 11);
                      break;
                    case 3:
                      h = getCustomHuffmanTable(u, t, a);
                      u++;
                      break;
                    default:
                      throw new Jbig2Error("invalid Huffman DT selector");
                  }
                  if (e.refinement)
                    throw new Jbig2Error(
                      "refinement with Huffman is not supported",
                    );
                  return {
                    symbolIDTable: o,
                    tableFirstS: c,
                    tableDeltaS: l,
                    tableDeltaT: h,
                  };
                })(e, t, this.customTables, h.length, c);
              }
              const d = new DecodingContext(a, r, i),
                f = decodeTextRegion(
                  e.huffman,
                  e.refinement,
                  s.width,
                  s.height,
                  e.defaultPixelValue,
                  e.numberOfSymbolInstances,
                  e.stripSize,
                  h,
                  u,
                  e.transposed,
                  e.dsOffset,
                  e.referenceCorner,
                  e.combinationOperator,
                  o,
                  e.refinementTemplate,
                  e.refinementAt,
                  d,
                  e.logStripSize,
                  c,
                );
              this.drawBitmap(s, f);
            }
            onImmediateLosslessTextRegion() {
              this.onImmediateTextRegion(...arguments);
            }
            onPatternDictionary(e, t, a, r, n) {
              let i = this.patterns;
              i || (this.patterns = i = {});
              const s = new DecodingContext(a, r, n);
              i[t] = (function decodePatternDictionary(e, t, a, r, n, i) {
                const s = [];
                if (!e) {
                  s.push({ x: -t, y: 0 });
                  0 === n &&
                    s.push({ x: -3, y: -1 }, { x: 2, y: -2 }, { x: -2, y: -2 });
                }
                const o = decodeBitmap(e, (r + 1) * t, a, n, !1, null, s, i),
                  c = [];
                for (let e = 0; e <= r; e++) {
                  const r = [],
                    n = t * e,
                    i = n + t;
                  for (let e = 0; e < a; e++) r.push(o[e].subarray(n, i));
                  c.push(r);
                }
                return c;
              })(
                e.mmr,
                e.patternWidth,
                e.patternHeight,
                e.maxPatternIndex,
                e.template,
                s,
              );
            }
            onImmediateHalftoneRegion(e, t, a, r, i) {
              const s = this.patterns[t[0]],
                o = e.info,
                c = new DecodingContext(a, r, i),
                l = (function decodeHalftoneRegion(
                  e,
                  t,
                  a,
                  r,
                  i,
                  s,
                  o,
                  c,
                  l,
                  h,
                  u,
                  d,
                  f,
                  g,
                  p,
                ) {
                  if (o) throw new Jbig2Error("skip is not supported");
                  if (0 !== c)
                    throw new Jbig2Error(
                      `operator "${c}" is not supported in halftone region`,
                    );
                  const m = [];
                  let b, y, w;
                  for (b = 0; b < i; b++) {
                    w = new Uint8Array(r);
                    if (s) for (y = 0; y < r; y++) w[y] = s;
                    m.push(w);
                  }
                  const S = t.length,
                    x = t[0],
                    C = x[0].length,
                    k = x.length,
                    v = (0, n.log2)(S),
                    F = [];
                  if (!e) {
                    F.push({ x: a <= 1 ? 3 : 2, y: -1 });
                    0 === a &&
                      F.push(
                        { x: -3, y: -1 },
                        { x: 2, y: -2 },
                        { x: -2, y: -2 },
                      );
                  }
                  const O = [];
                  let T, M, D, E, N, R, L, $, _, j, U;
                  e && (T = new Reader(p.data, p.start, p.end));
                  for (b = v - 1; b >= 0; b--) {
                    M = e
                      ? decodeMMRBitmap(T, l, h, !0)
                      : decodeBitmap(!1, l, h, a, !1, null, F, p);
                    O[b] = M;
                  }
                  for (D = 0; D < h; D++)
                    for (E = 0; E < l; E++) {
                      N = 0;
                      R = 0;
                      for (y = v - 1; y >= 0; y--) {
                        N ^= O[y][D][E];
                        R |= N << y;
                      }
                      L = t[R];
                      $ = (u + D * g + E * f) >> 8;
                      _ = (d + D * f - E * g) >> 8;
                      if ($ >= 0 && $ + C <= r && _ >= 0 && _ + k <= i)
                        for (b = 0; b < k; b++) {
                          U = m[_ + b];
                          j = L[b];
                          for (y = 0; y < C; y++) U[$ + y] |= j[y];
                        }
                      else {
                        let e, t;
                        for (b = 0; b < k; b++) {
                          t = _ + b;
                          if (!(t < 0 || t >= i)) {
                            U = m[t];
                            j = L[b];
                            for (y = 0; y < C; y++) {
                              e = $ + y;
                              e >= 0 && e < r && (U[e] |= j[y]);
                            }
                          }
                        }
                      }
                    }
                  return m;
                })(
                  e.mmr,
                  s,
                  e.template,
                  o.width,
                  o.height,
                  e.defaultPixelValue,
                  e.enableSkip,
                  e.combinationOperator,
                  e.gridWidth,
                  e.gridHeight,
                  e.gridOffsetX,
                  e.gridOffsetY,
                  e.gridVectorX,
                  e.gridVectorY,
                  c,
                );
              this.drawBitmap(o, l);
            }
            onImmediateLosslessHalftoneRegion() {
              this.onImmediateHalftoneRegion(...arguments);
            }
            onTables(e, t, a, r) {
              let i = this.customTables;
              i || (this.customTables = i = {});
              i[e] = (function decodeTablesSegment(e, t, a) {
                const r = e[t],
                  i = 4294967295 & (0, n.readUint32)(e, t + 1),
                  s = 4294967295 & (0, n.readUint32)(e, t + 5),
                  o = new Reader(e, t + 9, a),
                  c = 1 + ((r >> 1) & 7),
                  l = 1 + ((r >> 4) & 7),
                  h = [];
                let u,
                  d,
                  f = i;
                do {
                  u = o.readBits(c);
                  d = o.readBits(l);
                  h.push(new HuffmanLine([f, u, d, 0]));
                  f += 1 << d;
                } while (f < s);
                u = o.readBits(c);
                h.push(new HuffmanLine([i - 1, u, 32, 0, "lower"]));
                u = o.readBits(c);
                h.push(new HuffmanLine([s, u, 32, 0]));
                if (1 & r) {
                  u = o.readBits(c);
                  h.push(new HuffmanLine([u, 0]));
                }
                return new HuffmanTable(h, !1);
              })(t, a, r);
            }
          }
          class HuffmanLine {
            constructor(e) {
              if (2 === e.length) {
                this.isOOB = !0;
                this.rangeLow = 0;
                this.prefixLength = e[0];
                this.rangeLength = 0;
                this.prefixCode = e[1];
                this.isLowerRange = !1;
              } else {
                this.isOOB = !1;
                this.rangeLow = e[0];
                this.prefixLength = e[1];
                this.rangeLength = e[2];
                this.prefixCode = e[3];
                this.isLowerRange = "lower" === e[4];
              }
            }
          }
          class HuffmanTreeNode {
            constructor(e) {
              this.children = [];
              if (e) {
                this.isLeaf = !0;
                this.rangeLength = e.rangeLength;
                this.rangeLow = e.rangeLow;
                this.isLowerRange = e.isLowerRange;
                this.isOOB = e.isOOB;
              } else this.isLeaf = !1;
            }
            buildTree(e, t) {
              const a = (e.prefixCode >> t) & 1;
              if (t <= 0) this.children[a] = new HuffmanTreeNode(e);
              else {
                let r = this.children[a];
                r || (this.children[a] = r = new HuffmanTreeNode(null));
                r.buildTree(e, t - 1);
              }
            }
            decodeNode(e) {
              if (this.isLeaf) {
                if (this.isOOB) return null;
                const t = e.readBits(this.rangeLength);
                return this.rangeLow + (this.isLowerRange ? -t : t);
              }
              const t = this.children[e.readBit()];
              if (!t) throw new Jbig2Error("invalid Huffman data");
              return t.decodeNode(e);
            }
          }
          class HuffmanTable {
            constructor(e, t) {
              t || this.assignPrefixCodes(e);
              this.rootNode = new HuffmanTreeNode(null);
              for (let t = 0, a = e.length; t < a; t++) {
                const a = e[t];
                a.prefixLength > 0 &&
                  this.rootNode.buildTree(a, a.prefixLength - 1);
              }
            }
            decode(e) {
              return this.rootNode.decodeNode(e);
            }
            assignPrefixCodes(e) {
              const t = e.length;
              let a = 0;
              for (let r = 0; r < t; r++) a = Math.max(a, e[r].prefixLength);
              const r = new Uint32Array(a + 1);
              for (let a = 0; a < t; a++) r[e[a].prefixLength]++;
              let n,
                i,
                s,
                o = 1,
                c = 0;
              r[0] = 0;
              for (; o <= a; ) {
                c = (c + r[o - 1]) << 1;
                n = c;
                i = 0;
                for (; i < t; ) {
                  s = e[i];
                  if (s.prefixLength === o) {
                    s.prefixCode = n;
                    n++;
                  }
                  i++;
                }
                o++;
              }
            }
          }
          const p = {};
          function getStandardTable(e) {
            let t,
              a = p[e];
            if (a) return a;
            switch (e) {
              case 1:
                t = [
                  [0, 1, 4, 0],
                  [16, 2, 8, 2],
                  [272, 3, 16, 6],
                  [65808, 3, 32, 7],
                ];
                break;
              case 2:
                t = [
                  [0, 1, 0, 0],
                  [1, 2, 0, 2],
                  [2, 3, 0, 6],
                  [3, 4, 3, 14],
                  [11, 5, 6, 30],
                  [75, 6, 32, 62],
                  [6, 63],
                ];
                break;
              case 3:
                t = [
                  [-256, 8, 8, 254],
                  [0, 1, 0, 0],
                  [1, 2, 0, 2],
                  [2, 3, 0, 6],
                  [3, 4, 3, 14],
                  [11, 5, 6, 30],
                  [-257, 8, 32, 255, "lower"],
                  [75, 7, 32, 126],
                  [6, 62],
                ];
                break;
              case 4:
                t = [
                  [1, 1, 0, 0],
                  [2, 2, 0, 2],
                  [3, 3, 0, 6],
                  [4, 4, 3, 14],
                  [12, 5, 6, 30],
                  [76, 5, 32, 31],
                ];
                break;
              case 5:
                t = [
                  [-255, 7, 8, 126],
                  [1, 1, 0, 0],
                  [2, 2, 0, 2],
                  [3, 3, 0, 6],
                  [4, 4, 3, 14],
                  [12, 5, 6, 30],
                  [-256, 7, 32, 127, "lower"],
                  [76, 6, 32, 62],
                ];
                break;
              case 6:
                t = [
                  [-2048, 5, 10, 28],
                  [-1024, 4, 9, 8],
                  [-512, 4, 8, 9],
                  [-256, 4, 7, 10],
                  [-128, 5, 6, 29],
                  [-64, 5, 5, 30],
                  [-32, 4, 5, 11],
                  [0, 2, 7, 0],
                  [128, 3, 7, 2],
                  [256, 3, 8, 3],
                  [512, 4, 9, 12],
                  [1024, 4, 10, 13],
                  [-2049, 6, 32, 62, "lower"],
                  [2048, 6, 32, 63],
                ];
                break;
              case 7:
                t = [
                  [-1024, 4, 9, 8],
                  [-512, 3, 8, 0],
                  [-256, 4, 7, 9],
                  [-128, 5, 6, 26],
                  [-64, 5, 5, 27],
                  [-32, 4, 5, 10],
                  [0, 4, 5, 11],
                  [32, 5, 5, 28],
                  [64, 5, 6, 29],
                  [128, 4, 7, 12],
                  [256, 3, 8, 1],
                  [512, 3, 9, 2],
                  [1024, 3, 10, 3],
                  [-1025, 5, 32, 30, "lower"],
                  [2048, 5, 32, 31],
                ];
                break;
              case 8:
                t = [
                  [-15, 8, 3, 252],
                  [-7, 9, 1, 508],
                  [-5, 8, 1, 253],
                  [-3, 9, 0, 509],
                  [-2, 7, 0, 124],
                  [-1, 4, 0, 10],
                  [0, 2, 1, 0],
                  [2, 5, 0, 26],
                  [3, 6, 0, 58],
                  [4, 3, 4, 4],
                  [20, 6, 1, 59],
                  [22, 4, 4, 11],
                  [38, 4, 5, 12],
                  [70, 5, 6, 27],
                  [134, 5, 7, 28],
                  [262, 6, 7, 60],
                  [390, 7, 8, 125],
                  [646, 6, 10, 61],
                  [-16, 9, 32, 510, "lower"],
                  [1670, 9, 32, 511],
                  [2, 1],
                ];
                break;
              case 9:
                t = [
                  [-31, 8, 4, 252],
                  [-15, 9, 2, 508],
                  [-11, 8, 2, 253],
                  [-7, 9, 1, 509],
                  [-5, 7, 1, 124],
                  [-3, 4, 1, 10],
                  [-1, 3, 1, 2],
                  [1, 3, 1, 3],
                  [3, 5, 1, 26],
                  [5, 6, 1, 58],
                  [7, 3, 5, 4],
                  [39, 6, 2, 59],
                  [43, 4, 5, 11],
                  [75, 4, 6, 12],
                  [139, 5, 7, 27],
                  [267, 5, 8, 28],
                  [523, 6, 8, 60],
                  [779, 7, 9, 125],
                  [1291, 6, 11, 61],
                  [-32, 9, 32, 510, "lower"],
                  [3339, 9, 32, 511],
                  [2, 0],
                ];
                break;
              case 10:
                t = [
                  [-21, 7, 4, 122],
                  [-5, 8, 0, 252],
                  [-4, 7, 0, 123],
                  [-3, 5, 0, 24],
                  [-2, 2, 2, 0],
                  [2, 5, 0, 25],
                  [3, 6, 0, 54],
                  [4, 7, 0, 124],
                  [5, 8, 0, 253],
                  [6, 2, 6, 1],
                  [70, 5, 5, 26],
                  [102, 6, 5, 55],
                  [134, 6, 6, 56],
                  [198, 6, 7, 57],
                  [326, 6, 8, 58],
                  [582, 6, 9, 59],
                  [1094, 6, 10, 60],
                  [2118, 7, 11, 125],
                  [-22, 8, 32, 254, "lower"],
                  [4166, 8, 32, 255],
                  [2, 2],
                ];
                break;
              case 11:
                t = [
                  [1, 1, 0, 0],
                  [2, 2, 1, 2],
                  [4, 4, 0, 12],
                  [5, 4, 1, 13],
                  [7, 5, 1, 28],
                  [9, 5, 2, 29],
                  [13, 6, 2, 60],
                  [17, 7, 2, 122],
                  [21, 7, 3, 123],
                  [29, 7, 4, 124],
                  [45, 7, 5, 125],
                  [77, 7, 6, 126],
                  [141, 7, 32, 127],
                ];
                break;
              case 12:
                t = [
                  [1, 1, 0, 0],
                  [2, 2, 0, 2],
                  [3, 3, 1, 6],
                  [5, 5, 0, 28],
                  [6, 5, 1, 29],
                  [8, 6, 1, 60],
                  [10, 7, 0, 122],
                  [11, 7, 1, 123],
                  [13, 7, 2, 124],
                  [17, 7, 3, 125],
                  [25, 7, 4, 126],
                  [41, 8, 5, 254],
                  [73, 8, 32, 255],
                ];
                break;
              case 13:
                t = [
                  [1, 1, 0, 0],
                  [2, 3, 0, 4],
                  [3, 4, 0, 12],
                  [4, 5, 0, 28],
                  [5, 4, 1, 13],
                  [7, 3, 3, 5],
                  [15, 6, 1, 58],
                  [17, 6, 2, 59],
                  [21, 6, 3, 60],
                  [29, 6, 4, 61],
                  [45, 6, 5, 62],
                  [77, 7, 6, 126],
                  [141, 7, 32, 127],
                ];
                break;
              case 14:
                t = [
                  [-2, 3, 0, 4],
                  [-1, 3, 0, 5],
                  [0, 1, 0, 0],
                  [1, 3, 0, 6],
                  [2, 3, 0, 7],
                ];
                break;
              case 15:
                t = [
                  [-24, 7, 4, 124],
                  [-8, 6, 2, 60],
                  [-4, 5, 1, 28],
                  [-2, 4, 0, 12],
                  [-1, 3, 0, 4],
                  [0, 1, 0, 0],
                  [1, 3, 0, 5],
                  [2, 4, 0, 13],
                  [3, 5, 1, 29],
                  [5, 6, 2, 61],
                  [9, 7, 4, 125],
                  [-25, 7, 32, 126, "lower"],
                  [25, 7, 32, 127],
                ];
                break;
              default:
                throw new Jbig2Error(`standard table B.${e} does not exist`);
            }
            for (let e = 0, a = t.length; e < a; e++)
              t[e] = new HuffmanLine(t[e]);
            a = new HuffmanTable(t, !0);
            p[e] = a;
            return a;
          }
          class Reader {
            constructor(e, t, a) {
              this.data = e;
              this.start = t;
              this.end = a;
              this.position = t;
              this.shift = -1;
              this.currentByte = 0;
            }
            readBit() {
              if (this.shift < 0) {
                if (this.position >= this.end)
                  throw new Jbig2Error("end of data while reading bit");
                this.currentByte = this.data[this.position++];
                this.shift = 7;
              }
              const e = (this.currentByte >> this.shift) & 1;
              this.shift--;
              return e;
            }
            readBits(e) {
              let t,
                a = 0;
              for (t = e - 1; t >= 0; t--) a |= this.readBit() << t;
              return a;
            }
            byteAlign() {
              this.shift = -1;
            }
            next() {
              return this.position >= this.end
                ? -1
                : this.data[this.position++];
            }
          }
          function getCustomHuffmanTable(e, t, a) {
            let r = 0;
            for (let n = 0, i = t.length; n < i; n++) {
              const i = a[t[n]];
              if (i) {
                if (e === r) return i;
                r++;
              }
            }
            throw new Jbig2Error("can't find custom Huffman table");
          }
          function readUncompressedBitmap(e, t, a) {
            const r = [];
            for (let n = 0; n < a; n++) {
              const a = new Uint8Array(t);
              r.push(a);
              for (let r = 0; r < t; r++) a[r] = e.readBit();
              e.byteAlign();
            }
            return r;
          }
          function decodeMMRBitmap(e, t, a, r) {
            const n = {
                K: -1,
                Columns: t,
                Rows: a,
                BlackIs1: !0,
                EndOfBlock: r,
              },
              i = new s.CCITTFaxDecoder(e, n),
              o = [];
            let c,
              l = !1;
            for (let e = 0; e < a; e++) {
              const e = new Uint8Array(t);
              o.push(e);
              let a = -1;
              for (let r = 0; r < t; r++) {
                if (a < 0) {
                  c = i.readNextChar();
                  if (-1 === c) {
                    c = 0;
                    l = !0;
                  }
                  a = 7;
                }
                e[r] = (c >> a) & 1;
                a--;
              }
            }
            if (r && !l) {
              const e = 5;
              for (let t = 0; t < e && -1 !== i.readNextChar(); t++);
            }
            return o;
          }
          t.Jbig2Image = class Jbig2Image {
            parseChunks(e) {
              return (function parseJbig2Chunks(e) {
                const t = new SimpleSegmentVisitor();
                for (let a = 0, r = e.length; a < r; a++) {
                  const r = e[a];
                  processSegments(readSegments({}, r.data, r.start, r.end), t);
                }
                return t.buffer;
              })(e);
            }
            parse(e) {
              throw new Error("Not implemented: Jbig2Image.parse");
            }
          };
        },
        (e, t) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.ArithmeticDecoder = void 0;
          const a = [
            { qe: 22017, nmps: 1, nlps: 1, switchFlag: 1 },
            { qe: 13313, nmps: 2, nlps: 6, switchFlag: 0 },
            { qe: 6145, nmps: 3, nlps: 9, switchFlag: 0 },
            { qe: 2753, nmps: 4, nlps: 12, switchFlag: 0 },
            { qe: 1313, nmps: 5, nlps: 29, switchFlag: 0 },
            { qe: 545, nmps: 38, nlps: 33, switchFlag: 0 },
            { qe: 22017, nmps: 7, nlps: 6, switchFlag: 1 },
            { qe: 21505, nmps: 8, nlps: 14, switchFlag: 0 },
            { qe: 18433, nmps: 9, nlps: 14, switchFlag: 0 },
            { qe: 14337, nmps: 10, nlps: 14, switchFlag: 0 },
            { qe: 12289, nmps: 11, nlps: 17, switchFlag: 0 },
            { qe: 9217, nmps: 12, nlps: 18, switchFlag: 0 },
            { qe: 7169, nmps: 13, nlps: 20, switchFlag: 0 },
            { qe: 5633, nmps: 29, nlps: 21, switchFlag: 0 },
            { qe: 22017, nmps: 15, nlps: 14, switchFlag: 1 },
            { qe: 21505, nmps: 16, nlps: 14, switchFlag: 0 },
            { qe: 20737, nmps: 17, nlps: 15, switchFlag: 0 },
            { qe: 18433, nmps: 18, nlps: 16, switchFlag: 0 },
            { qe: 14337, nmps: 19, nlps: 17, switchFlag: 0 },
            { qe: 13313, nmps: 20, nlps: 18, switchFlag: 0 },
            { qe: 12289, nmps: 21, nlps: 19, switchFlag: 0 },
            { qe: 10241, nmps: 22, nlps: 19, switchFlag: 0 },
            { qe: 9217, nmps: 23, nlps: 20, switchFlag: 0 },
            { qe: 8705, nmps: 24, nlps: 21, switchFlag: 0 },
            { qe: 7169, nmps: 25, nlps: 22, switchFlag: 0 },
            { qe: 6145, nmps: 26, nlps: 23, switchFlag: 0 },
            { qe: 5633, nmps: 27, nlps: 24, switchFlag: 0 },
            { qe: 5121, nmps: 28, nlps: 25, switchFlag: 0 },
            { qe: 4609, nmps: 29, nlps: 26, switchFlag: 0 },
            { qe: 4353, nmps: 30, nlps: 27, switchFlag: 0 },
            { qe: 2753, nmps: 31, nlps: 28, switchFlag: 0 },
            { qe: 2497, nmps: 32, nlps: 29, switchFlag: 0 },
            { qe: 2209, nmps: 33, nlps: 30, switchFlag: 0 },
            { qe: 1313, nmps: 34, nlps: 31, switchFlag: 0 },
            { qe: 1089, nmps: 35, nlps: 32, switchFlag: 0 },
            { qe: 673, nmps: 36, nlps: 33, switchFlag: 0 },
            { qe: 545, nmps: 37, nlps: 34, switchFlag: 0 },
            { qe: 321, nmps: 38, nlps: 35, switchFlag: 0 },
            { qe: 273, nmps: 39, nlps: 36, switchFlag: 0 },
            { qe: 133, nmps: 40, nlps: 37, switchFlag: 0 },
            { qe: 73, nmps: 41, nlps: 38, switchFlag: 0 },
            { qe: 37, nmps: 42, nlps: 39, switchFlag: 0 },
            { qe: 21, nmps: 43, nlps: 40, switchFlag: 0 },
            { qe: 9, nmps: 44, nlps: 41, switchFlag: 0 },
            { qe: 5, nmps: 45, nlps: 42, switchFlag: 0 },
            { qe: 1, nmps: 45, nlps: 43, switchFlag: 0 },
            { qe: 22017, nmps: 46, nlps: 46, switchFlag: 0 },
          ];
          t.ArithmeticDecoder = class ArithmeticDecoder {
            constructor(e, t, a) {
              this.data = e;
              this.bp = t;
              this.dataEnd = a;
              this.chigh = e[t];
              this.clow = 0;
              this.byteIn();
              this.chigh =
                ((this.chigh << 7) & 65535) | ((this.clow >> 9) & 127);
              this.clow = (this.clow << 7) & 65535;
              this.ct -= 7;
              this.a = 32768;
            }
            byteIn() {
              const e = this.data;
              let t = this.bp;
              if (255 === e[t])
                if (e[t + 1] > 143) {
                  this.clow += 65280;
                  this.ct = 8;
                } else {
                  t++;
                  this.clow += e[t] << 9;
                  this.ct = 7;
                  this.bp = t;
                }
              else {
                t++;
                this.clow += t < this.dataEnd ? e[t] << 8 : 65280;
                this.ct = 8;
                this.bp = t;
              }
              if (this.clow > 65535) {
                this.chigh += this.clow >> 16;
                this.clow &= 65535;
              }
            }
            readBit(e, t) {
              let r = e[t] >> 1,
                n = 1 & e[t];
              const i = a[r],
                s = i.qe;
              let o,
                c = this.a - s;
              if (this.chigh < s)
                if (c < s) {
                  c = s;
                  o = n;
                  r = i.nmps;
                } else {
                  c = s;
                  o = 1 ^ n;
                  1 === i.switchFlag && (n = o);
                  r = i.nlps;
                }
              else {
                this.chigh -= s;
                if (0 != (32768 & c)) {
                  this.a = c;
                  return n;
                }
                if (c < s) {
                  o = 1 ^ n;
                  1 === i.switchFlag && (n = o);
                  r = i.nlps;
                } else {
                  o = n;
                  r = i.nmps;
                }
              }
              do {
                0 === this.ct && this.byteIn();
                c <<= 1;
                this.chigh =
                  ((this.chigh << 1) & 65535) | ((this.clow >> 15) & 1);
                this.clow = (this.clow << 1) & 65535;
                this.ct--;
              } while (0 == (32768 & c));
              this.a = c;
              e[t] = (r << 1) | n;
              return o;
            }
          };
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.JpegStream = void 0;
          var r = a(18),
            n = a(4),
            i = a(27),
            s = a(2);
          class JpegStream extends r.DecodeStream {
            constructor(e, t, a) {
              let r;
              for (; -1 !== (r = e.getByte()); )
                if (255 === r) {
                  e.skip(-1);
                  break;
                }
              super(t);
              this.stream = e;
              this.dict = e.dict;
              this.maybeLength = t;
              this.params = a;
            }
            get bytes() {
              return (0, s.shadow)(
                this,
                "bytes",
                this.stream.getBytes(this.maybeLength),
              );
            }
            ensureBuffer(e) {}
            readBlock() {
              if (this.eof) return;
              const e = { decodeTransform: void 0, colorTransform: void 0 },
                t = this.dict.getArray("D", "Decode");
              if ((this.forceRGBA || this.forceRGB) && Array.isArray(t)) {
                const a = this.dict.get("BPC", "BitsPerComponent") || 8,
                  r = t.length,
                  n = new Int32Array(r);
                let i = !1;
                const s = (1 << a) - 1;
                for (let e = 0; e < r; e += 2) {
                  n[e] = (256 * (t[e + 1] - t[e])) | 0;
                  n[e + 1] = (t[e] * s) | 0;
                  (256 === n[e] && 0 === n[e + 1]) || (i = !0);
                }
                i && (e.decodeTransform = n);
              }
              if (this.params instanceof n.Dict) {
                const t = this.params.get("ColorTransform");
                Number.isInteger(t) && (e.colorTransform = t);
              }
              const a = new i.JpegImage(e);
              a.parse(this.bytes);
              const r = a.getData({
                width: this.drawWidth,
                height: this.drawHeight,
                forceRGBA: this.forceRGBA,
                forceRGB: this.forceRGB,
                isSourcePDF: !0,
              });
              this.buffer = r;
              this.bufferLength = r.length;
              this.eof = !0;
            }
          }
          t.JpegStream = JpegStream;
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.JpegImage = void 0;
          var r = a(2),
            n = a(28),
            i = a(3);
          class JpegError extends r.BaseException {
            constructor(e) {
              super(`JPEG error: ${e}`, "JpegError");
            }
          }
          class DNLMarkerError extends r.BaseException {
            constructor(e, t) {
              super(e, "DNLMarkerError");
              this.scanLines = t;
            }
          }
          class EOIMarkerError extends r.BaseException {
            constructor(e) {
              super(e, "EOIMarkerError");
            }
          }
          const s = new Uint8Array([
              0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19,
              26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49,
              56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52,
              45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63,
            ]),
            o = 4017,
            c = 799,
            l = 3406,
            h = 2276,
            u = 1567,
            d = 3784,
            f = 5793,
            g = 2896;
          function buildHuffmanTable(e, t) {
            let a,
              r,
              n = 0,
              i = 16;
            for (; i > 0 && !e[i - 1]; ) i--;
            const s = [{ children: [], index: 0 }];
            let o,
              c = s[0];
            for (a = 0; a < i; a++) {
              for (r = 0; r < e[a]; r++) {
                c = s.pop();
                c.children[c.index] = t[n];
                for (; c.index > 0; ) c = s.pop();
                c.index++;
                s.push(c);
                for (; s.length <= a; ) {
                  s.push((o = { children: [], index: 0 }));
                  c.children[c.index] = o.children;
                  c = o;
                }
                n++;
              }
              if (a + 1 < i) {
                s.push((o = { children: [], index: 0 }));
                c.children[c.index] = o.children;
                c = o;
              }
            }
            return s[0].children;
          }
          function getBlockBufferOffset(e, t, a) {
            return 64 * ((e.blocksPerLine + 1) * t + a);
          }
          function decodeScan(e, t, a, n, o, c, l, h, u, d = !1) {
            const f = a.mcusPerLine,
              g = a.progressive,
              p = t;
            let m = 0,
              b = 0;
            function readBit() {
              if (b > 0) {
                b--;
                return (m >> b) & 1;
              }
              m = e[t++];
              if (255 === m) {
                const r = e[t++];
                if (r) {
                  if (220 === r && d) {
                    t += 2;
                    const r = (0, i.readUint16)(e, t);
                    t += 2;
                    if (r > 0 && r !== a.scanLines)
                      throw new DNLMarkerError(
                        "Found DNL marker (0xFFDC) while parsing scan data",
                        r,
                      );
                  } else if (217 === r) {
                    if (d) {
                      const e = x * (8 === a.precision ? 8 : 0);
                      if (e > 0 && Math.round(a.scanLines / e) >= 5)
                        throw new DNLMarkerError(
                          "Found EOI marker (0xFFD9) while parsing scan data, possibly caused by incorrect `scanLines` parameter",
                          e,
                        );
                    }
                    throw new EOIMarkerError(
                      "Found EOI marker (0xFFD9) while parsing scan data",
                    );
                  }
                  throw new JpegError(
                    `unexpected marker ${((m << 8) | r).toString(16)}`,
                  );
                }
              }
              b = 7;
              return m >>> 7;
            }
            function decodeHuffman(e) {
              let t = e;
              for (;;) {
                t = t[readBit()];
                switch (typeof t) {
                  case "number":
                    return t;
                  case "object":
                    continue;
                }
                throw new JpegError("invalid huffman sequence");
              }
            }
            function receive(e) {
              let t = 0;
              for (; e > 0; ) {
                t = (t << 1) | readBit();
                e--;
              }
              return t;
            }
            function receiveAndExtend(e) {
              if (1 === e) return 1 === readBit() ? 1 : -1;
              const t = receive(e);
              return t >= 1 << (e - 1) ? t : t + (-1 << e) + 1;
            }
            let y = 0;
            let w,
              S = 0;
            let x = 0;
            function decodeMcu(e, t, a, r, n) {
              const i = a % f;
              x = ((a / f) | 0) * e.v + r;
              const s = i * e.h + n;
              t(e, getBlockBufferOffset(e, x, s));
            }
            function decodeBlock(e, t, a) {
              x = (a / e.blocksPerLine) | 0;
              const r = a % e.blocksPerLine;
              t(e, getBlockBufferOffset(e, x, r));
            }
            const C = n.length;
            let k, v, F, O, T, M;
            M = g
              ? 0 === c
                ? 0 === h
                  ? function decodeDCFirst(e, t) {
                      const a = decodeHuffman(e.huffmanTableDC),
                        r = 0 === a ? 0 : receiveAndExtend(a) << u;
                      e.blockData[t] = e.pred += r;
                    }
                  : function decodeDCSuccessive(e, t) {
                      e.blockData[t] |= readBit() << u;
                    }
                : 0 === h
                  ? function decodeACFirst(e, t) {
                      if (y > 0) {
                        y--;
                        return;
                      }
                      let a = c;
                      const r = l;
                      for (; a <= r; ) {
                        const r = decodeHuffman(e.huffmanTableAC),
                          n = 15 & r,
                          i = r >> 4;
                        if (0 === n) {
                          if (i < 15) {
                            y = receive(i) + (1 << i) - 1;
                            break;
                          }
                          a += 16;
                          continue;
                        }
                        a += i;
                        const o = s[a];
                        e.blockData[t + o] = receiveAndExtend(n) * (1 << u);
                        a++;
                      }
                    }
                  : function decodeACSuccessive(e, t) {
                      let a = c;
                      const r = l;
                      let n,
                        i,
                        o = 0;
                      for (; a <= r; ) {
                        const r = t + s[a],
                          c = e.blockData[r] < 0 ? -1 : 1;
                        switch (S) {
                          case 0:
                            i = decodeHuffman(e.huffmanTableAC);
                            n = 15 & i;
                            o = i >> 4;
                            if (0 === n)
                              if (o < 15) {
                                y = receive(o) + (1 << o);
                                S = 4;
                              } else {
                                o = 16;
                                S = 1;
                              }
                            else {
                              if (1 !== n)
                                throw new JpegError("invalid ACn encoding");
                              w = receiveAndExtend(n);
                              S = o ? 2 : 3;
                            }
                            continue;
                          case 1:
                          case 2:
                            if (e.blockData[r])
                              e.blockData[r] += c * (readBit() << u);
                            else {
                              o--;
                              0 === o && (S = 2 === S ? 3 : 0);
                            }
                            break;
                          case 3:
                            if (e.blockData[r])
                              e.blockData[r] += c * (readBit() << u);
                            else {
                              e.blockData[r] = w << u;
                              S = 0;
                            }
                            break;
                          case 4:
                            e.blockData[r] &&
                              (e.blockData[r] += c * (readBit() << u));
                        }
                        a++;
                      }
                      if (4 === S) {
                        y--;
                        0 === y && (S = 0);
                      }
                    }
              : function decodeBaseline(e, t) {
                  const a = decodeHuffman(e.huffmanTableDC),
                    r = 0 === a ? 0 : receiveAndExtend(a);
                  e.blockData[t] = e.pred += r;
                  let n = 1;
                  for (; n < 64; ) {
                    const a = decodeHuffman(e.huffmanTableAC),
                      r = 15 & a,
                      i = a >> 4;
                    if (0 === r) {
                      if (i < 15) break;
                      n += 16;
                      continue;
                    }
                    n += i;
                    const o = s[n];
                    e.blockData[t + o] = receiveAndExtend(r);
                    n++;
                  }
                };
            let D,
              E = 0;
            const N =
              1 === C
                ? n[0].blocksPerLine * n[0].blocksPerColumn
                : f * a.mcusPerColumn;
            let R, L;
            for (; E <= N; ) {
              const a = o ? Math.min(N - E, o) : N;
              if (a > 0) {
                for (v = 0; v < C; v++) n[v].pred = 0;
                y = 0;
                if (1 === C) {
                  k = n[0];
                  for (T = 0; T < a; T++) {
                    decodeBlock(k, M, E);
                    E++;
                  }
                } else
                  for (T = 0; T < a; T++) {
                    for (v = 0; v < C; v++) {
                      k = n[v];
                      R = k.h;
                      L = k.v;
                      for (F = 0; F < L; F++)
                        for (O = 0; O < R; O++) decodeMcu(k, M, E, F, O);
                    }
                    E++;
                  }
              }
              b = 0;
              D = findNextFileMarker(e, t);
              if (!D) break;
              if (D.invalid) {
                const e = a > 0 ? "unexpected" : "excessive";
                (0, r.warn)(
                  `decodeScan - ${e} MCU data, current marker is: ${D.invalid}`,
                );
                t = D.offset;
              }
              if (!(D.marker >= 65488 && D.marker <= 65495)) break;
              t += 2;
            }
            return t - p;
          }
          function quantizeAndInverse(e, t, a) {
            const r = e.quantizationTable,
              n = e.blockData;
            let i, s, p, m, b, y, w, S, x, C, k, v, F, O, T, M, D;
            if (!r) throw new JpegError("missing required Quantization Table.");
            for (let e = 0; e < 64; e += 8) {
              x = n[t + e];
              C = n[t + e + 1];
              k = n[t + e + 2];
              v = n[t + e + 3];
              F = n[t + e + 4];
              O = n[t + e + 5];
              T = n[t + e + 6];
              M = n[t + e + 7];
              x *= r[e];
              if (0 != (C | k | v | F | O | T | M)) {
                C *= r[e + 1];
                k *= r[e + 2];
                v *= r[e + 3];
                F *= r[e + 4];
                O *= r[e + 5];
                T *= r[e + 6];
                M *= r[e + 7];
                i = (f * x + 128) >> 8;
                s = (f * F + 128) >> 8;
                p = k;
                m = T;
                b = (g * (C - M) + 128) >> 8;
                S = (g * (C + M) + 128) >> 8;
                y = v << 4;
                w = O << 4;
                i = (i + s + 1) >> 1;
                s = i - s;
                D = (p * d + m * u + 128) >> 8;
                p = (p * u - m * d + 128) >> 8;
                m = D;
                b = (b + w + 1) >> 1;
                w = b - w;
                S = (S + y + 1) >> 1;
                y = S - y;
                i = (i + m + 1) >> 1;
                m = i - m;
                s = (s + p + 1) >> 1;
                p = s - p;
                D = (b * h + S * l + 2048) >> 12;
                b = (b * l - S * h + 2048) >> 12;
                S = D;
                D = (y * c + w * o + 2048) >> 12;
                y = (y * o - w * c + 2048) >> 12;
                w = D;
                a[e] = i + S;
                a[e + 7] = i - S;
                a[e + 1] = s + w;
                a[e + 6] = s - w;
                a[e + 2] = p + y;
                a[e + 5] = p - y;
                a[e + 3] = m + b;
                a[e + 4] = m - b;
              } else {
                D = (f * x + 512) >> 10;
                a[e] = D;
                a[e + 1] = D;
                a[e + 2] = D;
                a[e + 3] = D;
                a[e + 4] = D;
                a[e + 5] = D;
                a[e + 6] = D;
                a[e + 7] = D;
              }
            }
            for (let e = 0; e < 8; ++e) {
              x = a[e];
              C = a[e + 8];
              k = a[e + 16];
              v = a[e + 24];
              F = a[e + 32];
              O = a[e + 40];
              T = a[e + 48];
              M = a[e + 56];
              if (0 != (C | k | v | F | O | T | M)) {
                i = (f * x + 2048) >> 12;
                s = (f * F + 2048) >> 12;
                p = k;
                m = T;
                b = (g * (C - M) + 2048) >> 12;
                S = (g * (C + M) + 2048) >> 12;
                y = v;
                w = O;
                i = 4112 + ((i + s + 1) >> 1);
                s = i - s;
                D = (p * d + m * u + 2048) >> 12;
                p = (p * u - m * d + 2048) >> 12;
                m = D;
                b = (b + w + 1) >> 1;
                w = b - w;
                S = (S + y + 1) >> 1;
                y = S - y;
                i = (i + m + 1) >> 1;
                m = i - m;
                s = (s + p + 1) >> 1;
                p = s - p;
                D = (b * h + S * l + 2048) >> 12;
                b = (b * l - S * h + 2048) >> 12;
                S = D;
                D = (y * c + w * o + 2048) >> 12;
                y = (y * o - w * c + 2048) >> 12;
                w = D;
                x = i + S;
                M = i - S;
                C = s + w;
                T = s - w;
                k = p + y;
                O = p - y;
                v = m + b;
                F = m - b;
                x < 16 ? (x = 0) : x >= 4080 ? (x = 255) : (x >>= 4);
                C < 16 ? (C = 0) : C >= 4080 ? (C = 255) : (C >>= 4);
                k < 16 ? (k = 0) : k >= 4080 ? (k = 255) : (k >>= 4);
                v < 16 ? (v = 0) : v >= 4080 ? (v = 255) : (v >>= 4);
                F < 16 ? (F = 0) : F >= 4080 ? (F = 255) : (F >>= 4);
                O < 16 ? (O = 0) : O >= 4080 ? (O = 255) : (O >>= 4);
                T < 16 ? (T = 0) : T >= 4080 ? (T = 255) : (T >>= 4);
                M < 16 ? (M = 0) : M >= 4080 ? (M = 255) : (M >>= 4);
                n[t + e] = x;
                n[t + e + 8] = C;
                n[t + e + 16] = k;
                n[t + e + 24] = v;
                n[t + e + 32] = F;
                n[t + e + 40] = O;
                n[t + e + 48] = T;
                n[t + e + 56] = M;
              } else {
                D = (f * x + 8192) >> 14;
                D = D < -2040 ? 0 : D >= 2024 ? 255 : (D + 2056) >> 4;
                n[t + e] = D;
                n[t + e + 8] = D;
                n[t + e + 16] = D;
                n[t + e + 24] = D;
                n[t + e + 32] = D;
                n[t + e + 40] = D;
                n[t + e + 48] = D;
                n[t + e + 56] = D;
              }
            }
          }
          function buildComponentData(e, t) {
            const a = t.blocksPerLine,
              r = t.blocksPerColumn,
              n = new Int16Array(64);
            for (let e = 0; e < r; e++)
              for (let r = 0; r < a; r++) {
                quantizeAndInverse(t, getBlockBufferOffset(t, e, r), n);
              }
            return t.blockData;
          }
          function findNextFileMarker(e, t, a = t) {
            const r = e.length - 1;
            let n = a < t ? a : t;
            if (t >= r) return null;
            const s = (0, i.readUint16)(e, t);
            if (s >= 65472 && s <= 65534)
              return { invalid: null, marker: s, offset: t };
            let o = (0, i.readUint16)(e, n);
            for (; !(o >= 65472 && o <= 65534); ) {
              if (++n >= r) return null;
              o = (0, i.readUint16)(e, n);
            }
            return { invalid: s.toString(16), marker: o, offset: n };
          }
          t.JpegImage = class JpegImage {
            constructor({
              decodeTransform: e = null,
              colorTransform: t = -1,
            } = {}) {
              this._decodeTransform = e;
              this._colorTransform = t;
            }
            parse(e, { dnlScanLines: t = null } = {}) {
              function readDataBlock() {
                const t = (0, i.readUint16)(e, o);
                o += 2;
                let a = o + t - 2;
                const n = findNextFileMarker(e, a, o);
                if (n?.invalid) {
                  (0, r.warn)(
                    "readDataBlock - incorrect length, current marker is: " +
                      n.invalid,
                  );
                  a = n.offset;
                }
                const s = e.subarray(o, a);
                o += s.length;
                return s;
              }
              function prepareComponents(e) {
                const t = Math.ceil(e.samplesPerLine / 8 / e.maxH),
                  a = Math.ceil(e.scanLines / 8 / e.maxV);
                for (const r of e.components) {
                  const n = Math.ceil(
                      (Math.ceil(e.samplesPerLine / 8) * r.h) / e.maxH,
                    ),
                    i = Math.ceil((Math.ceil(e.scanLines / 8) * r.v) / e.maxV),
                    s = t * r.h,
                    o = 64 * (a * r.v) * (s + 1);
                  r.blockData = new Int16Array(o);
                  r.blocksPerLine = n;
                  r.blocksPerColumn = i;
                }
                e.mcusPerLine = t;
                e.mcusPerColumn = a;
              }
              let a,
                n,
                o = 0,
                c = null,
                l = null,
                h = 0;
              const u = [],
                d = [],
                f = [];
              let g = (0, i.readUint16)(e, o);
              o += 2;
              if (65496 !== g) throw new JpegError("SOI not found");
              g = (0, i.readUint16)(e, o);
              o += 2;
              e: for (; 65497 !== g; ) {
                let p, m, b;
                switch (g) {
                  case 65504:
                  case 65505:
                  case 65506:
                  case 65507:
                  case 65508:
                  case 65509:
                  case 65510:
                  case 65511:
                  case 65512:
                  case 65513:
                  case 65514:
                  case 65515:
                  case 65516:
                  case 65517:
                  case 65518:
                  case 65519:
                  case 65534:
                    const y = readDataBlock();
                    65504 === g &&
                      74 === y[0] &&
                      70 === y[1] &&
                      73 === y[2] &&
                      70 === y[3] &&
                      0 === y[4] &&
                      (c = {
                        version: { major: y[5], minor: y[6] },
                        densityUnits: y[7],
                        xDensity: (y[8] << 8) | y[9],
                        yDensity: (y[10] << 8) | y[11],
                        thumbWidth: y[12],
                        thumbHeight: y[13],
                        thumbData: y.subarray(14, 14 + 3 * y[12] * y[13]),
                      });
                    65518 === g &&
                      65 === y[0] &&
                      100 === y[1] &&
                      111 === y[2] &&
                      98 === y[3] &&
                      101 === y[4] &&
                      (l = {
                        version: (y[5] << 8) | y[6],
                        flags0: (y[7] << 8) | y[8],
                        flags1: (y[9] << 8) | y[10],
                        transformCode: y[11],
                      });
                    break;
                  case 65499:
                    const w = (0, i.readUint16)(e, o);
                    o += 2;
                    const S = w + o - 2;
                    let x;
                    for (; o < S; ) {
                      const t = e[o++],
                        a = new Uint16Array(64);
                      if (t >> 4 == 0)
                        for (m = 0; m < 64; m++) {
                          x = s[m];
                          a[x] = e[o++];
                        }
                      else {
                        if (t >> 4 != 1)
                          throw new JpegError("DQT - invalid table spec");
                        for (m = 0; m < 64; m++) {
                          x = s[m];
                          a[x] = (0, i.readUint16)(e, o);
                          o += 2;
                        }
                      }
                      u[15 & t] = a;
                    }
                    break;
                  case 65472:
                  case 65473:
                  case 65474:
                    if (a)
                      throw new JpegError("Only single frame JPEGs supported");
                    o += 2;
                    a = {};
                    a.extended = 65473 === g;
                    a.progressive = 65474 === g;
                    a.precision = e[o++];
                    const C = (0, i.readUint16)(e, o);
                    o += 2;
                    a.scanLines = t || C;
                    a.samplesPerLine = (0, i.readUint16)(e, o);
                    o += 2;
                    a.components = [];
                    a.componentIds = {};
                    const k = e[o++];
                    let v = 0,
                      F = 0;
                    for (p = 0; p < k; p++) {
                      const t = e[o],
                        r = e[o + 1] >> 4,
                        n = 15 & e[o + 1];
                      v < r && (v = r);
                      F < n && (F = n);
                      const i = e[o + 2];
                      b = a.components.push({
                        h: r,
                        v: n,
                        quantizationId: i,
                        quantizationTable: null,
                      });
                      a.componentIds[t] = b - 1;
                      o += 3;
                    }
                    a.maxH = v;
                    a.maxV = F;
                    prepareComponents(a);
                    break;
                  case 65476:
                    const O = (0, i.readUint16)(e, o);
                    o += 2;
                    for (p = 2; p < O; ) {
                      const t = e[o++],
                        a = new Uint8Array(16);
                      let r = 0;
                      for (m = 0; m < 16; m++, o++) r += a[m] = e[o];
                      const n = new Uint8Array(r);
                      for (m = 0; m < r; m++, o++) n[m] = e[o];
                      p += 17 + r;
                      (t >> 4 == 0 ? f : d)[15 & t] = buildHuffmanTable(a, n);
                    }
                    break;
                  case 65501:
                    o += 2;
                    n = (0, i.readUint16)(e, o);
                    o += 2;
                    break;
                  case 65498:
                    const T = 1 == ++h && !t;
                    o += 2;
                    const M = e[o++],
                      D = [];
                    for (p = 0; p < M; p++) {
                      const t = e[o++],
                        r = a.componentIds[t],
                        n = a.components[r];
                      n.index = t;
                      const i = e[o++];
                      n.huffmanTableDC = f[i >> 4];
                      n.huffmanTableAC = d[15 & i];
                      D.push(n);
                    }
                    const E = e[o++],
                      N = e[o++],
                      R = e[o++];
                    try {
                      const t = decodeScan(
                        e,
                        o,
                        a,
                        D,
                        n,
                        E,
                        N,
                        R >> 4,
                        15 & R,
                        T,
                      );
                      o += t;
                    } catch (t) {
                      if (t instanceof DNLMarkerError) {
                        (0, r.warn)(
                          `${t.message} -- attempting to re-parse the JPEG image.`,
                        );
                        return this.parse(e, { dnlScanLines: t.scanLines });
                      }
                      if (t instanceof EOIMarkerError) {
                        (0, r.warn)(
                          `${t.message} -- ignoring the rest of the image data.`,
                        );
                        break e;
                      }
                      throw t;
                    }
                    break;
                  case 65500:
                    o += 4;
                    break;
                  case 65535:
                    255 !== e[o] && o--;
                    break;
                  default:
                    const L = findNextFileMarker(e, o - 2, o - 3);
                    if (L?.invalid) {
                      (0, r.warn)(
                        "JpegImage.parse - unexpected data, current marker is: " +
                          L.invalid,
                      );
                      o = L.offset;
                      break;
                    }
                    if (!L || o >= e.length - 1) {
                      (0, r.warn)(
                        "JpegImage.parse - reached the end of the image data without finding an EOI marker (0xFFD9).",
                      );
                      break e;
                    }
                    throw new JpegError(
                      "JpegImage.parse - unknown marker: " + g.toString(16),
                    );
                }
                g = (0, i.readUint16)(e, o);
                o += 2;
              }
              this.width = a.samplesPerLine;
              this.height = a.scanLines;
              this.jfif = c;
              this.adobe = l;
              this.components = [];
              for (const e of a.components) {
                const t = u[e.quantizationId];
                t && (e.quantizationTable = t);
                this.components.push({
                  index: e.index,
                  output: buildComponentData(0, e),
                  scaleX: e.h / a.maxH,
                  scaleY: e.v / a.maxV,
                  blocksPerLine: e.blocksPerLine,
                  blocksPerColumn: e.blocksPerColumn,
                });
              }
              this.numComponents = this.components.length;
            }
            _getLinearizedBlockData(e, t, a = !1) {
              const r = this.width / e,
                n = this.height / t;
              let i,
                s,
                o,
                c,
                l,
                h,
                u,
                d,
                f,
                g,
                p,
                m = 0;
              const b = this.components.length,
                y = e * t * b,
                w = new Uint8ClampedArray(y),
                S = new Uint32Array(e),
                x = 4294967288;
              let C;
              for (u = 0; u < b; u++) {
                i = this.components[u];
                s = i.scaleX * r;
                o = i.scaleY * n;
                m = u;
                p = i.output;
                c = (i.blocksPerLine + 1) << 3;
                if (s !== C) {
                  for (l = 0; l < e; l++) {
                    d = 0 | (l * s);
                    S[l] = ((d & x) << 3) | (7 & d);
                  }
                  C = s;
                }
                for (h = 0; h < t; h++) {
                  d = 0 | (h * o);
                  g = (c * (d & x)) | ((7 & d) << 3);
                  for (l = 0; l < e; l++) {
                    w[m] = p[g + S[l]];
                    m += b;
                  }
                }
              }
              let k = this._decodeTransform;
              a ||
                4 !== b ||
                k ||
                (k = new Int32Array([
                  -256, 255, -256, 255, -256, 255, -256, 255,
                ]));
              if (k)
                for (u = 0; u < y; )
                  for (d = 0, f = 0; d < b; d++, u++, f += 2)
                    w[u] = ((w[u] * k[f]) >> 8) + k[f + 1];
              return w;
            }
            get _isColorConversionNeeded() {
              return this.adobe
                ? !!this.adobe.transformCode
                : 3 === this.numComponents
                  ? 0 !== this._colorTransform &&
                    (82 !== this.components[0].index ||
                      71 !== this.components[1].index ||
                      66 !== this.components[2].index)
                  : 1 === this._colorTransform;
            }
            _convertYccToRgb(e) {
              let t, a, r;
              for (let n = 0, i = e.length; n < i; n += 3) {
                t = e[n];
                a = e[n + 1];
                r = e[n + 2];
                e[n] = t - 179.456 + 1.402 * r;
                e[n + 1] = t + 135.459 - 0.344 * a - 0.714 * r;
                e[n + 2] = t - 226.816 + 1.772 * a;
              }
              return e;
            }
            _convertYccToRgba(e, t) {
              for (let a = 0, r = 0, n = e.length; a < n; a += 3, r += 4) {
                const n = e[a],
                  i = e[a + 1],
                  s = e[a + 2];
                t[r] = n - 179.456 + 1.402 * s;
                t[r + 1] = n + 135.459 - 0.344 * i - 0.714 * s;
                t[r + 2] = n - 226.816 + 1.772 * i;
                t[r + 3] = 255;
              }
              return t;
            }
            _convertYcckToRgb(e) {
              let t,
                a,
                r,
                n,
                i = 0;
              for (let s = 0, o = e.length; s < o; s += 4) {
                t = e[s];
                a = e[s + 1];
                r = e[s + 2];
                n = e[s + 3];
                e[i++] =
                  a *
                    (-660635669420364e-19 * a +
                      0.000437130475926232 * r -
                      54080610064599e-18 * t +
                      0.00048449797120281 * n -
                      0.154362151871126) -
                  122.67195406894 +
                  r *
                    (-0.000957964378445773 * r +
                      0.000817076911346625 * t -
                      0.00477271405408747 * n +
                      1.53380253221734) +
                  t *
                    (0.000961250184130688 * t -
                      0.00266257332283933 * n +
                      0.48357088451265) +
                  n * (-0.000336197177618394 * n + 0.484791561490776);
                e[i++] =
                  107.268039397724 +
                  a *
                    (219927104525741e-19 * a -
                      0.000640992018297945 * r +
                      0.000659397001245577 * t +
                      0.000426105652938837 * n -
                      0.176491792462875) +
                  r *
                    (-0.000778269941513683 * r +
                      0.00130872261408275 * t +
                      0.000770482631801132 * n -
                      0.151051492775562) +
                  t *
                    (0.00126935368114843 * t -
                      0.00265090189010898 * n +
                      0.25802910206845) +
                  n * (-0.000318913117588328 * n - 0.213742400323665);
                e[i++] =
                  a *
                    (-0.000570115196973677 * a -
                      263409051004589e-19 * r +
                      0.0020741088115012 * t -
                      0.00288260236853442 * n +
                      0.814272968359295) -
                  20.810012546947 +
                  r *
                    (-153496057440975e-19 * r -
                      0.000132689043961446 * t +
                      0.000560833691242812 * n -
                      0.195152027534049) +
                  t *
                    (0.00174418132927582 * t -
                      0.00255243321439347 * n +
                      0.116935020465145) +
                  n * (-0.000343531996510555 * n + 0.24165260232407);
              }
              return e.subarray(0, i);
            }
            _convertYcckToRgba(e) {
              for (let t = 0, a = e.length; t < a; t += 4) {
                const a = e[t],
                  r = e[t + 1],
                  n = e[t + 2],
                  i = e[t + 3];
                e[t] =
                  r *
                    (-660635669420364e-19 * r +
                      0.000437130475926232 * n -
                      54080610064599e-18 * a +
                      0.00048449797120281 * i -
                      0.154362151871126) -
                  122.67195406894 +
                  n *
                    (-0.000957964378445773 * n +
                      0.000817076911346625 * a -
                      0.00477271405408747 * i +
                      1.53380253221734) +
                  a *
                    (0.000961250184130688 * a -
                      0.00266257332283933 * i +
                      0.48357088451265) +
                  i * (-0.000336197177618394 * i + 0.484791561490776);
                e[t + 1] =
                  107.268039397724 +
                  r *
                    (219927104525741e-19 * r -
                      0.000640992018297945 * n +
                      0.000659397001245577 * a +
                      0.000426105652938837 * i -
                      0.176491792462875) +
                  n *
                    (-0.000778269941513683 * n +
                      0.00130872261408275 * a +
                      0.000770482631801132 * i -
                      0.151051492775562) +
                  a *
                    (0.00126935368114843 * a -
                      0.00265090189010898 * i +
                      0.25802910206845) +
                  i * (-0.000318913117588328 * i - 0.213742400323665);
                e[t + 2] =
                  r *
                    (-0.000570115196973677 * r -
                      263409051004589e-19 * n +
                      0.0020741088115012 * a -
                      0.00288260236853442 * i +
                      0.814272968359295) -
                  20.810012546947 +
                  n *
                    (-153496057440975e-19 * n -
                      0.000132689043961446 * a +
                      0.000560833691242812 * i -
                      0.195152027534049) +
                  a *
                    (0.00174418132927582 * a -
                      0.00255243321439347 * i +
                      0.116935020465145) +
                  i * (-0.000343531996510555 * i + 0.24165260232407);
                e[t + 3] = 255;
              }
              return e;
            }
            _convertYcckToCmyk(e) {
              let t, a, r;
              for (let n = 0, i = e.length; n < i; n += 4) {
                t = e[n];
                a = e[n + 1];
                r = e[n + 2];
                e[n] = 434.456 - t - 1.402 * r;
                e[n + 1] = 119.541 - t + 0.344 * a + 0.714 * r;
                e[n + 2] = 481.816 - t - 1.772 * a;
              }
              return e;
            }
            _convertCmykToRgb(e) {
              let t,
                a,
                r,
                n,
                i = 0;
              for (let s = 0, o = e.length; s < o; s += 4) {
                t = e[s];
                a = e[s + 1];
                r = e[s + 2];
                n = e[s + 3];
                e[i++] =
                  255 +
                  t *
                    (-6747147073602441e-20 * t +
                      0.0008379262121013727 * a +
                      0.0002894718188643294 * r +
                      0.003264231057537806 * n -
                      1.1185611867203937) +
                  a *
                    (26374107616089405e-21 * a -
                      8626949158638572e-20 * r -
                      0.0002748769067499491 * n -
                      0.02155688794978967) +
                  r *
                    (-3878099212869363e-20 * r -
                      0.0003267808279485286 * n +
                      0.0686742238595345) -
                  n * (0.0003361971776183937 * n + 0.7430659151342254);
                e[i++] =
                  255 +
                  t *
                    (0.00013596372813588848 * t +
                      0.000924537132573585 * a +
                      0.00010567359618683593 * r +
                      0.0004791864687436512 * n -
                      0.3109689587515875) +
                  a *
                    (-0.00023545346108370344 * a +
                      0.0002702845253534714 * r +
                      0.0020200308977307156 * n -
                      0.7488052167015494) +
                  r *
                    (6834815998235662e-20 * r +
                      0.00015168452363460973 * n -
                      0.09751927774728933) -
                  n * (0.0003189131175883281 * n + 0.7364883807733168);
                e[i++] =
                  255 +
                  t *
                    (13598650411385307e-21 * t +
                      0.00012423956175490851 * a +
                      0.0004751985097583589 * r -
                      36729317476630422e-22 * n -
                      0.05562186980264034) +
                  a *
                    (0.00016141380598724676 * a +
                      0.0009692239130725186 * r +
                      0.0007782692450036253 * n -
                      0.44015232367526463) +
                  r *
                    (5.068882914068769e-7 * r +
                      0.0017778369011375071 * n -
                      0.7591454649749609) -
                  n * (0.0003435319965105553 * n + 0.7063770186160144);
              }
              return e.subarray(0, i);
            }
            _convertCmykToRgba(e) {
              for (let t = 0, a = e.length; t < a; t += 4) {
                const a = e[t],
                  r = e[t + 1],
                  n = e[t + 2],
                  i = e[t + 3];
                e[t] =
                  255 +
                  a *
                    (-6747147073602441e-20 * a +
                      0.0008379262121013727 * r +
                      0.0002894718188643294 * n +
                      0.003264231057537806 * i -
                      1.1185611867203937) +
                  r *
                    (26374107616089405e-21 * r -
                      8626949158638572e-20 * n -
                      0.0002748769067499491 * i -
                      0.02155688794978967) +
                  n *
                    (-3878099212869363e-20 * n -
                      0.0003267808279485286 * i +
                      0.0686742238595345) -
                  i * (0.0003361971776183937 * i + 0.7430659151342254);
                e[t + 1] =
                  255 +
                  a *
                    (0.00013596372813588848 * a +
                      0.000924537132573585 * r +
                      0.00010567359618683593 * n +
                      0.0004791864687436512 * i -
                      0.3109689587515875) +
                  r *
                    (-0.00023545346108370344 * r +
                      0.0002702845253534714 * n +
                      0.0020200308977307156 * i -
                      0.7488052167015494) +
                  n *
                    (6834815998235662e-20 * n +
                      0.00015168452363460973 * i -
                      0.09751927774728933) -
                  i * (0.0003189131175883281 * i + 0.7364883807733168);
                e[t + 2] =
                  255 +
                  a *
                    (13598650411385307e-21 * a +
                      0.00012423956175490851 * r +
                      0.0004751985097583589 * n -
                      36729317476630422e-22 * i -
                      0.05562186980264034) +
                  r *
                    (0.00016141380598724676 * r +
                      0.0009692239130725186 * n +
                      0.0007782692450036253 * i -
                      0.44015232367526463) +
                  n *
                    (5.068882914068769e-7 * n +
                      0.0017778369011375071 * i -
                      0.7591454649749609) -
                  i * (0.0003435319965105553 * i + 0.7063770186160144);
                e[t + 3] = 255;
              }
              return e;
            }
            getData({
              width: e,
              height: t,
              forceRGBA: a = !1,
              forceRGB: r = !1,
              isSourcePDF: i = !1,
            }) {
              if (this.numComponents > 4)
                throw new JpegError("Unsupported color mode");
              const s = this._getLinearizedBlockData(e, t, i);
              if (1 === this.numComponents && (a || r)) {
                const e = s.length * (a ? 4 : 3),
                  t = new Uint8ClampedArray(e);
                let r = 0;
                if (a) (0, n.grayToRGBA)(s, new Uint32Array(t.buffer));
                else
                  for (const e of s) {
                    t[r++] = e;
                    t[r++] = e;
                    t[r++] = e;
                  }
                return t;
              }
              if (3 === this.numComponents && this._isColorConversionNeeded) {
                if (a) {
                  const e = new Uint8ClampedArray((s.length / 3) * 4);
                  return this._convertYccToRgba(s, e);
                }
                return this._convertYccToRgb(s);
              }
              if (4 === this.numComponents) {
                if (this._isColorConversionNeeded)
                  return a
                    ? this._convertYcckToRgba(s)
                    : r
                      ? this._convertYcckToRgb(s)
                      : this._convertYcckToCmyk(s);
                if (a) return this._convertCmykToRgba(s);
                if (r) return this._convertCmykToRgb(s);
              }
              return s;
            }
          };
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.convertBlackAndWhiteToRGBA = convertBlackAndWhiteToRGBA;
          t.convertToRGBA = function convertToRGBA(e) {
            switch (e.kind) {
              case r.ImageKind.GRAYSCALE_1BPP:
                return convertBlackAndWhiteToRGBA(e);
              case r.ImageKind.RGB_24BPP:
                return (function convertRGBToRGBA({
                  src: e,
                  srcPos: t = 0,
                  dest: a,
                  destPos: n = 0,
                  width: i,
                  height: s,
                }) {
                  let o = 0;
                  const c = e.length >> 2,
                    l = new Uint32Array(e.buffer, t, c);
                  if (r.FeatureTest.isLittleEndian) {
                    for (; o < c - 2; o += 3, n += 4) {
                      const e = l[o],
                        t = l[o + 1],
                        r = l[o + 2];
                      a[n] = 4278190080 | e;
                      a[n + 1] = (e >>> 24) | (t << 8) | 4278190080;
                      a[n + 2] = (t >>> 16) | (r << 16) | 4278190080;
                      a[n + 3] = (r >>> 8) | 4278190080;
                    }
                    for (let t = 4 * o, r = e.length; t < r; t += 3)
                      a[n++] =
                        e[t] | (e[t + 1] << 8) | (e[t + 2] << 16) | 4278190080;
                  } else {
                    for (; o < c - 2; o += 3, n += 4) {
                      const e = l[o],
                        t = l[o + 1],
                        r = l[o + 2];
                      a[n] = 255 | e;
                      a[n + 1] = (e << 24) | (t >>> 8) | 255;
                      a[n + 2] = (t << 16) | (r >>> 16) | 255;
                      a[n + 3] = (r << 8) | 255;
                    }
                    for (let t = 4 * o, r = e.length; t < r; t += 3)
                      a[n++] =
                        (e[t] << 24) | (e[t + 1] << 16) | (e[t + 2] << 8) | 255;
                  }
                  return { srcPos: t, destPos: n };
                })(e);
            }
            return null;
          };
          t.grayToRGBA = function grayToRGBA(e, t) {
            if (r.FeatureTest.isLittleEndian)
              for (let a = 0, r = e.length; a < r; a++)
                t[a] = (65793 * e[a]) | 4278190080;
            else
              for (let a = 0, r = e.length; a < r; a++)
                t[a] = (16843008 * e[a]) | 255;
          };
          var r = a(2);
          function convertBlackAndWhiteToRGBA({
            src: e,
            srcPos: t = 0,
            dest: a,
            width: n,
            height: i,
            nonBlackColor: s = 4294967295,
            inverseDecode: o = !1,
          }) {
            const c = r.FeatureTest.isLittleEndian ? 4278190080 : 255,
              [l, h] = o ? [s, c] : [c, s],
              u = n >> 3,
              d = 7 & n,
              f = e.length;
            a = new Uint32Array(a.buffer);
            let g = 0;
            for (let r = 0; r < i; r++) {
              for (const r = t + u; t < r; t++) {
                const r = t < f ? e[t] : 255;
                a[g++] = 128 & r ? h : l;
                a[g++] = 64 & r ? h : l;
                a[g++] = 32 & r ? h : l;
                a[g++] = 16 & r ? h : l;
                a[g++] = 8 & r ? h : l;
                a[g++] = 4 & r ? h : l;
                a[g++] = 2 & r ? h : l;
                a[g++] = 1 & r ? h : l;
              }
              if (0 === d) continue;
              const r = t < f ? e[t++] : 255;
              for (let e = 0; e < d; e++) a[g++] = r & (1 << (7 - e)) ? h : l;
            }
            return { srcPos: t, destPos: g };
          }
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.JpxStream = void 0;
          var r = a(18),
            n = a(30),
            i = a(2);
          class JpxStream extends r.DecodeStream {
            constructor(e, t, a) {
              super(t);
              this.stream = e;
              this.dict = e.dict;
              this.maybeLength = t;
              this.params = a;
            }
            get bytes() {
              return (0, i.shadow)(
                this,
                "bytes",
                this.stream.getBytes(this.maybeLength),
              );
            }
            ensureBuffer(e) {}
            readBlock() {
              if (this.eof) return;
              const e = new n.JpxImage();
              e.parse(this.bytes);
              const t = e.width,
                a = e.height,
                r = e.componentsCount,
                i = e.tiles.length;
              if (1 === i) this.buffer = e.tiles[0].items;
              else {
                const n = new Uint8ClampedArray(t * a * r);
                for (let a = 0; a < i; a++) {
                  const i = e.tiles[a],
                    s = i.width,
                    o = i.height,
                    c = i.left,
                    l = i.top,
                    h = i.items;
                  let u = 0,
                    d = (t * l + c) * r;
                  const f = t * r,
                    g = s * r;
                  for (let e = 0; e < o; e++) {
                    const e = h.subarray(u, u + g);
                    n.set(e, d);
                    u += g;
                    d += f;
                  }
                }
                this.buffer = n;
              }
              this.bufferLength = this.buffer.length;
              this.eof = !0;
            }
          }
          t.JpxStream = JpxStream;
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.JpxImage = void 0;
          var r = a(2),
            n = a(3),
            i = a(25);
          class JpxError extends r.BaseException {
            constructor(e) {
              super(`JPX error: ${e}`, "JpxError");
            }
          }
          const s = { LL: 0, LH: 1, HL: 1, HH: 2 };
          t.JpxImage = class JpxImage {
            constructor() {
              this.failOnCorruptedImage = !1;
            }
            parse(e) {
              if (65359 === (0, n.readUint16)(e, 0)) {
                this.parseCodestream(e, 0, e.length);
                return;
              }
              const t = e.length;
              let a = 0;
              for (; a < t; ) {
                let i = 8,
                  s = (0, n.readUint32)(e, a);
                const o = (0, n.readUint32)(e, a + 4);
                a += i;
                if (1 === s) {
                  s =
                    4294967296 * (0, n.readUint32)(e, a) +
                    (0, n.readUint32)(e, a + 4);
                  a += 8;
                  i += 8;
                }
                0 === s && (s = t - a + i);
                if (s < i) throw new JpxError("Invalid box field size");
                const c = s - i;
                let l = !0;
                switch (o) {
                  case 1785737832:
                    l = !1;
                    break;
                  case 1668246642:
                    const t = e[a];
                    if (1 === t) {
                      const t = (0, n.readUint32)(e, a + 3);
                      switch (t) {
                        case 16:
                        case 17:
                        case 18:
                          break;
                        default:
                          (0, r.warn)("Unknown colorspace " + t);
                      }
                    } else 2 === t && (0, r.info)("ICC profile not supported");
                    break;
                  case 1785737827:
                    this.parseCodestream(e, a, a + c);
                    break;
                  case 1783636e3:
                    218793738 !== (0, n.readUint32)(e, a) &&
                      (0, r.warn)("Invalid JP2 signature");
                    break;
                  case 1783634458:
                  case 1718909296:
                  case 1920099697:
                  case 1919251232:
                  case 1768449138:
                    break;
                  default:
                    const i = String.fromCharCode(
                      (o >> 24) & 255,
                      (o >> 16) & 255,
                      (o >> 8) & 255,
                      255 & o,
                    );
                    (0, r.warn)(`Unsupported header type ${o} (${i}).`);
                }
                l && (a += c);
              }
            }
            parseImageProperties(e) {
              let t = e.getByte();
              for (; t >= 0; ) {
                const a = t;
                t = e.getByte();
                if (65361 === ((a << 8) | t)) {
                  e.skip(4);
                  const t = e.getInt32() >>> 0,
                    a = e.getInt32() >>> 0,
                    r = e.getInt32() >>> 0,
                    n = e.getInt32() >>> 0;
                  e.skip(16);
                  const i = e.getUint16();
                  this.width = t - r;
                  this.height = a - n;
                  this.componentsCount = i;
                  this.bitsPerComponent = 8;
                  return;
                }
              }
              throw new JpxError("No size marker found in JPX stream");
            }
            parseCodestream(e, t, a) {
              const i = {};
              let s = !1;
              try {
                let o = t;
                for (; o + 1 < a; ) {
                  const t = (0, n.readUint16)(e, o);
                  o += 2;
                  let a,
                    c,
                    l,
                    h,
                    u,
                    d,
                    f = 0;
                  switch (t) {
                    case 65359:
                      i.mainHeader = !0;
                      break;
                    case 65497:
                      break;
                    case 65361:
                      f = (0, n.readUint16)(e, o);
                      const g = {};
                      g.Xsiz = (0, n.readUint32)(e, o + 4);
                      g.Ysiz = (0, n.readUint32)(e, o + 8);
                      g.XOsiz = (0, n.readUint32)(e, o + 12);
                      g.YOsiz = (0, n.readUint32)(e, o + 16);
                      g.XTsiz = (0, n.readUint32)(e, o + 20);
                      g.YTsiz = (0, n.readUint32)(e, o + 24);
                      g.XTOsiz = (0, n.readUint32)(e, o + 28);
                      g.YTOsiz = (0, n.readUint32)(e, o + 32);
                      const p = (0, n.readUint16)(e, o + 36);
                      g.Csiz = p;
                      const m = [];
                      a = o + 38;
                      for (let t = 0; t < p; t++) {
                        const t = {
                          precision: 1 + (127 & e[a]),
                          isSigned: !!(128 & e[a]),
                          XRsiz: e[a + 1],
                          YRsiz: e[a + 2],
                        };
                        a += 3;
                        calculateComponentDimensions(t, g);
                        m.push(t);
                      }
                      i.SIZ = g;
                      i.components = m;
                      calculateTileGrids(i, m);
                      i.QCC = [];
                      i.COC = [];
                      break;
                    case 65372:
                      f = (0, n.readUint16)(e, o);
                      const b = {};
                      a = o + 2;
                      c = e[a++];
                      switch (31 & c) {
                        case 0:
                          h = 8;
                          u = !0;
                          break;
                        case 1:
                          h = 16;
                          u = !1;
                          break;
                        case 2:
                          h = 16;
                          u = !0;
                          break;
                        default:
                          throw new Error("Invalid SQcd value " + c);
                      }
                      b.noQuantization = 8 === h;
                      b.scalarExpounded = u;
                      b.guardBits = c >> 5;
                      l = [];
                      for (; a < f + o; ) {
                        const t = {};
                        if (8 === h) {
                          t.epsilon = e[a++] >> 3;
                          t.mu = 0;
                        } else {
                          t.epsilon = e[a] >> 3;
                          t.mu = ((7 & e[a]) << 8) | e[a + 1];
                          a += 2;
                        }
                        l.push(t);
                      }
                      b.SPqcds = l;
                      if (i.mainHeader) i.QCD = b;
                      else {
                        i.currentTile.QCD = b;
                        i.currentTile.QCC = [];
                      }
                      break;
                    case 65373:
                      f = (0, n.readUint16)(e, o);
                      const y = {};
                      a = o + 2;
                      let w;
                      if (i.SIZ.Csiz < 257) w = e[a++];
                      else {
                        w = (0, n.readUint16)(e, a);
                        a += 2;
                      }
                      c = e[a++];
                      switch (31 & c) {
                        case 0:
                          h = 8;
                          u = !0;
                          break;
                        case 1:
                          h = 16;
                          u = !1;
                          break;
                        case 2:
                          h = 16;
                          u = !0;
                          break;
                        default:
                          throw new Error("Invalid SQcd value " + c);
                      }
                      y.noQuantization = 8 === h;
                      y.scalarExpounded = u;
                      y.guardBits = c >> 5;
                      l = [];
                      for (; a < f + o; ) {
                        const t = {};
                        if (8 === h) {
                          t.epsilon = e[a++] >> 3;
                          t.mu = 0;
                        } else {
                          t.epsilon = e[a] >> 3;
                          t.mu = ((7 & e[a]) << 8) | e[a + 1];
                          a += 2;
                        }
                        l.push(t);
                      }
                      y.SPqcds = l;
                      i.mainHeader
                        ? (i.QCC[w] = y)
                        : (i.currentTile.QCC[w] = y);
                      break;
                    case 65362:
                      f = (0, n.readUint16)(e, o);
                      const S = {};
                      a = o + 2;
                      const x = e[a++];
                      S.entropyCoderWithCustomPrecincts = !!(1 & x);
                      S.sopMarkerUsed = !!(2 & x);
                      S.ephMarkerUsed = !!(4 & x);
                      S.progressionOrder = e[a++];
                      S.layersCount = (0, n.readUint16)(e, a);
                      a += 2;
                      S.multipleComponentTransform = e[a++];
                      S.decompositionLevelsCount = e[a++];
                      S.xcb = 2 + (15 & e[a++]);
                      S.ycb = 2 + (15 & e[a++]);
                      const C = e[a++];
                      S.selectiveArithmeticCodingBypass = !!(1 & C);
                      S.resetContextProbabilities = !!(2 & C);
                      S.terminationOnEachCodingPass = !!(4 & C);
                      S.verticallyStripe = !!(8 & C);
                      S.predictableTermination = !!(16 & C);
                      S.segmentationSymbolUsed = !!(32 & C);
                      S.reversibleTransformation = e[a++];
                      if (S.entropyCoderWithCustomPrecincts) {
                        const t = [];
                        for (; a < f + o; ) {
                          const r = e[a++];
                          t.push({ PPx: 15 & r, PPy: r >> 4 });
                        }
                        S.precinctsSizes = t;
                      }
                      const k = [];
                      S.selectiveArithmeticCodingBypass &&
                        k.push("selectiveArithmeticCodingBypass");
                      S.terminationOnEachCodingPass &&
                        k.push("terminationOnEachCodingPass");
                      S.verticallyStripe && k.push("verticallyStripe");
                      S.predictableTermination &&
                        k.push("predictableTermination");
                      if (k.length > 0) {
                        s = !0;
                        (0, r.warn)(
                          `JPX: Unsupported COD options (${k.join(", ")}).`,
                        );
                      }
                      if (i.mainHeader) i.COD = S;
                      else {
                        i.currentTile.COD = S;
                        i.currentTile.COC = [];
                      }
                      break;
                    case 65424:
                      f = (0, n.readUint16)(e, o);
                      d = {};
                      d.index = (0, n.readUint16)(e, o + 2);
                      d.length = (0, n.readUint32)(e, o + 4);
                      d.dataEnd = d.length + o - 2;
                      d.partIndex = e[o + 8];
                      d.partsCount = e[o + 9];
                      i.mainHeader = !1;
                      if (0 === d.partIndex) {
                        d.COD = i.COD;
                        d.COC = i.COC.slice(0);
                        d.QCD = i.QCD;
                        d.QCC = i.QCC.slice(0);
                      }
                      i.currentTile = d;
                      break;
                    case 65427:
                      d = i.currentTile;
                      if (0 === d.partIndex) {
                        initializeTile(i, d.index);
                        buildPackets(i);
                      }
                      f = d.dataEnd - o;
                      parseTilePackets(i, e, o, f);
                      break;
                    case 65363:
                      (0, r.warn)(
                        "JPX: Codestream code 0xFF53 (COC) is not implemented.",
                      );
                    case 65365:
                    case 65367:
                    case 65368:
                    case 65380:
                      f = (0, n.readUint16)(e, o);
                      break;
                    default:
                      throw new Error(
                        "Unknown codestream code: " + t.toString(16),
                      );
                  }
                  o += f;
                }
              } catch (e) {
                if (s || this.failOnCorruptedImage)
                  throw new JpxError(e.message);
                (0, r.warn)(`JPX: Trying to recover from: "${e.message}".`);
              }
              this.tiles = (function transformComponents(e) {
                const t = e.SIZ,
                  a = e.components,
                  r = t.Csiz,
                  n = [];
                for (let t = 0, i = e.tiles.length; t < i; t++) {
                  const i = e.tiles[t],
                    s = [];
                  for (let t = 0; t < r; t++) s[t] = transformTile(e, i, t);
                  const o = s[0],
                    c = new Uint8ClampedArray(o.items.length * r),
                    l = {
                      left: o.left,
                      top: o.top,
                      width: o.width,
                      height: o.height,
                      items: c,
                    };
                  let h,
                    u,
                    d,
                    f,
                    g,
                    p,
                    m,
                    b = 0;
                  if (
                    i.codingStyleDefaultParameters.multipleComponentTransform
                  ) {
                    const e = 4 === r,
                      t = s[0].items,
                      n = s[1].items,
                      o = s[2].items,
                      l = e ? s[3].items : null;
                    h = a[0].precision - 8;
                    u = 0.5 + (128 << h);
                    const y = i.components[0],
                      w = r - 3;
                    f = t.length;
                    if (y.codingStyleParameters.reversibleTransformation)
                      for (d = 0; d < f; d++, b += w) {
                        g = t[d] + u;
                        p = n[d];
                        m = o[d];
                        const e = g - ((m + p) >> 2);
                        c[b++] = (e + m) >> h;
                        c[b++] = e >> h;
                        c[b++] = (e + p) >> h;
                      }
                    else
                      for (d = 0; d < f; d++, b += w) {
                        g = t[d] + u;
                        p = n[d];
                        m = o[d];
                        c[b++] = (g + 1.402 * m) >> h;
                        c[b++] = (g - 0.34413 * p - 0.71414 * m) >> h;
                        c[b++] = (g + 1.772 * p) >> h;
                      }
                    if (e)
                      for (d = 0, b = 3; d < f; d++, b += 4)
                        c[b] = (l[d] + u) >> h;
                  } else
                    for (let e = 0; e < r; e++) {
                      const t = s[e].items;
                      h = a[e].precision - 8;
                      u = 0.5 + (128 << h);
                      for (b = e, d = 0, f = t.length; d < f; d++) {
                        c[b] = (t[d] + u) >> h;
                        b += r;
                      }
                    }
                  n.push(l);
                }
                return n;
              })(i);
              this.width = i.SIZ.Xsiz - i.SIZ.XOsiz;
              this.height = i.SIZ.Ysiz - i.SIZ.YOsiz;
              this.componentsCount = i.SIZ.Csiz;
            }
          };
          function calculateComponentDimensions(e, t) {
            e.x0 = Math.ceil(t.XOsiz / e.XRsiz);
            e.x1 = Math.ceil(t.Xsiz / e.XRsiz);
            e.y0 = Math.ceil(t.YOsiz / e.YRsiz);
            e.y1 = Math.ceil(t.Ysiz / e.YRsiz);
            e.width = e.x1 - e.x0;
            e.height = e.y1 - e.y0;
          }
          function calculateTileGrids(e, t) {
            const a = e.SIZ,
              r = [];
            let n;
            const i = Math.ceil((a.Xsiz - a.XTOsiz) / a.XTsiz),
              s = Math.ceil((a.Ysiz - a.YTOsiz) / a.YTsiz);
            for (let e = 0; e < s; e++)
              for (let t = 0; t < i; t++) {
                n = {};
                n.tx0 = Math.max(a.XTOsiz + t * a.XTsiz, a.XOsiz);
                n.ty0 = Math.max(a.YTOsiz + e * a.YTsiz, a.YOsiz);
                n.tx1 = Math.min(a.XTOsiz + (t + 1) * a.XTsiz, a.Xsiz);
                n.ty1 = Math.min(a.YTOsiz + (e + 1) * a.YTsiz, a.Ysiz);
                n.width = n.tx1 - n.tx0;
                n.height = n.ty1 - n.ty0;
                n.components = [];
                r.push(n);
              }
            e.tiles = r;
            for (let e = 0, i = a.Csiz; e < i; e++) {
              const a = t[e];
              for (let t = 0, i = r.length; t < i; t++) {
                const i = {};
                n = r[t];
                i.tcx0 = Math.ceil(n.tx0 / a.XRsiz);
                i.tcy0 = Math.ceil(n.ty0 / a.YRsiz);
                i.tcx1 = Math.ceil(n.tx1 / a.XRsiz);
                i.tcy1 = Math.ceil(n.ty1 / a.YRsiz);
                i.width = i.tcx1 - i.tcx0;
                i.height = i.tcy1 - i.tcy0;
                n.components[e] = i;
              }
            }
          }
          function getBlocksDimensions(e, t, a) {
            const r = t.codingStyleParameters,
              n = {};
            if (r.entropyCoderWithCustomPrecincts) {
              n.PPx = r.precinctsSizes[a].PPx;
              n.PPy = r.precinctsSizes[a].PPy;
            } else {
              n.PPx = 15;
              n.PPy = 15;
            }
            n.xcb_ =
              a > 0 ? Math.min(r.xcb, n.PPx - 1) : Math.min(r.xcb, n.PPx);
            n.ycb_ =
              a > 0 ? Math.min(r.ycb, n.PPy - 1) : Math.min(r.ycb, n.PPy);
            return n;
          }
          function buildPrecincts(e, t, a) {
            const r = 1 << a.PPx,
              n = 1 << a.PPy,
              i = 0 === t.resLevel,
              s = 1 << (a.PPx + (i ? 0 : -1)),
              o = 1 << (a.PPy + (i ? 0 : -1)),
              c =
                t.trx1 > t.trx0
                  ? Math.ceil(t.trx1 / r) - Math.floor(t.trx0 / r)
                  : 0,
              l =
                t.try1 > t.try0
                  ? Math.ceil(t.try1 / n) - Math.floor(t.try0 / n)
                  : 0,
              h = c * l;
            t.precinctParameters = {
              precinctWidth: r,
              precinctHeight: n,
              numprecinctswide: c,
              numprecinctshigh: l,
              numprecincts: h,
              precinctWidthInSubband: s,
              precinctHeightInSubband: o,
            };
          }
          function buildCodeblocks(e, t, a) {
            const r = a.xcb_,
              n = a.ycb_,
              i = 1 << r,
              s = 1 << n,
              o = t.tbx0 >> r,
              c = t.tby0 >> n,
              l = (t.tbx1 + i - 1) >> r,
              h = (t.tby1 + s - 1) >> n,
              u = t.resolution.precinctParameters,
              d = [],
              f = [];
            let g, p, m, b;
            for (p = c; p < h; p++)
              for (g = o; g < l; g++) {
                m = {
                  cbx: g,
                  cby: p,
                  tbx0: i * g,
                  tby0: s * p,
                  tbx1: i * (g + 1),
                  tby1: s * (p + 1),
                };
                m.tbx0_ = Math.max(t.tbx0, m.tbx0);
                m.tby0_ = Math.max(t.tby0, m.tby0);
                m.tbx1_ = Math.min(t.tbx1, m.tbx1);
                m.tby1_ = Math.min(t.tby1, m.tby1);
                b =
                  Math.floor((m.tbx0_ - t.tbx0) / u.precinctWidthInSubband) +
                  Math.floor((m.tby0_ - t.tby0) / u.precinctHeightInSubband) *
                    u.numprecinctswide;
                m.precinctNumber = b;
                m.subbandType = t.type;
                m.Lblock = 3;
                if (m.tbx1_ <= m.tbx0_ || m.tby1_ <= m.tby0_) continue;
                d.push(m);
                let e = f[b];
                if (void 0 !== e) {
                  g < e.cbxMin
                    ? (e.cbxMin = g)
                    : g > e.cbxMax && (e.cbxMax = g);
                  p < e.cbyMin
                    ? (e.cbxMin = p)
                    : p > e.cbyMax && (e.cbyMax = p);
                } else
                  f[b] = e = { cbxMin: g, cbyMin: p, cbxMax: g, cbyMax: p };
                m.precinct = e;
              }
            t.codeblockParameters = {
              codeblockWidth: r,
              codeblockHeight: n,
              numcodeblockwide: l - o + 1,
              numcodeblockhigh: h - c + 1,
            };
            t.codeblocks = d;
            t.precincts = f;
          }
          function createPacket(e, t, a) {
            const r = [],
              n = e.subbands;
            for (let e = 0, a = n.length; e < a; e++) {
              const a = n[e].codeblocks;
              for (let e = 0, n = a.length; e < n; e++) {
                const n = a[e];
                n.precinctNumber === t && r.push(n);
              }
            }
            return { layerNumber: a, codeblocks: r };
          }
          function LayerResolutionComponentPositionIterator(e) {
            const t = e.SIZ,
              a = e.currentTile.index,
              r = e.tiles[a],
              n = r.codingStyleDefaultParameters.layersCount,
              i = t.Csiz;
            let s = 0;
            for (let e = 0; e < i; e++)
              s = Math.max(
                s,
                r.components[e].codingStyleParameters.decompositionLevelsCount,
              );
            let o = 0,
              c = 0,
              l = 0,
              h = 0;
            this.nextPacket = function JpxImage_nextPacket() {
              for (; o < n; o++) {
                for (; c <= s; c++) {
                  for (; l < i; l++) {
                    const e = r.components[l];
                    if (c > e.codingStyleParameters.decompositionLevelsCount)
                      continue;
                    const t = e.resolutions[c],
                      a = t.precinctParameters.numprecincts;
                    for (; h < a; ) {
                      const e = createPacket(t, h, o);
                      h++;
                      return e;
                    }
                    h = 0;
                  }
                  l = 0;
                }
                c = 0;
              }
              throw new JpxError("Out of packets");
            };
          }
          function ResolutionLayerComponentPositionIterator(e) {
            const t = e.SIZ,
              a = e.currentTile.index,
              r = e.tiles[a],
              n = r.codingStyleDefaultParameters.layersCount,
              i = t.Csiz;
            let s = 0;
            for (let e = 0; e < i; e++)
              s = Math.max(
                s,
                r.components[e].codingStyleParameters.decompositionLevelsCount,
              );
            let o = 0,
              c = 0,
              l = 0,
              h = 0;
            this.nextPacket = function JpxImage_nextPacket() {
              for (; o <= s; o++) {
                for (; c < n; c++) {
                  for (; l < i; l++) {
                    const e = r.components[l];
                    if (o > e.codingStyleParameters.decompositionLevelsCount)
                      continue;
                    const t = e.resolutions[o],
                      a = t.precinctParameters.numprecincts;
                    for (; h < a; ) {
                      const e = createPacket(t, h, c);
                      h++;
                      return e;
                    }
                    h = 0;
                  }
                  l = 0;
                }
                c = 0;
              }
              throw new JpxError("Out of packets");
            };
          }
          function ResolutionPositionComponentLayerIterator(e) {
            const t = e.SIZ,
              a = e.currentTile.index,
              r = e.tiles[a],
              n = r.codingStyleDefaultParameters.layersCount,
              i = t.Csiz;
            let s,
              o,
              c,
              l,
              h = 0;
            for (c = 0; c < i; c++) {
              const e = r.components[c];
              h = Math.max(h, e.codingStyleParameters.decompositionLevelsCount);
            }
            const u = new Int32Array(h + 1);
            for (o = 0; o <= h; ++o) {
              let e = 0;
              for (c = 0; c < i; ++c) {
                const t = r.components[c].resolutions;
                o < t.length &&
                  (e = Math.max(e, t[o].precinctParameters.numprecincts));
              }
              u[o] = e;
            }
            s = 0;
            o = 0;
            c = 0;
            l = 0;
            this.nextPacket = function JpxImage_nextPacket() {
              for (; o <= h; o++) {
                for (; l < u[o]; l++) {
                  for (; c < i; c++) {
                    const e = r.components[c];
                    if (o > e.codingStyleParameters.decompositionLevelsCount)
                      continue;
                    const t = e.resolutions[o],
                      a = t.precinctParameters.numprecincts;
                    if (!(l >= a)) {
                      for (; s < n; ) {
                        const e = createPacket(t, l, s);
                        s++;
                        return e;
                      }
                      s = 0;
                    }
                  }
                  c = 0;
                }
                l = 0;
              }
              throw new JpxError("Out of packets");
            };
          }
          function PositionComponentResolutionLayerIterator(e) {
            const t = e.SIZ,
              a = e.currentTile.index,
              r = e.tiles[a],
              n = r.codingStyleDefaultParameters.layersCount,
              i = t.Csiz,
              s = getPrecinctSizesInImageScale(r),
              o = s;
            let c = 0,
              l = 0,
              h = 0,
              u = 0,
              d = 0;
            this.nextPacket = function JpxImage_nextPacket() {
              for (; d < o.maxNumHigh; d++) {
                for (; u < o.maxNumWide; u++) {
                  for (; h < i; h++) {
                    const e = r.components[h],
                      t = e.codingStyleParameters.decompositionLevelsCount;
                    for (; l <= t; l++) {
                      const t = e.resolutions[l],
                        a = s.components[h].resolutions[l],
                        r = getPrecinctIndexIfExist(u, d, a, o, t);
                      if (null !== r) {
                        for (; c < n; ) {
                          const e = createPacket(t, r, c);
                          c++;
                          return e;
                        }
                        c = 0;
                      }
                    }
                    l = 0;
                  }
                  h = 0;
                }
                u = 0;
              }
              throw new JpxError("Out of packets");
            };
          }
          function ComponentPositionResolutionLayerIterator(e) {
            const t = e.SIZ,
              a = e.currentTile.index,
              r = e.tiles[a],
              n = r.codingStyleDefaultParameters.layersCount,
              i = t.Csiz,
              s = getPrecinctSizesInImageScale(r);
            let o = 0,
              c = 0,
              l = 0,
              h = 0,
              u = 0;
            this.nextPacket = function JpxImage_nextPacket() {
              for (; l < i; ++l) {
                const e = r.components[l],
                  t = s.components[l],
                  a = e.codingStyleParameters.decompositionLevelsCount;
                for (; u < t.maxNumHigh; u++) {
                  for (; h < t.maxNumWide; h++) {
                    for (; c <= a; c++) {
                      const a = e.resolutions[c],
                        r = t.resolutions[c],
                        i = getPrecinctIndexIfExist(h, u, r, t, a);
                      if (null !== i) {
                        for (; o < n; ) {
                          const e = createPacket(a, i, o);
                          o++;
                          return e;
                        }
                        o = 0;
                      }
                    }
                    c = 0;
                  }
                  h = 0;
                }
                u = 0;
              }
              throw new JpxError("Out of packets");
            };
          }
          function getPrecinctIndexIfExist(e, t, a, r, n) {
            const i = e * r.minWidth,
              s = t * r.minHeight;
            if (i % a.width != 0 || s % a.height != 0) return null;
            const o = (s / a.width) * n.precinctParameters.numprecinctswide;
            return i / a.height + o;
          }
          function getPrecinctSizesInImageScale(e) {
            const t = e.components.length;
            let a = Number.MAX_VALUE,
              r = Number.MAX_VALUE,
              n = 0,
              i = 0;
            const s = new Array(t);
            for (let o = 0; o < t; o++) {
              const t = e.components[o],
                c = t.codingStyleParameters.decompositionLevelsCount,
                l = new Array(c + 1);
              let h = Number.MAX_VALUE,
                u = Number.MAX_VALUE,
                d = 0,
                f = 0,
                g = 1;
              for (let e = c; e >= 0; --e) {
                const a = t.resolutions[e],
                  r = g * a.precinctParameters.precinctWidth,
                  n = g * a.precinctParameters.precinctHeight;
                h = Math.min(h, r);
                u = Math.min(u, n);
                d = Math.max(d, a.precinctParameters.numprecinctswide);
                f = Math.max(f, a.precinctParameters.numprecinctshigh);
                l[e] = { width: r, height: n };
                g <<= 1;
              }
              a = Math.min(a, h);
              r = Math.min(r, u);
              n = Math.max(n, d);
              i = Math.max(i, f);
              s[o] = {
                resolutions: l,
                minWidth: h,
                minHeight: u,
                maxNumWide: d,
                maxNumHigh: f,
              };
            }
            return {
              components: s,
              minWidth: a,
              minHeight: r,
              maxNumWide: n,
              maxNumHigh: i,
            };
          }
          function buildPackets(e) {
            const t = e.SIZ,
              a = e.currentTile.index,
              r = e.tiles[a],
              n = t.Csiz;
            for (let e = 0; e < n; e++) {
              const t = r.components[e],
                a = t.codingStyleParameters.decompositionLevelsCount,
                n = [],
                i = [];
              for (let e = 0; e <= a; e++) {
                const r = getBlocksDimensions(0, t, e),
                  s = {},
                  o = 1 << (a - e);
                s.trx0 = Math.ceil(t.tcx0 / o);
                s.try0 = Math.ceil(t.tcy0 / o);
                s.trx1 = Math.ceil(t.tcx1 / o);
                s.try1 = Math.ceil(t.tcy1 / o);
                s.resLevel = e;
                buildPrecincts(0, s, r);
                n.push(s);
                let c;
                if (0 === e) {
                  c = {};
                  c.type = "LL";
                  c.tbx0 = Math.ceil(t.tcx0 / o);
                  c.tby0 = Math.ceil(t.tcy0 / o);
                  c.tbx1 = Math.ceil(t.tcx1 / o);
                  c.tby1 = Math.ceil(t.tcy1 / o);
                  c.resolution = s;
                  buildCodeblocks(0, c, r);
                  i.push(c);
                  s.subbands = [c];
                } else {
                  const n = 1 << (a - e + 1),
                    o = [];
                  c = {};
                  c.type = "HL";
                  c.tbx0 = Math.ceil(t.tcx0 / n - 0.5);
                  c.tby0 = Math.ceil(t.tcy0 / n);
                  c.tbx1 = Math.ceil(t.tcx1 / n - 0.5);
                  c.tby1 = Math.ceil(t.tcy1 / n);
                  c.resolution = s;
                  buildCodeblocks(0, c, r);
                  i.push(c);
                  o.push(c);
                  c = {};
                  c.type = "LH";
                  c.tbx0 = Math.ceil(t.tcx0 / n);
                  c.tby0 = Math.ceil(t.tcy0 / n - 0.5);
                  c.tbx1 = Math.ceil(t.tcx1 / n);
                  c.tby1 = Math.ceil(t.tcy1 / n - 0.5);
                  c.resolution = s;
                  buildCodeblocks(0, c, r);
                  i.push(c);
                  o.push(c);
                  c = {};
                  c.type = "HH";
                  c.tbx0 = Math.ceil(t.tcx0 / n - 0.5);
                  c.tby0 = Math.ceil(t.tcy0 / n - 0.5);
                  c.tbx1 = Math.ceil(t.tcx1 / n - 0.5);
                  c.tby1 = Math.ceil(t.tcy1 / n - 0.5);
                  c.resolution = s;
                  buildCodeblocks(0, c, r);
                  i.push(c);
                  o.push(c);
                  s.subbands = o;
                }
              }
              t.resolutions = n;
              t.subbands = i;
            }
            const i = r.codingStyleDefaultParameters.progressionOrder;
            switch (i) {
              case 0:
                r.packetsIterator =
                  new LayerResolutionComponentPositionIterator(e);
                break;
              case 1:
                r.packetsIterator =
                  new ResolutionLayerComponentPositionIterator(e);
                break;
              case 2:
                r.packetsIterator =
                  new ResolutionPositionComponentLayerIterator(e);
                break;
              case 3:
                r.packetsIterator =
                  new PositionComponentResolutionLayerIterator(e);
                break;
              case 4:
                r.packetsIterator =
                  new ComponentPositionResolutionLayerIterator(e);
                break;
              default:
                throw new JpxError(`Unsupported progression order ${i}`);
            }
          }
          function parseTilePackets(e, t, a, r) {
            let i,
              s = 0,
              o = 0,
              c = !1;
            function readBits(e) {
              for (; o < e; ) {
                const e = t[a + s];
                s++;
                if (c) {
                  i = (i << 7) | e;
                  o += 7;
                  c = !1;
                } else {
                  i = (i << 8) | e;
                  o += 8;
                }
                255 === e && (c = !0);
              }
              o -= e;
              return (i >>> o) & ((1 << e) - 1);
            }
            function skipMarkerIfEqual(e) {
              if (255 === t[a + s - 1] && t[a + s] === e) {
                skipBytes(1);
                return !0;
              }
              if (255 === t[a + s] && t[a + s + 1] === e) {
                skipBytes(2);
                return !0;
              }
              return !1;
            }
            function skipBytes(e) {
              s += e;
            }
            function alignToByte() {
              o = 0;
              if (c) {
                s++;
                c = !1;
              }
            }
            function readCodingpasses() {
              if (0 === readBits(1)) return 1;
              if (0 === readBits(1)) return 2;
              let e = readBits(2);
              if (e < 3) return e + 3;
              e = readBits(5);
              if (e < 31) return e + 6;
              e = readBits(7);
              return e + 37;
            }
            const l = e.currentTile.index,
              h = e.tiles[l],
              u = e.COD.sopMarkerUsed,
              d = e.COD.ephMarkerUsed,
              f = h.packetsIterator;
            for (; s < r; ) {
              alignToByte();
              u && skipMarkerIfEqual(145) && skipBytes(4);
              const e = f.nextPacket();
              if (!readBits(1)) continue;
              const r = e.layerNumber,
                i = [];
              let o;
              for (let t = 0, a = e.codeblocks.length; t < a; t++) {
                o = e.codeblocks[t];
                let a = o.precinct;
                const s = o.cbx - a.cbxMin,
                  c = o.cby - a.cbyMin;
                let l,
                  h,
                  u = !1,
                  d = !1;
                if (void 0 !== o.included) u = !!readBits(1);
                else {
                  a = o.precinct;
                  let e;
                  if (void 0 !== a.inclusionTree) e = a.inclusionTree;
                  else {
                    const t = a.cbxMax - a.cbxMin + 1,
                      n = a.cbyMax - a.cbyMin + 1;
                    e = new InclusionTree(t, n, r);
                    h = new TagTree(t, n);
                    a.inclusionTree = e;
                    a.zeroBitPlanesTree = h;
                    for (let e = 0; e < r; e++)
                      if (0 !== readBits(1))
                        throw new JpxError("Invalid tag tree");
                  }
                  if (e.reset(s, c, r))
                    for (;;) {
                      if (!readBits(1)) {
                        e.incrementValue(r);
                        break;
                      }
                      l = !e.nextLevel();
                      if (l) {
                        o.included = !0;
                        u = d = !0;
                        break;
                      }
                    }
                }
                if (!u) continue;
                if (d) {
                  h = a.zeroBitPlanesTree;
                  h.reset(s, c);
                  for (;;)
                    if (readBits(1)) {
                      l = !h.nextLevel();
                      if (l) break;
                    } else h.incrementValue();
                  o.zeroBitPlanes = h.value;
                }
                const f = readCodingpasses();
                for (; readBits(1); ) o.Lblock++;
                const g = (0, n.log2)(f),
                  p = readBits((f < 1 << g ? g - 1 : g) + o.Lblock);
                i.push({ codeblock: o, codingpasses: f, dataLength: p });
              }
              alignToByte();
              d && skipMarkerIfEqual(146);
              for (; i.length > 0; ) {
                const e = i.shift();
                o = e.codeblock;
                void 0 === o.data && (o.data = []);
                o.data.push({
                  data: t,
                  start: a + s,
                  end: a + s + e.dataLength,
                  codingpasses: e.codingpasses,
                });
                s += e.dataLength;
              }
            }
            return s;
          }
          function copyCoefficients(e, t, a, r, n, s, o, c, l) {
            const h = r.tbx0,
              u = r.tby0,
              d = r.tbx1 - r.tbx0,
              f = r.codeblocks,
              g = "H" === r.type.charAt(0) ? 1 : 0,
              p = "H" === r.type.charAt(1) ? t : 0;
            for (let a = 0, m = f.length; a < m; ++a) {
              const m = f[a],
                b = m.tbx1_ - m.tbx0_,
                y = m.tby1_ - m.tby0_;
              if (0 === b || 0 === y) continue;
              if (void 0 === m.data) continue;
              const w = new BitModel(b, y, m.subbandType, m.zeroBitPlanes, s);
              let S = 2;
              const x = m.data;
              let C,
                k,
                v,
                F = 0,
                O = 0;
              for (C = 0, k = x.length; C < k; C++) {
                v = x[C];
                F += v.end - v.start;
                O += v.codingpasses;
              }
              const T = new Uint8Array(F);
              let M = 0;
              for (C = 0, k = x.length; C < k; C++) {
                v = x[C];
                const e = v.data.subarray(v.start, v.end);
                T.set(e, M);
                M += e.length;
              }
              const D = new i.ArithmeticDecoder(T, 0, F);
              w.setDecoder(D);
              for (C = 0; C < O; C++) {
                switch (S) {
                  case 0:
                    w.runSignificancePropagationPass();
                    break;
                  case 1:
                    w.runMagnitudeRefinementPass();
                    break;
                  case 2:
                    w.runCleanupPass();
                    c && w.checkSegmentationSymbol();
                }
                l && w.reset();
                S = (S + 1) % 3;
              }
              let E = m.tbx0_ - h + (m.tby0_ - u) * d;
              const N = w.coefficentsSign,
                R = w.coefficentsMagnitude,
                L = w.bitsDecoded,
                $ = o ? 0 : 0.5;
              let _, j, U;
              M = 0;
              const X = "LL" !== r.type;
              for (C = 0; C < y; C++) {
                const a = 2 * ((E / d) | 0) * (t - d) + g + p;
                for (_ = 0; _ < b; _++) {
                  j = R[M];
                  if (0 !== j) {
                    j = (j + $) * n;
                    0 !== N[M] && (j = -j);
                    U = L[M];
                    e[X ? a + (E << 1) : E] =
                      o && U >= s ? j : j * (1 << (s - U));
                  }
                  E++;
                  M++;
                }
                E += d - b;
              }
            }
          }
          function transformTile(e, t, a) {
            const r = t.components[a],
              n = r.codingStyleParameters,
              i = r.quantizationParameters,
              o = n.decompositionLevelsCount,
              c = i.SPqcds,
              l = i.scalarExpounded,
              h = i.guardBits,
              u = n.segmentationSymbolUsed,
              d = n.resetContextProbabilities,
              f = e.components[a].precision,
              g = n.reversibleTransformation,
              p = g ? new ReversibleTransform() : new IrreversibleTransform(),
              m = [];
            let b = 0;
            for (let e = 0; e <= o; e++) {
              const t = r.resolutions[e],
                a = t.trx1 - t.trx0,
                n = t.try1 - t.try0,
                i = new Float32Array(a * n);
              for (let r = 0, n = t.subbands.length; r < n; r++) {
                let n, o;
                if (l) {
                  n = c[b].mu;
                  o = c[b].epsilon;
                  b++;
                } else {
                  n = c[0].mu;
                  o = c[0].epsilon + (e > 0 ? 1 - e : 0);
                }
                const p = t.subbands[r],
                  m = s[p.type];
                copyCoefficients(
                  i,
                  a,
                  0,
                  p,
                  g ? 1 : 2 ** (f + m - o) * (1 + n / 2048),
                  h + o - 1,
                  g,
                  u,
                  d,
                );
              }
              m.push({ width: a, height: n, items: i });
            }
            const y = p.calculate(m, r.tcx0, r.tcy0);
            return {
              left: r.tcx0,
              top: r.tcy0,
              width: y.width,
              height: y.height,
              items: y.items,
            };
          }
          function initializeTile(e, t) {
            const a = e.SIZ.Csiz,
              r = e.tiles[t];
            for (let t = 0; t < a; t++) {
              const a = r.components[t],
                n =
                  void 0 !== e.currentTile.QCC[t]
                    ? e.currentTile.QCC[t]
                    : e.currentTile.QCD;
              a.quantizationParameters = n;
              const i =
                void 0 !== e.currentTile.COC[t]
                  ? e.currentTile.COC[t]
                  : e.currentTile.COD;
              a.codingStyleParameters = i;
            }
            r.codingStyleDefaultParameters = e.currentTile.COD;
          }
          class TagTree {
            constructor(e, t) {
              const a = (0, n.log2)(Math.max(e, t)) + 1;
              this.levels = [];
              for (let r = 0; r < a; r++) {
                const a = { width: e, height: t, items: [] };
                this.levels.push(a);
                e = Math.ceil(e / 2);
                t = Math.ceil(t / 2);
              }
            }
            reset(e, t) {
              let a,
                r = 0,
                n = 0;
              for (; r < this.levels.length; ) {
                a = this.levels[r];
                const i = e + t * a.width;
                if (void 0 !== a.items[i]) {
                  n = a.items[i];
                  break;
                }
                a.index = i;
                e >>= 1;
                t >>= 1;
                r++;
              }
              r--;
              a = this.levels[r];
              a.items[a.index] = n;
              this.currentLevel = r;
              delete this.value;
            }
            incrementValue() {
              const e = this.levels[this.currentLevel];
              e.items[e.index]++;
            }
            nextLevel() {
              let e = this.currentLevel,
                t = this.levels[e];
              const a = t.items[t.index];
              e--;
              if (e < 0) {
                this.value = a;
                return !1;
              }
              this.currentLevel = e;
              t = this.levels[e];
              t.items[t.index] = a;
              return !0;
            }
          }
          class InclusionTree {
            constructor(e, t, a) {
              const r = (0, n.log2)(Math.max(e, t)) + 1;
              this.levels = [];
              for (let n = 0; n < r; n++) {
                const r = new Uint8Array(e * t);
                for (let e = 0, t = r.length; e < t; e++) r[e] = a;
                const n = { width: e, height: t, items: r };
                this.levels.push(n);
                e = Math.ceil(e / 2);
                t = Math.ceil(t / 2);
              }
            }
            reset(e, t, a) {
              let r = 0;
              for (; r < this.levels.length; ) {
                const n = this.levels[r],
                  i = e + t * n.width;
                n.index = i;
                const s = n.items[i];
                if (255 === s) break;
                if (s > a) {
                  this.currentLevel = r;
                  this.propagateValues();
                  return !1;
                }
                e >>= 1;
                t >>= 1;
                r++;
              }
              this.currentLevel = r - 1;
              return !0;
            }
            incrementValue(e) {
              const t = this.levels[this.currentLevel];
              t.items[t.index] = e + 1;
              this.propagateValues();
            }
            propagateValues() {
              let e = this.currentLevel,
                t = this.levels[e];
              const a = t.items[t.index];
              for (; --e >= 0; ) {
                t = this.levels[e];
                t.items[t.index] = a;
              }
            }
            nextLevel() {
              let e = this.currentLevel,
                t = this.levels[e];
              const a = t.items[t.index];
              t.items[t.index] = 255;
              e--;
              if (e < 0) return !1;
              this.currentLevel = e;
              t = this.levels[e];
              t.items[t.index] = a;
              return !0;
            }
          }
          class BitModel {
            static UNIFORM_CONTEXT = 17;
            static RUNLENGTH_CONTEXT = 18;
            static LLAndLHContextsLabel = new Uint8Array([
              0, 5, 8, 0, 3, 7, 8, 0, 4, 7, 8, 0, 0, 0, 0, 0, 1, 6, 8, 0, 3, 7,
              8, 0, 4, 7, 8, 0, 0, 0, 0, 0, 2, 6, 8, 0, 3, 7, 8, 0, 4, 7, 8, 0,
              0, 0, 0, 0, 2, 6, 8, 0, 3, 7, 8, 0, 4, 7, 8, 0, 0, 0, 0, 0, 2, 6,
              8, 0, 3, 7, 8, 0, 4, 7, 8,
            ]);
            static HLContextLabel = new Uint8Array([
              0, 3, 4, 0, 5, 7, 7, 0, 8, 8, 8, 0, 0, 0, 0, 0, 1, 3, 4, 0, 6, 7,
              7, 0, 8, 8, 8, 0, 0, 0, 0, 0, 2, 3, 4, 0, 6, 7, 7, 0, 8, 8, 8, 0,
              0, 0, 0, 0, 2, 3, 4, 0, 6, 7, 7, 0, 8, 8, 8, 0, 0, 0, 0, 0, 2, 3,
              4, 0, 6, 7, 7, 0, 8, 8, 8,
            ]);
            static HHContextLabel = new Uint8Array([
              0, 1, 2, 0, 1, 2, 2, 0, 2, 2, 2, 0, 0, 0, 0, 0, 3, 4, 5, 0, 4, 5,
              5, 0, 5, 5, 5, 0, 0, 0, 0, 0, 6, 7, 7, 0, 7, 7, 7, 0, 7, 7, 7, 0,
              0, 0, 0, 0, 8, 8, 8, 0, 8, 8, 8, 0, 8, 8, 8, 0, 0, 0, 0, 0, 8, 8,
              8, 0, 8, 8, 8, 0, 8, 8, 8,
            ]);
            constructor(e, t, a, r, n) {
              this.width = e;
              this.height = t;
              let i;
              i =
                "HH" === a
                  ? BitModel.HHContextLabel
                  : "HL" === a
                    ? BitModel.HLContextLabel
                    : BitModel.LLAndLHContextsLabel;
              this.contextLabelTable = i;
              const s = e * t;
              this.neighborsSignificance = new Uint8Array(s);
              this.coefficentsSign = new Uint8Array(s);
              let o;
              o =
                n > 14
                  ? new Uint32Array(s)
                  : n > 6
                    ? new Uint16Array(s)
                    : new Uint8Array(s);
              this.coefficentsMagnitude = o;
              this.processingFlags = new Uint8Array(s);
              const c = new Uint8Array(s);
              if (0 !== r) for (let e = 0; e < s; e++) c[e] = r;
              this.bitsDecoded = c;
              this.reset();
            }
            setDecoder(e) {
              this.decoder = e;
            }
            reset() {
              this.contexts = new Int8Array(19);
              this.contexts[0] = 8;
              this.contexts[BitModel.UNIFORM_CONTEXT] = 92;
              this.contexts[BitModel.RUNLENGTH_CONTEXT] = 6;
            }
            setNeighborsSignificance(e, t, a) {
              const r = this.neighborsSignificance,
                n = this.width,
                i = this.height,
                s = t > 0,
                o = t + 1 < n;
              let c;
              if (e > 0) {
                c = a - n;
                s && (r[c - 1] += 16);
                o && (r[c + 1] += 16);
                r[c] += 4;
              }
              if (e + 1 < i) {
                c = a + n;
                s && (r[c - 1] += 16);
                o && (r[c + 1] += 16);
                r[c] += 4;
              }
              s && (r[a - 1] += 1);
              o && (r[a + 1] += 1);
              r[a] |= 128;
            }
            runSignificancePropagationPass() {
              const e = this.decoder,
                t = this.width,
                a = this.height,
                r = this.coefficentsMagnitude,
                n = this.coefficentsSign,
                i = this.neighborsSignificance,
                s = this.processingFlags,
                o = this.contexts,
                c = this.contextLabelTable,
                l = this.bitsDecoded;
              for (let h = 0; h < a; h += 4)
                for (let u = 0; u < t; u++) {
                  let d = h * t + u;
                  for (let f = 0; f < 4; f++, d += t) {
                    const t = h + f;
                    if (t >= a) break;
                    s[d] &= -2;
                    if (r[d] || !i[d]) continue;
                    const g = c[i[d]];
                    if (e.readBit(o, g)) {
                      const e = this.decodeSignBit(t, u, d);
                      n[d] = e;
                      r[d] = 1;
                      this.setNeighborsSignificance(t, u, d);
                      s[d] |= 2;
                    }
                    l[d]++;
                    s[d] |= 1;
                  }
                }
            }
            decodeSignBit(e, t, a) {
              const r = this.width,
                n = this.height,
                i = this.coefficentsMagnitude,
                s = this.coefficentsSign;
              let o, c, l, h, u, d;
              h = t > 0 && 0 !== i[a - 1];
              if (t + 1 < r && 0 !== i[a + 1]) {
                l = s[a + 1];
                if (h) {
                  c = s[a - 1];
                  o = 1 - l - c;
                } else o = 1 - l - l;
              } else if (h) {
                c = s[a - 1];
                o = 1 - c - c;
              } else o = 0;
              const f = 3 * o;
              h = e > 0 && 0 !== i[a - r];
              if (e + 1 < n && 0 !== i[a + r]) {
                l = s[a + r];
                if (h) {
                  c = s[a - r];
                  o = 1 - l - c + f;
                } else o = 1 - l - l + f;
              } else if (h) {
                c = s[a - r];
                o = 1 - c - c + f;
              } else o = f;
              if (o >= 0) {
                u = 9 + o;
                d = this.decoder.readBit(this.contexts, u);
              } else {
                u = 9 - o;
                d = 1 ^ this.decoder.readBit(this.contexts, u);
              }
              return d;
            }
            runMagnitudeRefinementPass() {
              const e = this.decoder,
                t = this.width,
                a = this.height,
                r = this.coefficentsMagnitude,
                n = this.neighborsSignificance,
                i = this.contexts,
                s = this.bitsDecoded,
                o = this.processingFlags,
                c = t * a,
                l = 4 * t;
              for (let a, h = 0; h < c; h = a) {
                a = Math.min(c, h + l);
                for (let c = 0; c < t; c++)
                  for (let l = h + c; l < a; l += t) {
                    if (!r[l] || 0 != (1 & o[l])) continue;
                    let t = 16;
                    if (0 != (2 & o[l])) {
                      o[l] ^= 2;
                      t = 0 === (127 & n[l]) ? 15 : 14;
                    }
                    const a = e.readBit(i, t);
                    r[l] = (r[l] << 1) | a;
                    s[l]++;
                    o[l] |= 1;
                  }
              }
            }
            runCleanupPass() {
              const e = this.decoder,
                t = this.width,
                a = this.height,
                r = this.neighborsSignificance,
                n = this.coefficentsMagnitude,
                i = this.coefficentsSign,
                s = this.contexts,
                o = this.contextLabelTable,
                c = this.bitsDecoded,
                l = this.processingFlags,
                h = t,
                u = 2 * t,
                d = 3 * t;
              let f;
              for (let g = 0; g < a; g = f) {
                f = Math.min(g + 4, a);
                const p = g * t,
                  m = g + 3 < a;
                for (let a = 0; a < t; a++) {
                  const b = p + a;
                  let y,
                    w = 0,
                    S = b,
                    x = g;
                  if (
                    m &&
                    0 === l[b] &&
                    0 === l[b + h] &&
                    0 === l[b + u] &&
                    0 === l[b + d] &&
                    0 === r[b] &&
                    0 === r[b + h] &&
                    0 === r[b + u] &&
                    0 === r[b + d]
                  ) {
                    if (!e.readBit(s, BitModel.RUNLENGTH_CONTEXT)) {
                      c[b]++;
                      c[b + h]++;
                      c[b + u]++;
                      c[b + d]++;
                      continue;
                    }
                    w =
                      (e.readBit(s, BitModel.UNIFORM_CONTEXT) << 1) |
                      e.readBit(s, BitModel.UNIFORM_CONTEXT);
                    if (0 !== w) {
                      x = g + w;
                      S += w * t;
                    }
                    y = this.decodeSignBit(x, a, S);
                    i[S] = y;
                    n[S] = 1;
                    this.setNeighborsSignificance(x, a, S);
                    l[S] |= 2;
                    S = b;
                    for (let e = g; e <= x; e++, S += t) c[S]++;
                    w++;
                  }
                  for (x = g + w; x < f; x++, S += t) {
                    if (n[S] || 0 != (1 & l[S])) continue;
                    const t = o[r[S]];
                    if (1 === e.readBit(s, t)) {
                      y = this.decodeSignBit(x, a, S);
                      i[S] = y;
                      n[S] = 1;
                      this.setNeighborsSignificance(x, a, S);
                      l[S] |= 2;
                    }
                    c[S]++;
                  }
                }
              }
            }
            checkSegmentationSymbol() {
              const e = this.decoder,
                t = this.contexts;
              if (
                10 !==
                ((e.readBit(t, BitModel.UNIFORM_CONTEXT) << 3) |
                  (e.readBit(t, BitModel.UNIFORM_CONTEXT) << 2) |
                  (e.readBit(t, BitModel.UNIFORM_CONTEXT) << 1) |
                  e.readBit(t, BitModel.UNIFORM_CONTEXT))
              )
                throw new JpxError("Invalid segmentation symbol");
            }
          }
          class Transform {
            constructor() {
              this.constructor === Transform &&
                (0, r.unreachable)("Cannot initialize Transform.");
            }
            calculate(e, t, a) {
              let r = e[0];
              for (let n = 1, i = e.length; n < i; n++)
                r = this.iterate(r, e[n], t, a);
              return r;
            }
            extend(e, t, a) {
              let r = t - 1,
                n = t + 1,
                i = t + a - 2,
                s = t + a;
              e[r--] = e[n++];
              e[s++] = e[i--];
              e[r--] = e[n++];
              e[s++] = e[i--];
              e[r--] = e[n++];
              e[s++] = e[i--];
              e[r] = e[n];
              e[s] = e[i];
            }
            filter(e, t, a) {
              (0, r.unreachable)("Abstract method `filter` called");
            }
            iterate(e, t, a, r) {
              const n = e.width,
                i = e.height;
              let s = e.items;
              const o = t.width,
                c = t.height,
                l = t.items;
              let h, u, d, f, g, p;
              for (d = 0, h = 0; h < i; h++) {
                f = 2 * h * o;
                for (u = 0; u < n; u++, d++, f += 2) l[f] = s[d];
              }
              s = e.items = null;
              const m = new Float32Array(o + 8);
              if (1 === o) {
                if (0 != (1 & a))
                  for (p = 0, d = 0; p < c; p++, d += o) l[d] *= 0.5;
              } else
                for (p = 0, d = 0; p < c; p++, d += o) {
                  m.set(l.subarray(d, d + o), 4);
                  this.extend(m, 4, o);
                  this.filter(m, 4, o);
                  l.set(m.subarray(4, 4 + o), d);
                }
              let b = 16;
              const y = [];
              for (h = 0; h < b; h++) y.push(new Float32Array(c + 8));
              let w,
                S = 0;
              e = 4 + c;
              if (1 === c) {
                if (0 != (1 & r)) for (g = 0; g < o; g++) l[g] *= 0.5;
              } else
                for (g = 0; g < o; g++) {
                  if (0 === S) {
                    b = Math.min(o - g, b);
                    for (d = g, f = 4; f < e; d += o, f++)
                      for (w = 0; w < b; w++) y[w][f] = l[d + w];
                    S = b;
                  }
                  S--;
                  const t = y[S];
                  this.extend(t, 4, c);
                  this.filter(t, 4, c);
                  if (0 === S) {
                    d = g - b + 1;
                    for (f = 4; f < e; d += o, f++)
                      for (w = 0; w < b; w++) l[d + w] = y[w][f];
                  }
                }
              return { width: o, height: c, items: l };
            }
          }
          class IrreversibleTransform extends Transform {
            filter(e, t, a) {
              const r = a >> 1;
              let n, i, s, o;
              const c = -1.586134342059924,
                l = -0.052980118572961,
                h = 0.882911075530934,
                u = 0.443506852043971,
                d = 1.230174104914001;
              n = (t |= 0) - 3;
              for (i = r + 4; i--; n += 2) e[n] *= 0.8128930661159609;
              n = t - 2;
              s = u * e[n - 1];
              for (i = r + 3; i--; n += 2) {
                o = u * e[n + 1];
                e[n] = d * e[n] - s - o;
                if (!i--) break;
                n += 2;
                s = u * e[n + 1];
                e[n] = d * e[n] - s - o;
              }
              n = t - 1;
              s = h * e[n - 1];
              for (i = r + 2; i--; n += 2) {
                o = h * e[n + 1];
                e[n] -= s + o;
                if (!i--) break;
                n += 2;
                s = h * e[n + 1];
                e[n] -= s + o;
              }
              n = t;
              s = l * e[n - 1];
              for (i = r + 1; i--; n += 2) {
                o = l * e[n + 1];
                e[n] -= s + o;
                if (!i--) break;
                n += 2;
                s = l * e[n + 1];
                e[n] -= s + o;
              }
              if (0 !== r) {
                n = t + 1;
                s = c * e[n - 1];
                for (i = r; i--; n += 2) {
                  o = c * e[n + 1];
                  e[n] -= s + o;
                  if (!i--) break;
                  n += 2;
                  s = c * e[n + 1];
                  e[n] -= s + o;
                }
              }
            }
          }
          class ReversibleTransform extends Transform {
            filter(e, t, a) {
              const r = a >> 1;
              let n, i;
              for (n = t |= 0, i = r + 1; i--; n += 2)
                e[n] -= (e[n - 1] + e[n + 1] + 2) >> 2;
              for (n = t + 1, i = r; i--; n += 2)
                e[n] += (e[n - 1] + e[n + 1]) >> 1;
            }
          }
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.LZWStream = void 0;
          var r = a(18);
          class LZWStream extends r.DecodeStream {
            constructor(e, t, a) {
              super(t);
              this.str = e;
              this.dict = e.dict;
              this.cachedData = 0;
              this.bitsCached = 0;
              const r = 4096,
                n = {
                  earlyChange: a,
                  codeLength: 9,
                  nextCode: 258,
                  dictionaryValues: new Uint8Array(r),
                  dictionaryLengths: new Uint16Array(r),
                  dictionaryPrevCodes: new Uint16Array(r),
                  currentSequence: new Uint8Array(r),
                  currentSequenceLength: 0,
                };
              for (let e = 0; e < 256; ++e) {
                n.dictionaryValues[e] = e;
                n.dictionaryLengths[e] = 1;
              }
              this.lzwState = n;
            }
            readBits(e) {
              let t = this.bitsCached,
                a = this.cachedData;
              for (; t < e; ) {
                const e = this.str.getByte();
                if (-1 === e) {
                  this.eof = !0;
                  return null;
                }
                a = (a << 8) | e;
                t += 8;
              }
              this.bitsCached = t -= e;
              this.cachedData = a;
              this.lastCode = null;
              return (a >>> t) & ((1 << e) - 1);
            }
            readBlock() {
              let e,
                t,
                a,
                r = 1024;
              const n = this.lzwState;
              if (!n) return;
              const i = n.earlyChange;
              let s = n.nextCode;
              const o = n.dictionaryValues,
                c = n.dictionaryLengths,
                l = n.dictionaryPrevCodes;
              let h = n.codeLength,
                u = n.prevCode;
              const d = n.currentSequence;
              let f = n.currentSequenceLength,
                g = 0,
                p = this.bufferLength,
                m = this.ensureBuffer(this.bufferLength + r);
              for (e = 0; e < 512; e++) {
                const e = this.readBits(h),
                  n = f > 0;
                if (e < 256) {
                  d[0] = e;
                  f = 1;
                } else {
                  if (!(e >= 258)) {
                    if (256 === e) {
                      h = 9;
                      s = 258;
                      f = 0;
                      continue;
                    }
                    this.eof = !0;
                    delete this.lzwState;
                    break;
                  }
                  if (e < s) {
                    f = c[e];
                    for (t = f - 1, a = e; t >= 0; t--) {
                      d[t] = o[a];
                      a = l[a];
                    }
                  } else d[f++] = d[0];
                }
                if (n) {
                  l[s] = u;
                  c[s] = c[u] + 1;
                  o[s] = d[0];
                  s++;
                  h =
                    (s + i) & (s + i - 1)
                      ? h
                      : 0 |
                        Math.min(Math.log(s + i) / 0.6931471805599453 + 1, 12);
                }
                u = e;
                g += f;
                if (r < g) {
                  do {
                    r += 512;
                  } while (r < g);
                  m = this.ensureBuffer(this.bufferLength + r);
                }
                for (t = 0; t < f; t++) m[p++] = d[t];
              }
              n.nextCode = s;
              n.codeLength = h;
              n.prevCode = u;
              n.currentSequenceLength = f;
              this.bufferLength = p;
            }
          }
          t.LZWStream = LZWStream;
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.PredictorStream = void 0;
          var r = a(18),
            n = a(4),
            i = a(2);
          class PredictorStream extends r.DecodeStream {
            constructor(e, t, a) {
              super(t);
              if (!(a instanceof n.Dict)) return e;
              const r = (this.predictor = a.get("Predictor") || 1);
              if (r <= 1) return e;
              if (2 !== r && (r < 10 || r > 15))
                throw new i.FormatError(`Unsupported predictor: ${r}`);
              this.readBlock = 2 === r ? this.readBlockTiff : this.readBlockPng;
              this.str = e;
              this.dict = e.dict;
              const s = (this.colors = a.get("Colors") || 1),
                o = (this.bits = a.get("BPC", "BitsPerComponent") || 8),
                c = (this.columns = a.get("Columns") || 1);
              this.pixBytes = (s * o + 7) >> 3;
              this.rowBytes = (c * s * o + 7) >> 3;
              return this;
            }
            readBlockTiff() {
              const e = this.rowBytes,
                t = this.bufferLength,
                a = this.ensureBuffer(t + e),
                r = this.bits,
                n = this.colors,
                i = this.str.getBytes(e);
              this.eof = !i.length;
              if (this.eof) return;
              let s,
                o = 0,
                c = 0,
                l = 0,
                h = 0,
                u = t;
              if (1 === r && 1 === n)
                for (s = 0; s < e; ++s) {
                  let e = i[s] ^ o;
                  e ^= e >> 1;
                  e ^= e >> 2;
                  e ^= e >> 4;
                  o = (1 & e) << 7;
                  a[u++] = e;
                }
              else if (8 === r) {
                for (s = 0; s < n; ++s) a[u++] = i[s];
                for (; s < e; ++s) {
                  a[u] = a[u - n] + i[s];
                  u++;
                }
              } else if (16 === r) {
                const t = 2 * n;
                for (s = 0; s < t; ++s) a[u++] = i[s];
                for (; s < e; s += 2) {
                  const e =
                    ((255 & i[s]) << 8) +
                    (255 & i[s + 1]) +
                    ((255 & a[u - t]) << 8) +
                    (255 & a[u - t + 1]);
                  a[u++] = (e >> 8) & 255;
                  a[u++] = 255 & e;
                }
              } else {
                const e = new Uint8Array(n + 1),
                  u = (1 << r) - 1;
                let d = 0,
                  f = t;
                const g = this.columns;
                for (s = 0; s < g; ++s)
                  for (let t = 0; t < n; ++t) {
                    if (l < r) {
                      o = (o << 8) | (255 & i[d++]);
                      l += 8;
                    }
                    e[t] = (e[t] + (o >> (l - r))) & u;
                    l -= r;
                    c = (c << r) | e[t];
                    h += r;
                    if (h >= 8) {
                      a[f++] = (c >> (h - 8)) & 255;
                      h -= 8;
                    }
                  }
                h > 0 && (a[f++] = (c << (8 - h)) + (o & ((1 << (8 - h)) - 1)));
              }
              this.bufferLength += e;
            }
            readBlockPng() {
              const e = this.rowBytes,
                t = this.pixBytes,
                a = this.str.getByte(),
                r = this.str.getBytes(e);
              this.eof = !r.length;
              if (this.eof) return;
              const n = this.bufferLength,
                s = this.ensureBuffer(n + e);
              let o = s.subarray(n - e, n);
              0 === o.length && (o = new Uint8Array(e));
              let c,
                l,
                h,
                u = n;
              switch (a) {
                case 0:
                  for (c = 0; c < e; ++c) s[u++] = r[c];
                  break;
                case 1:
                  for (c = 0; c < t; ++c) s[u++] = r[c];
                  for (; c < e; ++c) {
                    s[u] = (s[u - t] + r[c]) & 255;
                    u++;
                  }
                  break;
                case 2:
                  for (c = 0; c < e; ++c) s[u++] = (o[c] + r[c]) & 255;
                  break;
                case 3:
                  for (c = 0; c < t; ++c) s[u++] = (o[c] >> 1) + r[c];
                  for (; c < e; ++c) {
                    s[u] = (((o[c] + s[u - t]) >> 1) + r[c]) & 255;
                    u++;
                  }
                  break;
                case 4:
                  for (c = 0; c < t; ++c) {
                    l = o[c];
                    h = r[c];
                    s[u++] = l + h;
                  }
                  for (; c < e; ++c) {
                    l = o[c];
                    const e = o[c - t],
                      a = s[u - t],
                      n = a + l - e;
                    let i = n - a;
                    i < 0 && (i = -i);
                    let d = n - l;
                    d < 0 && (d = -d);
                    let f = n - e;
                    f < 0 && (f = -f);
                    h = r[c];
                    s[u++] = i <= d && i <= f ? a + h : d <= f ? l + h : e + h;
                  }
                  break;
                default:
                  throw new i.FormatError(`Unsupported predictor: ${a}`);
              }
              this.bufferLength += e;
            }
          }
          t.PredictorStream = PredictorStream;
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.RunLengthStream = void 0;
          var r = a(18);
          class RunLengthStream extends r.DecodeStream {
            constructor(e, t) {
              super(t);
              this.str = e;
              this.dict = e.dict;
            }
            readBlock() {
              const e = this.str.getBytes(2);
              if (!e || e.length < 2 || 128 === e[0]) {
                this.eof = !0;
                return;
              }
              let t,
                a = this.bufferLength,
                r = e[0];
              if (r < 128) {
                t = this.ensureBuffer(a + r + 1);
                t[a++] = e[1];
                if (r > 0) {
                  const e = this.str.getBytes(r);
                  t.set(e, a);
                  a += r;
                }
              } else {
                r = 257 - r;
                const n = e[1];
                t = this.ensureBuffer(a + r + 1);
                for (let e = 0; e < r; e++) t[a++] = n;
              }
              this.bufferLength = a;
            }
          }
          t.RunLengthStream = RunLengthStream;
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.Font = t.ErrorFont = void 0;
          var r = a(2),
            n = a(35),
            i = a(38),
            s = a(40),
            o = a(39),
            c = a(37),
            l = a(41),
            h = a(42),
            u = a(43),
            d = a(44),
            f = a(45),
            g = a(46),
            p = a(14),
            m = a(47),
            b = a(3),
            y = a(8),
            w = a(48);
          const S = [
              [57344, 63743],
              [1048576, 1114109],
            ],
            x = 1e3,
            C = [
              "ascent",
              "bbox",
              "black",
              "bold",
              "charProcOperatorList",
              "composite",
              "cssFontInfo",
              "data",
              "defaultVMetrics",
              "defaultWidth",
              "descent",
              "fallbackName",
              "fontMatrix",
              "isInvalidPDFjsFont",
              "isType3Font",
              "italic",
              "loadedName",
              "mimetype",
              "missingFile",
              "name",
              "remeasure",
              "subtype",
              "systemFontInfo",
              "type",
              "vertical",
            ],
            k = [
              "cMap",
              "defaultEncoding",
              "differences",
              "isMonospace",
              "isSerifFont",
              "isSymbolicFont",
              "seacMap",
              "toFontChar",
              "toUnicode",
              "vmetrics",
              "widths",
            ];
          function adjustWidths(e) {
            if (!e.fontMatrix) return;
            if (e.fontMatrix[0] === r.FONT_IDENTITY_MATRIX[0]) return;
            const t = 0.001 / e.fontMatrix[0],
              a = e.widths;
            for (const e in a) a[e] *= t;
            e.defaultWidth *= t;
          }
          function amendFallbackToUnicode(e) {
            if (!e.fallbackToUnicode) return;
            if (e.toUnicode instanceof h.IdentityToUnicodeMap) return;
            const t = [];
            for (const a in e.fallbackToUnicode)
              e.toUnicode.has(a) || (t[a] = e.fallbackToUnicode[a]);
            t.length > 0 && e.toUnicode.amend(t);
          }
          class Glyph {
            constructor(e, t, a, r, n, i, s, o, c) {
              this.originalCharCode = e;
              this.fontChar = t;
              this.unicode = a;
              this.accent = r;
              this.width = n;
              this.vmetric = i;
              this.operatorListId = s;
              this.isSpace = o;
              this.isInFont = c;
            }
            get category() {
              return (0, r.shadow)(
                this,
                "category",
                (0, s.getCharUnicodeCategory)(this.unicode),
                !0,
              );
            }
          }
          function int16(e, t) {
            return (e << 8) + t;
          }
          function writeSignedInt16(e, t, a) {
            e[t + 1] = a;
            e[t] = a >>> 8;
          }
          function signedInt16(e, t) {
            const a = (e << 8) + t;
            return 32768 & a ? a - 65536 : a;
          }
          function string16(e) {
            return String.fromCharCode((e >> 8) & 255, 255 & e);
          }
          function safeString16(e) {
            e > 32767 ? (e = 32767) : e < -32768 && (e = -32768);
            return String.fromCharCode((e >> 8) & 255, 255 & e);
          }
          function isTrueTypeCollectionFile(e) {
            const t = e.peekBytes(4);
            return "ttcf" === (0, r.bytesToString)(t);
          }
          function getFontFileType(e, { type: t, subtype: a, composite: n }) {
            let i, s;
            if (
              (function isTrueTypeFile(e) {
                const t = e.peekBytes(4);
                return (
                  65536 === (0, b.readUint32)(t, 0) ||
                  "true" === (0, r.bytesToString)(t)
                );
              })(e) ||
              isTrueTypeCollectionFile(e)
            )
              i = n ? "CIDFontType2" : "TrueType";
            else if (
              (function isOpenTypeFile(e) {
                const t = e.peekBytes(4);
                return "OTTO" === (0, r.bytesToString)(t);
              })(e)
            )
              i = n ? "CIDFontType2" : "OpenType";
            else if (
              (function isType1File(e) {
                const t = e.peekBytes(2);
                return (
                  (37 === t[0] && 33 === t[1]) || (128 === t[0] && 1 === t[1])
                );
              })(e)
            )
              i = n ? "CIDFontType0" : "MMType1" === t ? "MMType1" : "Type1";
            else if (
              (function isCFFFile(e) {
                const t = e.peekBytes(4);
                return t[0] >= 1 && t[3] >= 1 && t[3] <= 4;
              })(e)
            )
              if (n) {
                i = "CIDFontType0";
                s = "CIDFontType0C";
              } else {
                i = "MMType1" === t ? "MMType1" : "Type1";
                s = "Type1C";
              }
            else {
              (0, r.warn)(
                "getFontFileType: Unable to detect correct font file Type/Subtype.",
              );
              i = t;
              s = a;
            }
            return [i, s];
          }
          function applyStandardFontGlyphMap(e, t) {
            for (const a in t) e[+a] = t[a];
          }
          function buildToFontChar(e, t, a) {
            const r = [];
            let n;
            for (let a = 0, i = e.length; a < i; a++) {
              n = (0, s.getUnicodeForGlyph)(e[a], t);
              -1 !== n && (r[a] = n);
            }
            for (const e in a) {
              n = (0, s.getUnicodeForGlyph)(a[e], t);
              -1 !== n && (r[+e] = n);
            }
            return r;
          }
          function isMacNameRecord(e) {
            return 1 === e.platform && 0 === e.encoding && 0 === e.language;
          }
          function isWinNameRecord(e) {
            return 3 === e.platform && 1 === e.encoding && 1033 === e.language;
          }
          function convertCidString(e, t, a = !1) {
            switch (t.length) {
              case 1:
                return t.charCodeAt(0);
              case 2:
                return (t.charCodeAt(0) << 8) | t.charCodeAt(1);
            }
            const n = `Unsupported CID string (charCode ${e}): "${t}".`;
            if (a) throw new r.FormatError(n);
            (0, r.warn)(n);
            return t;
          }
          function adjustMapping(e, t, a, n) {
            const i = Object.create(null),
              s = new Map(),
              o = [],
              c = new Set();
            let l = 0;
            let h = S[l][0],
              u = S[l][1];
            for (let f in e) {
              f |= 0;
              let g = e[f];
              if (!t(g)) continue;
              if (h > u) {
                l++;
                if (l >= S.length) {
                  (0, r.warn)("Ran out of space in font private use area.");
                  break;
                }
                h = S[l][0];
                u = S[l][1];
              }
              const p = h++;
              0 === g && (g = a);
              let m = n.get(f);
              "string" == typeof m && (m = m.codePointAt(0));
              if (
                m &&
                !((d = m),
                (S[0][0] <= d && d <= S[0][1]) ||
                  (S[1][0] <= d && d <= S[1][1])) &&
                !c.has(g)
              ) {
                s.set(m, g);
                c.add(g);
              }
              i[p] = g;
              o[f] = p;
            }
            var d;
            return {
              toFontChar: o,
              charCodeToGlyphId: i,
              toUnicodeExtraMap: s,
              nextAvailableFontCharCode: h,
            };
          }
          function createCmapTable(e, t, a) {
            const n = (function getRanges(e, t, a) {
                const r = [];
                for (const t in e)
                  e[t] >= a || r.push({ fontCharCode: 0 | t, glyphId: e[t] });
                if (t)
                  for (const [e, n] of t)
                    n >= a || r.push({ fontCharCode: e, glyphId: n });
                0 === r.length && r.push({ fontCharCode: 0, glyphId: 0 });
                r.sort(function fontGetRangesSort(e, t) {
                  return e.fontCharCode - t.fontCharCode;
                });
                const n = [],
                  i = r.length;
                for (let e = 0; e < i; ) {
                  const t = r[e].fontCharCode,
                    a = [r[e].glyphId];
                  ++e;
                  let s = t;
                  for (; e < i && s + 1 === r[e].fontCharCode; ) {
                    a.push(r[e].glyphId);
                    ++s;
                    ++e;
                    if (65535 === s) break;
                  }
                  n.push([t, s, a]);
                }
                return n;
              })(e, t, a),
              i = n.at(-1)[1] > 65535 ? 2 : 1;
            let s,
              o,
              c,
              l,
              h = "\0\0" + string16(i) + "\0\0" + (0, r.string32)(4 + 8 * i);
            for (s = n.length - 1; s >= 0 && !(n[s][0] <= 65535); --s);
            const u = s + 1;
            n[s][0] < 65535 && 65535 === n[s][1] && (n[s][1] = 65534);
            const d = n[s][1] < 65535 ? 1 : 0,
              f = u + d,
              g = m.OpenTypeFileBuilder.getSearchParams(f, 2);
            let p,
              b,
              y,
              w,
              S = "",
              x = "",
              C = "",
              k = "",
              v = "",
              F = 0;
            for (s = 0, o = u; s < o; s++) {
              p = n[s];
              b = p[0];
              y = p[1];
              S += string16(b);
              x += string16(y);
              w = p[2];
              let e = !0;
              for (c = 1, l = w.length; c < l; ++c)
                if (w[c] !== w[c - 1] + 1) {
                  e = !1;
                  break;
                }
              if (e) {
                C += string16((w[0] - b) & 65535);
                k += string16(0);
              } else {
                const e = 2 * (f - s) + 2 * F;
                F += y - b + 1;
                C += string16(0);
                k += string16(e);
                for (c = 0, l = w.length; c < l; ++c) v += string16(w[c]);
              }
            }
            if (d > 0) {
              x += "ÿÿ";
              S += "ÿÿ";
              C += "\0";
              k += "\0\0";
            }
            const O =
              "\0\0" +
              string16(2 * f) +
              string16(g.range) +
              string16(g.entry) +
              string16(g.rangeShift) +
              x +
              "\0\0" +
              S +
              C +
              k +
              v;
            let T = "",
              M = "";
            if (i > 1) {
              h += "\0\0\n" + (0, r.string32)(4 + 8 * i + 4 + O.length);
              T = "";
              for (s = 0, o = n.length; s < o; s++) {
                p = n[s];
                b = p[0];
                w = p[2];
                let e = w[0];
                for (c = 1, l = w.length; c < l; ++c)
                  if (w[c] !== w[c - 1] + 1) {
                    y = p[0] + c - 1;
                    T +=
                      (0, r.string32)(b) +
                      (0, r.string32)(y) +
                      (0, r.string32)(e);
                    b = y + 1;
                    e = w[c];
                  }
                T +=
                  (0, r.string32)(b) +
                  (0, r.string32)(p[1]) +
                  (0, r.string32)(e);
              }
              M =
                "\0\f\0\0" +
                (0, r.string32)(T.length + 16) +
                "\0\0\0\0" +
                (0, r.string32)(T.length / 12);
            }
            return h + "\0" + string16(O.length + 4) + O + M + T;
          }
          function createOS2Table(e, t, a) {
            a ||= { unitsPerEm: 0, yMax: 0, yMin: 0, ascent: 0, descent: 0 };
            let n = 0,
              i = 0,
              o = 0,
              c = 0,
              l = null,
              h = 0,
              u = -1;
            if (t) {
              for (let e in t) {
                e |= 0;
                (l > e || !l) && (l = e);
                h < e && (h = e);
                u = (0, s.getUnicodeRangeFor)(e, u);
                if (u < 32) n |= 1 << u;
                else if (u < 64) i |= 1 << (u - 32);
                else if (u < 96) o |= 1 << (u - 64);
                else {
                  if (!(u < 123))
                    throw new r.FormatError(
                      "Unicode ranges Bits > 123 are reserved for internal usage",
                    );
                  c |= 1 << (u - 96);
                }
              }
              h > 65535 && (h = 65535);
            } else {
              l = 0;
              h = 255;
            }
            const d = e.bbox || [0, 0, 0, 0],
              f =
                a.unitsPerEm || 1 / (e.fontMatrix || r.FONT_IDENTITY_MATRIX)[0],
              g = e.ascentScaled ? 1 : f / x,
              p = a.ascent || Math.round(g * (e.ascent || d[3]));
            let m = a.descent || Math.round(g * (e.descent || d[1]));
            m > 0 && e.descent > 0 && d[1] < 0 && (m = -m);
            const b = a.yMax || p,
              y = -a.yMin || -m;
            return (
              "\0$ô\0\0\0»\0\0\0»\0\0ß\x001\0\0\0\0" +
              String.fromCharCode(e.fixedPitch ? 9 : 0) +
              "\0\0\0\0\0\0" +
              (0, r.string32)(n) +
              (0, r.string32)(i) +
              (0, r.string32)(o) +
              (0, r.string32)(c) +
              "*21*" +
              string16(e.italicAngle ? 1 : 0) +
              string16(l || e.firstChar) +
              string16(h || e.lastChar) +
              string16(p) +
              string16(m) +
              "\0d" +
              string16(b) +
              string16(y) +
              "\0\0\0\0\0\0\0\0" +
              string16(e.xHeight) +
              string16(e.capHeight) +
              string16(0) +
              string16(l || e.firstChar) +
              "\0"
            );
          }
          function createPostTable(e) {
            const t = Math.floor(65536 * e.italicAngle);
            return (
              "\0\0\0" +
              (0, r.string32)(t) +
              "\0\0\0\0" +
              (0, r.string32)(e.fixedPitch ? 1 : 0) +
              "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
            );
          }
          function createPostscriptName(e) {
            return e.replaceAll(/[^\x21-\x7E]|[[\](){}<>/%]/g, "").slice(0, 63);
          }
          function createNameTable(e, t) {
            t || (t = [[], []]);
            const a = [
                t[0][0] || "Original licence",
                t[0][1] || e,
                t[0][2] || "Unknown",
                t[0][3] || "uniqueID",
                t[0][4] || e,
                t[0][5] || "Version 0.11",
                t[0][6] || createPostscriptName(e),
                t[0][7] || "Unknown",
                t[0][8] || "Unknown",
                t[0][9] || "Unknown",
              ],
              r = [];
            let n, i, s, o, c;
            for (n = 0, i = a.length; n < i; n++) {
              c = t[1][n] || a[n];
              const e = [];
              for (s = 0, o = c.length; s < o; s++)
                e.push(string16(c.charCodeAt(s)));
              r.push(e.join(""));
            }
            const l = [a, r],
              h = ["\0", "\0"],
              u = ["\0\0", "\0"],
              d = ["\0\0", "\t"],
              f = a.length * h.length;
            let g = "\0\0" + string16(f) + string16(12 * f + 6),
              p = 0;
            for (n = 0, i = h.length; n < i; n++) {
              const e = l[n];
              for (s = 0, o = e.length; s < o; s++) {
                c = e[s];
                g +=
                  h[n] +
                  u[n] +
                  d[n] +
                  string16(s) +
                  string16(c.length) +
                  string16(p);
                p += c.length;
              }
            }
            g += a.join("") + r.join("");
            return g;
          }
          t.Font = class Font {
            constructor(e, t, a) {
              this.name = e;
              this.psName = null;
              this.mimetype = null;
              this.disableFontFace = !1;
              this.loadedName = a.loadedName;
              this.isType3Font = a.isType3Font;
              this.missingFile = !1;
              this.cssFontInfo = a.cssFontInfo;
              this._charsCache = Object.create(null);
              this._glyphCache = Object.create(null);
              let n = !!(a.flags & i.FontFlags.Serif);
              if (!n && !a.isSimulatedFlags) {
                const t = e.replaceAll(/[,_]/g, "-").split("-")[0],
                  a = (0, l.getSerifFonts)();
                for (const e of t.split("+"))
                  if (a[e]) {
                    n = !0;
                    break;
                  }
              }
              this.isSerifFont = n;
              this.isSymbolicFont = !!(a.flags & i.FontFlags.Symbolic);
              this.isMonospace = !!(a.flags & i.FontFlags.FixedPitch);
              let { type: s, subtype: o } = a;
              this.type = s;
              this.subtype = o;
              this.systemFontInfo = a.systemFontInfo;
              const c = e.match(/^InvalidPDFjsFont_(.*)_\d+$/);
              this.isInvalidPDFjsFont = !!c;
              this.isInvalidPDFjsFont
                ? (this.fallbackName = c[1])
                : this.isMonospace
                  ? (this.fallbackName = "monospace")
                  : this.isSerifFont
                    ? (this.fallbackName = "serif")
                    : (this.fallbackName = "sans-serif");
              if (this.systemFontInfo?.guessFallback) {
                this.systemFontInfo.guessFallback = !1;
                this.systemFontInfo.css += `,${this.fallbackName}`;
              }
              this.differences = a.differences;
              this.widths = a.widths;
              this.defaultWidth = a.defaultWidth;
              this.composite = a.composite;
              this.cMap = a.cMap;
              this.capHeight = a.capHeight / x;
              this.ascent = a.ascent / x;
              this.descent = a.descent / x;
              this.lineHeight = this.ascent - this.descent;
              this.fontMatrix = a.fontMatrix;
              this.bbox = a.bbox;
              this.defaultEncoding = a.defaultEncoding;
              this.toUnicode = a.toUnicode;
              this.toFontChar = [];
              if ("Type3" === a.type) {
                for (let e = 0; e < 256; e++)
                  this.toFontChar[e] =
                    this.differences[e] || a.defaultEncoding[e];
                return;
              }
              this.cidEncoding = a.cidEncoding || "";
              this.vertical = !!a.vertical;
              if (this.vertical) {
                this.vmetrics = a.vmetrics;
                this.defaultVMetrics = a.defaultVMetrics;
              }
              if (!t || t.isEmpty) {
                t &&
                  (0, r.warn)(
                    'Font file is empty in "' +
                      e +
                      '" (' +
                      this.loadedName +
                      ")",
                  );
                this.fallbackToSystemFont(a);
                return;
              }
              [s, o] = getFontFileType(t, a);
              (s === this.type && o === this.subtype) ||
                (0, r.info)(
                  `Inconsistent font file Type/SubType, expected: ${this.type}/${this.subtype} but found: ${s}/${o}.`,
                );
              let h;
              try {
                switch (s) {
                  case "MMType1":
                    (0, r.info)(
                      "MMType1 font (" + e + "), falling back to Type1.",
                    );
                  case "Type1":
                  case "CIDFontType0":
                    this.mimetype = "font/opentype";
                    const n =
                      "Type1C" === o || "CIDFontType0C" === o
                        ? new u.CFFFont(t, a)
                        : new w.Type1Font(e, t, a);
                    adjustWidths(a);
                    h = this.convert(e, n, a);
                    break;
                  case "OpenType":
                  case "TrueType":
                  case "CIDFontType2":
                    this.mimetype = "font/opentype";
                    h = this.checkAndRepair(e, t, a);
                    if (this.isOpenType) {
                      adjustWidths(a);
                      s = "OpenType";
                    }
                    break;
                  default:
                    throw new r.FormatError(`Font ${s} is not supported`);
                }
              } catch (e) {
                (0, r.warn)(e);
                this.fallbackToSystemFont(a);
                return;
              }
              amendFallbackToUnicode(a);
              this.data = h;
              this.type = s;
              this.subtype = o;
              this.fontMatrix = a.fontMatrix;
              this.widths = a.widths;
              this.defaultWidth = a.defaultWidth;
              this.toUnicode = a.toUnicode;
              this.seacMap = a.seacMap;
            }
            get renderer() {
              const e = d.FontRendererFactory.create(
                this,
                i.SEAC_ANALYSIS_ENABLED,
              );
              return (0, r.shadow)(this, "renderer", e);
            }
            exportData(e = !1) {
              const t = e ? [...C, ...k] : C,
                a = Object.create(null);
              let r, n;
              for (r of t) {
                n = this[r];
                void 0 !== n && (a[r] = n);
              }
              return a;
            }
            fallbackToSystemFont(e) {
              this.missingFile = !0;
              const { name: t, type: a } = this;
              let r = (0, i.normalizeFontName)(t);
              const n = (0, l.getStdFontMap)(),
                u = (0, l.getNonStdFontMap)(),
                d = !!n[r],
                g = !(!u[r] || !n[u[r]]);
              r = n[r] || u[r] || r;
              const p = (0, f.getFontBasicMetrics)()[r];
              if (p) {
                isNaN(this.ascent) && (this.ascent = p.ascent / x);
                isNaN(this.descent) && (this.descent = p.descent / x);
                isNaN(this.capHeight) && (this.capHeight = p.capHeight / x);
              }
              this.bold = /bold/gi.test(r);
              this.italic = /oblique|italic/gi.test(r);
              this.black = /Black/g.test(t);
              const m = /Narrow/g.test(t);
              this.remeasure = (!d || m) && Object.keys(this.widths).length > 0;
              if (
                (d || g) &&
                "CIDFontType2" === a &&
                this.cidEncoding.startsWith("Identity-")
              ) {
                const a = e.cidToGidMap,
                  r = [];
                applyStandardFontGlyphMap(
                  r,
                  (0, l.getGlyphMapForStandardFonts)(),
                );
                /Arial-?Black/i.test(t)
                  ? applyStandardFontGlyphMap(
                      r,
                      (0, l.getSupplementalGlyphMapForArialBlack)(),
                    )
                  : /Calibri/i.test(t) &&
                    applyStandardFontGlyphMap(
                      r,
                      (0, l.getSupplementalGlyphMapForCalibri)(),
                    );
                if (a) {
                  for (const e in r) {
                    const t = r[e];
                    void 0 !== a[t] && (r[+e] = a[t]);
                  }
                  a.length !== this.toUnicode.length &&
                    e.hasIncludedToUnicodeMap &&
                    this.toUnicode instanceof h.IdentityToUnicodeMap &&
                    this.toUnicode.forEach(function (e, t) {
                      const n = r[e];
                      void 0 === a[n] && (r[+e] = t);
                    });
                }
                this.toUnicode instanceof h.IdentityToUnicodeMap ||
                  this.toUnicode.forEach(function (e, t) {
                    r[+e] = t;
                  });
                this.toFontChar = r;
                this.toUnicode = new h.ToUnicodeMap(r);
              } else if (/Symbol/i.test(r))
                this.toFontChar = buildToFontChar(
                  c.SymbolSetEncoding,
                  (0, o.getGlyphsUnicode)(),
                  this.differences,
                );
              else if (/Dingbats/i.test(r))
                this.toFontChar = buildToFontChar(
                  c.ZapfDingbatsEncoding,
                  (0, o.getDingbatsGlyphsUnicode)(),
                  this.differences,
                );
              else if (d) {
                const e = buildToFontChar(
                  this.defaultEncoding,
                  (0, o.getGlyphsUnicode)(),
                  this.differences,
                );
                "CIDFontType2" !== a ||
                  this.cidEncoding.startsWith("Identity-") ||
                  this.toUnicode instanceof h.IdentityToUnicodeMap ||
                  this.toUnicode.forEach(function (t, a) {
                    e[+t] = a;
                  });
                this.toFontChar = e;
              } else {
                const e = (0, o.getGlyphsUnicode)(),
                  a = [];
                this.toUnicode.forEach((t, r) => {
                  if (!this.composite) {
                    const a = this.differences[t] || this.defaultEncoding[t],
                      n = (0, s.getUnicodeForGlyph)(a, e);
                    -1 !== n && (r = n);
                  }
                  a[+t] = r;
                });
                this.composite &&
                  this.toUnicode instanceof h.IdentityToUnicodeMap &&
                  /Tahoma|Verdana/i.test(t) &&
                  applyStandardFontGlyphMap(
                    a,
                    (0, l.getGlyphMapForStandardFonts)(),
                  );
                this.toFontChar = a;
              }
              amendFallbackToUnicode(e);
              this.loadedName = r.split("-")[0];
            }
            checkAndRepair(e, t, a) {
              const s = [
                "OS/2",
                "cmap",
                "head",
                "hhea",
                "hmtx",
                "maxp",
                "name",
                "post",
                "loca",
                "glyf",
                "fpgm",
                "prep",
                "cvt ",
                "CFF ",
              ];
              function readTables(e, t) {
                const a = Object.create(null);
                a["OS/2"] = null;
                a.cmap = null;
                a.head = null;
                a.hhea = null;
                a.hmtx = null;
                a.maxp = null;
                a.name = null;
                a.post = null;
                for (let r = 0; r < t; r++) {
                  const t = readTableEntry(e);
                  s.includes(t.tag) && 0 !== t.length && (a[t.tag] = t);
                }
                return a;
              }
              function readTableEntry(e) {
                const t = e.getString(4),
                  a = e.getInt32() >>> 0,
                  r = e.getInt32() >>> 0,
                  n = e.getInt32() >>> 0,
                  i = e.pos;
                e.pos = e.start || 0;
                e.skip(r);
                const s = e.getBytes(n);
                e.pos = i;
                if ("head" === t) {
                  s[8] = s[9] = s[10] = s[11] = 0;
                  s[17] |= 32;
                }
                return { tag: t, checksum: a, length: n, offset: r, data: s };
              }
              function readOpenTypeHeader(e) {
                return {
                  version: e.getString(4),
                  numTables: e.getUint16(),
                  searchRange: e.getUint16(),
                  entrySelector: e.getUint16(),
                  rangeShift: e.getUint16(),
                };
              }
              function sanitizeGlyph(e, t, a, r, n, i) {
                const s = { length: 0, sizeOfInstructions: 0 };
                if (t < 0 || t >= e.length || a > e.length || a - t <= 12)
                  return s;
                const o = e.subarray(t, a),
                  c = signedInt16(o[2], o[3]),
                  l = signedInt16(o[4], o[5]),
                  h = signedInt16(o[6], o[7]),
                  u = signedInt16(o[8], o[9]);
                if (c > h) {
                  writeSignedInt16(o, 2, h);
                  writeSignedInt16(o, 6, c);
                }
                if (l > u) {
                  writeSignedInt16(o, 4, u);
                  writeSignedInt16(o, 8, l);
                }
                const d = signedInt16(o[0], o[1]);
                if (d < 0) {
                  if (d < -1) return s;
                  r.set(o, n);
                  s.length = o.length;
                  return s;
                }
                let f,
                  g = 10,
                  p = 0;
                for (f = 0; f < d; f++) {
                  p = ((o[g] << 8) | o[g + 1]) + 1;
                  g += 2;
                }
                const m = g,
                  b = (o[g] << 8) | o[g + 1];
                s.sizeOfInstructions = b;
                g += 2 + b;
                const y = g;
                let w = 0;
                for (f = 0; f < p; f++) {
                  const e = o[g++];
                  192 & e && (o[g - 1] = 63 & e);
                  let t = 2;
                  2 & e ? (t = 1) : 16 & e && (t = 0);
                  let a = 2;
                  4 & e ? (a = 1) : 32 & e && (a = 0);
                  const r = t + a;
                  w += r;
                  if (8 & e) {
                    const e = o[g++];
                    0 === e && (o[g - 1] ^= 8);
                    f += e;
                    w += e * r;
                  }
                }
                if (0 === w) return s;
                let S = g + w;
                if (S > o.length) return s;
                if (!i && b > 0) {
                  r.set(o.subarray(0, m), n);
                  r.set([0, 0], n + m);
                  r.set(o.subarray(y, S), n + m + 2);
                  S -= b;
                  o.length - S > 3 && (S = (S + 3) & -4);
                  s.length = S;
                  return s;
                }
                if (o.length - S > 3) {
                  S = (S + 3) & -4;
                  r.set(o.subarray(0, S), n);
                  s.length = S;
                  return s;
                }
                r.set(o, n);
                s.length = o.length;
                return s;
              }
              function readNameTable(e) {
                const a = (t.start || 0) + e.offset;
                t.pos = a;
                const r = [[], []],
                  n = [],
                  i = e.length,
                  s = a + i;
                if (0 !== t.getUint16() || i < 6) return [r, n];
                const o = t.getUint16(),
                  c = t.getUint16();
                let l, h;
                for (l = 0; l < o && t.pos + 12 <= s; l++) {
                  const e = {
                    platform: t.getUint16(),
                    encoding: t.getUint16(),
                    language: t.getUint16(),
                    name: t.getUint16(),
                    length: t.getUint16(),
                    offset: t.getUint16(),
                  };
                  (isMacNameRecord(e) || isWinNameRecord(e)) && n.push(e);
                }
                for (l = 0, h = n.length; l < h; l++) {
                  const e = n[l];
                  if (e.length <= 0) continue;
                  const i = a + c + e.offset;
                  if (i + e.length > s) continue;
                  t.pos = i;
                  const o = e.name;
                  if (e.encoding) {
                    let a = "";
                    for (let r = 0, n = e.length; r < n; r += 2)
                      a += String.fromCharCode(t.getUint16());
                    r[1][o] = a;
                  } else r[0][o] = t.getString(e.length);
                }
                return [r, n];
              }
              const l = [
                0, 0, 0, 0, 0, 0, 0, 0, -2, -2, -2, -2, 0, 0, -2, -5, -1, -1,
                -1, -1, -1, -1, -1, -1, 0, 0, -1, 0, -1, -1, -1, -1, 1, -1,
                -999, 0, 1, 0, -1, -2, 0, -1, -2, -1, -1, 0, -1, -1, 0, 0, -999,
                -999, -1, -1, -1, -1, -2, -999, -2, -2, -999, 0, -2, -2, 0, 0,
                -2, 0, -2, 0, 0, 0, -2, -1, -1, 1, 1, 0, 0, -1, -1, -1, -1, -1,
                -1, -1, 0, 0, -1, 0, -1, -1, 0, -999, -1, -1, -1, -1, -1, -1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2, -999, -999, -999, -999,
                -999, -1, -1, -2, -2, 0, 0, 0, 0, -1, -1, -999, -2, -2, 0, 0,
                -1, -2, -2, 0, 0, 0, -1, -1, -1, -2,
              ];
              function sanitizeTTProgram(e, t) {
                let a,
                  n,
                  i,
                  s,
                  o,
                  c = e.data,
                  h = 0,
                  u = 0,
                  d = 0;
                const f = [],
                  g = [],
                  p = [];
                let m = t.tooComplexToFollowFunctions,
                  b = !1,
                  y = 0,
                  w = 0;
                for (let e = c.length; h < e; ) {
                  const e = c[h++];
                  if (64 === e) {
                    n = c[h++];
                    if (b || w) h += n;
                    else for (a = 0; a < n; a++) f.push(c[h++]);
                  } else if (65 === e) {
                    n = c[h++];
                    if (b || w) h += 2 * n;
                    else
                      for (a = 0; a < n; a++) {
                        i = c[h++];
                        f.push((i << 8) | c[h++]);
                      }
                  } else if (176 == (248 & e)) {
                    n = e - 176 + 1;
                    if (b || w) h += n;
                    else for (a = 0; a < n; a++) f.push(c[h++]);
                  } else if (184 == (248 & e)) {
                    n = e - 184 + 1;
                    if (b || w) h += 2 * n;
                    else
                      for (a = 0; a < n; a++) {
                        i = c[h++];
                        f.push((i << 8) | c[h++]);
                      }
                  } else if (43 !== e || m)
                    if (44 !== e || m) {
                      if (45 === e)
                        if (b) {
                          b = !1;
                          u = h;
                        } else {
                          o = g.pop();
                          if (!o) {
                            (0, r.warn)("TT: ENDF bad stack");
                            t.hintsValid = !1;
                            return;
                          }
                          s = p.pop();
                          c = o.data;
                          h = o.i;
                          t.functionsStackDeltas[s] = f.length - o.stackTop;
                        }
                      else if (137 === e) {
                        if (b || w) {
                          (0, r.warn)("TT: nested IDEFs not allowed");
                          m = !0;
                        }
                        b = !0;
                        d = h;
                      } else if (88 === e) ++y;
                      else if (27 === e) w = y;
                      else if (89 === e) {
                        w === y && (w = 0);
                        --y;
                      } else if (28 === e && !b && !w) {
                        const e = f.at(-1);
                        e > 0 && (h += e - 1);
                      }
                    } else {
                      if (b || w) {
                        (0, r.warn)("TT: nested FDEFs not allowed");
                        m = !0;
                      }
                      b = !0;
                      d = h;
                      s = f.pop();
                      t.functionsDefined[s] = { data: c, i: h };
                    }
                  else if (!b && !w) {
                    s = f.at(-1);
                    if (isNaN(s))
                      (0, r.info)("TT: CALL empty stack (or invalid entry).");
                    else {
                      t.functionsUsed[s] = !0;
                      if (s in t.functionsStackDeltas) {
                        const e = f.length + t.functionsStackDeltas[s];
                        if (e < 0) {
                          (0, r.warn)(
                            "TT: CALL invalid functions stack delta.",
                          );
                          t.hintsValid = !1;
                          return;
                        }
                        f.length = e;
                      } else if (s in t.functionsDefined && !p.includes(s)) {
                        g.push({ data: c, i: h, stackTop: f.length - 1 });
                        p.push(s);
                        o = t.functionsDefined[s];
                        if (!o) {
                          (0, r.warn)("TT: CALL non-existent function");
                          t.hintsValid = !1;
                          return;
                        }
                        c = o.data;
                        h = o.i;
                      }
                    }
                  }
                  if (!b && !w) {
                    let t = 0;
                    e <= 142
                      ? (t = l[e])
                      : e >= 192 && e <= 223
                        ? (t = -1)
                        : e >= 224 && (t = -2);
                    if (e >= 113 && e <= 117) {
                      n = f.pop();
                      isNaN(n) || (t = 2 * -n);
                    }
                    for (; t < 0 && f.length > 0; ) {
                      f.pop();
                      t++;
                    }
                    for (; t > 0; ) {
                      f.push(NaN);
                      t--;
                    }
                  }
                }
                t.tooComplexToFollowFunctions = m;
                const S = [c];
                h > c.length && S.push(new Uint8Array(h - c.length));
                if (d > u) {
                  (0, r.warn)("TT: complementing a missing function tail");
                  S.push(new Uint8Array([34, 45]));
                }
                !(function foldTTTable(e, t) {
                  if (t.length > 1) {
                    let a,
                      r,
                      n = 0;
                    for (a = 0, r = t.length; a < r; a++) n += t[a].length;
                    n = (n + 3) & -4;
                    const i = new Uint8Array(n);
                    let s = 0;
                    for (a = 0, r = t.length; a < r; a++) {
                      i.set(t[a], s);
                      s += t[a].length;
                    }
                    e.data = i;
                    e.length = n;
                  }
                })(e, S);
              }
              let d, f, b, w;
              if (
                isTrueTypeCollectionFile(
                  (t = new y.Stream(new Uint8Array(t.getBytes()))),
                )
              ) {
                const e = (function readTrueTypeCollectionData(e, t) {
                  const { numFonts: a, offsetTable: n } =
                      (function readTrueTypeCollectionHeader(e) {
                        const t = e.getString(4);
                        (0, r.assert)(
                          "ttcf" === t,
                          "Must be a TrueType Collection font.",
                        );
                        const a = e.getUint16(),
                          n = e.getUint16(),
                          i = e.getInt32() >>> 0,
                          s = [];
                        for (let t = 0; t < i; t++) s.push(e.getInt32() >>> 0);
                        const o = {
                          ttcTag: t,
                          majorVersion: a,
                          minorVersion: n,
                          numFonts: i,
                          offsetTable: s,
                        };
                        switch (a) {
                          case 1:
                            return o;
                          case 2:
                            o.dsigTag = e.getInt32() >>> 0;
                            o.dsigLength = e.getInt32() >>> 0;
                            o.dsigOffset = e.getInt32() >>> 0;
                            return o;
                        }
                        throw new r.FormatError(
                          `Invalid TrueType Collection majorVersion: ${a}.`,
                        );
                      })(e),
                    i = t.split("+");
                  let s;
                  for (let o = 0; o < a; o++) {
                    e.pos = (e.start || 0) + n[o];
                    const a = readOpenTypeHeader(e),
                      c = readTables(e, a.numTables);
                    if (!c.name)
                      throw new r.FormatError(
                        'TrueType Collection font must contain a "name" table.',
                      );
                    const [l] = readNameTable(c.name);
                    for (let e = 0, r = l.length; e < r; e++)
                      for (let r = 0, n = l[e].length; r < n; r++) {
                        const n = l[e][r]?.replaceAll(/\s/g, "");
                        if (n) {
                          if (n === t) return { header: a, tables: c };
                          if (!(i.length < 2))
                            for (const e of i)
                              n === e &&
                                (s = { name: e, header: a, tables: c });
                        }
                      }
                  }
                  if (s) {
                    (0, r.warn)(
                      `TrueType Collection does not contain "${t}" font, falling back to "${s.name}" font instead.`,
                    );
                    return { header: s.header, tables: s.tables };
                  }
                  throw new r.FormatError(
                    `TrueType Collection does not contain "${t}" font.`,
                  );
                })(t, this.name);
                d = e.header;
                f = e.tables;
              } else {
                d = readOpenTypeHeader(t);
                f = readTables(t, d.numTables);
              }
              const S = !f["CFF "];
              if (S) {
                if (!f.loca)
                  throw new r.FormatError('Required "loca" table is not found');
                if (!f.glyf) {
                  (0, r.warn)(
                    'Required "glyf" table is not found -- trying to recover.',
                  );
                  f.glyf = { tag: "glyf", data: new Uint8Array(0) };
                }
                this.isOpenType = !1;
              } else {
                const t =
                  a.composite &&
                  (a.cidToGidMap?.length > 0 ||
                    !(a.cMap instanceof p.IdentityCMap));
                if (
                  ("OTTO" === d.version && !t) ||
                  !f.head ||
                  !f.hhea ||
                  !f.maxp ||
                  !f.post
                ) {
                  w = new y.Stream(f["CFF "].data);
                  b = new u.CFFFont(w, a);
                  adjustWidths(a);
                  return this.convert(e, b, a);
                }
                delete f.glyf;
                delete f.loca;
                delete f.fpgm;
                delete f.prep;
                delete f["cvt "];
                this.isOpenType = !0;
              }
              if (!f.maxp)
                throw new r.FormatError('Required "maxp" table is not found');
              t.pos = (t.start || 0) + f.maxp.offset;
              const x = t.getInt32(),
                C = t.getUint16();
              if (a.scaleFactors?.length === C && S) {
                const { scaleFactors: e } = a,
                  t = int16(f.head.data[50], f.head.data[51]),
                  r = new g.GlyfTable({
                    glyfTable: f.glyf.data,
                    isGlyphLocationsLong: t,
                    locaTable: f.loca.data,
                    numGlyphs: C,
                  });
                r.scale(e);
                const { glyf: n, loca: i, isLocationLong: s } = r.write();
                f.glyf.data = n;
                f.loca.data = i;
                if (s !== !!t) {
                  f.head.data[50] = 0;
                  f.head.data[51] = s ? 1 : 0;
                }
                const o = f.hmtx.data;
                for (let t = 0; t < C; t++) {
                  const a = 4 * t,
                    r = Math.round(e[t] * int16(o[a], o[a + 1]));
                  o[a] = (r >> 8) & 255;
                  o[a + 1] = 255 & r;
                  writeSignedInt16(
                    o,
                    a + 2,
                    Math.round(e[t] * signedInt16(o[a + 2], o[a + 3])),
                  );
                }
              }
              let k = C + 1,
                v = !0;
              if (k > 65535) {
                v = !1;
                k = C;
                (0, r.warn)(
                  "Not enough space in glyfs to duplicate first glyph.",
                );
              }
              let F = 0,
                O = 0;
              if (x >= 65536 && f.maxp.length >= 22) {
                t.pos += 8;
                if (t.getUint16() > 2) {
                  f.maxp.data[14] = 0;
                  f.maxp.data[15] = 2;
                }
                t.pos += 4;
                F = t.getUint16();
                t.pos += 4;
                O = t.getUint16();
              }
              f.maxp.data[4] = k >> 8;
              f.maxp.data[5] = 255 & k;
              const T = (function sanitizeTTPrograms(e, t, a, n) {
                const i = {
                  functionsDefined: [],
                  functionsUsed: [],
                  functionsStackDeltas: [],
                  tooComplexToFollowFunctions: !1,
                  hintsValid: !0,
                };
                e && sanitizeTTProgram(e, i);
                t && sanitizeTTProgram(t, i);
                e &&
                  (function checkInvalidFunctions(e, t) {
                    if (!e.tooComplexToFollowFunctions)
                      if (e.functionsDefined.length > t) {
                        (0, r.warn)("TT: more functions defined than expected");
                        e.hintsValid = !1;
                      } else
                        for (
                          let a = 0, n = e.functionsUsed.length;
                          a < n;
                          a++
                        ) {
                          if (a > t) {
                            (0, r.warn)("TT: invalid function id: " + a);
                            e.hintsValid = !1;
                            return;
                          }
                          if (e.functionsUsed[a] && !e.functionsDefined[a]) {
                            (0, r.warn)("TT: undefined function: " + a);
                            e.hintsValid = !1;
                            return;
                          }
                        }
                  })(i, n);
                if (a && 1 & a.length) {
                  const e = new Uint8Array(a.length + 1);
                  e.set(a.data);
                  a.data = e;
                }
                return i.hintsValid;
              })(f.fpgm, f.prep, f["cvt "], F);
              if (!T) {
                delete f.fpgm;
                delete f.prep;
                delete f["cvt "];
              }
              !(function sanitizeMetrics(e, t, a, n, i, s) {
                if (!t) {
                  a && (a.data = null);
                  return;
                }
                e.pos = (e.start || 0) + t.offset;
                e.pos += 4;
                e.pos += 2;
                e.pos += 2;
                e.pos += 2;
                e.pos += 2;
                e.pos += 2;
                e.pos += 2;
                e.pos += 2;
                e.pos += 2;
                e.pos += 2;
                const o = e.getUint16();
                e.pos += 8;
                e.pos += 2;
                let c = e.getUint16();
                if (0 !== o) {
                  if (!(2 & int16(n.data[44], n.data[45]))) {
                    t.data[22] = 0;
                    t.data[23] = 0;
                  }
                }
                if (c > i) {
                  (0, r.info)(
                    `The numOfMetrics (${c}) should not be greater than the numGlyphs (${i}).`,
                  );
                  c = i;
                  t.data[34] = (65280 & c) >> 8;
                  t.data[35] = 255 & c;
                }
                const l = i - c - ((a.length - 4 * c) >> 1);
                if (l > 0) {
                  const e = new Uint8Array(a.length + 2 * l);
                  e.set(a.data);
                  if (s) {
                    e[a.length] = a.data[2];
                    e[a.length + 1] = a.data[3];
                  }
                  a.data = e;
                }
              })(t, f.hhea, f.hmtx, f.head, k, v);
              if (!f.head)
                throw new r.FormatError('Required "head" table is not found');
              !(function sanitizeHead(e, t, a) {
                const n = e.data,
                  i = (function int32(e, t, a, r) {
                    return (e << 24) + (t << 16) + (a << 8) + r;
                  })(n[0], n[1], n[2], n[3]);
                if (i >> 16 != 1) {
                  (0, r.info)(
                    "Attempting to fix invalid version in head table: " + i,
                  );
                  n[0] = 0;
                  n[1] = 1;
                  n[2] = 0;
                  n[3] = 0;
                }
                const s = int16(n[50], n[51]);
                if (s < 0 || s > 1) {
                  (0, r.info)(
                    "Attempting to fix invalid indexToLocFormat in head table: " +
                      s,
                  );
                  const e = t + 1;
                  if (a === e << 1) {
                    n[50] = 0;
                    n[51] = 0;
                  } else {
                    if (a !== e << 2)
                      throw new r.FormatError(
                        "Could not fix indexToLocFormat: " + s,
                      );
                    n[50] = 0;
                    n[51] = 1;
                  }
                }
              })(f.head, C, S ? f.loca.length : 0);
              let M = Object.create(null);
              if (S) {
                const e = int16(f.head.data[50], f.head.data[51]),
                  t = (function sanitizeGlyphLocations(e, t, a, r, n, i, s) {
                    let o, c, l;
                    if (r) {
                      o = 4;
                      c = function fontItemDecodeLong(e, t) {
                        return (
                          (e[t] << 24) |
                          (e[t + 1] << 16) |
                          (e[t + 2] << 8) |
                          e[t + 3]
                        );
                      };
                      l = function fontItemEncodeLong(e, t, a) {
                        e[t] = (a >>> 24) & 255;
                        e[t + 1] = (a >> 16) & 255;
                        e[t + 2] = (a >> 8) & 255;
                        e[t + 3] = 255 & a;
                      };
                    } else {
                      o = 2;
                      c = function fontItemDecode(e, t) {
                        return (e[t] << 9) | (e[t + 1] << 1);
                      };
                      l = function fontItemEncode(e, t, a) {
                        e[t] = (a >> 9) & 255;
                        e[t + 1] = (a >> 1) & 255;
                      };
                    }
                    const h = i ? a + 1 : a,
                      u = o * (1 + h),
                      d = new Uint8Array(u);
                    d.set(e.data.subarray(0, u));
                    e.data = d;
                    const f = t.data,
                      g = f.length,
                      p = new Uint8Array(g);
                    let m, b;
                    const y = [];
                    for (m = 0, b = 0; m < a + 1; m++, b += o) {
                      let e = c(d, b);
                      e > g && (e = g);
                      y.push({ index: m, offset: e, endOffset: 0 });
                    }
                    y.sort((e, t) => e.offset - t.offset);
                    for (m = 0; m < a; m++) y[m].endOffset = y[m + 1].offset;
                    y.sort((e, t) => e.index - t.index);
                    for (m = 0; m < a; m++) {
                      const { offset: e, endOffset: t } = y[m];
                      if (0 !== e || 0 !== t) break;
                      const a = y[m + 1].offset;
                      if (0 !== a) {
                        y[m].endOffset = a;
                        break;
                      }
                    }
                    const w = Object.create(null);
                    let S = 0;
                    l(d, 0, S);
                    for (m = 0, b = o; m < a; m++, b += o) {
                      const e = sanitizeGlyph(
                          f,
                          y[m].offset,
                          y[m].endOffset,
                          p,
                          S,
                          n,
                        ),
                        t = e.length;
                      0 === t && (w[m] = !0);
                      e.sizeOfInstructions > s && (s = e.sizeOfInstructions);
                      S += t;
                      l(d, b, S);
                    }
                    if (0 === S) {
                      const e = new Uint8Array([
                        0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49, 0,
                      ]);
                      for (m = 0, b = o; m < h; m++, b += o) l(d, b, e.length);
                      t.data = e;
                    } else if (i) {
                      const a = c(d, o);
                      if (p.length > a + S) t.data = p.subarray(0, a + S);
                      else {
                        t.data = new Uint8Array(a + S);
                        t.data.set(p.subarray(0, S));
                      }
                      t.data.set(p.subarray(0, a), S);
                      l(e.data, d.length - o, S + a);
                    } else t.data = p.subarray(0, S);
                    return { missingGlyphs: w, maxSizeOfInstructions: s };
                  })(f.loca, f.glyf, C, e, T, v, O);
                M = t.missingGlyphs;
                if (x >= 65536 && f.maxp.length >= 22) {
                  f.maxp.data[26] = t.maxSizeOfInstructions >> 8;
                  f.maxp.data[27] = 255 & t.maxSizeOfInstructions;
                }
              }
              if (!f.hhea)
                throw new r.FormatError('Required "hhea" table is not found');
              if (0 === f.hhea.data[10] && 0 === f.hhea.data[11]) {
                f.hhea.data[10] = 255;
                f.hhea.data[11] = 255;
              }
              const D = {
                unitsPerEm: int16(f.head.data[18], f.head.data[19]),
                yMax: signedInt16(f.head.data[42], f.head.data[43]),
                yMin: signedInt16(f.head.data[38], f.head.data[39]),
                ascent: signedInt16(f.hhea.data[4], f.hhea.data[5]),
                descent: signedInt16(f.hhea.data[6], f.hhea.data[7]),
                lineGap: signedInt16(f.hhea.data[8], f.hhea.data[9]),
              };
              this.ascent = D.ascent / D.unitsPerEm;
              this.descent = D.descent / D.unitsPerEm;
              this.lineGap = D.lineGap / D.unitsPerEm;
              if (this.cssFontInfo?.lineHeight) {
                this.lineHeight = this.cssFontInfo.metrics.lineHeight;
                this.lineGap = this.cssFontInfo.metrics.lineGap;
              } else
                this.lineHeight = this.ascent - this.descent + this.lineGap;
              f.post &&
                (function readPostScriptTable(e, a, n) {
                  const s = (t.start || 0) + e.offset;
                  t.pos = s;
                  const o = s + e.length,
                    c = t.getInt32();
                  t.skip(28);
                  let l,
                    h,
                    u = !0;
                  switch (c) {
                    case 65536:
                      l = i.MacStandardGlyphOrdering;
                      break;
                    case 131072:
                      const e = t.getUint16();
                      if (e !== n) {
                        u = !1;
                        break;
                      }
                      const s = [];
                      for (h = 0; h < e; ++h) {
                        const e = t.getUint16();
                        if (e >= 32768) {
                          u = !1;
                          break;
                        }
                        s.push(e);
                      }
                      if (!u) break;
                      const d = [],
                        f = [];
                      for (; t.pos < o; ) {
                        const e = t.getByte();
                        f.length = e;
                        for (h = 0; h < e; ++h)
                          f[h] = String.fromCharCode(t.getByte());
                        d.push(f.join(""));
                      }
                      l = [];
                      for (h = 0; h < e; ++h) {
                        const e = s[h];
                        e < 258
                          ? l.push(i.MacStandardGlyphOrdering[e])
                          : l.push(d[e - 258]);
                      }
                      break;
                    case 196608:
                      break;
                    default:
                      (0, r.warn)(
                        "Unknown/unsupported post table version " + c,
                      );
                      u = !1;
                      a.defaultEncoding && (l = a.defaultEncoding);
                  }
                  a.glyphNames = l;
                  return u;
                })(f.post, a, C);
              f.post = { tag: "post", data: createPostTable(a) };
              const E = [];
              function hasGlyph(e) {
                return !M[e];
              }
              if (a.composite) {
                const e = a.cidToGidMap || [],
                  t = 0 === e.length;
                a.cMap.forEach(function (a, n) {
                  "string" == typeof n && (n = convertCidString(a, n, !0));
                  if (n > 65535)
                    throw new r.FormatError("Max size of CID is 65,535");
                  let i = -1;
                  t ? (i = n) : void 0 !== e[n] && (i = e[n]);
                  i >= 0 && i < C && hasGlyph(i) && (E[a] = i);
                });
              } else {
                const e = (function readCmapTable(e, t, a, n) {
                    if (!e) {
                      (0, r.warn)("No cmap table available.");
                      return {
                        platformId: -1,
                        encodingId: -1,
                        mappings: [],
                        hasShortCmap: !1,
                      };
                    }
                    let i,
                      s = (t.start || 0) + e.offset;
                    t.pos = s;
                    t.skip(2);
                    const o = t.getUint16();
                    let c,
                      l = !1;
                    for (let e = 0; e < o; e++) {
                      const r = t.getUint16(),
                        i = t.getUint16(),
                        s = t.getInt32() >>> 0;
                      let h = !1;
                      if (c?.platformId !== r || c?.encodingId !== i) {
                        if (0 !== r || (0 !== i && 1 !== i && 3 !== i))
                          if (1 === r && 0 === i) h = !0;
                          else if (3 !== r || 1 !== i || (!n && c)) {
                            if (a && 3 === r && 0 === i) {
                              h = !0;
                              let a = !0;
                              if (e < o - 1) {
                                const e = t.peekBytes(2);
                                int16(e[0], e[1]) < r && (a = !1);
                              }
                              a && (l = !0);
                            }
                          } else {
                            h = !0;
                            a || (l = !0);
                          }
                        else h = !0;
                        h && (c = { platformId: r, encodingId: i, offset: s });
                        if (l) break;
                      }
                    }
                    c && (t.pos = s + c.offset);
                    if (!c || -1 === t.peekByte()) {
                      (0, r.warn)("Could not find a preferred cmap table.");
                      return {
                        platformId: -1,
                        encodingId: -1,
                        mappings: [],
                        hasShortCmap: !1,
                      };
                    }
                    const h = t.getUint16();
                    let u = !1;
                    const d = [];
                    let f, g;
                    if (0 === h) {
                      t.skip(4);
                      for (f = 0; f < 256; f++) {
                        const e = t.getByte();
                        e && d.push({ charCode: f, glyphId: e });
                      }
                      u = !0;
                    } else if (2 === h) {
                      t.skip(4);
                      const e = [];
                      let a = 0;
                      for (let r = 0; r < 256; r++) {
                        const r = t.getUint16() >> 3;
                        e.push(r);
                        a = Math.max(r, a);
                      }
                      const r = [];
                      for (let e = 0; e <= a; e++)
                        r.push({
                          firstCode: t.getUint16(),
                          entryCount: t.getUint16(),
                          idDelta: signedInt16(t.getByte(), t.getByte()),
                          idRangePos: t.pos + t.getUint16(),
                        });
                      for (let a = 0; a < 256; a++)
                        if (0 === e[a]) {
                          t.pos = r[0].idRangePos + 2 * a;
                          g = t.getUint16();
                          d.push({ charCode: a, glyphId: g });
                        } else {
                          const n = r[e[a]];
                          for (f = 0; f < n.entryCount; f++) {
                            const e = (a << 8) + f + n.firstCode;
                            t.pos = n.idRangePos + 2 * f;
                            g = t.getUint16();
                            0 !== g && (g = (g + n.idDelta) % 65536);
                            d.push({ charCode: e, glyphId: g });
                          }
                        }
                    } else if (4 === h) {
                      t.skip(4);
                      const e = t.getUint16() >> 1;
                      t.skip(6);
                      const a = [];
                      let r;
                      for (r = 0; r < e; r++) a.push({ end: t.getUint16() });
                      t.skip(2);
                      for (r = 0; r < e; r++) a[r].start = t.getUint16();
                      for (r = 0; r < e; r++) a[r].delta = t.getUint16();
                      let n,
                        o = 0;
                      for (r = 0; r < e; r++) {
                        i = a[r];
                        const s = t.getUint16();
                        if (s) {
                          n = (s >> 1) - (e - r);
                          i.offsetIndex = n;
                          o = Math.max(o, n + i.end - i.start + 1);
                        } else i.offsetIndex = -1;
                      }
                      const c = [];
                      for (f = 0; f < o; f++) c.push(t.getUint16());
                      for (r = 0; r < e; r++) {
                        i = a[r];
                        s = i.start;
                        const e = i.end,
                          t = i.delta;
                        n = i.offsetIndex;
                        for (f = s; f <= e; f++)
                          if (65535 !== f) {
                            g = n < 0 ? f : c[n + f - s];
                            g = (g + t) & 65535;
                            d.push({ charCode: f, glyphId: g });
                          }
                      }
                    } else if (6 === h) {
                      t.skip(4);
                      const e = t.getUint16(),
                        a = t.getUint16();
                      for (f = 0; f < a; f++) {
                        g = t.getUint16();
                        const a = e + f;
                        d.push({ charCode: a, glyphId: g });
                      }
                    } else {
                      if (12 !== h) {
                        (0, r.warn)("cmap table has unsupported format: " + h);
                        return {
                          platformId: -1,
                          encodingId: -1,
                          mappings: [],
                          hasShortCmap: !1,
                        };
                      }
                      {
                        t.skip(10);
                        const e = t.getInt32() >>> 0;
                        for (f = 0; f < e; f++) {
                          const e = t.getInt32() >>> 0,
                            a = t.getInt32() >>> 0;
                          let r = t.getInt32() >>> 0;
                          for (let t = e; t <= a; t++)
                            d.push({ charCode: t, glyphId: r++ });
                        }
                      }
                    }
                    d.sort(function (e, t) {
                      return e.charCode - t.charCode;
                    });
                    for (let e = 1; e < d.length; e++)
                      if (d[e - 1].charCode === d[e].charCode) {
                        d.splice(e, 1);
                        e--;
                      }
                    return {
                      platformId: c.platformId,
                      encodingId: c.encodingId,
                      mappings: d,
                      hasShortCmap: u,
                    };
                  })(f.cmap, t, this.isSymbolicFont, a.hasEncoding),
                  n = e.platformId,
                  s = e.encodingId,
                  l = e.mappings;
                let u = [],
                  d = !1;
                !a.hasEncoding ||
                  ("MacRomanEncoding" !== a.baseEncodingName &&
                    "WinAnsiEncoding" !== a.baseEncodingName) ||
                  (u = (0, c.getEncoding)(a.baseEncodingName));
                if (
                  a.hasEncoding &&
                  !this.isSymbolicFont &&
                  ((3 === n && 1 === s) || (1 === n && 0 === s))
                ) {
                  const e = (0, o.getGlyphsUnicode)();
                  for (let t = 0; t < 256; t++) {
                    let r;
                    r =
                      void 0 !== this.differences[t]
                        ? this.differences[t]
                        : u.length && "" !== u[t]
                          ? u[t]
                          : c.StandardEncoding[t];
                    if (!r) continue;
                    const o = (0, i.recoverGlyphName)(r, e);
                    let d;
                    3 === n && 1 === s
                      ? (d = e[o])
                      : 1 === n &&
                        0 === s &&
                        (d = c.MacRomanEncoding.indexOf(o));
                    if (void 0 === d) {
                      if (
                        !a.glyphNames &&
                        a.hasIncludedToUnicodeMap &&
                        !(this.toUnicode instanceof h.IdentityToUnicodeMap)
                      ) {
                        const e = this.toUnicode.get(t);
                        e && (d = e.codePointAt(0));
                      }
                      if (void 0 === d) continue;
                    }
                    for (const e of l)
                      if (e.charCode === d) {
                        E[t] = e.glyphId;
                        break;
                      }
                  }
                } else if (0 === n) {
                  for (const e of l) E[e.charCode] = e.glyphId;
                  d = !0;
                } else
                  for (const e of l) {
                    let t = e.charCode;
                    3 === n && t >= 61440 && t <= 61695 && (t &= 255);
                    E[t] = e.glyphId;
                  }
                if (a.glyphNames && (u.length || this.differences.length))
                  for (let e = 0; e < 256; ++e) {
                    if (!d && void 0 !== E[e]) continue;
                    const t = this.differences[e] || u[e];
                    if (!t) continue;
                    const r = a.glyphNames.indexOf(t);
                    r > 0 && hasGlyph(r) && (E[e] = r);
                  }
              }
              0 === E.length && (E[0] = 0);
              let N = k - 1;
              v || (N = 0);
              if (!a.cssFontInfo) {
                const e = adjustMapping(E, hasGlyph, N, this.toUnicode);
                this.toFontChar = e.toFontChar;
                f.cmap = {
                  tag: "cmap",
                  data: createCmapTable(
                    e.charCodeToGlyphId,
                    e.toUnicodeExtraMap,
                    k,
                  ),
                };
                (f["OS/2"] &&
                  (function validateOS2Table(e, t) {
                    t.pos = (t.start || 0) + e.offset;
                    const a = t.getUint16();
                    t.skip(60);
                    const r = t.getUint16();
                    if (a < 4 && 768 & r) return !1;
                    if (t.getUint16() > t.getUint16()) return !1;
                    t.skip(6);
                    if (0 === t.getUint16()) return !1;
                    e.data[8] = e.data[9] = 0;
                    return !0;
                  })(f["OS/2"], t)) ||
                  (f["OS/2"] = {
                    tag: "OS/2",
                    data: createOS2Table(a, e.charCodeToGlyphId, D),
                  });
              }
              if (!S)
                try {
                  w = new y.Stream(f["CFF "].data);
                  b = new n.CFFParser(w, a, i.SEAC_ANALYSIS_ENABLED).parse();
                  b.duplicateFirstGlyph();
                  const e = new n.CFFCompiler(b);
                  f["CFF "].data = e.compile();
                } catch {
                  (0, r.warn)("Failed to compile font " + a.loadedName);
                }
              if (f.name) {
                const [t, r] = readNameTable(f.name);
                f.name.data = createNameTable(e, t);
                this.psName = t[0][6] || null;
                a.composite ||
                  (function adjustTrueTypeToUnicode(e, t, a) {
                    if (e.isInternalFont) return;
                    if (e.hasIncludedToUnicodeMap) return;
                    if (e.hasEncoding) return;
                    if (e.toUnicode instanceof h.IdentityToUnicodeMap) return;
                    if (!t) return;
                    if (0 === a.length) return;
                    if (e.defaultEncoding === c.WinAnsiEncoding) return;
                    for (const e of a) if (!isWinNameRecord(e)) return;
                    const r = c.WinAnsiEncoding,
                      n = [],
                      i = (0, o.getGlyphsUnicode)();
                    for (const e in r) {
                      const t = r[e];
                      if ("" === t) continue;
                      const a = i[t];
                      void 0 !== a && (n[e] = String.fromCharCode(a));
                    }
                    n.length > 0 && e.toUnicode.amend(n);
                  })(a, this.isSymbolicFont, r);
              } else f.name = { tag: "name", data: createNameTable(this.name) };
              const R = new m.OpenTypeFileBuilder(d.version);
              for (const e in f) R.addTable(e, f[e].data);
              return R.toArray();
            }
            convert(e, t, a) {
              a.fixedPitch = !1;
              a.builtInEncoding &&
                (function adjustType1ToUnicode(e, t) {
                  if (e.isInternalFont) return;
                  if (e.hasIncludedToUnicodeMap) return;
                  if (t === e.defaultEncoding) return;
                  if (e.toUnicode instanceof h.IdentityToUnicodeMap) return;
                  const a = [],
                    r = (0, o.getGlyphsUnicode)();
                  for (const n in t) {
                    if (
                      e.hasEncoding &&
                      (e.baseEncodingName || void 0 !== e.differences[n])
                    )
                      continue;
                    const i = t[n],
                      o = (0, s.getUnicodeForGlyph)(i, r);
                    -1 !== o && (a[n] = String.fromCharCode(o));
                  }
                  a.length > 0 && e.toUnicode.amend(a);
                })(a, a.builtInEncoding);
              let n = 1;
              t instanceof u.CFFFont && (n = t.numGlyphs - 1);
              const l = t.getGlyphMapping(a);
              let d = null,
                f = l,
                g = null;
              if (!a.cssFontInfo) {
                d = adjustMapping(l, t.hasGlyphId.bind(t), n, this.toUnicode);
                this.toFontChar = d.toFontChar;
                f = d.charCodeToGlyphId;
                g = d.toUnicodeExtraMap;
              }
              const p = t.numGlyphs;
              function getCharCodes(e, t) {
                let a = null;
                for (const r in e) t === e[r] && (a ||= []).push(0 | r);
                return a;
              }
              function createCharCode(e, t) {
                for (const a in e) if (t === e[a]) return 0 | a;
                d.charCodeToGlyphId[d.nextAvailableFontCharCode] = t;
                return d.nextAvailableFontCharCode++;
              }
              const b = t.seacs;
              if (d && i.SEAC_ANALYSIS_ENABLED && b?.length) {
                const e = a.fontMatrix || r.FONT_IDENTITY_MATRIX,
                  n = t.getCharset(),
                  i = Object.create(null);
                for (let t in b) {
                  t |= 0;
                  const a = b[t],
                    r = c.StandardEncoding[a[2]],
                    s = c.StandardEncoding[a[3]],
                    o = n.indexOf(r),
                    h = n.indexOf(s);
                  if (o < 0 || h < 0) continue;
                  const u = {
                      x: a[0] * e[0] + a[1] * e[2] + e[4],
                      y: a[0] * e[1] + a[1] * e[3] + e[5],
                    },
                    f = getCharCodes(l, t);
                  if (f)
                    for (const e of f) {
                      const t = d.charCodeToGlyphId,
                        a = createCharCode(t, o),
                        r = createCharCode(t, h);
                      i[e] = {
                        baseFontCharCode: a,
                        accentFontCharCode: r,
                        accentOffset: u,
                      };
                    }
                }
                a.seacMap = i;
              }
              const y = 1 / (a.fontMatrix || r.FONT_IDENTITY_MATRIX)[0],
                w = new m.OpenTypeFileBuilder("OTTO");
              w.addTable("CFF ", t.data);
              w.addTable("OS/2", createOS2Table(a, f));
              w.addTable("cmap", createCmapTable(f, g, p));
              w.addTable(
                "head",
                "\0\0\0\0\0\0\0\0\0\0_<õ\0\0" +
                  safeString16(y) +
                  "\0\0\0\0\v~'\0\0\0\0\v~'\0\0" +
                  safeString16(a.descent) +
                  "ÿ" +
                  safeString16(a.ascent) +
                  string16(a.italicAngle ? 2 : 0) +
                  "\0\0\0\0\0\0\0",
              );
              w.addTable(
                "hhea",
                "\0\0\0" +
                  safeString16(a.ascent) +
                  safeString16(a.descent) +
                  "\0\0ÿÿ\0\0\0\0\0\0" +
                  safeString16(a.capHeight) +
                  safeString16(Math.tan(a.italicAngle) * a.xHeight) +
                  "\0\0\0\0\0\0\0\0\0\0\0\0" +
                  string16(p),
              );
              w.addTable(
                "hmtx",
                (function fontFieldsHmtx() {
                  const e = t.charstrings,
                    a = t.cff ? t.cff.widths : null;
                  let r = "\0\0\0\0";
                  for (let t = 1, n = p; t < n; t++) {
                    let n = 0;
                    if (e) {
                      const a = e[t - 1];
                      n = "width" in a ? a.width : 0;
                    } else a && (n = Math.ceil(a[t] || 0));
                    r += string16(n) + string16(0);
                  }
                  return r;
                })(),
              );
              w.addTable("maxp", "\0\0P\0" + string16(p));
              w.addTable("name", createNameTable(e));
              w.addTable("post", createPostTable(a));
              return w.toArray();
            }
            get spaceWidth() {
              const e = ["space", "minus", "one", "i", "I"];
              let t;
              for (const a of e) {
                if (a in this.widths) {
                  t = this.widths[a];
                  break;
                }
                const e = (0, o.getGlyphsUnicode)()[a];
                let r = 0;
                if (this.composite && this.cMap.contains(e)) {
                  r = this.cMap.lookup(e);
                  "string" == typeof r && (r = convertCidString(e, r));
                }
                !r && this.toUnicode && (r = this.toUnicode.charCodeOf(e));
                r <= 0 && (r = e);
                t = this.widths[r];
                if (t) break;
              }
              return (0, r.shadow)(this, "spaceWidth", t || this.defaultWidth);
            }
            _charToGlyph(e, t = !1) {
              let a,
                n,
                i,
                o = this._glyphCache[e];
              if (o?.isSpace === t) return o;
              let c = e;
              if (this.cMap?.contains(e)) {
                c = this.cMap.lookup(e);
                "string" == typeof c && (c = convertCidString(e, c));
              }
              n = this.widths[c];
              "number" != typeof n && (n = this.defaultWidth);
              const l = this.vmetrics?.[c];
              let h = this.toUnicode.get(e) || e;
              "number" == typeof h && (h = String.fromCharCode(h));
              let u = void 0 !== this.toFontChar[e];
              a = this.toFontChar[e] || e;
              if (this.missingFile) {
                const t = this.differences[e] || this.defaultEncoding[e];
                (".notdef" !== t && "" !== t) ||
                  "Type1" !== this.type ||
                  (a = 32);
                a = (0, s.mapSpecialUnicodeValues)(a);
              }
              this.isType3Font && (i = a);
              let d = null;
              if (this.seacMap?.[e]) {
                u = !0;
                const t = this.seacMap[e];
                a = t.baseFontCharCode;
                d = {
                  fontChar: String.fromCodePoint(t.accentFontCharCode),
                  offset: t.accentOffset,
                };
              }
              let f = "";
              "number" == typeof a &&
                (a <= 1114111
                  ? (f = String.fromCodePoint(a))
                  : (0, r.warn)(`charToGlyph - invalid fontCharCode: ${a}`));
              o = new Glyph(e, f, h, d, n, l, i, t, u);
              return (this._glyphCache[e] = o);
            }
            charsToGlyphs(e) {
              let t = this._charsCache[e];
              if (t) return t;
              t = [];
              if (this.cMap) {
                const a = Object.create(null),
                  r = e.length;
                let n = 0;
                for (; n < r; ) {
                  this.cMap.readCharCode(e, n, a);
                  const { charcode: r, length: i } = a;
                  n += i;
                  const s = this._charToGlyph(
                    r,
                    1 === i && 32 === e.charCodeAt(n - 1),
                  );
                  t.push(s);
                }
              } else
                for (let a = 0, r = e.length; a < r; ++a) {
                  const r = e.charCodeAt(a),
                    n = this._charToGlyph(r, 32 === r);
                  t.push(n);
                }
              return (this._charsCache[e] = t);
            }
            getCharPositions(e) {
              const t = [];
              if (this.cMap) {
                const a = Object.create(null);
                let r = 0;
                for (; r < e.length; ) {
                  this.cMap.readCharCode(e, r, a);
                  const n = a.length;
                  t.push([r, r + n]);
                  r += n;
                }
              } else
                for (let a = 0, r = e.length; a < r; ++a) t.push([a, a + 1]);
              return t;
            }
            get glyphCacheValues() {
              return Object.values(this._glyphCache);
            }
            encodeString(e) {
              const t = [],
                a = [],
                hasCurrentBufErrors = () => t.length % 2 == 1,
                r =
                  this.toUnicode instanceof h.IdentityToUnicodeMap
                    ? (e) => this.toUnicode.charCodeOf(e)
                    : (e) => this.toUnicode.charCodeOf(String.fromCodePoint(e));
              for (let n = 0, i = e.length; n < i; n++) {
                const i = e.codePointAt(n);
                i > 55295 && (i < 57344 || i > 65533) && n++;
                if (this.toUnicode) {
                  const e = r(i);
                  if (-1 !== e) {
                    if (hasCurrentBufErrors()) {
                      t.push(a.join(""));
                      a.length = 0;
                    }
                    for (
                      let t =
                        (this.cMap ? this.cMap.getCharCodeLength(e) : 1) - 1;
                      t >= 0;
                      t--
                    )
                      a.push(String.fromCharCode((e >> (8 * t)) & 255));
                    continue;
                  }
                }
                if (!hasCurrentBufErrors()) {
                  t.push(a.join(""));
                  a.length = 0;
                }
                a.push(String.fromCodePoint(i));
              }
              t.push(a.join(""));
              return t;
            }
          };
          t.ErrorFont = class ErrorFont {
            constructor(e) {
              this.error = e;
              this.loadedName = "g_font_error";
              this.missingFile = !0;
            }
            charsToGlyphs() {
              return [];
            }
            encodeString(e) {
              return [e];
            }
            exportData(e = !1) {
              return { error: this.error };
            }
          };
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.CFFTopDict =
            t.CFFStrings =
            t.CFFStandardStrings =
            t.CFFPrivateDict =
            t.CFFParser =
            t.CFFIndex =
            t.CFFHeader =
            t.CFFFDSelect =
            t.CFFCompiler =
            t.CFFCharset =
            t.CFF =
              void 0;
          var r = a(2),
            n = a(36),
            i = a(37);
          const s = [
            ".notdef",
            "space",
            "exclam",
            "quotedbl",
            "numbersign",
            "dollar",
            "percent",
            "ampersand",
            "quoteright",
            "parenleft",
            "parenright",
            "asterisk",
            "plus",
            "comma",
            "hyphen",
            "period",
            "slash",
            "zero",
            "one",
            "two",
            "three",
            "four",
            "five",
            "six",
            "seven",
            "eight",
            "nine",
            "colon",
            "semicolon",
            "less",
            "equal",
            "greater",
            "question",
            "at",
            "A",
            "B",
            "C",
            "D",
            "E",
            "F",
            "G",
            "H",
            "I",
            "J",
            "K",
            "L",
            "M",
            "N",
            "O",
            "P",
            "Q",
            "R",
            "S",
            "T",
            "U",
            "V",
            "W",
            "X",
            "Y",
            "Z",
            "bracketleft",
            "backslash",
            "bracketright",
            "asciicircum",
            "underscore",
            "quoteleft",
            "a",
            "b",
            "c",
            "d",
            "e",
            "f",
            "g",
            "h",
            "i",
            "j",
            "k",
            "l",
            "m",
            "n",
            "o",
            "p",
            "q",
            "r",
            "s",
            "t",
            "u",
            "v",
            "w",
            "x",
            "y",
            "z",
            "braceleft",
            "bar",
            "braceright",
            "asciitilde",
            "exclamdown",
            "cent",
            "sterling",
            "fraction",
            "yen",
            "florin",
            "section",
            "currency",
            "quotesingle",
            "quotedblleft",
            "guillemotleft",
            "guilsinglleft",
            "guilsinglright",
            "fi",
            "fl",
            "endash",
            "dagger",
            "daggerdbl",
            "periodcentered",
            "paragraph",
            "bullet",
            "quotesinglbase",
            "quotedblbase",
            "quotedblright",
            "guillemotright",
            "ellipsis",
            "perthousand",
            "questiondown",
            "grave",
            "acute",
            "circumflex",
            "tilde",
            "macron",
            "breve",
            "dotaccent",
            "dieresis",
            "ring",
            "cedilla",
            "hungarumlaut",
            "ogonek",
            "caron",
            "emdash",
            "AE",
            "ordfeminine",
            "Lslash",
            "Oslash",
            "OE",
            "ordmasculine",
            "ae",
            "dotlessi",
            "lslash",
            "oslash",
            "oe",
            "germandbls",
            "onesuperior",
            "logicalnot",
            "mu",
            "trademark",
            "Eth",
            "onehalf",
            "plusminus",
            "Thorn",
            "onequarter",
            "divide",
            "brokenbar",
            "degree",
            "thorn",
            "threequarters",
            "twosuperior",
            "registered",
            "minus",
            "eth",
            "multiply",
            "threesuperior",
            "copyright",
            "Aacute",
            "Acircumflex",
            "Adieresis",
            "Agrave",
            "Aring",
            "Atilde",
            "Ccedilla",
            "Eacute",
            "Ecircumflex",
            "Edieresis",
            "Egrave",
            "Iacute",
            "Icircumflex",
            "Idieresis",
            "Igrave",
            "Ntilde",
            "Oacute",
            "Ocircumflex",
            "Odieresis",
            "Ograve",
            "Otilde",
            "Scaron",
            "Uacute",
            "Ucircumflex",
            "Udieresis",
            "Ugrave",
            "Yacute",
            "Ydieresis",
            "Zcaron",
            "aacute",
            "acircumflex",
            "adieresis",
            "agrave",
            "aring",
            "atilde",
            "ccedilla",
            "eacute",
            "ecircumflex",
            "edieresis",
            "egrave",
            "iacute",
            "icircumflex",
            "idieresis",
            "igrave",
            "ntilde",
            "oacute",
            "ocircumflex",
            "odieresis",
            "ograve",
            "otilde",
            "scaron",
            "uacute",
            "ucircumflex",
            "udieresis",
            "ugrave",
            "yacute",
            "ydieresis",
            "zcaron",
            "exclamsmall",
            "Hungarumlautsmall",
            "dollaroldstyle",
            "dollarsuperior",
            "ampersandsmall",
            "Acutesmall",
            "parenleftsuperior",
            "parenrightsuperior",
            "twodotenleader",
            "onedotenleader",
            "zerooldstyle",
            "oneoldstyle",
            "twooldstyle",
            "threeoldstyle",
            "fouroldstyle",
            "fiveoldstyle",
            "sixoldstyle",
            "sevenoldstyle",
            "eightoldstyle",
            "nineoldstyle",
            "commasuperior",
            "threequartersemdash",
            "periodsuperior",
            "questionsmall",
            "asuperior",
            "bsuperior",
            "centsuperior",
            "dsuperior",
            "esuperior",
            "isuperior",
            "lsuperior",
            "msuperior",
            "nsuperior",
            "osuperior",
            "rsuperior",
            "ssuperior",
            "tsuperior",
            "ff",
            "ffi",
            "ffl",
            "parenleftinferior",
            "parenrightinferior",
            "Circumflexsmall",
            "hyphensuperior",
            "Gravesmall",
            "Asmall",
            "Bsmall",
            "Csmall",
            "Dsmall",
            "Esmall",
            "Fsmall",
            "Gsmall",
            "Hsmall",
            "Ismall",
            "Jsmall",
            "Ksmall",
            "Lsmall",
            "Msmall",
            "Nsmall",
            "Osmall",
            "Psmall",
            "Qsmall",
            "Rsmall",
            "Ssmall",
            "Tsmall",
            "Usmall",
            "Vsmall",
            "Wsmall",
            "Xsmall",
            "Ysmall",
            "Zsmall",
            "colonmonetary",
            "onefitted",
            "rupiah",
            "Tildesmall",
            "exclamdownsmall",
            "centoldstyle",
            "Lslashsmall",
            "Scaronsmall",
            "Zcaronsmall",
            "Dieresissmall",
            "Brevesmall",
            "Caronsmall",
            "Dotaccentsmall",
            "Macronsmall",
            "figuredash",
            "hypheninferior",
            "Ogoneksmall",
            "Ringsmall",
            "Cedillasmall",
            "questiondownsmall",
            "oneeighth",
            "threeeighths",
            "fiveeighths",
            "seveneighths",
            "onethird",
            "twothirds",
            "zerosuperior",
            "foursuperior",
            "fivesuperior",
            "sixsuperior",
            "sevensuperior",
            "eightsuperior",
            "ninesuperior",
            "zeroinferior",
            "oneinferior",
            "twoinferior",
            "threeinferior",
            "fourinferior",
            "fiveinferior",
            "sixinferior",
            "seveninferior",
            "eightinferior",
            "nineinferior",
            "centinferior",
            "dollarinferior",
            "periodinferior",
            "commainferior",
            "Agravesmall",
            "Aacutesmall",
            "Acircumflexsmall",
            "Atildesmall",
            "Adieresissmall",
            "Aringsmall",
            "AEsmall",
            "Ccedillasmall",
            "Egravesmall",
            "Eacutesmall",
            "Ecircumflexsmall",
            "Edieresissmall",
            "Igravesmall",
            "Iacutesmall",
            "Icircumflexsmall",
            "Idieresissmall",
            "Ethsmall",
            "Ntildesmall",
            "Ogravesmall",
            "Oacutesmall",
            "Ocircumflexsmall",
            "Otildesmall",
            "Odieresissmall",
            "OEsmall",
            "Oslashsmall",
            "Ugravesmall",
            "Uacutesmall",
            "Ucircumflexsmall",
            "Udieresissmall",
            "Yacutesmall",
            "Thornsmall",
            "Ydieresissmall",
            "001.000",
            "001.001",
            "001.002",
            "001.003",
            "Black",
            "Bold",
            "Book",
            "Light",
            "Medium",
            "Regular",
            "Roman",
            "Semibold",
          ];
          t.CFFStandardStrings = s;
          const o = 391,
            c = [
              null,
              { id: "hstem", min: 2, stackClearing: !0, stem: !0 },
              null,
              { id: "vstem", min: 2, stackClearing: !0, stem: !0 },
              { id: "vmoveto", min: 1, stackClearing: !0 },
              { id: "rlineto", min: 2, resetStack: !0 },
              { id: "hlineto", min: 1, resetStack: !0 },
              { id: "vlineto", min: 1, resetStack: !0 },
              { id: "rrcurveto", min: 6, resetStack: !0 },
              null,
              { id: "callsubr", min: 1, undefStack: !0 },
              { id: "return", min: 0, undefStack: !0 },
              null,
              null,
              { id: "endchar", min: 0, stackClearing: !0 },
              null,
              null,
              null,
              { id: "hstemhm", min: 2, stackClearing: !0, stem: !0 },
              { id: "hintmask", min: 0, stackClearing: !0 },
              { id: "cntrmask", min: 0, stackClearing: !0 },
              { id: "rmoveto", min: 2, stackClearing: !0 },
              { id: "hmoveto", min: 1, stackClearing: !0 },
              { id: "vstemhm", min: 2, stackClearing: !0, stem: !0 },
              { id: "rcurveline", min: 8, resetStack: !0 },
              { id: "rlinecurve", min: 8, resetStack: !0 },
              { id: "vvcurveto", min: 4, resetStack: !0 },
              { id: "hhcurveto", min: 4, resetStack: !0 },
              null,
              { id: "callgsubr", min: 1, undefStack: !0 },
              { id: "vhcurveto", min: 4, resetStack: !0 },
              { id: "hvcurveto", min: 4, resetStack: !0 },
            ],
            l = [
              null,
              null,
              null,
              { id: "and", min: 2, stackDelta: -1 },
              { id: "or", min: 2, stackDelta: -1 },
              { id: "not", min: 1, stackDelta: 0 },
              null,
              null,
              null,
              { id: "abs", min: 1, stackDelta: 0 },
              {
                id: "add",
                min: 2,
                stackDelta: -1,
                stackFn(e, t) {
                  e[t - 2] = e[t - 2] + e[t - 1];
                },
              },
              {
                id: "sub",
                min: 2,
                stackDelta: -1,
                stackFn(e, t) {
                  e[t - 2] = e[t - 2] - e[t - 1];
                },
              },
              {
                id: "div",
                min: 2,
                stackDelta: -1,
                stackFn(e, t) {
                  e[t - 2] = e[t - 2] / e[t - 1];
                },
              },
              null,
              {
                id: "neg",
                min: 1,
                stackDelta: 0,
                stackFn(e, t) {
                  e[t - 1] = -e[t - 1];
                },
              },
              { id: "eq", min: 2, stackDelta: -1 },
              null,
              null,
              { id: "drop", min: 1, stackDelta: -1 },
              null,
              { id: "put", min: 2, stackDelta: -2 },
              { id: "get", min: 1, stackDelta: 0 },
              { id: "ifelse", min: 4, stackDelta: -3 },
              { id: "random", min: 0, stackDelta: 1 },
              {
                id: "mul",
                min: 2,
                stackDelta: -1,
                stackFn(e, t) {
                  e[t - 2] = e[t - 2] * e[t - 1];
                },
              },
              null,
              { id: "sqrt", min: 1, stackDelta: 0 },
              { id: "dup", min: 1, stackDelta: 1 },
              { id: "exch", min: 2, stackDelta: 0 },
              { id: "index", min: 2, stackDelta: 0 },
              { id: "roll", min: 3, stackDelta: -2 },
              null,
              null,
              null,
              { id: "hflex", min: 7, resetStack: !0 },
              { id: "flex", min: 13, resetStack: !0 },
              { id: "hflex1", min: 9, resetStack: !0 },
              { id: "flex1", min: 11, resetStack: !0 },
            ];
          t.CFFParser = class CFFParser {
            constructor(e, t, a) {
              this.bytes = e.getBytes();
              this.properties = t;
              this.seacAnalysisEnabled = !!a;
            }
            parse() {
              const e = this.properties,
                t = new CFF();
              this.cff = t;
              const a = this.parseHeader(),
                r = this.parseIndex(a.endPos),
                n = this.parseIndex(r.endPos),
                i = this.parseIndex(n.endPos),
                s = this.parseIndex(i.endPos),
                o = this.parseDict(n.obj.get(0)),
                c = this.createDict(CFFTopDict, o, t.strings);
              t.header = a.obj;
              t.names = this.parseNameIndex(r.obj);
              t.strings = this.parseStringIndex(i.obj);
              t.topDict = c;
              t.globalSubrIndex = s.obj;
              this.parsePrivateDict(t.topDict);
              t.isCIDFont = c.hasName("ROS");
              const l = c.getByName("CharStrings"),
                h = this.parseIndex(l).obj,
                u = c.getByName("FontMatrix");
              u && (e.fontMatrix = u);
              const d = c.getByName("FontBBox");
              if (d) {
                e.ascent = Math.max(d[3], d[1]);
                e.descent = Math.min(d[1], d[3]);
                e.ascentScaled = !0;
              }
              let f, g;
              if (t.isCIDFont) {
                const e = this.parseIndex(c.getByName("FDArray")).obj;
                for (let a = 0, r = e.count; a < r; ++a) {
                  const r = e.get(a),
                    n = this.createDict(
                      CFFTopDict,
                      this.parseDict(r),
                      t.strings,
                    );
                  this.parsePrivateDict(n);
                  t.fdArray.push(n);
                }
                g = null;
                f = this.parseCharsets(
                  c.getByName("charset"),
                  h.count,
                  t.strings,
                  !0,
                );
                t.fdSelect = this.parseFDSelect(
                  c.getByName("FDSelect"),
                  h.count,
                );
              } else {
                f = this.parseCharsets(
                  c.getByName("charset"),
                  h.count,
                  t.strings,
                  !1,
                );
                g = this.parseEncoding(
                  c.getByName("Encoding"),
                  e,
                  t.strings,
                  f.charset,
                );
              }
              t.charset = f;
              t.encoding = g;
              const p = this.parseCharStrings({
                charStrings: h,
                localSubrIndex: c.privateDict.subrsIndex,
                globalSubrIndex: s.obj,
                fdSelect: t.fdSelect,
                fdArray: t.fdArray,
                privateDict: c.privateDict,
              });
              t.charStrings = p.charStrings;
              t.seacs = p.seacs;
              t.widths = p.widths;
              return t;
            }
            parseHeader() {
              let e = this.bytes;
              const t = e.length;
              let a = 0;
              for (; a < t && 1 !== e[a]; ) ++a;
              if (a >= t) throw new r.FormatError("Invalid CFF header");
              if (0 !== a) {
                (0, r.info)("cff data is shifted");
                e = e.subarray(a);
                this.bytes = e;
              }
              const n = e[0],
                i = e[1],
                s = e[2],
                o = e[3];
              return { obj: new CFFHeader(n, i, s, o), endPos: s };
            }
            parseDict(e) {
              let t = 0;
              function parseOperand() {
                let a = e[t++];
                if (30 === a)
                  return (function parseFloatOperand() {
                    let a = "";
                    const r = 15,
                      n = [
                        "0",
                        "1",
                        "2",
                        "3",
                        "4",
                        "5",
                        "6",
                        "7",
                        "8",
                        "9",
                        ".",
                        "E",
                        "E-",
                        null,
                        "-",
                      ],
                      i = e.length;
                    for (; t < i; ) {
                      const i = e[t++],
                        s = i >> 4,
                        o = 15 & i;
                      if (s === r) break;
                      a += n[s];
                      if (o === r) break;
                      a += n[o];
                    }
                    return parseFloat(a);
                  })();
                if (28 === a) {
                  a = e[t++];
                  a = ((a << 24) | (e[t++] << 16)) >> 16;
                  return a;
                }
                if (29 === a) {
                  a = e[t++];
                  a = (a << 8) | e[t++];
                  a = (a << 8) | e[t++];
                  a = (a << 8) | e[t++];
                  return a;
                }
                if (a >= 32 && a <= 246) return a - 139;
                if (a >= 247 && a <= 250) return 256 * (a - 247) + e[t++] + 108;
                if (a >= 251 && a <= 254)
                  return -256 * (a - 251) - e[t++] - 108;
                (0, r.warn)(
                  'CFFParser_parseDict: "' + a + '" is a reserved command.',
                );
                return NaN;
              }
              let a = [];
              const n = [];
              t = 0;
              const i = e.length;
              for (; t < i; ) {
                let r = e[t];
                if (r <= 21) {
                  12 === r && (r = (r << 8) | e[++t]);
                  n.push([r, a]);
                  a = [];
                  ++t;
                } else a.push(parseOperand());
              }
              return n;
            }
            parseIndex(e) {
              const t = new CFFIndex(),
                a = this.bytes,
                r = (a[e++] << 8) | a[e++],
                n = [];
              let i,
                s,
                o = e;
              if (0 !== r) {
                const t = a[e++],
                  c = e + (r + 1) * t - 1;
                for (i = 0, s = r + 1; i < s; ++i) {
                  let r = 0;
                  for (let n = 0; n < t; ++n) {
                    r <<= 8;
                    r += a[e++];
                  }
                  n.push(c + r);
                }
                o = n[r];
              }
              for (i = 0, s = n.length - 1; i < s; ++i) {
                const e = n[i],
                  r = n[i + 1];
                t.add(a.subarray(e, r));
              }
              return { obj: t, endPos: o };
            }
            parseNameIndex(e) {
              const t = [];
              for (let a = 0, n = e.count; a < n; ++a) {
                const n = e.get(a);
                t.push((0, r.bytesToString)(n));
              }
              return t;
            }
            parseStringIndex(e) {
              const t = new CFFStrings();
              for (let a = 0, n = e.count; a < n; ++a) {
                const n = e.get(a);
                t.add((0, r.bytesToString)(n));
              }
              return t;
            }
            createDict(e, t, a) {
              const r = new e(a);
              for (const [e, a] of t) r.setByKey(e, a);
              return r;
            }
            parseCharString(e, t, a, n) {
              if (!t || e.callDepth > 10) return !1;
              let i = e.stackSize;
              const s = e.stack;
              let o = t.length;
              for (let h = 0; h < o; ) {
                const u = t[h++];
                let d = null;
                if (12 === u) {
                  const e = t[h++];
                  if (0 === e) {
                    t[h - 2] = 139;
                    t[h - 1] = 22;
                    i = 0;
                  } else d = l[e];
                } else if (28 === u) {
                  s[i] = ((t[h] << 24) | (t[h + 1] << 16)) >> 16;
                  h += 2;
                  i++;
                } else if (14 === u) {
                  if (i >= 4) {
                    i -= 4;
                    if (this.seacAnalysisEnabled) {
                      e.seac = s.slice(i, i + 4);
                      return !1;
                    }
                  }
                  d = c[u];
                } else if (u >= 32 && u <= 246) {
                  s[i] = u - 139;
                  i++;
                } else if (u >= 247 && u <= 254) {
                  s[i] =
                    u < 251
                      ? ((u - 247) << 8) + t[h] + 108
                      : -((u - 251) << 8) - t[h] - 108;
                  h++;
                  i++;
                } else if (255 === u) {
                  s[i] =
                    ((t[h] << 24) |
                      (t[h + 1] << 16) |
                      (t[h + 2] << 8) |
                      t[h + 3]) /
                    65536;
                  h += 4;
                  i++;
                } else if (19 === u || 20 === u) {
                  e.hints += i >> 1;
                  if (0 === e.hints) {
                    t.copyWithin(h - 1, h, -1);
                    h -= 1;
                    o -= 1;
                    continue;
                  }
                  h += (e.hints + 7) >> 3;
                  i %= 2;
                  d = c[u];
                } else {
                  if (10 === u || 29 === u) {
                    const t = 10 === u ? a : n;
                    if (!t) {
                      d = c[u];
                      (0, r.warn)("Missing subrsIndex for " + d.id);
                      return !1;
                    }
                    let o = 32768;
                    t.count < 1240 ? (o = 107) : t.count < 33900 && (o = 1131);
                    const l = s[--i] + o;
                    if (l < 0 || l >= t.count || isNaN(l)) {
                      d = c[u];
                      (0, r.warn)("Out of bounds subrIndex for " + d.id);
                      return !1;
                    }
                    e.stackSize = i;
                    e.callDepth++;
                    if (!this.parseCharString(e, t.get(l), a, n)) return !1;
                    e.callDepth--;
                    i = e.stackSize;
                    continue;
                  }
                  if (11 === u) {
                    e.stackSize = i;
                    return !0;
                  }
                  if (0 === u && h === t.length) {
                    t[h - 1] = 14;
                    d = c[14];
                  } else {
                    if (9 === u) {
                      t.copyWithin(h - 1, h, -1);
                      h -= 1;
                      o -= 1;
                      continue;
                    }
                    d = c[u];
                  }
                }
                if (d) {
                  if (d.stem) {
                    e.hints += i >> 1;
                    if (3 === u || 23 === u) e.hasVStems = !0;
                    else if (e.hasVStems && (1 === u || 18 === u)) {
                      (0, r.warn)("CFF stem hints are in wrong order");
                      t[h - 1] = 1 === u ? 3 : 23;
                    }
                  }
                  if ("min" in d && !e.undefStack && i < d.min) {
                    (0, r.warn)(
                      "Not enough parameters for " +
                        d.id +
                        "; actual: " +
                        i +
                        ", expected: " +
                        d.min,
                    );
                    if (0 === i) {
                      t[h - 1] = 14;
                      return !0;
                    }
                    return !1;
                  }
                  if (e.firstStackClearing && d.stackClearing) {
                    e.firstStackClearing = !1;
                    i -= d.min;
                    i >= 2 && d.stem
                      ? (i %= 2)
                      : i > 1 &&
                        (0, r.warn)(
                          "Found too many parameters for stack-clearing command",
                        );
                    i > 0 && (e.width = s[i - 1]);
                  }
                  if ("stackDelta" in d) {
                    "stackFn" in d && d.stackFn(s, i);
                    i += d.stackDelta;
                  } else if (d.stackClearing) i = 0;
                  else if (d.resetStack) {
                    i = 0;
                    e.undefStack = !1;
                  } else if (d.undefStack) {
                    i = 0;
                    e.undefStack = !0;
                    e.firstStackClearing = !1;
                  }
                }
              }
              o < t.length && t.fill(14, o);
              e.stackSize = i;
              return !0;
            }
            parseCharStrings({
              charStrings: e,
              localSubrIndex: t,
              globalSubrIndex: a,
              fdSelect: n,
              fdArray: i,
              privateDict: s,
            }) {
              const o = [],
                c = [],
                l = e.count;
              for (let h = 0; h < l; h++) {
                const l = e.get(h),
                  u = {
                    callDepth: 0,
                    stackSize: 0,
                    stack: [],
                    undefStack: !0,
                    hints: 0,
                    firstStackClearing: !0,
                    seac: null,
                    width: null,
                    hasVStems: !1,
                  };
                let d = !0,
                  f = null,
                  g = s;
                if (n && i.length) {
                  const e = n.getFDIndex(h);
                  if (-1 === e) {
                    (0, r.warn)("Glyph index is not in fd select.");
                    d = !1;
                  }
                  if (e >= i.length) {
                    (0, r.warn)("Invalid fd index for glyph index.");
                    d = !1;
                  }
                  if (d) {
                    g = i[e].privateDict;
                    f = g.subrsIndex;
                  }
                } else t && (f = t);
                d && (d = this.parseCharString(u, l, f, a));
                if (null !== u.width) {
                  const e = g.getByName("nominalWidthX");
                  c[h] = e + u.width;
                } else {
                  const e = g.getByName("defaultWidthX");
                  c[h] = e;
                }
                null !== u.seac && (o[h] = u.seac);
                d || e.set(h, new Uint8Array([14]));
              }
              return { charStrings: e, seacs: o, widths: c };
            }
            emptyPrivateDictionary(e) {
              const t = this.createDict(CFFPrivateDict, [], e.strings);
              e.setByKey(18, [0, 0]);
              e.privateDict = t;
            }
            parsePrivateDict(e) {
              if (!e.hasName("Private")) {
                this.emptyPrivateDictionary(e);
                return;
              }
              const t = e.getByName("Private");
              if (!Array.isArray(t) || 2 !== t.length) {
                e.removeByName("Private");
                return;
              }
              const a = t[0],
                r = t[1];
              if (0 === a || r >= this.bytes.length) {
                this.emptyPrivateDictionary(e);
                return;
              }
              const n = r + a,
                i = this.bytes.subarray(r, n),
                s = this.parseDict(i),
                o = this.createDict(CFFPrivateDict, s, e.strings);
              e.privateDict = o;
              0 === o.getByName("ExpansionFactor") &&
                o.setByName("ExpansionFactor", 0.06);
              if (!o.getByName("Subrs")) return;
              const c = o.getByName("Subrs"),
                l = r + c;
              if (0 === c || l >= this.bytes.length) {
                this.emptyPrivateDictionary(e);
                return;
              }
              const h = this.parseIndex(l);
              o.subrsIndex = h.obj;
            }
            parseCharsets(e, t, a, i) {
              if (0 === e)
                return new CFFCharset(!0, d.ISO_ADOBE, n.ISOAdobeCharset);
              if (1 === e) return new CFFCharset(!0, d.EXPERT, n.ExpertCharset);
              if (2 === e)
                return new CFFCharset(
                  !0,
                  d.EXPERT_SUBSET,
                  n.ExpertSubsetCharset,
                );
              const s = this.bytes,
                o = e,
                c = s[e++],
                l = [i ? 0 : ".notdef"];
              let h, u, f;
              t -= 1;
              switch (c) {
                case 0:
                  for (f = 0; f < t; f++) {
                    h = (s[e++] << 8) | s[e++];
                    l.push(i ? h : a.get(h));
                  }
                  break;
                case 1:
                  for (; l.length <= t; ) {
                    h = (s[e++] << 8) | s[e++];
                    u = s[e++];
                    for (f = 0; f <= u; f++) l.push(i ? h++ : a.get(h++));
                  }
                  break;
                case 2:
                  for (; l.length <= t; ) {
                    h = (s[e++] << 8) | s[e++];
                    u = (s[e++] << 8) | s[e++];
                    for (f = 0; f <= u; f++) l.push(i ? h++ : a.get(h++));
                  }
                  break;
                default:
                  throw new r.FormatError("Unknown charset format");
              }
              const g = e,
                p = s.subarray(o, g);
              return new CFFCharset(!1, c, l, p);
            }
            parseEncoding(e, t, a, n) {
              const s = Object.create(null),
                o = this.bytes;
              let c,
                l,
                h,
                u = !1,
                d = null;
              if (0 === e || 1 === e) {
                u = !0;
                c = e;
                const t = e ? i.ExpertEncoding : i.StandardEncoding;
                for (l = 0, h = n.length; l < h; l++) {
                  const e = t.indexOf(n[l]);
                  -1 !== e && (s[e] = l);
                }
              } else {
                const t = e;
                c = o[e++];
                switch (127 & c) {
                  case 0:
                    const t = o[e++];
                    for (l = 1; l <= t; l++) s[o[e++]] = l;
                    break;
                  case 1:
                    const a = o[e++];
                    let n = 1;
                    for (l = 0; l < a; l++) {
                      const t = o[e++],
                        a = o[e++];
                      for (let e = t; e <= t + a; e++) s[e] = n++;
                    }
                    break;
                  default:
                    throw new r.FormatError(
                      `Unknown encoding format: ${c} in CFF`,
                    );
                }
                const i = e;
                if (128 & c) {
                  o[t] &= 127;
                  !(function readSupplement() {
                    const t = o[e++];
                    for (l = 0; l < t; l++) {
                      const t = o[e++],
                        r = (o[e++] << 8) + (255 & o[e++]);
                      s[t] = n.indexOf(a.get(r));
                    }
                  })();
                }
                d = o.subarray(t, i);
              }
              c &= 127;
              return new CFFEncoding(u, c, s, d);
            }
            parseFDSelect(e, t) {
              const a = this.bytes,
                n = a[e++],
                i = [];
              let s;
              switch (n) {
                case 0:
                  for (s = 0; s < t; ++s) {
                    const t = a[e++];
                    i.push(t);
                  }
                  break;
                case 3:
                  const o = (a[e++] << 8) | a[e++];
                  for (s = 0; s < o; ++s) {
                    let t = (a[e++] << 8) | a[e++];
                    if (0 === s && 0 !== t) {
                      (0, r.warn)(
                        "parseFDSelect: The first range must have a first GID of 0 -- trying to recover.",
                      );
                      t = 0;
                    }
                    const n = a[e++],
                      o = (a[e] << 8) | a[e + 1];
                    for (let e = t; e < o; ++e) i.push(n);
                  }
                  e += 2;
                  break;
                default:
                  throw new r.FormatError(
                    `parseFDSelect: Unknown format "${n}".`,
                  );
              }
              if (i.length !== t)
                throw new r.FormatError("parseFDSelect: Invalid font data.");
              return new CFFFDSelect(n, i);
            }
          };
          class CFF {
            constructor() {
              this.header = null;
              this.names = [];
              this.topDict = null;
              this.strings = new CFFStrings();
              this.globalSubrIndex = null;
              this.encoding = null;
              this.charset = null;
              this.charStrings = null;
              this.fdArray = [];
              this.fdSelect = null;
              this.isCIDFont = !1;
            }
            duplicateFirstGlyph() {
              if (this.charStrings.count >= 65535) {
                (0, r.warn)(
                  "Not enough space in charstrings to duplicate first glyph.",
                );
                return;
              }
              const e = this.charStrings.get(0);
              this.charStrings.add(e);
              this.isCIDFont &&
                this.fdSelect.fdSelect.push(this.fdSelect.fdSelect[0]);
            }
            hasGlyphId(e) {
              if (e < 0 || e >= this.charStrings.count) return !1;
              return this.charStrings.get(e).length > 0;
            }
          }
          t.CFF = CFF;
          class CFFHeader {
            constructor(e, t, a, r) {
              this.major = e;
              this.minor = t;
              this.hdrSize = a;
              this.offSize = r;
            }
          }
          t.CFFHeader = CFFHeader;
          class CFFStrings {
            constructor() {
              this.strings = [];
            }
            get(e) {
              return e >= 0 && e <= 390
                ? s[e]
                : e - o <= this.strings.length
                  ? this.strings[e - o]
                  : s[0];
            }
            getSID(e) {
              let t = s.indexOf(e);
              if (-1 !== t) return t;
              t = this.strings.indexOf(e);
              return -1 !== t ? t + o : -1;
            }
            add(e) {
              this.strings.push(e);
            }
            get count() {
              return this.strings.length;
            }
          }
          t.CFFStrings = CFFStrings;
          class CFFIndex {
            constructor() {
              this.objects = [];
              this.length = 0;
            }
            add(e) {
              this.length += e.length;
              this.objects.push(e);
            }
            set(e, t) {
              this.length += t.length - this.objects[e].length;
              this.objects[e] = t;
            }
            get(e) {
              return this.objects[e];
            }
            get count() {
              return this.objects.length;
            }
          }
          t.CFFIndex = CFFIndex;
          class CFFDict {
            constructor(e, t) {
              this.keyToNameMap = e.keyToNameMap;
              this.nameToKeyMap = e.nameToKeyMap;
              this.defaults = e.defaults;
              this.types = e.types;
              this.opcodes = e.opcodes;
              this.order = e.order;
              this.strings = t;
              this.values = Object.create(null);
            }
            setByKey(e, t) {
              if (!(e in this.keyToNameMap)) return !1;
              if (0 === t.length) return !0;
              for (const a of t)
                if (isNaN(a)) {
                  (0, r.warn)(`Invalid CFFDict value: "${t}" for key "${e}".`);
                  return !0;
                }
              const a = this.types[e];
              ("num" !== a && "sid" !== a && "offset" !== a) || (t = t[0]);
              this.values[e] = t;
              return !0;
            }
            setByName(e, t) {
              if (!(e in this.nameToKeyMap))
                throw new r.FormatError(`Invalid dictionary name "${e}"`);
              this.values[this.nameToKeyMap[e]] = t;
            }
            hasName(e) {
              return this.nameToKeyMap[e] in this.values;
            }
            getByName(e) {
              if (!(e in this.nameToKeyMap))
                throw new r.FormatError(`Invalid dictionary name ${e}"`);
              const t = this.nameToKeyMap[e];
              return t in this.values ? this.values[t] : this.defaults[t];
            }
            removeByName(e) {
              delete this.values[this.nameToKeyMap[e]];
            }
            static createTables(e) {
              const t = {
                keyToNameMap: {},
                nameToKeyMap: {},
                defaults: {},
                types: {},
                opcodes: {},
                order: [],
              };
              for (const a of e) {
                const e = Array.isArray(a[0]) ? (a[0][0] << 8) + a[0][1] : a[0];
                t.keyToNameMap[e] = a[1];
                t.nameToKeyMap[a[1]] = e;
                t.types[e] = a[2];
                t.defaults[e] = a[3];
                t.opcodes[e] = Array.isArray(a[0]) ? a[0] : [a[0]];
                t.order.push(e);
              }
              return t;
            }
          }
          const h = [
            [[12, 30], "ROS", ["sid", "sid", "num"], null],
            [[12, 20], "SyntheticBase", "num", null],
            [0, "version", "sid", null],
            [1, "Notice", "sid", null],
            [[12, 0], "Copyright", "sid", null],
            [2, "FullName", "sid", null],
            [3, "FamilyName", "sid", null],
            [4, "Weight", "sid", null],
            [[12, 1], "isFixedPitch", "num", 0],
            [[12, 2], "ItalicAngle", "num", 0],
            [[12, 3], "UnderlinePosition", "num", -100],
            [[12, 4], "UnderlineThickness", "num", 50],
            [[12, 5], "PaintType", "num", 0],
            [[12, 6], "CharstringType", "num", 2],
            [
              [12, 7],
              "FontMatrix",
              ["num", "num", "num", "num", "num", "num"],
              [0.001, 0, 0, 0.001, 0, 0],
            ],
            [13, "UniqueID", "num", null],
            [5, "FontBBox", ["num", "num", "num", "num"], [0, 0, 0, 0]],
            [[12, 8], "StrokeWidth", "num", 0],
            [14, "XUID", "array", null],
            [15, "charset", "offset", 0],
            [16, "Encoding", "offset", 0],
            [17, "CharStrings", "offset", 0],
            [18, "Private", ["offset", "offset"], null],
            [[12, 21], "PostScript", "sid", null],
            [[12, 22], "BaseFontName", "sid", null],
            [[12, 23], "BaseFontBlend", "delta", null],
            [[12, 31], "CIDFontVersion", "num", 0],
            [[12, 32], "CIDFontRevision", "num", 0],
            [[12, 33], "CIDFontType", "num", 0],
            [[12, 34], "CIDCount", "num", 8720],
            [[12, 35], "UIDBase", "num", null],
            [[12, 37], "FDSelect", "offset", null],
            [[12, 36], "FDArray", "offset", null],
            [[12, 38], "FontName", "sid", null],
          ];
          class CFFTopDict extends CFFDict {
            static get tables() {
              return (0, r.shadow)(this, "tables", this.createTables(h));
            }
            constructor(e) {
              super(CFFTopDict.tables, e);
              this.privateDict = null;
            }
          }
          t.CFFTopDict = CFFTopDict;
          const u = [
            [6, "BlueValues", "delta", null],
            [7, "OtherBlues", "delta", null],
            [8, "FamilyBlues", "delta", null],
            [9, "FamilyOtherBlues", "delta", null],
            [[12, 9], "BlueScale", "num", 0.039625],
            [[12, 10], "BlueShift", "num", 7],
            [[12, 11], "BlueFuzz", "num", 1],
            [10, "StdHW", "num", null],
            [11, "StdVW", "num", null],
            [[12, 12], "StemSnapH", "delta", null],
            [[12, 13], "StemSnapV", "delta", null],
            [[12, 14], "ForceBold", "num", 0],
            [[12, 17], "LanguageGroup", "num", 0],
            [[12, 18], "ExpansionFactor", "num", 0.06],
            [[12, 19], "initialRandomSeed", "num", 0],
            [20, "defaultWidthX", "num", 0],
            [21, "nominalWidthX", "num", 0],
            [19, "Subrs", "offset", null],
          ];
          class CFFPrivateDict extends CFFDict {
            static get tables() {
              return (0, r.shadow)(this, "tables", this.createTables(u));
            }
            constructor(e) {
              super(CFFPrivateDict.tables, e);
              this.subrsIndex = null;
            }
          }
          t.CFFPrivateDict = CFFPrivateDict;
          const d = { ISO_ADOBE: 0, EXPERT: 1, EXPERT_SUBSET: 2 };
          class CFFCharset {
            constructor(e, t, a, r) {
              this.predefined = e;
              this.format = t;
              this.charset = a;
              this.raw = r;
            }
          }
          t.CFFCharset = CFFCharset;
          class CFFEncoding {
            constructor(e, t, a, r) {
              this.predefined = e;
              this.format = t;
              this.encoding = a;
              this.raw = r;
            }
          }
          class CFFFDSelect {
            constructor(e, t) {
              this.format = e;
              this.fdSelect = t;
            }
            getFDIndex(e) {
              return e < 0 || e >= this.fdSelect.length ? -1 : this.fdSelect[e];
            }
          }
          t.CFFFDSelect = CFFFDSelect;
          class CFFOffsetTracker {
            constructor() {
              this.offsets = Object.create(null);
            }
            isTracking(e) {
              return e in this.offsets;
            }
            track(e, t) {
              if (e in this.offsets)
                throw new r.FormatError(`Already tracking location of ${e}`);
              this.offsets[e] = t;
            }
            offset(e) {
              for (const t in this.offsets) this.offsets[t] += e;
            }
            setEntryLocation(e, t, a) {
              if (!(e in this.offsets))
                throw new r.FormatError(`Not tracking location of ${e}`);
              const n = a.data,
                i = this.offsets[e];
              for (let e = 0, a = t.length; e < a; ++e) {
                const a = 5 * e + i,
                  s = a + 1,
                  o = a + 2,
                  c = a + 3,
                  l = a + 4;
                if (
                  29 !== n[a] ||
                  0 !== n[s] ||
                  0 !== n[o] ||
                  0 !== n[c] ||
                  0 !== n[l]
                )
                  throw new r.FormatError(
                    "writing to an offset that is not empty",
                  );
                const h = t[e];
                n[a] = 29;
                n[s] = (h >> 24) & 255;
                n[o] = (h >> 16) & 255;
                n[c] = (h >> 8) & 255;
                n[l] = 255 & h;
              }
            }
          }
          class CFFCompiler {
            constructor(e) {
              this.cff = e;
            }
            compile() {
              const e = this.cff,
                t = {
                  data: [],
                  length: 0,
                  add(e) {
                    try {
                      this.data.push(...e);
                    } catch {
                      this.data = this.data.concat(e);
                    }
                    this.length = this.data.length;
                  },
                },
                a = this.compileHeader(e.header);
              t.add(a);
              const n = this.compileNameIndex(e.names);
              t.add(n);
              if (e.isCIDFont && e.topDict.hasName("FontMatrix")) {
                const t = e.topDict.getByName("FontMatrix");
                e.topDict.removeByName("FontMatrix");
                for (const a of e.fdArray) {
                  let e = t.slice(0);
                  a.hasName("FontMatrix") &&
                    (e = r.Util.transform(e, a.getByName("FontMatrix")));
                  a.setByName("FontMatrix", e);
                }
              }
              const i = e.topDict.getByName("XUID");
              i?.length > 16 && e.topDict.removeByName("XUID");
              e.topDict.setByName("charset", 0);
              let s = this.compileTopDicts([e.topDict], t.length, e.isCIDFont);
              t.add(s.output);
              const o = s.trackers[0],
                c = this.compileStringIndex(e.strings.strings);
              t.add(c);
              const l = this.compileIndex(e.globalSubrIndex);
              t.add(l);
              if (e.encoding && e.topDict.hasName("Encoding"))
                if (e.encoding.predefined)
                  o.setEntryLocation("Encoding", [e.encoding.format], t);
                else {
                  const a = this.compileEncoding(e.encoding);
                  o.setEntryLocation("Encoding", [t.length], t);
                  t.add(a);
                }
              const h = this.compileCharset(
                e.charset,
                e.charStrings.count,
                e.strings,
                e.isCIDFont,
              );
              o.setEntryLocation("charset", [t.length], t);
              t.add(h);
              const u = this.compileCharStrings(e.charStrings);
              o.setEntryLocation("CharStrings", [t.length], t);
              t.add(u);
              if (e.isCIDFont) {
                o.setEntryLocation("FDSelect", [t.length], t);
                const a = this.compileFDSelect(e.fdSelect);
                t.add(a);
                s = this.compileTopDicts(e.fdArray, t.length, !0);
                o.setEntryLocation("FDArray", [t.length], t);
                t.add(s.output);
                const r = s.trackers;
                this.compilePrivateDicts(e.fdArray, r, t);
              }
              this.compilePrivateDicts([e.topDict], [o], t);
              t.add([0]);
              return t.data;
            }
            encodeNumber(e) {
              return Number.isInteger(e)
                ? this.encodeInteger(e)
                : this.encodeFloat(e);
            }
            static get EncodeFloatRegExp() {
              return (0, r.shadow)(
                this,
                "EncodeFloatRegExp",
                /\.(\d*?)(?:9{5,20}|0{5,20})\d{0,2}(?:e(.+)|$)/,
              );
            }
            encodeFloat(e) {
              let t = e.toString();
              const a = CFFCompiler.EncodeFloatRegExp.exec(t);
              if (a) {
                const r = parseFloat("1e" + ((a[2] ? +a[2] : 0) + a[1].length));
                t = (Math.round(e * r) / r).toString();
              }
              let r,
                n,
                i = "";
              for (r = 0, n = t.length; r < n; ++r) {
                const e = t[r];
                i +=
                  "e" === e
                    ? "-" === t[++r]
                      ? "c"
                      : "b"
                    : "." === e
                      ? "a"
                      : "-" === e
                        ? "e"
                        : e;
              }
              i += 1 & i.length ? "f" : "ff";
              const s = [30];
              for (r = 0, n = i.length; r < n; r += 2)
                s.push(parseInt(i.substring(r, r + 2), 16));
              return s;
            }
            encodeInteger(e) {
              let t;
              t =
                e >= -107 && e <= 107
                  ? [e + 139]
                  : e >= 108 && e <= 1131
                    ? [247 + ((e -= 108) >> 8), 255 & e]
                    : e >= -1131 && e <= -108
                      ? [251 + ((e = -e - 108) >> 8), 255 & e]
                      : e >= -32768 && e <= 32767
                        ? [28, (e >> 8) & 255, 255 & e]
                        : [
                            29,
                            (e >> 24) & 255,
                            (e >> 16) & 255,
                            (e >> 8) & 255,
                            255 & e,
                          ];
              return t;
            }
            compileHeader(e) {
              return [e.major, e.minor, 4, e.offSize];
            }
            compileNameIndex(e) {
              const t = new CFFIndex();
              for (const a of e) {
                const e = Math.min(a.length, 127);
                let n = new Array(e);
                for (let t = 0; t < e; t++) {
                  let e = a[t];
                  (e < "!" ||
                    e > "~" ||
                    "[" === e ||
                    "]" === e ||
                    "(" === e ||
                    ")" === e ||
                    "{" === e ||
                    "}" === e ||
                    "<" === e ||
                    ">" === e ||
                    "/" === e ||
                    "%" === e) &&
                    (e = "_");
                  n[t] = e;
                }
                n = n.join("");
                "" === n && (n = "Bad_Font_Name");
                t.add((0, r.stringToBytes)(n));
              }
              return this.compileIndex(t);
            }
            compileTopDicts(e, t, a) {
              const r = [];
              let n = new CFFIndex();
              for (const i of e) {
                if (a) {
                  i.removeByName("CIDFontVersion");
                  i.removeByName("CIDFontRevision");
                  i.removeByName("CIDFontType");
                  i.removeByName("CIDCount");
                  i.removeByName("UIDBase");
                }
                const e = new CFFOffsetTracker(),
                  s = this.compileDict(i, e);
                r.push(e);
                n.add(s);
                e.offset(t);
              }
              n = this.compileIndex(n, r);
              return { trackers: r, output: n };
            }
            compilePrivateDicts(e, t, a) {
              for (let n = 0, i = e.length; n < i; ++n) {
                const i = e[n],
                  s = i.privateDict;
                if (!s || !i.hasName("Private"))
                  throw new r.FormatError(
                    "There must be a private dictionary.",
                  );
                const o = new CFFOffsetTracker(),
                  c = this.compileDict(s, o);
                let l = a.length;
                o.offset(l);
                c.length || (l = 0);
                t[n].setEntryLocation("Private", [c.length, l], a);
                a.add(c);
                if (s.subrsIndex && s.hasName("Subrs")) {
                  const e = this.compileIndex(s.subrsIndex);
                  o.setEntryLocation("Subrs", [c.length], a);
                  a.add(e);
                }
              }
            }
            compileDict(e, t) {
              const a = [];
              for (const n of e.order) {
                if (!(n in e.values)) continue;
                let i = e.values[n],
                  s = e.types[n];
                Array.isArray(s) || (s = [s]);
                Array.isArray(i) || (i = [i]);
                if (0 !== i.length) {
                  for (let o = 0, c = s.length; o < c; ++o) {
                    const c = s[o],
                      l = i[o];
                    switch (c) {
                      case "num":
                      case "sid":
                        a.push(...this.encodeNumber(l));
                        break;
                      case "offset":
                        const s = e.keyToNameMap[n];
                        t.isTracking(s) || t.track(s, a.length);
                        a.push(29, 0, 0, 0, 0);
                        break;
                      case "array":
                      case "delta":
                        a.push(...this.encodeNumber(l));
                        for (let e = 1, t = i.length; e < t; ++e)
                          a.push(...this.encodeNumber(i[e]));
                        break;
                      default:
                        throw new r.FormatError(`Unknown data type of ${c}`);
                    }
                  }
                  a.push(...e.opcodes[n]);
                }
              }
              return a;
            }
            compileStringIndex(e) {
              const t = new CFFIndex();
              for (const a of e) t.add((0, r.stringToBytes)(a));
              return this.compileIndex(t);
            }
            compileCharStrings(e) {
              const t = new CFFIndex();
              for (let a = 0; a < e.count; a++) {
                const r = e.get(a);
                0 !== r.length ? t.add(r) : t.add(new Uint8Array([139, 14]));
              }
              return this.compileIndex(t);
            }
            compileCharset(e, t, a, n) {
              let i;
              const s = t - 1;
              if (n) i = new Uint8Array([2, 0, 0, (s >> 8) & 255, 255 & s]);
              else {
                i = new Uint8Array(1 + 2 * s);
                i[0] = 0;
                let t = 0;
                const n = e.charset.length;
                let o = !1;
                for (let s = 1; s < i.length; s += 2) {
                  let c = 0;
                  if (t < n) {
                    const n = e.charset[t++];
                    c = a.getSID(n);
                    if (-1 === c) {
                      c = 0;
                      if (!o) {
                        o = !0;
                        (0, r.warn)(`Couldn't find ${n} in CFF strings`);
                      }
                    }
                  }
                  i[s] = (c >> 8) & 255;
                  i[s + 1] = 255 & c;
                }
              }
              return this.compileTypedArray(i);
            }
            compileEncoding(e) {
              return this.compileTypedArray(e.raw);
            }
            compileFDSelect(e) {
              const t = e.format;
              let a, r;
              switch (t) {
                case 0:
                  a = new Uint8Array(1 + e.fdSelect.length);
                  a[0] = t;
                  for (r = 0; r < e.fdSelect.length; r++)
                    a[r + 1] = e.fdSelect[r];
                  break;
                case 3:
                  const n = 0;
                  let i = e.fdSelect[0];
                  const s = [t, 0, 0, (n >> 8) & 255, 255 & n, i];
                  for (r = 1; r < e.fdSelect.length; r++) {
                    const t = e.fdSelect[r];
                    if (t !== i) {
                      s.push((r >> 8) & 255, 255 & r, t);
                      i = t;
                    }
                  }
                  const o = (s.length - 3) / 3;
                  s[1] = (o >> 8) & 255;
                  s[2] = 255 & o;
                  s.push((r >> 8) & 255, 255 & r);
                  a = new Uint8Array(s);
              }
              return this.compileTypedArray(a);
            }
            compileTypedArray(e) {
              return Array.from(e);
            }
            compileIndex(e, t = []) {
              const a = e.objects,
                r = a.length;
              if (0 === r) return [0, 0];
              const n = [(r >> 8) & 255, 255 & r];
              let i,
                s,
                o = 1;
              for (i = 0; i < r; ++i) o += a[i].length;
              s = o < 256 ? 1 : o < 65536 ? 2 : o < 16777216 ? 3 : 4;
              n.push(s);
              let c = 1;
              for (i = 0; i < r + 1; i++) {
                1 === s
                  ? n.push(255 & c)
                  : 2 === s
                    ? n.push((c >> 8) & 255, 255 & c)
                    : 3 === s
                      ? n.push((c >> 16) & 255, (c >> 8) & 255, 255 & c)
                      : n.push(
                          (c >>> 24) & 255,
                          (c >> 16) & 255,
                          (c >> 8) & 255,
                          255 & c,
                        );
                a[i] && (c += a[i].length);
              }
              for (i = 0; i < r; i++) {
                t[i] && t[i].offset(n.length);
                n.push(...a[i]);
              }
              return n;
            }
          }
          t.CFFCompiler = CFFCompiler;
        },
        (e, t) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.ISOAdobeCharset = t.ExpertSubsetCharset = t.ExpertCharset = void 0;
          t.ISOAdobeCharset = [
            ".notdef",
            "space",
            "exclam",
            "quotedbl",
            "numbersign",
            "dollar",
            "percent",
            "ampersand",
            "quoteright",
            "parenleft",
            "parenright",
            "asterisk",
            "plus",
            "comma",
            "hyphen",
            "period",
            "slash",
            "zero",
            "one",
            "two",
            "three",
            "four",
            "five",
            "six",
            "seven",
            "eight",
            "nine",
            "colon",
            "semicolon",
            "less",
            "equal",
            "greater",
            "question",
            "at",
            "A",
            "B",
            "C",
            "D",
            "E",
            "F",
            "G",
            "H",
            "I",
            "J",
            "K",
            "L",
            "M",
            "N",
            "O",
            "P",
            "Q",
            "R",
            "S",
            "T",
            "U",
            "V",
            "W",
            "X",
            "Y",
            "Z",
            "bracketleft",
            "backslash",
            "bracketright",
            "asciicircum",
            "underscore",
            "quoteleft",
            "a",
            "b",
            "c",
            "d",
            "e",
            "f",
            "g",
            "h",
            "i",
            "j",
            "k",
            "l",
            "m",
            "n",
            "o",
            "p",
            "q",
            "r",
            "s",
            "t",
            "u",
            "v",
            "w",
            "x",
            "y",
            "z",
            "braceleft",
            "bar",
            "braceright",
            "asciitilde",
            "exclamdown",
            "cent",
            "sterling",
            "fraction",
            "yen",
            "florin",
            "section",
            "currency",
            "quotesingle",
            "quotedblleft",
            "guillemotleft",
            "guilsinglleft",
            "guilsinglright",
            "fi",
            "fl",
            "endash",
            "dagger",
            "daggerdbl",
            "periodcentered",
            "paragraph",
            "bullet",
            "quotesinglbase",
            "quotedblbase",
            "quotedblright",
            "guillemotright",
            "ellipsis",
            "perthousand",
            "questiondown",
            "grave",
            "acute",
            "circumflex",
            "tilde",
            "macron",
            "breve",
            "dotaccent",
            "dieresis",
            "ring",
            "cedilla",
            "hungarumlaut",
            "ogonek",
            "caron",
            "emdash",
            "AE",
            "ordfeminine",
            "Lslash",
            "Oslash",
            "OE",
            "ordmasculine",
            "ae",
            "dotlessi",
            "lslash",
            "oslash",
            "oe",
            "germandbls",
            "onesuperior",
            "logicalnot",
            "mu",
            "trademark",
            "Eth",
            "onehalf",
            "plusminus",
            "Thorn",
            "onequarter",
            "divide",
            "brokenbar",
            "degree",
            "thorn",
            "threequarters",
            "twosuperior",
            "registered",
            "minus",
            "eth",
            "multiply",
            "threesuperior",
            "copyright",
            "Aacute",
            "Acircumflex",
            "Adieresis",
            "Agrave",
            "Aring",
            "Atilde",
            "Ccedilla",
            "Eacute",
            "Ecircumflex",
            "Edieresis",
            "Egrave",
            "Iacute",
            "Icircumflex",
            "Idieresis",
            "Igrave",
            "Ntilde",
            "Oacute",
            "Ocircumflex",
            "Odieresis",
            "Ograve",
            "Otilde",
            "Scaron",
            "Uacute",
            "Ucircumflex",
            "Udieresis",
            "Ugrave",
            "Yacute",
            "Ydieresis",
            "Zcaron",
            "aacute",
            "acircumflex",
            "adieresis",
            "agrave",
            "aring",
            "atilde",
            "ccedilla",
            "eacute",
            "ecircumflex",
            "edieresis",
            "egrave",
            "iacute",
            "icircumflex",
            "idieresis",
            "igrave",
            "ntilde",
            "oacute",
            "ocircumflex",
            "odieresis",
            "ograve",
            "otilde",
            "scaron",
            "uacute",
            "ucircumflex",
            "udieresis",
            "ugrave",
            "yacute",
            "ydieresis",
            "zcaron",
          ];
          t.ExpertCharset = [
            ".notdef",
            "space",
            "exclamsmall",
            "Hungarumlautsmall",
            "dollaroldstyle",
            "dollarsuperior",
            "ampersandsmall",
            "Acutesmall",
            "parenleftsuperior",
            "parenrightsuperior",
            "twodotenleader",
            "onedotenleader",
            "comma",
            "hyphen",
            "period",
            "fraction",
            "zerooldstyle",
            "oneoldstyle",
            "twooldstyle",
            "threeoldstyle",
            "fouroldstyle",
            "fiveoldstyle",
            "sixoldstyle",
            "sevenoldstyle",
            "eightoldstyle",
            "nineoldstyle",
            "colon",
            "semicolon",
            "commasuperior",
            "threequartersemdash",
            "periodsuperior",
            "questionsmall",
            "asuperior",
            "bsuperior",
            "centsuperior",
            "dsuperior",
            "esuperior",
            "isuperior",
            "lsuperior",
            "msuperior",
            "nsuperior",
            "osuperior",
            "rsuperior",
            "ssuperior",
            "tsuperior",
            "ff",
            "fi",
            "fl",
            "ffi",
            "ffl",
            "parenleftinferior",
            "parenrightinferior",
            "Circumflexsmall",
            "hyphensuperior",
            "Gravesmall",
            "Asmall",
            "Bsmall",
            "Csmall",
            "Dsmall",
            "Esmall",
            "Fsmall",
            "Gsmall",
            "Hsmall",
            "Ismall",
            "Jsmall",
            "Ksmall",
            "Lsmall",
            "Msmall",
            "Nsmall",
            "Osmall",
            "Psmall",
            "Qsmall",
            "Rsmall",
            "Ssmall",
            "Tsmall",
            "Usmall",
            "Vsmall",
            "Wsmall",
            "Xsmall",
            "Ysmall",
            "Zsmall",
            "colonmonetary",
            "onefitted",
            "rupiah",
            "Tildesmall",
            "exclamdownsmall",
            "centoldstyle",
            "Lslashsmall",
            "Scaronsmall",
            "Zcaronsmall",
            "Dieresissmall",
            "Brevesmall",
            "Caronsmall",
            "Dotaccentsmall",
            "Macronsmall",
            "figuredash",
            "hypheninferior",
            "Ogoneksmall",
            "Ringsmall",
            "Cedillasmall",
            "onequarter",
            "onehalf",
            "threequarters",
            "questiondownsmall",
            "oneeighth",
            "threeeighths",
            "fiveeighths",
            "seveneighths",
            "onethird",
            "twothirds",
            "zerosuperior",
            "onesuperior",
            "twosuperior",
            "threesuperior",
            "foursuperior",
            "fivesuperior",
            "sixsuperior",
            "sevensuperior",
            "eightsuperior",
            "ninesuperior",
            "zeroinferior",
            "oneinferior",
            "twoinferior",
            "threeinferior",
            "fourinferior",
            "fiveinferior",
            "sixinferior",
            "seveninferior",
            "eightinferior",
            "nineinferior",
            "centinferior",
            "dollarinferior",
            "periodinferior",
            "commainferior",
            "Agravesmall",
            "Aacutesmall",
            "Acircumflexsmall",
            "Atildesmall",
            "Adieresissmall",
            "Aringsmall",
            "AEsmall",
            "Ccedillasmall",
            "Egravesmall",
            "Eacutesmall",
            "Ecircumflexsmall",
            "Edieresissmall",
            "Igravesmall",
            "Iacutesmall",
            "Icircumflexsmall",
            "Idieresissmall",
            "Ethsmall",
            "Ntildesmall",
            "Ogravesmall",
            "Oacutesmall",
            "Ocircumflexsmall",
            "Otildesmall",
            "Odieresissmall",
            "OEsmall",
            "Oslashsmall",
            "Ugravesmall",
            "Uacutesmall",
            "Ucircumflexsmall",
            "Udieresissmall",
            "Yacutesmall",
            "Thornsmall",
            "Ydieresissmall",
          ];
          t.ExpertSubsetCharset = [
            ".notdef",
            "space",
            "dollaroldstyle",
            "dollarsuperior",
            "parenleftsuperior",
            "parenrightsuperior",
            "twodotenleader",
            "onedotenleader",
            "comma",
            "hyphen",
            "period",
            "fraction",
            "zerooldstyle",
            "oneoldstyle",
            "twooldstyle",
            "threeoldstyle",
            "fouroldstyle",
            "fiveoldstyle",
            "sixoldstyle",
            "sevenoldstyle",
            "eightoldstyle",
            "nineoldstyle",
            "colon",
            "semicolon",
            "commasuperior",
            "threequartersemdash",
            "periodsuperior",
            "asuperior",
            "bsuperior",
            "centsuperior",
            "dsuperior",
            "esuperior",
            "isuperior",
            "lsuperior",
            "msuperior",
            "nsuperior",
            "osuperior",
            "rsuperior",
            "ssuperior",
            "tsuperior",
            "ff",
            "fi",
            "fl",
            "ffi",
            "ffl",
            "parenleftinferior",
            "parenrightinferior",
            "hyphensuperior",
            "colonmonetary",
            "onefitted",
            "rupiah",
            "centoldstyle",
            "figuredash",
            "hypheninferior",
            "onequarter",
            "onehalf",
            "threequarters",
            "oneeighth",
            "threeeighths",
            "fiveeighths",
            "seveneighths",
            "onethird",
            "twothirds",
            "zerosuperior",
            "onesuperior",
            "twosuperior",
            "threesuperior",
            "foursuperior",
            "fivesuperior",
            "sixsuperior",
            "sevensuperior",
            "eightsuperior",
            "ninesuperior",
            "zeroinferior",
            "oneinferior",
            "twoinferior",
            "threeinferior",
            "fourinferior",
            "fiveinferior",
            "sixinferior",
            "seveninferior",
            "eightinferior",
            "nineinferior",
            "centinferior",
            "dollarinferior",
            "periodinferior",
            "commainferior",
          ];
        },
        (e, t) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.ZapfDingbatsEncoding =
            t.WinAnsiEncoding =
            t.SymbolSetEncoding =
            t.StandardEncoding =
            t.MacRomanEncoding =
            t.ExpertEncoding =
              void 0;
          t.getEncoding = function getEncoding(e) {
            switch (e) {
              case "WinAnsiEncoding":
                return s;
              case "StandardEncoding":
                return i;
              case "MacRomanEncoding":
                return n;
              case "SymbolSetEncoding":
                return o;
              case "ZapfDingbatsEncoding":
                return c;
              case "ExpertEncoding":
                return a;
              case "MacExpertEncoding":
                return r;
              default:
                return null;
            }
          };
          const a = [
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "space",
            "exclamsmall",
            "Hungarumlautsmall",
            "",
            "dollaroldstyle",
            "dollarsuperior",
            "ampersandsmall",
            "Acutesmall",
            "parenleftsuperior",
            "parenrightsuperior",
            "twodotenleader",
            "onedotenleader",
            "comma",
            "hyphen",
            "period",
            "fraction",
            "zerooldstyle",
            "oneoldstyle",
            "twooldstyle",
            "threeoldstyle",
            "fouroldstyle",
            "fiveoldstyle",
            "sixoldstyle",
            "sevenoldstyle",
            "eightoldstyle",
            "nineoldstyle",
            "colon",
            "semicolon",
            "commasuperior",
            "threequartersemdash",
            "periodsuperior",
            "questionsmall",
            "",
            "asuperior",
            "bsuperior",
            "centsuperior",
            "dsuperior",
            "esuperior",
            "",
            "",
            "",
            "isuperior",
            "",
            "",
            "lsuperior",
            "msuperior",
            "nsuperior",
            "osuperior",
            "",
            "",
            "rsuperior",
            "ssuperior",
            "tsuperior",
            "",
            "ff",
            "fi",
            "fl",
            "ffi",
            "ffl",
            "parenleftinferior",
            "",
            "parenrightinferior",
            "Circumflexsmall",
            "hyphensuperior",
            "Gravesmall",
            "Asmall",
            "Bsmall",
            "Csmall",
            "Dsmall",
            "Esmall",
            "Fsmall",
            "Gsmall",
            "Hsmall",
            "Ismall",
            "Jsmall",
            "Ksmall",
            "Lsmall",
            "Msmall",
            "Nsmall",
            "Osmall",
            "Psmall",
            "Qsmall",
            "Rsmall",
            "Ssmall",
            "Tsmall",
            "Usmall",
            "Vsmall",
            "Wsmall",
            "Xsmall",
            "Ysmall",
            "Zsmall",
            "colonmonetary",
            "onefitted",
            "rupiah",
            "Tildesmall",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "exclamdownsmall",
            "centoldstyle",
            "Lslashsmall",
            "",
            "",
            "Scaronsmall",
            "Zcaronsmall",
            "Dieresissmall",
            "Brevesmall",
            "Caronsmall",
            "",
            "Dotaccentsmall",
            "",
            "",
            "Macronsmall",
            "",
            "",
            "figuredash",
            "hypheninferior",
            "",
            "",
            "Ogoneksmall",
            "Ringsmall",
            "Cedillasmall",
            "",
            "",
            "",
            "onequarter",
            "onehalf",
            "threequarters",
            "questiondownsmall",
            "oneeighth",
            "threeeighths",
            "fiveeighths",
            "seveneighths",
            "onethird",
            "twothirds",
            "",
            "",
            "zerosuperior",
            "onesuperior",
            "twosuperior",
            "threesuperior",
            "foursuperior",
            "fivesuperior",
            "sixsuperior",
            "sevensuperior",
            "eightsuperior",
            "ninesuperior",
            "zeroinferior",
            "oneinferior",
            "twoinferior",
            "threeinferior",
            "fourinferior",
            "fiveinferior",
            "sixinferior",
            "seveninferior",
            "eightinferior",
            "nineinferior",
            "centinferior",
            "dollarinferior",
            "periodinferior",
            "commainferior",
            "Agravesmall",
            "Aacutesmall",
            "Acircumflexsmall",
            "Atildesmall",
            "Adieresissmall",
            "Aringsmall",
            "AEsmall",
            "Ccedillasmall",
            "Egravesmall",
            "Eacutesmall",
            "Ecircumflexsmall",
            "Edieresissmall",
            "Igravesmall",
            "Iacutesmall",
            "Icircumflexsmall",
            "Idieresissmall",
            "Ethsmall",
            "Ntildesmall",
            "Ogravesmall",
            "Oacutesmall",
            "Ocircumflexsmall",
            "Otildesmall",
            "Odieresissmall",
            "OEsmall",
            "Oslashsmall",
            "Ugravesmall",
            "Uacutesmall",
            "Ucircumflexsmall",
            "Udieresissmall",
            "Yacutesmall",
            "Thornsmall",
            "Ydieresissmall",
          ];
          t.ExpertEncoding = a;
          const r = [
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "space",
              "exclamsmall",
              "Hungarumlautsmall",
              "centoldstyle",
              "dollaroldstyle",
              "dollarsuperior",
              "ampersandsmall",
              "Acutesmall",
              "parenleftsuperior",
              "parenrightsuperior",
              "twodotenleader",
              "onedotenleader",
              "comma",
              "hyphen",
              "period",
              "fraction",
              "zerooldstyle",
              "oneoldstyle",
              "twooldstyle",
              "threeoldstyle",
              "fouroldstyle",
              "fiveoldstyle",
              "sixoldstyle",
              "sevenoldstyle",
              "eightoldstyle",
              "nineoldstyle",
              "colon",
              "semicolon",
              "",
              "threequartersemdash",
              "",
              "questionsmall",
              "",
              "",
              "",
              "",
              "Ethsmall",
              "",
              "",
              "onequarter",
              "onehalf",
              "threequarters",
              "oneeighth",
              "threeeighths",
              "fiveeighths",
              "seveneighths",
              "onethird",
              "twothirds",
              "",
              "",
              "",
              "",
              "",
              "",
              "ff",
              "fi",
              "fl",
              "ffi",
              "ffl",
              "parenleftinferior",
              "",
              "parenrightinferior",
              "Circumflexsmall",
              "hypheninferior",
              "Gravesmall",
              "Asmall",
              "Bsmall",
              "Csmall",
              "Dsmall",
              "Esmall",
              "Fsmall",
              "Gsmall",
              "Hsmall",
              "Ismall",
              "Jsmall",
              "Ksmall",
              "Lsmall",
              "Msmall",
              "Nsmall",
              "Osmall",
              "Psmall",
              "Qsmall",
              "Rsmall",
              "Ssmall",
              "Tsmall",
              "Usmall",
              "Vsmall",
              "Wsmall",
              "Xsmall",
              "Ysmall",
              "Zsmall",
              "colonmonetary",
              "onefitted",
              "rupiah",
              "Tildesmall",
              "",
              "",
              "asuperior",
              "centsuperior",
              "",
              "",
              "",
              "",
              "Aacutesmall",
              "Agravesmall",
              "Acircumflexsmall",
              "Adieresissmall",
              "Atildesmall",
              "Aringsmall",
              "Ccedillasmall",
              "Eacutesmall",
              "Egravesmall",
              "Ecircumflexsmall",
              "Edieresissmall",
              "Iacutesmall",
              "Igravesmall",
              "Icircumflexsmall",
              "Idieresissmall",
              "Ntildesmall",
              "Oacutesmall",
              "Ogravesmall",
              "Ocircumflexsmall",
              "Odieresissmall",
              "Otildesmall",
              "Uacutesmall",
              "Ugravesmall",
              "Ucircumflexsmall",
              "Udieresissmall",
              "",
              "eightsuperior",
              "fourinferior",
              "threeinferior",
              "sixinferior",
              "eightinferior",
              "seveninferior",
              "Scaronsmall",
              "",
              "centinferior",
              "twoinferior",
              "",
              "Dieresissmall",
              "",
              "Caronsmall",
              "osuperior",
              "fiveinferior",
              "",
              "commainferior",
              "periodinferior",
              "Yacutesmall",
              "",
              "dollarinferior",
              "",
              "",
              "Thornsmall",
              "",
              "nineinferior",
              "zeroinferior",
              "Zcaronsmall",
              "AEsmall",
              "Oslashsmall",
              "questiondownsmall",
              "oneinferior",
              "Lslashsmall",
              "",
              "",
              "",
              "",
              "",
              "",
              "Cedillasmall",
              "",
              "",
              "",
              "",
              "",
              "OEsmall",
              "figuredash",
              "hyphensuperior",
              "",
              "",
              "",
              "",
              "exclamdownsmall",
              "",
              "Ydieresissmall",
              "",
              "onesuperior",
              "twosuperior",
              "threesuperior",
              "foursuperior",
              "fivesuperior",
              "sixsuperior",
              "sevensuperior",
              "ninesuperior",
              "zerosuperior",
              "",
              "esuperior",
              "rsuperior",
              "tsuperior",
              "",
              "",
              "isuperior",
              "ssuperior",
              "dsuperior",
              "",
              "",
              "",
              "",
              "",
              "lsuperior",
              "Ogoneksmall",
              "Brevesmall",
              "Macronsmall",
              "bsuperior",
              "nsuperior",
              "msuperior",
              "commasuperior",
              "periodsuperior",
              "Dotaccentsmall",
              "Ringsmall",
              "",
              "",
              "",
              "",
            ],
            n = [
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "",
              "space",
              "exclam",
              "quotedbl",
              "numbersign",
              "dollar",
              "percent",
              "ampersand",
              "quotesingle",
              "parenleft",
              "parenright",
              "asterisk",
              "plus",
              "comma",
              "hyphen",
              "period",
              "slash",
              "zero",
              "one",
              "two",
              "three",
              "four",
              "five",
              "six",
              "seven",
              "eight",
              "nine",
              "colon",
              "semicolon",
              "less",
              "equal",
              "greater",
              "question",
              "at",
              "A",
              "B",
              "C",
              "D",
              "E",
              "F",
              "G",
              "H",
              "I",
              "J",
              "K",
              "L",
              "M",
              "N",
              "O",
              "P",
              "Q",
              "R",
              "S",
              "T",
              "U",
              "V",
              "W",
              "X",
              "Y",
              "Z",
              "bracketleft",
              "backslash",
              "bracketright",
              "asciicircum",
              "underscore",
              "grave",
              "a",
              "b",
              "c",
              "d",
              "e",
              "f",
              "g",
              "h",
              "i",
              "j",
              "k",
              "l",
              "m",
              "n",
              "o",
              "p",
              "q",
              "r",
              "s",
              "t",
              "u",
              "v",
              "w",
              "x",
              "y",
              "z",
              "braceleft",
              "bar",
              "braceright",
              "asciitilde",
              "",
              "Adieresis",
              "Aring",
              "Ccedilla",
              "Eacute",
              "Ntilde",
              "Odieresis",
              "Udieresis",
              "aacute",
              "agrave",
              "acircumflex",
              "adieresis",
              "atilde",
              "aring",
              "ccedilla",
              "eacute",
              "egrave",
              "ecircumflex",
              "edieresis",
              "iacute",
              "igrave",
              "icircumflex",
              "idieresis",
              "ntilde",
              "oacute",
              "ograve",
              "ocircumflex",
              "odieresis",
              "otilde",
              "uacute",
              "ugrave",
              "ucircumflex",
              "udieresis",
              "dagger",
              "degree",
              "cent",
              "sterling",
              "section",
              "bullet",
              "paragraph",
              "germandbls",
              "registered",
              "copyright",
              "trademark",
              "acute",
              "dieresis",
              "notequal",
              "AE",
              "Oslash",
              "infinity",
              "plusminus",
              "lessequal",
              "greaterequal",
              "yen",
              "mu",
              "partialdiff",
              "summation",
              "product",
              "pi",
              "integral",
              "ordfeminine",
              "ordmasculine",
              "Omega",
              "ae",
              "oslash",
              "questiondown",
              "exclamdown",
              "logicalnot",
              "radical",
              "florin",
              "approxequal",
              "Delta",
              "guillemotleft",
              "guillemotright",
              "ellipsis",
              "space",
              "Agrave",
              "Atilde",
              "Otilde",
              "OE",
              "oe",
              "endash",
              "emdash",
              "quotedblleft",
              "quotedblright",
              "quoteleft",
              "quoteright",
              "divide",
              "lozenge",
              "ydieresis",
              "Ydieresis",
              "fraction",
              "currency",
              "guilsinglleft",
              "guilsinglright",
              "fi",
              "fl",
              "daggerdbl",
              "periodcentered",
              "quotesinglbase",
              "quotedblbase",
              "perthousand",
              "Acircumflex",
              "Ecircumflex",
              "Aacute",
              "Edieresis",
              "Egrave",
              "Iacute",
              "Icircumflex",
              "Idieresis",
              "Igrave",
              "Oacute",
              "Ocircumflex",
              "apple",
              "Ograve",
              "Uacute",
              "Ucircumflex",
              "Ugrave",
              "dotlessi",
              "circumflex",
              "tilde",
              "macron",
              "breve",
              "dotaccent",
              "ring",
              "cedilla",
              "hungarumlaut",
              "ogonek",
              "caron",
            ];
          t.MacRomanEncoding = n;
          const i = [
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "space",
            "exclam",
            "quotedbl",
            "numbersign",
            "dollar",
            "percent",
            "ampersand",
            "quoteright",
            "parenleft",
            "parenright",
            "asterisk",
            "plus",
            "comma",
            "hyphen",
            "period",
            "slash",
            "zero",
            "one",
            "two",
            "three",
            "four",
            "five",
            "six",
            "seven",
            "eight",
            "nine",
            "colon",
            "semicolon",
            "less",
            "equal",
            "greater",
            "question",
            "at",
            "A",
            "B",
            "C",
            "D",
            "E",
            "F",
            "G",
            "H",
            "I",
            "J",
            "K",
            "L",
            "M",
            "N",
            "O",
            "P",
            "Q",
            "R",
            "S",
            "T",
            "U",
            "V",
            "W",
            "X",
            "Y",
            "Z",
            "bracketleft",
            "backslash",
            "bracketright",
            "asciicircum",
            "underscore",
            "quoteleft",
            "a",
            "b",
            "c",
            "d",
            "e",
            "f",
            "g",
            "h",
            "i",
            "j",
            "k",
            "l",
            "m",
            "n",
            "o",
            "p",
            "q",
            "r",
            "s",
            "t",
            "u",
            "v",
            "w",
            "x",
            "y",
            "z",
            "braceleft",
            "bar",
            "braceright",
            "asciitilde",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "exclamdown",
            "cent",
            "sterling",
            "fraction",
            "yen",
            "florin",
            "section",
            "currency",
            "quotesingle",
            "quotedblleft",
            "guillemotleft",
            "guilsinglleft",
            "guilsinglright",
            "fi",
            "fl",
            "",
            "endash",
            "dagger",
            "daggerdbl",
            "periodcentered",
            "",
            "paragraph",
            "bullet",
            "quotesinglbase",
            "quotedblbase",
            "quotedblright",
            "guillemotright",
            "ellipsis",
            "perthousand",
            "",
            "questiondown",
            "",
            "grave",
            "acute",
            "circumflex",
            "tilde",
            "macron",
            "breve",
            "dotaccent",
            "dieresis",
            "",
            "ring",
            "cedilla",
            "",
            "hungarumlaut",
            "ogonek",
            "caron",
            "emdash",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "AE",
            "",
            "ordfeminine",
            "",
            "",
            "",
            "",
            "Lslash",
            "Oslash",
            "OE",
            "ordmasculine",
            "",
            "",
            "",
            "",
            "",
            "ae",
            "",
            "",
            "",
            "dotlessi",
            "",
            "",
            "lslash",
            "oslash",
            "oe",
            "germandbls",
            "",
            "",
            "",
            "",
          ];
          t.StandardEncoding = i;
          const s = [
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "space",
            "exclam",
            "quotedbl",
            "numbersign",
            "dollar",
            "percent",
            "ampersand",
            "quotesingle",
            "parenleft",
            "parenright",
            "asterisk",
            "plus",
            "comma",
            "hyphen",
            "period",
            "slash",
            "zero",
            "one",
            "two",
            "three",
            "four",
            "five",
            "six",
            "seven",
            "eight",
            "nine",
            "colon",
            "semicolon",
            "less",
            "equal",
            "greater",
            "question",
            "at",
            "A",
            "B",
            "C",
            "D",
            "E",
            "F",
            "G",
            "H",
            "I",
            "J",
            "K",
            "L",
            "M",
            "N",
            "O",
            "P",
            "Q",
            "R",
            "S",
            "T",
            "U",
            "V",
            "W",
            "X",
            "Y",
            "Z",
            "bracketleft",
            "backslash",
            "bracketright",
            "asciicircum",
            "underscore",
            "grave",
            "a",
            "b",
            "c",
            "d",
            "e",
            "f",
            "g",
            "h",
            "i",
            "j",
            "k",
            "l",
            "m",
            "n",
            "o",
            "p",
            "q",
            "r",
            "s",
            "t",
            "u",
            "v",
            "w",
            "x",
            "y",
            "z",
            "braceleft",
            "bar",
            "braceright",
            "asciitilde",
            "bullet",
            "Euro",
            "bullet",
            "quotesinglbase",
            "florin",
            "quotedblbase",
            "ellipsis",
            "dagger",
            "daggerdbl",
            "circumflex",
            "perthousand",
            "Scaron",
            "guilsinglleft",
            "OE",
            "bullet",
            "Zcaron",
            "bullet",
            "bullet",
            "quoteleft",
            "quoteright",
            "quotedblleft",
            "quotedblright",
            "bullet",
            "endash",
            "emdash",
            "tilde",
            "trademark",
            "scaron",
            "guilsinglright",
            "oe",
            "bullet",
            "zcaron",
            "Ydieresis",
            "space",
            "exclamdown",
            "cent",
            "sterling",
            "currency",
            "yen",
            "brokenbar",
            "section",
            "dieresis",
            "copyright",
            "ordfeminine",
            "guillemotleft",
            "logicalnot",
            "hyphen",
            "registered",
            "macron",
            "degree",
            "plusminus",
            "twosuperior",
            "threesuperior",
            "acute",
            "mu",
            "paragraph",
            "periodcentered",
            "cedilla",
            "onesuperior",
            "ordmasculine",
            "guillemotright",
            "onequarter",
            "onehalf",
            "threequarters",
            "questiondown",
            "Agrave",
            "Aacute",
            "Acircumflex",
            "Atilde",
            "Adieresis",
            "Aring",
            "AE",
            "Ccedilla",
            "Egrave",
            "Eacute",
            "Ecircumflex",
            "Edieresis",
            "Igrave",
            "Iacute",
            "Icircumflex",
            "Idieresis",
            "Eth",
            "Ntilde",
            "Ograve",
            "Oacute",
            "Ocircumflex",
            "Otilde",
            "Odieresis",
            "multiply",
            "Oslash",
            "Ugrave",
            "Uacute",
            "Ucircumflex",
            "Udieresis",
            "Yacute",
            "Thorn",
            "germandbls",
            "agrave",
            "aacute",
            "acircumflex",
            "atilde",
            "adieresis",
            "aring",
            "ae",
            "ccedilla",
            "egrave",
            "eacute",
            "ecircumflex",
            "edieresis",
            "igrave",
            "iacute",
            "icircumflex",
            "idieresis",
            "eth",
            "ntilde",
            "ograve",
            "oacute",
            "ocircumflex",
            "otilde",
            "odieresis",
            "divide",
            "oslash",
            "ugrave",
            "uacute",
            "ucircumflex",
            "udieresis",
            "yacute",
            "thorn",
            "ydieresis",
          ];
          t.WinAnsiEncoding = s;
          const o = [
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "space",
            "exclam",
            "universal",
            "numbersign",
            "existential",
            "percent",
            "ampersand",
            "suchthat",
            "parenleft",
            "parenright",
            "asteriskmath",
            "plus",
            "comma",
            "minus",
            "period",
            "slash",
            "zero",
            "one",
            "two",
            "three",
            "four",
            "five",
            "six",
            "seven",
            "eight",
            "nine",
            "colon",
            "semicolon",
            "less",
            "equal",
            "greater",
            "question",
            "congruent",
            "Alpha",
            "Beta",
            "Chi",
            "Delta",
            "Epsilon",
            "Phi",
            "Gamma",
            "Eta",
            "Iota",
            "theta1",
            "Kappa",
            "Lambda",
            "Mu",
            "Nu",
            "Omicron",
            "Pi",
            "Theta",
            "Rho",
            "Sigma",
            "Tau",
            "Upsilon",
            "sigma1",
            "Omega",
            "Xi",
            "Psi",
            "Zeta",
            "bracketleft",
            "therefore",
            "bracketright",
            "perpendicular",
            "underscore",
            "radicalex",
            "alpha",
            "beta",
            "chi",
            "delta",
            "epsilon",
            "phi",
            "gamma",
            "eta",
            "iota",
            "phi1",
            "kappa",
            "lambda",
            "mu",
            "nu",
            "omicron",
            "pi",
            "theta",
            "rho",
            "sigma",
            "tau",
            "upsilon",
            "omega1",
            "omega",
            "xi",
            "psi",
            "zeta",
            "braceleft",
            "bar",
            "braceright",
            "similar",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "Euro",
            "Upsilon1",
            "minute",
            "lessequal",
            "fraction",
            "infinity",
            "florin",
            "club",
            "diamond",
            "heart",
            "spade",
            "arrowboth",
            "arrowleft",
            "arrowup",
            "arrowright",
            "arrowdown",
            "degree",
            "plusminus",
            "second",
            "greaterequal",
            "multiply",
            "proportional",
            "partialdiff",
            "bullet",
            "divide",
            "notequal",
            "equivalence",
            "approxequal",
            "ellipsis",
            "arrowvertex",
            "arrowhorizex",
            "carriagereturn",
            "aleph",
            "Ifraktur",
            "Rfraktur",
            "weierstrass",
            "circlemultiply",
            "circleplus",
            "emptyset",
            "intersection",
            "union",
            "propersuperset",
            "reflexsuperset",
            "notsubset",
            "propersubset",
            "reflexsubset",
            "element",
            "notelement",
            "angle",
            "gradient",
            "registerserif",
            "copyrightserif",
            "trademarkserif",
            "product",
            "radical",
            "dotmath",
            "logicalnot",
            "logicaland",
            "logicalor",
            "arrowdblboth",
            "arrowdblleft",
            "arrowdblup",
            "arrowdblright",
            "arrowdbldown",
            "lozenge",
            "angleleft",
            "registersans",
            "copyrightsans",
            "trademarksans",
            "summation",
            "parenlefttp",
            "parenleftex",
            "parenleftbt",
            "bracketlefttp",
            "bracketleftex",
            "bracketleftbt",
            "bracelefttp",
            "braceleftmid",
            "braceleftbt",
            "braceex",
            "",
            "angleright",
            "integral",
            "integraltp",
            "integralex",
            "integralbt",
            "parenrighttp",
            "parenrightex",
            "parenrightbt",
            "bracketrighttp",
            "bracketrightex",
            "bracketrightbt",
            "bracerighttp",
            "bracerightmid",
            "bracerightbt",
            "",
          ];
          t.SymbolSetEncoding = o;
          const c = [
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "space",
            "a1",
            "a2",
            "a202",
            "a3",
            "a4",
            "a5",
            "a119",
            "a118",
            "a117",
            "a11",
            "a12",
            "a13",
            "a14",
            "a15",
            "a16",
            "a105",
            "a17",
            "a18",
            "a19",
            "a20",
            "a21",
            "a22",
            "a23",
            "a24",
            "a25",
            "a26",
            "a27",
            "a28",
            "a6",
            "a7",
            "a8",
            "a9",
            "a10",
            "a29",
            "a30",
            "a31",
            "a32",
            "a33",
            "a34",
            "a35",
            "a36",
            "a37",
            "a38",
            "a39",
            "a40",
            "a41",
            "a42",
            "a43",
            "a44",
            "a45",
            "a46",
            "a47",
            "a48",
            "a49",
            "a50",
            "a51",
            "a52",
            "a53",
            "a54",
            "a55",
            "a56",
            "a57",
            "a58",
            "a59",
            "a60",
            "a61",
            "a62",
            "a63",
            "a64",
            "a65",
            "a66",
            "a67",
            "a68",
            "a69",
            "a70",
            "a71",
            "a72",
            "a73",
            "a74",
            "a203",
            "a75",
            "a204",
            "a76",
            "a77",
            "a78",
            "a79",
            "a81",
            "a82",
            "a83",
            "a84",
            "a97",
            "a98",
            "a99",
            "a100",
            "",
            "a89",
            "a90",
            "a93",
            "a94",
            "a91",
            "a92",
            "a205",
            "a85",
            "a206",
            "a86",
            "a87",
            "a88",
            "a95",
            "a96",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "a101",
            "a102",
            "a103",
            "a104",
            "a106",
            "a107",
            "a108",
            "a112",
            "a111",
            "a110",
            "a109",
            "a120",
            "a121",
            "a122",
            "a123",
            "a124",
            "a125",
            "a126",
            "a127",
            "a128",
            "a129",
            "a130",
            "a131",
            "a132",
            "a133",
            "a134",
            "a135",
            "a136",
            "a137",
            "a138",
            "a139",
            "a140",
            "a141",
            "a142",
            "a143",
            "a144",
            "a145",
            "a146",
            "a147",
            "a148",
            "a149",
            "a150",
            "a151",
            "a152",
            "a153",
            "a154",
            "a155",
            "a156",
            "a157",
            "a158",
            "a159",
            "a160",
            "a161",
            "a163",
            "a164",
            "a196",
            "a165",
            "a192",
            "a166",
            "a167",
            "a168",
            "a169",
            "a170",
            "a171",
            "a172",
            "a173",
            "a162",
            "a174",
            "a175",
            "a176",
            "a177",
            "a178",
            "a179",
            "a193",
            "a180",
            "a199",
            "a181",
            "a200",
            "a182",
            "",
            "a201",
            "a183",
            "a184",
            "a197",
            "a185",
            "a194",
            "a198",
            "a186",
            "a195",
            "a187",
            "a188",
            "a189",
            "a190",
            "a191",
            "",
          ];
          t.ZapfDingbatsEncoding = c;
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.SEAC_ANALYSIS_ENABLED =
            t.MacStandardGlyphOrdering =
            t.FontFlags =
              void 0;
          t.normalizeFontName = function normalizeFontName(e) {
            return e.replaceAll(/[,_]/g, "-").replaceAll(/\s/g, "");
          };
          t.recoverGlyphName = recoverGlyphName;
          t.type1FontGlyphMapping = function type1FontGlyphMapping(e, t, a) {
            const i = Object.create(null);
            let s, c, l;
            const h = !!(e.flags & o.Symbolic);
            if (e.isInternalFont) {
              l = t;
              for (c = 0; c < l.length; c++) {
                s = a.indexOf(l[c]);
                i[c] = s >= 0 ? s : 0;
              }
            } else if (e.baseEncodingName) {
              l = (0, r.getEncoding)(e.baseEncodingName);
              for (c = 0; c < l.length; c++) {
                s = a.indexOf(l[c]);
                i[c] = s >= 0 ? s : 0;
              }
            } else if (h) for (c in t) i[c] = t[c];
            else {
              l = r.StandardEncoding;
              for (c = 0; c < l.length; c++) {
                s = a.indexOf(l[c]);
                i[c] = s >= 0 ? s : 0;
              }
            }
            const u = e.differences;
            let d;
            if (u)
              for (c in u) {
                const e = u[c];
                s = a.indexOf(e);
                if (-1 === s) {
                  d || (d = (0, n.getGlyphsUnicode)());
                  const t = recoverGlyphName(e, d);
                  t !== e && (s = a.indexOf(t));
                }
                i[c] = s >= 0 ? s : 0;
              }
            return i;
          };
          var r = a(37),
            n = a(39),
            i = a(40),
            s = a(2);
          t.SEAC_ANALYSIS_ENABLED = !0;
          const o = {
            FixedPitch: 1,
            Serif: 2,
            Symbolic: 4,
            Script: 8,
            Nonsymbolic: 32,
            Italic: 64,
            AllCap: 65536,
            SmallCap: 131072,
            ForceBold: 262144,
          };
          t.FontFlags = o;
          t.MacStandardGlyphOrdering = [
            ".notdef",
            ".null",
            "nonmarkingreturn",
            "space",
            "exclam",
            "quotedbl",
            "numbersign",
            "dollar",
            "percent",
            "ampersand",
            "quotesingle",
            "parenleft",
            "parenright",
            "asterisk",
            "plus",
            "comma",
            "hyphen",
            "period",
            "slash",
            "zero",
            "one",
            "two",
            "three",
            "four",
            "five",
            "six",
            "seven",
            "eight",
            "nine",
            "colon",
            "semicolon",
            "less",
            "equal",
            "greater",
            "question",
            "at",
            "A",
            "B",
            "C",
            "D",
            "E",
            "F",
            "G",
            "H",
            "I",
            "J",
            "K",
            "L",
            "M",
            "N",
            "O",
            "P",
            "Q",
            "R",
            "S",
            "T",
            "U",
            "V",
            "W",
            "X",
            "Y",
            "Z",
            "bracketleft",
            "backslash",
            "bracketright",
            "asciicircum",
            "underscore",
            "grave",
            "a",
            "b",
            "c",
            "d",
            "e",
            "f",
            "g",
            "h",
            "i",
            "j",
            "k",
            "l",
            "m",
            "n",
            "o",
            "p",
            "q",
            "r",
            "s",
            "t",
            "u",
            "v",
            "w",
            "x",
            "y",
            "z",
            "braceleft",
            "bar",
            "braceright",
            "asciitilde",
            "Adieresis",
            "Aring",
            "Ccedilla",
            "Eacute",
            "Ntilde",
            "Odieresis",
            "Udieresis",
            "aacute",
            "agrave",
            "acircumflex",
            "adieresis",
            "atilde",
            "aring",
            "ccedilla",
            "eacute",
            "egrave",
            "ecircumflex",
            "edieresis",
            "iacute",
            "igrave",
            "icircumflex",
            "idieresis",
            "ntilde",
            "oacute",
            "ograve",
            "ocircumflex",
            "odieresis",
            "otilde",
            "uacute",
            "ugrave",
            "ucircumflex",
            "udieresis",
            "dagger",
            "degree",
            "cent",
            "sterling",
            "section",
            "bullet",
            "paragraph",
            "germandbls",
            "registered",
            "copyright",
            "trademark",
            "acute",
            "dieresis",
            "notequal",
            "AE",
            "Oslash",
            "infinity",
            "plusminus",
            "lessequal",
            "greaterequal",
            "yen",
            "mu",
            "partialdiff",
            "summation",
            "product",
            "pi",
            "integral",
            "ordfeminine",
            "ordmasculine",
            "Omega",
            "ae",
            "oslash",
            "questiondown",
            "exclamdown",
            "logicalnot",
            "radical",
            "florin",
            "approxequal",
            "Delta",
            "guillemotleft",
            "guillemotright",
            "ellipsis",
            "nonbreakingspace",
            "Agrave",
            "Atilde",
            "Otilde",
            "OE",
            "oe",
            "endash",
            "emdash",
            "quotedblleft",
            "quotedblright",
            "quoteleft",
            "quoteright",
            "divide",
            "lozenge",
            "ydieresis",
            "Ydieresis",
            "fraction",
            "currency",
            "guilsinglleft",
            "guilsinglright",
            "fi",
            "fl",
            "daggerdbl",
            "periodcentered",
            "quotesinglbase",
            "quotedblbase",
            "perthousand",
            "Acircumflex",
            "Ecircumflex",
            "Aacute",
            "Edieresis",
            "Egrave",
            "Iacute",
            "Icircumflex",
            "Idieresis",
            "Igrave",
            "Oacute",
            "Ocircumflex",
            "apple",
            "Ograve",
            "Uacute",
            "Ucircumflex",
            "Ugrave",
            "dotlessi",
            "circumflex",
            "tilde",
            "macron",
            "breve",
            "dotaccent",
            "ring",
            "cedilla",
            "hungarumlaut",
            "ogonek",
            "caron",
            "Lslash",
            "lslash",
            "Scaron",
            "scaron",
            "Zcaron",
            "zcaron",
            "brokenbar",
            "Eth",
            "eth",
            "Yacute",
            "yacute",
            "Thorn",
            "thorn",
            "minus",
            "multiply",
            "onesuperior",
            "twosuperior",
            "threesuperior",
            "onehalf",
            "onequarter",
            "threequarters",
            "franc",
            "Gbreve",
            "gbreve",
            "Idotaccent",
            "Scedilla",
            "scedilla",
            "Cacute",
            "cacute",
            "Ccaron",
            "ccaron",
            "dcroat",
          ];
          function recoverGlyphName(e, t) {
            if (void 0 !== t[e]) return e;
            const a = (0, i.getUnicodeForGlyph)(e, t);
            if (-1 !== a) for (const e in t) if (t[e] === a) return e;
            (0, s.info)("Unable to recover a standard glyph name for: " + e);
            return e;
          }
        },
        (e, t, a) => {
          Object.defineProperty(t, "__esModule", { value: !0 });
          t.getGlyphsUnicode = t.getDingbatsGlyphsUnicode = void 0;
          var r = a(3);
          const n = (0, r.getLookupTableFactory)(function (e) {
            e.A = 65;
            e.AE = 198;
            e.AEacute = 508;
            e.AEmacron = 482;
            e.AEsmall = 63462;
            e.Aacute = 193;
            e.Aacutesmall = 63457;
            e.Abreve = 258;
            e.Abreveacute = 7854;
            e.Abrevecyrillic = 1232;
            e.Abrevedotbelow = 7862;
            e.Abrevegrave = 7856;
            e.Abrevehookabove = 7858;
            e.Abrevetilde = 7860;
            e.Acaron = 461;
            e.Acircle = 9398;
            e.Acircumflex = 194;
            e.Acircumflexacute = 7844;
            e.Acircumflexdotbelow = 7852;
            e.Acircumflexgrave = 7846;
            e.Acircumflexhookabove = 7848;
            e.Acircumflexsmall = 63458;
            e.Acircumflextilde = 7850;
            e.Acute = 63177;
            e.Acutesmall = 63412;
            e.Acyrillic = 1040;
            e.Adblgrave = 512;
            e.Adieresis = 196;
            e.Adieresiscyrillic = 1234;
            e.Adieresismacron = 478;
            e.Adieresissmall = 63460;
            e.Adotbelow = 7840;
            e.Adotmacron = 480;
            e.Agrave = 192;
            e.Agravesmall = 63456;
            e.Ahookabove = 7842;
            e.Aiecyrillic = 1236;
            e.Ainvertedbreve = 514;
            e.Alpha = 913;
            e.Alphatonos = 902;
            e.Amacron = 256;
            e.Amonospace = 65313;
            e.Aogonek = 260;
            e.Aring = 197;
            e.Aringacute = 506;
            e.Aringbelow = 7680;
            e.Aringsmall = 63461;
            e.Asmall = 63329;
            e.Atilde = 195;
            e.Atildesmall = 63459;
            e.Aybarmenian = 1329;
            e.B = 66;
            e.Bcircle = 9399;
            e.Bdotaccent = 7682;
            e.Bdotbelow = 7684;
            e.Becyrillic = 1041;
            e.Benarmenian = 1330;
            e.Beta = 914;
            e.Bhook = 385;
            e.Blinebelow = 7686;
            e.Bmonospace = 65314;
            e.Brevesmall = 63220;
            e.Bsmall = 63330;
            e.Btopbar = 386;
            e.C = 67;
            e.Caarmenian = 1342;
            e.Cacute = 262;
            e.Caron = 63178;
            e.Caronsmall = 63221;
            e.Ccaron = 268;
            e.Ccedilla = 199;
            e.Ccedillaacute = 7688;
            e.Ccedillasmall = 63463;
            e.Ccircle = 9400;
            e.Ccircumflex = 264;
            e.Cdot = 266;
            e.Cdotaccent = 266;
            e.Cedillasmall = 63416;
            e.Chaarmenian = 1353;
            e.Cheabkhasiancyrillic = 1212;
            e.Checyrillic = 1063;
            e.Chedescenderabkhasiancyrillic = 1214;
            e.Chedescendercyrillic = 1206;
            e.Chedieresiscyrillic = 1268;
            e.Cheharmenian = 1347;
            e.Chekhakassiancyrillic = 1227;
            e.Cheverticalstrokecyrillic = 1208;
            e.Chi = 935;
            e.Chook = 391;
            e.Circumflexsmall = 63222;
            e.Cmonospace = 65315;
            e.Coarmenian = 1361;
            e.Csmall = 63331;
            e.D = 68;
            e.DZ = 497;
            e.DZcaron = 452;
            e.Daarmenian = 1332;
            e.Dafrican = 393;
            e.Dcaron = 270;
            e.Dcedilla = 7696;
            e.Dcircle = 9401;
            e.Dcircumflexbelow = 7698;
            e.Dcroat = 272;
            e.Ddotaccent = 7690;
            e.Ddotbelow = 7692;
            e.Decyrillic = 1044;
            e.Deicoptic = 1006;
            e.Delta = 8710;
            e.Deltagreek = 916;
            e.Dhook = 394;
            e.Dieresis = 63179;
            e.DieresisAcute = 63180;
            e.DieresisGrave = 63181;
            e.Dieresissmall = 63400;
            e.Digammagreek = 988;
            e.Djecyrillic = 1026;
            e.Dlinebelow = 7694;
            e.Dmonospace = 65316;
            e.Dotaccentsmall = 63223;
            e.Dslash = 272;
            e.Dsmall = 63332;
            e.Dtopbar = 395;
            e.Dz = 498;
            e.Dzcaron = 453;
            e.Dzeabkhasiancyrillic = 1248;
            e.Dzecyrillic = 1029;
            e.Dzhecyrillic = 1039;
            e.E = 69;
            e.Eacute = 201;
            e.Eacutesmall = 63465;
            e.Ebreve = 276;
            e.Ecaron = 282;
            e.Ecedillabreve = 7708;
            e.Echarmenian = 1333;
            e.Ecircle = 9402;
            e.Ecircumflex = 202;
            e.Ecircumflexacute = 7870;
            e.Ecircumflexbelow = 7704;
            e.Ecircumflexdotbelow = 7878;
            e.Ecircumflexgrave = 7872;
            e.Ecircumflexhookabove = 7874;
            e.Ecircumflexsmall = 63466;
            e.Ecircumflextilde = 7876;
            e.Ecyrillic = 1028;
            e.Edblgrave = 516;
            e.Edieresis = 203;
            e.Edieresissmall = 63467;
            e.Edot = 278;
            e.Edotaccent = 278;
            e.Edotbelow = 7864;
            e.Efcyrillic = 1060;
            e.Egrave = 200;
            e.Egravesmall = 63464;
            e.Eharmenian = 1335;
            e.Ehookabove = 7866;
            e.Eightroman = 8551;
            e.Einvertedbreve = 518;
            e.Eiotifiedcyrillic = 1124;
            e.Elcyrillic = 1051;
            e.Elevenroman = 8554;
            e.Emacron = 274;
            e.Emacronacute = 7702;
            e.Emacrongrave = 7700;
            e.Emcyrillic = 1052;
            e.Emonospace = 65317;
            e.Encyrillic = 1053;
            e.Endescendercyrillic = 1186;
            e.Eng = 330;
            e.Enghecyrillic = 1188;
            e.Enhookcyrillic = 1223;
            e.Eogonek = 280;
            e.Eopen = 400;
            e.Epsilon = 917;
            e.Epsilontonos = 904;
            e.Ercyrillic = 1056;
            e.Ereversed = 398;
            e.Ereversedcyrillic = 1069;
            e.Escyrillic = 1057;
            e.Esdescendercyrillic = 1194;
            e.Esh = 425;
            e.Esmall = 63333;
            e.Eta = 919;
            e.Etarmenian = 1336;
            e.Etatonos = 905;
            e.Eth = 208;
            e.Ethsmall = 63472;
            e.Etilde = 7868;
            e.Etildebelow = 7706;
            e.Euro = 8364;
            e.Ezh = 439;
            e.Ezhcaron = 494;
            e.Ezhreversed = 440;
            e.F = 70;
            e.Fcircle = 9403;
            e.Fdotaccent = 7710;
            e.Feharmenian = 1366;
            e.Feicoptic = 996;
            e.Fhook = 401;
            e.Fitacyrillic = 1138;
            e.Fiveroman = 8548;
            e.Fmonospace = 65318;
            e.Fourroman = 8547;
            e.Fsmall = 63334;
            e.G = 71;
            e.GBsquare = 13191;
            e.Gacute = 500;
            e.Gamma = 915;
            e.Gammaafrican = 404;
            e.Gangiacoptic = 1002;
            e.Gbreve = 286;
            e.Gcaron = 486;
            e.Gcedilla = 290;
            e.Gcircle = 9404;
            e.Gcircumflex = 284;
            e.Gcommaaccent = 290;
            e.Gdot = 288;
            e.Gdotaccent = 288;
            e.Gecyrillic = 1043;
            e.Ghadarmenian = 1346;
            e.Ghemiddlehookcyrillic = 1172;
            e.Ghestrokecyrillic = 1170;
            e.Gheupturncyrillic = 1168;
            e.Ghook = 403;
            e.Gimarmenian = 1331;
            e.Gjecyrillic = 1027;
            e.Gmacron = 7712;
            e.Gmonospace = 65319;
            e.Grave = 63182;
            e.Gravesmall = 63328;
            e.Gsmall = 63335;
            e.Gsmallhook = 667;
            e.Gstroke = 484;
            e.H = 72;
            e.H18533 = 9679;
            e.H18543 = 9642;
            e.H18551 = 9643;
            e.H22073 = 9633;
            e.HPsquare = 13259;
            e.Haabkhasiancyrillic = 1192;
            e.Hadescendercyrillic = 1202;
            e.Hardsigncyrillic = 1066;
            e.Hbar = 294;
            e.Hbrevebelow = 7722;
            e.Hcedilla = 7720;
            e.Hcircle = 9405;
            e.Hcircumflex = 292;
            e.Hdieresis = 7718;
            e.Hdotaccent = 7714;
            e.Hdotbelow = 7716;
            e.Hmonospace = 65320;
            e.Hoarmenian = 1344;
            e.Horicoptic = 1e3;
            e.Hsmall = 63336;
            e.Hungarumlaut = 63183;
            e.Hungarumlautsmall = 63224;
            e.Hzsquare = 13200;
            e.I = 73;
            e.IAcyrillic = 1071;
            e.IJ = 306;
            e.IUcyrillic = 1070;
            e.Iacute = 205;
            e.Iacutesmall = 63469;
            e.Ibreve = 300;
            e.Icaron = 463;
            e.Icircle = 9406;
            e.Icircumflex = 206;
            e.Icircumflexsmall = 63470;
            e.Icyrillic = 1030;
            e.Idblgrave = 520;
            e.Idieresis = 207;
            e.Idieresisacute = 7726;
            e.Idieresiscyrillic = 1252;
            e.Idieresissmall = 63471;
            e.Idot = 304;
            e.Idotaccent = 304;
            e.Idotbelow = 7882;
            e.Iebrevecyrillic = 1238;
            e.Iecyrillic = 1045;
            e.Ifraktur = 8465;
            e.Igrave = 204;
            e.Igravesmall = 63468;
            e.Ihookabove = 7880;
            e.Iicyrillic = 1048;
            e.Iinvertedbreve = 522;
            e.Iishortcyrillic = 1049;
            e.Imacron = 298;
            e.Imacroncyrillic = 1250;
            e.Imonospace = 65321;
            e.Iniarmenian = 1339;
            e.Iocyrillic = 1025;
            e.Iogonek = 302;
            e.Iota = 921;
            e.Iotaafrican = 406;
            e.Iotadieresis = 938;
            e.Iotatonos = 906;
            e.Ismall = 63337;
            e.Istroke = 407;
            e.Itilde = 296;
            e.Itildebelow = 7724;
            e.Izhitsacyrillic = 1140;
            e.Izhitsadblgravecyrillic = 1142;
            e.J = 74;
            e.Jaarmenian = 1345;
            e.Jcircle = 9407;
            e.Jcircumflex = 308;
            e.Jecyrillic = 1032;
            e.Jheharmenian = 1355;
            e.Jmonospace = 65322;
            e.Jsmall = 63338;
            e.K = 75;
            e.KBsquare = 13189;
            e.KKsquare = 13261;
            e.Kabashkircyrillic = 1184;
            e.Kacute = 7728;
            e.Kacyrillic = 1050;
            e.Kadescendercyrillic = 1178;
            e.Kahookcyrillic = 1219;
            e.Kappa = 922;
            e.Kastrokecyrillic = 1182;
            e.Kaverticalstrokecyrillic = 1180;
            e.Kcaron = 488;
            e.Kcedilla = 310;
            e.Kcircle = 9408;
            e.Kcommaaccent = 310;
            e.Kdotbelow = 7730;
            e.Keharmenian = 1364;
            e.Kenarmenian = 1343;
            e.Khacyrillic = 1061;
            e.Kheicoptic = 998;
            e.Khook = 408;
            e.Kjecyrillic = 1036;
            e.Klinebelow = 7732;
            e.Kmonospace = 65323;
            e.Koppacyrillic = 1152;
            e.Koppagreek = 990;
            e.Ksicyrillic = 1134;
            e.Ksmall = 63339;
            e.L = 76;
            e.LJ = 455;
            e.LL = 63167;
            e.Lacute = 313;
            e.Lambda = 923;
            e.Lcaron = 317;
            e.Lcedilla = 315;
            e.Lcircle = 9409;
            e.Lcircumflexbelow = 7740;
            e.Lcommaaccent = 315;
            e.Ldot = 319;
            e.Ldotaccent = 319;
            e.Ldotbelow = 7734;
            e.Ldotbelowmacron = 7736;
            e.Liwnarmenian = 1340;
            e.Lj = 456;
            e.Ljecyrillic = 1033;
            e.Llinebelow = 7738;
            e.Lmonospace = 65324;
            e.Lslash = 321;
            e.Lslashsmall = 63225;
            e.Lsmall = 63340;
            e.M = 77;
            e.MBsquare = 13190;
            e.Macron = 63184;
            e.Macronsmall = 63407;
            e.Macute = 7742;
            e.Mcircle = 9410;
            e.Mdotaccent = 7744;
            e.Mdotbelow = 7746;
            e.Menarmenian = 1348;
            e.Mmonospace = 65325;
            e.Msmall = 63341;
            e.Mturned = 412;
            e.Mu = 924;
            e.N = 78;
            e.NJ = 458;
            e.Nacute = 323;
            e.Ncaron = 327;
            e.Ncedilla = 325;
            e.Ncircle = 9411;
            e.Ncircumflexbelow = 7754;
            e.Ncommaaccent = 325;
            e.Ndotaccent = 7748;
            e.Ndotbelow = 7750;
            e.Nhookleft = 413;
            e.Nineroman = 8552;
            e.Nj = 459;
            e.Njecyrillic = 1034;
            e.Nlinebelow = 7752;
            e.Nmonospace = 65326;
            e.Nowarmenian = 1350;
            e.Nsmall = 63342;
            e.Ntilde = 209;
            e.Ntildesmall = 63473;
            e.Nu = 925;
            e.O = 79;
            e.OE = 338;
            e.OEsmall = 63226;
            e.Oacute = 211;
            e.Oacutesmall = 63475;
            e.Obarredcyrillic = 1256;
            e.Obarreddieresiscyrillic = 1258;
            e.Obreve = 334;
            e.Ocaron = 465;
            e.Ocenteredtilde = 415;
            e.Ocircle = 9412;
            e.Ocircumflex = 212;
            e.Ocircumflexacute = 7888;
            e.Ocircumflexdotbelow = 7896;
            e.Ocircumflexgrave = 7890;
            e.Ocircumflexhookabove = 7892;
            e.Ocircumflexsmall = 63476;
            e.Ocircumflextilde = 7894;
            e.Ocyrillic = 1054;
            e.Odblacute = 336;
            e.Odblgrave = 524;
            e.Odieresis = 214;
            e.Odieresiscyrillic = 1254;
            e.Odieresissmall = 63478;
            e.Odotbelow = 7884;
            e.Ogoneksmall = 63227;
            e.Ograve = 210;
            e.Ogravesmall = 63474;
            e.Oharmenian = 1365;
            e.Ohm = 8486;
            e.Ohookabove = 7886;
            e.Ohorn = 416;
            e.Ohornacute = 7898;
            e.Ohorndotbelow = 7906;
            e.Ohorngrave = 7900;
            e.Ohornhookabove = 7902;
            e.Ohorntilde = 7904;
            e.Ohungarumlaut = 336;
            e.Oi = 418;
            e.Oinvertedbreve = 526;
            e.Omacron = 332;
            e.Omacronacute = 7762;
            e.Omacrongrave = 7760;
            e.Omega = 8486;
            e.Omegacyrillic = 1120;
            e.Omegagreek = 937;
            e.Omegaroundcyrillic = 1146;
            e.Omegatitlocyrillic = 1148;
            e.Omegatonos = 911;
            e.Omicron = 927;
            e.Omicrontonos = 908;
            e.Omonospace = 65327;
            e.Oneroman = 8544;
            e.Oogonek = 490;
            e.Oogonekmacron = 492;
            e.Oopen = 390;
            e.Oslash = 216;
            e.Oslashacute = 510;
            e.Oslashsmall = 63480;
            e.Osmall = 63343;
            e.Ostrokeacute = 510;
            e.Otcyrillic = 1150;
            e.Otilde = 213;
            e.Otildeacute = 7756;
            e.Otildedieresis = 7758;
            e.Otildesmall = 63477;
            e.P = 80;
            e.Pacute = 7764;
            e.Pcircle = 9413;
            e.Pdotaccent = 7766;
            e.Pecyrillic = 1055;
            e.Peharmenian = 1354;
            e.Pemiddlehookcyrillic = 1190;
            e.Phi = 934;
            e.Phook = 420;
            e.Pi = 928;
            e.Piwrarmenian = 1363;
            e.Pmonospace = 65328;
            e.Psi = 936;
            e.Psicyrillic = 1136;
            e.Psmall = 63344;
            e.Q = 81;
            e.Qcircle = 9414;
            e.Qmonospace = 65329;
            e.Qsmall = 63345;
            e.R = 82;
            e.Raarmenian = 1356;
            e.Racute = 340;
            e.Rcaron = 344;
            e.Rcedilla = 342;
            e.Rcircle = 9415;
            e.Rcommaaccent = 342;
            e.Rdblgrave = 528;
            e.Rdotaccent = 7768;
            e.Rdotbelow = 7770;
            e.Rdotbelowmacron = 7772;
            e.Reharmenian = 1360;
            e.Rfraktur = 8476;
            e.Rho = 929;
            e.Ringsmall = 63228;
            e.Rinvertedbreve = 530;
            e.Rlinebelow = 7774;
            e.Rmonospace = 65330;
            e.Rsmall = 63346;
            e.Rsmallinverted = 641;
            e.Rsmallinvertedsuperior = 694;
            e.S = 83;
            e.SF010000 = 9484;
            e.SF020000 = 9492;
            e.SF030000 = 9488;
            e.SF040000 = 9496;
            e.SF050000 = 9532;
            e.SF060000 = 9516;
            e.SF070000 = 9524;
            e.SF080000 = 9500;
            e.SF090000 = 9508;
            e.SF100000 = 9472;
            e.SF110000 = 9474;
            e.SF190000 = 9569;
            e.SF200000 = 9570;
            e.SF210000 = 9558;
            e.SF220000 = 9557;
            e.SF230000 = 9571;
            e.SF240000 = 9553;
            e.SF250000 = 9559;
            e.SF260000 = 9565;
            e.SF270000 = 9564;
            e.SF280000 = 9563;
            e.SF360000 = 9566;
            e.SF370000 = 9567;
            e.SF380000 = 9562;
            e.SF390000 = 9556;
            e.SF400000 = 9577;
            e.SF410000 = 9574;
            e.SF420000 = 9568;
            e.SF430000 = 9552;
            e.SF440000 = 9580;
            e.SF450000 = 9575;
            e.SF460000 = 9576;
            e.SF470000 = 9572;
            e.SF480000 = 9573;
            e.SF490000 = 9561;
            e.SF500000 = 9560;
            e.SF510000 = 9554;
            e.SF520000 = 9555;
            e.SF530000 = 9579;
            e.SF540000 = 9578;
            e.Sacute = 346;
            e.Sacutedotaccent = 7780;
            e.Sampigreek = 992;
            e.Scaron = 352;
            e.Scarondotaccent = 7782;
            e.Scaronsmall = 63229;
            e.Scedilla = 350;
            e.Schwa = 399;
            e.Schwacyrillic = 1240;
            e.Schwadieresiscyrillic = 1242;
            e.Scircle = 9416;
            e.Scircumflex = 348;
            e.Scommaaccent = 536;
            e.Sdotaccent = 7776;
            e.Sdotbelow = 7778;
            e.Sdotbelowdotaccent = 7784;
            e.Seharmenian = 1357;
            e.Sevenroman = 8550;
            e.Shaarmenian = 1351;
            e.Shacyrillic = 1064;
            e.Shchacyrillic = 1065;
            e.Sheicoptic = 994;
            e.Shhacyrillic = 1210;
            e.Shimacoptic = 1004;
            e.Sigma = 931;
            e.Sixroman = 8549;
            e.Smonospace = 65331;
            e.Softsigncyrillic = 1068;
            e.Ssmall = 63347;
            e.Stigmagreek = 986;
            e.T = 84;
            e.Tau = 932;
            e.Tbar = 358;
            e.Tcaron = 356;
            e.Tcedilla = 354;
            e.Tcircle = 9417;
            e.Tcircumflexbelow = 7792;
            e.Tcommaaccent = 354;
            e.Tdotaccent = 7786;
            e.Tdotbelow = 7788;
            e.Tecyrillic = 1058;
            e.Tedescendercyrillic = 1196;
            e.Tenroman = 8553;
            e.Tetsecyrillic = 1204;
            e.Theta = 920;
            e.Thook = 428;
            e.Thorn = 222;
            e.Thornsmall = 63486;
            e.Threeroman = 8546;
            e.Tildesmall = 63230;
            e.Tiwnarmenian = 1359;
            e.Tlinebelow = 7790;
            e.Tmonospace = 65332;
            e.Toarmenian = 1337;
            e.Tonefive = 444;
            e.Tonesix = 388;
            e.Tonetwo = 423;
            e.Tretroflexhook = 430;
            e.Tsecyrillic = 1062;
            e.Tshecyrillic = 1035;
            e.Tsmall = 63348;
            e.Twelveroman = 8555;
            e.Tworoman = 8545;
            e.U = 85;
            e.Uacute = 218;
            e.Uacutesmall = 63482;
            e.Ubreve = 364;
            e.Ucaron = 467;
            e.Ucircle = 9418;
            e.Ucircumflex = 219;
            e.Ucircumflexbelow = 7798;
            e.Ucircumflexsmall = 63483;
            e.Ucyrillic = 1059;
            e.Udblacute = 368;
            e.Udblgrave = 532;
            e.Udieresis = 220;
            e.Udieresisacute = 471;
            e.Udieresisbelow = 7794;
            e.Udieresiscaron = 473;
            e.Udieresiscyrillic = 1264;
            e.Udieresisgrave = 475;
            e.Udieresismacron = 469;
            e.Udieresissmall = 63484;
            e.Udotbelow = 7908;
            e.Ugrave = 217;
            e.Ugravesmall = 63481;
            e.Uhookabove = 7910;
            e.Uhorn = 431;
            e.Uhornacute = 7912;
            e.Uhorndotbelow = 7920;
            e.Uhorngrave = 7914;
            e.Uhornhookabove = 7916;
            e.Uhorntilde = 7918;
            e.Uhungarumlaut = 368;
            e.Uhungarumlautcyrillic = 1266;
            e.Uinvertedbreve = 534;
            e.Ukcyrillic = 1144;
            e.Umacron = 362;
            e.Umacroncyrillic = 1262;
            e.Umacrondieresis = 7802;
            e.Umonospace = 65333;
            e.Uogonek = 370;
            e.Upsilon = 933;
            e.Upsilon1 = 978;
            e.Upsilonacutehooksymbolgreek = 979;
            e.Upsilonafrican = 433;
            e.Upsilondieresis = 939;
            e.Upsilondieresishooksymbolgreek = 980;
            e.Upsilonhooksymbol = 978;
            e.Upsilontonos = 910;
            e.Uring = 366;
            e.Ushortcyrillic = 1038;
            e.Usmall = 63349;
            e.Ustraightcyrillic = 1198;
            e.Ustraightstrokecyrillic = 1200;
            e.Utilde = 360;
            e.Utildeacute = 7800;
            e.Utildebelow = 7796;
            e.V = 86;
            e.Vcircle = 9419;
            e.Vdotbelow = 7806;
            e.Vecyrillic = 1042;
            e.Vewarmenian = 1358;
            e.Vhook = 434;
            e.Vmonospace = 65334;
            e.Voarmenian = 1352;
            e.Vsmall = 63350;
            e.Vtilde = 7804;
            e.W = 87;
            e.Wacute = 7810;
            e.Wcircle = 9420;
            e.Wcircumflex = 372;
            e.Wdieresis = 7812;
            e.Wdotaccent = 7814;
            e.Wdotbelow = 7816;
            e.Wgrave = 7808;
            e.Wmonospace = 65335;
            e.Wsmall = 63351;
            e.X = 88;
            e.Xcircle = 9421;
            e.Xdieresis = 7820;
            e.Xdotaccent = 7818;
            e.Xeharmenian = 1341;
            e.Xi = 926;
            e.Xmonospace = 65336;
            e.Xsmall = 63352;
            e.Y = 89;
            e.Yacute = 221;
            e.Yacutesmall = 63485;
            e.Yatcyrillic = 1122;
            e.Ycircle = 9422;
            e.Ycircumflex = 374;
            e.Ydieresis = 376;
            e.Ydieresissmall = 63487;
            e.Ydotaccent = 7822;
            e.Ydotbelow = 7924;
            e.Yericyrillic = 1067;
            e.Yerudieresiscyrillic = 1272;
            e.Ygrave = 7922;
            e.Yhook = 435;
            e.Yhookabove = 7926;
            e.Yiarmenian = 1349;
            e.Yicyrillic = 1031;
            e.Yiwnarmenian = 1362;
            e.Ymonospace = 65337;
            e.Ysmall = 63353;
            e.Ytilde = 7928;
            e.Yusbigcyrillic = 1130;
            e.Yusbigiotifiedcyrillic = 1132;
            e.Yuslittlecyrillic = 1126;
            e.Yuslittleiotifiedcyrillic = 1128;
            e.Z = 90;
            e.Zaarmenian = 1334;
            e.Zacute = 377;
            e.Zcaron = 381;
            e.Zcaronsmall = 63231;
            e.Zcircle = 9423;
            e.Zcircumflex = 7824;
            e.Zdot = 379;
            e.Zdotaccent = 379;
            e.Zdotbelow = 7826;
            e.Zecyrillic = 1047;
            e.Zedescendercyrillic = 1176;
            e.Zedieresiscyrillic = 1246;
            e.Zeta = 918;
            e.Zhearmenian = 1338;
            e.Zhebrevecyrillic = 1217;
            e.Zhecyrillic = 1046;
            e.Zhedescendercyrillic = 1174;
            e.Zhedieresiscyrillic = 1244;
            e.Zlinebelow = 7828;
            e.Zmonospace = 65338;
            e.Zsmall = 63354;
            e.Zstroke = 437;
            e.a = 97;
            e.aabengali = 2438;
            e.aacute = 225;
            e.aadeva = 2310;
            e.aagujarati = 2694;
            e.aagurmukhi = 2566;
            e.aamatragurmukhi = 2622;
            e.aarusquare = 13059;
            e.aavowelsignbengali = 2494;
            e.aavowelsigndeva = 2366;
            e.aavowelsigngujarati = 2750;
            e.abbreviationmarkarmenian = 1375;
            e.abbreviationsigndeva = 2416;
            e.abengali = 2437;
            e.abopomofo = 12570;
            e.abreve = 259;
            e.abreveacute = 7855;
            e.abrevecyrillic = 1233;
            e.abrevedotbelow = 7863;
            e.abrevegrave = 7857;
            e.abrevehookabove = 7859;
            e.abrevetilde = 7861;
            e.acaron = 462;
            e.acircle = 9424;
            e.acircumflex = 226;
            e.acircumflexacute = 7845;
            e.acircumflexdotbelow = 7853;
            e.acircumflexgrave = 7847;
            e.acircumflexhookabove = 7849;
            e.acircumflextilde = 7851;
            e.acute = 180;
            e.acutebelowcmb = 791;
            e.acutecmb = 769;
            e.acutecomb = 769;
            e.acutedeva = 2388;
            e.acutelowmod = 719;
            e.acutetonecmb = 833;
            e.acyrillic = 1072;
            e.adblgrave = 513;
            e.addakgurmukhi = 2673;
            e.adeva = 2309;
            e.adieresis = 228;
            e.adieresiscyrillic = 1235;
            e.adieresismacron = 479;
            e.adotbelow = 7841;
            e.adotmacron = 481;
            e.ae = 230;
            e.aeacute = 509;
            e.aekorean = 12624;
            e.aemacron = 483;
            e.afii00208 = 8213;
            e.afii08941 = 8356;
            e.afii10017 = 1040;
            e.afii10018 = 1041;
            e.afii10019 = 1042;
            e.afii10020 = 1043;
            e.afii10021 = 1044;
            e.afii10022 = 1045;
            e.afii10023 = 1025;
            e.afii10024 = 1046;
            e.afii10025 = 1047;
            e.afii10026 = 1048;
            e.afii10027 = 1049;
            e.afii10028 = 1050;
            e.afii10029 = 1051;
            e.afii10030 = 1052;
            e.afii10031 = 1053;
            e.afii10032 = 1054;
            e.afii10033 = 1055;
            e.afii10034 = 1056;
            e.afii10035 = 1057;
            e.afii10036 = 1058;
            e.afii10037 = 1059;
            e.afii10038 = 1060;
            e.afii10039 = 1061;
            e.afii10040 = 1062;
            e.afii10041 = 1063;
            e.afii10042 = 1064;
            e.afii10043 = 1065;
            e.afii10044 = 1066;
            e.afii10045 = 1067;
            e.afii10046 = 1068;
            e.afii10047 = 1069;
            e.afii10048 = 1070;
            e.afii10049 = 1071;
            e.afii10050 = 1168;
            e.afii10051 = 1026;
            e.afii10052 = 1027;
            e.afii10053 = 1028;
            e.afii10054 = 1029;
            e.afii10055 = 1030;
            e.afii10056 = 1031;
            e.afii10057 = 1032;
            e.afii10058 = 1033;
            e.afii10059 = 1034;
            e.afii10060 = 1035;
            e.afii10061 = 1036;
            e.afii1