package cmd

// Code generated by github.com/tinylib/msgp DO NOT EDIT.

import (
	"github.com/tinylib/msgp/msgp"
)

// DecodeMsg implements msgp.Decodable
func (z *BaseOptions) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z BaseOptions) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 0
	_ = z
	err = en.Append(0x80)
	if err != nil {
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z BaseOptions) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 0
	_ = z
	o = append(o, 0x80)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *BaseOptions) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z BaseOptions) Msgsize() (s int) {
	s = 1
	return
}

// DecodeMsg implements msgp.Decodable
func (z *CheckPartsHandlerParams) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "id":
			z.DiskID, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "DiskID")
				return
			}
		case "v":
			z.Volume, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Volume")
				return
			}
		case "fp":
			z.FilePath, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "FilePath")
				return
			}
		case "fi":
			err = z.FI.DecodeMsg(dc)
			if err != nil {
				err = msgp.WrapError(err, "FI")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *CheckPartsHandlerParams) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 4
	// write "id"
	err = en.Append(0x84, 0xa2, 0x69, 0x64)
	if err != nil {
		return
	}
	err = en.WriteString(z.DiskID)
	if err != nil {
		err = msgp.WrapError(err, "DiskID")
		return
	}
	// write "v"
	err = en.Append(0xa1, 0x76)
	if err != nil {
		return
	}
	err = en.WriteString(z.Volume)
	if err != nil {
		err = msgp.WrapError(err, "Volume")
		return
	}
	// write "fp"
	err = en.Append(0xa2, 0x66, 0x70)
	if err != nil {
		return
	}
	err = en.WriteString(z.FilePath)
	if err != nil {
		err = msgp.WrapError(err, "FilePath")
		return
	}
	// write "fi"
	err = en.Append(0xa2, 0x66, 0x69)
	if err != nil {
		return
	}
	err = z.FI.EncodeMsg(en)
	if err != nil {
		err = msgp.WrapError(err, "FI")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *CheckPartsHandlerParams) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 4
	// string "id"
	o = append(o, 0x84, 0xa2, 0x69, 0x64)
	o = msgp.AppendString(o, z.DiskID)
	// string "v"
	o = append(o, 0xa1, 0x76)
	o = msgp.AppendString(o, z.Volume)
	// string "fp"
	o = append(o, 0xa2, 0x66, 0x70)
	o = msgp.AppendString(o, z.FilePath)
	// string "fi"
	o = append(o, 0xa2, 0x66, 0x69)
	o, err = z.FI.MarshalMsg(o)
	if err != nil {
		err = msgp.WrapError(err, "FI")
		return
	}
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *CheckPartsHandlerParams) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "id":
			z.DiskID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "DiskID")
				return
			}
		case "v":
			z.Volume, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Volume")
				return
			}
		case "fp":
			z.FilePath, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "FilePath")
				return
			}
		case "fi":
			bts, err = z.FI.UnmarshalMsg(bts)
			if err != nil {
				err = msgp.WrapError(err, "FI")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *CheckPartsHandlerParams) Msgsize() (s int) {
	s = 1 + 3 + msgp.StringPrefixSize + len(z.DiskID) + 2 + msgp.StringPrefixSize + len(z.Volume) + 3 + msgp.StringPrefixSize + len(z.FilePath) + 3 + z.FI.Msgsize()
	return
}

// DecodeMsg implements msgp.Decodable
func (z *DeleteFileHandlerParams) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "id":
			z.DiskID, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "DiskID")
				return
			}
		case "v":
			z.Volume, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Volume")
				return
			}
		case "fp":
			z.FilePath, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "FilePath")
				return
			}
		case "do":
			err = z.Opts.DecodeMsg(dc)
			if err != nil {
				err = msgp.WrapError(err, "Opts")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *DeleteFileHandlerParams) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 4
	// write "id"
	err = en.Append(0x84, 0xa2, 0x69, 0x64)
	if err != nil {
		return
	}
	err = en.WriteString(z.DiskID)
	if err != nil {
		err = msgp.WrapError(err, "DiskID")
		return
	}
	// write "v"
	err = en.Append(0xa1, 0x76)
	if err != nil {
		return
	}
	err = en.WriteString(z.Volume)
	if err != nil {
		err = msgp.WrapError(err, "Volume")
		return
	}
	// write "fp"
	err = en.Append(0xa2, 0x66, 0x70)
	if err != nil {
		return
	}
	err = en.WriteString(z.FilePath)
	if err != nil {
		err = msgp.WrapError(err, "FilePath")
		return
	}
	// write "do"
	err = en.Append(0xa2, 0x64, 0x6f)
	if err != nil {
		return
	}
	err = z.Opts.EncodeMsg(en)
	if err != nil {
		err = msgp.WrapError(err, "Opts")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *DeleteFileHandlerParams) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 4
	// string "id"
	o = append(o, 0x84, 0xa2, 0x69, 0x64)
	o = msgp.AppendString(o, z.DiskID)
	// string "v"
	o = append(o, 0xa1, 0x76)
	o = msgp.AppendString(o, z.Volume)
	// string "fp"
	o = append(o, 0xa2, 0x66, 0x70)
	o = msgp.AppendString(o, z.FilePath)
	// string "do"
	o = append(o, 0xa2, 0x64, 0x6f)
	o, err = z.Opts.MarshalMsg(o)
	if err != nil {
		err = msgp.WrapError(err, "Opts")
		return
	}
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *DeleteFileHandlerParams) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "id":
			z.DiskID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "DiskID")
				return
			}
		case "v":
			z.Volume, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Volume")
				return
			}
		case "fp":
			z.FilePath, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "FilePath")
				return
			}
		case "do":
			bts, err = z.Opts.UnmarshalMsg(bts)
			if err != nil {
				err = msgp.WrapError(err, "Opts")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *DeleteFileHandlerParams) Msgsize() (s int) {
	s = 1 + 3 + msgp.StringPrefixSize + len(z.DiskID) + 2 + msgp.StringPrefixSize + len(z.Volume) + 3 + msgp.StringPrefixSize + len(z.FilePath) + 3 + z.Opts.Msgsize()
	return
}

// DecodeMsg implements msgp.Decodable
func (z *DeleteOptions) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "BaseOptions":
			var zb0002 uint32
			zb0002, err = dc.ReadMapHeader()
			if err != nil {
				err = msgp.WrapError(err, "BaseOptions")
				return
			}
			for zb0002 > 0 {
				zb0002--
				field, err = dc.ReadMapKeyPtr()
				if err != nil {
					err = msgp.WrapError(err, "BaseOptions")
					return
				}
				switch msgp.UnsafeString(field) {
				default:
					err = dc.Skip()
					if err != nil {
						err = msgp.WrapError(err, "BaseOptions")
						return
					}
				}
			}
		case "r":
			z.Recursive, err = dc.ReadBool()
			if err != nil {
				err = msgp.WrapError(err, "Recursive")
				return
			}
		case "i":
			z.Immediate, err = dc.ReadBool()
			if err != nil {
				err = msgp.WrapError(err, "Immediate")
				return
			}
		case "u":
			z.UndoWrite, err = dc.ReadBool()
			if err != nil {
				err = msgp.WrapError(err, "UndoWrite")
				return
			}
		case "o":
			z.OldDataDir, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "OldDataDir")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *DeleteOptions) EncodeMsg(en *msgp.Writer) (err error) {
	// check for omitted fields
	zb0001Len := uint32(5)
	var zb0001Mask uint8 /* 5 bits */
	_ = zb0001Mask
	if z.OldDataDir == "" {
		zb0001Len--
		zb0001Mask |= 0x10
	}
	// variable map header, size zb0001Len
	err = en.Append(0x80 | uint8(zb0001Len))
	if err != nil {
		return
	}
	if zb0001Len == 0 {
		return
	}
	// write "BaseOptions"
	err = en.Append(0xab, 0x42, 0x61, 0x73, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73)
	if err != nil {
		return
	}
	// map header, size 0
	_ = z.BaseOptions
	err = en.Append(0x80)
	if err != nil {
		return
	}
	// write "r"
	err = en.Append(0xa1, 0x72)
	if err != nil {
		return
	}
	err = en.WriteBool(z.Recursive)
	if err != nil {
		err = msgp.WrapError(err, "Recursive")
		return
	}
	// write "i"
	err = en.Append(0xa1, 0x69)
	if err != nil {
		return
	}
	err = en.WriteBool(z.Immediate)
	if err != nil {
		err = msgp.WrapError(err, "Immediate")
		return
	}
	// write "u"
	err = en.Append(0xa1, 0x75)
	if err != nil {
		return
	}
	err = en.WriteBool(z.UndoWrite)
	if err != nil {
		err = msgp.WrapError(err, "UndoWrite")
		return
	}
	if (zb0001Mask & 0x10) == 0 { // if not omitted
		// write "o"
		err = en.Append(0xa1, 0x6f)
		if err != nil {
			return
		}
		err = en.WriteString(z.OldDataDir)
		if err != nil {
			err = msgp.WrapError(err, "OldDataDir")
			return
		}
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *DeleteOptions) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// check for omitted fields
	zb0001Len := uint32(5)
	var zb0001Mask uint8 /* 5 bits */
	_ = zb0001Mask
	if z.OldDataDir == "" {
		zb0001Len--
		zb0001Mask |= 0x10
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len == 0 {
		return
	}
	// string "BaseOptions"
	o = append(o, 0xab, 0x42, 0x61, 0x73, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73)
	// map header, size 0
	_ = z.BaseOptions
	o = append(o, 0x80)
	// string "r"
	o = append(o, 0xa1, 0x72)
	o = msgp.AppendBool(o, z.Recursive)
	// string "i"
	o = append(o, 0xa1, 0x69)
	o = msgp.AppendBool(o, z.Immediate)
	// string "u"
	o = append(o, 0xa1, 0x75)
	o = msgp.AppendBool(o, z.UndoWrite)
	if (zb0001Mask & 0x10) == 0 { // if not omitted
		// string "o"
		o = append(o, 0xa1, 0x6f)
		o = msgp.AppendString(o, z.OldDataDir)
	}
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *DeleteOptions) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "BaseOptions":
			var zb0002 uint32
			zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "BaseOptions")
				return
			}
			for zb0002 > 0 {
				zb0002--
				field, bts, err = msgp.ReadMapKeyZC(bts)
				if err != nil {
					err = msgp.WrapError(err, "BaseOptions")
					return
				}
				switch msgp.UnsafeString(field) {
				default:
					bts, err = msgp.Skip(bts)
					if err != nil {
						err = msgp.WrapError(err, "BaseOptions")
						return
					}
				}
			}
		case "r":
			z.Recursive, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Recursive")
				return
			}
		case "i":
			z.Immediate, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Immediate")
				return
			}
		case "u":
			z.UndoWrite, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "UndoWrite")
				return
			}
		case "o":
			z.OldDataDir, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "OldDataDir")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *DeleteOptions) Msgsize() (s int) {
	s = 1 + 12 + 1 + 2 + msgp.BoolSize + 2 + msgp.BoolSize + 2 + msgp.BoolSize + 2 + msgp.StringPrefixSize + len(z.OldDataDir)
	return
}

// DecodeMsg implements msgp.Decodable
func (z *DeleteVersionHandlerParams) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "id":
			z.DiskID, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "DiskID")
				return
			}
		case "v":
			z.Volume, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Volume")
				return
			}
		case "fp":
			z.FilePath, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "FilePath")
				return
			}
		case "fdm":
			z.ForceDelMarker, err = dc.ReadBool()
			if err != nil {
				err = msgp.WrapError(err, "ForceDelMarker")
				return
			}
		case "do":
			err = z.Opts.DecodeMsg(dc)
			if err != nil {
				err = msgp.WrapError(err, "Opts")
				return
			}
		case "fi":
			err = z.FI.DecodeMsg(dc)
			if err != nil {
				err = msgp.WrapError(err, "FI")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *DeleteVersionHandlerParams) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 6
	// write "id"
	err = en.Append(0x86, 0xa2, 0x69, 0x64)
	if err != nil {
		return
	}
	err = en.WriteString(z.DiskID)
	if err != nil {
		err = msgp.WrapError(err, "DiskID")
		return
	}
	// write "v"
	err = en.Append(0xa1, 0x76)
	if err != nil {
		return
	}
	err = en.WriteString(z.Volume)
	if err != nil {
		err = msgp.WrapError(err, "Volume")
		return
	}
	// write "fp"
	err = en.Append(0xa2, 0x66, 0x70)
	if err != nil {
		return
	}
	err = en.WriteString(z.FilePath)
	if err != nil {
		err = msgp.WrapError(err, "FilePath")
		return
	}
	// write "fdm"
	err = en.Append(0xa3, 0x66, 0x64, 0x6d)
	if err != nil {
		return
	}
	err = en.WriteBool(z.ForceDelMarker)
	if err != nil {
		err = msgp.WrapError(err, "ForceDelMarker")
		return
	}
	// write "do"
	err = en.Append(0xa2, 0x64, 0x6f)
	if err != nil {
		return
	}
	err = z.Opts.EncodeMsg(en)
	if err != nil {
		err = msgp.WrapError(err, "Opts")
		return
	}
	// write "fi"
	err = en.Append(0xa2, 0x66, 0x69)
	if err != nil {
		return
	}
	err = z.FI.EncodeMsg(en)
	if err != nil {
		err = msgp.WrapError(err, "FI")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *DeleteVersionHandlerParams) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 6
	// string "id"
	o = append(o, 0x86, 0xa2, 0x69, 0x64)
	o = msgp.AppendString(o, z.DiskID)
	// string "v"
	o = append(o, 0xa1, 0x76)
	o = msgp.AppendString(o, z.Volume)
	// string "fp"
	o = append(o, 0xa2, 0x66, 0x70)
	o = msgp.AppendString(o, z.FilePath)
	// string "fdm"
	o = append(o, 0xa3, 0x66, 0x64, 0x6d)
	o = msgp.AppendBool(o, z.ForceDelMarker)
	// string "do"
	o = append(o, 0xa2, 0x64, 0x6f)
	o, err = z.Opts.MarshalMsg(o)
	if err != nil {
		err = msgp.WrapError(err, "Opts")
		return
	}
	// string "fi"
	o = append(o, 0xa2, 0x66, 0x69)
	o, err = z.FI.MarshalMsg(o)
	if err != nil {
		err = msgp.WrapError(err, "FI")
		return
	}
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *DeleteVersionHandlerParams) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "id":
			z.DiskID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "DiskID")
				return
			}
		case "v":
			z.Volume, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Volume")
				return
			}
		case "fp":
			z.FilePath, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "FilePath")
				return
			}
		case "fdm":
			z.ForceDelMarker, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ForceDelMarker")
				return
			}
		case "do":
			bts, err = z.Opts.UnmarshalMsg(bts)
			if err != nil {
				err = msgp.WrapError(err, "Opts")
				return
			}
		case "fi":
			bts, err = z.FI.UnmarshalMsg(bts)
			if err != nil {
				err = msgp.WrapError(err, "FI")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *DeleteVersionHandlerParams) Msgsize() (s int) {
	s = 1 + 3 + msgp.StringPrefixSize + len(z.DiskID) + 2 + msgp.StringPrefixSize + len(z.Volume) + 3 + msgp.StringPrefixSize + len(z.FilePath) + 4 + msgp.BoolSize + 3 + z.Opts.Msgsize() + 3 + z.FI.Msgsize()
	return
}

// DecodeMsg implements msgp.Decodable
func (z *DiskInfo) DecodeMsg(dc *msgp.Reader) (err error) {
	var zb0001 uint32
	zb0001, err = dc.ReadArrayHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	if zb0001 != 18 {
		err = msgp.ArrayError{Wanted: 18, Got: zb0001}
		return
	}
	z.Total, err = dc.ReadUint64()
	if err != nil {
		err = msgp.WrapError(err, "Total")
		return
	}
	z.Free, err = dc.ReadUint64()
	if err != nil {
		err = msgp.WrapError(err, "Free")
		return
	}
	z.Used, err = dc.ReadUint64()
	if err != nil {
		err = msgp.WrapError(err, "Used")
		return
	}
	z.UsedInodes, err = dc.ReadUint64()
	if err != nil {
		err = msgp.WrapError(err, "UsedInodes")
		return
	}
	z.FreeInodes, err = dc.ReadUint64()
	if err != nil {
		err = msgp.WrapError(err, "FreeInodes")
		return
	}
	z.Major, err = dc.ReadUint32()
	if err != nil {
		err = msgp.WrapError(err, "Major")
		return
	}
	z.Minor, err = dc.ReadUint32()
	if err != nil {
		err = msgp.WrapError(err, "Minor")
		return
	}
	z.NRRequests, err = dc.ReadUint64()
	if err != nil {
		err = msgp.WrapError(err, "NRRequests")
		return
	}
	z.FSType, err = dc.ReadString()
	if err != nil {
		err = msgp.WrapError(err, "FSType")
		return
	}
	z.RootDisk, err = dc.ReadBool()
	if err != nil {
		err = msgp.WrapError(err, "RootDisk")
		return
	}
	z.Healing, err = dc.ReadBool()
	if err != nil {
		err = msgp.WrapError(err, "Healing")
		return
	}
	z.Scanning, err = dc.ReadBool()
	if err != nil {
		err = msgp.WrapError(err, "Scanning")
		return
	}
	z.Endpoint, err = dc.ReadString()
	if err != nil {
		err = msgp.WrapError(err, "Endpoint")
		return
	}
	z.MountPath, err = dc.ReadString()
	if err != nil {
		err = msgp.WrapError(err, "MountPath")
		return
	}
	z.ID, err = dc.ReadString()
	if err != nil {
		err = msgp.WrapError(err, "ID")
		return
	}
	z.Rotational, err = dc.ReadBool()
	if err != nil {
		err = msgp.WrapError(err, "Rotational")
		return
	}
	err = z.Metrics.DecodeMsg(dc)
	if err != nil {
		err = msgp.WrapError(err, "Metrics")
		return
	}
	z.Error, err = dc.ReadString()
	if err != nil {
		err = msgp.WrapError(err, "Error")
		return
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *DiskInfo) EncodeMsg(en *msgp.Writer) (err error) {
	// array header, size 18
	err = en.Append(0xdc, 0x0, 0x12)
	if err != nil {
		return
	}
	err = en.WriteUint64(z.Total)
	if err != nil {
		err = msgp.WrapError(err, "Total")
		return
	}
	err = en.WriteUint64(z.Free)
	if err != nil {
		err = msgp.WrapError(err, "Free")
		return
	}
	err = en.WriteUint64(z.Used)
	if err != nil {
		err = msgp.WrapError(err, "Used")
		return
	}
	err = en.WriteUint64(z.UsedInodes)
	if err != nil {
		err = msgp.WrapError(err, "UsedInodes")
		return
	}
	err = en.WriteUint64(z.FreeInodes)
	if err != nil {
		err = msgp.WrapError(err, "FreeInodes")
		return
	}
	err = en.WriteUint32(z.Major)
	if err != nil {
		err = msgp.WrapError(err, "Major")
		return
	}
	err = en.WriteUint32(z.Minor)
	if err != nil {
		err = msgp.WrapError(err, "Minor")
		return
	}
	err = en.WriteUint64(z.NRRequests)
	if err != nil {
		err = msgp.WrapError(err, "NRRequests")
		return
	}
	err = en.WriteString(z.FSType)
	if err != nil {
		err = msgp.WrapError(err, "FSType")
		return
	}
	err = en.WriteBool(z.RootDisk)
	if err != nil {
		err = msgp.WrapError(err, "RootDisk")
		return
	}
	err = en.WriteBool(z.Healing)
	if err != nil {
		err = msgp.WrapError(err, "Healing")
		return
	}
	err = en.WriteBool(z.Scanning)
	if err != nil {
		err = msgp.WrapError(err, "Scanning")
		return
	}
	err = en.WriteString(z.Endpoint)
	if err != nil {
		err = msgp.WrapError(err, "Endpoint")
		return
	}
	err = en.WriteString(z.MountPath)
	if err != nil {
		err = msgp.WrapError(err, "MountPath")
		return
	}
	err = en.WriteString(z.ID)
	if err != nil {
		err = msgp.WrapError(err, "ID")
		return
	}
	err = en.WriteBool(z.Rotational)
	if err != nil {
		err = msgp.WrapError(err, "Rotational")
		return
	}
	err = z.Metrics.EncodeMsg(en)
	if err != nil {
		err = msgp.WrapError(err, "Metrics")
		return
	}
	err = en.WriteString(z.Error)
	if err != nil {
		err = msgp.WrapError(err, "Error")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *DiskInfo) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// array header, size 18
	o = append(o, 0xdc, 0x0, 0x12)
	o = msgp.AppendUint64(o, z.Total)
	o = msgp.AppendUint64(o, z.Free)
	o = msgp.AppendUint64(o, z.Used)
	o = msgp.AppendUint64(o, z.UsedInodes)
	o = msgp.AppendUint64(o, z.FreeInodes)
	o = msgp.AppendUint32(o, z.Major)
	o = msgp.AppendUint32(o, z.Minor)
	o = msgp.AppendUint64(o, z.NRRequests)
	o = msgp.AppendString(o, z.FSType)
	o = msgp.AppendBool(o, z.RootDisk)
	o = msgp.AppendBool(o, z.Healing)
	o = msgp.AppendBool(o, z.Scanning)
	o = msgp.AppendString(o, z.Endpoint)
	o = msgp.AppendString(o, z.MountPath)
	o = msgp.AppendString(o, z.ID)
	o = msgp.AppendBool(o, z.Rotational)
	o, err = z.Metrics.MarshalMsg(o)
	if err != nil {
		err = msgp.WrapError(err, "Metrics")
		return
	}
	o = msgp.AppendString(o, z.Error)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *DiskInfo) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadArrayHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	if zb0001 != 18 {
		err = msgp.ArrayError{Wanted: 18, Got: zb0001}
		return
	}
	z.Total, bts, err = msgp.ReadUint64Bytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Total")
		return
	}
	z.Free, bts, err = msgp.ReadUint64Bytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Free")
		return
	}
	z.Used, bts, err = msgp.ReadUint64Bytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Used")
		return
	}
	z.UsedInodes, bts, err = msgp.ReadUint64Bytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "UsedInodes")
		return
	}
	z.FreeInodes, bts, err = msgp.ReadUint64Bytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "FreeInodes")
		return
	}
	z.Major, bts, err = msgp.ReadUint32Bytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Major")
		return
	}
	z.Minor, bts, err = msgp.ReadUint32Bytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Minor")
		return
	}
	z.NRRequests, bts, err = msgp.ReadUint64Bytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "NRRequests")
		return
	}
	z.FSType, bts, err = msgp.ReadStringBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "FSType")
		return
	}
	z.RootDisk, bts, err = msgp.ReadBoolBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "RootDisk")
		return
	}
	z.Healing, bts, err = msgp.ReadBoolBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Healing")
		return
	}
	z.Scanning, bts, err = msgp.ReadBoolBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Scanning")
		return
	}
	z.Endpoint, bts, err = msgp.ReadStringBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Endpoint")
		return
	}
	z.MountPath, bts, err = msgp.ReadStringBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "MountPath")
		return
	}
	z.ID, bts, err = msgp.ReadStringBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "ID")
		return
	}
	z.Rotational, bts, err = msgp.ReadBoolBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Rotational")
		return
	}
	bts, err = z.Metrics.UnmarshalMsg(bts)
	if err != nil {
		err = msgp.WrapError(err, "Metrics")
		return
	}
	z.Error, bts, err = msgp.ReadStringBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Error")
		return
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *DiskInfo) Msgsize() (s int) {
	s = 3 + msgp.Uint64Size + msgp.Uint64Size + msgp.Uint64Size + msgp.Uint64Size + msgp.Uint64Size + msgp.Uint32Size + msgp.Uint32Size + msgp.Uint64Size + msgp.StringPrefixSize + len(z.FSType) + msgp.BoolSize + msgp.BoolSize + msgp.BoolSize + msgp.StringPrefixSize + len(z.Endpoint) + msgp.StringPrefixSize + len(z.MountPath) + msgp.StringPrefixSize + len(z.ID) + msgp.BoolSize + z.Metrics.Msgsize() + msgp.StringPrefixSize + len(z.Error)
	return
}

// DecodeMsg implements msgp.Decodable
func (z *DiskInfoOptions) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "id":
			z.DiskID, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "DiskID")
				return
			}
		case "m":
			z.Metrics, err = dc.ReadBool()
			if err != nil {
				err = msgp.WrapError(err, "Metrics")
				return
			}
		case "np":
			z.NoOp, err = dc.ReadBool()
			if err != nil {
				err = msgp.WrapError(err, "NoOp")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z DiskInfoOptions) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 3
	// write "id"
	err = en.Append(0x83, 0xa2, 0x69, 0x64)
	if err != nil {
		return
	}
	err = en.WriteString(z.DiskID)
	if err != nil {
		err = msgp.WrapError(err, "DiskID")
		return
	}
	// write "m"
	err = en.Append(0xa1, 0x6d)
	if err != nil {
		return
	}
	err = en.WriteBool(z.Metrics)
	if err != nil {
		err = msgp.WrapError(err, "Metrics")
		return
	}
	// write "np"
	err = en.Append(0xa2, 0x6e, 0x70)
	if err != nil {
		return
	}
	err = en.WriteBool(z.NoOp)
	if err != nil {
		err = msgp.WrapError(err, "NoOp")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z DiskInfoOptions) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 3
	// string "id"
	o = append(o, 0x83, 0xa2, 0x69, 0x64)
	o = msgp.AppendString(o, z.DiskID)
	// string "m"
	o = append(o, 0xa1, 0x6d)
	o = msgp.AppendBool(o, z.Metrics)
	// string "np"
	o = append(o, 0xa2, 0x6e, 0x70)
	o = msgp.AppendBool(o, z.NoOp)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *DiskInfoOptions) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "id":
			z.DiskID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "DiskID")
				return
			}
		case "m":
			z.Metrics, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Metrics")
				return
			}
		case "np":
			z.NoOp, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "NoOp")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z DiskInfoOptions) Msgsize() (s int) {
	s = 1 + 3 + msgp.StringPrefixSize + len(z.DiskID) + 2 + msgp.BoolSize + 3 + msgp.BoolSize
	return
}

// DecodeMsg implements msgp.Decodable
func (z *DiskMetrics) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "LastMinute":
			var zb0002 uint32
			zb0002, err = dc.ReadMapHeader()
			if err != nil {
				err = msgp.WrapError(err, "LastMinute")
				return
			}
			if z.LastMinute == nil {
				z.LastMinute = make(map[string]AccElem, zb0002)
			} else if len(z.LastMinute) > 0 {
				for key := range z.LastMinute {
					delete(z.LastMinute, key)
				}
			}
			for zb0002 > 0 {
				zb0002--
				var za0001 string
				var za0002 AccElem
				za0001, err = dc.ReadString()
				if err != nil {
					err = msgp.WrapError(err, "LastMinute")
					return
				}
				err = za0002.DecodeMsg(dc)
				if err != nil {
					err = msgp.WrapError(err, "LastMinute", za0001)
					return
				}
				z.LastMinute[za0001] = za0002
			}
		case "APICalls":
			var zb0003 uint32
			zb0003, err = dc.ReadMapHeader()
			if err != nil {
				err = msgp.WrapError(err, "APICalls")
				return
			}
			if z.APICalls == nil {
				z.APICalls = make(map[string]uint64, zb0003)
			} else if len(z.APICalls) > 0 {
				for key := range z.APICalls {
					delete(z.APICalls, key)
				}
			}
			for zb0003 > 0 {
				zb0003--
				var za0003 string
				var za0004 uint64
				za0003, err = dc.ReadString()
				if err != nil {
					err = msgp.WrapError(err, "APICalls")
					return
				}
				za0004, err = dc.ReadUint64()
				if err != nil {
					err = msgp.WrapError(err, "APICalls", za0003)
					return
				}
				z.APICalls[za0003] = za0004
			}
		case "TotalWaiting":
			z.TotalWaiting, err = dc.ReadUint32()
			if err != nil {
				err = msgp.WrapError(err, "TotalWaiting")
				return
			}
		case "TotalErrorsAvailability":
			z.TotalErrorsAvailability, err = dc.ReadUint64()
			if err != nil {
				err = msgp.WrapError(err, "TotalErrorsAvailability")
				return
			}
		case "TotalErrorsTimeout":
			z.TotalErrorsTimeout, err = dc.ReadUint64()
			if err != nil {
				err = msgp.WrapError(err, "TotalErrorsTimeout")
				return
			}
		case "TotalWrites":
			z.TotalWrites, err = dc.ReadUint64()
			if err != nil {
				err = msgp.WrapError(err, "TotalWrites")
				return
			}
		case "TotalDeletes":
			z.TotalDeletes, err = dc.ReadUint64()
			if err != nil {
				err = msgp.WrapError(err, "TotalDeletes")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *DiskMetrics) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 7
	// write "LastMinute"
	err = en.Append(0x87, 0xaa, 0x4c, 0x61, 0x73, 0x74, 0x4d, 0x69, 0x6e, 0x75, 0x74, 0x65)
	if err != nil {
		return
	}
	err = en.WriteMapHeader(uint32(len(z.LastMinute)))
	if err != nil {
		err = msgp.WrapError(err, "LastMinute")
		return
	}
	for za0001, za0002 := range z.LastMinute {
		err = en.WriteString(za0001)
		if err != nil {
			err = msgp.WrapError(err, "LastMinute")
			return
		}
		err = za0002.EncodeMsg(en)
		if err != nil {
			err = msgp.WrapError(err, "LastMinute", za0001)
			return
		}
	}
	// write "APICalls"
	err = en.Append(0xa8, 0x41, 0x50, 0x49, 0x43, 0x61, 0x6c, 0x6c, 0x73)
	if err != nil {
		return
	}
	err = en.WriteMapHeader(uint32(len(z.APICalls)))
	if err != nil {
		err = msgp.WrapError(err, "APICalls")
		return
	}
	for za0003, za0004 := range z.APICalls {
		err = en.WriteString(za0003)
		if err != nil {
			err = msgp.WrapError(err, "APICalls")
			return
		}
		err = en.WriteUint64(za0004)
		if err != nil {
			err = msgp.WrapError(err, "APICalls", za0003)
			return
		}
	}
	// write "TotalWaiting"
	err = en.Append(0xac, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x57, 0x61, 0x69, 0x74, 0x69, 0x6e, 0x67)
	if err != nil {
		return
	}
	err = en.WriteUint32(z.TotalWaiting)
	if err != nil {
		err = msgp.WrapError(err, "TotalWaiting")
		return
	}
	// write "TotalErrorsAvailability"
	err = en.Append(0xb7, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79)
	if err != nil {
		return
	}
	err = en.WriteUint64(z.TotalErrorsAvailability)
	if err != nil {
		err = msgp.WrapError(err, "TotalErrorsAvailability")
		return
	}
	// write "TotalErrorsTimeout"
	err = en.Append(0xb2, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74)
	if err != nil {
		return
	}
	err = en.WriteUint64(z.TotalErrorsTimeout)
	if err != nil {
		err = msgp.WrapError(err, "TotalErrorsTimeout")
		return
	}
	// write "TotalWrites"
	err = en.Append(0xab, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x57, 0x72, 0x69, 0x74, 0x65, 0x73)
	if err != nil {
		return
	}
	err = en.WriteUint64(z.TotalWrites)
	if err != nil {
		err = msgp.WrapError(err, "TotalWrites")
		return
	}
	// write "TotalDeletes"
	err = en.Append(0xac, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x73)
	if err != nil {
		return
	}
	err = en.WriteUint64(z.TotalDeletes)
	if err != nil {
		err = msgp.WrapError(err, "TotalDeletes")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *DiskMetrics) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 7
	// string "LastMinute"
	o = append(o, 0x87, 0xaa, 0x4c, 0x61, 0x73, 0x74, 0x4d, 0x69, 0x6e, 0x75, 0x74, 0x65)
	o = msgp.AppendMapHeader(o, uint32(len(z.LastMinute)))
	for za0001, za0002 := range z.LastMinute {
		o = msgp.AppendString(o, za0001)
		o, err = za0002.MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "LastMinute", za0001)
			return
		}
	}
	// string "APICalls"
	o = append(o, 0xa8, 0x41, 0x50, 0x49, 0x43, 0x61, 0x6c, 0x6c, 0x73)
	o = msgp.AppendMapHeader(o, uint32(len(z.APICalls)))
	for za0003, za0004 := range z.APICalls {
		o = msgp.AppendString(o, za0003)
		o = msgp.AppendUint64(o, za0004)
	}
	// string "TotalWaiting"
	o = append(o, 0xac, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x57, 0x61, 0x69, 0x74, 0x69, 0x6e, 0x67)
	o = msgp.AppendUint32(o, z.TotalWaiting)
	// string "TotalErrorsAvailability"
	o = append(o, 0xb7, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79)
	o = msgp.AppendUint64(o, z.TotalErrorsAvailability)
	// string "TotalErrorsTimeout"
	o = append(o, 0xb2, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74)
	o = msgp.AppendUint64(o, z.TotalErrorsTimeout)
	// string "TotalWrites"
	o = append(o, 0xab, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x57, 0x72, 0x69, 0x74, 0x65, 0x73)
	o = msgp.AppendUint64(o, z.TotalWrites)
	// string "TotalDeletes"
	o = append(o, 0xac, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x73)
	o = msgp.AppendUint64(o, z.TotalDeletes)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *DiskMetrics) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "LastMinute":
			var zb0002 uint32
			zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "LastMinute")
				return
			}
			if z.LastMinute == nil {
				z.LastMinute = make(map[string]AccElem, zb0002)
			} else if len(z.LastMinute) > 0 {
				for key := range z.LastMinute {
					delete(z.LastMinute, key)
				}
			}
			for zb0002 > 0 {
				var za0001 string
				var za0002 AccElem
				zb0002--
				za0001, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "LastMinute")
					return
				}
				bts, err = za0002.UnmarshalMsg(bts)
				if err != nil {
					err = msgp.WrapError(err, "LastMinute", za0001)
					return
				}
				z.LastMinute[za0001] = za0002
			}
		case "APICalls":
			var zb0003 uint32
			zb0003, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "APICalls")
				return
			}
			if z.APICalls == nil {
				z.APICalls = make(map[string]uint64, zb0003)
			} else if len(z.APICalls) > 0 {
				for key := range z.APICalls {
					delete(z.APICalls, key)
				}
			}
			for zb0003 > 0 {
				var za0003 string
				var za0004 uint64
				zb0003--
				za0003, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "APICalls")
					return
				}
				za0004, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "APICalls", za0003)
					return
				}
				z.APICalls[za0003] = za0004
			}
		case "TotalWaiting":
			z.TotalWaiting, bts, err = msgp.ReadUint32Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "TotalWaiting")
				return
			}
		case "TotalErrorsAvailability":
			z.TotalErrorsAvailability, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "TotalErrorsAvailability")
				return
			}
		case "TotalErrorsTimeout":
			z.TotalErrorsTimeout, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "TotalErrorsTimeout")
				return
			}
		case "TotalWrites":
			z.TotalWrites, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "TotalWrites")
				return
			}
		case "TotalDeletes":
			z.TotalDeletes, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "TotalDeletes")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *DiskMetrics) Msgsize() (s int) {
	s = 1 + 11 + msgp.MapHeaderSize
	if z.LastMinute != nil {
		for za0001, za0002 := range z.LastMinute {
			_ = za0002
			s += msgp.StringPrefixSize + len(za0001) + za0002.Msgsize()
		}
	}
	s += 9 + msgp.MapHeaderSize
	if z.APICalls != nil {
		for za0003, za0004 := range z.APICalls {
			_ = za0004
			s += msgp.StringPrefixSize + len(za0003) + msgp.Uint64Size
		}
	}
	s += 13 + msgp.Uint32Size + 24 + msgp.Uint64Size + 19 + msgp.Uint64Size + 12 + msgp.Uint64Size + 13 + msgp.Uint64Size
	return
}

// DecodeMsg implements msgp.Decodable
func (z *FileInfo) DecodeMsg(dc *msgp.Reader) (err error) {
	var zb0001 uint32
	zb0001, err = dc.ReadArrayHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	if zb0001 != 28 {
		err = msgp.ArrayError{Wanted: 28, Got: zb0001}
		return
	}
	z.Volume, err = dc.ReadString()
	if err != nil {
		err = msgp.WrapError(err, "Volume")
		return
	}
	z.Name, err = dc.ReadString()
	if err != nil {
		err = msgp.WrapError(err, "Name")
		return
	}
	z.VersionID, err = dc.ReadString()
	if err != nil {
		err = msgp.WrapError(err, "VersionID")
		return
	}
	z.IsLatest, err = dc.ReadBool()
	if err != nil {
		err = msgp.WrapError(err, "IsLatest")
		return
	}
	z.Deleted, err = dc.ReadBool()
	if err != nil {
		err = msgp.WrapError(err, "Deleted")
		return
	}
	z.TransitionStatus, err = dc.ReadString()
	if err != nil {
		err = msgp.WrapError(err, "TransitionStatus")
		return
	}
	z.TransitionedObjName, err = dc.ReadString()
	if err != nil {
		err = msgp.WrapError(err, "TransitionedObjName")
		return
	}
	z.TransitionTier, err = dc.ReadString()
	if err != nil {
		err = msgp.WrapError(err, "TransitionTier")
		return
	}
	z.TransitionVersionID, err = dc.ReadString()
	if err != nil {
		err = msgp.WrapError(err, "TransitionVersionID")
		return
	}
	z.ExpireRestored, err = dc.ReadBool()
	if err != nil {
		err = msgp.WrapError(err, "ExpireRestored")
		return
	}
	z.DataDir, err = dc.ReadString()
	if err != nil {
		err = msgp.WrapError(err, "DataDir")
		return
	}
	z.XLV1, err = dc.ReadBool()
	if err != nil {
		err = msgp.WrapError(err, "XLV1")
		return
	}
	z.ModTime, err = dc.ReadTime()
	if err != nil {
		err = msgp.WrapError(err, "ModTime")
		return
	}
	z.Size, err = dc.ReadInt64()
	if err != nil {
		err = msgp.WrapError(err, "Size")
		return
	}
	z.Mode, err = dc.ReadUint32()
	if err != nil {
		err = msgp.WrapError(err, "Mode")
		return
	}
	z.WrittenByVersion, err = dc.ReadUint64()
	if err != nil {
		err = msgp.WrapError(err, "WrittenByVersion")
		return
	}
	var zb0002 uint32
	zb0002, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err, "Metadata")
		return
	}
	if z.Metadata == nil {
		z.Metadata = make(map[string]string, zb0002)
	} else if len(z.Metadata) > 0 {
		for key := range z.Metadata {
			delete(z.Metadata, key)
		}
	}
	var field []byte
	_ = field
	for zb0002 > 0 {
		zb0002--
		var za0001 string
		var za0002 string
		za0001, err = dc.ReadString()
		if err != nil {
			err = msgp.WrapError(err, "Metadata")
			return
		}
		za0002, err = dc.ReadString()
		if err != nil {
			err = msgp.WrapError(err, "Metadata", za0001)
			return
		}
		z.Metadata[za0001] = za0002
	}
	var zb0003 uint32
	zb0003, err = dc.ReadArrayHeader()
	if err != nil {
		err = msgp.WrapError(err, "Parts")
		return
	}
	if cap(z.Parts) >= int(zb0003) {
		z.Parts = (z.Parts)[:zb0003]
	} else {
		z.Parts = make([]ObjectPartInfo, zb0003)
	}
	for za0003 := range z.Parts {
		err = z.Parts[za0003].DecodeMsg(dc)
		if err != nil {
			err = msgp.WrapError(err, "Parts", za0003)
			return
		}
	}
	err = z.Erasure.DecodeMsg(dc)
	if err != nil {
		err = msgp.WrapError(err, "Erasure")
		return
	}
	z.MarkDeleted, err = dc.ReadBool()
	if err != nil {
		err = msgp.WrapError(err, "MarkDeleted")
		return
	}
	err = z.ReplicationState.DecodeMsg(dc)
	if err != nil {
		err = msgp.WrapError(err, "ReplicationState")
		return
	}
	if dc.IsNil() {
		err = dc.ReadNil()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		z.Data = nil
	} else {
		z.Data, err = dc.ReadBytes(z.Data)
		if err != nil {
			err = msgp.WrapError(err, "Data")
			return
		}
	}
	z.NumVersions, err = dc.ReadInt()
	if err != nil {
		err = msgp.WrapError(err, "NumVersions")
		return
	}
	z.SuccessorModTime, err = dc.ReadTime()
	if err != nil {
		err = msgp.WrapError(err, "SuccessorModTime")
		return
	}
	z.Fresh, err = dc.ReadBool()
	if err != nil {
		err = msgp.WrapError(err, "Fresh")
		return
	}
	z.Idx, err = dc.ReadInt()
	if err != nil {
		err = msgp.WrapError(err, "Idx")
		return
	}
	if dc.IsNil() {
		err = dc.ReadNil()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		z.Checksum = nil
	} else {
		z.Checksum, err = dc.ReadBytes(z.Checksum)
		if err != nil {
			err = msgp.WrapError(err, "Checksum")
			return
		}
	}
	z.Versioned, err = dc.ReadBool()
	if err != nil {
		err = msgp.WrapError(err, "Versioned")
		return
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *FileInfo) EncodeMsg(en *msgp.Writer) (err error) {
	// array header, size 28
	err = en.Append(0xdc, 0x0, 0x1c)
	if err != nil {
		return
	}
	err = en.WriteString(z.Volume)
	if err != nil {
		err = msgp.WrapError(err, "Volume")
		return
	}
	err = en.WriteString(z.Name)
	if err != nil {
		err = msgp.WrapError(err, "Name")
		return
	}
	err = en.WriteString(z.VersionID)
	if err != nil {
		err = msgp.WrapError(err, "VersionID")
		return
	}
	err = en.WriteBool(z.IsLatest)
	if err != nil {
		err = msgp.WrapError(err, "IsLatest")
		return
	}
	err = en.WriteBool(z.Deleted)
	if err != nil {
		err = msgp.WrapError(err, "Deleted")
		return
	}
	err = en.WriteString(z.TransitionStatus)
	if err != nil {
		err = msgp.WrapError(err, "TransitionStatus")
		return
	}
	err = en.WriteString(z.TransitionedObjName)
	if err != nil {
		err = msgp.WrapError(err, "TransitionedObjName")
		return
	}
	err = en.WriteString(z.TransitionTier)
	if err != nil {
		err = msgp.WrapError(err, "TransitionTier")
		return
	}
	err = en.WriteString(z.TransitionVersionID)
	if err != nil {
		err = msgp.WrapError(err, "TransitionVersionID")
		return
	}
	err = en.WriteBool(z.ExpireRestored)
	if err != nil {
		err = msgp.WrapError(err, "ExpireRestored")
		return
	}
	err = en.WriteString(z.DataDir)
	if err != nil {
		err = msgp.WrapError(err, "DataDir")
		return
	}
	err = en.WriteBool(z.XLV1)
	if err != nil {
		err = msgp.WrapError(err, "XLV1")
		return
	}
	err = en.WriteTime(z.ModTime)
	if err != nil {
		err = msgp.WrapError(err, "ModTime")
		return
	}
	err = en.WriteInt64(z.Size)
	if err != nil {
		err = msgp.WrapError(err, "Size")
		return
	}
	err = en.WriteUint32(z.Mode)
	if err != nil {
		err = msgp.WrapError(err, "Mode")
		return
	}
	err = en.WriteUint64(z.WrittenByVersion)
	if err != nil {
		err = msgp.WrapError(err, "WrittenByVersion")
		return
	}
	err = en.WriteMapHeader(uint32(len(z.Metadata)))
	if err != nil {
		err = msgp.WrapError(err, "Metadata")
		return
	}
	for za0001, za0002 := range z.Metadata {
		err = en.WriteString(za0001)
		if err != nil {
			err = msgp.WrapError(err, "Metadata")
			return
		}
		err = en.WriteString(za0002)
		if err != nil {
			err = msgp.WrapError(err, "Metadata", za0001)
			return
		}
	}
	err = en.WriteArrayHeader(uint32(len(z.Parts)))
	if err != nil {
		err = msgp.WrapError(err, "Parts")
		return
	}
	for za0003 := range z.Parts {
		err = z.Parts[za0003].EncodeMsg(en)
		if err != nil {
			err = msgp.WrapError(err, "Parts", za0003)
			return
		}
	}
	err = z.Erasure.EncodeMsg(en)
	if err != nil {
		err = msgp.WrapError(err, "Erasure")
		return
	}
	err = en.WriteBool(z.MarkDeleted)
	if err != nil {
		err = msgp.WrapError(err, "MarkDeleted")
		return
	}
	err = z.ReplicationState.EncodeMsg(en)
	if err != nil {
		err = msgp.WrapError(err, "ReplicationState")
		return
	}
	if z.Data == nil { // allownil: if nil
		err = en.WriteNil()
		if err != nil {
			return
		}
	} else {
		err = en.WriteBytes(z.Data)
		if err != nil {
			err = msgp.WrapError(err, "Data")
			return
		}
	}
	err = en.WriteInt(z.NumVersions)
	if err != nil {
		err = msgp.WrapError(err, "NumVersions")
		return
	}
	err = en.WriteTime(z.SuccessorModTime)
	if err != nil {
		err = msgp.WrapError(err, "SuccessorModTime")
		return
	}
	err = en.WriteBool(z.Fresh)
	if err != nil {
		err = msgp.WrapError(err, "Fresh")
		return
	}
	err = en.WriteInt(z.Idx)
	if err != nil {
		err = msgp.WrapError(err, "Idx")
		return
	}
	if z.Checksum == nil { // allownil: if nil
		err = en.WriteNil()
		if err != nil {
			return
		}
	} else {
		err = en.WriteBytes(z.Checksum)
		if err != nil {
			err = msgp.WrapError(err, "Checksum")
			return
		}
	}
	err = en.WriteBool(z.Versioned)
	if err != nil {
		err = msgp.WrapError(err, "Versioned")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *FileInfo) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// array header, size 28
	o = append(o, 0xdc, 0x0, 0x1c)
	o = msgp.AppendString(o, z.Volume)
	o = msgp.AppendString(o, z.Name)
	o = msgp.AppendString(o, z.VersionID)
	o = msgp.AppendBool(o, z.IsLatest)
	o = msgp.AppendBool(o, z.Deleted)
	o = msgp.AppendString(o, z.TransitionStatus)
	o = msgp.AppendString(o, z.TransitionedObjName)
	o = msgp.AppendString(o, z.TransitionTier)
	o = msgp.AppendString(o, z.TransitionVersionID)
	o = msgp.AppendBool(o, z.ExpireRestored)
	o = msgp.AppendString(o, z.DataDir)
	o = msgp.AppendBool(o, z.XLV1)
	o = msgp.AppendTime(o, z.ModTime)
	o = msgp.AppendInt64(o, z.Size)
	o = msgp.AppendUint32(o, z.Mode)
	o = msgp.AppendUint64(o, z.WrittenByVersion)
	o = msgp.AppendMapHeader(o, uint32(len(z.Metadata)))
	for za0001, za0002 := range z.Metadata {
		o = msgp.AppendString(o, za0001)
		o = msgp.AppendString(o, za0002)
	}
	o = msgp.AppendArrayHeader(o, uint32(len(z.Parts)))
	for za0003 := range z.Parts {
		o, err = z.Parts[za0003].MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "Parts", za0003)
			return
		}
	}
	o, err = z.Erasure.MarshalMsg(o)
	if err != nil {
		err = msgp.WrapError(err, "Erasure")
		return
	}
	o = msgp.AppendBool(o, z.MarkDeleted)
	o, err = z.ReplicationState.MarshalMsg(o)
	if err != nil {
		err = msgp.WrapError(err, "ReplicationState")
		return
	}
	if z.Data == nil { // allownil: if nil
		o = msgp.AppendNil(o)
	} else {
		o = msgp.AppendBytes(o, z.Data)
	}
	o = msgp.AppendInt(o, z.NumVersions)
	o = msgp.AppendTime(o, z.SuccessorModTime)
	o = msgp.AppendBool(o, z.Fresh)
	o = msgp.AppendInt(o, z.Idx)
	if z.Checksum == nil { // allownil: if nil
		o = msgp.AppendNil(o)
	} else {
		o = msgp.AppendBytes(o, z.Checksum)
	}
	o = msgp.AppendBool(o, z.Versioned)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *FileInfo) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadArrayHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	if zb0001 != 28 {
		err = msgp.ArrayError{Wanted: 28, Got: zb0001}
		return
	}
	z.Volume, bts, err = msgp.ReadStringBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Volume")
		return
	}
	z.Name, bts, err = msgp.ReadStringBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Name")
		return
	}
	z.VersionID, bts, err = msgp.ReadStringBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "VersionID")
		return
	}
	z.IsLatest, bts, err = msgp.ReadBoolBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "IsLatest")
		return
	}
	z.Deleted, bts, err = msgp.ReadBoolBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Deleted")
		return
	}
	z.TransitionStatus, bts, err = msgp.ReadStringBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "TransitionStatus")
		return
	}
	z.TransitionedObjName, bts, err = msgp.ReadStringBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "TransitionedObjName")
		return
	}
	z.TransitionTier, bts, err = msgp.ReadStringBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "TransitionTier")
		return
	}
	z.TransitionVersionID, bts, err = msgp.ReadStringBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "TransitionVersionID")
		return
	}
	z.ExpireRestored, bts, err = msgp.ReadBoolBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "ExpireRestored")
		return
	}
	z.DataDir, bts, err = msgp.ReadStringBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "DataDir")
		return
	}
	z.XLV1, bts, err = msgp.ReadBoolBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "XLV1")
		return
	}
	z.ModTime, bts, err = msgp.ReadTimeBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "ModTime")
		return
	}
	z.Size, bts, err = msgp.ReadInt64Bytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Size")
		return
	}
	z.Mode, bts, err = msgp.ReadUint32Bytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Mode")
		return
	}
	z.WrittenByVersion, bts, err = msgp.ReadUint64Bytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "WrittenByVersion")
		return
	}
	var zb0002 uint32
	zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Metadata")
		return
	}
	if z.Metadata == nil {
		z.Metadata = make(map[string]string, zb0002)
	} else if len(z.Metadata) > 0 {
		for key := range z.Metadata {
			delete(z.Metadata, key)
		}
	}
	var field []byte
	_ = field
	for zb0002 > 0 {
		var za0001 string
		var za0002 string
		zb0002--
		za0001, bts, err = msgp.ReadStringBytes(bts)
		if err != nil {
			err = msgp.WrapError(err, "Metadata")
			return
		}
		za0002, bts, err = msgp.ReadStringBytes(bts)
		if err != nil {
			err = msgp.WrapError(err, "Metadata", za0001)
			return
		}
		z.Metadata[za0001] = za0002
	}
	var zb0003 uint32
	zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Parts")
		return
	}
	if cap(z.Parts) >= int(zb0003) {
		z.Parts = (z.Parts)[:zb0003]
	} else {
		z.Parts = make([]ObjectPartInfo, zb0003)
	}
	for za0003 := range z.Parts {
		bts, err = z.Parts[za0003].UnmarshalMsg(bts)
		if err != nil {
			err = msgp.WrapError(err, "Parts", za0003)
			return
		}
	}
	bts, err = z.Erasure.UnmarshalMsg(bts)
	if err != nil {
		err = msgp.WrapError(err, "Erasure")
		return
	}
	z.MarkDeleted, bts, err = msgp.ReadBoolBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "MarkDeleted")
		return
	}
	bts, err = z.ReplicationState.UnmarshalMsg(bts)
	if err != nil {
		err = msgp.WrapError(err, "ReplicationState")
		return
	}
	if msgp.IsNil(bts) {
		bts = bts[1:]
		z.Data = nil
	} else {
		z.Data, bts, err = msgp.ReadBytesBytes(bts, z.Data)
		if err != nil {
			err = msgp.WrapError(err, "Data")
			return
		}
	}
	z.NumVersions, bts, err = msgp.ReadIntBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "NumVersions")
		return
	}
	z.SuccessorModTime, bts, err = msgp.ReadTimeBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "SuccessorModTime")
		return
	}
	z.Fresh, bts, err = msgp.ReadBoolBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Fresh")
		return
	}
	z.Idx, bts, err = msgp.ReadIntBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Idx")
		return
	}
	if msgp.IsNil(bts) {
		bts = bts[1:]
		z.Checksum = nil
	} else {
		z.Checksum, bts, err = msgp.ReadBytesBytes(bts, z.Checksum)
		if err != nil {
			err = msgp.WrapError(err, "Checksum")
			return
		}
	}
	z.Versioned, bts, err = msgp.ReadBoolBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Versioned")
		return
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *FileInfo) Msgsize() (s int) {
	s = 3 + msgp.StringPrefixSize + len(z.Volume) + msgp.StringPrefixSize + len(z.Name) + msgp.StringPrefixSize + len(z.VersionID) + msgp.BoolSize + msgp.BoolSize + msgp.StringPrefixSize + len(z.TransitionStatus) + msgp.StringPrefixSize + len(z.TransitionedObjName) + msgp.StringPrefixSize + len(z.TransitionTier) + msgp.StringPrefixSize + len(z.TransitionVersionID) + msgp.BoolSize + msgp.StringPrefixSize + len(z.DataDir) + msgp.BoolSize + msgp.TimeSize + msgp.Int64Size + msgp.Uint32Size + msgp.Uint64Size + msgp.MapHeaderSize
	if z.Metadata != nil {
		for za0001, za0002 := range z.Metadata {
			_ = za0002
			s += msgp.StringPrefixSize + len(za0001) + msgp.StringPrefixSize + len(za0002)
		}
	}
	s += msgp.ArrayHeaderSize
	for za0003 := range z.Parts {
		s += z.Parts[za0003].Msgsize()
	}
	s += z.Erasure.Msgsize() + msgp.BoolSize + z.ReplicationState.Msgsize() + msgp.BytesPrefixSize + len(z.Data) + msgp.IntSize + msgp.TimeSize + msgp.BoolSize + msgp.IntSize + msgp.BytesPrefixSize + len(z.Checksum) + msgp.BoolSize
	return
}

// DecodeMsg implements msgp.Decodable
func (z *FileInfoVersions) DecodeMsg(dc *msgp.Reader) (err error) {
	var zb0001 uint32
	zb0001, err = dc.ReadArrayHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	if zb0001 != 5 {
		err = msgp.ArrayError{Wanted: 5, Got: zb0001}
		return
	}
	z.Volume, err = dc.ReadString()
	if err != nil {
		err = msgp.WrapError(err, "Volume")
		return
	}
	z.Name, err = dc.ReadString()
	if err != nil {
		err = msgp.WrapError(err, "Name")
		return
	}
	z.LatestModTime, err = dc.ReadTime()
	if err != nil {
		err = msgp.WrapError(err, "LatestModTime")
		return
	}
	var zb0002 uint32
	zb0002, err = dc.ReadArrayHeader()
	if err != nil {
		err = msgp.WrapError(err, "Versions")
		return
	}
	if cap(z.Versions) >= int(zb0002) {
		z.Versions = (z.Versions)[:zb0002]
	} else {
		z.Versions = make([]FileInfo, zb0002)
	}
	for za0001 := range z.Versions {
		err = z.Versions[za0001].DecodeMsg(dc)
		if err != nil {
			err = msgp.WrapError(err, "Versions", za0001)
			return
		}
	}
	var zb0003 uint32
	zb0003, err = dc.ReadArrayHeader()
	if err != nil {
		err = msgp.WrapError(err, "FreeVersions")
		return
	}
	if cap(z.FreeVersions) >= int(zb0003) {
		z.FreeVersions = (z.FreeVersions)[:zb0003]
	} else {
		z.FreeVersions = make([]FileInfo, zb0003)
	}
	for za0002 := range z.FreeVersions {
		err = z.FreeVersions[za0002].DecodeMsg(dc)
		if err != nil {
			err = msgp.WrapError(err, "FreeVersions", za0002)
			return
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *FileInfoVersions) EncodeMsg(en *msgp.Writer) (err error) {
	// array header, size 5
	err = en.Append(0x95)
	if err != nil {
		return
	}
	err = en.WriteString(z.Volume)
	if err != nil {
		err = msgp.WrapError(err, "Volume")
		return
	}
	err = en.WriteString(z.Name)
	if err != nil {
		err = msgp.WrapError(err, "Name")
		return
	}
	err = en.WriteTime(z.LatestModTime)
	if err != nil {
		err = msgp.WrapError(err, "LatestModTime")
		return
	}
	err = en.WriteArrayHeader(uint32(len(z.Versions)))
	if err != nil {
		err = msgp.WrapError(err, "Versions")
		return
	}
	for za0001 := range z.Versions {
		err = z.Versions[za0001].EncodeMsg(en)
		if err != nil {
			err = msgp.WrapError(err, "Versions", za0001)
			return
		}
	}
	err = en.WriteArrayHeader(uint32(len(z.FreeVersions)))
	if err != nil {
		err = msgp.WrapError(err, "FreeVersions")
		return
	}
	for za0002 := range z.FreeVersions {
		err = z.FreeVersions[za0002].EncodeMsg(en)
		if err != nil {
			err = msgp.WrapError(err, "FreeVersions", za0002)
			return
		}
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *FileInfoVersions) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// array header, size 5
	o = append(o, 0x95)
	o = msgp.AppendString(o, z.Volume)
	o = msgp.AppendString(o, z.Name)
	o = msgp.AppendTime(o, z.LatestModTime)
	o = msgp.AppendArrayHeader(o, uint32(len(z.Versions)))
	for za0001 := range z.Versions {
		o, err = z.Versions[za0001].MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "Versions", za0001)
			return
		}
	}
	o = msgp.AppendArrayHeader(o, uint32(len(z.FreeVersions)))
	for za0002 := range z.FreeVersions {
		o, err = z.FreeVersions[za0002].MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "FreeVersions", za0002)
			return
		}
	}
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *FileInfoVersions) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadArrayHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	if zb0001 != 5 {
		err = msgp.ArrayError{Wanted: 5, Got: zb0001}
		return
	}
	z.Volume, bts, err = msgp.ReadStringBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Volume")
		return
	}
	z.Name, bts, err = msgp.ReadStringBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Name")
		return
	}
	z.LatestModTime, bts, err = msgp.ReadTimeBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "LatestModTime")
		return
	}
	var zb0002 uint32
	zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Versions")
		return
	}
	if cap(z.Versions) >= int(zb0002) {
		z.Versions = (z.Versions)[:zb0002]
	} else {
		z.Versions = make([]FileInfo, zb0002)
	}
	for za0001 := range z.Versions {
		bts, err = z.Versions[za0001].UnmarshalMsg(bts)
		if err != nil {
			err = msgp.WrapError(err, "Versions", za0001)
			return
		}
	}
	var zb0003 uint32
	zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "FreeVersions")
		return
	}
	if cap(z.FreeVersions) >= int(zb0003) {
		z.FreeVersions = (z.FreeVersions)[:zb0003]
	} else {
		z.FreeVersions = make([]FileInfo, zb0003)
	}
	for za0002 := range z.FreeVersions {
		bts, err = z.FreeVersions[za0002].UnmarshalMsg(bts)
		if err != nil {
			err = msgp.WrapError(err, "FreeVersions", za0002)
			return
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *FileInfoVersions) Msgsize() (s int) {
	s = 1 + msgp.StringPrefixSize + len(z.Volume) + msgp.StringPrefixSize + len(z.Name) + msgp.TimeSize + msgp.ArrayHeaderSize
	for za0001 := range z.Versions {
		s += z.Versions[za0001].Msgsize()
	}
	s += msgp.ArrayHeaderSize
	for za0002 := range z.FreeVersions {
		s += z.FreeVersions[za0002].Msgsize()
	}
	return
}

// DecodeMsg implements msgp.Decodable
func (z *FilesInfo) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "Files":
			var zb0002 uint32
			zb0002, err = dc.ReadArrayHeader()
			if err != nil {
				err = msgp.WrapError(err, "Files")
				return
			}
			if cap(z.Files) >= int(zb0002) {
				z.Files = (z.Files)[:zb0002]
			} else {
				z.Files = make([]FileInfo, zb0002)
			}
			for za0001 := range z.Files {
				err = z.Files[za0001].DecodeMsg(dc)
				if err != nil {
					err = msgp.WrapError(err, "Files", za0001)
					return
				}
			}
		case "IsTruncated":
			z.IsTruncated, err = dc.ReadBool()
			if err != nil {
				err = msgp.WrapError(err, "IsTruncated")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *FilesInfo) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 2
	// write "Files"
	err = en.Append(0x82, 0xa5, 0x46, 0x69, 0x6c, 0x65, 0x73)
	if err != nil {
		return
	}
	err = en.WriteArrayHeader(uint32(len(z.Files)))
	if err != nil {
		err = msgp.WrapError(err, "Files")
		return
	}
	for za0001 := range z.Files {
		err = z.Files[za0001].EncodeMsg(en)
		if err != nil {
			err = msgp.WrapError(err, "Files", za0001)
			return
		}
	}
	// write "IsTruncated"
	err = en.Append(0xab, 0x49, 0x73, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64)
	if err != nil {
		return
	}
	err = en.WriteBool(z.IsTruncated)
	if err != nil {
		err = msgp.WrapError(err, "IsTruncated")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *FilesInfo) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 2
	// string "Files"
	o = append(o, 0x82, 0xa5, 0x46, 0x69, 0x6c, 0x65, 0x73)
	o = msgp.AppendArrayHeader(o, uint32(len(z.Files)))
	for za0001 := range z.Files {
		o, err = z.Files[za0001].MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "Files", za0001)
			return
		}
	}
	// string "IsTruncated"
	o = append(o, 0xab, 0x49, 0x73, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64)
	o = msgp.AppendBool(o, z.IsTruncated)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *FilesInfo) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "Files":
			var zb0002 uint32
			zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Files")
				return
			}
			if cap(z.Files) >= int(zb0002) {
				z.Files = (z.Files)[:zb0002]
			} else {
				z.Files = make([]FileInfo, zb0002)
			}
			for za0001 := range z.Files {
				bts, err = z.Files[za0001].UnmarshalMsg(bts)
				if err != nil {
					err = msgp.WrapError(err, "Files", za0001)
					return
				}
			}
		case "IsTruncated":
			z.IsTruncated, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "IsTruncated")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *FilesInfo) Msgsize() (s int) {
	s = 1 + 6 + msgp.ArrayHeaderSize
	for za0001 := range z.Files {
		s += z.Files[za0001].Msgsize()
	}
	s += 12 + msgp.BoolSize
	return
}

// DecodeMsg implements msgp.Decodable
func (z *ListDirResult) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "e":
			var zb0002 uint32
			zb0002, err = dc.ReadArrayHeader()
			if err != nil {
				err = msgp.WrapError(err, "Entries")
				return
			}
			if cap(z.Entries) >= int(zb0002) {
				z.Entries = (z.Entries)[:zb0002]
			} else {
				z.Entries = make([]string, zb0002)
			}
			for za0001 := range z.Entries {
				z.Entries[za0001], err = dc.ReadString()
				if err != nil {
					err = msgp.WrapError(err, "Entries", za0001)
					return
				}
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *ListDirResult) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 1
	// write "e"
	err = en.Append(0x81, 0xa1, 0x65)
	if err != nil {
		return
	}
	err = en.WriteArrayHeader(uint32(len(z.Entries)))
	if err != nil {
		err = msgp.WrapError(err, "Entries")
		return
	}
	for za0001 := range z.Entries {
		err = en.WriteString(z.Entries[za0001])
		if err != nil {
			err = msgp.WrapError(err, "Entries", za0001)
			return
		}
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *ListDirResult) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 1
	// string "e"
	o = append(o, 0x81, 0xa1, 0x65)
	o = msgp.AppendArrayHeader(o, uint32(len(z.Entries)))
	for za0001 := range z.Entries {
		o = msgp.AppendString(o, z.Entries[za0001])
	}
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *ListDirResult) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "e":
			var zb0002 uint32
			zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Entries")
				return
			}
			if cap(z.Entries) >= int(zb0002) {
				z.Entries = (z.Entries)[:zb0002]
			} else {
				z.Entries = make([]string, zb0002)
			}
			for za0001 := range z.Entries {
				z.Entries[za0001], bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Entries", za0001)
					return
				}
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *ListDirResult) Msgsize() (s int) {
	s = 1 + 2 + msgp.ArrayHeaderSize
	for za0001 := range z.Entries {
		s += msgp.StringPrefixSize + len(z.Entries[za0001])
	}
	return
}

// DecodeMsg implements msgp.Decodable
func (z *LocalDiskIDs) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "IDs":
			var zb0002 uint32
			zb0002, err = dc.ReadArrayHeader()
			if err != nil {
				err = msgp.WrapError(err, "IDs")
				return
			}
			if cap(z.IDs) >= int(zb0002) {
				z.IDs = (z.IDs)[:zb0002]
			} else {
				z.IDs = make([]string, zb0002)
			}
			for za0001 := range z.IDs {
				z.IDs[za0001], err = dc.ReadString()
				if err != nil {
					err = msgp.WrapError(err, "IDs", za0001)
					return
				}
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *LocalDiskIDs) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 1
	// write "IDs"
	err = en.Append(0x81, 0xa3, 0x49, 0x44, 0x73)
	if err != nil {
		return
	}
	err = en.WriteArrayHeader(uint32(len(z.IDs)))
	if err != nil {
		err = msgp.WrapError(err, "IDs")
		return
	}
	for za0001 := range z.IDs {
		err = en.WriteString(z.IDs[za0001])
		if err != nil {
			err = msgp.WrapError(err, "IDs", za0001)
			return
		}
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *LocalDiskIDs) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 1
	// string "IDs"
	o = append(o, 0x81, 0xa3, 0x49, 0x44, 0x73)
	o = msgp.AppendArrayHeader(o, uint32(len(z.IDs)))
	for za0001 := range z.IDs {
		o = msgp.AppendString(o, z.IDs[za0001])
	}
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *LocalDiskIDs) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "IDs":
			var zb0002 uint32
			zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "IDs")
				return
			}
			if cap(z.IDs) >= int(zb0002) {
				z.IDs = (z.IDs)[:zb0002]
			} else {
				z.IDs = make([]string, zb0002)
			}
			for za0001 := range z.IDs {
				z.IDs[za0001], bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "IDs", za0001)
					return
				}
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *LocalDiskIDs) Msgsize() (s int) {
	s = 1 + 4 + msgp.ArrayHeaderSize
	for za0001 := range z.IDs {
		s += msgp.StringPrefixSize + len(z.IDs[za0001])
	}
	return
}

// DecodeMsg implements msgp.Decodable
func (z *MetadataHandlerParams) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "id":
			z.DiskID, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "DiskID")
				return
			}
		case "v":
			z.Volume, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Volume")
				return
			}
		case "ov":
			z.OrigVolume, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "OrigVolume")
				return
			}
		case "fp":
			z.FilePath, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "FilePath")
				return
			}
		case "uo":
			var zb0002 uint32
			zb0002, err = dc.ReadMapHeader()
			if err != nil {
				err = msgp.WrapError(err, "UpdateOpts")
				return
			}
			for zb0002 > 0 {
				zb0002--
				field, err = dc.ReadMapKeyPtr()
				if err != nil {
					err = msgp.WrapError(err, "UpdateOpts")
					return
				}
				switch msgp.UnsafeString(field) {
				case "np":
					z.UpdateOpts.NoPersistence, err = dc.ReadBool()
					if err != nil {
						err = msgp.WrapError(err, "UpdateOpts", "NoPersistence")
						return
					}
				default:
					err = dc.Skip()
					if err != nil {
						err = msgp.WrapError(err, "UpdateOpts")
						return
					}
				}
			}
		case "fi":
			err = z.FI.DecodeMsg(dc)
			if err != nil {
				err = msgp.WrapError(err, "FI")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *MetadataHandlerParams) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 6
	// write "id"
	err = en.Append(0x86, 0xa2, 0x69, 0x64)
	if err != nil {
		return
	}
	err = en.WriteString(z.DiskID)
	if err != nil {
		err = msgp.WrapError(err, "DiskID")
		return
	}
	// write "v"
	err = en.Append(0xa1, 0x76)
	if err != nil {
		return
	}
	err = en.WriteString(z.Volume)
	if err != nil {
		err = msgp.WrapError(err, "Volume")
		return
	}
	// write "ov"
	err = en.Append(0xa2, 0x6f, 0x76)
	if err != nil {
		return
	}
	err = en.WriteString(z.OrigVolume)
	if err != nil {
		err = msgp.WrapError(err, "OrigVolume")
		return
	}
	// write "fp"
	err = en.Append(0xa2, 0x66, 0x70)
	if err != nil {
		return
	}
	err = en.WriteString(z.FilePath)
	if err != nil {
		err = msgp.WrapError(err, "FilePath")
		return
	}
	// write "uo"
	err = en.Append(0xa2, 0x75, 0x6f)
	if err != nil {
		return
	}
	// map header, size 1
	// write "np"
	err = en.Append(0x81, 0xa2, 0x6e, 0x70)
	if err != nil {
		return
	}
	err = en.WriteBool(z.UpdateOpts.NoPersistence)
	if err != nil {
		err = msgp.WrapError(err, "UpdateOpts", "NoPersistence")
		return
	}
	// write "fi"
	err = en.Append(0xa2, 0x66, 0x69)
	if err != nil {
		return
	}
	err = z.FI.EncodeMsg(en)
	if err != nil {
		err = msgp.WrapError(err, "FI")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *MetadataHandlerParams) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 6
	// string "id"
	o = append(o, 0x86, 0xa2, 0x69, 0x64)
	o = msgp.AppendString(o, z.DiskID)
	// string "v"
	o = append(o, 0xa1, 0x76)
	o = msgp.AppendString(o, z.Volume)
	// string "ov"
	o = append(o, 0xa2, 0x6f, 0x76)
	o = msgp.AppendString(o, z.OrigVolume)
	// string "fp"
	o = append(o, 0xa2, 0x66, 0x70)
	o = msgp.AppendString(o, z.FilePath)
	// string "uo"
	o = append(o, 0xa2, 0x75, 0x6f)
	// map header, size 1
	// string "np"
	o = append(o, 0x81, 0xa2, 0x6e, 0x70)
	o = msgp.AppendBool(o, z.UpdateOpts.NoPersistence)
	// string "fi"
	o = append(o, 0xa2, 0x66, 0x69)
	o, err = z.FI.MarshalMsg(o)
	if err != nil {
		err = msgp.WrapError(err, "FI")
		return
	}
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *MetadataHandlerParams) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "id":
			z.DiskID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "DiskID")
				return
			}
		case "v":
			z.Volume, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Volume")
				return
			}
		case "ov":
			z.OrigVolume, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "OrigVolume")
				return
			}
		case "fp":
			z.FilePath, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "FilePath")
				return
			}
		case "uo":
			var zb0002 uint32
			zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "UpdateOpts")
				return
			}
			for zb0002 > 0 {
				zb0002--
				field, bts, err = msgp.ReadMapKeyZC(bts)
				if err != nil {
					err = msgp.WrapError(err, "UpdateOpts")
					return
				}
				switch msgp.UnsafeString(field) {
				case "np":
					z.UpdateOpts.NoPersistence, bts, err = msgp.ReadBoolBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "UpdateOpts", "NoPersistence")
						return
					}
				default:
					bts, err = msgp.Skip(bts)
					if err != nil {
						err = msgp.WrapError(err, "UpdateOpts")
						return
					}
				}
			}
		case "fi":
			bts, err = z.FI.UnmarshalMsg(bts)
			if err != nil {
				err = msgp.WrapError(err, "FI")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *MetadataHandlerParams) Msgsize() (s int) {
	s = 1 + 3 + msgp.StringPrefixSize + len(z.DiskID) + 2 + msgp.StringPrefixSize + len(z.Volume) + 3 + msgp.StringPrefixSize + len(z.OrigVolume) + 3 + msgp.StringPrefixSize + len(z.FilePath) + 3 + 1 + 3 + msgp.BoolSize + 3 + z.FI.Msgsize()
	return
}

// DecodeMsg implements msgp.Decodable
func (z *RawFileInfo) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "b":
			if dc.IsNil() {
				err = dc.ReadNil()
				if err != nil {
					err = msgp.WrapError(err, "Buf")
					return
				}
				z.Buf = nil
			} else {
				z.Buf, err = dc.ReadBytes(z.Buf)
				if err != nil {
					err = msgp.WrapError(err, "Buf")
					return
				}
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *RawFileInfo) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 1
	// write "b"
	err = en.Append(0x81, 0xa1, 0x62)
	if err != nil {
		return
	}
	if z.Buf == nil { // allownil: if nil
		err = en.WriteNil()
		if err != nil {
			return
		}
	} else {
		err = en.WriteBytes(z.Buf)
		if err != nil {
			err = msgp.WrapError(err, "Buf")
			return
		}
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *RawFileInfo) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 1
	// string "b"
	o = append(o, 0x81, 0xa1, 0x62)
	if z.Buf == nil { // allownil: if nil
		o = msgp.AppendNil(o)
	} else {
		o = msgp.AppendBytes(o, z.Buf)
	}
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *RawFileInfo) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "b":
			if msgp.IsNil(bts) {
				bts = bts[1:]
				z.Buf = nil
			} else {
				z.Buf, bts, err = msgp.ReadBytesBytes(bts, z.Buf)
				if err != nil {
					err = msgp.WrapError(err, "Buf")
					return
				}
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *RawFileInfo) Msgsize() (s int) {
	s = 1 + 2 + msgp.BytesPrefixSize + len(z.Buf)
	return
}

// DecodeMsg implements msgp.Decodable
func (z *ReadAllHandlerParams) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "id":
			z.DiskID, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "DiskID")
				return
			}
		case "v":
			z.Volume, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Volume")
				return
			}
		case "fp":
			z.FilePath, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "FilePath")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z ReadAllHandlerParams) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 3
	// write "id"
	err = en.Append(0x83, 0xa2, 0x69, 0x64)
	if err != nil {
		return
	}
	err = en.WriteString(z.DiskID)
	if err != nil {
		err = msgp.WrapError(err, "DiskID")
		return
	}
	// write "v"
	err = en.Append(0xa1, 0x76)
	if err != nil {
		return
	}
	err = en.WriteString(z.Volume)
	if err != nil {
		err = msgp.WrapError(err, "Volume")
		return
	}
	// write "fp"
	err = en.Append(0xa2, 0x66, 0x70)
	if err != nil {
		return
	}
	err = en.WriteString(z.FilePath)
	if err != nil {
		err = msgp.WrapError(err, "FilePath")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z ReadAllHandlerParams) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 3
	// string "id"
	o = append(o, 0x83, 0xa2, 0x69, 0x64)
	o = msgp.AppendString(o, z.DiskID)
	// string "v"
	o = append(o, 0xa1, 0x76)
	o = msgp.AppendString(o, z.Volume)
	// string "fp"
	o = append(o, 0xa2, 0x66, 0x70)
	o = msgp.AppendString(o, z.FilePath)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *ReadAllHandlerParams) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "id":
			z.DiskID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "DiskID")
				return
			}
		case "v":
			z.Volume, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Volume")
				return
			}
		case "fp":
			z.FilePath, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "FilePath")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z ReadAllHandlerParams) Msgsize() (s int) {
	s = 1 + 3 + msgp.StringPrefixSize + len(z.DiskID) + 2 + msgp.StringPrefixSize + len(z.Volume) + 3 + msgp.StringPrefixSize + len(z.FilePath)
	return
}

// DecodeMsg implements msgp.Decodable
func (z *ReadMultipleReq) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "Bucket":
			z.Bucket, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Bucket")
				return
			}
		case "Prefix":
			z.Prefix, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Prefix")
				return
			}
		case "Files":
			var zb0002 uint32
			zb0002, err = dc.ReadArrayHeader()
			if err != nil {
				err = msgp.WrapError(err, "Files")
				return
			}
			if cap(z.Files) >= int(zb0002) {
				z.Files = (z.Files)[:zb0002]
			} else {
				z.Files = make([]string, zb0002)
			}
			for za0001 := range z.Files {
				z.Files[za0001], err = dc.ReadString()
				if err != nil {
					err = msgp.WrapError(err, "Files", za0001)
					return
				}
			}
		case "MaxSize":
			z.MaxSize, err = dc.ReadInt64()
			if err != nil {
				err = msgp.WrapError(err, "MaxSize")
				return
			}
		case "MetadataOnly":
			z.MetadataOnly, err = dc.ReadBool()
			if err != nil {
				err = msgp.WrapError(err, "MetadataOnly")
				return
			}
		case "AbortOn404":
			z.AbortOn404, err = dc.ReadBool()
			if err != nil {
				err = msgp.WrapError(err, "AbortOn404")
				return
			}
		case "MaxResults":
			z.MaxResults, err = dc.ReadInt()
			if err != nil {
				err = msgp.WrapError(err, "MaxResults")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *ReadMultipleReq) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 7
	// write "Bucket"
	err = en.Append(0x87, 0xa6, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74)
	if err != nil {
		return
	}
	err = en.WriteString(z.Bucket)
	if err != nil {
		err = msgp.WrapError(err, "Bucket")
		return
	}
	// write "Prefix"
	err = en.Append(0xa6, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78)
	if err != nil {
		return
	}
	err = en.WriteString(z.Prefix)
	if err != nil {
		err = msgp.WrapError(err, "Prefix")
		return
	}
	// write "Files"
	err = en.Append(0xa5, 0x46, 0x69, 0x6c, 0x65, 0x73)
	if err != nil {
		return
	}
	err = en.WriteArrayHeader(uint32(len(z.Files)))
	if err != nil {
		err = msgp.WrapError(err, "Files")
		return
	}
	for za0001 := range z.Files {
		err = en.WriteString(z.Files[za0001])
		if err != nil {
			err = msgp.WrapError(err, "Files", za0001)
			return
		}
	}
	// write "MaxSize"
	err = en.Append(0xa7, 0x4d, 0x61, 0x78, 0x53, 0x69, 0x7a, 0x65)
	if err != nil {
		return
	}
	err = en.WriteInt64(z.MaxSize)
	if err != nil {
		err = msgp.WrapError(err, "MaxSize")
		return
	}
	// write "MetadataOnly"
	err = en.Append(0xac, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4f, 0x6e, 0x6c, 0x79)
	if err != nil {
		return
	}
	err = en.WriteBool(z.MetadataOnly)
	if err != nil {
		err = msgp.WrapError(err, "MetadataOnly")
		return
	}
	// write "AbortOn404"
	err = en.Append(0xaa, 0x41, 0x62, 0x6f, 0x72, 0x74, 0x4f, 0x6e, 0x34, 0x30, 0x34)
	if err != nil {
		return
	}
	err = en.WriteBool(z.AbortOn404)
	if err != nil {
		err = msgp.WrapError(err, "AbortOn404")
		return
	}
	// write "MaxResults"
	err = en.Append(0xaa, 0x4d, 0x61, 0x78, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73)
	if err != nil {
		return
	}
	err = en.WriteInt(z.MaxResults)
	if err != nil {
		err = msgp.WrapError(err, "MaxResults")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *ReadMultipleReq) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 7
	// string "Bucket"
	o = append(o, 0x87, 0xa6, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74)
	o = msgp.AppendString(o, z.Bucket)
	// string "Prefix"
	o = append(o, 0xa6, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78)
	o = msgp.AppendString(o, z.Prefix)
	// string "Files"
	o = append(o, 0xa5, 0x46, 0x69, 0x6c, 0x65, 0x73)
	o = msgp.AppendArrayHeader(o, uint32(len(z.Files)))
	for za0001 := range z.Files {
		o = msgp.AppendString(o, z.Files[za0001])
	}
	// string "MaxSize"
	o = append(o, 0xa7, 0x4d, 0x61, 0x78, 0x53, 0x69, 0x7a, 0x65)
	o = msgp.AppendInt64(o, z.MaxSize)
	// string "MetadataOnly"
	o = append(o, 0xac, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4f, 0x6e, 0x6c, 0x79)
	o = msgp.AppendBool(o, z.MetadataOnly)
	// string "AbortOn404"
	o = append(o, 0xaa, 0x41, 0x62, 0x6f, 0x72, 0x74, 0x4f, 0x6e, 0x34, 0x30, 0x34)
	o = msgp.AppendBool(o, z.AbortOn404)
	// string "MaxResults"
	o = append(o, 0xaa, 0x4d, 0x61, 0x78, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73)
	o = msgp.AppendInt(o, z.MaxResults)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *ReadMultipleReq) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "Bucket":
			z.Bucket, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Bucket")
				return
			}
		case "Prefix":
			z.Prefix, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Prefix")
				return
			}
		case "Files":
			var zb0002 uint32
			zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Files")
				return
			}
			if cap(z.Files) >= int(zb0002) {
				z.Files = (z.Files)[:zb0002]
			} else {
				z.Files = make([]string, zb0002)
			}
			for za0001 := range z.Files {
				z.Files[za0001], bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Files", za0001)
					return
				}
			}
		case "MaxSize":
			z.MaxSize, bts, err = msgp.ReadInt64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "MaxSize")
				return
			}
		case "MetadataOnly":
			z.MetadataOnly, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "MetadataOnly")
				return
			}
		case "AbortOn404":
			z.AbortOn404, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "AbortOn404")
				return
			}
		case "MaxResults":
			z.MaxResults, bts, err = msgp.ReadIntBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "MaxResults")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *ReadMultipleReq) Msgsize() (s int) {
	s = 1 + 7 + msgp.StringPrefixSize + len(z.Bucket) + 7 + msgp.StringPrefixSize + len(z.Prefix) + 6 + msgp.ArrayHeaderSize
	for za0001 := range z.Files {
		s += msgp.StringPrefixSize + len(z.Files[za0001])
	}
	s += 8 + msgp.Int64Size + 13 + msgp.BoolSize + 11 + msgp.BoolSize + 11 + msgp.IntSize
	return
}

// DecodeMsg implements msgp.Decodable
func (z *ReadMultipleResp) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "Bucket":
			z.Bucket, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Bucket")
				return
			}
		case "Prefix":
			z.Prefix, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Prefix")
				return
			}
		case "File":
			z.File, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "File")
				return
			}
		case "Exists":
			z.Exists, err = dc.ReadBool()
			if err != nil {
				err = msgp.WrapError(err, "Exists")
				return
			}
		case "Error":
			z.Error, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Error")
				return
			}
		case "Data":
			z.Data, err = dc.ReadBytes(z.Data)
			if err != nil {
				err = msgp.WrapError(err, "Data")
				return
			}
		case "Modtime":
			z.Modtime, err = dc.ReadTime()
			if err != nil {
				err = msgp.WrapError(err, "Modtime")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *ReadMultipleResp) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 7
	// write "Bucket"
	err = en.Append(0x87, 0xa6, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74)
	if err != nil {
		return
	}
	err = en.WriteString(z.Bucket)
	if err != nil {
		err = msgp.WrapError(err, "Bucket")
		return
	}
	// write "Prefix"
	err = en.Append(0xa6, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78)
	if err != nil {
		return
	}
	err = en.WriteString(z.Prefix)
	if err != nil {
		err = msgp.WrapError(err, "Prefix")
		return
	}
	// write "File"
	err = en.Append(0xa4, 0x46, 0x69, 0x6c, 0x65)
	if err != nil {
		return
	}
	err = en.WriteString(z.File)
	if err != nil {
		err = msgp.WrapError(err, "File")
		return
	}
	// write "Exists"
	err = en.Append(0xa6, 0x45, 0x78, 0x69, 0x73, 0x74, 0x73)
	if err != nil {
		return
	}
	err = en.WriteBool(z.Exists)
	if err != nil {
		err = msgp.WrapError(err, "Exists")
		return
	}
	// write "Error"
	err = en.Append(0xa5, 0x45, 0x72, 0x72, 0x6f, 0x72)
	if err != nil {
		return
	}
	err = en.WriteString(z.Error)
	if err != nil {
		err = msgp.WrapError(err, "Error")
		return
	}
	// write "Data"
	err = en.Append(0xa4, 0x44, 0x61, 0x74, 0x61)
	if err != nil {
		return
	}
	err = en.WriteBytes(z.Data)
	if err != nil {
		err = msgp.WrapError(err, "Data")
		return
	}
	// write "Modtime"
	err = en.Append(0xa7, 0x4d, 0x6f, 0x64, 0x74, 0x69, 0x6d, 0x65)
	if err != nil {
		return
	}
	err = en.WriteTime(z.Modtime)
	if err != nil {
		err = msgp.WrapError(err, "Modtime")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *ReadMultipleResp) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 7
	// string "Bucket"
	o = append(o, 0x87, 0xa6, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74)
	o = msgp.AppendString(o, z.Bucket)
	// string "Prefix"
	o = append(o, 0xa6, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78)
	o = msgp.AppendString(o, z.Prefix)
	// string "File"
	o = append(o, 0xa4, 0x46, 0x69, 0x6c, 0x65)
	o = msgp.AppendString(o, z.File)
	// string "Exists"
	o = append(o, 0xa6, 0x45, 0x78, 0x69, 0x73, 0x74, 0x73)
	o = msgp.AppendBool(o, z.Exists)
	// string "Error"
	o = append(o, 0xa5, 0x45, 0x72, 0x72, 0x6f, 0x72)
	o = msgp.AppendString(o, z.Error)
	// string "Data"
	o = append(o, 0xa4, 0x44, 0x61, 0x74, 0x61)
	o = msgp.AppendBytes(o, z.Data)
	// string "Modtime"
	o = append(o, 0xa7, 0x4d, 0x6f, 0x64, 0x74, 0x69, 0x6d, 0x65)
	o = msgp.AppendTime(o, z.Modtime)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *ReadMultipleResp) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "Bucket":
			z.Bucket, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Bucket")
				return
			}
		case "Prefix":
			z.Prefix, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Prefix")
				return
			}
		case "File":
			z.File, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "File")
				return
			}
		case "Exists":
			z.Exists, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Exists")
				return
			}
		case "Error":
			z.Error, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Error")
				return
			}
		case "Data":
			z.Data, bts, err = msgp.ReadBytesBytes(bts, z.Data)
			if err != nil {
				err = msgp.WrapError(err, "Data")
				return
			}
		case "Modtime":
			z.Modtime, bts, err = msgp.ReadTimeBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Modtime")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *ReadMultipleResp) Msgsize() (s int) {
	s = 1 + 7 + msgp.StringPrefixSize + len(z.Bucket) + 7 + msgp.StringPrefixSize + len(z.Prefix) + 5 + msgp.StringPrefixSize + len(z.File) + 7 + msgp.BoolSize + 6 + msgp.StringPrefixSize + len(z.Error) + 5 + msgp.BytesPrefixSize + len(z.Data) + 8 + msgp.TimeSize
	return
}

// DecodeMsg implements msgp.Decodable
func (z *RenameDataHandlerParams) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "id":
			z.DiskID, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "DiskID")
				return
			}
		case "sv":
			z.SrcVolume, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "SrcVolume")
				return
			}
		case "sp":
			z.SrcPath, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "SrcPath")
				return
			}
		case "dv":
			z.DstVolume, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "DstVolume")
				return
			}
		case "dp":
			z.DstPath, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "DstPath")
				return
			}
		case "fi":
			err = z.FI.DecodeMsg(dc)
			if err != nil {
				err = msgp.WrapError(err, "FI")
				return
			}
		case "ro":
			var zb0002 uint32
			zb0002, err = dc.ReadMapHeader()
			if err != nil {
				err = msgp.WrapError(err, "Opts")
				return
			}
			for zb0002 > 0 {
				zb0002--
				field, err = dc.ReadMapKeyPtr()
				if err != nil {
					err = msgp.WrapError(err, "Opts")
					return
				}
				switch msgp.UnsafeString(field) {
				case "BaseOptions":
					var zb0003 uint32
					zb0003, err = dc.ReadMapHeader()
					if err != nil {
						err = msgp.WrapError(err, "Opts", "BaseOptions")
						return
					}
					for zb0003 > 0 {
						zb0003--
						field, err = dc.ReadMapKeyPtr()
						if err != nil {
							err = msgp.WrapError(err, "Opts", "BaseOptions")
							return
						}
						switch msgp.UnsafeString(field) {
						default:
							err = dc.Skip()
							if err != nil {
								err = msgp.WrapError(err, "Opts", "BaseOptions")
								return
							}
						}
					}
				default:
					err = dc.Skip()
					if err != nil {
						err = msgp.WrapError(err, "Opts")
						return
					}
				}
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *RenameDataHandlerParams) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 7
	// write "id"
	err = en.Append(0x87, 0xa2, 0x69, 0x64)
	if err != nil {
		return
	}
	err = en.WriteString(z.DiskID)
	if err != nil {
		err = msgp.WrapError(err, "DiskID")
		return
	}
	// write "sv"
	err = en.Append(0xa2, 0x73, 0x76)
	if err != nil {
		return
	}
	err = en.WriteString(z.SrcVolume)
	if err != nil {
		err = msgp.WrapError(err, "SrcVolume")
		return
	}
	// write "sp"
	err = en.Append(0xa2, 0x73, 0x70)
	if err != nil {
		return
	}
	err = en.WriteString(z.SrcPath)
	if err != nil {
		err = msgp.WrapError(err, "SrcPath")
		return
	}
	// write "dv"
	err = en.Append(0xa2, 0x64, 0x76)
	if err != nil {
		return
	}
	err = en.WriteString(z.DstVolume)
	if err != nil {
		err = msgp.WrapError(err, "DstVolume")
		return
	}
	// write "dp"
	err = en.Append(0xa2, 0x64, 0x70)
	if err != nil {
		return
	}
	err = en.WriteString(z.DstPath)
	if err != nil {
		err = msgp.WrapError(err, "DstPath")
		return
	}
	// write "fi"
	err = en.Append(0xa2, 0x66, 0x69)
	if err != nil {
		return
	}
	err = z.FI.EncodeMsg(en)
	if err != nil {
		err = msgp.WrapError(err, "FI")
		return
	}
	// write "ro"
	err = en.Append(0xa2, 0x72, 0x6f)
	if err != nil {
		return
	}
	// map header, size 1
	// write "BaseOptions"
	err = en.Append(0x81, 0xab, 0x42, 0x61, 0x73, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73)
	if err != nil {
		return
	}
	// map header, size 0
	_ = z.Opts.BaseOptions
	err = en.Append(0x80)
	if err != nil {
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *RenameDataHandlerParams) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 7
	// string "id"
	o = append(o, 0x87, 0xa2, 0x69, 0x64)
	o = msgp.AppendString(o, z.DiskID)
	// string "sv"
	o = append(o, 0xa2, 0x73, 0x76)
	o = msgp.AppendString(o, z.SrcVolume)
	// string "sp"
	o = append(o, 0xa2, 0x73, 0x70)
	o = msgp.AppendString(o, z.SrcPath)
	// string "dv"
	o = append(o, 0xa2, 0x64, 0x76)
	o = msgp.AppendString(o, z.DstVolume)
	// string "dp"
	o = append(o, 0xa2, 0x64, 0x70)
	o = msgp.AppendString(o, z.DstPath)
	// string "fi"
	o = append(o, 0xa2, 0x66, 0x69)
	o, err = z.FI.MarshalMsg(o)
	if err != nil {
		err = msgp.WrapError(err, "FI")
		return
	}
	// string "ro"
	o = append(o, 0xa2, 0x72, 0x6f)
	// map header, size 1
	// string "BaseOptions"
	o = append(o, 0x81, 0xab, 0x42, 0x61, 0x73, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73)
	// map header, size 0
	_ = z.Opts.BaseOptions
	o = append(o, 0x80)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *RenameDataHandlerParams) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "id":
			z.DiskID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "DiskID")
				return
			}
		case "sv":
			z.SrcVolume, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "SrcVolume")
				return
			}
		case "sp":
			z.SrcPath, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "SrcPath")
				return
			}
		case "dv":
			z.DstVolume, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "DstVolume")
				return
			}
		case "dp":
			z.DstPath, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "DstPath")
				return
			}
		case "fi":
			bts, err = z.FI.UnmarshalMsg(bts)
			if err != nil {
				err = msgp.WrapError(err, "FI")
				return
			}
		case "ro":
			var zb0002 uint32
			zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Opts")
				return
			}
			for zb0002 > 0 {
				zb0002--
				field, bts, err = msgp.ReadMapKeyZC(bts)
				if err != nil {
					err = msgp.WrapError(err, "Opts")
					return
				}
				switch msgp.UnsafeString(field) {
				case "BaseOptions":
					var zb0003 uint32
					zb0003, bts, err = msgp.ReadMapHeaderBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Opts", "BaseOptions")
						return
					}
					for zb0003 > 0 {
						zb0003--
						field, bts, err = msgp.ReadMapKeyZC(bts)
						if err != nil {
							err = msgp.WrapError(err, "Opts", "BaseOptions")
							return
						}
						switch msgp.UnsafeString(field) {
						default:
							bts, err = msgp.Skip(bts)
							if err != nil {
								err = msgp.WrapError(err, "Opts", "BaseOptions")
								return
							}
						}
					}
				default:
					bts, err = msgp.Skip(bts)
					if err != nil {
						err = msgp.WrapError(err, "Opts")
						return
					}
				}
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *RenameDataHandlerParams) Msgsize() (s int) {
	s = 1 + 3 + msgp.StringPrefixSize + len(z.DiskID) + 3 + msgp.StringPrefixSize + len(z.SrcVolume) + 3 + msgp.StringPrefixSize + len(z.SrcPath) + 3 + msgp.StringPrefixSize + len(z.DstVolume) + 3 + msgp.StringPrefixSize + len(z.DstPath) + 3 + z.FI.Msgsize() + 3 + 1 + 12 + 1
	return
}

// DecodeMsg implements msgp.Decodable
func (z *RenameDataInlineHandlerParams) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "p":
			err = z.RenameDataHandlerParams.DecodeMsg(dc)
			if err != nil {
				err = msgp.WrapError(err, "RenameDataHandlerParams")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *RenameDataInlineHandlerParams) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 1
	// write "p"
	err = en.Append(0x81, 0xa1, 0x70)
	if err != nil {
		return
	}
	err = z.RenameDataHandlerParams.EncodeMsg(en)
	if err != nil {
		err = msgp.WrapError(err, "RenameDataHandlerParams")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *RenameDataInlineHandlerParams) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 1
	// string "p"
	o = append(o, 0x81, 0xa1, 0x70)
	o, err = z.RenameDataHandlerParams.MarshalMsg(o)
	if err != nil {
		err = msgp.WrapError(err, "RenameDataHandlerParams")
		return
	}
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *RenameDataInlineHandlerParams) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "p":
			bts, err = z.RenameDataHandlerParams.UnmarshalMsg(bts)
			if err != nil {
				err = msgp.WrapError(err, "RenameDataHandlerParams")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *RenameDataInlineHandlerParams) Msgsize() (s int) {
	s = 1 + 2 + z.RenameDataHandlerParams.Msgsize()
	return
}

// DecodeMsg implements msgp.Decodable
func (z *RenameDataResp) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "Sign":
			z.Sign, err = dc.ReadBytes(z.Sign)
			if err != nil {
				err = msgp.WrapError(err, "Sign")
				return
			}
		case "OldDataDir":
			z.OldDataDir, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "OldDataDir")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *RenameDataResp) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 2
	// write "Sign"
	err = en.Append(0x82, 0xa4, 0x53, 0x69, 0x67, 0x6e)
	if err != nil {
		return
	}
	err = en.WriteBytes(z.Sign)
	if err != nil {
		err = msgp.WrapError(err, "Sign")
		return
	}
	// write "OldDataDir"
	err = en.Append(0xaa, 0x4f, 0x6c, 0x64, 0x44, 0x61, 0x74, 0x61, 0x44, 0x69, 0x72)
	if err != nil {
		return
	}
	err = en.WriteString(z.OldDataDir)
	if err != nil {
		err = msgp.WrapError(err, "OldDataDir")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *RenameDataResp) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 2
	// string "Sign"
	o = append(o, 0x82, 0xa4, 0x53, 0x69, 0x67, 0x6e)
	o = msgp.AppendBytes(o, z.Sign)
	// string "OldDataDir"
	o = append(o, 0xaa, 0x4f, 0x6c, 0x64, 0x44, 0x61, 0x74, 0x61, 0x44, 0x69, 0x72)
	o = msgp.AppendString(o, z.OldDataDir)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *RenameDataResp) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "Sign":
			z.Sign, bts, err = msgp.ReadBytesBytes(bts, z.Sign)
			if err != nil {
				err = msgp.WrapError(err, "Sign")
				return
			}
		case "OldDataDir":
			z.OldDataDir, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "OldDataDir")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *RenameDataResp) Msgsize() (s int) {
	s = 1 + 5 + msgp.BytesPrefixSize + len(z.Sign) + 11 + msgp.StringPrefixSize + len(z.OldDataDir)
	return
}

// DecodeMsg implements msgp.Decodable
func (z *RenameFileHandlerParams) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "id":
			z.DiskID, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "DiskID")
				return
			}
		case "sv":
			z.SrcVolume, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "SrcVolume")
				return
			}
		case "sp":
			z.SrcFilePath, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "SrcFilePath")
				return
			}
		case "dv":
			z.DstVolume, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "DstVolume")
				return
			}
		case "dp":
			z.DstFilePath, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "DstFilePath")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *RenameFileHandlerParams) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 5
	// write "id"
	err = en.Append(0x85, 0xa2, 0x69, 0x64)
	if err != nil {
		return
	}
	err = en.WriteString(z.DiskID)
	if err != nil {
		err = msgp.WrapError(err, "DiskID")
		return
	}
	// write "sv"
	err = en.Append(0xa2, 0x73, 0x76)
	if err != nil {
		return
	}
	err = en.WriteString(z.SrcVolume)
	if err != nil {
		err = msgp.WrapError(err, "SrcVolume")
		return
	}
	// write "sp"
	err = en.Append(0xa2, 0x73, 0x70)
	if err != nil {
		return
	}
	err = en.WriteString(z.SrcFilePath)
	if err != nil {
		err = msgp.WrapError(err, "SrcFilePath")
		return
	}
	// write "dv"
	err = en.Append(0xa2, 0x64, 0x76)
	if err != nil {
		return
	}
	err = en.WriteString(z.DstVolume)
	if err != nil {
		err = msgp.WrapError(err, "DstVolume")
		return
	}
	// write "dp"
	err = en.Append(0xa2, 0x64, 0x70)
	if err != nil {
		return
	}
	err = en.WriteString(z.DstFilePath)
	if err != nil {
		err = msgp.WrapError(err, "DstFilePath")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *RenameFileHandlerParams) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 5
	// string "id"
	o = append(o, 0x85, 0xa2, 0x69, 0x64)
	o = msgp.AppendString(o, z.DiskID)
	// string "sv"
	o = append(o, 0xa2, 0x73, 0x76)
	o = msgp.AppendString(o, z.SrcVolume)
	// string "sp"
	o = append(o, 0xa2, 0x73, 0x70)
	o = msgp.AppendString(o, z.SrcFilePath)
	// string "dv"
	o = append(o, 0xa2, 0x64, 0x76)
	o = msgp.AppendString(o, z.DstVolume)
	// string "dp"
	o = append(o, 0xa2, 0x64, 0x70)
	o = msgp.AppendString(o, z.DstFilePath)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *RenameFileHandlerParams) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "id":
			z.DiskID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "DiskID")
				return
			}
		case "sv":
			z.SrcVolume, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "SrcVolume")
				return
			}
		case "sp":
			z.SrcFilePath, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "SrcFilePath")
				return
			}
		case "dv":
			z.DstVolume, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "DstVolume")
				return
			}
		case "dp":
			z.DstFilePath, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "DstFilePath")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *RenameFileHandlerParams) Msgsize() (s int) {
	s = 1 + 3 + msgp.StringPrefixSize + len(z.DiskID) + 3 + msgp.StringPrefixSize + len(z.SrcVolume) + 3 + msgp.StringPrefixSize + len(z.SrcFilePath) + 3 + msgp.StringPrefixSize + len(z.DstVolume) + 3 + msgp.StringPrefixSize + len(z.DstFilePath)
	return
}

// DecodeMsg implements msgp.Decodable
func (z *RenameOptions) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "BaseOptions":
			var zb0002 uint32
			zb0002, err = dc.ReadMapHeader()
			if err != nil {
				err = msgp.WrapError(err, "BaseOptions")
				return
			}
			for zb0002 > 0 {
				zb0002--
				field, err = dc.ReadMapKeyPtr()
				if err != nil {
					err = msgp.WrapError(err, "BaseOptions")
					return
				}
				switch msgp.UnsafeString(field) {
				default:
					err = dc.Skip()
					if err != nil {
						err = msgp.WrapError(err, "BaseOptions")
						return
					}
				}
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *RenameOptions) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 1
	// write "BaseOptions"
	err = en.Append(0x81, 0xab, 0x42, 0x61, 0x73, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73)
	if err != nil {
		return
	}
	// map header, size 0
	_ = z.BaseOptions
	err = en.Append(0x80)
	if err != nil {
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *RenameOptions) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 1
	// string "BaseOptions"
	o = append(o, 0x81, 0xab, 0x42, 0x61, 0x73, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73)
	// map header, size 0
	_ = z.BaseOptions
	o = append(o, 0x80)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *RenameOptions) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "BaseOptions":
			var zb0002 uint32
			zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "BaseOptions")
				return
			}
			for zb0002 > 0 {
				zb0002--
				field, bts, err = msgp.ReadMapKeyZC(bts)
				if err != nil {
					err = msgp.WrapError(err, "BaseOptions")
					return
				}
				switch msgp.UnsafeString(field) {
				default:
					bts, err = msgp.Skip(bts)
					if err != nil {
						err = msgp.WrapError(err, "BaseOptions")
						return
					}
				}
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *RenameOptions) Msgsize() (s int) {
	s = 1 + 12 + 1
	return
}

// DecodeMsg implements msgp.Decodable
func (z *UpdateMetadataOpts) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "np":
			z.NoPersistence, err = dc.ReadBool()
			if err != nil {
				err = msgp.WrapError(err, "NoPersistence")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z UpdateMetadataOpts) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 1
	// write "np"
	err = en.Append(0x81, 0xa2, 0x6e, 0x70)
	if err != nil {
		return
	}
	err = en.WriteBool(z.NoPersistence)
	if err != nil {
		err = msgp.WrapError(err, "NoPersistence")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z UpdateMetadataOpts) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 1
	// string "np"
	o = append(o, 0x81, 0xa2, 0x6e, 0x70)
	o = msgp.AppendBool(o, z.NoPersistence)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *UpdateMetadataOpts) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "np":
			z.NoPersistence, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "NoPersistence")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z UpdateMetadataOpts) Msgsize() (s int) {
	s = 1 + 3 + msgp.BoolSize
	return
}

// DecodeMsg implements msgp.Decodable
func (z *VolInfo) DecodeMsg(dc *msgp.Reader) (err error) {
	var zb0001 uint32
	zb0001, err = dc.ReadArrayHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	if zb0001 != 2 {
		err = msgp.ArrayError{Wanted: 2, Got: zb0001}
		return
	}
	z.Name, err = dc.ReadString()
	if err != nil {
		err = msgp.WrapError(err, "Name")
		return
	}
	z.Created, err = dc.ReadTime()
	if err != nil {
		err = msgp.WrapError(err, "Created")
		return
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z VolInfo) EncodeMsg(en *msgp.Writer) (err error) {
	// array header, size 2
	err = en.Append(0x92)
	if err != nil {
		return
	}
	err = en.WriteString(z.Name)
	if err != nil {
		err = msgp.WrapError(err, "Name")
		return
	}
	err = en.WriteTime(z.Created)
	if err != nil {
		err = msgp.WrapError(err, "Created")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z VolInfo) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// array header, size 2
	o = append(o, 0x92)
	o = msgp.AppendString(o, z.Name)
	o = msgp.AppendTime(o, z.Created)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *VolInfo) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadArrayHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	if zb0001 != 2 {
		err = msgp.ArrayError{Wanted: 2, Got: zb0001}
		return
	}
	z.Name, bts, err = msgp.ReadStringBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Name")
		return
	}
	z.Created, bts, err = msgp.ReadTimeBytes(bts)
	if err != nil {
		err = msgp.WrapError(err, "Created")
		return
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z VolInfo) Msgsize() (s int) {
	s = 1 + msgp.StringPrefixSize + len(z.Name) + msgp.TimeSize
	return
}

// DecodeMsg implements msgp.Decodable
func (z *VolsInfo) DecodeMsg(dc *msgp.Reader) (err error) {
	var zb0002 uint32
	zb0002, err = dc.ReadArrayHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	if cap((*z)) >= int(zb0002) {
		(*z) = (*z)[:zb0002]
	} else {
		(*z) = make(VolsInfo, zb0002)
	}
	for zb0001 := range *z {
		var zb0003 uint32
		zb0003, err = dc.ReadArrayHeader()
		if err != nil {
			err = msgp.WrapError(err, zb0001)
			return
		}
		if zb0003 != 2 {
			err = msgp.ArrayError{Wanted: 2, Got: zb0003}
			return
		}
		(*z)[zb0001].Name, err = dc.ReadString()
		if err != nil {
			err = msgp.WrapError(err, zb0001, "Name")
			return
		}
		(*z)[zb0001].Created, err = dc.ReadTime()
		if err != nil {
			err = msgp.WrapError(err, zb0001, "Created")
			return
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z VolsInfo) EncodeMsg(en *msgp.Writer) (err error) {
	err = en.WriteArrayHeader(uint32(len(z)))
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0004 := range z {
		// array header, size 2
		err = en.Append(0x92)
		if err != nil {
			return
		}
		err = en.WriteString(z[zb0004].Name)
		if err != nil {
			err = msgp.WrapError(err, zb0004, "Name")
			return
		}
		err = en.WriteTime(z[zb0004].Created)
		if err != nil {
			err = msgp.WrapError(err, zb0004, "Created")
			return
		}
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z VolsInfo) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendArrayHeader(o, uint32(len(z)))
	for zb0004 := range z {
		// array header, size 2
		o = append(o, 0x92)
		o = msgp.AppendString(o, z[zb0004].Name)
		o = msgp.AppendTime(o, z[zb0004].Created)
	}
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *VolsInfo) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var zb0002 uint32
	zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	if cap((*z)) >= int(zb0002) {
		(*z) = (*z)[:zb0002]
	} else {
		(*z) = make(VolsInfo, zb0002)
	}
	for zb0001 := range *z {
		var zb0003 uint32
		zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err, zb0001)
			return
		}
		if zb0003 != 2 {
			err = msgp.ArrayError{Wanted: 2, Got: zb0003}
			return
		}
		(*z)[zb0001].Name, bts, err = msgp.ReadStringBytes(bts)
		if err != nil {
			err = msgp.WrapError(err, zb0001, "Name")
			return
		}
		(*z)[zb0001].Created, bts, err = msgp.ReadTimeBytes(bts)
		if err != nil {
			err = msgp.WrapError(err, zb0001, "Created")
			return
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z VolsInfo) Msgsize() (s int) {
	s = msgp.ArrayHeaderSize
	for zb0004 := range z {
		s += 1 + msgp.StringPrefixSize + len(z[zb0004].Name) + msgp.TimeSize
	}
	return
}

// DecodeMsg implements msgp.Decodable
func (z *WriteAllHandlerParams) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "id":
			z.DiskID, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "DiskID")
				return
			}
		case "v":
			z.Volume, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Volume")
				return
			}
		case "fp":
			z.FilePath, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "FilePath")
				return
			}
		case "b":
			z.Buf, err = dc.ReadBytes(z.Buf)
			if err != nil {
				err = msgp.WrapError(err, "Buf")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *WriteAllHandlerParams) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 4
	// write "id"
	err = en.Append(0x84, 0xa2, 0x69, 0x64)
	if err != nil {
		return
	}
	err = en.WriteString(z.DiskID)
	if err != nil {
		err = msgp.WrapError(err, "DiskID")
		return
	}
	// write "v"
	err = en.Append(0xa1, 0x76)
	if err != nil {
		return
	}
	err = en.WriteString(z.Volume)
	if err != nil {
		err = msgp.WrapError(err, "Volume")
		return
	}
	// write "fp"
	err = en.Append(0xa2, 0x66, 0x70)
	if err != nil {
		return
	}
	err = en.WriteString(z.FilePath)
	if err != nil {
		err = msgp.WrapError(err, "FilePath")
		return
	}
	// write "b"
	err = en.Append(0xa1, 0x62)
	if err != nil {
		return
	}
	err = en.WriteBytes(z.Buf)
	if err != nil {
		err = msgp.WrapError(err, "Buf")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *WriteAllHandlerParams) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 4
	// string "id"
	o = append(o, 0x84, 0xa2, 0x69, 0x64)
	o = msgp.AppendString(o, z.DiskID)
	// string "v"
	o = append(o, 0xa1, 0x76)
	o = msgp.AppendString(o, z.Volume)
	// string "fp"
	o = append(o, 0xa2, 0x66, 0x70)
	o = msgp.AppendString(o, z.FilePath)
	// string "b"
	o = append(o, 0xa1, 0x62)
	o = msgp.AppendBytes(o, z.Buf)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *WriteAllHandlerParams) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "id":
			z.DiskID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "DiskID")
				return
			}
		case "v":
			z.Volume, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Volume")
				return
			}
		case "fp":
			z.FilePath, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "FilePath")
				return
			}
		case "b":
			z.Buf, bts, err = msgp.ReadBytesBytes(bts, z.Buf)
			if err != nil {
				err = msgp.WrapError(err, "Buf")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *WriteAllHandlerParams) Msgsize() (s int) {
	s = 1 + 3 + msgp.StringPrefixSize + len(z.DiskID) + 2 + msgp.StringPrefixSize + len(z.Volume) + 3 + msgp.StringPrefixSize + len(z.FilePath) + 2 + msgp.BytesPrefixSize + len(z.Buf)
	return
}
