/* Command.c generated by valac 0.42.4, the Vala compiler
 * generated from Command.vala, do not modify */

/* Command.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define PALDO_TYPE_COMMAND (paldo_command_get_type ())
#define PALDO_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PALDO_TYPE_COMMAND, PaldoCommand))
#define PALDO_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PALDO_TYPE_COMMAND, PaldoCommandClass))
#define PALDO_IS_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PALDO_TYPE_COMMAND))
#define PALDO_IS_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PALDO_TYPE_COMMAND))
#define PALDO_COMMAND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PALDO_TYPE_COMMAND, PaldoCommandClass))

typedef struct _PaldoCommand PaldoCommand;
typedef struct _PaldoCommandClass PaldoCommandClass;
typedef struct _PaldoCommandPrivate PaldoCommandPrivate;
enum  {
	PALDO_COMMAND_0_PROPERTY,
	PALDO_COMMAND_COMMAND_LINE_PROPERTY,
	PALDO_COMMAND_WORKING_DIRECTORY_PROPERTY,
	PALDO_COMMAND_NUM_PROPERTIES
};
static GParamSpec* paldo_command_properties[PALDO_COMMAND_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	PALDO_COMMAND_EXIT_SIGNAL,
	PALDO_COMMAND_NUM_SIGNALS
};
static guint paldo_command_signals[PALDO_COMMAND_NUM_SIGNALS] = {0};

struct _PaldoCommand {
	GObject parent_instance;
	PaldoCommandPrivate * priv;
};

struct _PaldoCommandClass {
	GObjectClass parent_class;
};

struct _PaldoCommandPrivate {
	gchar* _command_line;
	gchar* _working_directory;
};


static gint PaldoCommand_private_offset;
static gpointer paldo_command_parent_class = NULL;

GType paldo_command_get_type (void) G_GNUC_CONST;
PaldoCommand* paldo_command_new (const gchar* command_line,
                                 const gchar* working_directory);
PaldoCommand* paldo_command_construct (GType object_type,
                                       const gchar* command_line,
                                       const gchar* working_directory);
void paldo_command_set_command_line (PaldoCommand* self,
                                     const gchar* value);
void paldo_command_set_working_directory (PaldoCommand* self,
                                          const gchar* value);
gboolean paldo_command_run (PaldoCommand* self);
const gchar* paldo_command_get_command_line (PaldoCommand* self);
const gchar* paldo_command_get_working_directory (PaldoCommand* self);
static void paldo_command_child_exit (PaldoCommand* self,
                               GPid pid,
                               gint status);
static void _paldo_command_child_exit_gchild_watch_func (GPid pid,
                                                  gint status,
                                                  gpointer self);
static void paldo_command_finalize (GObject * obj);
static void _vala_paldo_command_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_paldo_command_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


static inline gpointer
paldo_command_get_instance_private (PaldoCommand* self)
{
	return G_STRUCT_MEMBER_P (self, PaldoCommand_private_offset);
}


PaldoCommand*
paldo_command_construct (GType object_type,
                         const gchar* command_line,
                         const gchar* working_directory)
{
	PaldoCommand * self = NULL;
	g_return_val_if_fail (command_line != NULL, NULL);
	self = (PaldoCommand*) g_object_new (object_type, NULL);
	paldo_command_set_command_line (self, command_line);
	paldo_command_set_working_directory (self, working_directory);
	return self;
}


PaldoCommand*
paldo_command_new (const gchar* command_line,
                   const gchar* working_directory)
{
	return paldo_command_construct (PALDO_TYPE_COMMAND, command_line, working_directory);
}


static void
_paldo_command_child_exit_gchild_watch_func (GPid pid,
                                             gint status,
                                             gpointer self)
{
	paldo_command_child_exit ((PaldoCommand*) self, pid, status);
}


gboolean
paldo_command_run (PaldoCommand* self)
{
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gchar** argv = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar** _tmp4_;
		gint argv_length1;
		gint _argv_size_;
		GPid pid = 0;
		const gchar* _tmp5_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		GPid _tmp7_ = 0;
		GPid _tmp9_;
		_tmp0_ = g_strdup ("sh");
		_tmp1_ = g_strdup ("-c");
		_tmp2_ = self->priv->_command_line;
		_tmp3_ = g_strdup (_tmp2_);
		_tmp4_ = g_new0 (gchar*, 4 + 1);
		_tmp4_[0] = _tmp0_;
		_tmp4_[1] = _tmp1_;
		_tmp4_[2] = _tmp3_;
		_tmp4_[3] = NULL;
		argv = _tmp4_;
		argv_length1 = 4;
		_argv_size_ = argv_length1;
		_tmp5_ = self->priv->_working_directory;
		_tmp6_ = argv;
		_tmp6__length1 = argv_length1;
		g_spawn_async (_tmp5_, _tmp6_, NULL, G_SPAWN_DO_NOT_REAP_CHILD | G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp7_, &_inner_error_);
		pid = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp8_ = FALSE;
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp8_;
		}
		_tmp9_ = pid;
		g_child_watch_add_full (G_PRIORITY_DEFAULT, _tmp9_, _paldo_command_child_exit_gchild_watch_func, g_object_ref (self), g_object_unref);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("Command.vala:41: command");
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp10_;
	}
	result = TRUE;
	return result;
}


static void
paldo_command_child_exit (PaldoCommand* self,
                          GPid pid,
                          gint status)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, paldo_command_signals[PALDO_COMMAND_EXIT_SIGNAL], 0, status);
}


const gchar*
paldo_command_get_command_line (PaldoCommand* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_command_line;
	result = _tmp0_;
	return result;
}


void
paldo_command_set_command_line (PaldoCommand* self,
                                const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, paldo_command_get_command_line (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_command_line);
		self->priv->_command_line = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, paldo_command_properties[PALDO_COMMAND_COMMAND_LINE_PROPERTY]);
	}
}


const gchar*
paldo_command_get_working_directory (PaldoCommand* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_working_directory;
	result = _tmp0_;
	return result;
}


void
paldo_command_set_working_directory (PaldoCommand* self,
                                     const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, paldo_command_get_working_directory (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_working_directory);
		self->priv->_working_directory = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, paldo_command_properties[PALDO_COMMAND_WORKING_DIRECTORY_PROPERTY]);
	}
}


static void
paldo_command_class_init (PaldoCommandClass * klass)
{
	paldo_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PaldoCommand_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_paldo_command_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_paldo_command_set_property;
	G_OBJECT_CLASS (klass)->finalize = paldo_command_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PALDO_COMMAND_COMMAND_LINE_PROPERTY, paldo_command_properties[PALDO_COMMAND_COMMAND_LINE_PROPERTY] = g_param_spec_string ("command-line", "command-line", "command-line", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PALDO_COMMAND_WORKING_DIRECTORY_PROPERTY, paldo_command_properties[PALDO_COMMAND_WORKING_DIRECTORY_PROPERTY] = g_param_spec_string ("working-directory", "working-directory", "working-directory", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	paldo_command_signals[PALDO_COMMAND_EXIT_SIGNAL] = g_signal_new ("exit", PALDO_TYPE_COMMAND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
}


static void
paldo_command_instance_init (PaldoCommand * self)
{
	self->priv = paldo_command_get_instance_private (self);
}


static void
paldo_command_finalize (GObject * obj)
{
	PaldoCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PALDO_TYPE_COMMAND, PaldoCommand);
	_g_free0 (self->priv->_command_line);
	_g_free0 (self->priv->_working_directory);
	G_OBJECT_CLASS (paldo_command_parent_class)->finalize (obj);
}


GType
paldo_command_get_type (void)
{
	static volatile gsize paldo_command_type_id__volatile = 0;
	if (g_once_init_enter (&paldo_command_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PaldoCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) paldo_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PaldoCommand), 0, (GInstanceInitFunc) paldo_command_instance_init, NULL };
		GType paldo_command_type_id;
		paldo_command_type_id = g_type_register_static (G_TYPE_OBJECT, "PaldoCommand", &g_define_type_info, 0);
		PaldoCommand_private_offset = g_type_add_instance_private (paldo_command_type_id, sizeof (PaldoCommandPrivate));
		g_once_init_leave (&paldo_command_type_id__volatile, paldo_command_type_id);
	}
	return paldo_command_type_id__volatile;
}


static void
_vala_paldo_command_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	PaldoCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PALDO_TYPE_COMMAND, PaldoCommand);
	switch (property_id) {
		case PALDO_COMMAND_COMMAND_LINE_PROPERTY:
		g_value_set_string (value, paldo_command_get_command_line (self));
		break;
		case PALDO_COMMAND_WORKING_DIRECTORY_PROPERTY:
		g_value_set_string (value, paldo_command_get_working_directory (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_paldo_command_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	PaldoCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PALDO_TYPE_COMMAND, PaldoCommand);
	switch (property_id) {
		case PALDO_COMMAND_COMMAND_LINE_PROPERTY:
		paldo_command_set_command_line (self, g_value_get_string (value));
		break;
		case PALDO_COMMAND_WORKING_DIRECTORY_PROPERTY:
		paldo_command_set_working_directory (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



