/* InstallPage.c generated by valac 0.42.4, the Vala compiler
 * generated from InstallPage.vala, do not modify */

/* InstallPage.vala
 *
 * Copyright (C) 2007-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define PALDO_TYPE_INSTALL_PAGE (paldo_install_page_get_type ())
#define PALDO_INSTALL_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PALDO_TYPE_INSTALL_PAGE, PaldoInstallPage))
#define PALDO_INSTALL_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PALDO_TYPE_INSTALL_PAGE, PaldoInstallPageClass))
#define PALDO_IS_INSTALL_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PALDO_TYPE_INSTALL_PAGE))
#define PALDO_IS_INSTALL_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PALDO_TYPE_INSTALL_PAGE))
#define PALDO_INSTALL_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PALDO_TYPE_INSTALL_PAGE, PaldoInstallPageClass))

typedef struct _PaldoInstallPage PaldoInstallPage;
typedef struct _PaldoInstallPageClass PaldoInstallPageClass;
typedef struct _PaldoInstallPagePrivate PaldoInstallPagePrivate;

#define PALDO_TYPE_INSTALLER_SETTINGS (paldo_installer_settings_get_type ())
#define PALDO_INSTALLER_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PALDO_TYPE_INSTALLER_SETTINGS, PaldoInstallerSettings))
#define PALDO_INSTALLER_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PALDO_TYPE_INSTALLER_SETTINGS, PaldoInstallerSettingsClass))
#define PALDO_IS_INSTALLER_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PALDO_TYPE_INSTALLER_SETTINGS))
#define PALDO_IS_INSTALLER_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PALDO_TYPE_INSTALLER_SETTINGS))
#define PALDO_INSTALLER_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PALDO_TYPE_INSTALLER_SETTINGS, PaldoInstallerSettingsClass))

typedef struct _PaldoInstallerSettings PaldoInstallerSettings;
typedef struct _PaldoInstallerSettingsClass PaldoInstallerSettingsClass;
enum  {
	PALDO_INSTALL_PAGE_0_PROPERTY,
	PALDO_INSTALL_PAGE_SETTINGS_PROPERTY,
	PALDO_INSTALL_PAGE_NUM_PROPERTIES
};
static GParamSpec* paldo_install_page_properties[PALDO_INSTALL_PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define PALDO_TYPE_COMMAND (paldo_command_get_type ())
#define PALDO_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PALDO_TYPE_COMMAND, PaldoCommand))
#define PALDO_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PALDO_TYPE_COMMAND, PaldoCommandClass))
#define PALDO_IS_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PALDO_TYPE_COMMAND))
#define PALDO_IS_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PALDO_TYPE_COMMAND))
#define PALDO_COMMAND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PALDO_TYPE_COMMAND, PaldoCommandClass))

typedef struct _PaldoCommand PaldoCommand;
typedef struct _PaldoCommandClass PaldoCommandClass;
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	PALDO_INSTALL_PAGE_COMPLETE_CHANGED_SIGNAL,
	PALDO_INSTALL_PAGE_NUM_SIGNALS
};
static guint paldo_install_page_signals[PALDO_INSTALL_PAGE_NUM_SIGNALS] = {0};

struct _PaldoInstallPage {
	GtkVBox parent_instance;
	PaldoInstallPagePrivate * priv;
};

struct _PaldoInstallPageClass {
	GtkVBoxClass parent_class;
};

struct _PaldoInstallPagePrivate {
	PaldoInstallerSettings* _settings;
	GtkProgressBar* progress_bar;
	GtkLabel* operation_label;
	gint free_space_at_start;
	GTimeVal time_at_start;
	gboolean copy_running;
	gint root_format_ticks;
	gint root_mount_ticks;
	gint boot_format_ticks;
	gint boot_mount_ticks;
	gint swap_format_ticks;
	gint copy_ticks;
	gint adjust_ticks;
	gint home_format_ticks;
	gint home_mount_ticks;
	gint system_config_ticks;
	gint add_user_ticks;
	gint unmount_ticks;
	gint total_ticks;
};


static gint PaldoInstallPage_private_offset;
static gpointer paldo_install_page_parent_class = NULL;

GType paldo_install_page_get_type (void) G_GNUC_CONST;
GType paldo_installer_settings_get_type (void) G_GNUC_CONST;
#define PALDO_INSTALL_PAGE_MISC_TICKS 10
#define PALDO_INSTALL_PAGE_FORMAT_TICKS 1000
#define PALDO_INSTALL_PAGE_COPY_TICKS 10000
PaldoInstallPage* paldo_install_page_new (PaldoInstallerSettings* settings);
PaldoInstallPage* paldo_install_page_construct (GType object_type,
                                                PaldoInstallerSettings* settings);
void paldo_install_page_set_settings (PaldoInstallPage* self,
                                      PaldoInstallerSettings* value);
void paldo_install_page_run (PaldoInstallPage* self);
PaldoInstallerSettings* paldo_install_page_get_settings (PaldoInstallPage* self);
void paldo_installer_settings_set_frozen (PaldoInstallerSettings* self,
                                          gboolean value);
const gchar* paldo_installer_settings_get_swap_dev (PaldoInstallerSettings* self);
const gchar* paldo_installer_settings_get_home_dev (PaldoInstallerSettings* self);
gboolean paldo_installer_settings_get_home_format (PaldoInstallerSettings* self);
static void paldo_install_page_update_progress (PaldoInstallPage* self,
                                         gint ticks,
                                         const gchar* operation);
GType paldo_command_get_type (void) G_GNUC_CONST;
const gchar* paldo_installer_settings_get_root_fstype (PaldoInstallerSettings* self);
const gchar* paldo_installer_settings_get_root_dev (PaldoInstallerSettings* self);
PaldoCommand* paldo_command_new (const gchar* command_line,
                                 const gchar* working_directory);
PaldoCommand* paldo_command_construct (GType object_type,
                                       const gchar* command_line,
                                       const gchar* working_directory);
static void paldo_install_page_root_format_exit (PaldoInstallPage* self,
                                          PaldoCommand* cmd,
                                          gint status);
static void _paldo_install_page_root_format_exit_paldo_command_exit (PaldoCommand* _sender,
                                                              gint status,
                                                              gpointer self);
gboolean paldo_command_run (PaldoCommand* self);
static void paldo_install_page_display_error (PaldoInstallPage* self,
                                       const gchar* message);
const gchar* paldo_command_get_command_line (PaldoCommand* self);
static void paldo_install_page_root_mount_exit (PaldoInstallPage* self,
                                         PaldoCommand* cmd,
                                         gint status);
static void _paldo_install_page_root_mount_exit_paldo_command_exit (PaldoCommand* _sender,
                                                             gint status,
                                                             gpointer self);
const gchar* paldo_installer_settings_get_boot_dev (PaldoInstallerSettings* self);
static void paldo_install_page_boot_format_exit (PaldoInstallPage* self,
                                          PaldoCommand* cmd,
                                          gint status);
static void _paldo_install_page_boot_format_exit_paldo_command_exit (PaldoCommand* _sender,
                                                              gint status,
                                                              gpointer self);
static void paldo_install_page_boot_mount_exit (PaldoInstallPage* self,
                                         PaldoCommand* cmd,
                                         gint status);
static void _paldo_install_page_boot_mount_exit_paldo_command_exit (PaldoCommand* _sender,
                                                             gint status,
                                                             gpointer self);
static void paldo_install_page_swap_format_exit (PaldoInstallPage* self,
                                          PaldoCommand* cmd,
                                          gint status);
static void _paldo_install_page_swap_format_exit_paldo_command_exit (PaldoCommand* _sender,
                                                              gint status,
                                                              gpointer self);
gint paldo_installer_settings_get_installation_size (PaldoInstallerSettings* self);
static void paldo_install_page_unsquashfs_exit (PaldoInstallPage* self,
                                         PaldoCommand* cmd,
                                         gint status);
static void _paldo_install_page_unsquashfs_exit_paldo_command_exit (PaldoCommand* _sender,
                                                             gint status,
                                                             gpointer self);
static gboolean paldo_install_page_update_copy_progress (PaldoInstallPage* self);
static gboolean _paldo_install_page_update_copy_progress_gsource_func (gpointer self);
static void paldo_install_page_boot_copy_exit (PaldoInstallPage* self,
                                        PaldoCommand* cmd,
                                        gint status);
static void _paldo_install_page_boot_copy_exit_paldo_command_exit (PaldoCommand* _sender,
                                                            gint status,
                                                            gpointer self);
static void paldo_install_page_adjust_exit (PaldoInstallPage* self,
                                     PaldoCommand* cmd,
                                     gint status);
static void _paldo_install_page_adjust_exit_paldo_command_exit (PaldoCommand* _sender,
                                                         gint status,
                                                         gpointer self);
const gchar* paldo_installer_settings_get_home_fstype (PaldoInstallerSettings* self);
static void paldo_install_page_home_format_exit (PaldoInstallPage* self,
                                          PaldoCommand* cmd,
                                          gint status);
static void _paldo_install_page_home_format_exit_paldo_command_exit (PaldoCommand* _sender,
                                                              gint status,
                                                              gpointer self);
static void paldo_install_page_home_mount_exit (PaldoInstallPage* self,
                                         PaldoCommand* cmd,
                                         gint status);
static void _paldo_install_page_home_mount_exit_paldo_command_exit (PaldoCommand* _sender,
                                                             gint status,
                                                             gpointer self);
const gchar* paldo_installer_settings_get_boot_fstype (PaldoInstallerSettings* self);
const gchar* paldo_installer_settings_get_hostname (PaldoInstallerSettings* self);
const gchar* paldo_installer_settings_get_domainname (PaldoInstallerSettings* self);
const gchar* paldo_installer_settings_get_root_password (PaldoInstallerSettings* self);
const gchar* paldo_installer_settings_get_language (PaldoInstallerSettings* self);
const gchar* paldo_installer_settings_get_country (PaldoInstallerSettings* self);
const gchar* paldo_installer_settings_get_kbd (PaldoInstallerSettings* self);
const gchar* paldo_installer_settings_get_xkblayout (PaldoInstallerSettings* self);
const gchar* paldo_installer_settings_get_xkbvariant (PaldoInstallerSettings* self);
const gchar* paldo_installer_settings_get_timezone (PaldoInstallerSettings* self);
static void paldo_install_page_system_config_exit (PaldoInstallPage* self,
                                            PaldoCommand* cmd,
                                            gint status);
static void _paldo_install_page_system_config_exit_paldo_command_exit (PaldoCommand* _sender,
                                                                gint status,
                                                                gpointer self);
gint paldo_installer_settings_get_uid (PaldoInstallerSettings* self);
const gchar* paldo_installer_settings_get_username (PaldoInstallerSettings* self);
const gchar* paldo_installer_settings_get_user_password (PaldoInstallerSettings* self);
static void paldo_install_page_add_user_exit (PaldoInstallPage* self,
                                       PaldoCommand* cmd,
                                       gint status);
static void _paldo_install_page_add_user_exit_paldo_command_exit (PaldoCommand* _sender,
                                                           gint status,
                                                           gpointer self);
static void paldo_install_page_finalize (GObject * obj);
static void _vala_paldo_install_page_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_paldo_install_page_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);


static inline gpointer
paldo_install_page_get_instance_private (PaldoInstallPage* self)
{
	return G_STRUCT_MEMBER_P (self, PaldoInstallPage_private_offset);
}


PaldoInstallPage*
paldo_install_page_construct (GType object_type,
                              PaldoInstallerSettings* settings)
{
	PaldoInstallPage * self = NULL;
	GtkLabel* label = NULL;
	GtkLabel* _tmp0_;
	GtkProgressBar* _tmp1_;
	GtkProgressBar* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	g_return_val_if_fail (settings != NULL, NULL);
	self = (PaldoInstallPage*) g_object_new (object_type, NULL);
	paldo_install_page_set_settings (self, settings);
	gtk_box_set_spacing ((GtkBox*) self, 6);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 12);
	_tmp0_ = (GtkLabel*) gtk_label_new (_ ("Installing paldo GNU/Linux"));
	g_object_ref_sink (_tmp0_);
	label = _tmp0_;
	gtk_label_set_use_markup (label, TRUE);
	gtk_label_set_xalign (label, (gfloat) 0);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	_tmp1_ = (GtkProgressBar*) gtk_progress_bar_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->progress_bar);
	self->priv->progress_bar = _tmp1_;
	_tmp2_ = self->priv->progress_bar;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp2_, FALSE, FALSE, (guint) 0);
	_tmp3_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->operation_label);
	self->priv->operation_label = _tmp3_;
	_tmp4_ = self->priv->operation_label;
	gtk_label_set_use_markup (_tmp4_, TRUE);
	_tmp5_ = self->priv->operation_label;
	gtk_label_set_xalign (_tmp5_, (gfloat) 0);
	_tmp6_ = self->priv->operation_label;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp6_, FALSE, FALSE, (guint) 0);
	_g_object_unref0 (label);
	return self;
}


PaldoInstallPage*
paldo_install_page_new (PaldoInstallerSettings* settings)
{
	return paldo_install_page_construct (PALDO_TYPE_INSTALL_PAGE, settings);
}


/**
 * Starts the installation.
 */
static void
_paldo_install_page_root_format_exit_paldo_command_exit (PaldoCommand* _sender,
                                                         gint status,
                                                         gpointer self)
{
	paldo_install_page_root_format_exit ((PaldoInstallPage*) self, _sender, status);
}


void
paldo_install_page_run (PaldoInstallPage* self)
{
	PaldoInstallerSettings* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	PaldoInstallerSettings* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gboolean _tmp19_ = FALSE;
	PaldoInstallerSettings* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	gint _tmp27_;
	PaldoInstallerSettings* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gint _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	PaldoCommand* root_format_cmd = NULL;
	PaldoInstallerSettings* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	PaldoInstallerSettings* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	PaldoCommand* _tmp49_;
	PaldoCommand* _tmp50_;
	PaldoCommand* _tmp51_;
	PaldoCommand* _tmp52_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_settings;
	paldo_installer_settings_set_frozen (_tmp0_, TRUE);
	self->priv->total_ticks = 0;
	_tmp1_ = self->priv->total_ticks;
	self->priv->root_format_ticks = _tmp1_;
	_tmp2_ = self->priv->total_ticks;
	self->priv->total_ticks = _tmp2_ + PALDO_INSTALL_PAGE_FORMAT_TICKS;
	_tmp3_ = self->priv->total_ticks;
	self->priv->root_mount_ticks = _tmp3_;
	_tmp4_ = self->priv->total_ticks;
	self->priv->total_ticks = _tmp4_ + PALDO_INSTALL_PAGE_MISC_TICKS;
	_tmp5_ = self->priv->total_ticks;
	self->priv->boot_format_ticks = _tmp5_;
	_tmp6_ = self->priv->total_ticks;
	self->priv->total_ticks = _tmp6_ + PALDO_INSTALL_PAGE_FORMAT_TICKS;
	_tmp7_ = self->priv->total_ticks;
	self->priv->boot_mount_ticks = _tmp7_;
	_tmp8_ = self->priv->total_ticks;
	self->priv->total_ticks = _tmp8_ + PALDO_INSTALL_PAGE_MISC_TICKS;
	_tmp9_ = self->priv->total_ticks;
	self->priv->swap_format_ticks = _tmp9_;
	_tmp10_ = self->priv->_settings;
	_tmp11_ = paldo_installer_settings_get_swap_dev (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ != NULL) {
		gint _tmp13_;
		_tmp13_ = self->priv->total_ticks;
		self->priv->total_ticks = _tmp13_ + PALDO_INSTALL_PAGE_FORMAT_TICKS;
	}
	_tmp14_ = self->priv->total_ticks;
	self->priv->copy_ticks = _tmp14_;
	_tmp15_ = self->priv->total_ticks;
	self->priv->total_ticks = _tmp15_ + PALDO_INSTALL_PAGE_COPY_TICKS;
	_tmp16_ = self->priv->total_ticks;
	self->priv->adjust_ticks = _tmp16_;
	_tmp17_ = self->priv->total_ticks;
	self->priv->total_ticks = _tmp17_ + PALDO_INSTALL_PAGE_MISC_TICKS;
	_tmp18_ = self->priv->total_ticks;
	self->priv->home_format_ticks = _tmp18_;
	_tmp20_ = self->priv->_settings;
	_tmp21_ = paldo_installer_settings_get_home_dev (_tmp20_);
	_tmp22_ = _tmp21_;
	if (_tmp22_ != NULL) {
		PaldoInstallerSettings* _tmp23_;
		gboolean _tmp24_;
		gboolean _tmp25_;
		_tmp23_ = self->priv->_settings;
		_tmp24_ = paldo_installer_settings_get_home_format (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp19_ = _tmp25_;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		gint _tmp26_;
		_tmp26_ = self->priv->total_ticks;
		self->priv->total_ticks = _tmp26_ + PALDO_INSTALL_PAGE_FORMAT_TICKS;
	}
	_tmp27_ = self->priv->total_ticks;
	self->priv->home_mount_ticks = _tmp27_;
	_tmp28_ = self->priv->_settings;
	_tmp29_ = paldo_installer_settings_get_home_dev (_tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_ != NULL) {
		gint _tmp31_;
		_tmp31_ = self->priv->total_ticks;
		self->priv->total_ticks = _tmp31_ + PALDO_INSTALL_PAGE_MISC_TICKS;
	}
	_tmp32_ = self->priv->total_ticks;
	self->priv->system_config_ticks = _tmp32_;
	_tmp33_ = self->priv->total_ticks;
	self->priv->total_ticks = _tmp33_ + PALDO_INSTALL_PAGE_MISC_TICKS;
	_tmp34_ = self->priv->total_ticks;
	self->priv->add_user_ticks = _tmp34_;
	_tmp35_ = self->priv->total_ticks;
	self->priv->total_ticks = _tmp35_ + PALDO_INSTALL_PAGE_MISC_TICKS;
	_tmp36_ = self->priv->total_ticks;
	self->priv->unmount_ticks = _tmp36_;
	_tmp37_ = self->priv->total_ticks;
	self->priv->total_ticks = _tmp37_ + PALDO_INSTALL_PAGE_MISC_TICKS;
	g_get_current_time (&self->priv->time_at_start);
	_tmp38_ = self->priv->root_format_ticks;
	paldo_install_page_update_progress (self, _tmp38_, _ ("Formatting root partition"));
	_tmp39_ = self->priv->_settings;
	_tmp40_ = paldo_installer_settings_get_root_fstype (_tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = self->priv->_settings;
	_tmp43_ = paldo_installer_settings_get_root_dev (_tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = g_shell_quote (_tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = g_strdup_printf ("mkfs.%s -q %s", _tmp41_, _tmp46_);
	_tmp48_ = _tmp47_;
	_tmp49_ = paldo_command_new (_tmp48_, NULL);
	_tmp50_ = _tmp49_;
	_g_free0 (_tmp48_);
	_g_free0 (_tmp46_);
	root_format_cmd = _tmp50_;
	_tmp51_ = root_format_cmd;
	g_signal_connect_object (_tmp51_, "exit", (GCallback) _paldo_install_page_root_format_exit_paldo_command_exit, self, 0);
	_tmp52_ = root_format_cmd;
	if (!paldo_command_run (_tmp52_)) {
		PaldoCommand* _tmp53_;
		const gchar* _tmp54_;
		const gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		_tmp53_ = root_format_cmd;
		_tmp54_ = paldo_command_get_command_line (_tmp53_);
		_tmp55_ = _tmp54_;
		_tmp56_ = g_strdup_printf (_ ("Unable to run command `%s`"), _tmp55_);
		_tmp57_ = _tmp56_;
		paldo_install_page_display_error (self, _tmp57_);
		_g_free0 (_tmp57_);
	}
	_g_object_unref0 (root_format_cmd);
}


static void
paldo_install_page_display_error (PaldoInstallPage* self,
                                  const gchar* message)
{
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->operation_label;
	_tmp1_ = g_strdup_printf (_ ("Installation failed: %s"), message);
	_tmp2_ = _tmp1_;
	gtk_label_set_label (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
}


static void
paldo_install_page_update_progress (PaldoInstallPage* self,
                                    gint ticks,
                                    const gchar* operation)
{
	GtkProgressBar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GtkLabel* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (operation != NULL);
	_tmp0_ = self->priv->progress_bar;
	_tmp1_ = self->priv->total_ticks;
	gtk_progress_bar_set_fraction (_tmp0_, ((gdouble) ticks) / _tmp1_);
	_tmp2_ = self->priv->total_ticks;
	if (ticks == _tmp2_) {
		GtkProgressBar* _tmp3_;
		_tmp3_ = self->priv->progress_bar;
		gtk_progress_bar_set_text (_tmp3_, "");
	} else {
		if (ticks > 0) {
			GTimeVal tv = {0};
			glong remaining = 0L;
			GTimeVal _tmp4_;
			glong _tmp5_;
			GTimeVal _tmp6_;
			glong _tmp7_;
			gint _tmp8_;
			glong remaining_min = 0L;
			glong _tmp9_;
			glong _tmp10_;
			g_get_current_time (&tv);
			_tmp4_ = tv;
			_tmp5_ = _tmp4_.tv_sec;
			_tmp6_ = self->priv->time_at_start;
			_tmp7_ = _tmp6_.tv_sec;
			_tmp8_ = self->priv->total_ticks;
			remaining = ((_tmp5_ - _tmp7_) * (_tmp8_ - ticks)) / ticks;
			_tmp9_ = remaining;
			remaining_min = (_tmp9_ + 30) / 60;
			_tmp10_ = remaining_min;
			if (_tmp10_ < ((glong) 1)) {
				GtkProgressBar* _tmp11_;
				_tmp11_ = self->priv->progress_bar;
				gtk_progress_bar_set_text (_tmp11_, _ ("Less than 1 minute left"));
			} else {
				glong _tmp12_;
				_tmp12_ = remaining_min;
				if (_tmp12_ == ((glong) 1)) {
					GtkProgressBar* _tmp13_;
					_tmp13_ = self->priv->progress_bar;
					gtk_progress_bar_set_text (_tmp13_, _ ("About 1 minute left"));
				} else {
					glong _tmp14_;
					_tmp14_ = remaining_min;
					if (_tmp14_ >= ((glong) 60)) {
						glong remaining_h = 0L;
						glong _tmp15_;
						glong _tmp16_;
						_tmp15_ = remaining;
						remaining_h = (_tmp15_ + 1800) / 3600;
						_tmp16_ = remaining_h;
						if (_tmp16_ <= ((glong) 1)) {
							GtkProgressBar* _tmp17_;
							_tmp17_ = self->priv->progress_bar;
							gtk_progress_bar_set_text (_tmp17_, _ ("About 1 hour left"));
						} else {
							GtkProgressBar* _tmp18_;
							glong _tmp19_;
							gchar* _tmp20_;
							gchar* _tmp21_;
							_tmp18_ = self->priv->progress_bar;
							_tmp19_ = remaining_h;
							_tmp20_ = g_strdup_printf (_ ("About %ld hours left"), _tmp19_);
							_tmp21_ = _tmp20_;
							gtk_progress_bar_set_text (_tmp18_, _tmp21_);
							_g_free0 (_tmp21_);
						}
					} else {
						GtkProgressBar* _tmp22_;
						glong _tmp23_;
						gchar* _tmp24_;
						gchar* _tmp25_;
						_tmp22_ = self->priv->progress_bar;
						_tmp23_ = remaining_min;
						_tmp24_ = g_strdup_printf (_ ("About %ld minutes left"), _tmp23_);
						_tmp25_ = _tmp24_;
						gtk_progress_bar_set_text (_tmp22_, _tmp25_);
						_g_free0 (_tmp25_);
					}
				}
			}
		}
	}
	_tmp26_ = self->priv->operation_label;
	_tmp27_ = g_markup_escape_text (operation, (gssize) -1);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_strdup_printf ("<i>%s</i>", _tmp28_);
	_tmp30_ = _tmp29_;
	gtk_label_set_label (_tmp26_, _tmp30_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp28_);
}


static void
_paldo_install_page_root_mount_exit_paldo_command_exit (PaldoCommand* _sender,
                                                        gint status,
                                                        gpointer self)
{
	paldo_install_page_root_mount_exit ((PaldoInstallPage*) self, _sender, status);
}


static void
paldo_install_page_root_format_exit (PaldoInstallPage* self,
                                     PaldoCommand* cmd,
                                     gint status)
{
	gint _tmp0_;
	PaldoCommand* root_mount_cmd = NULL;
	PaldoInstallerSettings* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	PaldoCommand* _tmp8_;
	PaldoCommand* _tmp9_;
	PaldoCommand* _tmp10_;
	PaldoCommand* _tmp11_;
	g_return_if_fail (self != NULL);
	if (status != 0) {
		paldo_install_page_display_error (self, _ ("Unable to format root partition."));
		return;
	}
	_tmp0_ = self->priv->root_mount_ticks;
	paldo_install_page_update_progress (self, _tmp0_, _ ("Mounting root partition"));
	_tmp1_ = self->priv->_settings;
	_tmp2_ = paldo_installer_settings_get_root_dev (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_shell_quote (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("mount %s /upkg", _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = paldo_command_new (_tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	root_mount_cmd = _tmp9_;
	_tmp10_ = root_mount_cmd;
	g_signal_connect_object (_tmp10_, "exit", (GCallback) _paldo_install_page_root_mount_exit_paldo_command_exit, self, 0);
	_tmp11_ = root_mount_cmd;
	if (!paldo_command_run (_tmp11_)) {
		PaldoCommand* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp12_ = root_mount_cmd;
		_tmp13_ = paldo_command_get_command_line (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strdup_printf (_ ("Unable to run command `%s`"), _tmp14_);
		_tmp16_ = _tmp15_;
		paldo_install_page_display_error (self, _tmp16_);
		_g_free0 (_tmp16_);
	}
	_g_object_unref0 (root_mount_cmd);
}


static void
_paldo_install_page_boot_format_exit_paldo_command_exit (PaldoCommand* _sender,
                                                         gint status,
                                                         gpointer self)
{
	paldo_install_page_boot_format_exit ((PaldoInstallPage*) self, _sender, status);
}


static void
paldo_install_page_root_mount_exit (PaldoInstallPage* self,
                                    PaldoCommand* cmd,
                                    gint status)
{
	GFile* f = NULL;
	GFile* _tmp0_;
	GFileInfo* fsinfo = NULL;
	GFile* _tmp1_;
	GFileInfo* _tmp2_;
	GFileInfo* _tmp3_;
	GFile* boot_dir = NULL;
	GFile* _tmp4_;
	GFile* _tmp5_;
	gint _tmp6_;
	PaldoCommand* boot_format_cmd = NULL;
	PaldoInstallerSettings* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	PaldoCommand* _tmp14_;
	PaldoCommand* _tmp15_;
	PaldoCommand* _tmp16_;
	PaldoCommand* _tmp17_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (status != 0) {
		paldo_install_page_display_error (self, _ ("Unable to mount root partition."));
		return;
	}
	_tmp0_ = g_file_new_for_path ("/upkg/");
	f = _tmp0_;
	_tmp1_ = f;
	_tmp2_ = g_file_query_filesystem_info (_tmp1_, G_FILE_ATTRIBUTE_FILESYSTEM_FREE, NULL, &_inner_error_);
	fsinfo = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (f);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp3_ = fsinfo;
	self->priv->free_space_at_start = (gint) (g_file_info_get_attribute_uint64 (_tmp3_, G_FILE_ATTRIBUTE_FILESYSTEM_FREE) / 1024);
	_tmp4_ = g_file_new_for_path ("/upkg/boot");
	boot_dir = _tmp4_;
	_tmp5_ = boot_dir;
	g_file_make_directory (_tmp5_, NULL, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (boot_dir);
		_g_object_unref0 (fsinfo);
		_g_object_unref0 (f);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = self->priv->boot_format_ticks;
	paldo_install_page_update_progress (self, _tmp6_, _ ("Formatting boot partition"));
	_tmp7_ = self->priv->_settings;
	_tmp8_ = paldo_installer_settings_get_boot_dev (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_shell_quote (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf ("mkfs.vfat -F 32 %s", _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = paldo_command_new (_tmp13_, NULL);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	boot_format_cmd = _tmp15_;
	_tmp16_ = boot_format_cmd;
	g_signal_connect_object (_tmp16_, "exit", (GCallback) _paldo_install_page_boot_format_exit_paldo_command_exit, self, 0);
	_tmp17_ = boot_format_cmd;
	if (!paldo_command_run (_tmp17_)) {
		PaldoCommand* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp18_ = boot_format_cmd;
		_tmp19_ = paldo_command_get_command_line (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strdup_printf (_ ("Unable to run command `%s`"), _tmp20_);
		_tmp22_ = _tmp21_;
		paldo_install_page_display_error (self, _tmp22_);
		_g_free0 (_tmp22_);
	}
	_g_object_unref0 (boot_format_cmd);
	_g_object_unref0 (boot_dir);
	_g_object_unref0 (fsinfo);
	_g_object_unref0 (f);
}


static void
_paldo_install_page_boot_mount_exit_paldo_command_exit (PaldoCommand* _sender,
                                                        gint status,
                                                        gpointer self)
{
	paldo_install_page_boot_mount_exit ((PaldoInstallPage*) self, _sender, status);
}


static void
paldo_install_page_boot_format_exit (PaldoInstallPage* self,
                                     PaldoCommand* cmd,
                                     gint status)
{
	gint _tmp0_;
	PaldoCommand* boot_mount_cmd = NULL;
	PaldoInstallerSettings* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	PaldoCommand* _tmp8_;
	PaldoCommand* _tmp9_;
	PaldoCommand* _tmp10_;
	PaldoCommand* _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (status != 0) {
		g_spawn_command_line_sync ("umount -l /upkg", NULL, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		paldo_install_page_display_error (self, _ ("Unable to format boot partition."));
		return;
	}
	_tmp0_ = self->priv->boot_mount_ticks;
	paldo_install_page_update_progress (self, _tmp0_, _ ("Mounting boot partition"));
	_tmp1_ = self->priv->_settings;
	_tmp2_ = paldo_installer_settings_get_boot_dev (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_shell_quote (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("mount %s /upkg/boot", _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = paldo_command_new (_tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	boot_mount_cmd = _tmp9_;
	_tmp10_ = boot_mount_cmd;
	g_signal_connect_object (_tmp10_, "exit", (GCallback) _paldo_install_page_boot_mount_exit_paldo_command_exit, self, 0);
	_tmp11_ = boot_mount_cmd;
	if (!paldo_command_run (_tmp11_)) {
		PaldoCommand* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp12_ = boot_mount_cmd;
		_tmp13_ = paldo_command_get_command_line (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strdup_printf (_ ("Unable to run command `%s`"), _tmp14_);
		_tmp16_ = _tmp15_;
		paldo_install_page_display_error (self, _tmp16_);
		_g_free0 (_tmp16_);
	}
	_g_object_unref0 (boot_mount_cmd);
}


static void
_paldo_install_page_swap_format_exit_paldo_command_exit (PaldoCommand* _sender,
                                                         gint status,
                                                         gpointer self)
{
	paldo_install_page_swap_format_exit ((PaldoInstallPage*) self, _sender, status);
}


static void
paldo_install_page_boot_mount_exit (PaldoInstallPage* self,
                                    PaldoCommand* cmd,
                                    gint status)
{
	PaldoInstallerSettings* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (status != 0) {
		g_spawn_command_line_sync ("umount -l /upkg", NULL, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		paldo_install_page_display_error (self, _ ("Unable to mount boot partition."));
		return;
	}
	_tmp0_ = self->priv->_settings;
	_tmp1_ = paldo_installer_settings_get_swap_dev (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		paldo_install_page_swap_format_exit (self, NULL, 0);
	} else {
		gint _tmp3_;
		PaldoCommand* swap_format_cmd = NULL;
		PaldoInstallerSettings* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		PaldoCommand* _tmp11_;
		PaldoCommand* _tmp12_;
		PaldoCommand* _tmp13_;
		PaldoCommand* _tmp14_;
		_tmp3_ = self->priv->swap_format_ticks;
		paldo_install_page_update_progress (self, _tmp3_, _ ("Formatting swap partition"));
		_tmp4_ = self->priv->_settings;
		_tmp5_ = paldo_installer_settings_get_swap_dev (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_shell_quote (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup_printf ("mkswap %s", _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = paldo_command_new (_tmp10_, NULL);
		_tmp12_ = _tmp11_;
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		swap_format_cmd = _tmp12_;
		_tmp13_ = swap_format_cmd;
		g_signal_connect_object (_tmp13_, "exit", (GCallback) _paldo_install_page_swap_format_exit_paldo_command_exit, self, 0);
		_tmp14_ = swap_format_cmd;
		if (!paldo_command_run (_tmp14_)) {
			PaldoCommand* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp15_ = swap_format_cmd;
			_tmp16_ = paldo_command_get_command_line (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_strdup_printf (_ ("Unable to run command `%s`"), _tmp17_);
			_tmp19_ = _tmp18_;
			paldo_install_page_display_error (self, _tmp19_);
			_g_free0 (_tmp19_);
		}
		_g_object_unref0 (swap_format_cmd);
	}
}


static void
_paldo_install_page_unsquashfs_exit_paldo_command_exit (PaldoCommand* _sender,
                                                        gint status,
                                                        gpointer self)
{
	paldo_install_page_unsquashfs_exit ((PaldoInstallPage*) self, _sender, status);
}


static gboolean
_paldo_install_page_update_copy_progress_gsource_func (gpointer self)
{
	gboolean result;
	result = paldo_install_page_update_copy_progress ((PaldoInstallPage*) self);
	return result;
}


static void
paldo_install_page_swap_format_exit (PaldoInstallPage* self,
                                     PaldoCommand* cmd,
                                     gint status)
{
	gint _tmp0_;
	PaldoInstallerSettings* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	PaldoCommand* unsquashfs_cmd = NULL;
	PaldoCommand* _tmp6_;
	PaldoCommand* _tmp7_;
	PaldoCommand* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (status != 0) {
		g_spawn_command_line_sync ("umount -l /upkg/boot", NULL, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		g_spawn_command_line_sync ("umount -l /upkg", NULL, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		paldo_install_page_display_error (self, _ ("Unable to format swap partition."));
		return;
	}
	_tmp0_ = self->priv->copy_ticks;
	_tmp1_ = self->priv->_settings;
	_tmp2_ = paldo_installer_settings_get_installation_size (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf (_ ("Copying files, %.1f MB of %.1f MB copied"), 0.0, ((gdouble) _tmp3_) / 1024);
	_tmp5_ = _tmp4_;
	paldo_install_page_update_progress (self, _tmp0_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = paldo_command_new ("unsquashfs -f -d /upkg /run/live/rootfs.img", NULL);
	unsquashfs_cmd = _tmp6_;
	_tmp7_ = unsquashfs_cmd;
	g_signal_connect_object (_tmp7_, "exit", (GCallback) _paldo_install_page_unsquashfs_exit_paldo_command_exit, self, 0);
	_tmp8_ = unsquashfs_cmd;
	if (!paldo_command_run (_tmp8_)) {
		PaldoCommand* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp9_ = unsquashfs_cmd;
		_tmp10_ = paldo_command_get_command_line (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strdup_printf (_ ("Unable to run command `%s`"), _tmp11_);
		_tmp13_ = _tmp12_;
		paldo_install_page_display_error (self, _tmp13_);
		_g_free0 (_tmp13_);
		_g_object_unref0 (unsquashfs_cmd);
		return;
	}
	self->priv->copy_running = TRUE;
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, _paldo_install_page_update_copy_progress_gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (unsquashfs_cmd);
}


static gboolean
paldo_install_page_update_copy_progress (PaldoInstallPage* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	GFile* f = NULL;
	GFile* _tmp1_;
	GFileInfo* fsinfo = NULL;
	GFile* _tmp2_;
	GFileInfo* _tmp3_;
	gint free_space = 0;
	GFileInfo* _tmp5_;
	gint used_space = 0;
	gint _tmp6_;
	gint _tmp7_;
	PaldoInstallerSettings* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint current_copy_ticks = 0;
	gint _tmp11_;
	PaldoInstallerSettings* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	PaldoInstallerSettings* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->copy_running;
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = g_file_new_for_path ("/upkg/");
	f = _tmp1_;
	_tmp2_ = f;
	_tmp3_ = g_file_query_filesystem_info (_tmp2_, G_FILE_ATTRIBUTE_FILESYSTEM_FREE, NULL, &_inner_error_);
	fsinfo = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		_g_object_unref0 (f);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp4_;
	}
	_tmp5_ = fsinfo;
	free_space = (gint) (g_file_info_get_attribute_uint64 (_tmp5_, G_FILE_ATTRIBUTE_FILESYSTEM_FREE) / 1024);
	_tmp6_ = self->priv->free_space_at_start;
	_tmp7_ = free_space;
	_tmp8_ = self->priv->_settings;
	_tmp9_ = paldo_installer_settings_get_installation_size (_tmp8_);
	_tmp10_ = _tmp9_;
	used_space = CLAMP (_tmp6_ - _tmp7_, 0, _tmp10_);
	_tmp11_ = used_space;
	_tmp12_ = self->priv->_settings;
	_tmp13_ = paldo_installer_settings_get_installation_size (_tmp12_);
	_tmp14_ = _tmp13_;
	current_copy_ticks = CLAMP ((gint) ((((gdouble) PALDO_INSTALL_PAGE_COPY_TICKS) * _tmp11_) / _tmp14_), 0, PALDO_INSTALL_PAGE_COPY_TICKS);
	_tmp15_ = self->priv->copy_ticks;
	_tmp16_ = current_copy_ticks;
	_tmp17_ = used_space;
	_tmp18_ = self->priv->_settings;
	_tmp19_ = paldo_installer_settings_get_installation_size (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strdup_printf (_ ("Copying files, %.1f MB of %.1f MB copied"), ((gdouble) _tmp17_) / 1024, ((gdouble) _tmp20_) / 1024);
	_tmp22_ = _tmp21_;
	paldo_install_page_update_progress (self, _tmp15_ + _tmp16_, _tmp22_);
	_g_free0 (_tmp22_);
	result = TRUE;
	_g_object_unref0 (fsinfo);
	_g_object_unref0 (f);
	return result;
}


static void
_paldo_install_page_boot_copy_exit_paldo_command_exit (PaldoCommand* _sender,
                                                       gint status,
                                                       gpointer self)
{
	paldo_install_page_boot_copy_exit ((PaldoInstallPage*) self, _sender, status);
}


static void
paldo_install_page_unsquashfs_exit (PaldoInstallPage* self,
                                    PaldoCommand* cmd,
                                    gint status)
{
	PaldoCommand* boot_copy_cmd = NULL;
	PaldoCommand* _tmp0_;
	PaldoCommand* _tmp1_;
	PaldoCommand* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (status != 0) {
		self->priv->copy_running = FALSE;
		g_spawn_command_line_sync ("umount -l /upkg/boot", NULL, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		g_spawn_command_line_sync ("umount -l /upkg", NULL, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		paldo_install_page_display_error (self, _ ("Error while copying files."));
		return;
	}
	_tmp0_ = paldo_command_new ("cp -a /run/live/{config-*,initramfs-*,linux-*,System.map-*,EFI,loader}" \
" /upkg/boot/", NULL);
	boot_copy_cmd = _tmp0_;
	_tmp1_ = boot_copy_cmd;
	g_signal_connect_object (_tmp1_, "exit", (GCallback) _paldo_install_page_boot_copy_exit_paldo_command_exit, self, 0);
	_tmp2_ = boot_copy_cmd;
	if (!paldo_command_run (_tmp2_)) {
		PaldoCommand* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp3_ = boot_copy_cmd;
		_tmp4_ = paldo_command_get_command_line (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf (_ ("Unable to run command `%s`"), _tmp5_);
		_tmp7_ = _tmp6_;
		paldo_install_page_display_error (self, _tmp7_);
		_g_free0 (_tmp7_);
		_g_object_unref0 (boot_copy_cmd);
		return;
	}
	_g_object_unref0 (boot_copy_cmd);
}


static void
_paldo_install_page_adjust_exit_paldo_command_exit (PaldoCommand* _sender,
                                                    gint status,
                                                    gpointer self)
{
	paldo_install_page_adjust_exit ((PaldoInstallPage*) self, _sender, status);
}


static void
paldo_install_page_boot_copy_exit (PaldoInstallPage* self,
                                   PaldoCommand* cmd,
                                   gint status)
{
	gint _tmp0_;
	gchar* resume_opt = NULL;
	gchar* _tmp1_;
	PaldoInstallerSettings* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	PaldoCommand* adjust_cmd = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	PaldoCommand* _tmp15_;
	PaldoCommand* _tmp16_;
	PaldoCommand* _tmp17_;
	PaldoCommand* _tmp18_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->copy_running = FALSE;
	if (status != 0) {
		g_spawn_command_line_sync ("umount -l /upkg/boot", NULL, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		g_spawn_command_line_sync ("umount -l /upkg", NULL, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		paldo_install_page_display_error (self, _ ("Error while copying files."));
		return;
	}
	_tmp0_ = self->priv->adjust_ticks;
	paldo_install_page_update_progress (self, _tmp0_, _ ("Adjusting installation"));
	_tmp1_ = g_strdup ("");
	resume_opt = _tmp1_;
	_tmp2_ = self->priv->_settings;
	_tmp3_ = paldo_installer_settings_get_swap_dev (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (" resume=@SWAP@");
		_g_free0 (resume_opt);
		resume_opt = _tmp5_;
	}
	_tmp6_ = resume_opt;
	_tmp7_ = g_strconcat ("rm -rf /upkg/{.readonly,home/paldo}" " && sed -i -e '/^paldo:/d' -e 's/:paldo$/:/' /upkg/etc/{passwd,group}" " && cp /upkg/usr/share/doc/gdm/custom.conf.paldo /upkg/etc/gdm/custom." \
"conf" " && cp /upkg/usr/share/doc/util-linux/default-fstab.paldo /upkg/etc/fs" \
"tab" " && sed -i -e 's/root=[^\"]*/root=@ROOTDEV@", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp8_, "/' /upkg/boot/loader/entries/*.conf /upkg/etc/kernel/cmdline", NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat (_tmp10_, " && sed -i -e 's/cachedir chroot=\"yes\"/cachedir/' /upkg/etc/upkg.con" \
"f", NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat (_tmp12_, " && chroot /upkg upkg-remove --force paldo-installer", NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = paldo_command_new (_tmp14_, NULL);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	adjust_cmd = _tmp16_;
	_tmp17_ = adjust_cmd;
	g_signal_connect_object (_tmp17_, "exit", (GCallback) _paldo_install_page_adjust_exit_paldo_command_exit, self, 0);
	_tmp18_ = adjust_cmd;
	if (!paldo_command_run (_tmp18_)) {
		PaldoCommand* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp19_ = adjust_cmd;
		_tmp20_ = paldo_command_get_command_line (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strdup_printf (_ ("Unable to run command `%s`"), _tmp21_);
		_tmp23_ = _tmp22_;
		paldo_install_page_display_error (self, _tmp23_);
		_g_free0 (_tmp23_);
		_g_object_unref0 (adjust_cmd);
		_g_free0 (resume_opt);
		return;
	}
	_g_object_unref0 (adjust_cmd);
	_g_free0 (resume_opt);
}


static void
_paldo_install_page_home_format_exit_paldo_command_exit (PaldoCommand* _sender,
                                                         gint status,
                                                         gpointer self)
{
	paldo_install_page_home_format_exit ((PaldoInstallPage*) self, _sender, status);
}


static void
paldo_install_page_adjust_exit (PaldoInstallPage* self,
                                PaldoCommand* cmd,
                                gint status)
{
	gboolean _tmp0_ = FALSE;
	PaldoInstallerSettings* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (status != 0) {
		g_spawn_command_line_sync ("umount -l /upkg/boot", NULL, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		g_spawn_command_line_sync ("umount -l /upkg", NULL, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		paldo_install_page_display_error (self, _ ("Error while adjusting installation."));
		return;
	}
	_tmp1_ = self->priv->_settings;
	_tmp2_ = paldo_installer_settings_get_home_dev (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		PaldoInstallerSettings* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->_settings;
		_tmp5_ = paldo_installer_settings_get_home_format (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp7_;
		PaldoCommand* home_format_cmd = NULL;
		PaldoInstallerSettings* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		PaldoInstallerSettings* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		PaldoCommand* _tmp18_;
		PaldoCommand* _tmp19_;
		PaldoCommand* _tmp20_;
		PaldoCommand* _tmp21_;
		_tmp7_ = self->priv->home_format_ticks;
		paldo_install_page_update_progress (self, _tmp7_, _ ("Formatting home partition"));
		_tmp8_ = self->priv->_settings;
		_tmp9_ = paldo_installer_settings_get_home_fstype (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = self->priv->_settings;
		_tmp12_ = paldo_installer_settings_get_home_dev (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_shell_quote (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strdup_printf ("mkfs.%s -q %s", _tmp10_, _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = paldo_command_new (_tmp17_, NULL);
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
		home_format_cmd = _tmp19_;
		_tmp20_ = home_format_cmd;
		g_signal_connect_object (_tmp20_, "exit", (GCallback) _paldo_install_page_home_format_exit_paldo_command_exit, self, 0);
		_tmp21_ = home_format_cmd;
		if (!paldo_command_run (_tmp21_)) {
			PaldoCommand* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp22_ = home_format_cmd;
			_tmp23_ = paldo_command_get_command_line (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_strdup_printf (_ ("Unable to run command `%s`"), _tmp24_);
			_tmp26_ = _tmp25_;
			paldo_install_page_display_error (self, _tmp26_);
			_g_free0 (_tmp26_);
		}
		_g_object_unref0 (home_format_cmd);
	} else {
		paldo_install_page_home_format_exit (self, NULL, 0);
	}
}


static void
_paldo_install_page_home_mount_exit_paldo_command_exit (PaldoCommand* _sender,
                                                        gint status,
                                                        gpointer self)
{
	paldo_install_page_home_mount_exit ((PaldoInstallPage*) self, _sender, status);
}


static void
paldo_install_page_home_format_exit (PaldoInstallPage* self,
                                     PaldoCommand* cmd,
                                     gint status)
{
	PaldoInstallerSettings* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (status != 0) {
		g_spawn_command_line_sync ("umount -l /upkg/boot", NULL, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		g_spawn_command_line_sync ("umount -l /upkg", NULL, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		paldo_install_page_display_error (self, "Error while mounting home partition.");
		return;
	}
	_tmp0_ = self->priv->_settings;
	_tmp1_ = paldo_installer_settings_get_home_dev (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		gint _tmp3_;
		PaldoCommand* home_mount_cmd = NULL;
		PaldoInstallerSettings* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		PaldoCommand* _tmp11_;
		PaldoCommand* _tmp12_;
		PaldoCommand* _tmp13_;
		PaldoCommand* _tmp14_;
		_tmp3_ = self->priv->home_mount_ticks;
		paldo_install_page_update_progress (self, _tmp3_, _ ("Mounting home partition"));
		_tmp4_ = self->priv->_settings;
		_tmp5_ = paldo_installer_settings_get_home_dev (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_shell_quote (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup_printf ("mount %s /upkg/home", _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = paldo_command_new (_tmp10_, NULL);
		_tmp12_ = _tmp11_;
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		home_mount_cmd = _tmp12_;
		_tmp13_ = home_mount_cmd;
		g_signal_connect_object (_tmp13_, "exit", (GCallback) _paldo_install_page_home_mount_exit_paldo_command_exit, self, 0);
		_tmp14_ = home_mount_cmd;
		if (!paldo_command_run (_tmp14_)) {
			PaldoCommand* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp15_ = home_mount_cmd;
			_tmp16_ = paldo_command_get_command_line (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_strdup_printf (_ ("Unable to run command `%s`"), _tmp17_);
			_tmp19_ = _tmp18_;
			paldo_install_page_display_error (self, _tmp19_);
			_g_free0 (_tmp19_);
		}
		_g_object_unref0 (home_mount_cmd);
	} else {
		paldo_install_page_home_mount_exit (self, NULL, 0);
	}
}


static void
_paldo_install_page_system_config_exit_paldo_command_exit (PaldoCommand* _sender,
                                                           gint status,
                                                           gpointer self)
{
	paldo_install_page_system_config_exit ((PaldoInstallPage*) self, _sender, status);
}


static void
paldo_install_page_home_mount_exit (PaldoInstallPage* self,
                                    PaldoCommand* cmd,
                                    gint status)
{
	gint _tmp0_;
	gchar* fstab_sed = NULL;
	PaldoInstallerSettings* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	PaldoInstallerSettings* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	PaldoInstallerSettings* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	PaldoInstallerSettings* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	PaldoInstallerSettings* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	PaldoInstallerSettings* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp44_;
	gchar* _tmp45_;
	PaldoCommand* system_config_cmd = NULL;
	const gchar* _tmp46_;
	PaldoInstallerSettings* _tmp47_;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	PaldoInstallerSettings* _tmp54_;
	const gchar* _tmp55_;
	const gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	PaldoInstallerSettings* _tmp61_;
	const gchar* _tmp62_;
	const gchar* _tmp63_;
	PaldoInstallerSettings* _tmp64_;
	const gchar* _tmp65_;
	const gchar* _tmp66_;
	PaldoInstallerSettings* _tmp67_;
	const gchar* _tmp68_;
	const gchar* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	PaldoInstallerSettings* _tmp74_;
	const gchar* _tmp75_;
	const gchar* _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	gchar* _tmp81_;
	gchar* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	PaldoInstallerSettings* _tmp85_;
	const gchar* _tmp86_;
	const gchar* _tmp87_;
	PaldoInstallerSettings* _tmp88_;
	const gchar* _tmp89_;
	const gchar* _tmp90_;
	gchar* _tmp91_;
	gchar* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	PaldoInstallerSettings* _tmp95_;
	const gchar* _tmp96_;
	const gchar* _tmp97_;
	PaldoInstallerSettings* _tmp98_;
	const gchar* _tmp99_;
	const gchar* _tmp100_;
	gchar* _tmp101_;
	gchar* _tmp102_;
	gchar* _tmp103_;
	gchar* _tmp104_;
	PaldoInstallerSettings* _tmp105_;
	const gchar* _tmp106_;
	const gchar* _tmp107_;
	gchar* _tmp108_;
	gchar* _tmp109_;
	gchar* _tmp110_;
	gchar* _tmp111_;
	PaldoInstallerSettings* _tmp112_;
	const gchar* _tmp113_;
	const gchar* _tmp114_;
	PaldoInstallerSettings* _tmp115_;
	const gchar* _tmp116_;
	const gchar* _tmp117_;
	gchar* _tmp118_;
	gchar* _tmp119_;
	gchar* _tmp120_;
	gchar* _tmp121_;
	gchar* _tmp122_;
	gchar* _tmp123_;
	PaldoInstallerSettings* _tmp124_;
	const gchar* _tmp125_;
	const gchar* _tmp126_;
	gchar* _tmp127_;
	gchar* _tmp128_;
	gchar* _tmp129_;
	gchar* _tmp130_;
	PaldoCommand* _tmp131_;
	PaldoCommand* _tmp132_;
	PaldoCommand* _tmp133_;
	PaldoCommand* _tmp134_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (status != 0) {
		g_spawn_command_line_sync ("umount -l /upkg/boot", NULL, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		g_spawn_command_line_sync ("umount -l /upkg", NULL, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		paldo_install_page_display_error (self, _ ("Error while mounting home partition."));
		return;
	}
	_tmp0_ = self->priv->system_config_ticks;
	paldo_install_page_update_progress (self, _tmp0_, _ ("Writing system configuration"));
	_tmp1_ = self->priv->_settings;
	_tmp2_ = paldo_installer_settings_get_root_dev (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_settings;
	_tmp5_ = paldo_installer_settings_get_root_fstype (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("sed -i -e \"s|@ROOTDEV@|/dev/disk/by-uuid/$(/sbin/blkid -o value -s UU" \
"ID %s)|\" -e 's|@ROOTFSTYPE@|%s|'", _tmp3_, _tmp6_);
	fstab_sed = _tmp7_;
	_tmp8_ = fstab_sed;
	_tmp9_ = self->priv->_settings;
	_tmp10_ = paldo_installer_settings_get_boot_dev (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->_settings;
	_tmp13_ = paldo_installer_settings_get_boot_fstype (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strdup_printf (" -e \"s|^.*@BOOTDEV@|/dev/disk/by-uuid/$(/sbin/blkid -o value -s UUID " \
"%s)|\" -e 's|@BOOTFSTYPE@|%s|'", _tmp11_, _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat (_tmp8_, _tmp16_, NULL);
	_g_free0 (fstab_sed);
	fstab_sed = _tmp17_;
	_g_free0 (_tmp16_);
	_tmp18_ = self->priv->_settings;
	_tmp19_ = paldo_installer_settings_get_home_dev (_tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_ != NULL) {
		const gchar* _tmp21_;
		PaldoInstallerSettings* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		PaldoInstallerSettings* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp21_ = fstab_sed;
		_tmp22_ = self->priv->_settings;
		_tmp23_ = paldo_installer_settings_get_home_dev (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = self->priv->_settings;
		_tmp26_ = paldo_installer_settings_get_home_fstype (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strdup_printf (" -e \"s|# @HOMEDEV@|/dev/disk/by-uuid/$(/sbin/blkid -o value -s UUID %" \
"s)|\" -e 's|@HOMEFSTYPE@|%s|'", _tmp24_, _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat (_tmp21_, _tmp29_, NULL);
		_g_free0 (fstab_sed);
		fstab_sed = _tmp30_;
		_g_free0 (_tmp29_);
	}
	_tmp31_ = self->priv->_settings;
	_tmp32_ = paldo_installer_settings_get_swap_dev (_tmp31_);
	_tmp33_ = _tmp32_;
	if (_tmp33_ != NULL) {
		const gchar* _tmp34_;
		PaldoInstallerSettings* _tmp35_;
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		PaldoInstallerSettings* _tmp38_;
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		_tmp34_ = fstab_sed;
		_tmp35_ = self->priv->_settings;
		_tmp36_ = paldo_installer_settings_get_swap_dev (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = self->priv->_settings;
		_tmp39_ = paldo_installer_settings_get_swap_dev (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = g_strdup_printf (" -e \"s|# @SWAP@|/dev/disk/by-uuid/$(/sbin/blkid -o value -s UUID %s)|" \
"\" -e \"s|@SWAP@|/dev/disk/by-uuid/$(/sbin/blkid -o value -s UUID %s)|" \
"\"", _tmp37_, _tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = g_strconcat (_tmp34_, _tmp42_, NULL);
		_g_free0 (fstab_sed);
		fstab_sed = _tmp43_;
		_g_free0 (_tmp42_);
	}
	_tmp44_ = fstab_sed;
	_tmp45_ = g_strconcat (_tmp44_, " /upkg/etc/fstab /upkg/boot/loader/entries/*.conf /upkg/etc/kernel/cmd" \
"line", NULL);
	_g_free0 (fstab_sed);
	fstab_sed = _tmp45_;
	_tmp46_ = fstab_sed;
	_tmp47_ = self->priv->_settings;
	_tmp48_ = paldo_installer_settings_get_hostname (_tmp47_);
	_tmp49_ = _tmp48_;
	_tmp50_ = g_strdup_printf (" && echo %s > /upkg/etc/hostname", _tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = g_strconcat (_tmp46_, _tmp51_, NULL);
	_tmp53_ = _tmp52_;
	_tmp54_ = self->priv->_settings;
	_tmp55_ = paldo_installer_settings_get_domainname (_tmp54_);
	_tmp56_ = _tmp55_;
	_tmp57_ = g_strdup_printf (" && echo %s > /upkg/etc/domainname", _tmp56_);
	_tmp58_ = _tmp57_;
	_tmp59_ = g_strconcat (_tmp53_, _tmp58_, NULL);
	_tmp60_ = _tmp59_;
	_tmp61_ = self->priv->_settings;
	_tmp62_ = paldo_installer_settings_get_hostname (_tmp61_);
	_tmp63_ = _tmp62_;
	_tmp64_ = self->priv->_settings;
	_tmp65_ = paldo_installer_settings_get_domainname (_tmp64_);
	_tmp66_ = _tmp65_;
	_tmp67_ = self->priv->_settings;
	_tmp68_ = paldo_installer_settings_get_hostname (_tmp67_);
	_tmp69_ = _tmp68_;
	_tmp70_ = g_strdup_printf (" && echo 127.0.0.1 %s.%s %s localhost > /upkg/etc/hosts", _tmp63_, _tmp66_, _tmp69_);
	_tmp71_ = _tmp70_;
	_tmp72_ = g_strconcat (_tmp60_, _tmp71_, NULL);
	_tmp73_ = _tmp72_;
	_tmp74_ = self->priv->_settings;
	_tmp75_ = paldo_installer_settings_get_root_password (_tmp74_);
	_tmp76_ = _tmp75_;
	_tmp77_ = g_strdup_printf ("root:%s", _tmp76_);
	_tmp78_ = _tmp77_;
	_tmp79_ = g_shell_quote (_tmp78_);
	_tmp80_ = _tmp79_;
	_tmp81_ = g_strdup_printf (" && ( echo %s | chroot /upkg chpasswd )", _tmp80_);
	_tmp82_ = _tmp81_;
	_tmp83_ = g_strconcat (_tmp73_, _tmp82_, NULL);
	_tmp84_ = _tmp83_;
	_tmp85_ = self->priv->_settings;
	_tmp86_ = paldo_installer_settings_get_language (_tmp85_);
	_tmp87_ = _tmp86_;
	_tmp88_ = self->priv->_settings;
	_tmp89_ = paldo_installer_settings_get_country (_tmp88_);
	_tmp90_ = _tmp89_;
	_tmp91_ = g_strdup_printf (" && sed -i -e 's/LANG=.*/LANG=%s_%s.UTF-8/' /upkg/etc/profile.d/locale" \
".sh", _tmp87_, _tmp90_);
	_tmp92_ = _tmp91_;
	_tmp93_ = g_strconcat (_tmp84_, _tmp92_, NULL);
	_tmp94_ = _tmp93_;
	_tmp95_ = self->priv->_settings;
	_tmp96_ = paldo_installer_settings_get_language (_tmp95_);
	_tmp97_ = _tmp96_;
	_tmp98_ = self->priv->_settings;
	_tmp99_ = paldo_installer_settings_get_country (_tmp98_);
	_tmp100_ = _tmp99_;
	_tmp101_ = g_strdup_printf (" && echo LANG=%s_%s.UTF-8 > /upkg/etc/locale.conf", _tmp97_, _tmp100_);
	_tmp102_ = _tmp101_;
	_tmp103_ = g_strconcat (_tmp94_, _tmp102_, NULL);
	_tmp104_ = _tmp103_;
	_tmp105_ = self->priv->_settings;
	_tmp106_ = paldo_installer_settings_get_kbd (_tmp105_);
	_tmp107_ = _tmp106_;
	_tmp108_ = g_strdup_printf (" && echo KEYMAP=%s > /upkg/etc/vconsole.conf", _tmp107_);
	_tmp109_ = _tmp108_;
	_tmp110_ = g_strconcat (_tmp104_, _tmp109_, NULL);
	_tmp111_ = _tmp110_;
	_tmp112_ = self->priv->_settings;
	_tmp113_ = paldo_installer_settings_get_xkblayout (_tmp112_);
	_tmp114_ = _tmp113_;
	_tmp115_ = self->priv->_settings;
	_tmp116_ = paldo_installer_settings_get_xkbvariant (_tmp115_);
	_tmp117_ = _tmp116_;
	_tmp118_ = g_strdup_printf (" && localectl set-x11-keymap %s %s", _tmp114_, _tmp117_);
	_tmp119_ = _tmp118_;
	_tmp120_ = g_strconcat (_tmp111_, _tmp119_, NULL);
	_tmp121_ = _tmp120_;
	_tmp122_ = g_strconcat (_tmp121_, " && install -D -m 0644 /etc/X11/xorg.conf.d/00-keyboard.conf /upkg/etc" \
"/X11/xorg.conf.d/00-keyboard.conf", NULL);
	_tmp123_ = _tmp122_;
	_tmp124_ = self->priv->_settings;
	_tmp125_ = paldo_installer_settings_get_timezone (_tmp124_);
	_tmp126_ = _tmp125_;
	_tmp127_ = g_strdup_printf (" && cp /upkg/usr/share/zoneinfo/%s /upkg/etc/localtime", _tmp126_);
	_tmp128_ = _tmp127_;
	_tmp129_ = g_strconcat (_tmp123_, _tmp128_, NULL);
	_tmp130_ = _tmp129_;
	_tmp131_ = paldo_command_new (_tmp130_, NULL);
	_tmp132_ = _tmp131_;
	_g_free0 (_tmp130_);
	_g_free0 (_tmp128_);
	_g_free0 (_tmp123_);
	_g_free0 (_tmp121_);
	_g_free0 (_tmp119_);
	_g_free0 (_tmp111_);
	_g_free0 (_tmp109_);
	_g_free0 (_tmp104_);
	_g_free0 (_tmp102_);
	_g_free0 (_tmp94_);
	_g_free0 (_tmp92_);
	_g_free0 (_tmp84_);
	_g_free0 (_tmp82_);
	_g_free0 (_tmp80_);
	_g_free0 (_tmp78_);
	_g_free0 (_tmp73_);
	_g_free0 (_tmp71_);
	_g_free0 (_tmp60_);
	_g_free0 (_tmp58_);
	_g_free0 (_tmp53_);
	_g_free0 (_tmp51_);
	system_config_cmd = _tmp132_;
	_tmp133_ = system_config_cmd;
	g_signal_connect_object (_tmp133_, "exit", (GCallback) _paldo_install_page_system_config_exit_paldo_command_exit, self, 0);
	_tmp134_ = system_config_cmd;
	if (!paldo_command_run (_tmp134_)) {
		PaldoCommand* _tmp135_;
		const gchar* _tmp136_;
		const gchar* _tmp137_;
		gchar* _tmp138_;
		gchar* _tmp139_;
		_tmp135_ = system_config_cmd;
		_tmp136_ = paldo_command_get_command_line (_tmp135_);
		_tmp137_ = _tmp136_;
		_tmp138_ = g_strdup_printf (_ ("Unable to run command `%s`"), _tmp137_);
		_tmp139_ = _tmp138_;
		paldo_install_page_display_error (self, _tmp139_);
		_g_free0 (_tmp139_);
		_g_object_unref0 (system_config_cmd);
		_g_free0 (fstab_sed);
		return;
	}
	_g_object_unref0 (system_config_cmd);
	_g_free0 (fstab_sed);
}


static void
_paldo_install_page_add_user_exit_paldo_command_exit (PaldoCommand* _sender,
                                                      gint status,
                                                      gpointer self)
{
	paldo_install_page_add_user_exit ((PaldoInstallPage*) self, _sender, status);
}


static void
paldo_install_page_system_config_exit (PaldoInstallPage* self,
                                       PaldoCommand* cmd,
                                       gint status)
{
	gint _tmp3_;
	PaldoCommand* add_user_cmd = NULL;
	PaldoInstallerSettings* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	PaldoInstallerSettings* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	PaldoInstallerSettings* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	PaldoInstallerSettings* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	PaldoInstallerSettings* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	PaldoInstallerSettings* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	PaldoInstallerSettings* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	PaldoCommand* _tmp39_;
	PaldoCommand* _tmp40_;
	PaldoCommand* _tmp41_;
	PaldoCommand* _tmp42_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (status != 0) {
		PaldoInstallerSettings* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp0_ = self->priv->_settings;
		_tmp1_ = paldo_installer_settings_get_home_dev (_tmp0_);
		_tmp2_ = _tmp1_;
		if (_tmp2_ != NULL) {
			g_spawn_command_line_sync ("umount -l /upkg/home", NULL, NULL, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		g_spawn_command_line_sync ("umount -l /upkg/boot", NULL, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		g_spawn_command_line_sync ("umount -l /upkg", NULL, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		paldo_install_page_display_error (self, _ ("Error while writing system configuration."));
		return;
	}
	_tmp3_ = self->priv->add_user_ticks;
	paldo_install_page_update_progress (self, _tmp3_, _ ("Adding user"));
	_tmp4_ = self->priv->_settings;
	_tmp5_ = paldo_installer_settings_get_uid (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->_settings;
	_tmp8_ = paldo_installer_settings_get_username (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup_printf ("chroot /upkg groupadd -g %d %s", _tmp6_, _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->_settings;
	_tmp13_ = paldo_installer_settings_get_uid (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = self->priv->_settings;
	_tmp16_ = paldo_installer_settings_get_username (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = self->priv->_settings;
	_tmp19_ = paldo_installer_settings_get_username (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strdup_printf (" && chroot /upkg useradd -m -u %d -g %s -G audio,cdrom,network,video,w" \
"heel %s", _tmp14_, _tmp17_, _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strconcat (_tmp11_, _tmp22_, NULL);
	_tmp24_ = _tmp23_;
	_tmp25_ = self->priv->_settings;
	_tmp26_ = paldo_installer_settings_get_username (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = self->priv->_settings;
	_tmp29_ = paldo_installer_settings_get_user_password (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strdup_printf ("%s:%s", _tmp27_, _tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = g_shell_quote (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = g_strdup_printf (" && ( echo %s | chroot /upkg chpasswd )", _tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = g_strconcat (_tmp24_, _tmp36_, NULL);
	_tmp38_ = _tmp37_;
	_tmp39_ = paldo_command_new (_tmp38_, NULL);
	_tmp40_ = _tmp39_;
	_g_free0 (_tmp38_);
	_g_free0 (_tmp36_);
	_g_free0 (_tmp34_);
	_g_free0 (_tmp32_);
	_g_free0 (_tmp24_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp11_);
	add_user_cmd = _tmp40_;
	_tmp41_ = add_user_cmd;
	g_signal_connect_object (_tmp41_, "exit", (GCallback) _paldo_install_page_add_user_exit_paldo_command_exit, self, 0);
	_tmp42_ = add_user_cmd;
	if (!paldo_command_run (_tmp42_)) {
		PaldoCommand* _tmp43_;
		const gchar* _tmp44_;
		const gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		_tmp43_ = add_user_cmd;
		_tmp44_ = paldo_command_get_command_line (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = g_strdup_printf (_ ("Unable to run command `%s`"), _tmp45_);
		_tmp47_ = _tmp46_;
		paldo_install_page_display_error (self, _tmp47_);
		_g_free0 (_tmp47_);
		_g_object_unref0 (add_user_cmd);
		return;
	}
	_g_object_unref0 (add_user_cmd);
}


static void
paldo_install_page_add_user_exit (PaldoInstallPage* self,
                                  PaldoCommand* cmd,
                                  gint status)
{
	gint _tmp0_;
	PaldoInstallerSettings* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->unmount_ticks;
	paldo_install_page_update_progress (self, _tmp0_, _ ("Unmounting partitions"));
	_tmp1_ = self->priv->_settings;
	_tmp2_ = paldo_installer_settings_get_home_dev (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		g_spawn_command_line_sync ("umount -l /upkg/home", NULL, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_spawn_command_line_sync ("umount -l /upkg/boot", NULL, NULL, NULL, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_spawn_command_line_sync ("umount -l /upkg", NULL, NULL, NULL, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	if (status != 0) {
		paldo_install_page_display_error (self, _ ("Error while adding user."));
		return;
	}
	_tmp4_ = self->priv->total_ticks;
	paldo_install_page_update_progress (self, _tmp4_, _ ("Installation finished."));
	g_signal_emit (self, paldo_install_page_signals[PALDO_INSTALL_PAGE_COMPLETE_CHANGED_SIGNAL], 0, TRUE);
}


PaldoInstallerSettings*
paldo_install_page_get_settings (PaldoInstallPage* self)
{
	PaldoInstallerSettings* result;
	PaldoInstallerSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


void
paldo_install_page_set_settings (PaldoInstallPage* self,
                                 PaldoInstallerSettings* value)
{
	g_return_if_fail (self != NULL);
	if (paldo_install_page_get_settings (self) != value) {
		PaldoInstallerSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_settings);
		self->priv->_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, paldo_install_page_properties[PALDO_INSTALL_PAGE_SETTINGS_PROPERTY]);
	}
}


static void
paldo_install_page_class_init (PaldoInstallPageClass * klass)
{
	paldo_install_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PaldoInstallPage_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_paldo_install_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_paldo_install_page_set_property;
	G_OBJECT_CLASS (klass)->finalize = paldo_install_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PALDO_INSTALL_PAGE_SETTINGS_PROPERTY, paldo_install_page_properties[PALDO_INSTALL_PAGE_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", PALDO_TYPE_INSTALLER_SETTINGS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	paldo_install_page_signals[PALDO_INSTALL_PAGE_COMPLETE_CHANGED_SIGNAL] = g_signal_new ("complete-changed", PALDO_TYPE_INSTALL_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}


static void
paldo_install_page_instance_init (PaldoInstallPage * self)
{
	self->priv = paldo_install_page_get_instance_private (self);
}


static void
paldo_install_page_finalize (GObject * obj)
{
	PaldoInstallPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PALDO_TYPE_INSTALL_PAGE, PaldoInstallPage);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->progress_bar);
	_g_object_unref0 (self->priv->operation_label);
	G_OBJECT_CLASS (paldo_install_page_parent_class)->finalize (obj);
}


GType
paldo_install_page_get_type (void)
{
	static volatile gsize paldo_install_page_type_id__volatile = 0;
	if (g_once_init_enter (&paldo_install_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PaldoInstallPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) paldo_install_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PaldoInstallPage), 0, (GInstanceInitFunc) paldo_install_page_instance_init, NULL };
		GType paldo_install_page_type_id;
		paldo_install_page_type_id = g_type_register_static (gtk_vbox_get_type (), "PaldoInstallPage", &g_define_type_info, 0);
		PaldoInstallPage_private_offset = g_type_add_instance_private (paldo_install_page_type_id, sizeof (PaldoInstallPagePrivate));
		g_once_init_leave (&paldo_install_page_type_id__volatile, paldo_install_page_type_id);
	}
	return paldo_install_page_type_id__volatile;
}


static void
_vala_paldo_install_page_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	PaldoInstallPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PALDO_TYPE_INSTALL_PAGE, PaldoInstallPage);
	switch (property_id) {
		case PALDO_INSTALL_PAGE_SETTINGS_PROPERTY:
		g_value_set_object (value, paldo_install_page_get_settings (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_paldo_install_page_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	PaldoInstallPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PALDO_TYPE_INSTALL_PAGE, PaldoInstallPage);
	switch (property_id) {
		case PALDO_INSTALL_PAGE_SETTINGS_PROPERTY:
		paldo_install_page_set_settings (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



