/* WelcomePage.c generated by valac 0.42.4, the Vala compiler
 * generated from WelcomePage.vala, do not modify */

/* WelcomePage.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define PALDO_TYPE_WELCOME_PAGE (paldo_welcome_page_get_type ())
#define PALDO_WELCOME_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PALDO_TYPE_WELCOME_PAGE, PaldoWelcomePage))
#define PALDO_WELCOME_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PALDO_TYPE_WELCOME_PAGE, PaldoWelcomePageClass))
#define PALDO_IS_WELCOME_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PALDO_TYPE_WELCOME_PAGE))
#define PALDO_IS_WELCOME_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PALDO_TYPE_WELCOME_PAGE))
#define PALDO_WELCOME_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PALDO_TYPE_WELCOME_PAGE, PaldoWelcomePageClass))

typedef struct _PaldoWelcomePage PaldoWelcomePage;
typedef struct _PaldoWelcomePageClass PaldoWelcomePageClass;
typedef struct _PaldoWelcomePagePrivate PaldoWelcomePagePrivate;

#define PALDO_TYPE_INSTALLER_SETTINGS (paldo_installer_settings_get_type ())
#define PALDO_INSTALLER_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PALDO_TYPE_INSTALLER_SETTINGS, PaldoInstallerSettings))
#define PALDO_INSTALLER_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PALDO_TYPE_INSTALLER_SETTINGS, PaldoInstallerSettingsClass))
#define PALDO_IS_INSTALLER_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PALDO_TYPE_INSTALLER_SETTINGS))
#define PALDO_IS_INSTALLER_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PALDO_TYPE_INSTALLER_SETTINGS))
#define PALDO_INSTALLER_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PALDO_TYPE_INSTALLER_SETTINGS, PaldoInstallerSettingsClass))

typedef struct _PaldoInstallerSettings PaldoInstallerSettings;
typedef struct _PaldoInstallerSettingsClass PaldoInstallerSettingsClass;
enum  {
	PALDO_WELCOME_PAGE_0_PROPERTY,
	PALDO_WELCOME_PAGE_SETTINGS_PROPERTY,
	PALDO_WELCOME_PAGE_NUM_PROPERTIES
};
static GParamSpec* paldo_welcome_page_properties[PALDO_WELCOME_PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _PaldoWelcomePage {
	GtkVBox parent_instance;
	PaldoWelcomePagePrivate * priv;
};

struct _PaldoWelcomePageClass {
	GtkVBoxClass parent_class;
};

struct _PaldoWelcomePagePrivate {
	PaldoInstallerSettings* _settings;
	GtkListStore* language_model;
	GtkComboBox* language_combobox;
	GtkListStore* country_model;
	GtkComboBox* country_combobox;
	GtkListStore* kbd_model;
	GtkComboBox* kbd_combobox;
	GtkListStore* tz_model;
	GtkComboBox* tz_combobox;
	GtkTreeModelFilter* country_filter;
	gint n_languages;
	gint n_countries;
	GHashTable* language_code_table;
	GHashTable* country_code_table;
	gboolean* language_countries;
	gint language_countries_length1;
	gint _language_countries_size_;
	gint* language_default_country;
	gint language_default_country_length1;
	gint _language_default_country_size_;
	gint n_keyboard_layouts;
	gint n_timezones;
};


static gint PaldoWelcomePage_private_offset;
static gpointer paldo_welcome_page_parent_class = NULL;

GType paldo_welcome_page_get_type (void) G_GNUC_CONST;
GType paldo_installer_settings_get_type (void) G_GNUC_CONST;
PaldoWelcomePage* paldo_welcome_page_new (PaldoInstallerSettings* settings);
PaldoWelcomePage* paldo_welcome_page_construct (GType object_type,
                                                PaldoInstallerSettings* settings);
void paldo_welcome_page_set_settings (PaldoWelcomePage* self,
                                      PaldoInstallerSettings* value);
static void paldo_welcome_page_add_language (PaldoWelcomePage* self,
                                      const gchar* code,
                                      const gchar* name);
static void paldo_welcome_page_language_changed (PaldoWelcomePage* self,
                                          GtkComboBox* combobox);
static void _paldo_welcome_page_language_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                 gpointer self);
static void paldo_welcome_page_add_country (PaldoWelcomePage* self,
                                     const gchar* code,
                                     const gchar* name);
static void paldo_welcome_page_country_changed (PaldoWelcomePage* self,
                                         GtkComboBox* combobox);
static void _paldo_welcome_page_country_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                gpointer self);
static void paldo_welcome_page_add_locale (PaldoWelcomePage* self,
                                    const gchar* language,
                                    const gchar* country,
                                    gboolean default_country);
static gint paldo_welcome_page_add_keyboard_layout (PaldoWelcomePage* self,
                                             const gchar* xkblayout,
                                             const gchar* xkbvariant,
                                             const gchar* kbd,
                                             const gchar* name);
static void paldo_welcome_page_kbd_changed (PaldoWelcomePage* self,
                                     GtkComboBox* combobox);
static void _paldo_welcome_page_kbd_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                            gpointer self);
static gint paldo_welcome_page_add_time_zone (PaldoWelcomePage* self,
                                       const gchar* code,
                                       const gchar* name);
static void paldo_welcome_page_tz_changed (PaldoWelcomePage* self,
                                    GtkComboBox* combobox);
static void _paldo_welcome_page_tz_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                           gpointer self);
static void paldo_welcome_page_update_settings (PaldoWelcomePage* self);
PaldoInstallerSettings* paldo_welcome_page_get_settings (PaldoWelcomePage* self);
void paldo_installer_settings_set_language (PaldoInstallerSettings* self,
                                            const gchar* value);
void paldo_installer_settings_set_country (PaldoInstallerSettings* self,
                                           const gchar* value);
void paldo_installer_settings_set_language_name (PaldoInstallerSettings* self,
                                                 const gchar* value);
void paldo_installer_settings_set_xkblayout (PaldoInstallerSettings* self,
                                             const gchar* value);
void paldo_installer_settings_set_xkbvariant (PaldoInstallerSettings* self,
                                              const gchar* value);
void paldo_installer_settings_set_kbd (PaldoInstallerSettings* self,
                                       const gchar* value);
void paldo_installer_settings_set_keyboard_name (PaldoInstallerSettings* self,
                                                 const gchar* value);
void paldo_installer_settings_set_timezone (PaldoInstallerSettings* self,
                                            const gchar* value);
void paldo_installer_settings_set_timezone_name (PaldoInstallerSettings* self,
                                                 const gchar* value);
static void paldo_welcome_page_finalize (GObject * obj);
static void _vala_paldo_welcome_page_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_paldo_welcome_page_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);


static inline gpointer
paldo_welcome_page_get_instance_private (PaldoWelcomePage* self)
{
	return G_STRUCT_MEMBER_P (self, PaldoWelcomePage_private_offset);
}


static void
_paldo_welcome_page_language_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                            gpointer self)
{
	paldo_welcome_page_language_changed ((PaldoWelcomePage*) self, _sender);
}


static void
_paldo_welcome_page_country_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                           gpointer self)
{
	paldo_welcome_page_country_changed ((PaldoWelcomePage*) self, _sender);
}


static void
_paldo_welcome_page_kbd_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                       gpointer self)
{
	paldo_welcome_page_kbd_changed ((PaldoWelcomePage*) self, _sender);
}


static void
_paldo_welcome_page_tz_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                      gpointer self)
{
	paldo_welcome_page_tz_changed ((PaldoWelcomePage*) self, _sender);
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


PaldoWelcomePage*
paldo_welcome_page_construct (GType object_type,
                              PaldoInstallerSettings* settings)
{
	PaldoWelcomePage * self = NULL;
	GtkLabel* label = NULL;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* section_label = NULL;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkHBox* hbox = NULL;
	GtkHBox* _tmp7_;
	GtkHBox* _tmp8_;
	GtkHBox* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	gchar* current_locale = NULL;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	GtkListStore* _tmp14_;
	GtkListStore* _tmp15_;
	GtkComboBox* _tmp16_;
	GtkHBox* _tmp17_;
	GtkComboBox* _tmp18_;
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp19_;
	GtkComboBox* _tmp20_;
	GtkCellRendererText* _tmp21_;
	GtkComboBox* _tmp22_;
	GtkCellRendererText* _tmp23_;
	GtkComboBox* _tmp24_;
	GtkLabel* _tmp25_;
	GtkComboBox* _tmp26_;
	GtkListStore* _tmp27_;
	GtkListStore* _tmp28_;
	GtkTreeModelFilter* _tmp29_;
	GtkTreeModelFilter* _tmp30_;
	GtkTreeModelFilter* _tmp31_;
	GtkComboBox* _tmp32_;
	GtkHBox* _tmp33_;
	GtkComboBox* _tmp34_;
	GtkCellRendererPixbuf* renderer_pixbuf = NULL;
	GtkCellRendererPixbuf* _tmp35_;
	GtkComboBox* _tmp36_;
	GtkCellRendererPixbuf* _tmp37_;
	GtkComboBox* _tmp38_;
	GtkCellRendererPixbuf* _tmp39_;
	GtkCellRendererText* _tmp40_;
	GtkComboBox* _tmp41_;
	GtkCellRendererText* _tmp42_;
	GtkComboBox* _tmp43_;
	GtkCellRendererText* _tmp44_;
	GtkComboBox* _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	gboolean* _tmp48_;
	gint _tmp49_;
	gint* _tmp50_;
	GtkLabel* _tmp51_;
	GtkLabel* _tmp52_;
	GtkLabel* _tmp53_;
	GtkLabel* _tmp54_;
	GtkHBox* _tmp55_;
	GtkHBox* _tmp56_;
	GtkHBox* _tmp57_;
	GtkLabel* _tmp58_;
	GtkLabel* _tmp59_;
	GtkListStore* _tmp60_;
	gint kbd_br = 0;
	gint kbd_gb = 0;
	gint kbd_ca = 0;
	gint kbd_fr = 0;
	gint kbd_de = 0;
	gint kbd_it = 0;
	gint kbd_pl = 0;
	gint kbd_pt = 0;
	gint kbd_es = 0;
	gint kbd_ch_fr = 0;
	gint kbd_ch = 0;
	gint kbd_tr = 0;
	gint kbd_us = 0;
	GtkListStore* _tmp61_;
	GtkComboBox* _tmp62_;
	GtkHBox* _tmp63_;
	GtkComboBox* _tmp64_;
	GtkCellRendererText* _tmp65_;
	GtkComboBox* _tmp66_;
	GtkCellRendererText* _tmp67_;
	GtkComboBox* _tmp68_;
	GtkCellRendererText* _tmp69_;
	GtkComboBox* _tmp70_;
	GtkLabel* _tmp71_;
	GtkComboBox* _tmp72_;
	GtkLabel* _tmp73_;
	GtkLabel* _tmp74_;
	GtkLabel* _tmp75_;
	GtkLabel* _tmp76_;
	GtkHBox* _tmp77_;
	GtkHBox* _tmp78_;
	GtkHBox* _tmp79_;
	GtkLabel* _tmp80_;
	GtkLabel* _tmp81_;
	GtkListStore* _tmp82_;
	gint default_timezone = 0;
	GtkListStore* _tmp83_;
	GtkComboBox* _tmp84_;
	GtkHBox* _tmp85_;
	GtkComboBox* _tmp86_;
	GtkCellRendererText* _tmp87_;
	GtkComboBox* _tmp88_;
	GtkCellRendererText* _tmp89_;
	GtkComboBox* _tmp90_;
	GtkCellRendererText* _tmp91_;
	GtkComboBox* _tmp92_;
	gint _tmp93_;
	GtkComboBox* _tmp94_;
	GtkLabel* _tmp95_;
	GtkComboBox* _tmp96_;
	gint current_lang = 0;
	gchar* current_lang_str = NULL;
	gchar* _tmp97_;
	gboolean _tmp98_ = FALSE;
	const gchar* _tmp99_;
	GHashTable* _tmp105_;
	const gchar* _tmp106_;
	gconstpointer _tmp107_;
	GtkComboBox* _tmp108_;
	gint _tmp109_;
	gchar* current_country_str = NULL;
	gchar* _tmp110_;
	gboolean _tmp111_ = FALSE;
	const gchar* _tmp112_;
	const gchar* _tmp131_;
	g_return_val_if_fail (settings != NULL, NULL);
	self = (PaldoWelcomePage*) g_object_new (object_type, NULL);
	paldo_welcome_page_set_settings (self, settings);
	gtk_box_set_spacing ((GtkBox*) self, 6);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 12);
	_tmp0_ = (GtkLabel*) gtk_label_new (_ ("Welcome to the installation of paldo GNU/Linux."));
	g_object_ref_sink (_tmp0_);
	label = _tmp0_;
	_tmp1_ = label;
	gtk_label_set_xalign (_tmp1_, (gfloat) 0);
	_tmp2_ = label;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp2_, FALSE, FALSE, (guint) 0);
	_tmp3_ = (GtkLabel*) gtk_label_new (_ ("<b>Language</b>"));
	g_object_ref_sink (_tmp3_);
	section_label = _tmp3_;
	_tmp4_ = section_label;
	gtk_label_set_use_markup (_tmp4_, TRUE);
	_tmp5_ = section_label;
	gtk_label_set_xalign (_tmp5_, (gfloat) 0);
	_tmp6_ = section_label;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp6_, FALSE, FALSE, (guint) 0);
	_tmp7_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	g_object_ref_sink (_tmp7_);
	hbox = _tmp7_;
	_tmp8_ = hbox;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp8_, FALSE, FALSE, (guint) 0);
	_tmp9_ = hbox;
	_tmp10_ = (GtkLabel*) gtk_label_new ("    ");
	g_object_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	gtk_box_pack_start ((GtkBox*) _tmp9_, (GtkWidget*) _tmp11_, FALSE, FALSE, (guint) 0);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = g_getenv ("LANG");
	_tmp13_ = g_strdup (_tmp12_);
	current_locale = _tmp13_;
	_tmp14_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, -1);
	_g_object_unref0 (self->priv->language_model);
	self->priv->language_model = _tmp14_;
	paldo_welcome_page_add_language (self, "en", _ ("English"));
	paldo_welcome_page_add_language (self, "fr", _ ("French"));
	paldo_welcome_page_add_language (self, "de", _ ("German"));
	paldo_welcome_page_add_language (self, "it", _ ("Italian"));
	paldo_welcome_page_add_language (self, "pl", _ ("Polish"));
	paldo_welcome_page_add_language (self, "pt", _ ("Portuguese"));
	paldo_welcome_page_add_language (self, "es", _ ("Spanish"));
	paldo_welcome_page_add_language (self, "tr", _ ("Turkish"));
	_tmp15_ = self->priv->language_model;
	_tmp16_ = (GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) _tmp15_);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->language_combobox);
	self->priv->language_combobox = _tmp16_;
	_tmp17_ = hbox;
	_tmp18_ = self->priv->language_combobox;
	gtk_box_pack_start ((GtkBox*) _tmp17_, (GtkWidget*) _tmp18_, FALSE, FALSE, (guint) 6);
	_tmp19_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp19_);
	renderer = _tmp19_;
	_tmp20_ = self->priv->language_combobox;
	_tmp21_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp20_, (GtkCellRenderer*) _tmp21_, TRUE);
	_tmp22_ = self->priv->language_combobox;
	_tmp23_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp22_, (GtkCellRenderer*) _tmp23_, "text", 1);
	_tmp24_ = self->priv->language_combobox;
	g_signal_connect_object (_tmp24_, "changed", (GCallback) _paldo_welcome_page_language_changed_gtk_combo_box_changed, self, 0);
	_tmp25_ = section_label;
	_tmp26_ = self->priv->language_combobox;
	gtk_label_set_mnemonic_widget (_tmp25_, (GtkWidget*) _tmp26_);
	_tmp27_ = gtk_list_store_new (4, G_TYPE_STRING, G_TYPE_STRING, gdk_pixbuf_get_type (), G_TYPE_BOOLEAN, -1);
	_g_object_unref0 (self->priv->country_model);
	self->priv->country_model = _tmp27_;
	paldo_welcome_page_add_country (self, "AR", _ ("Argentinia"));
	paldo_welcome_page_add_country (self, "AU", _ ("Australia"));
	paldo_welcome_page_add_country (self, "AT", _ ("Austria"));
	paldo_welcome_page_add_country (self, "BE", _ ("Belgium"));
	paldo_welcome_page_add_country (self, "BO", _ ("Bolivia"));
	paldo_welcome_page_add_country (self, "BR", _ ("Brazil"));
	paldo_welcome_page_add_country (self, "CA", _ ("Canada"));
	paldo_welcome_page_add_country (self, "CL", _ ("Chile"));
	paldo_welcome_page_add_country (self, "CO", _ ("Colombia"));
	paldo_welcome_page_add_country (self, "CR", _ ("Costa Rica"));
	paldo_welcome_page_add_country (self, "DO", _ ("Dominican Republic"));
	paldo_welcome_page_add_country (self, "EC", _ ("Ecuador"));
	paldo_welcome_page_add_country (self, "SV", _ ("El Salvador"));
	paldo_welcome_page_add_country (self, "FR", _ ("France"));
	paldo_welcome_page_add_country (self, "DE", _ ("Germany"));
	paldo_welcome_page_add_country (self, "GT", _ ("Guatemala"));
	paldo_welcome_page_add_country (self, "HN", _ ("Honduras"));
	paldo_welcome_page_add_country (self, "IE", _ ("Ireland"));
	paldo_welcome_page_add_country (self, "IT", _ ("Italy"));
	paldo_welcome_page_add_country (self, "LU", _ ("Luxembourg"));
	paldo_welcome_page_add_country (self, "MX", _ ("Mexico"));
	paldo_welcome_page_add_country (self, "NI", _ ("Nicaragua"));
	paldo_welcome_page_add_country (self, "NZ", _ ("New Zealand"));
	paldo_welcome_page_add_country (self, "PA", _ ("Panama"));
	paldo_welcome_page_add_country (self, "PY", _ ("Paraguay"));
	paldo_welcome_page_add_country (self, "PE", _ ("Peru"));
	paldo_welcome_page_add_country (self, "PL", _ ("Poland"));
	paldo_welcome_page_add_country (self, "PT", _ ("Portugal"));
	paldo_welcome_page_add_country (self, "PR", _ ("Puerto Rico"));
	paldo_welcome_page_add_country (self, "ES", _ ("Spain"));
	paldo_welcome_page_add_country (self, "CH", _ ("Switzerland"));
	paldo_welcome_page_add_country (self, "TR", _ ("Turkey"));
	paldo_welcome_page_add_country (self, "GB", _ ("United Kingdom"));
	paldo_welcome_page_add_country (self, "US", _ ("United States"));
	paldo_welcome_page_add_country (self, "UY", _ ("Uruguay"));
	paldo_welcome_page_add_country (self, "VE", _ ("Venezuela"));
	_tmp28_ = self->priv->country_model;
	_tmp29_ = (GtkTreeModelFilter*) gtk_tree_model_filter_new ((GtkTreeModel*) _tmp28_, NULL);
	_g_object_unref0 (self->priv->country_filter);
	self->priv->country_filter = G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_tree_model_filter_get_type (), GtkTreeModelFilter);
	_tmp30_ = self->priv->country_filter;
	gtk_tree_model_filter_set_visible_column (_tmp30_, 3);
	_tmp31_ = self->priv->country_filter;
	_tmp32_ = (GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) _tmp31_);
	g_object_ref_sink (_tmp32_);
	_g_object_unref0 (self->priv->country_combobox);
	self->priv->country_combobox = _tmp32_;
	_tmp33_ = hbox;
	_tmp34_ = self->priv->country_combobox;
	gtk_box_pack_start ((GtkBox*) _tmp33_, (GtkWidget*) _tmp34_, TRUE, TRUE, (guint) 6);
	_tmp35_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp35_);
	renderer_pixbuf = _tmp35_;
	_tmp36_ = self->priv->country_combobox;
	_tmp37_ = renderer_pixbuf;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp36_, (GtkCellRenderer*) _tmp37_, FALSE);
	_tmp38_ = self->priv->country_combobox;
	_tmp39_ = renderer_pixbuf;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp38_, (GtkCellRenderer*) _tmp39_, "pixbuf", 2);
	_tmp40_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp40_);
	_g_object_unref0 (renderer);
	renderer = _tmp40_;
	_tmp41_ = self->priv->country_combobox;
	_tmp42_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp41_, (GtkCellRenderer*) _tmp42_, TRUE);
	_tmp43_ = self->priv->country_combobox;
	_tmp44_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp43_, (GtkCellRenderer*) _tmp44_, "text", 1);
	_tmp45_ = self->priv->country_combobox;
	g_signal_connect_object (_tmp45_, "changed", (GCallback) _paldo_welcome_page_country_changed_gtk_combo_box_changed, self, 0);
	_tmp46_ = self->priv->n_languages;
	_tmp47_ = self->priv->n_countries;
	_tmp48_ = g_new0 (gboolean, _tmp46_ * _tmp47_);
	self->priv->language_countries = (g_free (self->priv->language_countries), NULL);
	self->priv->language_countries = _tmp48_;
	self->priv->language_countries_length1 = _tmp46_ * _tmp47_;
	self->priv->_language_countries_size_ = self->priv->language_countries_length1;
	_tmp49_ = self->priv->n_languages;
	_tmp50_ = g_new0 (gint, _tmp49_);
	self->priv->language_default_country = (g_free (self->priv->language_default_country), NULL);
	self->priv->language_default_country = _tmp50_;
	self->priv->language_default_country_length1 = _tmp49_;
	self->priv->_language_default_country_size_ = self->priv->language_default_country_length1;
	paldo_welcome_page_add_locale (self, "de", "AT", FALSE);
	paldo_welcome_page_add_locale (self, "de", "BE", FALSE);
	paldo_welcome_page_add_locale (self, "de", "CH", FALSE);
	paldo_welcome_page_add_locale (self, "de", "DE", TRUE);
	paldo_welcome_page_add_locale (self, "de", "LU", FALSE);
	paldo_welcome_page_add_locale (self, "en", "AU", FALSE);
	paldo_welcome_page_add_locale (self, "en", "CA", FALSE);
	paldo_welcome_page_add_locale (self, "en", "CH", FALSE);
	paldo_welcome_page_add_locale (self, "en", "GB", FALSE);
	paldo_welcome_page_add_locale (self, "en", "IE", FALSE);
	paldo_welcome_page_add_locale (self, "en", "NZ", FALSE);
	paldo_welcome_page_add_locale (self, "en", "US", TRUE);
	paldo_welcome_page_add_locale (self, "es", "ES", TRUE);
	paldo_welcome_page_add_locale (self, "es", "MX", FALSE);
	paldo_welcome_page_add_locale (self, "es", "US", FALSE);
	paldo_welcome_page_add_locale (self, "fr", "BE", FALSE);
	paldo_welcome_page_add_locale (self, "fr", "CA", FALSE);
	paldo_welcome_page_add_locale (self, "fr", "CH", FALSE);
	paldo_welcome_page_add_locale (self, "fr", "FR", TRUE);
	paldo_welcome_page_add_locale (self, "fr", "LU", FALSE);
	paldo_welcome_page_add_locale (self, "it", "CH", FALSE);
	paldo_welcome_page_add_locale (self, "it", "IT", TRUE);
	paldo_welcome_page_add_locale (self, "pl", "PL", TRUE);
	paldo_welcome_page_add_locale (self, "pt", "BR", FALSE);
	paldo_welcome_page_add_locale (self, "pt", "PT", TRUE);
	paldo_welcome_page_add_locale (self, "tr", "TR", TRUE);
	_tmp51_ = (GtkLabel*) gtk_label_new (_ ("<b>Keyboard Layout</b>"));
	g_object_ref_sink (_tmp51_);
	_g_object_unref0 (section_label);
	section_label = _tmp51_;
	_tmp52_ = section_label;
	gtk_label_set_use_markup (_tmp52_, TRUE);
	_tmp53_ = section_label;
	gtk_label_set_xalign (_tmp53_, (gfloat) 0);
	_tmp54_ = section_label;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp54_, FALSE, FALSE, (guint) 0);
	_tmp55_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	g_object_ref_sink (_tmp55_);
	_g_object_unref0 (hbox);
	hbox = _tmp55_;
	_tmp56_ = hbox;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp56_, FALSE, FALSE, (guint) 0);
	_tmp57_ = hbox;
	_tmp58_ = (GtkLabel*) gtk_label_new ("    ");
	g_object_ref_sink (_tmp58_);
	_tmp59_ = _tmp58_;
	gtk_box_pack_start ((GtkBox*) _tmp57_, (GtkWidget*) _tmp59_, FALSE, FALSE, (guint) 0);
	_g_object_unref0 (_tmp59_);
	_tmp60_ = gtk_list_store_new (4, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, -1);
	_g_object_unref0 (self->priv->kbd_model);
	self->priv->kbd_model = _tmp60_;
	kbd_br = paldo_welcome_page_add_keyboard_layout (self, "br", "", "br-abnt2", _ ("Brazilian"));
	kbd_gb = paldo_welcome_page_add_keyboard_layout (self, "gb", "", "uk", _ ("British"));
	kbd_ca = paldo_welcome_page_add_keyboard_layout (self, "ca", "", "cf", _ ("Canadian"));
	kbd_fr = paldo_welcome_page_add_keyboard_layout (self, "fr", "", "fr-latin9", _ ("French"));
	kbd_de = paldo_welcome_page_add_keyboard_layout (self, "de", "", "de-latin1", _ ("German"));
	kbd_it = paldo_welcome_page_add_keyboard_layout (self, "it", "", "it", _ ("Italian"));
	kbd_pl = paldo_welcome_page_add_keyboard_layout (self, "pl", "", "pl", _ ("Polish"));
	kbd_pt = paldo_welcome_page_add_keyboard_layout (self, "pt", "", "pt-latin9", _ ("Portuguese"));
	kbd_es = paldo_welcome_page_add_keyboard_layout (self, "es", "", "es", _ ("Spanish"));
	kbd_ch_fr = paldo_welcome_page_add_keyboard_layout (self, "ch", "fr", "fr_CH-latin1", _ ("Swiss French"));
	kbd_ch = paldo_welcome_page_add_keyboard_layout (self, "ch", "de_nodeadkeys", "sg-latin1", _ ("Swiss German"));
	kbd_tr = paldo_welcome_page_add_keyboard_layout (self, "tr", "", "tr", _ ("Turkish"));
	kbd_us = paldo_welcome_page_add_keyboard_layout (self, "us", "", "us", _ ("United States"));
	_tmp61_ = self->priv->kbd_model;
	_tmp62_ = (GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) _tmp61_);
	g_object_ref_sink (_tmp62_);
	_g_object_unref0 (self->priv->kbd_combobox);
	self->priv->kbd_combobox = _tmp62_;
	_tmp63_ = hbox;
	_tmp64_ = self->priv->kbd_combobox;
	gtk_box_pack_start ((GtkBox*) _tmp63_, (GtkWidget*) _tmp64_, TRUE, TRUE, (guint) 6);
	_tmp65_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp65_);
	_g_object_unref0 (renderer);
	renderer = _tmp65_;
	_tmp66_ = self->priv->kbd_combobox;
	_tmp67_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp66_, (GtkCellRenderer*) _tmp67_, TRUE);
	_tmp68_ = self->priv->kbd_combobox;
	_tmp69_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp68_, (GtkCellRenderer*) _tmp69_, "text", 3);
	_tmp70_ = self->priv->kbd_combobox;
	g_signal_connect_object (_tmp70_, "changed", (GCallback) _paldo_welcome_page_kbd_changed_gtk_combo_box_changed, self, 0);
	_tmp71_ = section_label;
	_tmp72_ = self->priv->kbd_combobox;
	gtk_label_set_mnemonic_widget (_tmp71_, (GtkWidget*) _tmp72_);
	_tmp73_ = (GtkLabel*) gtk_label_new (_ ("<b>Time Zone</b>"));
	g_object_ref_sink (_tmp73_);
	_g_object_unref0 (section_label);
	section_label = _tmp73_;
	_tmp74_ = section_label;
	gtk_label_set_use_markup (_tmp74_, TRUE);
	_tmp75_ = section_label;
	gtk_label_set_xalign (_tmp75_, (gfloat) 0);
	_tmp76_ = section_label;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp76_, FALSE, FALSE, (guint) 0);
	_tmp77_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	g_object_ref_sink (_tmp77_);
	_g_object_unref0 (hbox);
	hbox = _tmp77_;
	_tmp78_ = hbox;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp78_, FALSE, FALSE, (guint) 0);
	_tmp79_ = hbox;
	_tmp80_ = (GtkLabel*) gtk_label_new ("    ");
	g_object_ref_sink (_tmp80_);
	_tmp81_ = _tmp80_;
	gtk_box_pack_start ((GtkBox*) _tmp79_, (GtkWidget*) _tmp81_, FALSE, FALSE, (guint) 0);
	_g_object_unref0 (_tmp81_);
	_tmp82_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, -1);
	_g_object_unref0 (self->priv->tz_model);
	self->priv->tz_model = _tmp82_;
	paldo_welcome_page_add_time_zone (self, "America/Los_Angeles", _ ("UTC-08:00: North American Pacific Time: Los Angeles"));
	paldo_welcome_page_add_time_zone (self, "America/Denver", _ ("UTC-07:00: North American Mountain Time: Denver"));
	paldo_welcome_page_add_time_zone (self, "America/Chicago", _ ("UTC-06:00: North American Central Time: Chicago"));
	paldo_welcome_page_add_time_zone (self, "America/New_York", _ ("UTC-05:00: North American Eastern Time: New York"));
	paldo_welcome_page_add_time_zone (self, "Europe/London", _ ("UTC+00:00: Western European Time: Dublin, Edinburgh, Lisbon, London"));
	default_timezone = paldo_welcome_page_add_time_zone (self, "Europe/Zurich", _ ("UTC+01:00: Central European Time: Amsterdam, Berlin, Bern, Rome, Stock" \
"holm, Vienna"));
	paldo_welcome_page_add_time_zone (self, "Europe/Istanbul", _ ("UTC+02:00: Eastern European Time: Istanbul"));
	paldo_welcome_page_add_time_zone (self, "Australia/Perth", _ ("UTC+08:00: Australian Western Time: Perth"));
	paldo_welcome_page_add_time_zone (self, "Australia/Adelaide", _ ("UTC+09:30: Australian Central Time: Adelaide"));
	paldo_welcome_page_add_time_zone (self, "Australia/Melbourne", _ ("UTC+10:00: Australian Eastern Time: Melbourne"));
	_tmp83_ = self->priv->tz_model;
	_tmp84_ = (GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) _tmp83_);
	g_object_ref_sink (_tmp84_);
	_g_object_unref0 (self->priv->tz_combobox);
	self->priv->tz_combobox = _tmp84_;
	_tmp85_ = hbox;
	_tmp86_ = self->priv->tz_combobox;
	gtk_box_pack_start ((GtkBox*) _tmp85_, (GtkWidget*) _tmp86_, TRUE, TRUE, (guint) 6);
	_tmp87_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp87_);
	_g_object_unref0 (renderer);
	renderer = _tmp87_;
	_tmp88_ = self->priv->tz_combobox;
	_tmp89_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp88_, (GtkCellRenderer*) _tmp89_, TRUE);
	_tmp90_ = self->priv->tz_combobox;
	_tmp91_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp90_, (GtkCellRenderer*) _tmp91_, "text", 1);
	_tmp92_ = self->priv->tz_combobox;
	_tmp93_ = default_timezone;
	gtk_combo_box_set_active (_tmp92_, _tmp93_);
	_tmp94_ = self->priv->tz_combobox;
	g_signal_connect_object (_tmp94_, "changed", (GCallback) _paldo_welcome_page_tz_changed_gtk_combo_box_changed, self, 0);
	_tmp95_ = section_label;
	_tmp96_ = self->priv->tz_combobox;
	gtk_label_set_mnemonic_widget (_tmp95_, (GtkWidget*) _tmp96_);
	_tmp97_ = g_strdup ("en");
	current_lang_str = _tmp97_;
	_tmp99_ = current_locale;
	if (_tmp99_ != NULL) {
		const gchar* _tmp100_;
		gint _tmp101_;
		gint _tmp102_;
		_tmp100_ = current_locale;
		_tmp101_ = strlen (_tmp100_);
		_tmp102_ = _tmp101_;
		_tmp98_ = _tmp102_ >= 2;
	} else {
		_tmp98_ = FALSE;
	}
	if (_tmp98_) {
		const gchar* _tmp103_;
		gchar* _tmp104_;
		_tmp103_ = current_locale;
		_tmp104_ = string_substring (_tmp103_, (glong) 0, (glong) 2);
		_g_free0 (current_lang_str);
		current_lang_str = _tmp104_;
	}
	_tmp105_ = self->priv->language_code_table;
	_tmp106_ = current_lang_str;
	_tmp107_ = g_hash_table_lookup (_tmp105_, _tmp106_);
	current_lang = (gint) ((gintptr) _tmp107_);
	_tmp108_ = self->priv->language_combobox;
	_tmp109_ = current_lang;
	gtk_combo_box_set_active (_tmp108_, _tmp109_);
	_tmp110_ = g_strdup ("CH");
	current_country_str = _tmp110_;
	_tmp112_ = current_locale;
	if (_tmp112_ != NULL) {
		const gchar* _tmp113_;
		gint _tmp114_;
		gint _tmp115_;
		_tmp113_ = current_locale;
		_tmp114_ = strlen (_tmp113_);
		_tmp115_ = _tmp114_;
		_tmp111_ = _tmp115_ >= 5;
	} else {
		_tmp111_ = FALSE;
	}
	if (_tmp111_) {
		const gchar* _tmp116_;
		gchar* _tmp117_;
		gint current_country = 0;
		GHashTable* _tmp118_;
		const gchar* _tmp119_;
		gconstpointer _tmp120_;
		GtkComboBox* _tmp121_;
		gint _tmp122_;
		GtkTreeIter iter = {0};
		GtkTreeIter filter_iter = {0};
		GtkListStore* _tmp123_;
		gint _tmp124_;
		GtkTreeIter _tmp125_ = {0};
		GtkTreeModelFilter* _tmp126_;
		GtkTreeIter _tmp127_;
		GtkTreeIter _tmp128_ = {0};
		GtkComboBox* _tmp129_;
		GtkTreeIter _tmp130_;
		_tmp116_ = current_locale;
		_tmp117_ = string_substring (_tmp116_, (glong) 3, (glong) 2);
		_g_free0 (current_country_str);
		current_country_str = _tmp117_;
		_tmp118_ = self->priv->country_code_table;
		_tmp119_ = current_country_str;
		_tmp120_ = g_hash_table_lookup (_tmp118_, _tmp119_);
		current_country = (gint) ((gintptr) _tmp120_);
		_tmp121_ = self->priv->language_combobox;
		_tmp122_ = current_lang;
		gtk_combo_box_set_active (_tmp121_, _tmp122_);
		_tmp123_ = self->priv->country_model;
		_tmp124_ = current_country;
		gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp123_, &_tmp125_, NULL, _tmp124_);
		iter = _tmp125_;
		_tmp126_ = self->priv->country_filter;
		_tmp127_ = iter;
		gtk_tree_model_filter_convert_child_iter_to_iter (_tmp126_, &_tmp128_, &_tmp127_);
		filter_iter = _tmp128_;
		_tmp129_ = self->priv->country_combobox;
		_tmp130_ = filter_iter;
		gtk_combo_box_set_active_iter (_tmp129_, &_tmp130_);
	}
	_tmp131_ = current_country_str;
	if (g_strcmp0 (_tmp131_, "BR") == 0) {
		GtkComboBox* _tmp132_;
		gint _tmp133_;
		_tmp132_ = self->priv->kbd_combobox;
		_tmp133_ = kbd_br;
		gtk_combo_box_set_active (_tmp132_, _tmp133_);
	} else {
		const gchar* _tmp134_;
		_tmp134_ = current_country_str;
		if (g_strcmp0 (_tmp134_, "CA") == 0) {
			GtkComboBox* _tmp135_;
			gint _tmp136_;
			_tmp135_ = self->priv->kbd_combobox;
			_tmp136_ = kbd_ca;
			gtk_combo_box_set_active (_tmp135_, _tmp136_);
		} else {
			gboolean _tmp137_ = FALSE;
			const gchar* _tmp138_;
			_tmp138_ = current_country_str;
			if (g_strcmp0 (_tmp138_, "CH") == 0) {
				const gchar* _tmp139_;
				_tmp139_ = current_lang_str;
				_tmp137_ = g_strcmp0 (_tmp139_, "fr") == 0;
			} else {
				_tmp137_ = FALSE;
			}
			if (_tmp137_) {
				GtkComboBox* _tmp140_;
				gint _tmp141_;
				_tmp140_ = self->priv->kbd_combobox;
				_tmp141_ = kbd_ch_fr;
				gtk_combo_box_set_active (_tmp140_, _tmp141_);
			} else {
				const gchar* _tmp142_;
				_tmp142_ = current_country_str;
				if (g_strcmp0 (_tmp142_, "CH") == 0) {
					GtkComboBox* _tmp143_;
					gint _tmp144_;
					_tmp143_ = self->priv->kbd_combobox;
					_tmp144_ = kbd_ch;
					gtk_combo_box_set_active (_tmp143_, _tmp144_);
				} else {
					gboolean _tmp145_ = FALSE;
					const gchar* _tmp146_;
					_tmp146_ = current_country_str;
					if (g_strcmp0 (_tmp146_, "DE") == 0) {
						_tmp145_ = TRUE;
					} else {
						const gchar* _tmp147_;
						_tmp147_ = current_country_str;
						_tmp145_ = g_strcmp0 (_tmp147_, "AT") == 0;
					}
					if (_tmp145_) {
						GtkComboBox* _tmp148_;
						gint _tmp149_;
						_tmp148_ = self->priv->kbd_combobox;
						_tmp149_ = kbd_de;
						gtk_combo_box_set_active (_tmp148_, _tmp149_);
					} else {
						const gchar* _tmp150_;
						_tmp150_ = current_country_str;
						if (g_strcmp0 (_tmp150_, "GB") == 0) {
							GtkComboBox* _tmp151_;
							gint _tmp152_;
							_tmp151_ = self->priv->kbd_combobox;
							_tmp152_ = kbd_gb;
							gtk_combo_box_set_active (_tmp151_, _tmp152_);
						} else {
							const gchar* _tmp153_;
							_tmp153_ = current_lang_str;
							if (g_strcmp0 (_tmp153_, "es") == 0) {
								GtkComboBox* _tmp154_;
								gint _tmp155_;
								_tmp154_ = self->priv->kbd_combobox;
								_tmp155_ = kbd_es;
								gtk_combo_box_set_active (_tmp154_, _tmp155_);
							} else {
								const gchar* _tmp156_;
								_tmp156_ = current_lang_str;
								if (g_strcmp0 (_tmp156_, "fr") == 0) {
									GtkComboBox* _tmp157_;
									gint _tmp158_;
									_tmp157_ = self->priv->kbd_combobox;
									_tmp158_ = kbd_fr;
									gtk_combo_box_set_active (_tmp157_, _tmp158_);
								} else {
									const gchar* _tmp159_;
									_tmp159_ = current_lang_str;
									if (g_strcmp0 (_tmp159_, "it") == 0) {
										GtkComboBox* _tmp160_;
										gint _tmp161_;
										_tmp160_ = self->priv->kbd_combobox;
										_tmp161_ = kbd_it;
										gtk_combo_box_set_active (_tmp160_, _tmp161_);
									} else {
										const gchar* _tmp162_;
										_tmp162_ = current_lang_str;
										if (g_strcmp0 (_tmp162_, "pl") == 0) {
											GtkComboBox* _tmp163_;
											gint _tmp164_;
											_tmp163_ = self->priv->kbd_combobox;
											_tmp164_ = kbd_pl;
											gtk_combo_box_set_active (_tmp163_, _tmp164_);
										} else {
											const gchar* _tmp165_;
											_tmp165_ = current_lang_str;
											if (g_strcmp0 (_tmp165_, "pt") == 0) {
												GtkComboBox* _tmp166_;
												gint _tmp167_;
												_tmp166_ = self->priv->kbd_combobox;
												_tmp167_ = kbd_pt;
												gtk_combo_box_set_active (_tmp166_, _tmp167_);
											} else {
												const gchar* _tmp168_;
												_tmp168_ = current_lang_str;
												if (g_strcmp0 (_tmp168_, "tr") == 0) {
													GtkComboBox* _tmp169_;
													gint _tmp170_;
													_tmp169_ = self->priv->kbd_combobox;
													_tmp170_ = kbd_tr;
													gtk_combo_box_set_active (_tmp169_, _tmp170_);
												} else {
													GtkComboBox* _tmp171_;
													gint _tmp172_;
													_tmp171_ = self->priv->kbd_combobox;
													_tmp172_ = kbd_us;
													gtk_combo_box_set_active (_tmp171_, _tmp172_);
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_g_free0 (current_country_str);
	_g_free0 (current_lang_str);
	_g_object_unref0 (renderer_pixbuf);
	_g_object_unref0 (renderer);
	_g_free0 (current_locale);
	_g_object_unref0 (hbox);
	_g_object_unref0 (section_label);
	_g_object_unref0 (label);
	return self;
}


PaldoWelcomePage*
paldo_welcome_page_new (PaldoInstallerSettings* settings)
{
	return paldo_welcome_page_construct (PALDO_TYPE_WELCOME_PAGE, settings);
}


static void
paldo_welcome_page_language_changed (PaldoWelcomePage* self,
                                     GtkComboBox* combobox)
{
	gint l = 0;
	gint _tmp0_;
	gint _tmp1_;
	GtkComboBox* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combobox != NULL);
	_tmp0_ = gtk_combo_box_get_active (combobox);
	_tmp1_ = _tmp0_;
	l = _tmp1_;
	{
		gint c = 0;
		c = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_;
				gint _tmp5_;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp6_;
				gint _tmp7_;
				GtkTreeIter _tmp8_ = {0};
				GtkListStore* _tmp9_;
				GtkTreeIter _tmp10_;
				gboolean* _tmp11_;
				gint _tmp11__length1;
				gint _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				gboolean _tmp15_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = c;
					c = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = c;
				_tmp5_ = self->priv->n_countries;
				if (!(_tmp4_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->country_model;
				_tmp7_ = c;
				gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp6_, &_tmp8_, NULL, _tmp7_);
				iter = _tmp8_;
				_tmp9_ = self->priv->country_model;
				_tmp10_ = iter;
				_tmp11_ = self->priv->language_countries;
				_tmp11__length1 = self->priv->language_countries_length1;
				_tmp12_ = l;
				_tmp13_ = self->priv->n_countries;
				_tmp14_ = c;
				_tmp15_ = _tmp11_[(_tmp12_ * _tmp13_) + _tmp14_];
				gtk_list_store_set (_tmp9_, &_tmp10_, 3, _tmp15_, -1, -1);
			}
		}
	}
	_tmp16_ = self->priv->country_combobox;
	_tmp17_ = gtk_combo_box_get_active (_tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_ == -1) {
		GtkTreeIter iter = {0};
		GtkTreeIter filter_iter = {0};
		GtkListStore* _tmp19_;
		gint* _tmp20_;
		gint _tmp20__length1;
		gint _tmp21_;
		gint _tmp22_;
		GtkTreeIter _tmp23_ = {0};
		GtkTreeModelFilter* _tmp24_;
		GtkTreeIter _tmp25_;
		GtkTreeIter _tmp26_ = {0};
		GtkComboBox* _tmp27_;
		GtkTreeIter _tmp28_;
		_tmp19_ = self->priv->country_model;
		_tmp20_ = self->priv->language_default_country;
		_tmp20__length1 = self->priv->language_default_country_length1;
		_tmp21_ = l;
		_tmp22_ = _tmp20_[_tmp21_];
		gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp19_, &_tmp23_, NULL, _tmp22_);
		iter = _tmp23_;
		_tmp24_ = self->priv->country_filter;
		_tmp25_ = iter;
		gtk_tree_model_filter_convert_child_iter_to_iter (_tmp24_, &_tmp26_, &_tmp25_);
		filter_iter = _tmp26_;
		_tmp27_ = self->priv->country_combobox;
		_tmp28_ = filter_iter;
		gtk_combo_box_set_active_iter (_tmp27_, &_tmp28_);
	}
	paldo_welcome_page_update_settings (self);
}


static void
paldo_welcome_page_country_changed (PaldoWelcomePage* self,
                                    GtkComboBox* combobox)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (combobox != NULL);
	paldo_welcome_page_update_settings (self);
}


static void
paldo_welcome_page_kbd_changed (PaldoWelcomePage* self,
                                GtkComboBox* combobox)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (combobox != NULL);
	paldo_welcome_page_update_settings (self);
}


static void
paldo_welcome_page_tz_changed (PaldoWelcomePage* self,
                               GtkComboBox* combobox)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (combobox != NULL);
	paldo_welcome_page_update_settings (self);
}


static void
paldo_welcome_page_update_settings (PaldoWelcomePage* self)
{
	GtkTreeIter iter = {0};
	gchar* language_name = NULL;
	gchar* _tmp0_;
	GtkComboBox* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
	GtkComboBox* _tmp8_;
	GtkTreeIter _tmp9_ = {0};
	gboolean _tmp10_;
	PaldoInstallerSettings* _tmp20_;
	const gchar* _tmp21_;
	GtkComboBox* _tmp22_;
	GtkTreeIter _tmp23_ = {0};
	gboolean _tmp24_;
	GtkComboBox* _tmp35_;
	GtkTreeIter _tmp36_ = {0};
	gboolean _tmp37_;
	PaldoInstallerSettings* _tmp44_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (_ ("Unknown"));
	language_name = _tmp0_;
	_tmp1_ = self->priv->language_combobox;
	_tmp3_ = gtk_combo_box_get_active_iter (_tmp1_, &_tmp2_);
	iter = _tmp2_;
	if (_tmp3_) {
		gchar* language = NULL;
		GtkListStore* _tmp4_;
		GtkTreeIter _tmp5_;
		PaldoInstallerSettings* _tmp6_;
		const gchar* _tmp7_;
		_tmp4_ = self->priv->language_model;
		_tmp5_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp4_, &_tmp5_, 0, &language, 1, &language_name, -1, -1);
		_tmp6_ = self->priv->_settings;
		_tmp7_ = language;
		paldo_installer_settings_set_language (_tmp6_, _tmp7_);
		_g_free0 (language);
	}
	_tmp8_ = self->priv->country_combobox;
	_tmp10_ = gtk_combo_box_get_active_iter (_tmp8_, &_tmp9_);
	iter = _tmp9_;
	if (_tmp10_) {
		gchar* country = NULL;
		gchar* country_name = NULL;
		GtkTreeModelFilter* _tmp11_;
		GtkTreeIter _tmp12_;
		PaldoInstallerSettings* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp11_ = self->priv->country_filter;
		_tmp12_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp11_, &_tmp12_, 0, &country, 1, &country_name, -1, -1);
		_tmp13_ = self->priv->_settings;
		_tmp14_ = country;
		paldo_installer_settings_set_country (_tmp13_, _tmp14_);
		_tmp15_ = language_name;
		_tmp16_ = country_name;
		_tmp17_ = g_strdup_printf (" (%s)", _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strconcat (_tmp15_, _tmp18_, NULL);
		_g_free0 (language_name);
		language_name = _tmp19_;
		_g_free0 (_tmp18_);
		_g_free0 (country_name);
		_g_free0 (country);
	}
	_tmp20_ = self->priv->_settings;
	_tmp21_ = language_name;
	paldo_installer_settings_set_language_name (_tmp20_, _tmp21_);
	_tmp22_ = self->priv->kbd_combobox;
	_tmp24_ = gtk_combo_box_get_active_iter (_tmp22_, &_tmp23_);
	iter = _tmp23_;
	if (_tmp24_) {
		gchar* xkblayout = NULL;
		gchar* xkbvariant = NULL;
		gchar* kbd = NULL;
		gchar* keyboard_name = NULL;
		GtkListStore* _tmp25_;
		GtkTreeIter _tmp26_;
		PaldoInstallerSettings* _tmp27_;
		const gchar* _tmp28_;
		PaldoInstallerSettings* _tmp29_;
		const gchar* _tmp30_;
		PaldoInstallerSettings* _tmp31_;
		const gchar* _tmp32_;
		PaldoInstallerSettings* _tmp33_;
		const gchar* _tmp34_;
		_tmp25_ = self->priv->kbd_model;
		_tmp26_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp25_, &_tmp26_, 0, &xkblayout, 1, &xkbvariant, 2, &kbd, 3, &keyboard_name, -1, -1);
		_tmp27_ = self->priv->_settings;
		_tmp28_ = xkblayout;
		paldo_installer_settings_set_xkblayout (_tmp27_, _tmp28_);
		_tmp29_ = self->priv->_settings;
		_tmp30_ = xkbvariant;
		paldo_installer_settings_set_xkbvariant (_tmp29_, _tmp30_);
		_tmp31_ = self->priv->_settings;
		_tmp32_ = kbd;
		paldo_installer_settings_set_kbd (_tmp31_, _tmp32_);
		_tmp33_ = self->priv->_settings;
		_tmp34_ = keyboard_name;
		paldo_installer_settings_set_keyboard_name (_tmp33_, _tmp34_);
		_g_free0 (keyboard_name);
		_g_free0 (kbd);
		_g_free0 (xkbvariant);
		_g_free0 (xkblayout);
	}
	_tmp35_ = self->priv->tz_combobox;
	_tmp37_ = gtk_combo_box_get_active_iter (_tmp35_, &_tmp36_);
	iter = _tmp36_;
	if (_tmp37_) {
		gchar* timezone = NULL;
		gchar* timezone_name = NULL;
		GtkListStore* _tmp38_;
		GtkTreeIter _tmp39_;
		PaldoInstallerSettings* _tmp40_;
		const gchar* _tmp41_;
		PaldoInstallerSettings* _tmp42_;
		const gchar* _tmp43_;
		_tmp38_ = self->priv->tz_model;
		_tmp39_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp38_, &_tmp39_, 0, &timezone, 1, &timezone_name, -1, -1);
		_tmp40_ = self->priv->_settings;
		_tmp41_ = timezone;
		paldo_installer_settings_set_timezone (_tmp40_, _tmp41_);
		_tmp42_ = self->priv->_settings;
		_tmp43_ = timezone_name;
		paldo_installer_settings_set_timezone_name (_tmp42_, _tmp43_);
		_g_free0 (timezone_name);
		_g_free0 (timezone);
	}
	_tmp44_ = self->priv->_settings;
	g_signal_emit_by_name (_tmp44_, "changed");
	_g_free0 (language_name);
}


static void
paldo_welcome_page_add_language (PaldoWelcomePage* self,
                                 const gchar* code,
                                 const gchar* name)
{
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_;
	GHashTable* _tmp4_;
	gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (code != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->language_model;
	gtk_list_store_append (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = self->priv->language_model;
	_tmp3_ = iter;
	gtk_list_store_set (_tmp2_, &_tmp3_, 0, code, 1, name, -1, -1);
	_tmp4_ = self->priv->language_code_table;
	_tmp5_ = g_strdup (code);
	_tmp6_ = self->priv->n_languages;
	g_hash_table_insert (_tmp4_, _tmp5_, (gpointer) ((gintptr) _tmp6_));
	_tmp7_ = self->priv->n_languages;
	self->priv->n_languages = _tmp7_ + 1;
}


static void
paldo_welcome_page_add_country (PaldoWelcomePage* self,
                                const gchar* code,
                                const gchar* name)
{
	GtkTreeIter iter = {0};
	GdkPixbuf* pixbuf = NULL;
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GdkPixbuf* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GdkPixbuf* _tmp7_;
	GdkPixbuf* _tmp8_;
	GdkPixbuf* _tmp9_;
	GtkListStore* _tmp10_;
	GtkTreeIter _tmp11_;
	GdkPixbuf* _tmp12_;
	GHashTable* _tmp13_;
	gchar* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (code != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->country_model;
	gtk_list_store_append (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp3_ = g_utf8_strdown (code, (gssize) -1);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("/usr/share/paldo-installer/images/%s.svg", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gdk_pixbuf_new_from_file_at_size (_tmp6_, 24, 24, &_inner_error_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp2_ = _tmp8_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (pixbuf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp9_ = _tmp2_;
	_tmp2_ = NULL;
	_g_object_unref0 (pixbuf);
	pixbuf = _tmp9_;
	_tmp10_ = self->priv->country_model;
	_tmp11_ = iter;
	_tmp12_ = pixbuf;
	gtk_list_store_set (_tmp10_, &_tmp11_, 0, code, 1, name, 2, _tmp12_, -1, -1);
	_tmp13_ = self->priv->country_code_table;
	_tmp14_ = g_strdup (code);
	_tmp15_ = self->priv->n_countries;
	g_hash_table_insert (_tmp13_, _tmp14_, (gpointer) ((gintptr) _tmp15_));
	_tmp16_ = self->priv->n_countries;
	self->priv->n_countries = _tmp16_ + 1;
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (pixbuf);
}


static gint
paldo_welcome_page_add_keyboard_layout (PaldoWelcomePage* self,
                                        const gchar* xkblayout,
                                        const gchar* xkbvariant,
                                        const gchar* kbd,
                                        const gchar* name)
{
	gint result = 0;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (xkblayout != NULL, 0);
	g_return_val_if_fail (xkbvariant != NULL, 0);
	g_return_val_if_fail (kbd != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = self->priv->kbd_model;
	gtk_list_store_append (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = self->priv->kbd_model;
	_tmp3_ = iter;
	gtk_list_store_set (_tmp2_, &_tmp3_, 0, xkblayout, 1, xkbvariant, 2, kbd, 3, name, -1, -1);
	_tmp4_ = self->priv->n_keyboard_layouts;
	self->priv->n_keyboard_layouts = _tmp4_ + 1;
	result = _tmp4_;
	return result;
}


static gint
paldo_welcome_page_add_time_zone (PaldoWelcomePage* self,
                                  const gchar* code,
                                  const gchar* name)
{
	gint result = 0;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (code != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = self->priv->tz_model;
	gtk_list_store_append (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = self->priv->tz_model;
	_tmp3_ = iter;
	gtk_list_store_set (_tmp2_, &_tmp3_, 0, code, 1, name, -1, -1);
	_tmp4_ = self->priv->n_timezones;
	self->priv->n_timezones = _tmp4_ + 1;
	result = _tmp4_;
	return result;
}


static void
paldo_welcome_page_add_locale (PaldoWelcomePage* self,
                               const gchar* language,
                               const gchar* country,
                               gboolean default_country)
{
	gint l = 0;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	gint c = 0;
	GHashTable* _tmp2_;
	gconstpointer _tmp3_;
	gboolean* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (language != NULL);
	g_return_if_fail (country != NULL);
	_tmp0_ = self->priv->language_code_table;
	_tmp1_ = g_hash_table_lookup (_tmp0_, language);
	l = (gint) ((gintptr) _tmp1_);
	_tmp2_ = self->priv->country_code_table;
	_tmp3_ = g_hash_table_lookup (_tmp2_, country);
	c = (gint) ((gintptr) _tmp3_);
	_tmp4_ = self->priv->language_countries;
	_tmp4__length1 = self->priv->language_countries_length1;
	_tmp5_ = l;
	_tmp6_ = self->priv->n_countries;
	_tmp7_ = c;
	_tmp4_[(_tmp5_ * _tmp6_) + _tmp7_] = TRUE;
	if (default_country) {
		gint* _tmp8_;
		gint _tmp8__length1;
		gint _tmp9_;
		gint _tmp10_;
		_tmp8_ = self->priv->language_default_country;
		_tmp8__length1 = self->priv->language_default_country_length1;
		_tmp9_ = l;
		_tmp10_ = c;
		_tmp8_[_tmp9_] = _tmp10_;
	}
}


PaldoInstallerSettings*
paldo_welcome_page_get_settings (PaldoWelcomePage* self)
{
	PaldoInstallerSettings* result;
	PaldoInstallerSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


void
paldo_welcome_page_set_settings (PaldoWelcomePage* self,
                                 PaldoInstallerSettings* value)
{
	g_return_if_fail (self != NULL);
	if (paldo_welcome_page_get_settings (self) != value) {
		PaldoInstallerSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_settings);
		self->priv->_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, paldo_welcome_page_properties[PALDO_WELCOME_PAGE_SETTINGS_PROPERTY]);
	}
}


static void
paldo_welcome_page_class_init (PaldoWelcomePageClass * klass)
{
	paldo_welcome_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PaldoWelcomePage_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_paldo_welcome_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_paldo_welcome_page_set_property;
	G_OBJECT_CLASS (klass)->finalize = paldo_welcome_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PALDO_WELCOME_PAGE_SETTINGS_PROPERTY, paldo_welcome_page_properties[PALDO_WELCOME_PAGE_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", PALDO_TYPE_INSTALLER_SETTINGS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
paldo_welcome_page_instance_init (PaldoWelcomePage * self)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GDestroyNotify _tmp2_;
	GHashTable* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	GDestroyNotify _tmp6_;
	GHashTable* _tmp7_;
	self->priv = paldo_welcome_page_get_instance_private (self);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_free;
	_tmp3_ = g_hash_table_new_full (_tmp0_, _tmp1_, _tmp2_, NULL);
	self->priv->language_code_table = _tmp3_;
	_tmp4_ = g_str_hash;
	_tmp5_ = g_str_equal;
	_tmp6_ = g_free;
	_tmp7_ = g_hash_table_new_full (_tmp4_, _tmp5_, _tmp6_, NULL);
	self->priv->country_code_table = _tmp7_;
}


static void
paldo_welcome_page_finalize (GObject * obj)
{
	PaldoWelcomePage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PALDO_TYPE_WELCOME_PAGE, PaldoWelcomePage);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->language_model);
	_g_object_unref0 (self->priv->language_combobox);
	_g_object_unref0 (self->priv->country_model);
	_g_object_unref0 (self->priv->country_combobox);
	_g_object_unref0 (self->priv->kbd_model);
	_g_object_unref0 (self->priv->kbd_combobox);
	_g_object_unref0 (self->priv->tz_model);
	_g_object_unref0 (self->priv->tz_combobox);
	_g_object_unref0 (self->priv->country_filter);
	_g_hash_table_unref0 (self->priv->language_code_table);
	_g_hash_table_unref0 (self->priv->country_code_table);
	self->priv->language_countries = (g_free (self->priv->language_countries), NULL);
	self->priv->language_default_country = (g_free (self->priv->language_default_country), NULL);
	G_OBJECT_CLASS (paldo_welcome_page_parent_class)->finalize (obj);
}


GType
paldo_welcome_page_get_type (void)
{
	static volatile gsize paldo_welcome_page_type_id__volatile = 0;
	if (g_once_init_enter (&paldo_welcome_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PaldoWelcomePageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) paldo_welcome_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PaldoWelcomePage), 0, (GInstanceInitFunc) paldo_welcome_page_instance_init, NULL };
		GType paldo_welcome_page_type_id;
		paldo_welcome_page_type_id = g_type_register_static (gtk_vbox_get_type (), "PaldoWelcomePage", &g_define_type_info, 0);
		PaldoWelcomePage_private_offset = g_type_add_instance_private (paldo_welcome_page_type_id, sizeof (PaldoWelcomePagePrivate));
		g_once_init_leave (&paldo_welcome_page_type_id__volatile, paldo_welcome_page_type_id);
	}
	return paldo_welcome_page_type_id__volatile;
}


static void
_vala_paldo_welcome_page_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	PaldoWelcomePage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PALDO_TYPE_WELCOME_PAGE, PaldoWelcomePage);
	switch (property_id) {
		case PALDO_WELCOME_PAGE_SETTINGS_PROPERTY:
		g_value_set_object (value, paldo_welcome_page_get_settings (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_paldo_welcome_page_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	PaldoWelcomePage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PALDO_TYPE_WELCOME_PAGE, PaldoWelcomePage);
	switch (property_id) {
		case PALDO_WELCOME_PAGE_SETTINGS_PROPERTY:
		paldo_welcome_page_set_settings (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



