/*
 * perms.c
 *
 * tool to keep permissions in a Upkg repo proper
 * you need to check/change user/group names here
 * needs to be run SUID root
 *
 * Copyright (C) 2004 Raffaele Sandrini, Jürg Billeter
 *
 * This file is part of Upkg (http://www.upkg.org).
 *
 * Upkg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * Upkg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Upkg; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Authors:
 *   Raffaele Sandrini <rasa at paldo dot org>
 *   Jürg Billeter <juerg at paldo dot org>
 */

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <errno.h>

int main ()
{
	pid_t pid;
	uid_t uid;
	int status;
	switch (pid = fork ())
	{
	case -1:
		printf ("can't fork\n");
		return (-1);
	case 0:
		execlp ("chown", "chown", "-R", "paldo:paldo", "sources", "binaries", NULL);
		printf ("chown execlp failed\n");
		return (-1);
	default:
		wait (&status);
		if (!WIFEXITED (status))
		{
			printf ("chown failed with exit code %i\n", WEXITSTATUS (status));
			return (-1);
		}
	}
	switch (pid = fork ())
	{
	case -1:
		printf ("can't fork\n");
		return (-1);
	case 0:
		execlp ("chown", "chown", "-R", "www-data:www-data", "specs", NULL);
		printf ("chown execlp failed\n");
		return (-1);
	default:
		wait (&status);
		if (!WIFEXITED (status))
		{
			printf ("chown failed with exit code %i\n", WEXITSTATUS (status));
			return (-1);
		}
	}
	switch (pid = fork ())
	{
	case -1:
		printf ("can't fork\n");
		return (-1);
	case 0:
		execlp ("chmod", "chmod", "-R", "ug+rw", "sources", "binaries", "specs", NULL);
		printf ("chmod execlp failed\n");
		return (-1);
	default:
		wait (&status);
		if (!WIFEXITED (status))
		{
			printf ("chmod failed with exit code %i\n", WEXITSTATUS (status));
			return (-1);
		}
	}

	return (0);
}

