<?php
// postbin.php
//
// Enables a http server to receave Upkg binaries
//
// Copyright (C) 2004 Raffaele Sandrini, Jürg Billeter
//
// This file is part of Upkg (http://www.upkg.org).
//
// Upkg is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// as published by the Free Software Foundation.
//
// Upkg is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Upkg; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// Authors:
//   Raffaele Sandrini <rasa at paldo dot org>
//   Jürg Billeter <juerg at paldo dot org>
// usync.php: tool to keep Upkg repositories in sync
// Copyright (C) 2004 Raffaele Sadndrini

// ATTENTION: To run this script you possibly need to increase apache's "Timeout" value.

require_once ('upkg.inc.php');

// configure the log
define_syslog_variables ();
openlog ('postbin.php', LOG_CONS | LOG_PID | LOG_PERROR, LOG_DAEMON);

// we expect a file named 'binary' through POST
// check its md5 sum
if (md5_file ($_FILES['binary']['tmp_name']) != $_GET['md5sum'])
break;

$basename = basename ($_FILES['binary']['name']);

// check if the file doesn't exist allready
if (!file_exists ('binaries/' . $basename))
{
	$targetfile = 'binaries/' . $basename;
	move_uploaded_file ($_FILES['binary']['tmp_name'], $targetfile);
	chgrp ($targetfile, UPKG_GROUP);
	syslog (LOG_INFO, "INFO: got \"$basename\" uploaded -> distributing it");
	
	/* DISABLED: due to connection problems during upload
	// tell all known repos to fetch that new file
	foreach ($GLOBALS['repos'] as $reponame => $repo)
	{
		// do not mirror our own repo
		if ($reponame == THIS_REPO)
			continue;
		if (file_get_contents ($repo . 'usync.php?action=syncbinaries&source=' . THIS_REPO) === false)
			syslog (LOG_WARNING, 'WARNING: Unable to call "'. $repo . '" to sync its binaries');
	}
	*/
}

// close the log
closelog ();
?>
