// Architecture.cs
//
// represents a arch xml file
//
// Copyright (C) 2004-2005 Raffaele Sandrini, Jürg Billeter
//
// This file is part of Upkg (http://www.upkg.org).
//
// Upkg is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// as published by the Free Software Foundation.
//
// Upkg is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Upkg; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// Authors:
//   Raffaele Sandrini <rasa at paldo dot org>
//   Jürg Billeter <juerg at paldo dot org>

using System;
using System.Collections;
using System.Xml;
using System.IO;

namespace Upkg
{
	public class Architecture
	{
		// constructor: find and process most important arch-$ARCH.xml
		protected Architecture (string name)
		{			
			XmlSpecification spec = new XmlSpecification ("arch-" + name + ".xml");

			// Process each branch specification
			foreach (XmlElement branchElement in spec.GetElementsByTagName ("branch"))
			{
				BranchSpecification branch = new BranchSpecification (branchElement, name, null);
				Branches.Add (branch.Name, branch);
			}
		}

		// holds the branch specifications
		public Branches Branches = new Branches ();
		
		public static Architecture GetArchitecture (string name)
		{
			if (!Architectures.ContainsKey (name))
				Architectures[name] = new Architecture (name);

			return ((Architecture) Architectures[name]);
		}
		
		// clear all processed specs
		public static void Flush ()
		{
			Architectures.Clear();
		}
		
		protected static Hashtable Architectures = new Hashtable ();
		
		// retuns an array with all default architectures
		public static string[] DefaultArchitectures = new string[] { "x86", "x86_64" };

		public static bool IsActive (string arch)
		{
			if (Local.Architecture != "" && arch != null && arch != "")
			{
			 	if (Array.IndexOf (arch.Split (' '), Local.Architecture) == -1)
			 		return (false);
			}
			
			return (true);
		}
	}
}
