// ArchiveScript.cs
//
// Processes a scriptType Element wich reside inside a archive element
// Difference is that here a patch command will be invoked differently
//
// Copyright (C) 2004 Raffaele Sandrini, Jürg Billeter
//
// This file is part of Upkg (http://www.upkg.org).
//
// Upkg is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// as published by the Free Software Foundation.
//
// Upkg is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Upkg; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// Authors:
//   Raffaele Sandrini <rasa at paldo dot org>
//   Jürg Billeter <juerg at paldo dot org>

using System;
using System.Collections;
using System.Xml;

namespace Upkg
{
	class ArchiveScript : Script
	{
		protected readonly string SrcDir;
				
		public ArchiveScript (string sourcedir) : base ()
		{
			if (sourcedir == null)
				throw new ArgumentNullException ("sourcedir");
			
			SrcDir = sourcedir;
		}
		
		// override the selection for the correct processor for a given XmlElement
		protected override void CallProcessorForElement (XmlElement command)
		{
			if (command == null)
				throw new ArgumentNullException ("command");
			
			Command c = null;
			
			if (command.Name == "patch")
				c = new PatchCommand (command, SrcDir);
			else
			{
				base.CallProcessorForElement (command);
				// return as the element will be fully handled by the base class (if possible)
				return;
			}
			
			Add (c);
		}
	}
}
