// BashFunction.cs
//
// Represents a bash function definition
//
// Copyright (C) 2005 Raffaele Sandrini, Jürg Billeter
//
// This file is part of Upkg (http://www.upkg.org).
//
// Upkg is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// as published by the Free Software Foundation.
//
// Upkg is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Upkg; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// Authors:
//   Raffaele Sandrini <rasa at paldo dot org>
//   Jürg Billeter <juerg at paldo dot org>

using System;
using System.IO;
using System.Collections;

namespace Upkg
{
	public class BashFunction : BashCommand
	{
		public readonly string Name;

		private readonly BashList list = new BashList ();
		
		public BashFunction (string name) : base ()
		{
			Name = name;
			list.Indent = true;
		}
		
		public void Add (BashCommand command)
		{
			list.Add (command);
		}

		public override void WriteContentTo (BashScriptWriter writer)
		{
			list.WriteTo (writer);
		}
		
		public override void WriteTo (BashScriptWriter writer)
		{
			writer.WriteLine ("function " + Name + " ()");
			writer.WriteLine ("{");

			WriteContentTo (writer);
			
			writer.WriteLine ("}");
		}
	}
}
