// BashList.cs
//
// Represents a bash command list
//
// Copyright (C) 2005 Raffaele Sandrini, Jürg Billeter
//
// This file is part of Upkg (http://www.upkg.org).
//
// Upkg is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// as published by the Free Software Foundation.
//
// Upkg is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Upkg; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// Authors:
//   Raffaele Sandrini <rasa at paldo dot org>
//   Jürg Billeter <juerg at paldo dot org>

using System;
using System.IO;
using System.Collections;

namespace Upkg
{
	class BashList : BashCommand
	{
		private readonly ArrayList commands = new ArrayList ();
		public bool Indent = false;
		public bool Preformatted = false;
		
		public BashList () : base ()
		{
		}
		
		public void Add (BashCommand command)
		{
			commands.Add (command);
		}

		public override void WriteContentTo (BashScriptWriter writer)
		{
			foreach (BashCommand cmd in commands)
				cmd.WriteTo (writer);
		}
		
		public override void WriteTo (BashScriptWriter writer)
		{
			if (Preformatted && Indent)
				throw (new InvalidOperationException ("Either Preformatted or Indent must be false."));
				
			int savedIndent = writer.Indent;

			if (Indent)
				writer.Indent++;
			else if (Preformatted)
				writer.Indent = 0;

			WriteContentTo (writer);
			
			writer.Indent = savedIndent;
		}
	}
}
