// BashScript.cs
//
// Represents a bash script
//
// Copyright (C) 2005 Raffaele Sandrini, Jürg Billeter
//
// This file is part of Upkg (http://www.upkg.org).
//
// Upkg is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// as published by the Free Software Foundation.
//
// Upkg is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Upkg; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// Authors:
//   Raffaele Sandrini <rasa at paldo dot org>
//   Jürg Billeter <juerg at paldo dot org>

using System;
using System.IO;
using System.Collections;

namespace Upkg
{
	class BashScript : BashCommand
	{
		private readonly BashList List = new BashList ();
		
		public BashScript () : base ()
		{
			List.Add (new BashCommand ("#!/bin/bash"));
		}
		
		public void Add (BashCommand command)
		{
			List.Add (command);
		}

		public override void WriteContentTo (BashScriptWriter writer)
		{
			List.WriteTo (writer);
		}
		
		public override void WriteTo (BashScriptWriter writer)
		{
			WriteContentTo (writer);
		}
	}
}
