// BashScriptWriter.cs
//
// Writes a (proper) bash script
//
// Copyright (C) 2004-2005 Raffaele Sandrini, Jürg Billeter
//
// This file is part of Upkg (http://www.upkg.org).
//
// Upkg is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// as published by the Free Software Foundation.
//
// Upkg is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Upkg; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// Authors:
//   Raffaele Sandrini <rasa at paldo dot org>
//   Jürg Billeter <juerg at paldo dot org>

using System;
using System.IO;
using System.Collections;

namespace Upkg
{
	public class BashScriptWriter : StreamWriter
	{
		// default StreamWriter constructor.
		public BashScriptWriter (Stream stream) : base (stream)
		{
		}
		
		public BashScriptWriter (string file) : base (file)
		{
		}

		public override void WriteLine (string value)
		{
			OutputTabs ();
			base.WriteLine (value);
		}
		
		public virtual void OutputTabs ()
		{
			Write (new String ('\t', Indent));
		}

		// Translate characters not valid in a bash variable
		protected static string EscapeString (string s)
		{
			return (s.Replace ("-", "_").Replace ("+", "_").Replace (".", "_"));
		}
		
		// quote a string to disable any bash interpretation in it
		public static string QuoteString (string s)
		{
			return (s.Replace("\\", "\\\\").Replace("\"", "\\\"").Replace("$", "\\$").Replace("`", "\\`"));
		}

		public int Indent
		{
			get
			{
				return (indent);
			}
			set
			{
				if (value < 0)
					throw (new ArgumentOutOfRangeException ("value"));
				
				indent = value;
			}
		}
		private int indent = 0;
	}
}
