// Branches.cs
//
// Represents a <branches> element
//
// Copyright (C) 2004 Raffaele Sandrini, Jürg Billeter
//
// This file is part of Upkg (http://www.upkg.org).
//
// Upkg is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// as published by the Free Software Foundation.
//
// Upkg is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Upkg; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// Authors:
//   Raffaele Sandrini <rasa at paldo dot org>
//   Jürg Billeter <juerg at paldo dot org>


using System;
using System.Collections;
using System.Xml;
using System.IO;

namespace Upkg
{
	public class Branches : SortedList
	{
		public override void Add (object key, object value)
		{
			if (!(key is string) && !(key is Branch))
				throw (new ArgumentException ("key must be a string or a Branch"));
			if (!(value is Specification))
				throw (new ArgumentException ("value must be a Specification"));
			
			if (key is string)
				base.Add (new Branch (key as string), value);
			else
				base.Add (key, value);
		}
		
		public override object this[object key]
		{
			get
			{
				Specification result;
				if (key is string)
					result = base[new Branch (key as string)] as Specification;
				else
					result = base[key] as Specification;
				// make sure the specification is ready to be used
				result.Process ();

				return (result);
			}
			set
			{
				if (key is string)
					base[new Branch (key as string)] = value;
				else
					base[key] = value;
			}
		}

		public object Current
		{
			get
			{
				// Local.Branch is the unstablest branch we can accept
				Branch branchRequirement = Local.Branch;

				// Go through all candidates
				// we begin with the unstablest branch (as this is a sorted list, we don't have to do anything to achieve that)
				foreach (Branch branch in this.Keys)
				{
					// is the current branch sufficient stable
					if (branch >= branchRequirement)
						return (this[branch]);
				}
				return (null);
			}
		}
	}
}
