// ConfigFile.cs
//
// Represents a <configfile> element
//
// Copyright (C) 2004 Raffaele Sandrini, Jürg Billeter
//
// This file is part of Upkg (http://www.upkg.org).
//
// Upkg is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// as published by the Free Software Foundation.
//
// Upkg is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Upkg; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// Authors:
//   Raffaele Sandrini <rasa at paldo dot org>
//   Jürg Billeter <juerg at paldo dot org>


using System;
using System.Xml;

namespace Upkg
{
	public class ConfigFile
	{
		public readonly ResolvableString Name;
		public readonly ResolvableString Default;
		public readonly ResolvableString Dest;
		public readonly string Mode;
		
		public ConfigFile (XmlElement configFileElement)
		{
			// get the params
			Name = configFileElement.GetAttribute ("name");
			if (Name == "")
				Name = null;
			Dest = configFileElement.GetAttribute ("dest");
			Mode = configFileElement.GetAttribute ("mode");
			if (Mode == "")
				Mode = null;
			Default = configFileElement.GetAttribute ("default");
		}
	}
}
