// DeepFileList.cs
//
// Consists of all _files_ included in a dir and all its subdirs
//
// Copyright (C) 2004 Raffaele Sandrini, Jürg Billeter
//
// This file is part of Upkg (http://www.upkg.org).
//
// Upkg is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// as published by the Free Software Foundation.
//
// Upkg is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Upkg; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// Authors:
//   Raffaele Sandrini <rasa at paldo dot org>
//   Jürg Billeter <juerg at paldo dot org>


using System;
using System.IO;
using System.Collections;

namespace Upkg
{
	public class DeepFileList : SortedList
	{
		public DeepFileList (string[] paths)
		{
			if (paths == null)
				throw (new ArgumentNullException ("path"));
			
			foreach (string path in paths)
			{
				// remove trailing DirectorySeparatorChars	
				InsertAllFiles (path.TrimEnd (new char[] { Path.DirectorySeparatorChar }));
			}
		}
		
		public DeepFileList (string path)
		{
			if (path == null)
				throw (new ArgumentNullException ("path"));
			
			// remove trailing DirectorySeparatorChars	
			InsertAllFiles (path.TrimEnd (new char[] { Path.DirectorySeparatorChar }));
		}
		
		protected void InsertAllFiles (string path)
		{			
			foreach (string file in Directory.GetFiles (path))
			{
				Add (file,null);
			}
			
			foreach (string dir in Directory.GetDirectories (path))
			{
				InsertAllFiles (dir);
			}
		}
	}
}
