// FileList.cs
//
// Processes a FileListType element
//
// Copyright (C) 2004 Raffaele Sandrini, Jürg Billeter
//
// This file is part of Upkg (http://www.upkg.org).
//
// Upkg is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// as published by the Free Software Foundation.
//
// Upkg is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Upkg; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// Authors:
//   Raffaele Sandrini <rasa at paldo dot org>
//   Jürg Billeter <juerg at paldo dot org>


using System;
using System.Collections;
using System.Xml;

namespace Upkg
{
	public class FileList : ArrayList
	{
		// Processes the sources inside a build element
		public void Process (XmlElement fileListElement)
		{
			// check the arguments
			if (fileListElement == null)
				throw new ArgumentNullException("fileListElement");			
					
			// Go through all files
			foreach (XmlNode file in fileListElement.ChildNodes)
			{
				// Check if we have an XmlElement
				if (file.NodeType != XmlNodeType.Element)
					continue;
				
				if (file.Name != "file")
					throw new ApplicationException("FileList: Unknown child '" + file.Name + "' found in fileListType.");
				
				// add the info to the filelist
				Add (new ResolvableString (file.InnerText));
			}
		}
	}
}
