// Global.cs
//
// Process the global.xml file [SINGLETON]
//
// Copyright (C) 2004 Raffaele Sandrini, Jürg Billeter
//
// This file is part of Upkg (http://www.upkg.org).
//
// Upkg is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// as published by the Free Software Foundation.
//
// Upkg is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Upkg; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// Authors:
//   Raffaele Sandrini <rasa at paldo dot org>
//   Jürg Billeter <juerg at paldo dot org>


using System;
using System.Collections;
using System.Xml;
using System.IO;

namespace Upkg
{
	public class Global
	{
		static Global ()
		{
			Init ();
		}

		// find and process most important global.xml
		public static void Init ()
		{
			XmlSpecification spec = new XmlSpecification ("global.xml");

			Branches = new Branches ();
			
			// Process each branch specification
			foreach (XmlElement branchElement in spec.GetElementsByTagName ("branch"))
			{
				BranchSpecification branch = new BranchSpecification (branchElement);
				Branches.Add (branch.Name, branch);
			}

			Compression = ((BranchSpecification)Branches.Current).Settings.Compression;
		}

		// holds the singleton global branch specifications		
		public static Branches Branches;
		
		// returns the most stable branch inside the current toolchain
		public static Branch UpperToolchainBranchBound
		{
			get
			{
				string actual_toolchain = (string)((BranchSpecification)Branches.Current).Settings.Variables["$TOOLCHAIN"];
				Branch other = Local.Branch;
				
				foreach (Branch b in Branches.Keys)
				{
					if (b >= Local.Branch)
					{
						// if we cross the toolchain border, exit the loop
						if ((string) ((BranchSpecification)Branches[b]).Settings.Variables["$TOOLCHAIN"] != actual_toolchain)
							break;

						other = b;
					}
				}
				
				return (other);
			}
		}

		public static string Compression;
	}
}
