// Package.cs
//
// Writes a .dot file for GraphViz
//
// Copyright (C) 2004 Raffaele Sandrini, Jürg Billeter
//
// This file is part of Upkg (http://www.upkg.org).
//
// Upkg is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// as published by the Free Software Foundation.
//
// Upkg is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Upkg; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// Authors:
//   Raffaele Sandrini <rasa at paldo dot org>
//   Jürg Billeter <juerg at paldo dot org>


using System;
using System.IO;

namespace Upkg
{
	public class GraphWriter : StreamWriter
	{
		// default StreamWriter constructor.
		public GraphWriter (string file) : base (file, false)
		{
			// write the header
			WriteLine ("digraph G {");
		}
		
		public void WriteReleaseSpecification (ReleaseSpecification release)
		{
			// Check for non valid parameters
			if (release == null)
				throw new ArgumentNullException ("release");
			
			WriteLine (release.Package.Name.Replace ("-", "").Replace (".", "").Replace ("+", "") + " [label=\"" + release.Package.Name + "\"]");
			
			foreach (ReleaseSpecification dep in release.Deps)
			{
				string edge = release.Package.Name.Replace ("-", "").Replace (".", "").Replace ("+", "") + " -> " + dep.Package.Name.Replace ("-", "").Replace (".", "").Replace ("+", "");
				if (release.BuildScript == null || release.BuildScript.Count == 0)
					edge += " [weight=10]";
				WriteLine (edge + ";");
			}
		}

		public override void Close ()
		{
			WriteLine ("}");
			base.Close();
		}
	}
}
