// ListComparer.cs
//
// Compares two ILists and stores the diffs
//
// Copyright (C) 2004 Raffaele Sandrini, Jürg Billeter
//
// This file is part of Upkg (http://www.upkg.org).
//
// Upkg is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// as published by the Free Software Foundation.
//
// Upkg is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Upkg; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// Authors:
//   Raffaele Sandrini <rasa at paldo dot org>
//   Jürg Billeter <juerg at paldo dot org>


using System;
using System.Collections;


namespace Upkg
{
	public class ListComparer
	{
		// consists of all elements missing in l2 compared to l1
		public readonly ArrayList MissingInL2 = new ArrayList ();
		// consists of all elements missing in l1 compared to l2
		public readonly ArrayList MissingInL1 = new ArrayList ();
		// consists of all elements added in l2 compared to l1
		public ArrayList AdditionalInL2 { get { return (MissingInL1); } }
		// consists of all elements added in l1 compared to l2
		public ArrayList AdditionalInL1 { get { return (MissingInL2); } }
		
		public ListComparer (IList l1, IList l2)
		{
			foreach (object l1_obj in l1)
			{
				if (!l2.Contains (l1_obj))
					MissingInL2.Add (l1_obj);
			}
			
			foreach (object l2_obj in l2)
			{
				if (!l1.Contains (l2_obj))
					MissingInL1.Add (l2_obj);
			}		
		}
	}
}
