// PackageNotFoundException.cs
//
// Represents the error that occurs when a package, a package tag or a package
// release can't be found.
//
// Copyright (C) 2004 Raffaele Sandrini, Jürg Billeter
//
// This file is part of Upkg (http://www.upkg.org).
//
// Upkg is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// as published by the Free Software Foundation.
//
// Upkg is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Upkg; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// Authors:
//   Raffaele Sandrini <rasa at paldo dot org>
//   Jürg Billeter <juerg at paldo dot org>


using System;
using System.Collections;
using System.Xml;
using System.IO;

namespace Upkg
{
	public class PackageNotFoundException : ApplicationException
	{
		public readonly string Package;
		public readonly string Tag;
		public readonly string Branch;
	
		public PackageNotFoundException (string package, string tag, string branch) : base ()
		{
			if (package == null)
				throw (new ArgumentNullException ("package"));
			if (tag == null && branch != null)
				throw (new ArgumentNullException ("tag"));

			Package = package;
			Tag = tag;
			Branch = branch;
		}
		
		public PackageNotFoundException (string package, string tag) : this (package, tag, null)
		{
		}
		
		public PackageNotFoundException (string package) : this (package, null)
		{
		}
		
		public override string Message
		{
			get
			{
				if (Branch != null)
					return ("Release for package '" + Package + "' with tag '" + Tag + "' and branch '" + Branch + "' not found.");
				else if (Tag != null)
					return ("Tag '" + Tag + "' for package '" + Package + "' not found.");
				else
					return ("Package '" + Package + "' not found.");
			}
		}
	}
}
