// Repository.cs
//
// Represents a package repository
//
// Copyright (C) 2004 Raffaele Sandrini, Jürg Billeter
//
// This file is part of Upkg (http://www.upkg.org).
//
// Upkg is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// as published by the Free Software Foundation.
//
// Upkg is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Upkg; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// Authors:
//   Raffaele Sandrini <rasa at paldo dot org>
//   Jürg Billeter <juerg at paldo dot org>

using System;
using System.Collections;
using System.IO;
using System.Net;
using System.Text;
using System.Xml;

namespace Upkg
{
	public class Repository
	{
		public Repository (string url)
		{
			Url = url.TrimEnd ('/');
		}
		
		public readonly string Url;
		
		public bool Remote
		{
			get
			{
				return (Url.StartsWith ("http://") || Url.StartsWith ("https://"));
			}
		}
		
		public Hashtable ModificationTimeTable
		{
			get
			{
				if (modificationTimeTable == null)
				{
					modificationTimeTable = new Hashtable ();
					if (Remote)
					{
						// try to get modification time of package specifications via WebDAV PROPFIND
						try
						{
							HttpWebRequest request = Local.CreateHttpWebRequest (Url + "/specs/");
							request.Method = "PROPFIND";
							request.Headers.Add ("Depth: 1");
							request.KeepAlive = false;
							Stream requestStream = request.GetRequestStream ();
							string webdavxml = "<?xml version=\"1.0\"?><propfind xmlns=\"DAV:\"><prop><getlastmodified xmlns=\"DAV:\"/></prop></propfind>";
							byte[] bytes = Encoding.UTF8.GetBytes (webdavxml);
							requestStream.Write (bytes, 0, bytes.Length);
							requestStream.Close ();
							
							HttpWebResponse response = (HttpWebResponse) request.GetResponse ();
							StreamReader reader = new StreamReader (response.GetResponseStream ());
							XmlDocument doc = new XmlDocument ();
							doc.Load (reader);
							response.Close ();
						
							XmlNodeList nodeList;
							XmlElement element;
							string href, getlastmodified;
							foreach (XmlElement responseElement in doc.GetElementsByTagName ("D:response"))
							{
								nodeList = responseElement.GetElementsByTagName ("D:href");
								if (nodeList == null || nodeList.Count == 0)
									continue;
								element = (XmlElement) nodeList[0];
								href = element.InnerText;

								nodeList = responseElement.GetElementsByTagName ("lp1:getlastmodified");
								if (nodeList == null || nodeList.Count == 0)
									continue;
								element = (XmlElement) nodeList[0];
								getlastmodified = element.InnerText;
								
								modificationTimeTable[href.Substring (href.IndexOf ("specs/"))] = DateTime.Parse (getlastmodified);
							}
						}
						catch (Exception e)
						{
							// ignore any errors as we can use standard http methods as slow fallback
						}
					}
				}
				
				return (modificationTimeTable);
			}
		}
		
		protected Hashtable modificationTimeTable;
	}
}
