// RepositoriesList.cs
//
// Contains all validated repositories
//
// Copyright (C) 2004 Raffaele Sandrini, Jürg Billeter
//
// This file is part of Upkg (http://www.upkg.org).
//
// Upkg is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// as published by the Free Software Foundation.
//
// Upkg is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Upkg; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// Authors:
//   Raffaele Sandrini <rasa at paldo dot org>
//   Jürg Billeter <juerg at paldo dot org>

using System;
using System.Collections;
using System.IO;

namespace Upkg
{
	public class RepositoryList : ArrayList
	{
		public override int Add (object value)
		{
			if (!(value is Repository))
				throw (new ArgumentException ("value must be a Repository"));
			
			Repository repo = (Repository) value;

			if (repo.Remote)
			{
				// we've got a remote repo, do an availability check
				string host = new Uri (repo.Url).Host;
				try
				{
					System.Net.Dns.Resolve (host);
					// FIXME: add a more extensive check to see whether the repo is really available
				}
				catch (System.Net.Sockets.SocketException e)
				{
					// resolve not possible
					Console.Error.WriteLine ("could not resolve {0}, dropping this repository", host);
					return (-1);
				}
			}
			else if (!Directory.Exists (repo.Url))
			{
				Console.Error.WriteLine ("{0} does not exist, dropping this repository", repo.Url);
				return (-1);
			}
						
			return (base.Add (repo));
		}
	}
}
