// SimpleCommand.cs
//
// Holds all information a simple command element has
//
// Copyright (C) 2004 Raffaele Sandrini, Jürg Billeter
//
// This file is part of Upkg (http://www.upkg.org).
//
// Upkg is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// as published by the Free Software Foundation.
//
// Upkg is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Upkg; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// Authors:
//   Raffaele Sandrini <rasa at paldo dot org>
//   Jürg Billeter <juerg at paldo dot org>

using System;
using System.Collections;
using System.Xml;

namespace Upkg
{
	public class SimpleCommand : Command
	{
		// Holds the command
		protected ResolvableString Command;
		// should this command be checked?
		protected bool Check;
		
		// constructor
		public SimpleCommand (ResolvableString command, bool check)
		{
			if (command == null)
				throw new ArgumentNullException ("cmd");
				
			Command = command;
			Check = check;
		}
		
		// create out of a XmlElement
		public SimpleCommand (XmlElement commandtype)
		{
			if (commandtype == null)
				throw new ArgumentNullException ("commandtype");
			
			// Check if we want the command to be checked
			if (commandtype.Attributes.GetNamedItem("check") != null && commandtype.Attributes.GetNamedItem("check").InnerText == "no")
				Check = false;
			else
				Check = true;
			
			Command = commandtype.InnerText;
		}
		
		// shell representation
		public override BashCommand ToBashCommand (bool verbose)
		{
			BashList result = new BashList ();
			string commandString = Command;
			string quotedCommand = BashScriptWriter.QuoteString (commandString);
			if (verbose)
				result.Add (new BashCommand ("echo \" " + (Check ? "[CHECK]" : "[NOCHECK]") + " " + quotedCommand + "\""));
			if (!Check)
				result.Add (new BashCommand (commandString));
			else
				result.Add (new BashCommand (commandString + " || { echo \"*** Error: " + quotedCommand + "\" ; exit 1 ; }"));
				
			return (result);
		}
	}
}
