// Specification.cs
//
// represents a specification as BranchSpecification and ReleaseSpecification
// (that's only part of an xml file)
//
// Copyright (C) 2004-2005 Raffaele Sandrini, Jürg Billeter
//
// This file is part of Upkg (http://www.upkg.org).
//
// Upkg is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// as published by the Free Software Foundation.
//
// Upkg is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Upkg; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// Authors:
//   Raffaele Sandrini <rasa at paldo dot org>
//   Jürg Billeter <juerg at paldo dot org>

using System;
using System.Collections;
using System.Xml;
using System.IO;

namespace Upkg
{
	public abstract class Specification
	{
		// finish processing the specification if not yet done
		// should be able to call this more than once without problems
		public abstract void Process ();

		protected virtual Settings ProcessSettings (BranchSpecification parentSpec)
		{
			if (SpecElement == null)
				throw (new InvalidOperationException ("specElement must not be null."));
			XmlNodeList settingsElements = SpecElement.GetElementsByTagName ("settings");
			
			Settings parentSettings = null;
			if (parentSpec != null)
				parentSettings = parentSpec.Settings;
				
			XmlElement settingsElement = null;
			if (settingsElements.Count > 0)
				settingsElement = (XmlElement) settingsElements[0];
			
			return (new Settings (settingsElement, parentSettings));
		}
		
		protected XmlElement SpecElement;
	}
}
