// XmlTextValidatingReader.cs
//
// Combines (wrapps around) XmlTextReader and XmlValidatingReader
//
// Copyright (C) 2004 Raffaele Sandrini, Jürg Billeter
//
// This file is part of Upkg (http://www.upkg.org).
//
// Upkg is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// as published by the Free Software Foundation.
//
// Upkg is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Upkg; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// Authors:
//   Raffaele Sandrini <rasa at paldo dot org>
//   Jürg Billeter <juerg at paldo dot org>

using System;
using System.Xml;
using System.Xml.Schema;

namespace Upkg
{
	class XmlValidatingTextReader : XmlValidatingReader
	{	
		public XmlValidatingTextReader (string file, string[] schemas) : base(new XmlTextReader(file))
		{
			// Check the parameters
			if (file == null)
				throw new ArgumentNullException("file");
			if (file == "")
				throw new ArgumentException("empty: file");
			
			// Add the schemas
			XmlTextReader schemareader;
			if ((schemas != null) && (schemas.Length > 0))
			{
				// Add each schema
				foreach (string schema in schemas)
				{
					schemareader = new XmlTextReader(schema);
					Schemas.Add(null,schemareader);;
				}
			}
			
			// Till now we had no error
			
			// Add the handle to the event
			//ValidationEventHandler += this.ValidationEventHandle; // WORKAROUND TO FORCE THE EXCEPTION TO COME. Reimplemetning of Read() would possibly be a pritier solution.
		}
		
		public XmlValidatingTextReader (string file, XmlSchema schema) : base (new XmlTextReader (file))
		{
			// Check the parameters
			if (file == null)
				throw new ArgumentNullException("file");
			if (file == "")
				throw new ArgumentException("empty: file");
			
			// Add the schema
			Schemas.Add (schema);
			
			// Till now we had no error
			
			// Add the handle to the event
			//ValidationEventHandler += this.ValidationEventHandle; // WORKAROUND TO FORCE THE EXCEPTION TO COME. Reimplemetning of Read() would possibly be a pritier solution.
		}
		
		// If you want to validate the whole file at once use this method. Do not use it if you want to validate during using the reader
		// If u consider to use Validate() then you have to recreate the Reader after that because it will be "used up" (there is no rewind).
		public void Validate ()
		{
			try
			{				
				// Read the file
				while (Read()) {}
			}
			finally
			{
				// Close the validating reader if it was open
				Close();
			}
		}
		
		// Handler for the ValidationEventHanlder event from XmlValidationReader
		protected void ValidationEventHandle (object sender, ValidationEventArgs e_args)
		{
			// Check the Severity
			if (e_args.Severity == XmlSeverityType.Error)
			{
				Console.Error.WriteLine("FATAL: validation: " + e_args.Message);
			}
			else if (e_args.Severity == XmlSeverityType.Warning) 
				Console.Error.WriteLine("WARNING: validation: " + e_args.Message);
			else
			{
				Console.Error.WriteLine("Unknown validation error: " + e_args.Message);
			}
		}
		
		// internal success
	}
}
