// ManagerWindow.cs
//
// Main window of the Manager
//
// Copyright (C) 2004 Raffaele Sandrini, Jürg Billeter
//
// This file is part of Upkg (http://www.upkg.org).
//
// Upkg is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// as published by the Free Software Foundation.
//
// Upkg is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Upkg; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// Authors:
//   Raffaele Sandrini <rasa at paldo dot org>
//   Jürg Billeter <juerg at paldo dot org>

using System;
using System.Collections;
using System.IO;

using Gtk;

namespace Upkg
{
	class ManagerWindow : Window
	{
		public ManagerWindow () : base ("Upkg Package Manager")
		{
			Toolbar toolbar = new Toolbar ();
			Button deps = new Button ("Dependencies");
			deps.Clicked += OnShowDependencies;
			toolbar.AppendWidget (deps, "Show dependency graph", "Show dependency graph");
			
			Add (toolbar);
		}
		
		public void OnShowDependencies (object sender, EventArgs args)
		{
			/*foreach (string file in Directory.GetFiles ("/home/juerg/Projects/Upkg-local" + "/specs", "*.xml"))
			{
				// exclude global.xml and tag-*.xml
				if (System.IO.Path.GetFileName (file) == "global.xml" || System.IO.Path.GetFileName (file).StartsWith ("tag-"))
					continue;
				
				// create a Package for each xml file
				Package p = Package.GetPackage (System.IO.Path.GetFileName (file.Replace (".xml", "")));
				foreach (Branches branches in p.Tags.Values)
				{
					ReleaseSpecification release = branches.Current as ReleaseSpecification;
				}
			}*/
			// create the root package
			Package rootPackage = Package.GetPackage (Local.RootPackageName);
			// this implicitly processes the root package and all dependent packages
			Branches branches = rootPackage.Tags[Local.RootPackageTag] as Branches;
			ReleaseSpecification rootRelease = branches.Current as ReleaseSpecification;
			
			Graph graph = new Graph ();
			
			foreach (ReleaseSpecification release in ReleaseSpecification.ReleaseList.Values)
			{
				foreach (ReleaseSpecification dep in release.Deps)
				{
					graph.Add (release, dep);
				}
			}
			
			GraphWriter graphWriter = new GraphWriter ("upkg.dot");

			ArrayList list = graph.TopologicalSort ();
			foreach (ReleaseSpecification release in list)
			{
				graphWriter.WriteReleaseSpecification (release);
				//Console.WriteLine (release.UniqueName);
			}
			graphWriter.Close();

			/*GraphWriter graphWriter = new GraphWriter ("upkg.dot");

			// create the root package
			Package rootPackage = Package.GetPackage (Local.RootPackageName);
			// this implicitly processes the root package and all dependent packages
			Branches branches = rootPackage.Tags[Local.RootPackageTag] as Branches;
			ReleaseSpecification rootRelease = branches.Current as ReleaseSpecification;
			
			foreach (ReleaseSpecification release in ReleaseSpecification.ReleaseList.Values)
			{
				graphWriter.WriteReleaseSpecification (release);
			}
			graphWriter.Close();*/
			/*MessageDialog dlg = new MessageDialog (this, DialogFlags.Modal, MessageType.Info, ButtonsType.Ok, "Dependencies");
			dlg.Run ();*/
		}
	}
}
